import{s as cl,n as ol,o as Ml}from"../chunks/scheduler.23542ac5.js";import{S as ul,i as rl,e as p,s as n,c,h as dl,a as i,d as t,b as a,f as U,g as o,j as m,k as Ns,l as h,m as l,n as M,t as u,o as r,p as d}from"../chunks/index.9b1f405b.js";import{C as hl,H as V,E as gl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f1623902.js";import{C as g}from"../chunks/CodeBlock.e697091a.js";import{D as bl}from"../chunks/DocNotebookDropdown.68a629d2.js";function jl(yt){let f,qs,Ys,Ps,Z,Os,v,Ks,_,se,k,Tt="🧨 Diffusers는 사용자 친화적이며 유연한 도구 상자로, 사용사례에 맞게 diffusion 시스템을 구축 할 수 있도록 설계되었습니다. 이 도구 상자의 핵심은 모델과 스케줄러입니다. <code>DiffusionPipeline</code>은 편의를 위해 이러한 구성 요소를 번들로 제공하지만, 파이프라인을 분리하고 모델과 스케줄러를 개별적으로 사용해 새로운 diffusion 시스템을 만들 수도 있습니다.",ee,I,wt="이 튜토리얼에서는 기본 파이프라인부터 시작해 Stable Diffusion 파이프라인까지 진행하며 모델과 스케줄러를 사용해 추론을 위한 diffusion 시스템을 조립하는 방법을 배웁니다.",te,R,le,Q,Ct="파이프라인은 추론을 위해 모델을 실행하는 빠르고 쉬운 방법으로, 이미지를 생성하는 데 코드가 4줄 이상 필요하지 않습니다:",ne,G,ae,T,$t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',pe,x,Vt="정말 쉽습니다. 그런데 파이프라인은 어떻게 이렇게 할 수 있었을까요? 파이프라인을 세분화하여 내부에서 어떤 일이 일어나고 있는지 살펴보겠습니다.",ie,W,Zt="위 예시에서 파이프라인에는 <code>UNet2DModel</code> 모델과 <code>DDPMScheduler</code>가 포함되어 있습니다. 파이프라인은 원하는 출력 크기의 랜덤 노이즈를 받아 모델을 여러번 통과시켜 이미지의 노이즈를 제거합니다. 각 timestep에서 모델은 <em>noise residual</em>을 예측하고 스케줄러는 이를 사용하여 노이즈가 적은 이미지를 예측합니다. 파이프라인은 지정된 추론 스텝수에 도달할 때까지 이 과정을 반복합니다.",me,N,vt="모델과 스케줄러를 별도로 사용하여 파이프라인을 다시 생성하기 위해 자체적인 노이즈 제거 프로세스를 작성해 보겠습니다.",ce,b,E,Es,_t="모델과 스케줄러를 불러옵니다:",ct,X,ot,B,Xs,kt="노이즈 제거 프로세스를 실행할 timestep 수를 설정합니다:",Mt,F,ut,S,Bs,It="스케줄러의 timestep을 설정하면 균등한 간격의 구성 요소를 가진 텐서가 생성됩니다.(이 예시에서는 50개) 각 요소는 모델이 이미지의 노이즈를 제거하는 시간 간격에 해당합니다. 나중에 노이즈 제거 루프를 만들 때 이 텐서를 반복하여 이미지의 노이즈를 제거합니다:",rt,H,dt,L,Fs,Rt="원하는 출력과 같은 모양을 가진 랜덤 노이즈를 생성합니다:",ht,D,gt,J,Ss,Qt="이제 timestep을 반복하는 루프를 작성합니다. 각 timestep에서 모델은 <code>UNet2DModel.forward()</code>를 통해 noisy residual을 반환합니다. 스케줄러의 <code>step()</code> 메서드는 noisy residual, timestep, 그리고 입력을 받아 이전 timestep에서 이미지를 예측합니다. 이 출력은 노이즈 제거 루프의 모델에 대한 다음 입력이 되며, <code>timesteps</code> 배열의 끝에 도달할 때까지 반복됩니다.",bt,z,jt,Hs,Gt="이것이 전체 노이즈 제거 프로세스이며, 동일한 패턴을 사용해 모든 diffusion 시스템을 작성할 수 있습니다.",Ut,Y,Ls,xt="마지막 단계는 노이즈가 제거된 출력을 이미지로 변환하는 것입니다:",ft,A,oe,q,Wt="다음 섹션에서는 여러분의 기술을 시험해보고 좀 더 복잡한 Stable Diffusion 파이프라인을 분석해 보겠습니다. 방법은 거의 동일합니다. 필요한 구성요소들을 초기화하고 timestep수를 설정하여 <code>timestep</code> 배열을 생성합니다. 노이즈 제거 루프에서 <code>timestep</code> 배열이 사용되며, 이 배열의 각 요소에 대해 모델은 노이즈가 적은 이미지를 예측합니다. 노이즈 제거 루프는 <code>timestep</code>을 반복하고 각 timestep에서 noise residual을 출력하고 스케줄러는 이를 사용하여 이전 timestep에서 노이즈가 덜한 이미지를 예측합니다. 이 프로세스는 <code>timestep</code> 배열의 끝에 도달할 때까지 반복됩니다.",Me,P,Nt="한번 사용해 봅시다!",ue,O,re,K,Et="Stable Diffusion 은 text-to-image <em>latent diffusion</em> 모델입니다. latent diffusion 모델이라고 불리는 이유는 실제 픽셀 공간 대신 이미지의 저차원의 표현으로 작업하기 때문이고, 메모리 효율이 더 높습니다. 인코더는 이미지를 더 작은 표현으로 압축하고, 디코더는 압축된 표현을 다시 이미지로 변환합니다. text-to-image 모델의 경우 텍스트 임베딩을 생성하기 위해 tokenizer와 인코더가 필요합니다. 이전 예제에서 이미 UNet 모델과 스케줄러가 필요하다는 것은 알고 계셨을 것입니다.",de,ss,Xt="보시다시피, 이것은 UNet 모델만 포함된 DDPM 파이프라인보다 더 복잡합니다. Stable Diffusion 모델에는 세 개의 개별 사전학습된 모델이 있습니다.",he,w,Bt='<p>💡 VAE, UNet 및 텍스트 인코더 모델의 작동방식에 대한 자세한 내용은 <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> 블로그를 참조하세요.</p>',ge,es,Ft='이제 Stable Diffusion 파이프라인에 필요한 구성요소들이 무엇인지 알았으니, <code>from_pretrained()</code> 메서드를 사용해 모든 구성요소를 불러옵니다. 사전학습된 체크포인트 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>에서 찾을 수 있으며, 각 구성요소들은 별도의 하위 폴더에 저장되어 있습니다:',be,ts,je,ls,St="기본 <code>PNDMScheduler</code> 대신, <code>UniPCMultistepScheduler</code>로 교체하여 다른 스케줄러를 얼마나 쉽게 연결할 수 있는지 확인합니다:",Ue,ns,fe,as,Ht="추론 속도를 높이려면 스케줄러와 달리 학습 가능한 가중치가 있으므로 모델을 GPU로 옮기세요:",Je,ps,ye,is,Te,ms,Lt="다음 단계는 임베딩을 생성하기 위해 텍스트를 토큰화하는 것입니다. 이 텍스트는 UNet 모델에서 condition으로 사용되고 입력 프롬프트와 유사한 방향으로 diffusion 프로세스를 조정하는 데 사용됩니다.",we,C,Dt="<p>💡 <code>guidance_scale</code> 매개변수는 이미지를 생성할 때 프롬프트에 얼마나 많은 가중치를 부여할지 결정합니다.</p>",Ce,cs,zt="다른 프롬프트를 생성하고 싶다면 원하는 프롬프트를 자유롭게 선택하세요!",$e,os,Ve,Ms,Yt="텍스트를 토큰화하고 프롬프트에서 임베딩을 생성합니다:",Ze,us,ve,rs,At="또한 패딩 토큰의 임베딩인 <em>unconditional 텍스트 임베딩</em>을 생성해야 합니다. 이 임베딩은 조건부 <code>text_embeddings</code>과 동일한 shape(<code>batch_size</code> 그리고 <code>seq_length</code>)을 가져야 합니다:",_e,ds,ke,hs,qt="두번의 forward pass를 피하기 위해 conditional 임베딩과 unconditional 임베딩을 배치(batch)로 연결하겠습니다:",Ie,gs,Re,bs,Qe,js,Pt="그다음 diffusion 프로세스의 시작점으로 초기 랜덤 노이즈를 생성합니다. 이것이 이미지의 잠재적 표현이며 점차적으로 노이즈가 제거됩니다. 이 시점에서 <code>latent</code> 이미지는 최종 이미지 크기보다 작지만 나중에 모델이 이를 512x512 이미지 크기로 변환하므로 괜찮습니다.",Ge,y,Ds,Ot="💡 <code>vae</code> 모델에는 3개의 다운 샘플링 레이어가 있기 때문에 높이와 너비가 8로 나뉩니다. 다음을 실행하여 확인할 수 있습니다:",Jt,Us,xe,fs,We,Js,Ne,ys,Kt="먼저 <code>UniPCMultistepScheduler</code>와 같은 향상된 스케줄러에 필요한 노이즈 스케일 값인 초기 노이즈 분포 <em>sigma</em> 로 입력을 스케일링 하는 것부터 시작합니다:",Ee,Ts,Xe,ws,sl="마지막 단계는 <code>latent</code>의 순수한 노이즈를 점진적으로 프롬프트에 설명된 이미지로 변환하는 노이즈 제거 루프를 생성하는 것입니다. 노이즈 제거 루프는 세 가지 작업을 수행해야 한다는 점을 기억하세요:",Be,Cs,el="<li>노이즈 제거 중에 사용할 스케줄러의 timesteps를 설정합니다.</li> <li>timestep을 따라 반복합니다.</li> <li>각 timestep에서 UNet 모델을 호출하여 noise residual을 예측하고 스케줄러에 전달하여 이전 노이즈 샘플을 계산합니다.</li>",Fe,$s,Se,Vs,He,Zs,tl="마지막 단계는 <code>vae</code>를 이용하여 잠재 표현을 이미지로 디코딩하고 <code>sample</code>과 함께 디코딩된 출력을 얻는 것입니다:",Le,vs,De,_s,ll="마지막으로 이미지를 <code>PIL.Image</code>로 변환하면 생성된 이미지를 확인할 수 있습니다!",ze,ks,Ye,$,nl='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',Ae,Is,qe,Rs,al="기본 파이프라인부터 복잡한 파이프라인까지, 자신만의 diffusion 시스템을 작성하는 데 필요한 것은 노이즈 제거 루프뿐이라는 것을 알 수 있었습니다. 이 루프는 스케줄러의 timesteps를 설정하고, 이를 반복하며, UNet 모델을 호출하여 noise residual을 예측하고 스케줄러에 전달하여 이전 노이즈 샘플을 계산하는 과정을 번갈아 가며 수행해야 합니다.",Pe,Qs,pl="이것이 바로 🧨 Diffusers가 설계된 목적입니다: 모델과 스케줄러를 사용해 자신만의 diffusion 시스템을 직관적이고 쉽게 작성할 수 있도록 하기 위해서입니다.",Oe,Gs,il="다음 단계를 자유롭게 진행하세요:",Ke,xs,ml='<li>🧨 Diffusers에 <a href="using-diffusers/#contribute_pipeline">파이프라인 구축 및 기여</a>하는 방법을 알아보세요. 여러분이 어떤 아이디어를 내놓을지 기대됩니다!</li> <li>라이브러리에서 <a href="./api/pipelines/overview">기본 파이프라인</a>을 살펴보고, 모델과 스케줄러를 별도로 사용하여 파이프라인을 처음부터 해체하고 빌드할 수 있는지 확인해 보세요.</li>',st,Ws,et,As,tt;return Z=new hl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new bl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/write_own_pipeline.ipynb"}]}}),_=new V({props:{title:"파이프라인, 모델 및 스케줄러 이해하기",local:"파이프라인-모델-및-스케줄러-이해하기",headingTag:"h1"}}),R=new V({props:{title:"기본 파이프라인 해체하기",local:"기본-파이프라인-해체하기",headingTag:"h2"}}),G=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMikudG8oJTIyY3VkYSUyMiklMEFpbWFnZSUyMCUzRCUyMGRkcG0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),X=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),F=new g({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)',wrap:!1}}),H=new g({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`,wrap:!1}}),D=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),z=new g({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`,wrap:!1}}),A=new g({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSklMEFpbWFnZSUyMCUzRCUyMGltYWdlLmNwdSgpLnBlcm11dGUoMCUyQyUyMDIlMkMlMjAzJTJDJTIwMSkubnVtcHkoKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheSgoaW1hZ2UlMjAqJTIwMjU1KS5yb3VuZCgpLmFzdHlwZSglMjJ1aW50OCUyMikpJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).numpy()[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray((image * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),O=new V({props:{title:"Stable Diffusion 파이프라인 해체하기",local:"stable-diffusion-파이프라인-해체하기",headingTag:"h2"}}),ts=new g({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQ0xJUFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRva2VuaXplciUyMiklMEF0ZXh0X2VuY29kZXIlMjAlM0QlMjBDTElQVGV4dE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),ns=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),ps=new g({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`,wrap:!1}}),is=new V({props:{title:"텍스트 임베딩 생성하기",local:"텍스트-임베딩-생성하기",headingTag:"h3"}}),os=new g({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwU3RhYmxlJTIwRGlmZnVzaW9uJUVDJTlEJTk4JTIwJUVBJUI4JUIwJUVCJUIzJUI4JTIwJUVCJTg2JTkyJUVDJTlEJUI0JTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBTdGFibGUlMjBEaWZmdXNpb24lRUMlOUQlOTglMjAlRUElQjglQjAlRUIlQjMlQjglMjAlRUIlODQlODglRUIlQjklODQlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjUlMjAlMjAlMjMlMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglMjAlRUMlQTAlOUMlRUElQjElQjAlMjAlRUMlOEElQTQlRUQlODUlOUQlMjAlRUMlODglOTglMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMGNsYXNzaWZpZXItZnJlZSUyMGd1aWRhbmNlJUVCJUE1JUJDJTIwJUVDJTlDJTg0JUVEJTk1JTlDJTIwc2NhbGUlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMCVFQyVCNCU4OCVFQSVCOCVCMCUyMCVFQyU5RSVBMCVFQyU5RSVBQyUyMCVFQiU4NSVCOCVFQyU5RCVCNCVFQyVBNiU4OCVFQiVBNSVCQyUyMCVFQyU4MyU5RCVFQyU4NCVCMSVFRCU5NSU5OCVFQiU4QSU5NCUyMHNlZWQlMjBnZW5lcmF0b3IlMEFiYXRjaF9zaXplJTIwJTNEJTIwbGVuKHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># Stable Diffusion의 기본 높이</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># Stable Diffusion의 기본 너비</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># 노이즈 제거 스텝 수</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># classifier-free guidance를 위한 scale</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># 초기 잠재 노이즈를 생성하는 seed generator</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`,wrap:!1}}),us=new g({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),ds=new g({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),gs=new g({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])',wrap:!1}}),bs=new V({props:{title:"랜덤 노이즈 생성",local:"랜덤-노이즈-생성",headingTag:"h3"}}),Us=new g({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>',wrap:!1}}),fs=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Js=new V({props:{title:"이미지 노이즈 제거",local:"이미지-노이즈-제거",headingTag:"h3"}}),Ts=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma',wrap:!1}}),$s=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBjbGFzc2lmaWVyLWZyZWUlMjBndWlkYW5jZSVFQiVBNSVCQyUyMCVFQyU4OCU5OCVFRCU5NiU4OSVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQSVCMiVCRCVFQyU5QSVCMCUyMCVFQiU5MSU5MCVFQiVCMiU4OCVFQyU5RCU5OCUyMGZvcndhcmQlMjBwYXNzJUVCJUE1JUJDJTIwJUVDJTg4JTk4JUVEJTk2JTg5JUVEJTk1JTk4JUVDJUE3JTgwJTIwJUVDJTk1JThBJUVCJThGJTg0JUVCJUExJTlEJTIwbGF0ZW50JUVCJUE1JUJDJTIwJUVEJTk5JTk1JUVDJTlFJUE1LiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBub2lzZSUyMHJlc2lkdWFsJTIwJUVDJTk4JTg4JUVDJUI4JUExJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMjAlM0QlMjB1bmV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMlM0R0ZXh0X2VtYmVkZGluZ3MpLnNhbXBsZSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGd1aWRhbmNlJTIwJUVDJTg4JTk4JUVEJTk2JTg5JTBBJTIwJTIwJTIwJTIwbm9pc2VfcHJlZF91bmNvbmQlMkMlMjBub2lzZV9wcmVkX3RleHQlMjAlM0QlMjBub2lzZV9wcmVkLmNodW5rKDIpJTBBJTIwJTIwJTIwJTIwbm9pc2VfcHJlZCUyMCUzRCUyMG5vaXNlX3ByZWRfdW5jb25kJTIwJTJCJTIwZ3VpZGFuY2Vfc2NhbGUlMjAqJTIwKG5vaXNlX3ByZWRfdGV4dCUyMC0lMjBub2lzZV9wcmVkX3VuY29uZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRUMlOUQlQjQlRUMlQTAlODQlMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglMjAlRUMlODMlOTglRUQlOTQlOEMlRUMlOUQlODQlMjAlRUElQjMlODQlRUMlODIlQjAlMjB4X3QlMjAtJTNFJTIweF90LTElMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwc2NoZWR1bGVyLnN0ZXAobm9pc2VfcHJlZCUyQyUyMHQlMkMlMjBsYXRlbnRzKS5wcmV2X3NhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># classifier-free guidance를 수행하는 경우 두번의 forward pass를 수행하지 않도록 latent를 확장.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># noise residual 예측</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># guidance 수행</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 이전 노이즈 샘플을 계산 x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`,wrap:!1}}),Vs=new V({props:{title:"이미지 디코딩",local:"이미지-디코딩",headingTag:"h3"}}),vs=new g({props:{code:"JTIzJTIwbGF0ZW50JUVCJUE1JUJDJTIwJUVDJThBJUE0JUVDJUJDJTgwJUVDJTlEJUJDJUVCJUE3JTgxJUVEJTk1JTk4JUVBJUIzJUEwJTIwdmFlJUVCJUExJTlDJTIwJUVDJTlEJUI0JUVCJUFGJUI4JUVDJUE3JTgwJTIwJUVCJTk0JTk0JUVDJUJEJTk0JUVCJTk0JUE5JTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># latent를 스케일링하고 vae로 이미지 디코딩</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`,wrap:!1}}),ks=new g({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSklMEFpbWFnZSUyMCUzRCUyMGltYWdlLmRldGFjaCgpLmNwdSgpLnBlcm11dGUoMCUyQyUyMDIlMkMlMjAzJTJDJTIwMSkubnVtcHkoKSUwQWltYWdlcyUyMCUzRCUyMChpbWFnZSUyMColMjAyNTUpLnJvdW5kKCkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUwQXBpbF9pbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5mcm9tYXJyYXkoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGltYWdlcyU1RCUwQXBpbF9pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.detach().cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>images = (image * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pil_images = [Image.fromarray(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">&gt;&gt;&gt; </span>pil_images[<span class="hljs-number">0</span>]`,wrap:!1}}),Is=new V({props:{title:"다음 단계",local:"다음-단계",headingTag:"h2"}}),Ws=new gl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/using-diffusers/write_own_pipeline.md"}}),{c(){f=p("meta"),qs=n(),Ys=p("p"),Ps=n(),c(Z.$$.fragment),Os=n(),c(v.$$.fragment),Ks=n(),c(_.$$.fragment),se=n(),k=p("p"),k.innerHTML=Tt,ee=n(),I=p("p"),I.textContent=wt,te=n(),c(R.$$.fragment),le=n(),Q=p("p"),Q.textContent=Ct,ne=n(),c(G.$$.fragment),ae=n(),T=p("div"),T.innerHTML=$t,pe=n(),x=p("p"),x.textContent=Vt,ie=n(),W=p("p"),W.innerHTML=Zt,me=n(),N=p("p"),N.textContent=vt,ce=n(),b=p("ol"),E=p("li"),Es=p("p"),Es.textContent=_t,ct=n(),c(X.$$.fragment),ot=n(),B=p("li"),Xs=p("p"),Xs.textContent=kt,Mt=n(),c(F.$$.fragment),ut=n(),S=p("li"),Bs=p("p"),Bs.textContent=It,rt=n(),c(H.$$.fragment),dt=n(),L=p("li"),Fs=p("p"),Fs.textContent=Rt,ht=n(),c(D.$$.fragment),gt=n(),J=p("li"),Ss=p("p"),Ss.innerHTML=Qt,bt=n(),c(z.$$.fragment),jt=n(),Hs=p("p"),Hs.textContent=Gt,Ut=n(),Y=p("li"),Ls=p("p"),Ls.textContent=xt,ft=n(),c(A.$$.fragment),oe=n(),q=p("p"),q.innerHTML=Wt,Me=n(),P=p("p"),P.textContent=Nt,ue=n(),c(O.$$.fragment),re=n(),K=p("p"),K.innerHTML=Et,de=n(),ss=p("p"),ss.textContent=Xt,he=n(),w=p("blockquote"),w.innerHTML=Bt,ge=n(),es=p("p"),es.innerHTML=Ft,be=n(),c(ts.$$.fragment),je=n(),ls=p("p"),ls.innerHTML=St,Ue=n(),c(ns.$$.fragment),fe=n(),as=p("p"),as.textContent=Ht,Je=n(),c(ps.$$.fragment),ye=n(),c(is.$$.fragment),Te=n(),ms=p("p"),ms.textContent=Lt,we=n(),C=p("blockquote"),C.innerHTML=Dt,Ce=n(),cs=p("p"),cs.textContent=zt,$e=n(),c(os.$$.fragment),Ve=n(),Ms=p("p"),Ms.textContent=Yt,Ze=n(),c(us.$$.fragment),ve=n(),rs=p("p"),rs.innerHTML=At,_e=n(),c(ds.$$.fragment),ke=n(),hs=p("p"),hs.textContent=qt,Ie=n(),c(gs.$$.fragment),Re=n(),c(bs.$$.fragment),Qe=n(),js=p("p"),js.innerHTML=Pt,Ge=n(),y=p("blockquote"),Ds=p("p"),Ds.innerHTML=Ot,Jt=n(),c(Us.$$.fragment),xe=n(),c(fs.$$.fragment),We=n(),c(Js.$$.fragment),Ne=n(),ys=p("p"),ys.innerHTML=Kt,Ee=n(),c(Ts.$$.fragment),Xe=n(),ws=p("p"),ws.innerHTML=sl,Be=n(),Cs=p("ol"),Cs.innerHTML=el,Fe=n(),c($s.$$.fragment),Se=n(),c(Vs.$$.fragment),He=n(),Zs=p("p"),Zs.innerHTML=tl,Le=n(),c(vs.$$.fragment),De=n(),_s=p("p"),_s.innerHTML=ll,ze=n(),c(ks.$$.fragment),Ye=n(),$=p("div"),$.innerHTML=nl,Ae=n(),c(Is.$$.fragment),qe=n(),Rs=p("p"),Rs.textContent=al,Pe=n(),Qs=p("p"),Qs.textContent=pl,Oe=n(),Gs=p("p"),Gs.textContent=il,Ke=n(),xs=p("ul"),xs.innerHTML=ml,st=n(),c(Ws.$$.fragment),et=n(),As=p("p"),this.h()},l(s){const e=dl("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(t),qs=a(s),Ys=i(s,"P",{}),U(Ys).forEach(t),Ps=a(s),o(Z.$$.fragment,s),Os=a(s),o(v.$$.fragment,s),Ks=a(s),o(_.$$.fragment,s),se=a(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1w08vjm"&&(k.innerHTML=Tt),ee=a(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1rh2wvk"&&(I.textContent=wt),te=a(s),o(R.$$.fragment,s),le=a(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1ejhv0l"&&(Q.textContent=Ct),ne=a(s),o(G.$$.fragment,s),ae=a(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-ej6f4c"&&(T.innerHTML=$t),pe=a(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1l346u9"&&(x.textContent=Vt),ie=a(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-abj3gw"&&(W.innerHTML=Zt),me=a(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-dgd067"&&(N.textContent=vt),ce=a(s),b=i(s,"OL",{});var j=U(b);E=i(j,"LI",{});var lt=U(E);Es=i(lt,"P",{"data-svelte-h":!0}),m(Es)!=="svelte-j1r62h"&&(Es.textContent=_t),ct=a(lt),o(X.$$.fragment,lt),lt.forEach(t),ot=a(j),B=i(j,"LI",{});var nt=U(B);Xs=i(nt,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-khbsw8"&&(Xs.textContent=kt),Mt=a(nt),o(F.$$.fragment,nt),nt.forEach(t),ut=a(j),S=i(j,"LI",{});var at=U(S);Bs=i(at,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-yj8dtl"&&(Bs.textContent=It),rt=a(at),o(H.$$.fragment,at),at.forEach(t),dt=a(j),L=i(j,"LI",{});var pt=U(L);Fs=i(pt,"P",{"data-svelte-h":!0}),m(Fs)!=="svelte-1mx5t16"&&(Fs.textContent=Rt),ht=a(pt),o(D.$$.fragment,pt),pt.forEach(t),gt=a(j),J=i(j,"LI",{});var zs=U(J);Ss=i(zs,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-1dcn1b9"&&(Ss.innerHTML=Qt),bt=a(zs),o(z.$$.fragment,zs),jt=a(zs),Hs=i(zs,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-x05lv9"&&(Hs.textContent=Gt),zs.forEach(t),Ut=a(j),Y=i(j,"LI",{});var it=U(Y);Ls=i(it,"P",{"data-svelte-h":!0}),m(Ls)!=="svelte-1plitwm"&&(Ls.textContent=xt),ft=a(it),o(A.$$.fragment,it),it.forEach(t),j.forEach(t),oe=a(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1lzspna"&&(q.innerHTML=Wt),Me=a(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-5z3iwd"&&(P.textContent=Nt),ue=a(s),o(O.$$.fragment,s),re=a(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-cnatu9"&&(K.innerHTML=Et),de=a(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-1qnf9z2"&&(ss.textContent=Xt),he=a(s),w=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-1x7lfaf"&&(w.innerHTML=Bt),ge=a(s),es=i(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-xdwsf8"&&(es.innerHTML=Ft),be=a(s),o(ts.$$.fragment,s),je=a(s),ls=i(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-angdpe"&&(ls.innerHTML=St),Ue=a(s),o(ns.$$.fragment,s),fe=a(s),as=i(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-xe2wp7"&&(as.textContent=Ht),Je=a(s),o(ps.$$.fragment,s),ye=a(s),o(is.$$.fragment,s),Te=a(s),ms=i(s,"P",{"data-svelte-h":!0}),m(ms)!=="svelte-nswq27"&&(ms.textContent=Lt),we=a(s),C=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(C)!=="svelte-1jen626"&&(C.innerHTML=Dt),Ce=a(s),cs=i(s,"P",{"data-svelte-h":!0}),m(cs)!=="svelte-193i9if"&&(cs.textContent=zt),$e=a(s),o(os.$$.fragment,s),Ve=a(s),Ms=i(s,"P",{"data-svelte-h":!0}),m(Ms)!=="svelte-v5k7o5"&&(Ms.textContent=Yt),Ze=a(s),o(us.$$.fragment,s),ve=a(s),rs=i(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-1nerc8v"&&(rs.innerHTML=At),_e=a(s),o(ds.$$.fragment,s),ke=a(s),hs=i(s,"P",{"data-svelte-h":!0}),m(hs)!=="svelte-iqpjwl"&&(hs.textContent=qt),Ie=a(s),o(gs.$$.fragment,s),Re=a(s),o(bs.$$.fragment,s),Qe=a(s),js=i(s,"P",{"data-svelte-h":!0}),m(js)!=="svelte-b5xa4e"&&(js.innerHTML=Pt),Ge=a(s),y=i(s,"BLOCKQUOTE",{class:!0});var mt=U(y);Ds=i(mt,"P",{"data-svelte-h":!0}),m(Ds)!=="svelte-132csr5"&&(Ds.innerHTML=Ot),Jt=a(mt),o(Us.$$.fragment,mt),mt.forEach(t),xe=a(s),o(fs.$$.fragment,s),We=a(s),o(Js.$$.fragment,s),Ne=a(s),ys=i(s,"P",{"data-svelte-h":!0}),m(ys)!=="svelte-1xr7g73"&&(ys.innerHTML=Kt),Ee=a(s),o(Ts.$$.fragment,s),Xe=a(s),ws=i(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-4n9fvy"&&(ws.innerHTML=sl),Be=a(s),Cs=i(s,"OL",{"data-svelte-h":!0}),m(Cs)!=="svelte-iivnel"&&(Cs.innerHTML=el),Fe=a(s),o($s.$$.fragment,s),Se=a(s),o(Vs.$$.fragment,s),He=a(s),Zs=i(s,"P",{"data-svelte-h":!0}),m(Zs)!=="svelte-12g4hh4"&&(Zs.innerHTML=tl),Le=a(s),o(vs.$$.fragment,s),De=a(s),_s=i(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-1bjoomr"&&(_s.innerHTML=ll),ze=a(s),o(ks.$$.fragment,s),Ye=a(s),$=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m($)!=="svelte-1b0w6va"&&($.innerHTML=nl),Ae=a(s),o(Is.$$.fragment,s),qe=a(s),Rs=i(s,"P",{"data-svelte-h":!0}),m(Rs)!=="svelte-nwx4ql"&&(Rs.textContent=al),Pe=a(s),Qs=i(s,"P",{"data-svelte-h":!0}),m(Qs)!=="svelte-g0p09q"&&(Qs.textContent=pl),Oe=a(s),Gs=i(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-qg73l2"&&(Gs.textContent=il),Ke=a(s),xs=i(s,"UL",{"data-svelte-h":!0}),m(xs)!=="svelte-y3g0al"&&(xs.innerHTML=ml),st=a(s),o(Ws.$$.fragment,s),et=a(s),As=i(s,"P",{}),U(As).forEach(t),this.h()},h(){Ns(f,"name","hf:doc:metadata"),Ns(f,"content",Ul),Ns(T,"class","flex justify-center"),Ns(w,"class","tip"),Ns(C,"class","tip"),Ns(y,"class","tip"),Ns($,"class","flex justify-center")},m(s,e){h(document.head,f),l(s,qs,e),l(s,Ys,e),l(s,Ps,e),M(Z,s,e),l(s,Os,e),M(v,s,e),l(s,Ks,e),M(_,s,e),l(s,se,e),l(s,k,e),l(s,ee,e),l(s,I,e),l(s,te,e),M(R,s,e),l(s,le,e),l(s,Q,e),l(s,ne,e),M(G,s,e),l(s,ae,e),l(s,T,e),l(s,pe,e),l(s,x,e),l(s,ie,e),l(s,W,e),l(s,me,e),l(s,N,e),l(s,ce,e),l(s,b,e),h(b,E),h(E,Es),h(E,ct),M(X,E,null),h(b,ot),h(b,B),h(B,Xs),h(B,Mt),M(F,B,null),h(b,ut),h(b,S),h(S,Bs),h(S,rt),M(H,S,null),h(b,dt),h(b,L),h(L,Fs),h(L,ht),M(D,L,null),h(b,gt),h(b,J),h(J,Ss),h(J,bt),M(z,J,null),h(J,jt),h(J,Hs),h(b,Ut),h(b,Y),h(Y,Ls),h(Y,ft),M(A,Y,null),l(s,oe,e),l(s,q,e),l(s,Me,e),l(s,P,e),l(s,ue,e),M(O,s,e),l(s,re,e),l(s,K,e),l(s,de,e),l(s,ss,e),l(s,he,e),l(s,w,e),l(s,ge,e),l(s,es,e),l(s,be,e),M(ts,s,e),l(s,je,e),l(s,ls,e),l(s,Ue,e),M(ns,s,e),l(s,fe,e),l(s,as,e),l(s,Je,e),M(ps,s,e),l(s,ye,e),M(is,s,e),l(s,Te,e),l(s,ms,e),l(s,we,e),l(s,C,e),l(s,Ce,e),l(s,cs,e),l(s,$e,e),M(os,s,e),l(s,Ve,e),l(s,Ms,e),l(s,Ze,e),M(us,s,e),l(s,ve,e),l(s,rs,e),l(s,_e,e),M(ds,s,e),l(s,ke,e),l(s,hs,e),l(s,Ie,e),M(gs,s,e),l(s,Re,e),M(bs,s,e),l(s,Qe,e),l(s,js,e),l(s,Ge,e),l(s,y,e),h(y,Ds),h(y,Jt),M(Us,y,null),l(s,xe,e),M(fs,s,e),l(s,We,e),M(Js,s,e),l(s,Ne,e),l(s,ys,e),l(s,Ee,e),M(Ts,s,e),l(s,Xe,e),l(s,ws,e),l(s,Be,e),l(s,Cs,e),l(s,Fe,e),M($s,s,e),l(s,Se,e),M(Vs,s,e),l(s,He,e),l(s,Zs,e),l(s,Le,e),M(vs,s,e),l(s,De,e),l(s,_s,e),l(s,ze,e),M(ks,s,e),l(s,Ye,e),l(s,$,e),l(s,Ae,e),M(Is,s,e),l(s,qe,e),l(s,Rs,e),l(s,Pe,e),l(s,Qs,e),l(s,Oe,e),l(s,Gs,e),l(s,Ke,e),l(s,xs,e),l(s,st,e),M(Ws,s,e),l(s,et,e),l(s,As,e),tt=!0},p:ol,i(s){tt||(u(Z.$$.fragment,s),u(v.$$.fragment,s),u(_.$$.fragment,s),u(R.$$.fragment,s),u(G.$$.fragment,s),u(X.$$.fragment,s),u(F.$$.fragment,s),u(H.$$.fragment,s),u(D.$$.fragment,s),u(z.$$.fragment,s),u(A.$$.fragment,s),u(O.$$.fragment,s),u(ts.$$.fragment,s),u(ns.$$.fragment,s),u(ps.$$.fragment,s),u(is.$$.fragment,s),u(os.$$.fragment,s),u(us.$$.fragment,s),u(ds.$$.fragment,s),u(gs.$$.fragment,s),u(bs.$$.fragment,s),u(Us.$$.fragment,s),u(fs.$$.fragment,s),u(Js.$$.fragment,s),u(Ts.$$.fragment,s),u($s.$$.fragment,s),u(Vs.$$.fragment,s),u(vs.$$.fragment,s),u(ks.$$.fragment,s),u(Is.$$.fragment,s),u(Ws.$$.fragment,s),tt=!0)},o(s){r(Z.$$.fragment,s),r(v.$$.fragment,s),r(_.$$.fragment,s),r(R.$$.fragment,s),r(G.$$.fragment,s),r(X.$$.fragment,s),r(F.$$.fragment,s),r(H.$$.fragment,s),r(D.$$.fragment,s),r(z.$$.fragment,s),r(A.$$.fragment,s),r(O.$$.fragment,s),r(ts.$$.fragment,s),r(ns.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(os.$$.fragment,s),r(us.$$.fragment,s),r(ds.$$.fragment,s),r(gs.$$.fragment,s),r(bs.$$.fragment,s),r(Us.$$.fragment,s),r(fs.$$.fragment,s),r(Js.$$.fragment,s),r(Ts.$$.fragment,s),r($s.$$.fragment,s),r(Vs.$$.fragment,s),r(vs.$$.fragment,s),r(ks.$$.fragment,s),r(Is.$$.fragment,s),r(Ws.$$.fragment,s),tt=!1},d(s){s&&(t(qs),t(Ys),t(Ps),t(Os),t(Ks),t(se),t(k),t(ee),t(I),t(te),t(le),t(Q),t(ne),t(ae),t(T),t(pe),t(x),t(ie),t(W),t(me),t(N),t(ce),t(b),t(oe),t(q),t(Me),t(P),t(ue),t(re),t(K),t(de),t(ss),t(he),t(w),t(ge),t(es),t(be),t(je),t(ls),t(Ue),t(fe),t(as),t(Je),t(ye),t(Te),t(ms),t(we),t(C),t(Ce),t(cs),t($e),t(Ve),t(Ms),t(Ze),t(ve),t(rs),t(_e),t(ke),t(hs),t(Ie),t(Re),t(Qe),t(js),t(Ge),t(y),t(xe),t(We),t(Ne),t(ys),t(Ee),t(Xe),t(ws),t(Be),t(Cs),t(Fe),t(Se),t(He),t(Zs),t(Le),t(De),t(_s),t(ze),t(Ye),t($),t(Ae),t(qe),t(Rs),t(Pe),t(Qs),t(Oe),t(Gs),t(Ke),t(xs),t(st),t(et),t(As)),t(f),d(Z,s),d(v,s),d(_,s),d(R,s),d(G,s),d(X),d(F),d(H),d(D),d(z),d(A),d(O,s),d(ts,s),d(ns,s),d(ps,s),d(is,s),d(os,s),d(us,s),d(ds,s),d(gs,s),d(bs,s),d(Us),d(fs,s),d(Js,s),d(Ts,s),d($s,s),d(Vs,s),d(vs,s),d(ks,s),d(Is,s),d(Ws,s)}}}const Ul='{"title":"파이프라인, 모델 및 스케줄러 이해하기","local":"파이프라인-모델-및-스케줄러-이해하기","sections":[{"title":"기본 파이프라인 해체하기","local":"기본-파이프라인-해체하기","sections":[],"depth":2},{"title":"Stable Diffusion 파이프라인 해체하기","local":"stable-diffusion-파이프라인-해체하기","sections":[{"title":"텍스트 임베딩 생성하기","local":"텍스트-임베딩-생성하기","sections":[],"depth":3},{"title":"랜덤 노이즈 생성","local":"랜덤-노이즈-생성","sections":[],"depth":3},{"title":"이미지 노이즈 제거","local":"이미지-노이즈-제거","sections":[],"depth":3},{"title":"이미지 디코딩","local":"이미지-디코딩","sections":[],"depth":3}],"depth":2},{"title":"다음 단계","local":"다음-단계","sections":[],"depth":2}],"depth":1}';function fl(yt){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends ul{constructor(f){super(),rl(this,f,fl,jl,cl,{})}}export{$l as component};
