import{s as tl,n as sl,o as al}from"../chunks/scheduler.9cda857a.js";import{S as nl,i as il,e as i,s as a,c as r,h as ml,a as m,d as t,b as n,f as ll,g as p,j as o,k as O,l as ol,m as s,n as c,t as d,o as y,p as M}from"../chunks/index.003612b0.js";import{C as rl}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as D}from"../chunks/CodeBlock.a90632f1.js";import{H as q,E as pl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function cl(Ye){let h,ee,P,le,w,te,f,se,g,ze='<code>timm</code>, also known as <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">pytorch-image-models</a>, is an open-source collection of state-of-the-art PyTorch image models, pretrained weights, and utility scripts for training, inference, and validation.',ae,b,Ve='This documentation focuses on <code>timm</code> functionality in the Hugging Face Hub instead of the <code>timm</code> library itself. For detailed information about the <code>timm</code> library, visit <a href="https://huggingface.co/docs/timm" rel="nofollow">its documentation</a>.',ne,U,_e='You can find a number of <code>timm</code> models on the Hub using the filters on the left of the <a href="https://huggingface.co/models?library=timm&amp;sort=downloads" rel="nofollow">models page</a>.',ie,I,Ne="All models on the Hub come with several useful features:",me,j,Qe='<li>An automatically generated model card, which model authors can complete with <a href="./model-cards">information about their model</a>.</li> <li>Metadata tags help users discover the relevant <code>timm</code> models.</li> <li>An <a href="./models-widgets">interactive widget</a> you can use to play with the model directly in the browser.</li> <li>An <a href="./models-inference">Inference API</a> that allows users to make inference requests.</li>',oe,W,re,x,Ee="Any <code>timm</code> model from the Hugging Face Hub can be loaded with a single line of code as long as you have <code>timm</code> installed! Once you’ve selected a model from the Hub, pass the model’s ID prefixed with <code>hf-hub:</code> to <code>timm</code>’s <code>create_model</code> method to download and instantiate the model.",pe,B,ce,Z,Se="If you want to see how to load a specific model, you can click <strong>Use in timm</strong> and you will be given a working snippet to load it!",de,J,Ae='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1-dark.png"/>',ye,T,Le='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2-dark.png"/>',Me,$,he,v,Re="The snippet below shows how you can perform inference on a <code>timm</code> model loaded from the Hub:",Je,C,Te,G,Xe="This should leave you with a list of predictions, like this:",ue,H,we,k,fe,Y,Fe="You can share your <code>timm</code> models directly to the Hugging Face Hub. This will publish a new version of your model to the Hugging Face Hub, creating a model repo for you if it doesn’t already exist.",ge,z,De="Before pushing a model, make sure that you’ve logged in to Hugging Face:",be,V,Ue,_,qe="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, once you’ve installed <code>huggingface_hub</code> you can log in with:",Ie,N,je,Q,Pe="Then, push your model using the <code>push_to_hf_hub</code> method:",We,E,xe,S,Be,A,Ke='All <code>timm</code> models on the Hub are automatically equipped with an <a href="./models-widgets">inference widget</a>, pictured below for <a href="https://huggingface.co/nateraw/timm-resnet50-beans" rel="nofollow">nateraw/timm-resnet50-beans</a>. Additionally, <code>timm</code> models are available through the <a href="./models-inference">Inference API</a>, which you can access through HTTP with cURL, Python’s <code>requests</code> library, or your preferred method for making network requests.',Ze,u,Oe='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget-dark.png"/>',$e,L,ve,R,Ce,X,el='<li>timm (pytorch-image-models) <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">GitHub Repo</a>.</li> <li>timm <a href="https://huggingface.co/docs/timm" rel="nofollow">documentation</a>.</li> <li>Additional documentation at <a href="https://timm.fast.ai" rel="nofollow">timmdocs</a> by <a href="https://github.com/amaarora" rel="nofollow">Aman Arora</a>.</li> <li><a href="https://towardsdatascience.com/getting-started-with-pytorch-image-models-timm-a-practitioners-guide-4e77b4bf9055" rel="nofollow">Getting Started with PyTorch Image Models (timm): A Practitioner’s Guide</a> by <a href="https://github.com/Chris-hughes10" rel="nofollow">Chris Hughes</a>.</li>',Ge,F,He,K,ke;return w=new rl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new q({props:{title:"Using timm at Hugging Face",local:"using-timm-at-hugging-face",headingTag:"h1"}}),W=new q({props:{title:"Using existing models from the Hub",local:"using-existing-models-from-the-hub",headingTag:"h2"}}),B=new D({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMExvYWRpbmclMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGltbSUyRmVjYV9uZm5ldF9sMCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJTIyaGYtaHViJTNBdGltbSUyRmVjYV9uZm5ldF9sMCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Loading https://huggingface.co/timm/eca_nfnet_l0</span>
model = timm.create_model(<span class="hljs-string">&quot;hf-hub:timm/eca_nfnet_l0&quot;</span>, pretrained=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new q({props:{title:"Inference",local:"inference",headingTag:"h3"}}),C=new D({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> timm
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-comment"># Load from Hub 🔥</span>
model = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:nateraw/resnet50-oxford-iiit-pet&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Set model to eval mode for inference</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># Create Transform</span>
transform = create_transform(**resolve_data_config(model.pretrained_cfg, model=model))

<span class="hljs-comment"># Get the labels from the model config</span>
labels = model.pretrained_cfg[<span class="hljs-string">&#x27;label_names&#x27;</span>]
top_k = <span class="hljs-built_in">min</span>(<span class="hljs-built_in">len</span>(labels), <span class="hljs-number">5</span>)

<span class="hljs-comment"># Use your own image file here...</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;boxer.jpg&#x27;</span>).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)

<span class="hljs-comment"># Process PIL image with transforms and add a batch dimension</span>
x = transform(image).unsqueeze(<span class="hljs-number">0</span>)

<span class="hljs-comment"># Pass inputs to model forward function to get outputs</span>
out = model(x)

<span class="hljs-comment"># Apply softmax to get predicted probabilities for each class</span>
probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Grab the values and indices of top 5 predicted classes</span>
values, indices = torch.topk(probabilities, top_k)

<span class="hljs-comment"># Prepare a nice dict of top k predictions</span>
predictions = [
    {<span class="hljs-string">&quot;label&quot;</span>: labels[i], <span class="hljs-string">&quot;score&quot;</span>: v.item()}
    <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(indices, values)
]
<span class="hljs-built_in">print</span>(predictions)`,wrap:!1}}),H=new D({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdhbWVyaWNhbl9waXRfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTk5OTg4MDc5MDcxMDQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ3N0YWZmb3Jkc2hpcmVfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdtaW5pYXR1cmVfcGluc2NoZXInJTJDJTIwJ3Njb3JlJyUzQSUyMDEuMDAwMDAwMDE0OTAxMTYxMmUtMDclN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ2NoaWh1YWh1YSclMkMlMjAnc2NvcmUnJTNBJTIwMS4wMDAwMDAwMTQ5MDExNjEyZS0wNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QidsYWJlbCclM0ElMjAnYmVhZ2xlJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTBBJTVE",highlighted:`[
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;american_pit_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9999998807907104</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;staffordshire_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;miniature_pinscher&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;chihuahua&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;beagle&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>}
]`,wrap:!1}}),k=new q({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),V=new D({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBaGYlMjBhdXRoJTIwbG9naW4=",highlighted:`python -m pip install huggingface_hub
hf auth login`,wrap:!1}}),N=new D({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()`,wrap:!1}}),E=new D({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMEJ1aWxkJTIwb3IlMjBsb2FkJTIwYSUyMG1vZGVsJTJDJTIwZS5nLiUyMHRpbW0ncyUyMHByZXRyYWluZWQlMjByZXNuZXQxOCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0Q0KSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUwQSUyMyUyMCU1QkZpbmUlMjB0dW5lJTIweW91ciUyMG1vZGVsLi4uJTVEJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwUHVzaCUyMGl0JTIwdG8lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBIdWIlMEF0aW1tLm1vZGVscy5odWIucHVzaF90b19oZl9odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAncmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnJTNEJTdCJ2xhYmVscyclM0ElMjAlNUInYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclNUQlN0QlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMHlvdXIlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEFtb2RlbF9yZWxvYWRlZCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUwQSUyMCUyMCUyMCUyMCdoZi1odWIlM0ElM0N5b3VyLXVzZXJuYW1lJTNFJTJGcmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwcHJldHJhaW5lZCUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Build or load a model, e.g. timm&#x27;s pretrained resnet18</span>
model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">4</span>)

<span class="hljs-comment">###########################</span>
<span class="hljs-comment"># [Fine tune your model...]</span>
<span class="hljs-comment">###########################</span>

<span class="hljs-comment"># Push it to the 🤗 Hub</span>
timm.models.hub.push_to_hf_hub(
    model,
    <span class="hljs-string">&#x27;resnet18-random-classifier&#x27;</span>,
    model_config={<span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]}
)

<span class="hljs-comment"># Load your model from the Hub</span>
model_reloaded = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:&lt;your-username&gt;/resnet18-random-classifier&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)`,wrap:!1}}),S=new q({props:{title:"Inference Widget and API",local:"inference-widget-and-api",headingTag:"h2"}}),L=new D({props:{code:"Y3VybCUyMGh0dHBzJTNBJTJGJTJGYXBpLWluZmVyZW5jZS5odWdnaW5nZmFjZS5jbyUyRm1vZGVscyUyRm5hdGVyYXclMkZ0aW1tLXJlc25ldDUwLWJlYW5zJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBiZWFucy5qcGVnJyUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCU3QiUyNEhGX0FQSV9UT0tFTiU3RCUyMiUwQSUyMyUyMCU1QiU3QiUyMmxhYmVsJTIyJTNBJTIyYW5ndWxhcl9sZWFmX3Nwb3QlMjIlMkMlMjJzY29yZSUyMiUzQTAuOTg0NTk0NzAyNzIwNjQyMSU3RCUyQyU3QiUyMmxhYmVsJTIyJTNBJTIyYmVhbl9ydXN0JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAxMzY4MzE1MDUyMjQxMDg3JTdEJTJDJTdCJTIybGFiZWwlMjIlM0ElMjJoZWFsdGh5JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAwMTcyMjA4NTg3MTczMzcyNSU3RCU1RA==",highlighted:`curl https://api-inference.huggingface.co/models/nateraw/timm-resnet50-beans \\
        -X POST \\
        --data-binary <span class="hljs-string">&#x27;@beans.jpeg&#x27;</span> \\
        -H <span class="hljs-string">&quot;Authorization: Bearer {<span class="hljs-variable">$HF_API_TOKEN</span>}&quot;</span>
<span class="hljs-comment"># [{&quot;label&quot;:&quot;angular_leaf_spot&quot;,&quot;score&quot;:0.9845947027206421},{&quot;label&quot;:&quot;bean_rust&quot;,&quot;score&quot;:0.01368315052241087},{&quot;label&quot;:&quot;healthy&quot;,&quot;score&quot;:0.001722085871733725}]</span>`,wrap:!1}}),R=new q({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),F=new pl({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/timm.md"}}),{c(){h=i("meta"),ee=a(),P=i("p"),le=a(),r(w.$$.fragment),te=a(),r(f.$$.fragment),se=a(),g=i("p"),g.innerHTML=ze,ae=a(),b=i("p"),b.innerHTML=Ve,ne=a(),U=i("p"),U.innerHTML=_e,ie=a(),I=i("p"),I.textContent=Ne,me=a(),j=i("ol"),j.innerHTML=Qe,oe=a(),r(W.$$.fragment),re=a(),x=i("p"),x.innerHTML=Ee,pe=a(),r(B.$$.fragment),ce=a(),Z=i("p"),Z.innerHTML=Se,de=a(),J=i("div"),J.innerHTML=Ae,ye=a(),T=i("div"),T.innerHTML=Le,Me=a(),r($.$$.fragment),he=a(),v=i("p"),v.innerHTML=Re,Je=a(),r(C.$$.fragment),Te=a(),G=i("p"),G.textContent=Xe,ue=a(),r(H.$$.fragment),we=a(),r(k.$$.fragment),fe=a(),Y=i("p"),Y.innerHTML=Fe,ge=a(),z=i("p"),z.textContent=De,be=a(),r(V.$$.fragment),Ue=a(),_=i("p"),_.innerHTML=qe,Ie=a(),r(N.$$.fragment),je=a(),Q=i("p"),Q.innerHTML=Pe,We=a(),r(E.$$.fragment),xe=a(),r(S.$$.fragment),Be=a(),A=i("p"),A.innerHTML=Ke,Ze=a(),u=i("div"),u.innerHTML=Oe,$e=a(),r(L.$$.fragment),ve=a(),r(R.$$.fragment),Ce=a(),X=i("ul"),X.innerHTML=el,Ge=a(),r(F.$$.fragment),He=a(),K=i("p"),this.h()},l(e){const l=ml("svelte-u9bgzb",document.head);h=m(l,"META",{name:!0,content:!0}),l.forEach(t),ee=n(e),P=m(e,"P",{}),ll(P).forEach(t),le=n(e),p(w.$$.fragment,e),te=n(e),p(f.$$.fragment,e),se=n(e),g=m(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1bz9zfk"&&(g.innerHTML=ze),ae=n(e),b=m(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1b9kavw"&&(b.innerHTML=Ve),ne=n(e),U=m(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-19ixdpv"&&(U.innerHTML=_e),ie=n(e),I=m(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1uvi03j"&&(I.textContent=Ne),me=n(e),j=m(e,"OL",{"data-svelte-h":!0}),o(j)!=="svelte-1dns05d"&&(j.innerHTML=Qe),oe=n(e),p(W.$$.fragment,e),re=n(e),x=m(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19q2wuk"&&(x.innerHTML=Ee),pe=n(e),p(B.$$.fragment,e),ce=n(e),Z=m(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1dv22ye"&&(Z.innerHTML=Se),de=n(e),J=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-y8p227"&&(J.innerHTML=Ae),ye=n(e),T=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1xvepxr"&&(T.innerHTML=Le),Me=n(e),p($.$$.fragment,e),he=n(e),v=m(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-4jjk9c"&&(v.innerHTML=Re),Je=n(e),p(C.$$.fragment,e),Te=n(e),G=m(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1hfr7cw"&&(G.textContent=Xe),ue=n(e),p(H.$$.fragment,e),we=n(e),p(k.$$.fragment,e),fe=n(e),Y=m(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1m2yz24"&&(Y.innerHTML=Fe),ge=n(e),z=m(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ixi9lc"&&(z.textContent=De),be=n(e),p(V.$$.fragment,e),Ue=n(e),_=m(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-19plf33"&&(_.innerHTML=qe),Ie=n(e),p(N.$$.fragment,e),je=n(e),Q=m(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-13bqgmd"&&(Q.innerHTML=Pe),We=n(e),p(E.$$.fragment,e),xe=n(e),p(S.$$.fragment,e),Be=n(e),A=m(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1suwl6q"&&(A.innerHTML=Ke),Ze=n(e),u=m(e,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-11rs1r3"&&(u.innerHTML=Oe),$e=n(e),p(L.$$.fragment,e),ve=n(e),p(R.$$.fragment,e),Ce=n(e),X=m(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-1o8g6cw"&&(X.innerHTML=el),Ge=n(e),p(F.$$.fragment,e),He=n(e),K=m(e,"P",{}),ll(K).forEach(t),this.h()},h(){O(h,"name","hf:doc:metadata"),O(h,"content",dl),O(J,"class","flex justify-center"),O(T,"class","flex justify-center"),O(u,"class","flex justify-center")},m(e,l){ol(document.head,h),s(e,ee,l),s(e,P,l),s(e,le,l),c(w,e,l),s(e,te,l),c(f,e,l),s(e,se,l),s(e,g,l),s(e,ae,l),s(e,b,l),s(e,ne,l),s(e,U,l),s(e,ie,l),s(e,I,l),s(e,me,l),s(e,j,l),s(e,oe,l),c(W,e,l),s(e,re,l),s(e,x,l),s(e,pe,l),c(B,e,l),s(e,ce,l),s(e,Z,l),s(e,de,l),s(e,J,l),s(e,ye,l),s(e,T,l),s(e,Me,l),c($,e,l),s(e,he,l),s(e,v,l),s(e,Je,l),c(C,e,l),s(e,Te,l),s(e,G,l),s(e,ue,l),c(H,e,l),s(e,we,l),c(k,e,l),s(e,fe,l),s(e,Y,l),s(e,ge,l),s(e,z,l),s(e,be,l),c(V,e,l),s(e,Ue,l),s(e,_,l),s(e,Ie,l),c(N,e,l),s(e,je,l),s(e,Q,l),s(e,We,l),c(E,e,l),s(e,xe,l),c(S,e,l),s(e,Be,l),s(e,A,l),s(e,Ze,l),s(e,u,l),s(e,$e,l),c(L,e,l),s(e,ve,l),c(R,e,l),s(e,Ce,l),s(e,X,l),s(e,Ge,l),c(F,e,l),s(e,He,l),s(e,K,l),ke=!0},p:sl,i(e){ke||(d(w.$$.fragment,e),d(f.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(C.$$.fragment,e),d(H.$$.fragment,e),d(k.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(L.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),ke=!0)},o(e){y(w.$$.fragment,e),y(f.$$.fragment,e),y(W.$$.fragment,e),y(B.$$.fragment,e),y($.$$.fragment,e),y(C.$$.fragment,e),y(H.$$.fragment,e),y(k.$$.fragment,e),y(V.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),y(R.$$.fragment,e),y(F.$$.fragment,e),ke=!1},d(e){e&&(t(ee),t(P),t(le),t(te),t(se),t(g),t(ae),t(b),t(ne),t(U),t(ie),t(I),t(me),t(j),t(oe),t(re),t(x),t(pe),t(ce),t(Z),t(de),t(J),t(ye),t(T),t(Me),t(he),t(v),t(Je),t(Te),t(G),t(ue),t(we),t(fe),t(Y),t(ge),t(z),t(be),t(Ue),t(_),t(Ie),t(je),t(Q),t(We),t(xe),t(Be),t(A),t(Ze),t(u),t($e),t(ve),t(Ce),t(X),t(Ge),t(He),t(K)),t(h),M(w,e),M(f,e),M(W,e),M(B,e),M($,e),M(C,e),M(H,e),M(k,e),M(V,e),M(N,e),M(E,e),M(S,e),M(L,e),M(R,e),M(F,e)}}}const dl='{"title":"Using timm at Hugging Face","local":"using-timm-at-hugging-face","sections":[{"title":"Using existing models from the Hub","local":"using-existing-models-from-the-hub","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Inference Widget and API","local":"inference-widget-and-api","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function yl(Ye){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends nl{constructor(h){super(),il(this,h,yl,cl,tl,{})}}export{wl as component};
