import{s as ka,n as va,o as Ua}from"../chunks/scheduler.9cda857a.js";import{S as Ca,i as $a,e as o,s,c as p,h as Ia,a as i,d as a,b as n,f as ga,g as h,j as r,k as Ce,l as Aa,m as l,n as d,t as c,o as u,p as M}from"../chunks/index.003612b0.js";import{C as xa}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as m}from"../chunks/CodeBlock.a90632f1.js";import{H as w,E as _a}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function Ba(Xt){let y,$e,ve,Ie,b,Ae,J,xe,f,Rt="<p>Webhooks are now publicly available!</p>",_e,g,Gt="This guide will walk you through creating a system that reacts to changes to a user’s or organization’s models or datasets on the Hub and creates a ‘metadata review’ for the changed repository.",Be,k,Ee,v,Lt="Before we dive into the technical details involved in this particular workflow, we’ll quickly outline what we’re creating and why.",Ze,U,St='<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model cards</a> and <a href="https://huggingface.co/docs/hub/datasets-cards" rel="nofollow">dataset cards</a> are essential tools for documenting machine learning models and datasets. The Hugging Face Hub uses a <code>README.md</code> file containing a <a href="https://en.wikipedia.org/wiki/YAML" rel="nofollow">YAML</a> header block to generate model and dataset cards. This <code>YAML</code> section defines metadata relating to the model or dataset. For example:',We,C,He,$,Yt="This metadata contains essential information about your model or dataset for potential users. The license, for example, defines the terms under which a model or dataset can be used. Hub users can also use the fields defined in the <code>YAML</code> metadata as filters for identifying models or datasets that fit specific criteria.",Xe,I,Vt='Since the metadata defined in this block is essential for potential users of our models and datasets, it is important that we complete this section. In a team or organization setting, users pushing models and datasets to the Hub may have differing familiarity with the importance of this YAML metadata block. While someone in a team could take on the responsibility of reviewing this metadata, there may instead be some automation we can do to help us with this problem. The result will be a metadata review report automatically posted or updated when a repository on the Hub changes. For our metadata quality, this system works similarly to <a href="https://en.wikipedia.org/wiki/CI/CD" rel="nofollow">CI/CD</a>.',Re,A,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/003-metadata-review/metadata-report-screenshot.png" alt="Metadata review"/>',Ge,x,Qt='You can also find an example review <a href="https://huggingface.co/datasets/davanstrien/test_webhook/discussions/1#63d932fe19aa7b8ed2718b3f" rel="nofollow">here</a>.',Le,_,Se,B,qt='The <code>huggingface_hub</code> is a Python library that allows you to interact with the Hub. We can use this library to <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">download model and dataset cards</a> from the Hub using the <code>DatasetCard.load</code> or <code>ModelCard.load</code> methods. In particular, we’ll use these methods to load a Python dictionary, which contains the metadata defined in the <code>YAML</code> of our model or dataset card. We’ll create a small Python function to wrap these methods and do some exception handling.',Ye,E,Ve,Z,Ft="This function will return a Python dictionary containing the metadata associated with the repository (or an empty dictionary if there is no metadata).",Ne,W,Qe,H,qe,X,zt="Once we have a Python dictionary containing the metadata associated with a repository, we’ll create a ‘report card’ for our metadata review. In this particular instance, we’ll review our metadata by defining some metadata fields for which we want values. For example, we may want to ensure that the <code>license</code> field has always been completed. To rate our metadata, we’ll count which metadata fields are present out of our desired fields and return a percentage score based on the coverage of the required metadata fields we want to see values.",Fe,R,Pt="Since we have a Python dictionary containing our metadata, we can loop through this dictionary to check if our desired keys are there. If a desired metadata field (a key in our dictionary) is missing, we’ll assign the value as <code>None</code>.",ze,G,Pe,L,Dt="This function will return a dictionary containing keys representing the metadata fields we require for our model or dataset. The dictionary values will either include the metadata entered for that field or <code>None</code> if that metadata field is missing in the <code>YAML</code>.",De,S,Ke,Y,Kt='Once we have this dictionary, we can create our metadata report. In the interest of brevity, we won’t include the complete code here, but the Hugging Face Spaces <a href="https://huggingface.co/spaces/librarian-bot/webhook_metadata_reviewer/blob/main/main.py" rel="nofollow">repository</a> for this Webhook contains the full code.',Oe,V,Ot="We create one function which creates a markdown table that produces a prettier version of the data we have in our metadata coverage dictionary.",et,N,tt,Q,ea="We also have a Python function that generates a score (representing the percentage of the desired metadata fields present)",at,q,lt,F,ta="and a Python function that creates a markdown report for our metadata review. This report contains both the score and metadata table, along with some explanation of what the report contains.",st,z,nt,P,ot,D,aa="We now have a markdown formatted metadata review report. We’ll use the <code>huggingface_hub</code> library to post this review. We define a function that takes back the Webhook data received from the Hub, parses the data, and creates the metadata report. Depending on whether a report has previously been created, the function creates a new report or posts a new issue to an existing metadata review thread.",it,K,rt,j,la='<p><code>:=</code> is the Python Syntax for an assignment expression operator added to the Python language in version 3.8 (colloquially known as the walrus operator). People have mixed opinions on this syntax, and it doesn’t change how Python evaluates the code if you don’t use this. You can read more about this operator in this <a href="https://realpython.com/python-walrus-operator">Real Python article</a>.</p>',pt,O,ht,ee,sa="We’ve now got the core functionality for creating a metadata review report for a model or dataset. The next step is to use Webhooks to respond to changes automatically.",dt,te,ct,ae,na='First, create your Webhook by going to <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>.',ut,le,oa='<li>Input a few target repositories that your Webhook will listen to (you will likely want to limit this to your own repositories or the repositories of the organization you belong to).</li> <li>Input a secret to make your Webhook more secure (if you don’t know what to choose for this, you may want to use a <a href="https://1password.com/password-generator/" rel="nofollow">password generator</a> to generate a sufficiently long random string for your secret).</li> <li>We can pass a dummy URL for the <code>Webhook URL</code> parameter for now.</li>',Mt,se,ia="Your Webhook will look like this:",wt,ne,ra='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/003-metadata-review/webhook-settings.png" alt="webhook settings"/>',mt,oe,yt,ie,pa="This guide creates a separate user account that will post the metadata reviews.",ft,re,ha='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/003-metadata-review/librarian-bot-profile.png" alt="Bot user account"/>',jt,T,da="<p>When creating a bot that will interact with other users on the Hub, we ask that you clearly label the account as a “Bot” (see profile screenshot).</p>",Tt,pe,bt,he,ca='We now need some way of listening to Webhook events. There are many possible tools you can use to listen to Webhook events. Many existing services, such as <a href="https://zapier.com/" rel="nofollow">Zapier</a> and <a href="https://ifttt.com" rel="nofollow">IFTTT</a>, can use Webhooks to trigger actions (for example, they could post a tweet every time a model is updated). In this case, we’ll implement our Webhook listener using  <a href="https://fastapi.tiangolo.com/" rel="nofollow">FastAPI</a>.',Jt,de,ua='<a href="https://fastapi.tiangolo.com/" rel="nofollow">FastAPI</a> is a Python web framework. We’ll use FastAPI to create a Webhook listener. In particular, we need to implement a route that accepts <code>POST</code> requests on <code>/webhook</code>. For authentication, we’ll compare the <code>X-Webhook-Secret</code> header with a <code>WEBHOOK_SECRET</code> secret that can be passed to our <a href="./spaces-sdks-docker#runtime">Docker container at runtime</a>.',gt,ce,kt,ue,Ma="The above function will receive Webhook events and creates or updates the metadata review report for the changed repository.",vt,Me,Ut,we,wa='Our <a href="https://huggingface.co/spaces/librarian-bot/webhook_metadata_reviewer/blob/main/main.py" rel="nofollow">main.py</a> file contains all the code we need for our Webhook app. To deploy it, we’ll use a <a href="./spaces-overview">Space</a>.',Ct,me,ma='For our Space, we’ll use Docker to run our app. The <a href="https://huggingface.co/spaces/librarian-bot/webhook_metadata_reviewer/blob/main/Dockerfile" rel="nofollow">Dockerfile</a> copies our app file, installs the required dependencies, and runs the application. To populate the <code>KEY</code> variable, we’ll also set a <code>WEBHOOK_SECRET</code> secret for our Space with the secret we generated earlier. You can read more about Docker Spaces <a href="./spaces-sdks-docker">here</a>.',$t,ye,ya="Finally, we need to update the URL in our Webhook settings to the URL of our Space. We can get our Space’s “direct URL” from the contextual menu. Click on “Embed this Space” and copy the “Direct URL”.",It,fe,fa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/003-metadata-review/direct-url.png" alt="direct url"/>',At,je,ja="Once we have this URL, we can pass this to the <code>Webhook URL</code> parameter in our Webhook settings. Our bot should now start posting reviews when monitored repositories change!",xt,Te,_t,be,Ta="We now have an automatic metadata review bot! Here are some ideas for how you could build on this guide:",Bt,Je,ba="<li>The metadata review done by our bot was relatively crude; you could add more complex rules for reviewing metadata.</li> <li>You could use the full <code>README.md</code> file for doing the review.</li> <li>You may want to define ‘rules’ which are particularly important for your organization and use a webhook to check these are followed.</li>",Et,ge,Ja="If you build a metadata quality app using Webhooks, please tag me @davanstrien; I would love to know about it!",Zt,ke,Wt,Ue,Ht;return b=new xa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new w({props:{title:"Webhook guide: Setup an automatic metadata quality review for models and datasets",local:"webhook-guide-setup-an-automatic-metadata-quality-review-for-models-and-datasets",headingTag:"h1"}}),k=new w({props:{title:"What are we building and why?",local:"what-are-we-building-and-why",headingTag:"h2"}}),C=new m({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjAlMEElMjAlMjAtJTIwJTIyTGlzdCUyMG9mJTIwSVNPJTIwNjM5LTElMjBjb2RlJTIwZm9yJTIweW91ciUyMGxhbmd1YWdlJTIyJTBBJTIwJTIwLSUyMGxhbmcxJTBBJTIwJTIwLSUyMGxhbmcyJTBBdGFncyUzQSUwQS0lMjB0YWcxJTBBLSUyMHRhZzIlMEFsaWNlbnNlJTNBJTIwJTIyYW55JTIwdmFsaWQlMjBsaWNlbnNlJTIwaWRlbnRpZmllciUyMiUwQWRhdGFzZXRzJTNBJTBBLSUyMGRhdGFzZXQxJTBBLS0t",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> 
  <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;List of ISO 639-1 code for your language&quot;</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">lang1</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">lang2</span>
<span class="hljs-attr">tags:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">tag1</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">tag2</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">&quot;any valid license identifier&quot;</span>
<span class="hljs-attr">datasets:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">dataset1</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),_=new w({props:{title:"Using the Hub Client Library to create a model review card",local:"using-the-hub-client-library-to-create-a-model-review-card",headingTag:"h2"}}),E=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMERhdGFzZXRDYXJkJTJDJTIwTW9kZWxDYXJkJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi51dGlscyUyMGltcG9ydCUyMEVudHJ5Tm90Rm91bmRFcnJvciUyMCUwQSUwQWRlZiUyMGxvYWRfcmVwb19jYXJkX21ldGFkYXRhKHJlcG9fdHlwZSUyQyUyMHJlcG9fbmFtZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHJlcG9fdHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBEYXRhc2V0Q2FyZC5sb2FkKHJlcG9fbmFtZSkuZGF0YS50b19kaWN0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGNlcHQlMjBFbnRyeU5vdEZvdW5kRXJyb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMHJlcG9fdHlwZSUyMCUzRCUzRCUyMCUyMm1vZGVsJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTW9kZWxDYXJkLmxvYWQocmVwb19uYW1lKS5kYXRhLnRvX2RpY3QoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4Y2VwdCUyMEVudHJ5Tm90Rm91bmRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RA==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> DatasetCard, ModelCard
<span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> EntryNotFoundError 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_repo_card_metadata</span>(<span class="hljs-params">repo_type, repo_name</span>):
    <span class="hljs-keyword">if</span> repo_type == <span class="hljs-string">&quot;dataset&quot;</span>:
        <span class="hljs-keyword">try</span>:
            <span class="hljs-keyword">return</span> DatasetCard.load(repo_name).data.to_dict()
        <span class="hljs-keyword">except</span> EntryNotFoundError:
            <span class="hljs-keyword">return</span> {}
    <span class="hljs-keyword">if</span> repo_type == <span class="hljs-string">&quot;model&quot;</span>:
        <span class="hljs-keyword">try</span>:
            <span class="hljs-keyword">return</span> ModelCard.load(repo_name).data.to_dict()
        <span class="hljs-keyword">except</span> EntryNotFoundError:
            <span class="hljs-keyword">return</span> {}`,wrap:!1}}),W=new m({props:{code:"JTdCJ2xpY2Vuc2UnJTNBJTIwJ2FmbC0zLjAnJTdE",highlighted:'{<span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;afl-3.0&#x27;</span>}',wrap:!1}}),H=new w({props:{title:"Creating our metadata review report",local:"creating-our-metadata-review-report",headingTag:"h2"}}),G=new m({props:{code:"ZGVmJTIwY3JlYXRlX21ldGFkYXRhX2tleV9kaWN0KGNhcmRfZGF0YSUyQyUyMHJlcG9fdHlwZSUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjBzaGFyZWRfa2V5cyUyMCUzRCUyMCU1QiUyMnRhZ3MlMjIlMkMlMjAlMjJsaWNlbnNlJTIyJTVEJTBBJTIwJTIwJTIwJTIwaWYlMjByZXBvX3R5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2tleXMlMjAlM0QlMjAlNUIlMjJsaWJyYXJ5X25hbWUlMjIlMkMlMjAlMjJkYXRhc2V0cyUyMiUyQyUyMCUyMm1ldHJpY3MlMjIlMkMlMjAlMjJjbzIlMjIlMkMlMjAlMjJwaXBlbGluZV90YWclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaGFyZWRfa2V5cy5leHRlbmQobW9kZWxfa2V5cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXlzJTIwJTNEJTIwc2hhcmVkX2tleXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0JrZXklM0ElMjBjYXJkX2RhdGEuZ2V0KGtleSklMjBmb3IlMjBrZXklMjBpbiUyMGtleXMlN0QlMEElMjAlMjAlMjAlMjBpZiUyMHJlcG9fdHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlNUIuLi4lNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_metadata_key_dict</span>(<span class="hljs-params">card_data, repo_type: <span class="hljs-built_in">str</span></span>):
    shared_keys = [<span class="hljs-string">&quot;tags&quot;</span>, <span class="hljs-string">&quot;license&quot;</span>]
    <span class="hljs-keyword">if</span> repo_type == <span class="hljs-string">&quot;model&quot;</span>:
        model_keys = [<span class="hljs-string">&quot;library_name&quot;</span>, <span class="hljs-string">&quot;datasets&quot;</span>, <span class="hljs-string">&quot;metrics&quot;</span>, <span class="hljs-string">&quot;co2&quot;</span>, <span class="hljs-string">&quot;pipeline_tag&quot;</span>]
        shared_keys.extend(model_keys)
        keys = shared_keys
        <span class="hljs-keyword">return</span> {key: card_data.get(key) <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> keys}
    <span class="hljs-keyword">if</span> repo_type == <span class="hljs-string">&quot;dataset&quot;</span>:
        <span class="hljs-comment"># [...]</span>`,wrap:!1}}),S=new m({props:{code:"JTdCJ3RhZ3MnJTNBJTIwTm9uZSUyQyUwQSUyMCdsaWNlbnNlJyUzQSUyMCdhZmwtMy4wJyUyQyUwQSUyMCdsaWJyYXJ5X25hbWUnJTNBJTIwTm9uZSUyQyUwQSUyMCdkYXRhc2V0cyclM0ElMjBOb25lJTJDJTBBJTIwJ21ldHJpY3MnJTNBJTIwTm9uZSUyQyUwQSUyMCdjbzInJTNBJTIwTm9uZSUyQyUwQSUyMCdwaXBlbGluZV90YWcnJTNBJTIwTm9uZSU3RA==",highlighted:`{<span class="hljs-string">&#x27;tags&#x27;</span>: <span class="hljs-literal">None</span>,
 <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;afl-3.0&#x27;</span>,
 <span class="hljs-string">&#x27;library_name&#x27;</span>: <span class="hljs-literal">None</span>,
 <span class="hljs-string">&#x27;datasets&#x27;</span>: <span class="hljs-literal">None</span>,
 <span class="hljs-string">&#x27;metrics&#x27;</span>: <span class="hljs-literal">None</span>,
 <span class="hljs-string">&#x27;co2&#x27;</span>: <span class="hljs-literal">None</span>,
 <span class="hljs-string">&#x27;pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>}`,wrap:!1}}),N=new m({props:{code:"ZGVmJTIwY3JlYXRlX21ldGFkYXRhX2JyZWFrZG93bl90YWJsZShkZXNpcmVkX21ldGFkYXRhX2RpY3Rpb25hcnkpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGFidWxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFibGVfZGF0YSUyQyUyMHRhYmxlZm10JTNEJTIyZ2l0aHViJTIyJTJDJTIwaGVhZGVycyUzRCglMjJNZXRhZGF0YSUyMEZpZWxkJTIyJTJDJTIwJTIyUHJvdmlkZWQlMjBWYWx1ZSUyMiklMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_metadata_breakdown_table</span>(<span class="hljs-params">desired_metadata_dictionary</span>):
    <span class="hljs-comment"># [...]</span>
    <span class="hljs-keyword">return</span> tabulate(
        table_data, tablefmt=<span class="hljs-string">&quot;github&quot;</span>, headers=(<span class="hljs-string">&quot;Metadata Field&quot;</span>, <span class="hljs-string">&quot;Provided Value&quot;</span>)
    )`,wrap:!1}}),q=new m({props:{code:"ZGVmJTIwY2FsY3VsYXRlX2dyYWRlKGRlc2lyZWRfbWV0YWRhdGFfZGljdGlvbmFyeSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlNUIuLi4lNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjByb3VuZChzY29yZSUyQyUyMDIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_grade</span>(<span class="hljs-params">desired_metadata_dictionary</span>):
    <span class="hljs-comment"># [...]</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(score, <span class="hljs-number">2</span>)`,wrap:!1}}),z=new m({props:{code:"ZGVmJTIwY3JlYXRlX21hcmtkb3duX3JlcG9ydCglMEElMjAlMjAlMjAlMjBkZXNpcmVkX21ldGFkYXRhX2RpY3Rpb25hcnklMkMlMjByZXBvX25hbWUlMkMlMjByZXBvX3R5cGUlMkMlMjBzY29yZSUyQyUyMHVwZGF0ZSUzQSUyMGJvb2wlMjAlM0QlMjBGYWxzZSUwQSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlNUIuLi4lNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXBvcnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_markdown_report</span>(<span class="hljs-params">
    desired_metadata_dictionary, repo_name, repo_type, score, update: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>
</span>):
    <span class="hljs-comment"># [...]</span>
    <span class="hljs-keyword">return</span> report`,wrap:!1}}),P=new w({props:{title:"How to post the review automatically?",local:"how-to-post-the-review-automatically",headingTag:"h2"}}),K=new m({props:{code:"ZGVmJTIwY3JlYXRlX29yX3VwZGF0ZV9yZXBvcnQoZGF0YSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHBhcnNlZF9wb3N0JTIwJTNBJTNEJTIwcGFyc2Vfd2ViaG9va19wb3N0KGRhdGEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTJDJTIwcmVwb19uYW1lJTIwJTNEJTIwcGFyc2VkX3Bvc3QlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUmVzcG9uc2UoJTIyVW5hYmxlJTIwdG8lMjBwYXJzZSUyMHdlYmhvb2slMjBkYXRhJTIyJTJDJTIwc3RhdHVzX2NvZGUlM0Q0MDApJTBBJTIwJTIwJTIwJTIwJTIzJTIwJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_or_update_report</span>(<span class="hljs-params">data</span>):
    <span class="hljs-keyword">if</span> parsed_post := parse_webhook_post(data):
        repo_type, repo_name = parsed_post
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> Response(<span class="hljs-string">&quot;Unable to parse webhook data&quot;</span>, status_code=<span class="hljs-number">400</span>)
    <span class="hljs-comment"># [...]</span>
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>`,wrap:!1}}),O=new w({props:{title:"Creating a Webhook to respond to changes on the Hub",local:"creating-a-webhook-to-respond-to-changes-on-the-hub",headingTag:"h2"}}),te=new w({props:{title:"Create a Webhook in your user profile",local:"create-a-webhook-in-your-user-profile",headingTag:"h2"}}),oe=new w({props:{title:"Create a new Bot user profile",local:"create-a-new-bot-user-profile",headingTag:"h2"}}),pe=new w({props:{title:"Create a Webhook listener",local:"create-a-webhook-listener",headingTag:"h2"}}),ce=new m({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTJDJTIwUmVxdWVzdCUyQyUyMFJlc3BvbnNlJTBBaW1wb3J0JTIwb3MlMEElMEFLRVklMjAlM0QlMjBvcy5lbnZpcm9uLmdldCglMjJXRUJIT09LX1NFQ1JFVCUyMiklMEElMEFhcHAlMjAlM0QlMjBGYXN0QVBJKCklMEElMEElNDBhcHAucG9zdCglMjIlMkZ3ZWJob29rJTIyKSUwQWFzeW5jJTIwZGVmJTIwd2ViaG9vayhyZXF1ZXN0JTNBJTIwUmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHJlcXVlc3QubWV0aG9kJTIwJTNEJTNEJTIwJTIyUE9TVCUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcmVxdWVzdC5oZWFkZXJzLmdldCglMjJYLVdlYmhvb2stU2VjcmV0JTIyKSUyMCElM0QlMjBLRVklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBSZXNwb25zZSglMjJJbnZhbGlkJTIwc2VjcmV0JTIyJTJDJTIwc3RhdHVzX2NvZGUlM0Q0MDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGF3YWl0JTIwcmVxdWVzdC5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBjcmVhdGVfb3JfdXBkYXRlX3JlcG9ydChkYXRhKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMldlYmhvb2slMjByZWNlaXZlZCElMjIlMjBpZiUyMHJlc3VsdCUyMGVsc2UlMjByZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI, Request, Response
<span class="hljs-keyword">import</span> os

KEY = os.environ.get(<span class="hljs-string">&quot;WEBHOOK_SECRET&quot;</span>)

app = FastAPI()

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">webhook</span>(<span class="hljs-params">request: Request</span>):
    <span class="hljs-keyword">if</span> request.method == <span class="hljs-string">&quot;POST&quot;</span>:
        <span class="hljs-keyword">if</span> request.headers.get(<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>) != KEY:
            <span class="hljs-keyword">return</span> Response(<span class="hljs-string">&quot;Invalid secret&quot;</span>, status_code=<span class="hljs-number">401</span>)
        data = <span class="hljs-keyword">await</span> request.json()
        result = create_or_update_report(data)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Webhook received!&quot;</span> <span class="hljs-keyword">if</span> result <span class="hljs-keyword">else</span> result`,wrap:!1}}),Me=new w({props:{title:"Use Spaces to deploy our Webhook app",local:"use-spaces-to-deploy-our-webhook-app",headingTag:"h2"}}),Te=new w({props:{title:"Conclusion and next steps",local:"conclusion-and-next-steps",headingTag:"h2"}}),ke=new _a({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/webhooks-guide-metadata-review.md"}}),{c(){y=o("meta"),$e=s(),ve=o("p"),Ie=s(),p(b.$$.fragment),Ae=s(),p(J.$$.fragment),xe=s(),f=o("blockquote"),f.innerHTML=Rt,_e=s(),g=o("p"),g.textContent=Gt,Be=s(),p(k.$$.fragment),Ee=s(),v=o("p"),v.textContent=Lt,Ze=s(),U=o("p"),U.innerHTML=St,We=s(),p(C.$$.fragment),He=s(),$=o("p"),$.innerHTML=Yt,Xe=s(),I=o("p"),I.innerHTML=Vt,Re=s(),A=o("p"),A.innerHTML=Nt,Ge=s(),x=o("p"),x.innerHTML=Qt,Le=s(),p(_.$$.fragment),Se=s(),B=o("p"),B.innerHTML=qt,Ye=s(),p(E.$$.fragment),Ve=s(),Z=o("p"),Z.textContent=Ft,Ne=s(),p(W.$$.fragment),Qe=s(),p(H.$$.fragment),qe=s(),X=o("p"),X.innerHTML=zt,Fe=s(),R=o("p"),R.innerHTML=Pt,ze=s(),p(G.$$.fragment),Pe=s(),L=o("p"),L.innerHTML=Dt,De=s(),p(S.$$.fragment),Ke=s(),Y=o("p"),Y.innerHTML=Kt,Oe=s(),V=o("p"),V.textContent=Ot,et=s(),p(N.$$.fragment),tt=s(),Q=o("p"),Q.textContent=ea,at=s(),p(q.$$.fragment),lt=s(),F=o("p"),F.textContent=ta,st=s(),p(z.$$.fragment),nt=s(),p(P.$$.fragment),ot=s(),D=o("p"),D.innerHTML=aa,it=s(),p(K.$$.fragment),rt=s(),j=o("blockquote"),j.innerHTML=la,pt=s(),p(O.$$.fragment),ht=s(),ee=o("p"),ee.textContent=sa,dt=s(),p(te.$$.fragment),ct=s(),ae=o("p"),ae.innerHTML=na,ut=s(),le=o("ul"),le.innerHTML=oa,Mt=s(),se=o("p"),se.textContent=ia,wt=s(),ne=o("p"),ne.innerHTML=ra,mt=s(),p(oe.$$.fragment),yt=s(),ie=o("p"),ie.textContent=pa,ft=s(),re=o("p"),re.innerHTML=ha,jt=s(),T=o("blockquote"),T.innerHTML=da,Tt=s(),p(pe.$$.fragment),bt=s(),he=o("p"),he.innerHTML=ca,Jt=s(),de=o("p"),de.innerHTML=ua,gt=s(),p(ce.$$.fragment),kt=s(),ue=o("p"),ue.textContent=Ma,vt=s(),p(Me.$$.fragment),Ut=s(),we=o("p"),we.innerHTML=wa,Ct=s(),me=o("p"),me.innerHTML=ma,$t=s(),ye=o("p"),ye.textContent=ya,It=s(),fe=o("p"),fe.innerHTML=fa,At=s(),je=o("p"),je.innerHTML=ja,xt=s(),p(Te.$$.fragment),_t=s(),be=o("p"),be.textContent=Ta,Bt=s(),Je=o("ul"),Je.innerHTML=ba,Et=s(),ge=o("p"),ge.textContent=Ja,Zt=s(),p(ke.$$.fragment),Wt=s(),Ue=o("p"),this.h()},l(e){const t=Ia("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(a),$e=n(e),ve=i(e,"P",{}),ga(ve).forEach(a),Ie=n(e),h(b.$$.fragment,e),Ae=n(e),h(J.$$.fragment,e),xe=n(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-19nwf8t"&&(f.innerHTML=Rt),_e=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1wyb330"&&(g.textContent=Gt),Be=n(e),h(k.$$.fragment,e),Ee=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1bcy1mu"&&(v.textContent=Lt),Ze=n(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ctihbc"&&(U.innerHTML=St),We=n(e),h(C.$$.fragment,e),He=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-12s8ueu"&&($.innerHTML=Yt),Xe=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-h3jf88"&&(I.innerHTML=Vt),Re=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1hci4od"&&(A.innerHTML=Nt),Ge=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-u9z3jz"&&(x.innerHTML=Qt),Le=n(e),h(_.$$.fragment,e),Se=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1t66uig"&&(B.innerHTML=qt),Ye=n(e),h(E.$$.fragment,e),Ve=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-s51573"&&(Z.textContent=Ft),Ne=n(e),h(W.$$.fragment,e),Qe=n(e),h(H.$$.fragment,e),qe=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-9tm0kz"&&(X.innerHTML=zt),Fe=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ezzxtl"&&(R.innerHTML=Pt),ze=n(e),h(G.$$.fragment,e),Pe=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-wb44jy"&&(L.innerHTML=Dt),De=n(e),h(S.$$.fragment,e),Ke=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-j30v8p"&&(Y.innerHTML=Kt),Oe=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ovf8z6"&&(V.textContent=Ot),et=n(e),h(N.$$.fragment,e),tt=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-165i45h"&&(Q.textContent=ea),at=n(e),h(q.$$.fragment,e),lt=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-11nagum"&&(F.textContent=ta),st=n(e),h(z.$$.fragment,e),nt=n(e),h(P.$$.fragment,e),ot=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-e8zd3l"&&(D.innerHTML=aa),it=n(e),h(K.$$.fragment,e),rt=n(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1p8imxn"&&(j.innerHTML=la),pt=n(e),h(O.$$.fragment,e),ht=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-zhvgkm"&&(ee.textContent=sa),dt=n(e),h(te.$$.fragment,e),ct=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1e62m07"&&(ae.innerHTML=na),ut=n(e),le=i(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-sbl72c"&&(le.innerHTML=oa),Mt=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1kjjv0e"&&(se.textContent=ia),wt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-hnnrra"&&(ne.innerHTML=ra),mt=n(e),h(oe.$$.fragment,e),yt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-447eup"&&(ie.textContent=pa),ft=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1kaon34"&&(re.innerHTML=ha),jt=n(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-yptivr"&&(T.innerHTML=da),Tt=n(e),h(pe.$$.fragment,e),bt=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1dhhtbl"&&(he.innerHTML=ca),Jt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1dkwj91"&&(de.innerHTML=ua),gt=n(e),h(ce.$$.fragment,e),kt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-19m1e7u"&&(ue.textContent=Ma),vt=n(e),h(Me.$$.fragment,e),Ut=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1efoutq"&&(we.innerHTML=wa),Ct=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-pa1g45"&&(me.innerHTML=ma),$t=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1xqf5ir"&&(ye.textContent=ya),It=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-180gk1s"&&(fe.innerHTML=fa),At=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-wrd8fj"&&(je.innerHTML=ja),xt=n(e),h(Te.$$.fragment,e),_t=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-18ft921"&&(be.textContent=Ta),Bt=n(e),Je=i(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-1qp6jfy"&&(Je.innerHTML=ba),Et=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1rk9epj"&&(ge.textContent=Ja),Zt=n(e),h(ke.$$.fragment,e),Wt=n(e),Ue=i(e,"P",{}),ga(Ue).forEach(a),this.h()},h(){Ce(y,"name","hf:doc:metadata"),Ce(y,"content",Ea),Ce(f,"class","tip"),Ce(j,"class","tip"),Ce(T,"class","tip")},m(e,t){Aa(document.head,y),l(e,$e,t),l(e,ve,t),l(e,Ie,t),d(b,e,t),l(e,Ae,t),d(J,e,t),l(e,xe,t),l(e,f,t),l(e,_e,t),l(e,g,t),l(e,Be,t),d(k,e,t),l(e,Ee,t),l(e,v,t),l(e,Ze,t),l(e,U,t),l(e,We,t),d(C,e,t),l(e,He,t),l(e,$,t),l(e,Xe,t),l(e,I,t),l(e,Re,t),l(e,A,t),l(e,Ge,t),l(e,x,t),l(e,Le,t),d(_,e,t),l(e,Se,t),l(e,B,t),l(e,Ye,t),d(E,e,t),l(e,Ve,t),l(e,Z,t),l(e,Ne,t),d(W,e,t),l(e,Qe,t),d(H,e,t),l(e,qe,t),l(e,X,t),l(e,Fe,t),l(e,R,t),l(e,ze,t),d(G,e,t),l(e,Pe,t),l(e,L,t),l(e,De,t),d(S,e,t),l(e,Ke,t),l(e,Y,t),l(e,Oe,t),l(e,V,t),l(e,et,t),d(N,e,t),l(e,tt,t),l(e,Q,t),l(e,at,t),d(q,e,t),l(e,lt,t),l(e,F,t),l(e,st,t),d(z,e,t),l(e,nt,t),d(P,e,t),l(e,ot,t),l(e,D,t),l(e,it,t),d(K,e,t),l(e,rt,t),l(e,j,t),l(e,pt,t),d(O,e,t),l(e,ht,t),l(e,ee,t),l(e,dt,t),d(te,e,t),l(e,ct,t),l(e,ae,t),l(e,ut,t),l(e,le,t),l(e,Mt,t),l(e,se,t),l(e,wt,t),l(e,ne,t),l(e,mt,t),d(oe,e,t),l(e,yt,t),l(e,ie,t),l(e,ft,t),l(e,re,t),l(e,jt,t),l(e,T,t),l(e,Tt,t),d(pe,e,t),l(e,bt,t),l(e,he,t),l(e,Jt,t),l(e,de,t),l(e,gt,t),d(ce,e,t),l(e,kt,t),l(e,ue,t),l(e,vt,t),d(Me,e,t),l(e,Ut,t),l(e,we,t),l(e,Ct,t),l(e,me,t),l(e,$t,t),l(e,ye,t),l(e,It,t),l(e,fe,t),l(e,At,t),l(e,je,t),l(e,xt,t),d(Te,e,t),l(e,_t,t),l(e,be,t),l(e,Bt,t),l(e,Je,t),l(e,Et,t),l(e,ge,t),l(e,Zt,t),d(ke,e,t),l(e,Wt,t),l(e,Ue,t),Ht=!0},p:va,i(e){Ht||(c(b.$$.fragment,e),c(J.$$.fragment,e),c(k.$$.fragment,e),c(C.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(G.$$.fragment,e),c(S.$$.fragment,e),c(N.$$.fragment,e),c(q.$$.fragment,e),c(z.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(Te.$$.fragment,e),c(ke.$$.fragment,e),Ht=!0)},o(e){u(b.$$.fragment,e),u(J.$$.fragment,e),u(k.$$.fragment,e),u(C.$$.fragment,e),u(_.$$.fragment,e),u(E.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(G.$$.fragment,e),u(S.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(ke.$$.fragment,e),Ht=!1},d(e){e&&(a($e),a(ve),a(Ie),a(Ae),a(xe),a(f),a(_e),a(g),a(Be),a(Ee),a(v),a(Ze),a(U),a(We),a(He),a($),a(Xe),a(I),a(Re),a(A),a(Ge),a(x),a(Le),a(Se),a(B),a(Ye),a(Ve),a(Z),a(Ne),a(Qe),a(qe),a(X),a(Fe),a(R),a(ze),a(Pe),a(L),a(De),a(Ke),a(Y),a(Oe),a(V),a(et),a(tt),a(Q),a(at),a(lt),a(F),a(st),a(nt),a(ot),a(D),a(it),a(rt),a(j),a(pt),a(ht),a(ee),a(dt),a(ct),a(ae),a(ut),a(le),a(Mt),a(se),a(wt),a(ne),a(mt),a(yt),a(ie),a(ft),a(re),a(jt),a(T),a(Tt),a(bt),a(he),a(Jt),a(de),a(gt),a(kt),a(ue),a(vt),a(Ut),a(we),a(Ct),a(me),a($t),a(ye),a(It),a(fe),a(At),a(je),a(xt),a(_t),a(be),a(Bt),a(Je),a(Et),a(ge),a(Zt),a(Wt),a(Ue)),a(y),M(b,e),M(J,e),M(k,e),M(C,e),M(_,e),M(E,e),M(W,e),M(H,e),M(G,e),M(S,e),M(N,e),M(q,e),M(z,e),M(P,e),M(K,e),M(O,e),M(te,e),M(oe,e),M(pe,e),M(ce,e),M(Me,e),M(Te,e),M(ke,e)}}}const Ea='{"title":"Webhook guide: Setup an automatic metadata quality review for models and datasets","local":"webhook-guide-setup-an-automatic-metadata-quality-review-for-models-and-datasets","sections":[{"title":"What are we building and why?","local":"what-are-we-building-and-why","sections":[],"depth":2},{"title":"Using the Hub Client Library to create a model review card","local":"using-the-hub-client-library-to-create-a-model-review-card","sections":[],"depth":2},{"title":"Creating our metadata review report","local":"creating-our-metadata-review-report","sections":[],"depth":2},{"title":"How to post the review automatically?","local":"how-to-post-the-review-automatically","sections":[],"depth":2},{"title":"Creating a Webhook to respond to changes on the Hub","local":"creating-a-webhook-to-respond-to-changes-on-the-hub","sections":[],"depth":2},{"title":"Create a Webhook in your user profile","local":"create-a-webhook-in-your-user-profile","sections":[],"depth":2},{"title":"Create a new Bot user profile","local":"create-a-new-bot-user-profile","sections":[],"depth":2},{"title":"Create a Webhook listener","local":"create-a-webhook-listener","sections":[],"depth":2},{"title":"Use Spaces to deploy our Webhook app","local":"use-spaces-to-deploy-our-webhook-app","sections":[],"depth":2},{"title":"Conclusion and next steps","local":"conclusion-and-next-steps","sections":[],"depth":2}],"depth":1}';function Za(Xt){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class La extends Ca{constructor(y){super(),$a(this,y,Za,Ba,ka,{})}}export{La as component};
