import{s as Nt,n as St,o as zt}from"../chunks/scheduler.9cda857a.js";import{S as Qt,i as Pt,e as i,s as n,c as r,h as At,a as o,d as s,b as a,f as qt,g as d,j as p,k as ye,l as Kt,m as l,n as f,t as m,o as c,p as h}from"../chunks/index.003612b0.js";import{C as Ot}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as ce}from"../chunks/CodeBlock.a90632f1.js";import{H as u,E as es}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function ts(yt){let y,Me,he,ge,j,Ue,w,je,M,Mt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/DDUF/DDUF-Banner.svg"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/DDUF/DDUF-Banner-dark.svg"/>',we,b,be,T,gt="DDUF (<strong>D</strong>DUF’s <strong>D</strong>iffusion <strong>U</strong>nified <strong>F</strong>ormat) is a single-file format for diffusion models that aims to unify the different model distribution methods and weight-saving formats by packaging all model components into a single file. It is language-agnostic and built to be parsable from a remote location without downloading the entire file.",Te,v,Ut='This work draws inspiration from the <a href="https://github.com/ggerganov/ggml/blob/master/docs/gguf.md" rel="nofollow">GGUF</a> format.',ve,Z,jt='Check out the <a href="https://huggingface.co/DDUF" rel="nofollow">DDUF</a> org to start using some of the most popular diffusion models in DDUF.',Ze,g,wt='<p>We welcome contributions with open arms!</p> <p>To create a widely adopted file format, we need early feedback from the community. Nothing is set in stone, and we value everyone’s input. Is your use case not covered? Please let us know in the DDUF organization <a href="https://huggingface.co/spaces/DDUF/README/discussions/2" rel="nofollow">discussions</a>.</p>',$e,$,bt="Its key features include the following.",Je,J,Tt='<li><strong>Single file</strong> packaging.</li> <li>Based on <strong>ZIP file format</strong> to leverage existing tooling.</li> <li>No compression, ensuring <strong><code>mmap</code> compatibility</strong> for fast loading and saving.</li> <li><strong>Language-agnostic</strong>: tooling can be implemented in Python, JavaScript, Rust, C++, etc.</li> <li><strong>HTTP-friendly</strong>: metadata and file structure can be fetched remotely using HTTP Range requests.</li> <li><strong>Flexible</strong>: each model component is stored in its own directory, following the current Diffusers structure.</li> <li><strong>Safe</strong>: uses <a href="https://huggingface.co/docs/diffusers/using-diffusers/other-formats#safetensors" rel="nofollow">Safetensors</a> as a weight-saving format and prohibits nested directories to prevent ZIP bombs.</li>',_e,_,Ge,G,vt='Technically, a <code>.dduf</code> file <strong>is</strong> a <a href="https://en.wikipedia.org/wiki/ZIP_(file_format)" rel="nofollow"><code>.zip</code> archive</a>. By building on a universally supported file format, we ensure robust tooling already exists. However, some constraints are enforced to meet diffusion models’ requirements:',ke,k,Zt="<li>Data must be stored uncompressed (flag <code>0</code>), allowing lazy-loading using memory-mapping.</li> <li>Data must be stored using ZIP64 protocol, enabling saving files above 4GB.</li> <li>The archive can only contain <code>.json</code>, <code>.safetensors</code>, <code>.model</code> and <code>.txt</code> files.</li> <li>A <code>model_index.json</code> file must be present at the root of the archive. It must contain a key-value mapping with metadata about the model and its components.</li> <li>Each component must be stored in its own directory (e.g., <code>vae/</code>, <code>text_encoder/</code>). Nested files must use UNIX-style path separators (<code>/</code>).</li> <li>Each directory must correspond to a component in the <code>model_index.json</code> index.</li> <li>Each directory must contain a json config file (one of <code>config.json</code>, <code>tokenizer_config.json</code>, <code>preprocessor_config.json</code>, <code>scheduler_config.json</code>).</li> <li>Sub-directories are forbidden.</li>",Ce,C,$t='Want to check if your file is valid? Check it out using this Space: <a href="https://huggingface.co/spaces/DDUF/dduf-check" rel="nofollow">https://huggingface.co/spaces/DDUF/dduf-check</a>.',De,D,xe,x,Jt="The <code>huggingface_hub</code> provides tooling to handle DDUF files in Python. It includes built-in rules to validate file integrity and helpers to read and export DDUF files. The goal is to see this tooling adopted in the Python ecosystem, such as in the <code>diffusers</code> integration. Similar tooling can be developed for other languages (JavaScript, Rust, C++, etc.).",Ie,I,Fe,F,_t='Pass a path to <code>read_dduf_file</code> to read a DDUF file. Only the metadata is read, meaning this is a lightweight call that won’t explode your memory. In the example below, we consider that you’ve already downloaded the <a href="https://huggingface.co/DDUF/FLUX.1-dev-DDUF/blob/main/FLUX.1-dev.dduf" rel="nofollow"><code>FLUX.1-dev.dduf</code></a> file locally.',We,W,Re,R,Gt="<code>read_dduf_file</code> returns a mapping where each entry corresponds to a file in the DDUF archive. A file is represented by a <code>DDUFEntry</code> dataclass that contains the filename, offset, and length of the entry in the original DDUF file. This information is useful to read its content without loading the whole file. In practice, you won’t have to handle low-level reading but rely on helpers instead.",Le,L,kt="For instance, here is how to load the <code>model_index.json</code> content:",He,H,Be,B,Ct="For binary files, you’ll want to access the raw bytes using <code>as_mmap</code>. This returns bytes as a memory-mapping on the original file. The memory-mapping allows you to read only the bytes you need without loading everything in memory. For instance, here is how to load safetensors weights:",Ve,V,Ee,U,Dt="<p><code>as_mmap</code> must be used in a context manager to benefit from the memory-mapping properties.</p>",Xe,E,Ye,X,xt="Pass a folder path to <code>export_folder_as_dduf</code> to export a DDUF file.",qe,Y,Ne,q,It="This tool scans the folder, adds the relevant entries and ensures the exported file is valid. If anything goes wrong during the process, a <code>DDUFExportError</code> is raised.",Se,N,Ft="For more flexibility, use [<code>export_entries_as_dduf</code>] to explicitly specify a list of files to include in the final DDUF file:",ze,S,Qe,z,Wt="<code>export_entries_as_dduf</code> works well if you’ve already saved your model on the disk. But what if you have a model loaded in memory and want to serialize it directly into a DDUF file? <code>export_entries_as_dduf</code> lets you do that by providing a Python <code>generator</code> that tells how to serialize the data iteratively:",Pe,Q,Ae,P,Ke,A,Rt="Diffusers has a built-in integration for DDUF files. Here is an example on how to load a pipeline from a stored checkpoint on the Hub:",Oe,K,et,O,tt,ee,st,te,Lt="ZIP provides several advantages:",lt,se,Ht="<li>Universally supported file format</li> <li>No additional dependencies for reading</li> <li>Built-in file indexing</li> <li>Wide language support</li>",nt,le,at,ne,Bt='See the explanation in this <a href="https://github.com/huggingface/huggingface_hub/pull/2692#issuecomment-2519863726" rel="nofollow">comment</a>.',it,ae,ot,ie,Vt="<li>Enables direct memory mapping of large files</li> <li>Ensures consistent and predictable remote file access</li> <li>Prevents CPU overhead during file reading</li> <li>Maintains compatibility with safetensors</li>",pt,oe,rt,pe,Et="No. For now, DDUF files are designed to be immutable. To update a model, create a new DDUF file.",dt,re,ft,de,Xt='<li><a href="https://github.com/huggingface/diffusers" rel="nofollow">Diffusers</a></li>',mt,fe,Yt='We are constantly reaching out to other libraries and frameworks. If you are interested in adding support to your project, open a Discussion in the <a href="https://huggingface.co/spaces/DDUF/README/discussions" rel="nofollow">DDUF org</a>.',ct,me,ht,ue,ut;return j=new Ot({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new u({props:{title:"DDUF",local:"dduf",headingTag:"h1"}}),b=new u({props:{title:"Overview",local:"overview",headingTag:"h2"}}),_=new u({props:{title:"Technical specifications",local:"technical-specifications",headingTag:"h2"}}),D=new u({props:{title:"Usage",local:"usage",headingTag:"h2"}}),I=new u({props:{title:"How to read a DDUF file?",local:"how-to-read-a-dduf-file",headingTag:"h3"}}),W=new ce({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlYWRfZGR1Zl9maWxlJTBBJTBBZGR1Zl9lbnRyaWVzJTIwJTNEJTIwcmVhZF9kZHVmX2ZpbGUoJTIyRkxVWC4xLWRldi5kZHVmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> read_dduf_file

<span class="hljs-comment"># Read DDUF metadata</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dduf_entries = read_dduf_file(<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>)`,wrap:!1}}),H=new ce({props:{code:"aW1wb3J0JTIwanNvbiUwQWpzb24ubG9hZHMoZGR1Zl9lbnRyaWVzJTVCJTIybW9kZWxfaW5kZXguanNvbiUyMiU1RC5yZWFkX3RleHQoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(dduf_entries[<span class="hljs-string">&quot;model_index.json&quot;</span>].read_text())
{<span class="hljs-string">&#x27;_class_name&#x27;</span>: <span class="hljs-string">&#x27;FluxPipeline&#x27;</span>, <span class="hljs-string">&#x27;_diffusers_version&#x27;</span>: <span class="hljs-string">&#x27;0.32.0.dev0&#x27;</span>, <span class="hljs-string">&#x27;_name_or_path&#x27;</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>, ...`,wrap:!1}}),V=new ce({props:{code:"aW1wb3J0JTIwc2FmZXRlbnNvcnMudG9yY2glMEF3aXRoJTIwZGR1Zl9lbnRyaWVzJTVCJTIydmFlJTJGZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuc2FmZXRlbnNvcnMlMjIlNUQuYXNfbW1hcCgpJTIwYXMlMjBtbSUzQSUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjBzYWZldGVuc29ycy50b3JjaC5sb2FkKG1tKSUyMCUyMyUyMCU2MG1tJTYwJTIwaXMlMjBhJTIwYnl0ZXMlMjBvYmplY3Q=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> safetensors.torch\n<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> dduf_entries[<span class="hljs-string">&quot;vae/diffusion_pytorch_model.safetensors&quot;</span>].as_mmap() <span class="hljs-keyword">as</span> mm:\n<span class="hljs-meta">... </span>    state_dict = safetensors.torch.load(mm) <span class="hljs-comment"># `mm` is a bytes object</span>',wrap:!1}}),E=new u({props:{title:"How to write a DDUF file?",local:"how-to-write-a-dduf-file",headingTag:"h3"}}),Y=new ce({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGV4cG9ydF9mb2xkZXJfYXNfZGR1ZiUwQWV4cG9ydF9mb2xkZXJfYXNfZGR1ZiglMjJGTFVYLjEtZGV2LmRkdWYlMjIlMkMlMjBmb2xkZXJfcGF0aCUzRCUyMnBhdGglMkZ0byUyRkZMVVguMS1kZXYlMjIp",highlighted:`<span class="hljs-comment"># Export a folder as a DDUF file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> export_folder_as_dduf
<span class="hljs-meta">&gt;&gt;&gt; </span>export_folder_as_dduf(<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>, folder_path=<span class="hljs-string">&quot;path/to/FLUX.1-dev&quot;</span>)`,wrap:!1}}),S=new ce({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGV4cG9ydF9lbnRyaWVzX2FzX2RkdWYlMEFleHBvcnRfZW50cmllc19hc19kZHVmKCUwQSUyMCUyMCUyMCUyMGRkdWZfcGF0aCUzRCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNC1GUDE2LmRkdWYlMjIlMkMlMEElMjAlMjAlMjAlMjBlbnRyaWVzJTNEJTVCJTIwJTIzJTIwTGlzdCUyMGVudHJpZXMlMjB0byUyMGFkZCUyMHRvJTIwdGhlJTIwRERVRiUyMGZpbGUlMjAoaGVyZSUyQyUyMG9ubHklMjBGUDE2JTIwd2VpZ2h0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJTIybW9kZWxfaW5kZXguanNvbiUyMiUyQyUyMCUyMnBhdGglMkZ0byUyRm1vZGVsX2luZGV4Lmpzb24lMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCUyMnZhZSUyRmNvbmZpZy5qc29uJTIyJTJDJTIwJTIycGF0aCUyRnRvJTJGdmFlJTJGY29uZmlnLmpzb24lMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCUyMnZhZSUyRmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmZwMTYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJwYXRoJTJGdG8lMkZ2YWUlMkZkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5mcDE2LnNhZmV0ZW5zb3JzJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJ0ZXh0X2VuY29kZXIlMkZjb25maWcuanNvbiUyMiUyQyUyMCUyMnBhdGglMkZ0byUyRnRleHRfZW5jb2RlciUyRmNvbmZpZy5qc29uJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJ0ZXh0X2VuY29kZXIlMkZtb2RlbC5mcDE2LnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTIycGF0aCUyRnRvJTJGdGV4dF9lbmNvZGVyJTJGbW9kZWwuZnAxNi5zYWZldGVuc29ycyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBhZGQlMjBtb3JlJTIwZW50cmllcyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-comment"># Export specific files from the local disk.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> export_entries_as_dduf
<span class="hljs-meta">&gt;&gt;&gt; </span>export_entries_as_dduf(
<span class="hljs-meta">... </span>    dduf_path=<span class="hljs-string">&quot;stable-diffusion-v1-4-FP16.dduf&quot;</span>,
<span class="hljs-meta">... </span>    entries=[ <span class="hljs-comment"># List entries to add to the DDUF file (here, only FP16 weights)</span>
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;model_index.json&quot;</span>, <span class="hljs-string">&quot;path/to/model_index.json&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;vae/config.json&quot;</span>, <span class="hljs-string">&quot;path/to/vae/config.json&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;vae/diffusion_pytorch_model.fp16.safetensors&quot;</span>, <span class="hljs-string">&quot;path/to/vae/diffusion_pytorch_model.fp16.safetensors&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;text_encoder/config.json&quot;</span>, <span class="hljs-string">&quot;path/to/text_encoder/config.json&quot;</span>),
<span class="hljs-meta">... </span>        (<span class="hljs-string">&quot;text_encoder/model.fp16.safetensors&quot;</span>, <span class="hljs-string">&quot;path/to/text_encoder/model.fp16.safetensors&quot;</span>),
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ... add more entries here</span>
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new ce({props:{code:"JTBBZGVmJTIwYXNfZW50cmllcyhwaXBlJTNBJTIwRGlmZnVzaW9uUGlwZWxpbmUpJTIwLSUzRSUyMEdlbmVyYXRvciU1QlR1cGxlJTVCc3RyJTJDJTIwYnl0ZXMlNUQlMkMlMjBOb25lJTJDJTIwTm9uZSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEJ1aWxkJTIwYSUyMGdlbmVyYXRvciUyMHRoYXQlMjB5aWVsZHMlMjB0aGUlMjBlbnRyaWVzJTIwdG8lMjBhZGQlMjB0byUyMHRoZSUyMEREVUYlMjBmaWxlLiUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGZpcnN0JTIwZWxlbWVudCUyMG9mJTIwdGhlJTIwdHVwbGUlMjBpcyUyMHRoZSUyMGZpbGVuYW1lJTIwaW4lMjB0aGUlMjBERFVGJTIwYXJjaGl2ZS4lMjBUaGUlMjBzZWNvbmQlMjBlbGVtZW50JTIwaXMlMjB0aGUlMjBjb250ZW50JTIwb2YlMjB0aGUlMjBmaWxlLiUwQSUyMCUyMCUyMCUyMCUyMyUyMEVudHJpZXMlMjB3aWxsJTIwYmUlMjBldmFsdWF0ZWQlMjBsYXppbHklMjB3aGVuJTIwdGhlJTIwRERVRiUyMGZpbGUlMjBpcyUyMGNyZWF0ZWQlMjAob25seSUyMDElMjBlbnRyeSUyMGlzJTIwbG9hZGVkJTIwaW4lMjBtZW1vcnklMjBhdCUyMGElMjB0aW1lKSUwQSUyMCUyMCUyMCUyMHlpZWxkJTIwJTIydmFlJTJGY29uZmlnLmpzb24lMjIlMkMlMjBwaXBlLnZhZS50b19qc29uX3N0cmluZygpLmVuY29kZSgpJTBBJTIwJTIwJTIwJTIweWllbGQlMjAlMjJ2YWUlMkZkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5zYWZldGVuc29ycyUyMiUyQyUyMHNhZmV0ZW5zb3JzLnRvcmNoLnNhdmUocGlwZS52YWUuc3RhdGVfZGljdCgpKSUwQSUyMCUyMCUyMCUyMHlpZWxkJTIwJTIydGV4dF9lbmNvZGVyJTJGY29uZmlnLmpzb24lMjIlMkMlMjBwaXBlLnRleHRfZW5jb2Rlci5jb25maWcudG9fanNvbl9zdHJpbmcoKS5lbmNvZGUoKSUwQSUyMCUyMCUyMCUyMHlpZWxkJTIwJTIydGV4dF9lbmNvZGVyJTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIlMkMlMjBzYWZldGVuc29ycy50b3JjaC5zYXZlKHBpcGUudGV4dF9lbmNvZGVyLnN0YXRlX2RpY3QoKSklMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBhZGQlMjBtb3JlJTIwZW50cmllcyUyMGhlcmUlMEElMEFleHBvcnRfZW50cmllc19hc19kZHVmKGRkdWZfcGF0aCUzRCUyMm15LWNvb2wtZGlmZnVzaW9uLW1vZGVsLmRkdWYlMjIlMkMlMjBlbnRyaWVzJTNEYXNfZW50cmllcyhwaXBlKSk=",highlighted:`(...)

<span class="hljs-comment"># Export state_dicts one by one from a loaded pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">as_entries</span>(<span class="hljs-params">pipe: DiffusionPipeline</span>) -&gt; Generator[<span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bytes</span>], <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Build a generator that yields the entries to add to the DDUF file.</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The first element of the tuple is the filename in the DDUF archive. The second element is the content of the file.</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Entries will be evaluated lazily when the DDUF file is created (only 1 entry is loaded in memory at a time)</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;vae/config.json&quot;</span>, pipe.vae.to_json_string().encode()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;vae/diffusion_pytorch_model.safetensors&quot;</span>, safetensors.torch.save(pipe.vae.state_dict())
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;text_encoder/config.json&quot;</span>, pipe.text_encoder.config.to_json_string().encode()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;text_encoder/model.safetensors&quot;</span>, safetensors.torch.save(pipe.text_encoder.state_dict())
<span class="hljs-meta">... </span>    <span class="hljs-comment"># ... add more entries here</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>export_entries_as_dduf(dduf_path=<span class="hljs-string">&quot;my-cool-diffusion-model.dduf&quot;</span>, entries=as_entries(pipe))`,wrap:!1}}),P=new u({props:{title:"Loading a DDUF file with Diffusers",local:"loading-a-dduf-file-with-diffusers",headingTag:"h3"}}),K=new ce({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkREVUYlMkZGTFVYLjEtZGV2LUREVUYlMjIlMkMlMjBkZHVmX2ZpbGUlM0QlMjJGTFVYLjEtZGV2LmRkdWYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJwaG90byUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMERpZmZ1c2VycyUyMiUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMy41JTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;DDUF/FLUX.1-dev-DDUF&quot;</span>, dduf_file=<span class="hljs-string">&quot;FLUX.1-dev.dduf&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipe(
    <span class="hljs-string">&quot;photo a cat holding a sign that says Diffusers&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">3.5</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),O=new u({props:{title:"F.A.Q.",local:"faq",headingTag:"h2"}}),ee=new u({props:{title:"Why build on top of ZIP?",local:"why-build-on-top-of-zip",headingTag:"h3"}}),le=new u({props:{title:"Why not use a TAR with a table of contents at the beginning of the archive?",local:"why-not-use-a-tar-with-a-table-of-contents-at-the-beginning-of-the-archive",headingTag:"h3"}}),ae=new u({props:{title:"Why no compression?",local:"why-no-compression",headingTag:"h3"}}),oe=new u({props:{title:"Can I modify a DDUF file?",local:"can-i-modify-a-dduf-file",headingTag:"h3"}}),re=new u({props:{title:"Which frameworks/apps support DDUFs?",local:"which-frameworksapps-support-ddufs",headingTag:"h3"}}),me=new es({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/dduf.md"}}),{c(){y=i("meta"),Me=n(),he=i("p"),ge=n(),r(j.$$.fragment),Ue=n(),r(w.$$.fragment),je=n(),M=i("div"),M.innerHTML=Mt,we=n(),r(b.$$.fragment),be=n(),T=i("p"),T.innerHTML=gt,Te=n(),v=i("p"),v.innerHTML=Ut,ve=n(),Z=i("p"),Z.innerHTML=jt,Ze=n(),g=i("blockquote"),g.innerHTML=wt,$e=n(),$=i("p"),$.textContent=bt,Je=n(),J=i("ol"),J.innerHTML=Tt,_e=n(),r(_.$$.fragment),Ge=n(),G=i("p"),G.innerHTML=vt,ke=n(),k=i("ul"),k.innerHTML=Zt,Ce=n(),C=i("p"),C.innerHTML=$t,De=n(),r(D.$$.fragment),xe=n(),x=i("p"),x.innerHTML=Jt,Ie=n(),r(I.$$.fragment),Fe=n(),F=i("p"),F.innerHTML=_t,We=n(),r(W.$$.fragment),Re=n(),R=i("p"),R.innerHTML=Gt,Le=n(),L=i("p"),L.innerHTML=kt,He=n(),r(H.$$.fragment),Be=n(),B=i("p"),B.innerHTML=Ct,Ve=n(),r(V.$$.fragment),Ee=n(),U=i("blockquote"),U.innerHTML=Dt,Xe=n(),r(E.$$.fragment),Ye=n(),X=i("p"),X.innerHTML=xt,qe=n(),r(Y.$$.fragment),Ne=n(),q=i("p"),q.innerHTML=It,Se=n(),N=i("p"),N.innerHTML=Ft,ze=n(),r(S.$$.fragment),Qe=n(),z=i("p"),z.innerHTML=Wt,Pe=n(),r(Q.$$.fragment),Ae=n(),r(P.$$.fragment),Ke=n(),A=i("p"),A.textContent=Rt,Oe=n(),r(K.$$.fragment),et=n(),r(O.$$.fragment),tt=n(),r(ee.$$.fragment),st=n(),te=i("p"),te.textContent=Lt,lt=n(),se=i("ul"),se.innerHTML=Ht,nt=n(),r(le.$$.fragment),at=n(),ne=i("p"),ne.innerHTML=Bt,it=n(),r(ae.$$.fragment),ot=n(),ie=i("ul"),ie.innerHTML=Vt,pt=n(),r(oe.$$.fragment),rt=n(),pe=i("p"),pe.textContent=Et,dt=n(),r(re.$$.fragment),ft=n(),de=i("ul"),de.innerHTML=Xt,mt=n(),fe=i("p"),fe.innerHTML=Yt,ct=n(),r(me.$$.fragment),ht=n(),ue=i("p"),this.h()},l(e){const t=At("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),Me=a(e),he=o(e,"P",{}),qt(he).forEach(s),ge=a(e),d(j.$$.fragment,e),Ue=a(e),d(w.$$.fragment,e),je=a(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-uwodo1"&&(M.innerHTML=Mt),we=a(e),d(b.$$.fragment,e),be=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-7klt1s"&&(T.innerHTML=gt),Te=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-16sdl9o"&&(v.innerHTML=Ut),ve=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-umdzam"&&(Z.innerHTML=jt),Ze=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-1hccti0"&&(g.innerHTML=wt),$e=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-5akq1a"&&($.textContent=bt),Je=a(e),J=o(e,"OL",{"data-svelte-h":!0}),p(J)!=="svelte-5rkj06"&&(J.innerHTML=Tt),_e=a(e),d(_.$$.fragment,e),Ge=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-ym2fu5"&&(G.innerHTML=vt),ke=a(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1c0l6r6"&&(k.innerHTML=Zt),Ce=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-ewlv6m"&&(C.innerHTML=$t),De=a(e),d(D.$$.fragment,e),xe=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1y6ujs0"&&(x.innerHTML=Jt),Ie=a(e),d(I.$$.fragment,e),Fe=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-61z4jx"&&(F.innerHTML=_t),We=a(e),d(W.$$.fragment,e),Re=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-3tn1oa"&&(R.innerHTML=Gt),Le=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1p2f8zq"&&(L.innerHTML=kt),He=a(e),d(H.$$.fragment,e),Be=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-143uvwp"&&(B.innerHTML=Ct),Ve=a(e),d(V.$$.fragment,e),Ee=a(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-f8vsyb"&&(U.innerHTML=Dt),Xe=a(e),d(E.$$.fragment,e),Ye=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1wt9r80"&&(X.innerHTML=xt),qe=a(e),d(Y.$$.fragment,e),Ne=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-umutob"&&(q.innerHTML=It),Se=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1qiwegn"&&(N.innerHTML=Ft),ze=a(e),d(S.$$.fragment,e),Qe=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-82mgo8"&&(z.innerHTML=Wt),Pe=a(e),d(Q.$$.fragment,e),Ae=a(e),d(P.$$.fragment,e),Ke=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1yk4tz4"&&(A.textContent=Rt),Oe=a(e),d(K.$$.fragment,e),et=a(e),d(O.$$.fragment,e),tt=a(e),d(ee.$$.fragment,e),st=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-jn7vtl"&&(te.textContent=Lt),lt=a(e),se=o(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-k91t7b"&&(se.innerHTML=Ht),nt=a(e),d(le.$$.fragment,e),at=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-nx5ek0"&&(ne.innerHTML=Bt),it=a(e),d(ae.$$.fragment,e),ot=a(e),ie=o(e,"UL",{"data-svelte-h":!0}),p(ie)!=="svelte-g8evt1"&&(ie.innerHTML=Vt),pt=a(e),d(oe.$$.fragment,e),rt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-2hybhj"&&(pe.textContent=Et),dt=a(e),d(re.$$.fragment,e),ft=a(e),de=o(e,"UL",{"data-svelte-h":!0}),p(de)!=="svelte-11bupfp"&&(de.innerHTML=Xt),mt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1niq24m"&&(fe.innerHTML=Yt),ct=a(e),d(me.$$.fragment,e),ht=a(e),ue=o(e,"P",{}),qt(ue).forEach(s),this.h()},h(){ye(y,"name","hf:doc:metadata"),ye(y,"content",ss),ye(M,"class","flex justify-center"),ye(g,"class","tip"),ye(U,"class","tip")},m(e,t){Kt(document.head,y),l(e,Me,t),l(e,he,t),l(e,ge,t),f(j,e,t),l(e,Ue,t),f(w,e,t),l(e,je,t),l(e,M,t),l(e,we,t),f(b,e,t),l(e,be,t),l(e,T,t),l(e,Te,t),l(e,v,t),l(e,ve,t),l(e,Z,t),l(e,Ze,t),l(e,g,t),l(e,$e,t),l(e,$,t),l(e,Je,t),l(e,J,t),l(e,_e,t),f(_,e,t),l(e,Ge,t),l(e,G,t),l(e,ke,t),l(e,k,t),l(e,Ce,t),l(e,C,t),l(e,De,t),f(D,e,t),l(e,xe,t),l(e,x,t),l(e,Ie,t),f(I,e,t),l(e,Fe,t),l(e,F,t),l(e,We,t),f(W,e,t),l(e,Re,t),l(e,R,t),l(e,Le,t),l(e,L,t),l(e,He,t),f(H,e,t),l(e,Be,t),l(e,B,t),l(e,Ve,t),f(V,e,t),l(e,Ee,t),l(e,U,t),l(e,Xe,t),f(E,e,t),l(e,Ye,t),l(e,X,t),l(e,qe,t),f(Y,e,t),l(e,Ne,t),l(e,q,t),l(e,Se,t),l(e,N,t),l(e,ze,t),f(S,e,t),l(e,Qe,t),l(e,z,t),l(e,Pe,t),f(Q,e,t),l(e,Ae,t),f(P,e,t),l(e,Ke,t),l(e,A,t),l(e,Oe,t),f(K,e,t),l(e,et,t),f(O,e,t),l(e,tt,t),f(ee,e,t),l(e,st,t),l(e,te,t),l(e,lt,t),l(e,se,t),l(e,nt,t),f(le,e,t),l(e,at,t),l(e,ne,t),l(e,it,t),f(ae,e,t),l(e,ot,t),l(e,ie,t),l(e,pt,t),f(oe,e,t),l(e,rt,t),l(e,pe,t),l(e,dt,t),f(re,e,t),l(e,ft,t),l(e,de,t),l(e,mt,t),l(e,fe,t),l(e,ct,t),f(me,e,t),l(e,ht,t),l(e,ue,t),ut=!0},p:St,i(e){ut||(m(j.$$.fragment,e),m(w.$$.fragment,e),m(b.$$.fragment,e),m(_.$$.fragment,e),m(D.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(H.$$.fragment,e),m(V.$$.fragment,e),m(E.$$.fragment,e),m(Y.$$.fragment,e),m(S.$$.fragment,e),m(Q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),ut=!0)},o(e){c(j.$$.fragment,e),c(w.$$.fragment,e),c(b.$$.fragment,e),c(_.$$.fragment,e),c(D.$$.fragment,e),c(I.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),ut=!1},d(e){e&&(s(Me),s(he),s(ge),s(Ue),s(je),s(M),s(we),s(be),s(T),s(Te),s(v),s(ve),s(Z),s(Ze),s(g),s($e),s($),s(Je),s(J),s(_e),s(Ge),s(G),s(ke),s(k),s(Ce),s(C),s(De),s(xe),s(x),s(Ie),s(Fe),s(F),s(We),s(Re),s(R),s(Le),s(L),s(He),s(Be),s(B),s(Ve),s(Ee),s(U),s(Xe),s(Ye),s(X),s(qe),s(Ne),s(q),s(Se),s(N),s(ze),s(Qe),s(z),s(Pe),s(Ae),s(Ke),s(A),s(Oe),s(et),s(tt),s(st),s(te),s(lt),s(se),s(nt),s(at),s(ne),s(it),s(ot),s(ie),s(pt),s(rt),s(pe),s(dt),s(ft),s(de),s(mt),s(fe),s(ct),s(ht),s(ue)),s(y),h(j,e),h(w,e),h(b,e),h(_,e),h(D,e),h(I,e),h(W,e),h(H,e),h(V,e),h(E,e),h(Y,e),h(S,e),h(Q,e),h(P,e),h(K,e),h(O,e),h(ee,e),h(le,e),h(ae,e),h(oe,e),h(re,e),h(me,e)}}}const ss='{"title":"DDUF","local":"dduf","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Technical specifications","local":"technical-specifications","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"How to read a DDUF file?","local":"how-to-read-a-dduf-file","sections":[],"depth":3},{"title":"How to write a DDUF file?","local":"how-to-write-a-dduf-file","sections":[],"depth":3},{"title":"Loading a DDUF file with Diffusers","local":"loading-a-dduf-file-with-diffusers","sections":[],"depth":3}],"depth":2},{"title":"F.A.Q.","local":"faq","sections":[{"title":"Why build on top of ZIP?","local":"why-build-on-top-of-zip","sections":[],"depth":3},{"title":"Why not use a TAR with a table of contents at the beginning of the archive?","local":"why-not-use-a-tar-with-a-table-of-contents-at-the-beginning-of-the-archive","sections":[],"depth":3},{"title":"Why no compression?","local":"why-no-compression","sections":[],"depth":3},{"title":"Can I modify a DDUF file?","local":"can-i-modify-a-dduf-file","sections":[],"depth":3},{"title":"Which frameworks/apps support DDUFs?","local":"which-frameworksapps-support-ddufs","sections":[],"depth":3}],"depth":2}],"depth":1}';function ls(yt){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends Qt{constructor(y){super(),Pt(this,y,ls,ts,Nt,{})}}export{rs as component};
