# Security

The Hugging Face Hub offers several security features to ensure that your code and data are secure. Beyond offering [private repositories](./repositories-settings#private-repositories) for models, datasets, and Spaces, the Hub supports access tokens, resource groups, MFA, commit signatures, malware scanning, and more.

Hugging Face is GDPR compliant. If a contract or specific data storage is something you'll need, we recommend taking a look at our [Enterprise Hub Support](https://huggingface.co/support). Hugging Face can also offer Business Associate Addendums or GDPR data processing agreements through an [Enterprise Plan](https://huggingface.co/pricing). 

Hugging Face is also [SOC2 Type 2 certified](https://us.aicpa.org/interestareas/frc/assuranceadvisoryservices/aicpasoc2report.html), meaning we provide security certification to our customers and actively monitor and patch any security weaknesses.

<img width="150" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-soc-1.jpg">

For any other security questions, please feel free to send us an email at security@huggingface.co.

## Contents

- [User Access Tokens](./security-tokens)
- [Two-Factor Authentication (2FA)](./security-2fa)
- [Git over SSH](./security-git-ssh)
- [Signing commits with GPG](./security-gpg)
- [Single Sign-On (SSO)](./security-sso)
- [Advanced Access Control (Resource Groups)](./security-resource-groups)
- [Malware Scanning](./security-malware)
- [Pickle Scanning](./security-pickle)
- [Secrets Scanning](./security-secrets)
- [Third-party scanner: Protect AI](./security-protectai)
- [Third-party scanner: JFrog](./security-jfrog)


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/security.md" />