import{s as Je,a as je,n as Ie,o as Ue}from"../chunks/scheduler.3d32dc09.js";import{S as qe,i as Se,e as i,s as l,c as h,h as Ge,a,d as n,b as s,f as He,g as d,j as r,k as st,l as We,m as o,n as f,t as c,o as g,p as w}from"../chunks/index.f9718211.js";import{C as Be,H as it,E as Ee}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.70a1e6b5.js";import{C as Re}from"../chunks/CodeBlock.d4b513b9.js";function Oe(Qt){let u,at,ot,rt,y,ut,v,pt,x,mt,b,Dt="Any efficient system using AI will need to provide LLMs some kind of access to the real world: for instance the possibility to call a search tool to get external information, or to act on certain programs in order to solve a task. In other words, LLMs should have <strong><em>agency</em></strong>. Agentic programs are the gateway to the outside world for LLMs.",ht,p,Kt="<p>AI Agents are <strong>programs where LLM outputs control the workflow</strong>.</p>",dt,M,te="Any system leveraging LLMs will integrate the LLM outputs into code. The influence of the LLM’s input on the code workflow is the level of agency of LLMs in the system.",ft,L,ee="Note that with this definition, “agent” is not a discrete, 0 or 1 definition: instead, “agency” evolves on a continuous spectrum, as you give more or less power to the LLM on your workflow.",ct,C,ne="See in the table below how agency can vary across systems:",gt,_,oe="<thead><tr><th>Agency Level</th> <th>Description</th> <th>Short name</th> <th>Example Code</th></tr></thead> <tbody><tr><td>☆☆☆</td> <td>LLM output has no impact on program flow</td> <td>Simple processor</td> <td><code>process_llm_output(llm_response)</code></td></tr> <tr><td>★☆☆</td> <td>LLM output controls an if/else switch</td> <td>Router</td> <td><code>if llm_decision(): path_a() else: path_b()</code></td></tr> <tr><td>★★☆</td> <td>LLM output controls function execution</td> <td>Tool call</td> <td><code>run_function(llm_chosen_tool, llm_chosen_args)</code></td></tr> <tr><td>★★☆</td> <td>LLM output controls iteration and program continuation</td> <td>Multi-step Agent</td> <td><code>while llm_should_continue(): execute_next_step()</code></td></tr> <tr><td>★★★</td> <td>One agentic workflow can start another agentic workflow</td> <td>Multi-Agent</td> <td><code>if llm_trigger(): execute_agent()</code></td></tr> <tr><td>★★★</td> <td>LLM acts in code, can define its own tools / start other agents</td> <td>Code Agents</td> <td><code>def custom_tool(args): ...</code></td></tr></tbody>",wt,k,le="The multi-step agent has this code structure:",yt,T,vt,$,se="This agentic system runs in a loop, executing a new action at each step (the action can involve calling some pre-determined <em>tools</em> that are just functions), until its observations make it apparent that a satisfactory state has been reached to solve the given task. Here’s an example of how a multi-step agent can solve a simple math question:",xt,m,ie='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif"/>',bt,A,Mt,P,ae=`Agents are useful when you need an LLM to determine the workflow of an app. But they’re often overkill. The question is: do I really need flexibility in the workflow to efficiently solve the task at hand?
If the pre-determined workflow falls short too often, that means you need more flexibility.
Let’s take an example: say you’re making an app that handles customer requests on a surfing trip website.`,Lt,H,re="You could know in advance that the requests will belong to either of 2 buckets (based on user choice), and you have a predefined workflow for each of these 2 cases.",Ct,J,ue="<li>Want some knowledge on the trips? ⇒ give them access to a search bar to search your knowledge base</li> <li>Wants to talk to sales? ⇒ let them type in a contact form.</li>",_t,j,pe="If that deterministic workflow fits all queries, by all means just code everything! This will give you a 100% reliable system with no risk of error introduced by letting unpredictable LLMs meddle in your workflow. For the sake of simplicity and robustness, it’s advised to regularize towards not using any agentic behaviour.",kt,I,me="But what if the workflow can’t be determined that well in advance?",Tt,U,he="For instance, a user wants to ask: <code>&quot;I can come on Monday, but I forgot my passport so risk being delayed to Wednesday, is it possible to take me and my stuff to surf on Tuesday morning, with a cancellation insurance?&quot;</code> This question hinges on many factors, and probably none of the predetermined criteria above will suffice for this request.",$t,q,de="If the pre-determined workflow falls short too often, that means you need more flexibility.",At,S,fe="That is where an agentic setup helps.",Pt,G,ce="In the above example, you could just make a multi-step agent that has access to a weather API for weather forecasts, Google Maps API to compute travel distance, an employee availability dashboard and a RAG system on your knowledge base.",Ht,W,ge="Until recently, computer programs were restricted to pre-determined workflows, trying to handle complexity by piling up  if/else switches. They focused on extremely narrow tasks, like “compute the sum of these numbers” or “find the shortest path in this graph”. But actually, most real-life tasks, like our trip example above, do not fit in pre-determined workflows. Agentic systems open up the vast world of real-world tasks to programs!",Jt,B,jt,E,we="For some low-level agentic use cases, like chains or routers, you can write all the code yourself. You’ll be much better that way, since it will let you control and understand your system better.",It,R,ye="But once you start going for more complicated behaviours like letting an LLM call a function (that’s “tool calling”) or letting an LLM run a while loop (“multi-step agent”), some abstractions become necessary:",Ut,O,ve="<li>For tool calling, you need to parse the agent’s output, so this output needs a predefined format like “Thought: I should call tool ‘get_weather’. Action: get_weather(Paris).”, that you parse with a predefined function, and system prompt given to the LLM should notify it about this format.</li> <li>For a multi-step agent where the LLM output determines the loop, you need to give a different prompt to the LLM based on what happened in the last loop iteration: so you need some kind of memory.</li>",qt,V,xe="See? With these two examples, we already found the need for a few items to help us:",St,z,be="<li>Of course, an LLM that acts as the engine powering the system</li> <li>A list of tools that the agent can access</li> <li>A system prompt guiding the LLM on the agent logic: ReAct loop of Reflection -&gt; Action -&gt; Observation, available tools, tool calling format to use…</li> <li>A parser that extracts tool calls from the LLM output, in the format indicated by system prompt above.</li> <li>A memory</li>",Gt,N,Me="But wait, since we give room to LLMs in decisions, surely they will make mistakes: so we need error logging and retry mechanisms.",Wt,F,Le="All these elements need tight coupling to make a well-functioning system. That’s why we decided we needed to make basic building blocks to make all this stuff work together.",Bt,X,Et,Y,Ce="In a multi-step agent, at each step, the LLM can write an action, in the form of some calls to external tools. A common format (used by Anthropic, OpenAI, and many others) for writing these actions is generally different shades of “writing actions as a JSON of tools names and arguments to use, which you then parse to know which tool to execute and with which arguments”.",Rt,Z,_e='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLMs actions written as code snippets is a more natural and flexible way of writing them.',Ot,Q,ke=`The reason for this simply that <em>we crafted our code languages specifically to express the actions performed by a computer</em>.
In other words, our agent is going to write programs in order to solve the user’s issues : do you think their programming will be easier in blocks of Python or JSON?`,Vt,D,Te='The figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>, illustrates some advantages of writing actions in code:',zt,nt,$e,Nt,K,Ae="Writing actions in code rather than JSON-like snippets provides better:",Ft,tt,Pe="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training data:</strong> plenty of quality code actions are already included in LLMs’ training data which means they’re already trained for this!</li>",Xt,et,Yt,lt,Zt;return y=new Be({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new it({props:{title:"What are agents? 🤔",local:"what-are-agents-",headingTag:"h1"}}),x=new it({props:{title:"An introduction to agentic systems.",local:"an-introduction-to-agentic-systems",headingTag:"h2"}}),T=new Re({props:{code:"bWVtb3J5JTIwJTNEJTIwJTVCdXNlcl9kZWZpbmVkX3Rhc2slNUQlMEF3aGlsZSUyMGxsbV9zaG91bGRfY29udGludWUobWVtb3J5KSUzQSUyMCUyMyUyMHRoaXMlMjBsb29wJTIwaXMlMjB0aGUlMjBtdWx0aS1zdGVwJTIwcGFydCUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGxsbV9nZXRfbmV4dF9hY3Rpb24obWVtb3J5KSUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMHRvb2wtY2FsbGluZyUyMHBhcnQlMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbnMlMjAlM0QlMjBleGVjdXRlX2FjdGlvbihhY3Rpb24pJTBBJTIwJTIwJTIwJTIwbWVtb3J5JTIwJTJCJTNEJTIwJTVCYWN0aW9uJTJDJTIwb2JzZXJ2YXRpb25zJTVE",highlighted:`memory = [user_defined_task]
<span class="hljs-keyword">while</span> llm_should_continue(memory): <span class="hljs-comment"># this loop is the multi-step part</span>
    action = llm_get_next_action(memory) <span class="hljs-comment"># this is the tool-calling part</span>
    observations = execute_action(action)
    memory += [action, observations]`,wrap:!1}}),A=new it({props:{title:"✅ When to use agents / ⛔ when to avoid them",local:"-when-to-use-agents---when-to-avoid-them",headingTag:"h2"}}),B=new it({props:{title:"Why smolagents ?",local:"why-smolagents-",headingTag:"h2"}}),X=new it({props:{title:"Code agents",local:"code-agents",headingTag:"h2"}}),et=new Ee({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/conceptual_guides/intro_agents.md"}}),{c(){u=i("meta"),at=l(),ot=i("p"),rt=l(),h(y.$$.fragment),ut=l(),h(v.$$.fragment),pt=l(),h(x.$$.fragment),mt=l(),b=i("p"),b.innerHTML=Dt,ht=l(),p=i("blockquote"),p.innerHTML=Kt,dt=l(),M=i("p"),M.textContent=te,ft=l(),L=i("p"),L.textContent=ee,ct=l(),C=i("p"),C.textContent=ne,gt=l(),_=i("table"),_.innerHTML=oe,wt=l(),k=i("p"),k.textContent=le,yt=l(),h(T.$$.fragment),vt=l(),$=i("p"),$.innerHTML=se,xt=l(),m=i("div"),m.innerHTML=ie,bt=l(),h(A.$$.fragment),Mt=l(),P=i("p"),P.textContent=ae,Lt=l(),H=i("p"),H.textContent=re,Ct=l(),J=i("ol"),J.innerHTML=ue,_t=l(),j=i("p"),j.textContent=pe,kt=l(),I=i("p"),I.textContent=me,Tt=l(),U=i("p"),U.innerHTML=he,$t=l(),q=i("p"),q.textContent=de,At=l(),S=i("p"),S.textContent=fe,Pt=l(),G=i("p"),G.textContent=ce,Ht=l(),W=i("p"),W.textContent=ge,Jt=l(),h(B.$$.fragment),jt=l(),E=i("p"),E.textContent=we,It=l(),R=i("p"),R.textContent=ye,Ut=l(),O=i("ul"),O.innerHTML=ve,qt=l(),V=i("p"),V.textContent=xe,St=l(),z=i("ul"),z.innerHTML=be,Gt=l(),N=i("p"),N.textContent=Me,Wt=l(),F=i("p"),F.textContent=Le,Bt=l(),h(X.$$.fragment),Et=l(),Y=i("p"),Y.textContent=Ce,Rt=l(),Z=i("p"),Z.innerHTML=_e,Ot=l(),Q=i("p"),Q.innerHTML=ke,Vt=l(),D=i("p"),D.innerHTML=Te,zt=l(),nt=i("img"),Nt=l(),K=i("p"),K.textContent=Ae,Ft=l(),tt=i("ul"),tt.innerHTML=Pe,Xt=l(),h(et.$$.fragment),Yt=l(),lt=i("p"),this.h()},l(t){const e=Ge("svelte-u9bgzb",document.head);u=a(e,"META",{name:!0,content:!0}),e.forEach(n),at=s(t),ot=a(t,"P",{}),He(ot).forEach(n),rt=s(t),d(y.$$.fragment,t),ut=s(t),d(v.$$.fragment,t),pt=s(t),d(x.$$.fragment,t),mt=s(t),b=a(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-t8xwkl"&&(b.innerHTML=Dt),ht=s(t),p=a(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-12jgvf4"&&(p.innerHTML=Kt),dt=s(t),M=a(t,"P",{"data-svelte-h":!0}),r(M)!=="svelte-hvpo8l"&&(M.textContent=te),ft=s(t),L=a(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ocrk28"&&(L.textContent=ee),ct=s(t),C=a(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-15ep98q"&&(C.textContent=ne),gt=s(t),_=a(t,"TABLE",{"data-svelte-h":!0}),r(_)!=="svelte-167gmr2"&&(_.innerHTML=oe),wt=s(t),k=a(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1xdd6c8"&&(k.textContent=le),yt=s(t),d(T.$$.fragment,t),vt=s(t),$=a(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1n725h4"&&($.innerHTML=se),xt=s(t),m=a(t,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-znws87"&&(m.innerHTML=ie),bt=s(t),d(A.$$.fragment,t),Mt=s(t),P=a(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1vnvz56"&&(P.textContent=ae),Lt=s(t),H=a(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16gbieh"&&(H.textContent=re),Ct=s(t),J=a(t,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-1v0rus5"&&(J.innerHTML=ue),_t=s(t),j=a(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-d38gnh"&&(j.textContent=pe),kt=s(t),I=a(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-16wqlg"&&(I.textContent=me),Tt=s(t),U=a(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1qwedk6"&&(U.innerHTML=he),$t=s(t),q=a(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-j2eqzu"&&(q.textContent=de),At=s(t),S=a(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-lqbq6n"&&(S.textContent=fe),Pt=s(t),G=a(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-eus48c"&&(G.textContent=ce),Ht=s(t),W=a(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-4d8m3z"&&(W.textContent=ge),Jt=s(t),d(B.$$.fragment,t),jt=s(t),E=a(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1o6p1sy"&&(E.textContent=we),It=s(t),R=a(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-olr701"&&(R.textContent=ye),Ut=s(t),O=a(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-5j7kqn"&&(O.innerHTML=ve),qt=s(t),V=a(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-19q6xk9"&&(V.textContent=xe),St=s(t),z=a(t,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-fxlju7"&&(z.innerHTML=be),Gt=s(t),N=a(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-95dd5s"&&(N.textContent=Me),Wt=s(t),F=a(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-19mjig0"&&(F.textContent=Le),Bt=s(t),d(X.$$.fragment,t),Et=s(t),Y=a(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1i79ci0"&&(Y.textContent=Ce),Rt=s(t),Z=a(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-qdqtni"&&(Z.innerHTML=_e),Ot=s(t),Q=a(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ysoq7h"&&(Q.innerHTML=ke),Vt=s(t),D=a(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1k33473"&&(D.innerHTML=Te),zt=s(t),nt=a(t,"IMG",{src:!0}),Nt=s(t),K=a(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-18lekkw"&&(K.textContent=Ae),Ft=s(t),tt=a(t,"UL",{"data-svelte-h":!0}),r(tt)!=="svelte-1qmn0c3"&&(tt.innerHTML=Pe),Xt=s(t),d(et.$$.fragment,t),Yt=s(t),lt=a(t,"P",{}),He(lt).forEach(n),this.h()},h(){st(u,"name","hf:doc:metadata"),st(u,"content",Ve),st(p,"class","tip"),st(m,"class","flex justify-center"),je(nt.src,$e="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||st(nt,"src",$e)},m(t,e){We(document.head,u),o(t,at,e),o(t,ot,e),o(t,rt,e),f(y,t,e),o(t,ut,e),f(v,t,e),o(t,pt,e),f(x,t,e),o(t,mt,e),o(t,b,e),o(t,ht,e),o(t,p,e),o(t,dt,e),o(t,M,e),o(t,ft,e),o(t,L,e),o(t,ct,e),o(t,C,e),o(t,gt,e),o(t,_,e),o(t,wt,e),o(t,k,e),o(t,yt,e),f(T,t,e),o(t,vt,e),o(t,$,e),o(t,xt,e),o(t,m,e),o(t,bt,e),f(A,t,e),o(t,Mt,e),o(t,P,e),o(t,Lt,e),o(t,H,e),o(t,Ct,e),o(t,J,e),o(t,_t,e),o(t,j,e),o(t,kt,e),o(t,I,e),o(t,Tt,e),o(t,U,e),o(t,$t,e),o(t,q,e),o(t,At,e),o(t,S,e),o(t,Pt,e),o(t,G,e),o(t,Ht,e),o(t,W,e),o(t,Jt,e),f(B,t,e),o(t,jt,e),o(t,E,e),o(t,It,e),o(t,R,e),o(t,Ut,e),o(t,O,e),o(t,qt,e),o(t,V,e),o(t,St,e),o(t,z,e),o(t,Gt,e),o(t,N,e),o(t,Wt,e),o(t,F,e),o(t,Bt,e),f(X,t,e),o(t,Et,e),o(t,Y,e),o(t,Rt,e),o(t,Z,e),o(t,Ot,e),o(t,Q,e),o(t,Vt,e),o(t,D,e),o(t,zt,e),o(t,nt,e),o(t,Nt,e),o(t,K,e),o(t,Ft,e),o(t,tt,e),o(t,Xt,e),f(et,t,e),o(t,Yt,e),o(t,lt,e),Zt=!0},p:Ie,i(t){Zt||(c(y.$$.fragment,t),c(v.$$.fragment,t),c(x.$$.fragment,t),c(T.$$.fragment,t),c(A.$$.fragment,t),c(B.$$.fragment,t),c(X.$$.fragment,t),c(et.$$.fragment,t),Zt=!0)},o(t){g(y.$$.fragment,t),g(v.$$.fragment,t),g(x.$$.fragment,t),g(T.$$.fragment,t),g(A.$$.fragment,t),g(B.$$.fragment,t),g(X.$$.fragment,t),g(et.$$.fragment,t),Zt=!1},d(t){t&&(n(at),n(ot),n(rt),n(ut),n(pt),n(mt),n(b),n(ht),n(p),n(dt),n(M),n(ft),n(L),n(ct),n(C),n(gt),n(_),n(wt),n(k),n(yt),n(vt),n($),n(xt),n(m),n(bt),n(Mt),n(P),n(Lt),n(H),n(Ct),n(J),n(_t),n(j),n(kt),n(I),n(Tt),n(U),n($t),n(q),n(At),n(S),n(Pt),n(G),n(Ht),n(W),n(Jt),n(jt),n(E),n(It),n(R),n(Ut),n(O),n(qt),n(V),n(St),n(z),n(Gt),n(N),n(Wt),n(F),n(Bt),n(Et),n(Y),n(Rt),n(Z),n(Ot),n(Q),n(Vt),n(D),n(zt),n(nt),n(Nt),n(K),n(Ft),n(tt),n(Xt),n(Yt),n(lt)),n(u),w(y,t),w(v,t),w(x,t),w(T,t),w(A,t),w(B,t),w(X,t),w(et,t)}}}const Ve='{"title":"What are agents? 🤔","local":"what-are-agents-","sections":[{"title":"An introduction to agentic systems.","local":"an-introduction-to-agentic-systems","sections":[],"depth":2},{"title":"✅ When to use agents / ⛔ when to avoid them","local":"-when-to-use-agents---when-to-avoid-them","sections":[],"depth":2},{"title":"Why smolagents ?","local":"why-smolagents-","sections":[],"depth":2},{"title":"Code agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function ze(Qt){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends qe{constructor(u){super(),Se(this,u,ze,Oe,Je,{})}}export{Ze as component};
