import{s as ue,n as he,o as be}from"../chunks/scheduler.3d32dc09.js";import{S as Je,i as Te,e as M,s as n,c as i,h as ge,a as y,d as t,b as a,f as Ce,g as p,j as o,k as Ll,l as fe,m as s,n as U,t as r,o as j,p as c}from"../chunks/index.f9718211.js";import{C as Ae,H as zl,E as Ie}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.70a1e6b5.js";import{C as w}from"../chunks/CodeBlock.d4b513b9.js";import{D as Be}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function ke(Fl){let d,nl,tl,al,C,Ml,u,yl,h,ol,b,ql="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",il,J,Pl="It will be a simple hierarchy:",pl,T,Ul,g,Dl="Let’s set up this system.",rl,f,Kl="Run the line below to install the required dependencies:",jl,A,cl,I,Ol="Let’s login to HF in order to call Inference Providers:",wl,B,dl,k,le='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen3-Next-80B-A3B-Thinking" rel="nofollow">Qwen/Qwen3-Next-80B-A3B-Thinking</a> using <code>InferenceClientModel</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',ml,m,ee='<p>Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.</p>',Cl,Z,ul,v,hl,G,te='For web browsing, we can already use our native <a href="/docs/smolagents/main/en/reference/default_tools#smolagents.WebSearchTool">WebSearchTool</a> tool to provide a Google search equivalent.',bl,W,se=`But then we will also need to be able to peak into the page found by the <code>WebSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,Jl,S,ne="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",Tl,$,gl,V,ae="Ok, now let’s initialize and test our tool!",fl,E,Al,x,Il,Q,Me="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Bl,_,ye="Which configuration to choose for this agent?",kl,H,oe="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ToolCallingAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_steps</code> to 10.</li>",Zl,X,vl,R,ie="Note that we gave this agent attributes <code>name</code> and <code>description</code>, mandatory attributes to make this agent callable by its manager agent.",Gl,N,pe="Then we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",Wl,Y,Ue="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>CodeAgent</code> will work well.",Sl,L,re="Also, we want to ask a question that involves the current year and does additional data calculations: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;numpy&quot;, &quot;pandas&quot;]</code>, just in case the agent needs these packages.",$l,z,Vl,F,je="That’s all! Now let’s run our system! We select a question that requires both some calculation and research:",El,q,xl,P,ce="We get this report as the answer:",Ql,D,_l,K,we='Seems like we’ll need some sizeable powerplants if the <a href="https://gwern.net/scaling-hypothesis" rel="nofollow">scaling hypothesis</a> continues to hold true.',Hl,O,de="Our agents managed to efficiently collaborate towards solving the task! ✅",Xl,ll,me="💡 You can easily extend this orchestration to more agents: one does the code execution, one the web search, one handles file loadings…",Rl,el,Nl,sl,Yl;return C=new Ae({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new Be({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"}]}}),h=new zl({props:{title:"Orchestrate a multi-agent system 🤖🤝🤖",local:"orchestrate-a-multi-agent-system-",headingTag:"h1"}}),T=new w({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyME1hbmFnZXIlMjBhZ2VudCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0lMkIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfX19fX19fX19fX19fX18lN0NfX19fX19fX19fX19fXyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQUNvZGUlMjBJbnRlcnByZXRlciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBXZWIlMjBTZWFyY2glMjBhZ2VudCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFdlYiUyMFNlYXJjaCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBWaXNpdCUyMHdlYnBhZ2UlMjB0b29s",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
Code Interpreter            +------------------+
    tool                    |<span class="hljs-string"> Web Search agent </span>|
                            +------------------+
                               |<span class="hljs-string">            </span>|
                        Web Search tool     |<span class="hljs-string">
                                   Visit webpage tool</span>`,wrap:!1}}),A=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAnc21vbGFnZW50cyU1QnRvb2xraXQlNUQnJTIwLS11cGdyYWRlJTIwLXE=",highlighted:'!pip install <span class="hljs-string">&#x27;smolagents[toolkit]&#x27;</span> --upgrade -q',wrap:!1}}),B=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),Z=new w({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjMtTmV4dC04MEItQTNCLVRoaW5raW5nJTIy",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>',wrap:!1}}),v=new zl({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h2"}}),$=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = markdownify(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),E=new w({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),x=new zl({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),X=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwV2ViU2VhcmNoVG9vbCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QldlYlNlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX3NlYXJjaF9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyUnVucyUyMHdlYiUyMHNlYXJjaGVzJTIwZm9yJTIweW91LiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    InferenceClientModel,
    WebSearchTool,
)

model = InferenceClientModel(model_id=model_id)

web_agent = ToolCallingAgent(
    tools=[WebSearchTool(), visit_webpage],
    model=model,
    max_steps=<span class="hljs-number">10</span>,
    name=<span class="hljs-string">&quot;web_search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you.&quot;</span>,
)`,wrap:!1}}),z=new w({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1QndlYl9hZ2VudCU1RCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIydGltZSUyMiUyQyUyMCUyMm51bXB5JTIyJTJDJTIwJTIycGFuZGFzJTIyJTVEJTJDJTBBKQ==",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>],
)`,wrap:!1}}),q=new w({props:{code:"YW5zd2VyJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIySWYlMjBMTE0lMjB0cmFpbmluZyUyMGNvbnRpbnVlcyUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUyQyUyMHdoYXQlMjB3b3VsZCUyMGJlJTIwdGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMGluJTIwR1clMjByZXF1aXJlZCUyMHRvJTIwcG93ZXIlMjB0aGUlMjBiaWdnZXN0JTIwdHJhaW5pbmclMjBydW5zJTIwYnklMjAyMDMwJTNGJTIwV2hhdCUyMHdvdWxkJTIwdGhhdCUyMGNvcnJlc3BvbmQlMjB0byUyQyUyMGNvbXBhcmVkJTIwdG8lMjBzb21lJTIwY291bnRyaWVzJTNGJTIwUGxlYXNlJTIwcHJvdmlkZSUyMGElMjBzb3VyY2UlMjBmb3IlMjBhbnklMjBudW1iZXJzJTIwdXNlZC4lMjIp",highlighted:'answer = manager_agent.run(<span class="hljs-string">&quot;If LLM training continues to scale up at the current rhythm until 2030, what would be the electric power in GW required to power the biggest training runs by 2030? What would that correspond to, compared to some countries? Please provide a source for any numbers used.&quot;</span>)',wrap:!1}}),D=new w({props:{code:"QmFzZWQlMjBvbiUyMGN1cnJlbnQlMjBncm93dGglMjBwcm9qZWN0aW9ucyUyMGFuZCUyMGVuZXJneSUyMGNvbnN1bXB0aW9uJTIwZXN0aW1hdGVzJTJDJTIwaWYlMjBMTE0lMjB0cmFpbmluZ3MlMjBjb250aW51ZSUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwJTBBY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUzQSUwQSUwQTEuJTIwVGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMHJlcXVpcmVkJTIwdG8lMjBwb3dlciUyMHRoZSUyMGJpZ2dlc3QlMjB0cmFpbmluZyUyMHJ1bnMlMjBieSUyMDIwMzAlMjB3b3VsZCUyMGJlJTIwYXBwcm94aW1hdGVseSUyMDMwMy43NCUyMEdXJTJDJTIwd2hpY2glMjAlMEF0cmFuc2xhdGVzJTIwdG8lMjBhYm91dCUyMDIlMkM2NjAlMkM3NjIlMjBHV2glMkZ5ZWFyLiUwQSUwQTIuJTIwQ29tcGFyaW5nJTIwdGhpcyUyMHRvJTIwY291bnRyaWVzJyUyMGVsZWN0cmljaXR5JTIwY29uc3VtcHRpb24lM0ElMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwZXF1aXZhbGVudCUyMHRvJTIwYWJvdXQlMjAzNCUyNSUyMG9mJTIwQ2hpbmEncyUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbi4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGV4Y2VlZCUyMHRoZSUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwSW5kaWElMjAoMTg0JTI1KSUyQyUyMFJ1c3NpYSUyMCgyNjclMjUpJTJDJTIwYW5kJTIwSmFwYW4lMjAoMjkxJTI1KS4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwbmVhcmx5JTIwOSUyMHRpbWVzJTIwdGhlJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwY291bnRyaWVzJTIwbGlrZSUyMEl0YWx5JTIwb3IlMjBNZXhpY28uJTBBJTBBMy4lMjBTb3VyY2UlMjBvZiUyMG51bWJlcnMlM0ElMEElMjAlMjAlMjAtJTIwVGhlJTIwaW5pdGlhbCUyMGVzdGltYXRlJTIwb2YlMjA1JTIwR1clMjBmb3IlMjBmdXR1cmUlMjBMTE0lMjB0cmFpbmluZyUyMGNvbWVzJTIwZnJvbSUyMEFXUyUyMENFTyUyME1hdHQlMjBHYXJtYW4uJTBBJTIwJTIwJTIwLSUyMFRoZSUyMGdyb3d0aCUyMHByb2plY3Rpb24lMjB1c2VkJTIwYSUyMENBR1IlMjBvZiUyMDc5LjgwJTI1JTIwZnJvbSUyMG1hcmtldCUyMHJlc2VhcmNoJTIwYnklMjBTcHJpbmdzLiUwQSUyMCUyMCUyMC0lMjBDb3VudHJ5JTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMGRhdGElMjBpcyUyMGZyb20lMjB0aGUlMjBVLlMuJTIwRW5lcmd5JTIwSW5mb3JtYXRpb24lMjBBZG1pbmlzdHJhdGlvbiUyQyUyMHByaW1hcmlseSUyMGZvciUyMHRoZSUyMHllYXIlMjAlMEEyMDIxLg==",highlighted:`Based <span class="hljs-keyword">on</span> current growth projections <span class="hljs-keyword">and</span> energy consumption estimates, <span class="hljs-keyword">if</span> LLM trainings <span class="hljs-keyword">continue</span> <span class="hljs-keyword">to</span> scale up <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> 
current rhythm <span class="hljs-keyword">until</span> <span class="hljs-number">2030</span>:

<span class="hljs-number">1.</span> The electric power required <span class="hljs-keyword">to</span> power <span class="hljs-keyword">the</span> biggest training runs <span class="hljs-keyword">by</span> <span class="hljs-number">2030</span> would be approximately <span class="hljs-number">303.74</span> GW, which 
translates <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">2</span>,<span class="hljs-number">660</span>,<span class="hljs-number">762</span> GWh/<span class="hljs-built_in">year</span>.

<span class="hljs-number">2.</span> Comparing this <span class="hljs-keyword">to</span> countries&#x27; electricity consumption:
   - It would be equivalent <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">34</span>% <span class="hljs-keyword">of</span> China&#x27;s total electricity consumption.
   - It would exceed <span class="hljs-keyword">the</span> total electricity consumption <span class="hljs-keyword">of</span> India (<span class="hljs-number">184</span>%), Russia (<span class="hljs-number">267</span>%), <span class="hljs-keyword">and</span> Japan (<span class="hljs-number">291</span>%).
   - It would be nearly <span class="hljs-number">9</span> <span class="hljs-keyword">times</span> <span class="hljs-keyword">the</span> electricity consumption <span class="hljs-keyword">of</span> countries like Italy <span class="hljs-keyword">or</span> Mexico.

<span class="hljs-number">3.</span> Source <span class="hljs-keyword">of</span> numbers:
   - The initial estimate <span class="hljs-keyword">of</span> <span class="hljs-number">5</span> GW <span class="hljs-keyword">for</span> future LLM training comes <span class="hljs-keyword">from</span> AWS CEO Matt Garman.
   - The growth projection used a CAGR <span class="hljs-keyword">of</span> <span class="hljs-number">79.80</span>% <span class="hljs-keyword">from</span> market research <span class="hljs-keyword">by</span> Springs.
   - Country electricity consumption data <span class="hljs-keyword">is</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> U.S. Energy Information Administration, primarily <span class="hljs-keyword">for</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span> 
<span class="hljs-number">2021.</span>`,wrap:!1}}),el=new Ie({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/multiagents.md"}}),{c(){d=M("meta"),nl=n(),tl=M("p"),al=n(),i(C.$$.fragment),Ml=n(),i(u.$$.fragment),yl=n(),i(h.$$.fragment),ol=n(),b=M("p"),b.innerHTML=ql,il=n(),J=M("p"),J.textContent=Pl,pl=n(),i(T.$$.fragment),Ul=n(),g=M("p"),g.textContent=Dl,rl=n(),f=M("p"),f.textContent=Kl,jl=n(),i(A.$$.fragment),cl=n(),I=M("p"),I.textContent=Ol,wl=n(),i(B.$$.fragment),dl=n(),k=M("p"),k.innerHTML=le,ml=n(),m=M("blockquote"),m.innerHTML=ee,Cl=n(),i(Z.$$.fragment),ul=n(),i(v.$$.fragment),hl=n(),G=M("p"),G.innerHTML=te,bl=n(),W=M("p"),W.innerHTML=se,Jl=n(),S=M("p"),S.innerHTML=ne,Tl=n(),i($.$$.fragment),gl=n(),V=M("p"),V.textContent=ae,fl=n(),i(E.$$.fragment),Al=n(),i(x.$$.fragment),Il=n(),Q=M("p"),Q.innerHTML=Me,Bl=n(),_=M("p"),_.textContent=ye,kl=n(),H=M("ul"),H.innerHTML=oe,Zl=n(),i(X.$$.fragment),vl=n(),R=M("p"),R.innerHTML=ie,Gl=n(),N=M("p"),N.innerHTML=pe,Wl=n(),Y=M("p"),Y.innerHTML=Ue,Sl=n(),L=M("p"),L.innerHTML=re,$l=n(),i(z.$$.fragment),Vl=n(),F=M("p"),F.textContent=je,El=n(),i(q.$$.fragment),xl=n(),P=M("p"),P.textContent=ce,Ql=n(),i(D.$$.fragment),_l=n(),K=M("p"),K.innerHTML=we,Hl=n(),O=M("p"),O.textContent=de,Xl=n(),ll=M("p"),ll.textContent=me,Rl=n(),i(el.$$.fragment),Nl=n(),sl=M("p"),this.h()},l(l){const e=ge("svelte-u9bgzb",document.head);d=y(e,"META",{name:!0,content:!0}),e.forEach(t),nl=a(l),tl=y(l,"P",{}),Ce(tl).forEach(t),al=a(l),p(C.$$.fragment,l),Ml=a(l),p(u.$$.fragment,l),yl=a(l),p(h.$$.fragment,l),ol=a(l),b=y(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-45abwn"&&(b.innerHTML=ql),il=a(l),J=y(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1f6nia6"&&(J.textContent=Pl),pl=a(l),p(T.$$.fragment,l),Ul=a(l),g=y(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1occiln"&&(g.textContent=Dl),rl=a(l),f=y(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-ofrdjq"&&(f.textContent=Kl),jl=a(l),p(A.$$.fragment,l),cl=a(l),I=y(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-gkovew"&&(I.textContent=Ol),wl=a(l),p(B.$$.fragment,l),dl=a(l),k=y(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1pnbpip"&&(k.innerHTML=le),ml=a(l),m=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(m)!=="svelte-1lti5bi"&&(m.innerHTML=ee),Cl=a(l),p(Z.$$.fragment,l),ul=a(l),p(v.$$.fragment,l),hl=a(l),G=y(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ya7t4h"&&(G.innerHTML=te),bl=a(l),W=y(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-128rf40"&&(W.innerHTML=se),Jl=a(l),S=y(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1ms2uj2"&&(S.innerHTML=ne),Tl=a(l),p($.$$.fragment,l),gl=a(l),V=y(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-hbvg5t"&&(V.textContent=ae),fl=a(l),p(E.$$.fragment,l),Al=a(l),p(x.$$.fragment,l),Il=a(l),Q=y(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-5768lo"&&(Q.innerHTML=Me),Bl=a(l),_=y(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-noa5rw"&&(_.textContent=ye),kl=a(l),H=y(l,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-cg2xmz"&&(H.innerHTML=oe),Zl=a(l),p(X.$$.fragment,l),vl=a(l),R=y(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-fbxoqx"&&(R.innerHTML=ie),Gl=a(l),N=y(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-wtigy3"&&(N.innerHTML=pe),Wl=a(l),Y=y(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1lmitd7"&&(Y.innerHTML=Ue),Sl=a(l),L=y(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1ezr7oa"&&(L.innerHTML=re),$l=a(l),p(z.$$.fragment,l),Vl=a(l),F=y(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-90lagx"&&(F.textContent=je),El=a(l),p(q.$$.fragment,l),xl=a(l),P=y(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-tvhx1x"&&(P.textContent=ce),Ql=a(l),p(D.$$.fragment,l),_l=a(l),K=y(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-19s7crl"&&(K.innerHTML=we),Hl=a(l),O=y(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-ollz3q"&&(O.textContent=de),Xl=a(l),ll=y(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-rvy62f"&&(ll.textContent=me),Rl=a(l),p(el.$$.fragment,l),Nl=a(l),sl=y(l,"P",{}),Ce(sl).forEach(t),this.h()},h(){Ll(d,"name","hf:doc:metadata"),Ll(d,"content",Ze),Ll(m,"class","tip")},m(l,e){fe(document.head,d),s(l,nl,e),s(l,tl,e),s(l,al,e),U(C,l,e),s(l,Ml,e),U(u,l,e),s(l,yl,e),U(h,l,e),s(l,ol,e),s(l,b,e),s(l,il,e),s(l,J,e),s(l,pl,e),U(T,l,e),s(l,Ul,e),s(l,g,e),s(l,rl,e),s(l,f,e),s(l,jl,e),U(A,l,e),s(l,cl,e),s(l,I,e),s(l,wl,e),U(B,l,e),s(l,dl,e),s(l,k,e),s(l,ml,e),s(l,m,e),s(l,Cl,e),U(Z,l,e),s(l,ul,e),U(v,l,e),s(l,hl,e),s(l,G,e),s(l,bl,e),s(l,W,e),s(l,Jl,e),s(l,S,e),s(l,Tl,e),U($,l,e),s(l,gl,e),s(l,V,e),s(l,fl,e),U(E,l,e),s(l,Al,e),U(x,l,e),s(l,Il,e),s(l,Q,e),s(l,Bl,e),s(l,_,e),s(l,kl,e),s(l,H,e),s(l,Zl,e),U(X,l,e),s(l,vl,e),s(l,R,e),s(l,Gl,e),s(l,N,e),s(l,Wl,e),s(l,Y,e),s(l,Sl,e),s(l,L,e),s(l,$l,e),U(z,l,e),s(l,Vl,e),s(l,F,e),s(l,El,e),U(q,l,e),s(l,xl,e),s(l,P,e),s(l,Ql,e),U(D,l,e),s(l,_l,e),s(l,K,e),s(l,Hl,e),s(l,O,e),s(l,Xl,e),s(l,ll,e),s(l,Rl,e),U(el,l,e),s(l,Nl,e),s(l,sl,e),Yl=!0},p:he,i(l){Yl||(r(C.$$.fragment,l),r(u.$$.fragment,l),r(h.$$.fragment,l),r(T.$$.fragment,l),r(A.$$.fragment,l),r(B.$$.fragment,l),r(Z.$$.fragment,l),r(v.$$.fragment,l),r($.$$.fragment,l),r(E.$$.fragment,l),r(x.$$.fragment,l),r(X.$$.fragment,l),r(z.$$.fragment,l),r(q.$$.fragment,l),r(D.$$.fragment,l),r(el.$$.fragment,l),Yl=!0)},o(l){j(C.$$.fragment,l),j(u.$$.fragment,l),j(h.$$.fragment,l),j(T.$$.fragment,l),j(A.$$.fragment,l),j(B.$$.fragment,l),j(Z.$$.fragment,l),j(v.$$.fragment,l),j($.$$.fragment,l),j(E.$$.fragment,l),j(x.$$.fragment,l),j(X.$$.fragment,l),j(z.$$.fragment,l),j(q.$$.fragment,l),j(D.$$.fragment,l),j(el.$$.fragment,l),Yl=!1},d(l){l&&(t(nl),t(tl),t(al),t(Ml),t(yl),t(ol),t(b),t(il),t(J),t(pl),t(Ul),t(g),t(rl),t(f),t(jl),t(cl),t(I),t(wl),t(dl),t(k),t(ml),t(m),t(Cl),t(ul),t(hl),t(G),t(bl),t(W),t(Jl),t(S),t(Tl),t(gl),t(V),t(fl),t(Al),t(Il),t(Q),t(Bl),t(_),t(kl),t(H),t(Zl),t(vl),t(R),t(Gl),t(N),t(Wl),t(Y),t(Sl),t(L),t($l),t(Vl),t(F),t(El),t(xl),t(P),t(Ql),t(_l),t(K),t(Hl),t(O),t(Xl),t(ll),t(Rl),t(Nl),t(sl)),t(d),c(C,l),c(u,l),c(h,l),c(T,l),c(A,l),c(B,l),c(Z,l),c(v,l),c($,l),c(E,l),c(x,l),c(X,l),c(z,l),c(q,l),c(D,l),c(el,l)}}}const Ze='{"title":"Orchestrate a multi-agent system 🤖🤝🤖","local":"orchestrate-a-multi-agent-system-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":2},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function ve(Fl){return be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends Je{constructor(d){super(),Te(this,d,ve,ke,ue,{})}}export{Ee as component};
