import{s as Fa,o as Wa,n as Ba}from"../chunks/scheduler.bdbef820.js";import{S as Ca,i as Xa,g as o,s,r as p,A as Na,h as d,f as e,c as n,j as Ya,u as r,x as M,k as Ia,y as Va,a as l,v as m,d as u,t as c,w as h}from"../chunks/index.c0aea24a.js";import{T as Qa}from"../chunks/Tip.31005f7d.js";import{C as x}from"../chunks/CodeBlock.6ccca92e.js";import{H as q}from"../chunks/Heading.2eb892cb.js";function xa(D){let i,J='For more information about creating your own <code>AudioFolder</code> dataset, take a look at the <a href="./audio_dataset">Create an audio dataset</a> guide.';return{c(){i=o("p"),i.innerHTML=J},l(f){i=d(f,"P",{"data-svelte-h":!0}),M(i)!=="svelte-13t5t9f"&&(i.innerHTML=J)},m(f,H){l(f,i,H)},p:Ba,d(f){f&&e(i)}}}function Ha(D){let i,J,f,H,U,L,g,ga=`You can load an audio dataset using the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature that automatically decodes and resamples the audio files when you access the examples.
Audio decoding is based on the <a href="https://github.com/bastibe/python-soundfile" rel="nofollow"><code>soundfile</code></a> python package, which uses the <a href="https://github.com/libsndfile/libsndfile" rel="nofollow"><code>libsndfile</code></a> C library under the hood.`,A,T,E,j,Ta=`To work with audio datasets, you need to have the <code>audio</code> dependencies installed.
Check out the <a href="./installation#audio">installation</a> guide to learn how to install it.`,P,w,O,k,ja='You can load your own dataset using the paths to your audio files. Use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function to take a column of audio file paths, and cast it to the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature:',K,G,aa,Z,ta,b,wa="You can also load a dataset with an <code>AudioFolder</code> dataset builder. It does not require writing a custom dataloader, making it useful for quickly creating and loading audio datasets with several thousand audio files.",ea,$,la,z,ka="To link your audio files with metadata information, make sure your dataset has a <code>metadata.csv</code> file. Your dataset structure might look like:",sa,_,na,R,Ga="Your <code>metadata.csv</code> file must have a <code>file_name</code> column which links audio files with their metadata. An example <code>metadata.csv</code> file might look like:",ia,v,oa,Y,Za="<code>AudioFolder</code> will load audio data and create a <code>transcription</code> column containing texts from <code>metadata.csv</code>:",da,I,pa,F,ba="You can load remote datasets from their URLs with the data_files parameter:",ra,W,ma,B,$a="Metadata can also be specified as JSON Lines, in which case use <code>metadata.jsonl</code> as the name of the metadata file. This format is helpful in scenarios when one of the columns is complex, e.g. a list of floats, to avoid parsing errors or reading the complex values as strings.",ua,C,za='To ignore the information in the metadata file, set <code>drop_metadata=True</code> in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',ca,X,ha,N,_a=`If you don’t have a metadata file, <code>AudioFolder</code> automatically infers the label name from the directory name.
If you want to drop automatically created labels, set <code>drop_labels=True</code>.
In this case, your dataset will only contain an audio column:`,Ma,V,fa,y,ya,Q,Ra='For a guide on how to load any type of dataset, take a look at the <a class="underline decoration-sky-400 decoration-2 font-semibold" href="./loading">general loading guide</a>.',Ja,S,Ua;return U=new q({props:{title:"Load audio data",local:"load-audio-data",headingTag:"h1"}}),T=new q({props:{title:"Installation",local:"installation",headingTag:"h2"}}),w=new q({props:{title:"Local files",local:"local-files",headingTag:"h2"}}),G=new x({props:{code:"YXVkaW9fZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmF1ZGlvJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW9fMSUyMiUyQyUyMCUyMnBhdGglMkZ0byUyRmF1ZGlvXzIlMjIlMkMlMjAuLi4lMkMlMjAlMjJwYXRoJTJGdG8lMkZhdWRpb19uJTIyJTVEJTdEKS5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKCkpJTBBYXVkaW9fZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: [<span class="hljs-string">&quot;path/to/audio_1&quot;</span>, <span class="hljs-string">&quot;path/to/audio_2&quot;</span>, ..., <span class="hljs-string">&quot;path/to/audio_n&quot;</span>]}).cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio())
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]
{<span class="hljs-string">&#x27;array&#x27;</span>: array([ <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.00024414</span>, -<span class="hljs-number">0.00024414</span>, ..., -<span class="hljs-number">0.00024414</span>,
         <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        ], dtype=float32),
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;path/to/audio_1&#x27;</span>,
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),Z=new q({props:{title:"AudioFolder",local:"audiofolder",headingTag:"h2"}}),$=new q({props:{title:"AudioFolder with metadata",local:"audiofolder-with-metadata",headingTag:"h2"}}),_=new x({props:{code:"Zm9sZGVyJTJGdHJhaW4lMkZtZXRhZGF0YS5jc3YlMEFmb2xkZXIlMkZ0cmFpbiUyRmZpcnN0X2F1ZGlvX2ZpbGUubXAzJTBBZm9sZGVyJTJGdHJhaW4lMkZzZWNvbmRfYXVkaW9fZmlsZS5tcDMlMEFmb2xkZXIlMkZ0cmFpbiUyRnRoaXJkX2F1ZGlvX2ZpbGUubXAz",highlighted:`folder<span class="hljs-regexp">/train/m</span>etadata.csv
folder<span class="hljs-regexp">/train/</span>first_audio_file.mp3
folder<span class="hljs-regexp">/train/</span>second_audio_file.mp3
folder<span class="hljs-regexp">/train/</span>third_audio_file.mp3`,wrap:!1}}),v=new x({props:{code:"ZmlsZV9uYW1lJTJDdHJhbnNjcmlwdGlvbiUwQWZpcnN0X2F1ZGlvX2ZpbGUubXAzJTJDem5vd3UlMjBzaSVDNCU5OSUyMGR1Y2glMjB6JTIwY2lhJUM1JTgyZW0lMjB6cm8lQzUlOUJuaWUlMjB3JTIwbSVDNSU4Mm9kb2NpYW5laiUyMHdzdGFuaWVzeiUyMHdpb3NuaWUlMjBpJTIwbW8lQzUlQkNlc3olMjBza3V0a2llbSUyMHR5Y2glMjBsZWslQzMlQjN3JTIwdW1pZXJhJUM0JTg3JTIwd3N0YXdhJUM0JTg3JTIwd2llayUyMHdpZWslQzMlQjN3JTIwZGFsZWolMjB0YW0lMjBieSVDNSU4MnklMjBwcnplc3Ryb2dpJTIwamFrJTIwc2lla2ElQzQlODclMjBnJUM1JTgyb3clQzQlOTklMjBqYWslMjBub2dpJTBBc2Vjb25kX2F1ZGlvX2ZpbGUubXAzJTJDanUlQzUlQkMlMjB1JTIwJUM1JUJBd2llcnp5JUM1JTg0Y2ElMjBwb2R3b2olQzMlQjN3JTIwa3IlQzMlQjNsJTIwemFzaWFkYSUyMHByenklMjBuaW0lMjBrc2klQzQlODUlQzUlQkMlQzQlOTl0YSUyMGklMjBwYW5vd2llJTIwcmFkYSUyMGElMjBnZHppZSUyMHd6bmlvcyVDNSU4MnklMjBrciVDNCU4NSVDNSVCQ3klQzUlODIlMjBnYW5layUyMHJ5Y2VyemUlMjBvYm9rJTIwa29jaGFuZWslMjBrciVDMyVCM2wlMjBza2luJUM0JTg1JUM1JTgyJTIwcGFsY2VtJTIwemFjeiVDNCU5OXRvJTIwaWdyenlza28lMEF0aGlyZF9hdWRpb19maWxlLm1wMyUyQ3Bld25pZSUyMGslQzQlOTlkeSVDNSU5QiUyMHclMjBvYiVDNSU4MiVDNCU5OWR6aWUlMjB1Yml0ZSUyMG1pbiVDNCU5OSVDNSU4MnklMjBzemxha2klMjB6YWN6ZWtham15JTIwZHppZSVDNSU4NCUyMGpha2klMjBwbyVDNSU5QmxlbXklMjBzenVrYSVDNCU4NyUyMHdzeiVDNCU5OWR6aWUlMjBkemklQzUlOUIlMjBqdXRybyUyMHBld25pZSUyMGIlQzQlOTlkemllJTIwcG9zJUM1JTgyYWxpJTIwd3N6JUM0JTk5ZHppZSUyMHMlQzUlODJ1Z2klMjBjemVrYWxpJTIwZHppZSVDNSU4NCUyMGklMjBkcnVnaSUyMGdkeSUyMG5pYyUyMG5pZSUyMGRvY3pla2FsaSUyMHolMjBwJUM1JTgyYWN6ZW0lMjBjaGMlQzQlODUlMjBqZWNoYSVDNCU4NyUyMGRhbGk=",highlighted:`file_name,transcription
first_audio_file.mp3,znowu się duch z ciałem zrośnie w młodocianej wstaniesz wiosnie i możesz skutkiem tych leków umierać wstawać wiek wieków dalej tam były przestrogi jak siekać głowę jak nogi
second_audio_file.mp3,już u źwierzyńca podwojów król zasiada przy nim książęta i panowie rada a gdzie wzniosły krążył ganek rycerze obok kochanek król skinął palcem zaczęto igrzysko
third_audio_file.mp3,pewnie kędyś w obłędzie ubite minęły szlaki zaczekajmy dzień jaki poślemy szukać wszędzie dziś jutro pewnie będzie posłali wszędzie sługi czekali dzień i drugi gdy nic nie doczekali z płaczem chcą jechać dali`,wrap:!1}}),I=new x({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhdWRpb2ZvbGRlciUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyJTJGcGF0aCUyRnRvJTJGZm9sZGVyJTIyKSUwQSUyMyUyME9SJTIwYnklMjBzcGVjaWZ5aW5nJTIwdGhlJTIwbGlzdCUyMG9mJTIwZmlsZXMlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmF1ZGlvZm9sZGVyJTIyJTJDJTIwZGF0YV9maWxlcyUzRCU1QiUyMnBhdGglMkZ0byUyRmF1ZGlvXzElMjIlMkMlMjAlMjJwYXRoJTJGdG8lMkZhdWRpb18yJTIyJTJDJTIwLi4uJTJDJTIwJTIycGF0aCUyRnRvJTJGYXVkaW9fbiUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/folder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># OR by specifying the list of files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_files=[<span class="hljs-string">&quot;path/to/audio_1&quot;</span>, <span class="hljs-string">&quot;path/to/audio_2&quot;</span>, ..., <span class="hljs-string">&quot;path/to/audio_n&quot;</span>])`,wrap:!1}}),W=new x({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhdWRpb2ZvbGRlciUyMiUyQyUyMGRhdGFfZmlsZXMlM0QlNUIlMjJodHRwcyUzQSUyRiUyRmZvby5iYXIlMkZhdWRpb18xJTIyJTJDJTIwJTIyaHR0cHMlM0ElMkYlMkZmb28uYmFyJTJGYXVkaW9fMiUyMiUyQyUyMC4uLiUyQyUyMCUyMmh0dHBzJTNBJTJGJTJGZm9vLmJhciUyRmF1ZGlvX24lMjIlNUQlMEElMjMlMjBmb3IlMjBleGFtcGxlJTJDJTIwcGFzcyUyMFNwZWVjaENvbW1hbmRzJTIwYXJjaGl2ZSUzQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyYXVkaW9mb2xkZXIlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTIyaHR0cHMlM0ElMkYlMkZzMy5hbWF6b25hd3MuY29tJTJGZGF0YXNldHMuaHVnZ2luZ2ZhY2UuY28lMkZTcGVlY2hDb21tYW5kcyUyRnYwLjAxJTJGdjAuMDFfdGVzdC50YXIuZ3olMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_files=[<span class="hljs-string">&quot;https://foo.bar/audio_1&quot;</span>, <span class="hljs-string">&quot;https://foo.bar/audio_2&quot;</span>, ..., <span class="hljs-string">&quot;https://foo.bar/audio_n&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, pass SpeechCommands archive:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_files=<span class="hljs-string">&quot;https://s3.amazonaws.com/datasets.huggingface.co/SpeechCommands/v0.01/v0.01_test.tar.gz&quot;</span>)`,wrap:!1}}),X=new x({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhdWRpb2ZvbGRlciUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyJTJGcGF0aCUyRnRvJTJGZm9sZGVyJTIyJTJDJTIwZHJvcF9tZXRhZGF0YSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/folder&quot;</span>, drop_metadata=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new x({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhdWRpb2ZvbGRlciUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyJTJGcGF0aCUyRnRvJTJGZm9sZGVyX3dpdGhvdXRfbWV0YWRhdGElMjIlMkMlMjBkcm9wX2xhYmVscyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/folder_without_metadata&quot;</span>, drop_labels=<span class="hljs-literal">True</span>)`,wrap:!1}}),y=new Qa({props:{$$slots:{default:[xa]},$$scope:{ctx:D}}}),{c(){i=o("meta"),J=s(),f=o("p"),H=s(),p(U.$$.fragment),L=s(),g=o("p"),g.innerHTML=ga,A=s(),p(T.$$.fragment),E=s(),j=o("p"),j.innerHTML=Ta,P=s(),p(w.$$.fragment),O=s(),k=o("p"),k.innerHTML=ja,K=s(),p(G.$$.fragment),aa=s(),p(Z.$$.fragment),ta=s(),b=o("p"),b.innerHTML=wa,ea=s(),p($.$$.fragment),la=s(),z=o("p"),z.innerHTML=ka,sa=s(),p(_.$$.fragment),na=s(),R=o("p"),R.innerHTML=Ga,ia=s(),p(v.$$.fragment),oa=s(),Y=o("p"),Y.innerHTML=Za,da=s(),p(I.$$.fragment),pa=s(),F=o("p"),F.textContent=ba,ra=s(),p(W.$$.fragment),ma=s(),B=o("p"),B.innerHTML=$a,ua=s(),C=o("p"),C.innerHTML=za,ca=s(),p(X.$$.fragment),ha=s(),N=o("p"),N.innerHTML=_a,Ma=s(),p(V.$$.fragment),fa=s(),p(y.$$.fragment),ya=s(),Q=o("p"),Q.innerHTML=Ra,Ja=s(),S=o("p"),this.h()},l(a){const t=Na("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(e),J=n(a),f=d(a,"P",{}),Ya(f).forEach(e),H=n(a),r(U.$$.fragment,a),L=n(a),g=d(a,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1g2r2dt"&&(g.innerHTML=ga),A=n(a),r(T.$$.fragment,a),E=n(a),j=d(a,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1w2j0f6"&&(j.innerHTML=Ta),P=n(a),r(w.$$.fragment,a),O=n(a),k=d(a,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1dl818q"&&(k.innerHTML=ja),K=n(a),r(G.$$.fragment,a),aa=n(a),r(Z.$$.fragment,a),ta=n(a),b=d(a,"P",{"data-svelte-h":!0}),M(b)!=="svelte-xb80yi"&&(b.innerHTML=wa),ea=n(a),r($.$$.fragment,a),la=n(a),z=d(a,"P",{"data-svelte-h":!0}),M(z)!=="svelte-10ikose"&&(z.innerHTML=ka),sa=n(a),r(_.$$.fragment,a),na=n(a),R=d(a,"P",{"data-svelte-h":!0}),M(R)!=="svelte-79nbny"&&(R.innerHTML=Ga),ia=n(a),r(v.$$.fragment,a),oa=n(a),Y=d(a,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-ev3dle"&&(Y.innerHTML=Za),da=n(a),r(I.$$.fragment,a),pa=n(a),F=d(a,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1bgv0g6"&&(F.textContent=ba),ra=n(a),r(W.$$.fragment,a),ma=n(a),B=d(a,"P",{"data-svelte-h":!0}),M(B)!=="svelte-6lifis"&&(B.innerHTML=$a),ua=n(a),C=d(a,"P",{"data-svelte-h":!0}),M(C)!=="svelte-r43656"&&(C.innerHTML=za),ca=n(a),r(X.$$.fragment,a),ha=n(a),N=d(a,"P",{"data-svelte-h":!0}),M(N)!=="svelte-a4opl4"&&(N.innerHTML=_a),Ma=n(a),r(V.$$.fragment,a),fa=n(a),r(y.$$.fragment,a),ya=n(a),Q=d(a,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-12zk6g2"&&(Q.innerHTML=Ra),Ja=n(a),S=d(a,"P",{}),Ya(S).forEach(e),this.h()},h(){Ia(i,"name","hf:doc:metadata"),Ia(i,"content",Sa)},m(a,t){Va(document.head,i),l(a,J,t),l(a,f,t),l(a,H,t),m(U,a,t),l(a,L,t),l(a,g,t),l(a,A,t),m(T,a,t),l(a,E,t),l(a,j,t),l(a,P,t),m(w,a,t),l(a,O,t),l(a,k,t),l(a,K,t),m(G,a,t),l(a,aa,t),m(Z,a,t),l(a,ta,t),l(a,b,t),l(a,ea,t),m($,a,t),l(a,la,t),l(a,z,t),l(a,sa,t),m(_,a,t),l(a,na,t),l(a,R,t),l(a,ia,t),m(v,a,t),l(a,oa,t),l(a,Y,t),l(a,da,t),m(I,a,t),l(a,pa,t),l(a,F,t),l(a,ra,t),m(W,a,t),l(a,ma,t),l(a,B,t),l(a,ua,t),l(a,C,t),l(a,ca,t),m(X,a,t),l(a,ha,t),l(a,N,t),l(a,Ma,t),m(V,a,t),l(a,fa,t),m(y,a,t),l(a,ya,t),l(a,Q,t),l(a,Ja,t),l(a,S,t),Ua=!0},p(a,[t]){const va={};t&2&&(va.$$scope={dirty:t,ctx:a}),y.$set(va)},i(a){Ua||(u(U.$$.fragment,a),u(T.$$.fragment,a),u(w.$$.fragment,a),u(G.$$.fragment,a),u(Z.$$.fragment,a),u($.$$.fragment,a),u(_.$$.fragment,a),u(v.$$.fragment,a),u(I.$$.fragment,a),u(W.$$.fragment,a),u(X.$$.fragment,a),u(V.$$.fragment,a),u(y.$$.fragment,a),Ua=!0)},o(a){c(U.$$.fragment,a),c(T.$$.fragment,a),c(w.$$.fragment,a),c(G.$$.fragment,a),c(Z.$$.fragment,a),c($.$$.fragment,a),c(_.$$.fragment,a),c(v.$$.fragment,a),c(I.$$.fragment,a),c(W.$$.fragment,a),c(X.$$.fragment,a),c(V.$$.fragment,a),c(y.$$.fragment,a),Ua=!1},d(a){a&&(e(J),e(f),e(H),e(L),e(g),e(A),e(E),e(j),e(P),e(O),e(k),e(K),e(aa),e(ta),e(b),e(ea),e(la),e(z),e(sa),e(na),e(R),e(ia),e(oa),e(Y),e(da),e(pa),e(F),e(ra),e(ma),e(B),e(ua),e(C),e(ca),e(ha),e(N),e(Ma),e(fa),e(ya),e(Q),e(Ja),e(S)),e(i),h(U,a),h(T,a),h(w,a),h(G,a),h(Z,a),h($,a),h(_,a),h(v,a),h(I,a),h(W,a),h(X,a),h(V,a),h(y,a)}}}const Sa='{"title":"Load audio data","local":"load-audio-data","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Local files","local":"local-files","sections":[],"depth":2},{"title":"AudioFolder","local":"audiofolder","sections":[],"depth":2},{"title":"AudioFolder with metadata","local":"audiofolder-with-metadata","sections":[],"depth":2}],"depth":1}';function qa(D){return Wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oa extends Ca{constructor(i){super(),Xa(this,i,qa,Ha,Fa,{})}}export{Oa as component};
