import{s as ut,n as ht,o as mt}from"../chunks/scheduler.bdbef820.js";import{S as gt,i as ft,g as o,s as n,r as p,A as yt,h as i,f as a,c as l,j as ne,u as c,x as r,k as Ye,y as d,a as s,v as u,d as h,t as m,w as g}from"../chunks/index.c0aea24a.js";import{C as j}from"../chunks/CodeBlock.6ccca92e.js";import{H as Re}from"../chunks/Heading.2eb892cb.js";function wt(Ne){let w,le,ae,oe,k,ie,v,Qe='Sometimes, you may need to create a dataset if you’re working with your own data. Creating a dataset with 🤗 Datasets confers all the advantages of the library to your dataset: fast loading and processing, <a href="stream">stream enormous datasets</a>, <a href="https://huggingface.co/course/chapter5/4?fw=pt#the-magic-of-memory-mapping" rel="nofollow">memory-mapping</a>, and more. You can easily and rapidly create a dataset with 🤗 Datasets low-code approaches, reducing the time it takes to start training a model. In many cases, it is as easy as <a href="upload_dataset#upload-with-the-hub-ui">dragging and dropping</a> your data files into a dataset repository on the Hub.',re,U,Ve="In this tutorial, you’ll learn how to use 🤗 Datasets low-code methods for creating all types of datasets:",de,_,Se="<li>Folder-based builders for quickly creating an image or audio dataset</li> <li><code>from_</code> methods for creating datasets from local files</li>",pe,$,ce,I,Pe="There are two folder-based builders, <code>ImageFolder</code> and <code>AudioFolder</code>. These are low-code methods for quickly creating an image or speech and audio dataset with several thousand examples. They are great for rapidly prototyping computer vision and speech models before scaling to a larger dataset. Folder-based builders takes your data and automatically generates the dataset’s features, splits, and labels. Under the hood:",ue,G,De='<li><code>ImageFolder</code> uses the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> feature to decode an image file. Many image extension formats are supported, such as jpg and png, but other formats are also supported. You can check the complete <a href="https://github.com/huggingface/datasets/blob/b5672a956d5de864e6f5550e493527d962d6ae55/src/datasets/packaged_modules/imagefolder/imagefolder.py#L39" rel="nofollow">list</a> of supported image extensions.</li> <li><code>AudioFolder</code> uses the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature to decode an audio file. Audio extensions such as wav and mp3 are supported, and you can check the complete <a href="https://github.com/huggingface/datasets/blob/b5672a956d5de864e6f5550e493527d962d6ae55/src/datasets/packaged_modules/audiofolder/audiofolder.py#L39" rel="nofollow">list</a> of supported audio extensions.</li>',he,q,Ee="The dataset splits are generated from the repository structure, and the label names are automatically inferred from the directory name.",me,Z,Ae="For example, if your image dataset (it is the same for an audio dataset) is stored like this:",ge,C,fe,x,Ke="Then this is how the folder-based builder generates an example:",ye,J,Oe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/folder-based-builder.png"/>',we,R,et='Create the image dataset by specifying <code>imagefolder</code> in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',Je,F,Te,X,tt='An audio dataset is created in the same way, except you specify <code>audiofolder</code> in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> instead:',be,B,Me,W,at="Any additional information about your dataset, such as text captions or transcriptions, can be included with a <code>metadata.csv</code> file in the folder containing your dataset. The metadata file needs to have a <code>file_name</code> column that links the image or audio file to its corresponding metadata:",je,H,ke,z,st='To learn more about each of these folder-based builders, check out the and <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder"><span class="underline decoration-yellow-400 decoration-2 font-semibold">ImageFolder</span></a> or <a href="https://huggingface.co/docs/datasets/audio_dataset#audiofolder"><span class="underline decoration-pink-400 decoration-2 font-semibold">AudioFolder</span></a> guides.',ve,L,Ue,Y,nt="You can also create a dataset from local files by specifying the path to the data files. There are two ways you can create a dataset using the <code>from_</code> methods:",_e,T,f,K,lt='The <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_generator">from_generator()</a> method is the most memory-efficient way to create a dataset from a <a href="https://wiki.python.org/moin/Generators" rel="nofollow">generator</a> due to a generators iterative behavior. This is especially useful when you’re working with a really large dataset that may not fit in memory, since the dataset is generated on disk progressively and then memory-mapped.',Fe,N,Xe,O,ot='A generator-based <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> needs to be iterated over with a <code>for</code> loop for example:',Be,Q,We,y,ee,it='The <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_dict">from_dict()</a> method is a straightforward way to create a dataset from a dictionary:',He,V,ze,te,rt='To create an image or audio dataset, chain the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> method with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_dict">from_dict()</a> and specify the column and feature type. For example, to create an audio dataset:',Le,S,$e,P,Ie,D,dt="We didn’t mention this in the tutorial, but you can also create a dataset with a loading script. A loading script is a more manual and code-intensive method for creating a dataset, but it also gives you the most flexibility and control over how a dataset is generated. It lets you configure additional options such as creating multiple configurations within a dataset, or enabling your dataset to be streamed.",Ge,E,pt='To learn more about how to write loading scripts, take a look at the <a href="https://huggingface.co/docs/datasets/main/en/image_dataset#loading-script"><span class="underline decoration-yellow-400 decoration-2 font-semibold">image loading script</span></a>, <a href="https://huggingface.co/docs/datasets/main/en/audio_dataset"><span class="underline decoration-pink-400 decoration-2 font-semibold">audio loading script</span></a>, and <a href="https://huggingface.co/docs/datasets/main/en/dataset_script"><span class="underline decoration-green-400 decoration-2 font-semibold">text loading script</span></a> guides.',qe,A,ct="Now that you know how to create a dataset, consider sharing it on the Hub so the community can also benefit from your work! Go on to the next section to learn how to share your dataset.",Ze,se,Ce;return k=new Re({props:{title:"Create a dataset",local:"create-a-dataset",headingTag:"h1"}}),$=new Re({props:{title:"Folder-based builders",local:"folder-based-builders",headingTag:"h2"}}),C=new j({props:{code:"cG9rZW1vbiUyRnRyYWluJTJGZ3Jhc3MlMkZidWxiYXNhdXIucG5nJTBBcG9rZW1vbiUyRnRyYWluJTJGZmlyZSUyRmNoYXJtYW5kZXIucG5nJTBBcG9rZW1vbiUyRnRyYWluJTJGd2F0ZXIlMkZzcXVpcnRsZS5wbmclMEElMEFwb2tlbW9uJTJGdGVzdCUyRmdyYXNzJTJGaXZ5c2F1ci5wbmclMEFwb2tlbW9uJTJGdGVzdCUyRmZpcmUlMkZjaGFybWVsZW9uLnBuZyUwQXBva2Vtb24lMkZ0ZXN0JTJGd2F0ZXIlMkZ3YXJ0b3J0bGUucG5n",highlighted:`pokemon<span class="hljs-regexp">/train/g</span>rass/bulbasaur.png
pokemon<span class="hljs-regexp">/train/</span>fire/charmander.png
pokemon<span class="hljs-regexp">/train/</span>water/squirtle.png

pokemon<span class="hljs-regexp">/test/g</span>rass/ivysaur.png
pokemon<span class="hljs-regexp">/test/</span>fire/charmeleon.png
pokemon<span class="hljs-regexp">/test/</span>water/wartortle.png`,wrap:!1}}),F=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWFnZWZvbGRlciUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyJTJGcGF0aCUyRnRvJTJGcG9rZW1vbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;imagefolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/pokemon&quot;</span>)`,wrap:!1}}),B=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhdWRpb2ZvbGRlciUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyJTJGcGF0aCUyRnRvJTJGZm9sZGVyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/folder&quot;</span>)`,wrap:!1}}),H=new j({props:{code:"ZmlsZV9uYW1lJTJDJTIwdGV4dCUwQWJ1bGJhc2F1ci5wbmclMkMlMjBUaGVyZSUyMGlzJTIwYSUyMHBsYW50JTIwc2VlZCUyMG9uJTIwaXRzJTIwYmFjayUyMHJpZ2h0JTIwZnJvbSUyMHRoZSUyMGRheSUyMHRoaXMlMjBQb2slQzMlQTltb24lMjBpcyUyMGJvcm4uJTBBY2hhcm1hbmRlci5wbmclMkMlMjBJdCUyMGhhcyUyMGElMjBwcmVmZXJlbmNlJTIwZm9yJTIwaG90JTIwdGhpbmdzLiUwQXNxdWlydGxlLnBuZyUyQyUyMFdoZW4lMjBpdCUyMHJldHJhY3RzJTIwaXRzJTIwbG9uZyUyMG5lY2slMjBpbnRvJTIwaXRzJTIwc2hlbGwlMkMlMjBpdCUyMHNxdWlydHMlMjBvdXQlMjB3YXRlciUyMHdpdGglMjB2aWdvcm91cyUyMGZvcmNlLg==",highlighted:`file_name, <span class="hljs-built_in">text</span>
bulbasaur.png, There <span class="hljs-keyword">is</span> a plant seed <span class="hljs-keyword">on</span> <span class="hljs-keyword">its</span> <span class="hljs-keyword">back</span> right <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">day</span> this Pokémon <span class="hljs-keyword">is</span> born.
charmander.png, It has a preference <span class="hljs-keyword">for</span> hot things.
squirtle.png, When <span class="hljs-keyword">it</span> retracts <span class="hljs-keyword">its</span> long neck <span class="hljs-keyword">into</span> <span class="hljs-keyword">its</span> shell, <span class="hljs-keyword">it</span> squirts out water <span class="hljs-keyword">with</span> vigorous force.`,wrap:!1}}),L=new Re({props:{title:"From local files",local:"from-local-files",headingTag:"h2"}}),N=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRlZiUyMGdlbigpJTNBJTBBJTIwJTIwJTIwJTIweWllbGQlMjAlN0IlMjJwb2tlbW9uJTIyJTNBJTIwJTIyYnVsYmFzYXVyJTIyJTJDJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdyYXNzJTIyJTdEJTBBJTIwJTIwJTIwJTIweWllbGQlMjAlN0IlMjJwb2tlbW9uJTIyJTNBJTIwJTIyc3F1aXJ0bGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyd2F0ZXIlMjIlN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9nZW5lcmF0b3IoZ2VuKSUwQWRzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">gen</span>():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;squirtle&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;water&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_generator(gen)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}`,wrap:!1}}),Q=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwSXRlcmFibGVEYXRhc2V0JTBBZHMlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IoZ2VuKSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> IterableDataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = IterableDataset.from_generator(gen)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> ds:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;squirtle&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;water&quot;</span>}`,wrap:!1}}),V=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIycG9rZW1vbiUyMiUzQSUyMCU1QiUyMmJ1bGJhc2F1ciUyMiUyQyUyMCUyMnNxdWlydGxlJTIyJTVEJTJDJTIwJTIydHlwZSUyMiUzQSUyMCU1QiUyMmdyYXNzJTIyJTJDJTIwJTIyd2F0ZXIlMjIlNUQlN0QpJTBBZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;pokemon&quot;</span>: [<span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;squirtle&quot;</span>], <span class="hljs-string">&quot;type&quot;</span>: [<span class="hljs-string">&quot;grass&quot;</span>, <span class="hljs-string">&quot;water&quot;</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}`,wrap:!1}}),S=new j({props:{code:"YXVkaW9fZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmF1ZGlvJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW9fMSUyMiUyQyUyMC4uLiUyQyUyMCUyMnBhdGglMkZ0byUyRmF1ZGlvX24lMjIlNUQlN0QpLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: [<span class="hljs-string">&quot;path/to/audio_1&quot;</span>, ..., <span class="hljs-string">&quot;path/to/audio_n&quot;</span>]}).cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio())',wrap:!1}}),P=new Re({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){w=o("meta"),le=n(),ae=o("p"),oe=n(),p(k.$$.fragment),ie=n(),v=o("p"),v.innerHTML=Qe,re=n(),U=o("p"),U.textContent=Ve,de=n(),_=o("ul"),_.innerHTML=Se,pe=n(),p($.$$.fragment),ce=n(),I=o("p"),I.innerHTML=Pe,ue=n(),G=o("ul"),G.innerHTML=De,he=n(),q=o("p"),q.textContent=Ee,me=n(),Z=o("p"),Z.textContent=Ae,ge=n(),p(C.$$.fragment),fe=n(),x=o("p"),x.textContent=Ke,ye=n(),J=o("div"),J.innerHTML=Oe,we=n(),R=o("p"),R.innerHTML=et,Je=n(),p(F.$$.fragment),Te=n(),X=o("p"),X.innerHTML=tt,be=n(),p(B.$$.fragment),Me=n(),W=o("p"),W.innerHTML=at,je=n(),p(H.$$.fragment),ke=n(),z=o("p"),z.innerHTML=st,ve=n(),p(L.$$.fragment),Ue=n(),Y=o("p"),Y.innerHTML=nt,_e=n(),T=o("ul"),f=o("li"),K=o("p"),K.innerHTML=lt,Fe=n(),p(N.$$.fragment),Xe=n(),O=o("p"),O.innerHTML=ot,Be=n(),p(Q.$$.fragment),We=n(),y=o("li"),ee=o("p"),ee.innerHTML=it,He=n(),p(V.$$.fragment),ze=n(),te=o("p"),te.innerHTML=rt,Le=n(),p(S.$$.fragment),$e=n(),p(P.$$.fragment),Ie=n(),D=o("p"),D.textContent=dt,Ge=n(),E=o("p"),E.innerHTML=pt,qe=n(),A=o("p"),A.textContent=ct,Ze=n(),se=o("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(a),le=l(e),ae=i(e,"P",{}),ne(ae).forEach(a),oe=l(e),c(k.$$.fragment,e),ie=l(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-v9imqp"&&(v.innerHTML=Qe),re=l(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1cv0g2h"&&(U.textContent=Ve),de=l(e),_=i(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1lzxsuu"&&(_.innerHTML=Se),pe=l(e),c($.$$.fragment,e),ce=l(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-gu1tts"&&(I.innerHTML=Pe),ue=l(e),G=i(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1qgcixv"&&(G.innerHTML=De),he=l(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-v88ugk"&&(q.textContent=Ee),me=l(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-cn9wsj"&&(Z.textContent=Ae),ge=l(e),c(C.$$.fragment,e),fe=l(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-5wcoi"&&(x.textContent=Ke),ye=l(e),J=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-mid65z"&&(J.innerHTML=Oe),we=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1oxusca"&&(R.innerHTML=et),Je=l(e),c(F.$$.fragment,e),Te=l(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-13hsz50"&&(X.innerHTML=tt),be=l(e),c(B.$$.fragment,e),Me=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-ai9qzj"&&(W.innerHTML=at),je=l(e),c(H.$$.fragment,e),ke=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-c9ukhj"&&(z.innerHTML=st),ve=l(e),c(L.$$.fragment,e),Ue=l(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-c4isg3"&&(Y.innerHTML=nt),_e=l(e),T=i(e,"UL",{});var xe=ne(T);f=i(xe,"LI",{});var b=ne(f);K=i(b,"P",{"data-svelte-h":!0}),r(K)!=="svelte-sk6mcz"&&(K.innerHTML=lt),Fe=l(b),c(N.$$.fragment,b),Xe=l(b),O=i(b,"P",{"data-svelte-h":!0}),r(O)!=="svelte-2gehho"&&(O.innerHTML=ot),Be=l(b),c(Q.$$.fragment,b),b.forEach(a),We=l(xe),y=i(xe,"LI",{});var M=ne(y);ee=i(M,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-b40znq"&&(ee.innerHTML=it),He=l(M),c(V.$$.fragment,M),ze=l(M),te=i(M,"P",{"data-svelte-h":!0}),r(te)!=="svelte-v3dq16"&&(te.innerHTML=rt),Le=l(M),c(S.$$.fragment,M),M.forEach(a),xe.forEach(a),$e=l(e),c(P.$$.fragment,e),Ie=l(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1o9me9i"&&(D.textContent=dt),Ge=l(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-cqv4z9"&&(E.innerHTML=pt),qe=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-uhu1ny"&&(A.textContent=ct),Ze=l(e),se=i(e,"P",{}),ne(se).forEach(a),this.h()},h(){Ye(w,"name","hf:doc:metadata"),Ye(w,"content",Jt),Ye(J,"class","flex justify-center")},m(e,t){d(document.head,w),s(e,le,t),s(e,ae,t),s(e,oe,t),u(k,e,t),s(e,ie,t),s(e,v,t),s(e,re,t),s(e,U,t),s(e,de,t),s(e,_,t),s(e,pe,t),u($,e,t),s(e,ce,t),s(e,I,t),s(e,ue,t),s(e,G,t),s(e,he,t),s(e,q,t),s(e,me,t),s(e,Z,t),s(e,ge,t),u(C,e,t),s(e,fe,t),s(e,x,t),s(e,ye,t),s(e,J,t),s(e,we,t),s(e,R,t),s(e,Je,t),u(F,e,t),s(e,Te,t),s(e,X,t),s(e,be,t),u(B,e,t),s(e,Me,t),s(e,W,t),s(e,je,t),u(H,e,t),s(e,ke,t),s(e,z,t),s(e,ve,t),u(L,e,t),s(e,Ue,t),s(e,Y,t),s(e,_e,t),s(e,T,t),d(T,f),d(f,K),d(f,Fe),u(N,f,null),d(f,Xe),d(f,O),d(f,Be),u(Q,f,null),d(T,We),d(T,y),d(y,ee),d(y,He),u(V,y,null),d(y,ze),d(y,te),d(y,Le),u(S,y,null),s(e,$e,t),u(P,e,t),s(e,Ie,t),s(e,D,t),s(e,Ge,t),s(e,E,t),s(e,qe,t),s(e,A,t),s(e,Ze,t),s(e,se,t),Ce=!0},p:ht,i(e){Ce||(h(k.$$.fragment,e),h($.$$.fragment,e),h(C.$$.fragment,e),h(F.$$.fragment,e),h(B.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),Ce=!0)},o(e){m(k.$$.fragment,e),m($.$$.fragment,e),m(C.$$.fragment,e),m(F.$$.fragment,e),m(B.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),Ce=!1},d(e){e&&(a(le),a(ae),a(oe),a(ie),a(v),a(re),a(U),a(de),a(_),a(pe),a(ce),a(I),a(ue),a(G),a(he),a(q),a(me),a(Z),a(ge),a(fe),a(x),a(ye),a(J),a(we),a(R),a(Je),a(Te),a(X),a(be),a(Me),a(W),a(je),a(ke),a(z),a(ve),a(Ue),a(Y),a(_e),a(T),a($e),a(Ie),a(D),a(Ge),a(E),a(qe),a(A),a(Ze),a(se)),a(w),g(k,e),g($,e),g(C,e),g(F,e),g(B,e),g(H,e),g(L,e),g(N),g(Q),g(V),g(S),g(P,e)}}}const Jt='{"title":"Create a dataset","local":"create-a-dataset","sections":[{"title":"Folder-based builders","local":"folder-based-builders","sections":[],"depth":2},{"title":"From local files","local":"from-local-files","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Tt(Ne){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends gt{constructor(w){super(),ft(this,w,Tt,wt,ut,{})}}export{vt as component};
