import{s as Js,o as $s,n as js}from"../chunks/scheduler.bdbef820.js";import{S as ws,i as _s,g as o,s as l,r as p,A as vs,h as i,f as s,c as n,j as bs,u as r,x as g,k as T,y as ks,a,v as d,d as m,t as c,w as u}from"../chunks/index.c0aea24a.js";import{T as Zs}from"../chunks/Tip.31005f7d.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as M}from"../chunks/Heading.2eb892cb.js";function Us(Rt){let y,U='Remember to define your credentials in your <a href="#set-up-your-cloud-storage-filesystem">FileSystem instance</a> <code>fs</code> whenever you are interacting with a private cloud storage.';return{c(){y=o("p"),y.innerHTML=U},l(h){y=i(h,"P",{"data-svelte-h":!0}),g(y)!=="svelte-f0wftp"&&(y.innerHTML=U)},m(h,Gt){a(h,y,Gt)},p:js,d(h){h&&s(y)}}}function Gs(Rt){let y,U,h,Gt,G,It,z,Le=`🤗 Datasets supports access to cloud storage providers through a <code>fsspec</code> FileSystem implementations.
You can save and load datasets from any cloud storage in a Pythonic way.
Take a look at the following table for some example of supported cloud storage providers:`,Wt,R,Ne='<thead><tr><th>Storage provider</th> <th>Filesystem implementation</th></tr></thead> <tbody><tr><td>Amazon S3</td> <td><a href="https://s3fs.readthedocs.io/en/latest/" rel="nofollow">s3fs</a></td></tr> <tr><td>Google Cloud Storage</td> <td><a href="https://gcsfs.readthedocs.io/en/latest/" rel="nofollow">gcsfs</a></td></tr> <tr><td>Azure Blob/DataLake</td> <td><a href="https://github.com/fsspec/adlfs" rel="nofollow">adlfs</a></td></tr> <tr><td>Dropbox</td> <td><a href="https://github.com/MarineChap/dropboxdrivefs" rel="nofollow">dropboxdrivefs</a></td></tr> <tr><td>Google Drive</td> <td><a href="https://github.com/intake/gdrivefs" rel="nofollow">gdrivefs</a></td></tr> <tr><td>Oracle Cloud Storage</td> <td><a href="https://ocifs.readthedocs.io/en/latest/" rel="nofollow">ocifs</a></td></tr></tbody>',Ct,I,xe=`This guide will show you how to save and load datasets with any cloud storage.
Here are examples for S3, Google Cloud Storage, Azure Blob Storage, and Oracle Cloud Object Storage.`,Xt,W,Ht,C,qt,X,Se="<li>Install the S3 FileSystem implementation:</li>",Vt,H,Ft,b,Qe="<li>Define your credentials</li>",Yt,q,Ee=`To use an anonymous connection, use <code>anon=True</code>.
Otherwise, include your <code>aws_access_key_id</code> and <code>aws_secret_access_key</code> whenever you are interacting with a private S3 bucket.`,Bt,V,Lt,J,Ae="<li>Create your FileSystem instance</li>",Nt,F,xt,Y,St,B,De="<li>Install the Google Cloud Storage implementation:</li>",Qt,L,Et,$,Oe="<li>Define your credentials</li>",At,N,Dt,j,Pe="<li>Create your FileSystem instance</li>",Ot,x,Pt,S,Kt,Q,Ke="<li>Install the Azure Blob Storage implementation:</li>",te,E,ee,w,ts="<li>Define your credentials</li>",se,A,ae,_,es="<li>Create your FileSystem instance</li>",le,D,ne,O,oe,P,ss="<li>Install the OCI FileSystem implementation:</li>",ie,K,pe,v,as="<li>Define your credentials</li>",re,tt,de,k,ls="<li>Create your FileSystem instance</li>",me,et,ce,st,ue,at,ge,lt,ns=`You can download and prepare a dataset into your cloud storage by specifying a remote <code>output_dir</code> in <code>download_and_prepare</code>.
Don’t forget to use the previously defined <code>storage_options</code> containing your credentials to write into a private cloud storage.`,fe,nt,os="The <code>download_and_prepare</code> method works in two steps:",ye,ot,is='<li>it first downloads the raw data files (if any) in your local cache. You can set your cache directory by passing <code>cache_dir</code> to <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset_builder">load_dataset_builder()</a></li> <li>then it generates the dataset in Arrow or Parquet format in your cloud storage by iterating over the raw data files.</li>',Me,it,ps='Load a dataset builder from the Hugging Face Hub (see <a href="./loading#hugging-face-hub">how to load from the Hugging Face Hub</a>):',he,pt,Te,rt,rs='Load a dataset builder using a loading script (see <a href="./loading#local-loading-script">how to load a local loading script</a>):',be,dt,Je,mt,ds='Use your own data files (see <a href="./loading#local-and-remote-files">how to load local and remote files</a>):',$e,ct,je,ut,ms=`It is highly recommended to save the files as compressed Parquet files to optimize I/O by specifying <code>file_format=&quot;parquet&quot;</code>.
Otherwise the dataset is saved as an uncompressed Arrow file.`,we,gt,cs="You can also specify the size of the shards using <code>max_shard_size</code> (default is 500MB):",_e,ft,ve,yt,ke,Mt,us=`Dask is a parallel computing library and it has a pandas-like API for working with larger than memory Parquet datasets in parallel.
Dask can use multiple threads or processes on a single machine, or a cluster of machines to process data in parallel.
Dask supports local data but also data from a cloud storage.`,Ze,ht,gs="Therefore you can load a dataset saved as sharded Parquet files in Dask with",Ue,Tt,Ge,bt,fs='You can find more about dask dataframes in their <a href="https://docs.dask.org/en/stable/dataframe.html" rel="nofollow">documentation</a>.',ze,Jt,Re,$t,ys='After you have processed your dataset, you can save it to your cloud storage with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.save_to_disk">Dataset.save_to_disk()</a>:',Ie,jt,We,Z,Ce,wt,Xe,_t,Ms="List files from a cloud storage with your FileSystem instance <code>fs</code>, using <code>fs.ls</code>:",He,vt,qe,kt,Ve,Zt,hs='When you are ready to use your dataset again, reload it with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.load_from_disk">Dataset.load_from_disk()</a>:',Fe,Ut,Ye,zt,Be;return G=new M({props:{title:"Cloud storage",local:"cloud-storage",headingTag:"h1"}}),W=new M({props:{title:"Set up your cloud storage FileSystem",local:"set-up-your-cloud-storage-filesystem",headingTag:"h2"}}),C=new M({props:{title:"Amazon S3",local:"amazon-s3",headingTag:"h3"}}),H=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHMzZnM=",highlighted:'<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install s3fs</span>',wrap:!1}}),V=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyYW5vbiUyMiUzQSUyMFRydWUlN0QlMjAlMjAlMjMlMjBmb3IlMjBhbm9ueW1vdXMlMjBjb25uZWN0aW9uJTBBc3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIya2V5JTIyJTNBJTIwYXdzX2FjY2Vzc19rZXlfaWQlMkMlMjAlMjJzZWNyZXQlMjIlM0ElMjBhd3Nfc2VjcmV0X2FjY2Vzc19rZXklN0QlMjAlMjAlMjMlMjBmb3IlMjBwcml2YXRlJTIwYnVja2V0cyUwQWltcG9ydCUyMGFpb2JvdG9jb3JlLnNlc3Npb24lMEFzM19zZXNzaW9uJTIwJTNEJTIwYWlvYm90b2NvcmUuc2Vzc2lvbi5BaW9TZXNzaW9uKHByb2ZpbGUlM0QlMjJteV9wcm9maWxlX25hbWUlMjIpJTBBc3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyc2Vzc2lvbiUyMiUzQSUyMHMzX3Nlc3Npb24lN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;anon&quot;</span>: <span class="hljs-literal">True</span>}  <span class="hljs-comment"># for anonymous connection</span>
<span class="hljs-comment"># or use your credentials</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;key&quot;</span>: aws_access_key_id, <span class="hljs-string">&quot;secret&quot;</span>: aws_secret_access_key}  <span class="hljs-comment"># for private buckets</span>
<span class="hljs-comment"># or use a botocore session</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> aiobotocore.session
<span class="hljs-meta">&gt;&gt;&gt; </span>s3_session = aiobotocore.session.AioSession(profile=<span class="hljs-string">&quot;my_profile_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;session&quot;</span>: s3_session}`,wrap:!1}}),F=new f({props:{code:"aW1wb3J0JTIwczNmcyUwQWZzJTIwJTNEJTIwczNmcy5TM0ZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> s3fs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = s3fs.S3FileSystem(**storage_options)`,wrap:!1}}),Y=new M({props:{title:"Google Cloud Storage",local:"google-cloud-storage",headingTag:"h3"}}),L=new f({props:{code:"Y29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGdjc2ZzJTBBcGlwJTIwaW5zdGFsbCUyMGdjc2Zz",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">conda install -c conda-forge gcsfs</span>
# or install with pip
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install gcsfs</span>`,wrap:!1}}),N=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTNEJTdCJTIydG9rZW4lMjIlM0ElMjAlMjJhbm9uJTIyJTdEJTIwJTIwJTIzJTIwZm9yJTIwYW5vbnltb3VzJTIwY29ubmVjdGlvbiUwQXN0b3JhZ2Vfb3B0aW9ucyUzRCU3QiUyMnByb2plY3QlMjIlM0ElMjAlMjJteS1nb29nbGUtcHJvamVjdCUyMiU3RCUwQXN0b3JhZ2Vfb3B0aW9ucyUzRCU3QiUyMnByb2plY3QlMjIlM0ElMjAlMjJteS1nb29nbGUtcHJvamVjdCUyMiUyQyUyMCUyMnRva2VuJTIyJTNBJTIwVE9LRU4lN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;token&quot;</span>: <span class="hljs-string">&quot;anon&quot;</span>}  <span class="hljs-comment"># for anonymous connection</span>
<span class="hljs-comment"># or use your credentials of your default gcloud credentials or from the google metadata service</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;project&quot;</span>: <span class="hljs-string">&quot;my-google-project&quot;</span>}
<span class="hljs-comment"># or use your credentials from elsewhere, see the documentation at https://gcsfs.readthedocs.io/</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;project&quot;</span>: <span class="hljs-string">&quot;my-google-project&quot;</span>, <span class="hljs-string">&quot;token&quot;</span>: TOKEN}`,wrap:!1}}),x=new f({props:{code:"aW1wb3J0JTIwZ2NzZnMlMEFmcyUyMCUzRCUyMGdjc2ZzLkdDU0ZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gcsfs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = gcsfs.GCSFileSystem(**storage_options)`,wrap:!1}}),S=new M({props:{title:"Azure Blob Storage",local:"azure-blob-storage",headingTag:"h3"}}),E=new f({props:{code:"Y29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGFkbGZzJTBBcGlwJTIwaW5zdGFsbCUyMGFkbGZz",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">conda install -c conda-forge adlfs</span>
# or install with pip
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install adlfs</span>`,wrap:!1}}),A=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyYW5vbiUyMiUzQSUyMFRydWUlN0QlMjAlMjAlMjMlMjBmb3IlMjBhbm9ueW1vdXMlMjBjb25uZWN0aW9uJTBBc3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyYWNjb3VudF9uYW1lJTIyJTNBJTIwQUNDT1VOVF9OQU1FJTJDJTIwJTIyYWNjb3VudF9rZXklMjIlM0ElMjBBQ0NPVU5UX0tFWSU3RCUyMCUyMCUyMyUyMGdlbiUyMDIlMjBmaWxlc3lzdGVtJTBBc3RvcmFnZV9vcHRpb25zJTNEJTdCJTIydGVuYW50X2lkJTIyJTNBJTIwVEVOQU5UX0lEJTJDJTIwJTIyY2xpZW50X2lkJTIyJTNBJTIwQ0xJRU5UX0lEJTJDJTIwJTIyY2xpZW50X3NlY3JldCUyMiUzQSUyMENMSUVOVF9TRUNSRVQlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;anon&quot;</span>: <span class="hljs-literal">True</span>}  <span class="hljs-comment"># for anonymous connection</span>
<span class="hljs-comment"># or use your credentials</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;account_name&quot;</span>: ACCOUNT_NAME, <span class="hljs-string">&quot;account_key&quot;</span>: ACCOUNT_KEY}  <span class="hljs-comment"># gen 2 filesystem</span>
<span class="hljs-comment"># or use your credentials with the gen 1 filesystem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;tenant_id&quot;</span>: TENANT_ID, <span class="hljs-string">&quot;client_id&quot;</span>: CLIENT_ID, <span class="hljs-string">&quot;client_secret&quot;</span>: CLIENT_SECRET}`,wrap:!1}}),D=new f({props:{code:"aW1wb3J0JTIwYWRsZnMlMEFmcyUyMCUzRCUyMGFkbGZzLkF6dXJlQmxvYkZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> adlfs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = adlfs.AzureBlobFileSystem(**storage_options)`,wrap:!1}}),O=new M({props:{title:"Oracle Cloud Object Storage",local:"oracle-cloud-object-storage",headingTag:"h3"}}),K=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9jaWZz",highlighted:'<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install ocifs</span>',wrap:!1}}),tt=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyY29uZmlnJTIyJTNBJTIwJTIyfiUyRi5vY2klMkZjb25maWclMjIlMkMlMjAlMjJyZWdpb24lMjIlM0ElMjAlMjJ1cy1hc2hidXJuLTElMjIlN0QlMjA=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;config&quot;</span>: <span class="hljs-string">&quot;~/.oci/config&quot;</span>, <span class="hljs-string">&quot;region&quot;</span>: <span class="hljs-string">&quot;us-ashburn-1&quot;</span>} ',wrap:!1}}),et=new f({props:{code:"aW1wb3J0JTIwb2NpZnMlMEFmcyUyMCUzRCUyMG9jaWZzLk9DSUZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> ocifs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = ocifs.OCIFileSystem(**storage_options)`,wrap:!1}}),st=new M({props:{title:"Load and Save your datasets using your cloud storage FileSystem",local:"load-and-save-your-datasets-using-your-cloud-storage-filesystem",headingTag:"h2"}}),at=new M({props:{title:"Download and prepare a dataset into a cloud storage",local:"download-and-prepare-a-dataset-into-a-cloud-storage",headingTag:"h3"}}),pt=new f({props:{code:"b3V0cHV0X2RpciUyMCUzRCUyMCUyMnMzJTNBJTJGJTJGbXktYnVja2V0JTJGaW1kYiUyMiUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJpbWRiJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUob3V0cHV0X2RpciUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyUyQyUyMGZpbGVfZm9ybWF0JTNEJTIycGFycXVldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;s3://my-bucket/imdb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;imdb&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),dt=new f({props:{code:"b3V0cHV0X2RpciUyMCUzRCUyMCUyMnMzJTNBJTJGJTJGbXktYnVja2V0JTJGaW1kYiUyMiUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJwYXRoJTJGdG8lMkZsb2NhbCUyRmxvYWRpbmdfc2NyaXB0JTJGbG9hZGluZ19zY3JpcHQucHklMjIpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZShvdXRwdXRfZGlyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zJTJDJTIwZmlsZV9mb3JtYXQlM0QlMjJwYXJxdWV0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;s3://my-bucket/imdb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;path/to/local/loading_script/loading_script.py&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),ct=new f({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGdHJhaW4uY3N2JTIyJTVEJTdEJTBBb3V0cHV0X2RpciUyMCUzRCUyMCUyMnMzJTNBJTJGJTJGbXktYnVja2V0JTJGaW1kYiUyMiUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEZGF0YV9maWxlcyklMEFidWlsZGVyLmRvd25sb2FkX2FuZF9wcmVwYXJlKG91dHB1dF9kaXIlMkMlMjBzdG9yYWdlX29wdGlvbnMlM0RzdG9yYWdlX29wdGlvbnMlMkMlMjBmaWxlX2Zvcm1hdCUzRCUyMnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/train.csv&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;s3://my-bucket/imdb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),ft=new f({props:{code:"YnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZShvdXRwdXRfZGlyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zJTJDJTIwZmlsZV9mb3JtYXQlM0QlMjJwYXJxdWV0JTIyJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIxR0IlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>)',wrap:!1}}),yt=new M({props:{title:"Dask",local:"dask",headingTag:"h4"}}),Tt=new f({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQob3V0cHV0X2RpciUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyklMEElMEElMjMlMjBvciUyMGlmJTIweW91ciUyMGRhdGFzZXQlMjBpcyUyMHNwbGl0JTIwaW50byUyMHRyYWluJTJGdmFsaWQlMkZ0ZXN0JTBBZGZfdHJhaW4lMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQob3V0cHV0X2RpciUyMCUyQiUyMGYlMjIlMkYlN0JidWlsZGVyLm5hbWUlN0QtdHJhaW4tKi5wYXJxdWV0JTIyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zKSUwQWRmX3ZhbGlkJTIwJTNEJTIwZGQucmVhZF9wYXJxdWV0KG91dHB1dF9kaXIlMjAlMkIlMjBmJTIyJTJGJTdCYnVpbGRlci5uYW1lJTdELXZhbGlkYXRpb24tKi5wYXJxdWV0JTIyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zKSUwQWRmX3Rlc3QlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQob3V0cHV0X2RpciUyMCUyQiUyMGYlMjIlMkYlN0JidWlsZGVyLm5hbWUlN0QtdGVzdC0qLnBhcnF1ZXQlMjIlMkMlMjBzdG9yYWdlX29wdGlvbnMlM0RzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df = dd.read_parquet(output_dir, storage_options=storage_options)

<span class="hljs-comment"># or if your dataset is split into train/valid/test</span>
df_train = dd.read_parquet(output_dir + <span class="hljs-string">f&quot;/<span class="hljs-subst">{builder.name}</span>-train-*.parquet&quot;</span>, storage_options=storage_options)
df_valid = dd.read_parquet(output_dir + <span class="hljs-string">f&quot;/<span class="hljs-subst">{builder.name}</span>-validation-*.parquet&quot;</span>, storage_options=storage_options)
df_test = dd.read_parquet(output_dir + <span class="hljs-string">f&quot;/<span class="hljs-subst">{builder.name}</span>-test-*.parquet&quot;</span>, storage_options=storage_options)`,wrap:!1}}),Jt=new M({props:{title:"Saving serialized datasets",local:"saving-serialized-datasets",headingTag:"h2"}}),jt=new f({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJzMyUzQSUyRiUyRm15LXByaXZhdGUtZGF0YXNldHMlMkZpbWRiJTJGdHJhaW4lMjIlMkMlMjBzdG9yYWdlX29wdGlvbnMlM0RzdG9yYWdlX29wdGlvbnMpJTBBZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJnY3MlM0ElMkYlMkZteS1wcml2YXRlLWRhdGFzZXRzJTJGaW1kYiUyRnRyYWluJTIyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zKSUwQWVuY29kZWRfZGF0YXNldC5zYXZlX3RvX2Rpc2soJTIyYWRsJTNBJTJGJTJGbXktcHJpdmF0ZS1kYXRhc2V0cyUyRmltZGIlMkZ0cmFpbiUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyk=",highlighted:`<span class="hljs-comment"># saves encoded_dataset to amazon s3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;s3://my-private-datasets/imdb/train&quot;</span>, storage_options=storage_options)
<span class="hljs-comment"># saves encoded_dataset to google cloud storage</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;gcs://my-private-datasets/imdb/train&quot;</span>, storage_options=storage_options)
<span class="hljs-comment"># saves encoded_dataset to microsoft azure blob/datalake</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;adl://my-private-datasets/imdb/train&quot;</span>, storage_options=storage_options)`,wrap:!1}}),Z=new Zs({props:{$$slots:{default:[Us]},$$scope:{ctx:Rt}}}),wt=new M({props:{title:"Listing serialized datasets",local:"listing-serialized-datasets",headingTag:"h2"}}),vt=new f({props:{code:"ZnMubHMoJTIybXktcHJpdmF0ZS1kYXRhc2V0cyUyRmltZGIlMkZ0cmFpbiUyMiUyQyUyMGRldGFpbCUzREZhbHNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;my-private-datasets/imdb/train&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&quot;dataset_info.json.json&quot;</span>,<span class="hljs-string">&quot;dataset.arrow&quot;</span>,<span class="hljs-string">&quot;state.json&quot;</span>]`,wrap:!1}}),kt=new M({props:{title:"Load serialized datasets",local:"load-serialized-datasets",headingTag:"h3"}}),Ut=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9mcm9tX2Rpc2soJTIyczMlM0ElMkYlMkZhLXB1YmxpYy1kYXRhc2V0cyUyRmltZGIlMkZ0cmFpbiUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyklMjAlMjAlMEFwcmludChsZW4oZGF0YXNldCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk
<span class="hljs-comment"># load encoded_dataset from cloud storage</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_from_disk(<span class="hljs-string">&quot;s3://a-public-datasets/imdb/train&quot;</span>, storage_options=storage_options)  
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(dataset))
<span class="hljs-number">25000</span>`,wrap:!1}}),{c(){y=o("meta"),U=l(),h=o("p"),Gt=l(),p(G.$$.fragment),It=l(),z=o("p"),z.innerHTML=Le,Wt=l(),R=o("table"),R.innerHTML=Ne,Ct=l(),I=o("p"),I.textContent=xe,Xt=l(),p(W.$$.fragment),Ht=l(),p(C.$$.fragment),qt=l(),X=o("ol"),X.innerHTML=Se,Vt=l(),p(H.$$.fragment),Ft=l(),b=o("ol"),b.innerHTML=Qe,Yt=l(),q=o("p"),q.innerHTML=Ee,Bt=l(),p(V.$$.fragment),Lt=l(),J=o("ol"),J.innerHTML=Ae,Nt=l(),p(F.$$.fragment),xt=l(),p(Y.$$.fragment),St=l(),B=o("ol"),B.innerHTML=De,Qt=l(),p(L.$$.fragment),Et=l(),$=o("ol"),$.innerHTML=Oe,At=l(),p(N.$$.fragment),Dt=l(),j=o("ol"),j.innerHTML=Pe,Ot=l(),p(x.$$.fragment),Pt=l(),p(S.$$.fragment),Kt=l(),Q=o("ol"),Q.innerHTML=Ke,te=l(),p(E.$$.fragment),ee=l(),w=o("ol"),w.innerHTML=ts,se=l(),p(A.$$.fragment),ae=l(),_=o("ol"),_.innerHTML=es,le=l(),p(D.$$.fragment),ne=l(),p(O.$$.fragment),oe=l(),P=o("ol"),P.innerHTML=ss,ie=l(),p(K.$$.fragment),pe=l(),v=o("ol"),v.innerHTML=as,re=l(),p(tt.$$.fragment),de=l(),k=o("ol"),k.innerHTML=ls,me=l(),p(et.$$.fragment),ce=l(),p(st.$$.fragment),ue=l(),p(at.$$.fragment),ge=l(),lt=o("p"),lt.innerHTML=ns,fe=l(),nt=o("p"),nt.innerHTML=os,ye=l(),ot=o("ol"),ot.innerHTML=is,Me=l(),it=o("p"),it.innerHTML=ps,he=l(),p(pt.$$.fragment),Te=l(),rt=o("p"),rt.innerHTML=rs,be=l(),p(dt.$$.fragment),Je=l(),mt=o("p"),mt.innerHTML=ds,$e=l(),p(ct.$$.fragment),je=l(),ut=o("p"),ut.innerHTML=ms,we=l(),gt=o("p"),gt.innerHTML=cs,_e=l(),p(ft.$$.fragment),ve=l(),p(yt.$$.fragment),ke=l(),Mt=o("p"),Mt.textContent=us,Ze=l(),ht=o("p"),ht.textContent=gs,Ue=l(),p(Tt.$$.fragment),Ge=l(),bt=o("p"),bt.innerHTML=fs,ze=l(),p(Jt.$$.fragment),Re=l(),$t=o("p"),$t.innerHTML=ys,Ie=l(),p(jt.$$.fragment),We=l(),p(Z.$$.fragment),Ce=l(),p(wt.$$.fragment),Xe=l(),_t=o("p"),_t.innerHTML=Ms,He=l(),p(vt.$$.fragment),qe=l(),p(kt.$$.fragment),Ve=l(),Zt=o("p"),Zt.innerHTML=hs,Fe=l(),p(Ut.$$.fragment),Ye=l(),zt=o("p"),this.h()},l(t){const e=vs("svelte-u9bgzb",document.head);y=i(e,"META",{name:!0,content:!0}),e.forEach(s),U=n(t),h=i(t,"P",{}),bs(h).forEach(s),Gt=n(t),r(G.$$.fragment,t),It=n(t),z=i(t,"P",{"data-svelte-h":!0}),g(z)!=="svelte-1xcb7pv"&&(z.innerHTML=Le),Wt=n(t),R=i(t,"TABLE",{"data-svelte-h":!0}),g(R)!=="svelte-14du81h"&&(R.innerHTML=Ne),Ct=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-jhnqvu"&&(I.textContent=xe),Xt=n(t),r(W.$$.fragment,t),Ht=n(t),r(C.$$.fragment,t),qt=n(t),X=i(t,"OL",{"data-svelte-h":!0}),g(X)!=="svelte-16p50yk"&&(X.innerHTML=Se),Vt=n(t),r(H.$$.fragment,t),Ft=n(t),b=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(b)!=="svelte-172a894"&&(b.innerHTML=Qe),Yt=n(t),q=i(t,"P",{"data-svelte-h":!0}),g(q)!=="svelte-1m0nrhz"&&(q.innerHTML=Ee),Bt=n(t),r(V.$$.fragment,t),Lt=n(t),J=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(J)!=="svelte-zc3ks6"&&(J.innerHTML=Ae),Nt=n(t),r(F.$$.fragment,t),xt=n(t),r(Y.$$.fragment,t),St=n(t),B=i(t,"OL",{"data-svelte-h":!0}),g(B)!=="svelte-tzsteu"&&(B.innerHTML=De),Qt=n(t),r(L.$$.fragment,t),Et=n(t),$=i(t,"OL",{start:!0,"data-svelte-h":!0}),g($)!=="svelte-172a894"&&($.innerHTML=Oe),At=n(t),r(N.$$.fragment,t),Dt=n(t),j=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(j)!=="svelte-zc3ks6"&&(j.innerHTML=Pe),Ot=n(t),r(x.$$.fragment,t),Pt=n(t),r(S.$$.fragment,t),Kt=n(t),Q=i(t,"OL",{"data-svelte-h":!0}),g(Q)!=="svelte-zykrn6"&&(Q.innerHTML=Ke),te=n(t),r(E.$$.fragment,t),ee=n(t),w=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(w)!=="svelte-172a894"&&(w.innerHTML=ts),se=n(t),r(A.$$.fragment,t),ae=n(t),_=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(_)!=="svelte-zc3ks6"&&(_.innerHTML=es),le=n(t),r(D.$$.fragment,t),ne=n(t),r(O.$$.fragment,t),oe=n(t),P=i(t,"OL",{"data-svelte-h":!0}),g(P)!=="svelte-33zejz"&&(P.innerHTML=ss),ie=n(t),r(K.$$.fragment,t),pe=n(t),v=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(v)!=="svelte-172a894"&&(v.innerHTML=as),re=n(t),r(tt.$$.fragment,t),de=n(t),k=i(t,"OL",{start:!0,"data-svelte-h":!0}),g(k)!=="svelte-zc3ks6"&&(k.innerHTML=ls),me=n(t),r(et.$$.fragment,t),ce=n(t),r(st.$$.fragment,t),ue=n(t),r(at.$$.fragment,t),ge=n(t),lt=i(t,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-1dq9go1"&&(lt.innerHTML=ns),fe=n(t),nt=i(t,"P",{"data-svelte-h":!0}),g(nt)!=="svelte-sha7eh"&&(nt.innerHTML=os),ye=n(t),ot=i(t,"OL",{"data-svelte-h":!0}),g(ot)!=="svelte-1eau5ga"&&(ot.innerHTML=is),Me=n(t),it=i(t,"P",{"data-svelte-h":!0}),g(it)!=="svelte-1ypj8lj"&&(it.innerHTML=ps),he=n(t),r(pt.$$.fragment,t),Te=n(t),rt=i(t,"P",{"data-svelte-h":!0}),g(rt)!=="svelte-1xv3q0z"&&(rt.innerHTML=rs),be=n(t),r(dt.$$.fragment,t),Je=n(t),mt=i(t,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-1yv9guc"&&(mt.innerHTML=ds),$e=n(t),r(ct.$$.fragment,t),je=n(t),ut=i(t,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-1ksm788"&&(ut.innerHTML=ms),we=n(t),gt=i(t,"P",{"data-svelte-h":!0}),g(gt)!=="svelte-s9cwoq"&&(gt.innerHTML=cs),_e=n(t),r(ft.$$.fragment,t),ve=n(t),r(yt.$$.fragment,t),ke=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),g(Mt)!=="svelte-pl160m"&&(Mt.textContent=us),Ze=n(t),ht=i(t,"P",{"data-svelte-h":!0}),g(ht)!=="svelte-r3cnvj"&&(ht.textContent=gs),Ue=n(t),r(Tt.$$.fragment,t),Ge=n(t),bt=i(t,"P",{"data-svelte-h":!0}),g(bt)!=="svelte-e328yx"&&(bt.innerHTML=fs),ze=n(t),r(Jt.$$.fragment,t),Re=n(t),$t=i(t,"P",{"data-svelte-h":!0}),g($t)!=="svelte-4murcx"&&($t.innerHTML=ys),Ie=n(t),r(jt.$$.fragment,t),We=n(t),r(Z.$$.fragment,t),Ce=n(t),r(wt.$$.fragment,t),Xe=n(t),_t=i(t,"P",{"data-svelte-h":!0}),g(_t)!=="svelte-19hbo6c"&&(_t.innerHTML=Ms),He=n(t),r(vt.$$.fragment,t),qe=n(t),r(kt.$$.fragment,t),Ve=n(t),Zt=i(t,"P",{"data-svelte-h":!0}),g(Zt)!=="svelte-ixotur"&&(Zt.innerHTML=hs),Fe=n(t),r(Ut.$$.fragment,t),Ye=n(t),zt=i(t,"P",{}),bs(zt).forEach(s),this.h()},h(){T(y,"name","hf:doc:metadata"),T(y,"content",zs),T(b,"start","2"),T(J,"start","3"),T($,"start","2"),T(j,"start","3"),T(w,"start","2"),T(_,"start","3"),T(v,"start","2"),T(k,"start","3")},m(t,e){ks(document.head,y),a(t,U,e),a(t,h,e),a(t,Gt,e),d(G,t,e),a(t,It,e),a(t,z,e),a(t,Wt,e),a(t,R,e),a(t,Ct,e),a(t,I,e),a(t,Xt,e),d(W,t,e),a(t,Ht,e),d(C,t,e),a(t,qt,e),a(t,X,e),a(t,Vt,e),d(H,t,e),a(t,Ft,e),a(t,b,e),a(t,Yt,e),a(t,q,e),a(t,Bt,e),d(V,t,e),a(t,Lt,e),a(t,J,e),a(t,Nt,e),d(F,t,e),a(t,xt,e),d(Y,t,e),a(t,St,e),a(t,B,e),a(t,Qt,e),d(L,t,e),a(t,Et,e),a(t,$,e),a(t,At,e),d(N,t,e),a(t,Dt,e),a(t,j,e),a(t,Ot,e),d(x,t,e),a(t,Pt,e),d(S,t,e),a(t,Kt,e),a(t,Q,e),a(t,te,e),d(E,t,e),a(t,ee,e),a(t,w,e),a(t,se,e),d(A,t,e),a(t,ae,e),a(t,_,e),a(t,le,e),d(D,t,e),a(t,ne,e),d(O,t,e),a(t,oe,e),a(t,P,e),a(t,ie,e),d(K,t,e),a(t,pe,e),a(t,v,e),a(t,re,e),d(tt,t,e),a(t,de,e),a(t,k,e),a(t,me,e),d(et,t,e),a(t,ce,e),d(st,t,e),a(t,ue,e),d(at,t,e),a(t,ge,e),a(t,lt,e),a(t,fe,e),a(t,nt,e),a(t,ye,e),a(t,ot,e),a(t,Me,e),a(t,it,e),a(t,he,e),d(pt,t,e),a(t,Te,e),a(t,rt,e),a(t,be,e),d(dt,t,e),a(t,Je,e),a(t,mt,e),a(t,$e,e),d(ct,t,e),a(t,je,e),a(t,ut,e),a(t,we,e),a(t,gt,e),a(t,_e,e),d(ft,t,e),a(t,ve,e),d(yt,t,e),a(t,ke,e),a(t,Mt,e),a(t,Ze,e),a(t,ht,e),a(t,Ue,e),d(Tt,t,e),a(t,Ge,e),a(t,bt,e),a(t,ze,e),d(Jt,t,e),a(t,Re,e),a(t,$t,e),a(t,Ie,e),d(jt,t,e),a(t,We,e),d(Z,t,e),a(t,Ce,e),d(wt,t,e),a(t,Xe,e),a(t,_t,e),a(t,He,e),d(vt,t,e),a(t,qe,e),d(kt,t,e),a(t,Ve,e),a(t,Zt,e),a(t,Fe,e),d(Ut,t,e),a(t,Ye,e),a(t,zt,e),Be=!0},p(t,[e]){const Ts={};e&2&&(Ts.$$scope={dirty:e,ctx:t}),Z.$set(Ts)},i(t){Be||(m(G.$$.fragment,t),m(W.$$.fragment,t),m(C.$$.fragment,t),m(H.$$.fragment,t),m(V.$$.fragment,t),m(F.$$.fragment,t),m(Y.$$.fragment,t),m(L.$$.fragment,t),m(N.$$.fragment,t),m(x.$$.fragment,t),m(S.$$.fragment,t),m(E.$$.fragment,t),m(A.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(st.$$.fragment,t),m(at.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(ct.$$.fragment,t),m(ft.$$.fragment,t),m(yt.$$.fragment,t),m(Tt.$$.fragment,t),m(Jt.$$.fragment,t),m(jt.$$.fragment,t),m(Z.$$.fragment,t),m(wt.$$.fragment,t),m(vt.$$.fragment,t),m(kt.$$.fragment,t),m(Ut.$$.fragment,t),Be=!0)},o(t){c(G.$$.fragment,t),c(W.$$.fragment,t),c(C.$$.fragment,t),c(H.$$.fragment,t),c(V.$$.fragment,t),c(F.$$.fragment,t),c(Y.$$.fragment,t),c(L.$$.fragment,t),c(N.$$.fragment,t),c(x.$$.fragment,t),c(S.$$.fragment,t),c(E.$$.fragment,t),c(A.$$.fragment,t),c(D.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(pt.$$.fragment,t),c(dt.$$.fragment,t),c(ct.$$.fragment,t),c(ft.$$.fragment,t),c(yt.$$.fragment,t),c(Tt.$$.fragment,t),c(Jt.$$.fragment,t),c(jt.$$.fragment,t),c(Z.$$.fragment,t),c(wt.$$.fragment,t),c(vt.$$.fragment,t),c(kt.$$.fragment,t),c(Ut.$$.fragment,t),Be=!1},d(t){t&&(s(U),s(h),s(Gt),s(It),s(z),s(Wt),s(R),s(Ct),s(I),s(Xt),s(Ht),s(qt),s(X),s(Vt),s(Ft),s(b),s(Yt),s(q),s(Bt),s(Lt),s(J),s(Nt),s(xt),s(St),s(B),s(Qt),s(Et),s($),s(At),s(Dt),s(j),s(Ot),s(Pt),s(Kt),s(Q),s(te),s(ee),s(w),s(se),s(ae),s(_),s(le),s(ne),s(oe),s(P),s(ie),s(pe),s(v),s(re),s(de),s(k),s(me),s(ce),s(ue),s(ge),s(lt),s(fe),s(nt),s(ye),s(ot),s(Me),s(it),s(he),s(Te),s(rt),s(be),s(Je),s(mt),s($e),s(je),s(ut),s(we),s(gt),s(_e),s(ve),s(ke),s(Mt),s(Ze),s(ht),s(Ue),s(Ge),s(bt),s(ze),s(Re),s($t),s(Ie),s(We),s(Ce),s(Xe),s(_t),s(He),s(qe),s(Ve),s(Zt),s(Fe),s(Ye),s(zt)),s(y),u(G,t),u(W,t),u(C,t),u(H,t),u(V,t),u(F,t),u(Y,t),u(L,t),u(N,t),u(x,t),u(S,t),u(E,t),u(A,t),u(D,t),u(O,t),u(K,t),u(tt,t),u(et,t),u(st,t),u(at,t),u(pt,t),u(dt,t),u(ct,t),u(ft,t),u(yt,t),u(Tt,t),u(Jt,t),u(jt,t),u(Z,t),u(wt,t),u(vt,t),u(kt,t),u(Ut,t)}}}const zs='{"title":"Cloud storage","local":"cloud-storage","sections":[{"title":"Set up your cloud storage FileSystem","local":"set-up-your-cloud-storage-filesystem","sections":[{"title":"Amazon S3","local":"amazon-s3","sections":[],"depth":3},{"title":"Google Cloud Storage","local":"google-cloud-storage","sections":[],"depth":3},{"title":"Azure Blob Storage","local":"azure-blob-storage","sections":[],"depth":3},{"title":"Oracle Cloud Object Storage","local":"oracle-cloud-object-storage","sections":[],"depth":3}],"depth":2},{"title":"Load and Save your datasets using your cloud storage FileSystem","local":"load-and-save-your-datasets-using-your-cloud-storage-filesystem","sections":[{"title":"Download and prepare a dataset into a cloud storage","local":"download-and-prepare-a-dataset-into-a-cloud-storage","sections":[{"title":"Dask","local":"dask","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Saving serialized datasets","local":"saving-serialized-datasets","sections":[],"depth":2},{"title":"Listing serialized datasets","local":"listing-serialized-datasets","sections":[{"title":"Load serialized datasets","local":"load-serialized-datasets","sections":[],"depth":3}],"depth":2}],"depth":1}';function Rs(Rt){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qs extends ws{constructor(y){super(),_s(this,y,Rs,Gs,Js,{})}}export{qs as component};
