import{s as Js,n as Ts,o as ws}from"../chunks/scheduler.bdbef820.js";import{S as $s,i as bs,g as p,s as l,r as o,A as _s,h as i,f as a,c as n,j as ys,u as d,x as r,k as js,y as xs,a as e,v as m,d as c,t as f,w as h}from"../chunks/index.c0aea24a.js";import{C as u}from"../chunks/CodeBlock.6ccca92e.js";import{H as et}from"../chunks/Heading.2eb892cb.js";function Cs(Wt){let g,pt,lt,it,M,rt,y,Pt="A tabular dataset is a generic dataset used to describe any data stored in rows and columns, where the rows represent an example and the columns represent a feature (can be continuous or categorical). These datasets are commonly stored in CSV files, Pandas DataFrames, and in database tables. This guide will show you how to load and create a tabular dataset from:",ot,j,At="<li>CSV files</li> <li>Pandas DataFrames</li> <li>Databases</li>",dt,J,mt,T,Kt='🤗 Datasets can read CSV files by specifying the generic <code>csv</code> dataset builder name in the <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> method. To load more than one CSV file, pass them as a list to the <code>data_files</code> parameter:',ct,w,ft,$,Ot="You can also map specific CSV files to the train and test splits:",ht,b,ut,_,ts="To load remote CSV files, pass the URLs instead:",gt,x,Mt,C,ss="To load zipped CSV files:",yt,q,jt,v,Jt,k,as='🤗 Datasets also supports loading datasets from <a href="https://pandas.pydata.org/docs/reference/api/pandas.DataFrame.html" rel="nofollow">Pandas DataFrames</a> with the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_pandas">from_pandas()</a> method:',Tt,R,wt,U,es="Use the <code>splits</code> parameter to specify the name of the dataset split:",$t,Z,bt,Y,ls='If the dataset doesn’t look as expected, you should explicitly <a href="loading#specify-features">specify your dataset features</a>. A <a href="https://pandas.pydata.org/docs/reference/api/pandas.Series.html" rel="nofollow">pandas.Series</a> may not always carry enough information for Arrow to automatically infer a data type. For example, if a DataFrame is of length <code>0</code> or if the Series only contains <code>None/NaN</code> objects, the type is set to <code>null</code>.',_t,G,xt,X,ns="Datasets stored in databases are typically accessed with SQL queries. With 🤗 Datasets, you can connect to a database, query for the data you need, and create a dataset out of it. Then you can use all the processing features of 🤗 Datasets to prepare your dataset for training.",Ct,I,qt,F,ps="SQLite is a small, lightweight database that is fast and easy to set up. You can use an existing database if you’d like, or follow along and start from scratch.",vt,N,is='Start by creating a quick SQLite database with this <a href="https://github.com/nytimes/covid-19-data/blob/master/us-states.csv" rel="nofollow">Covid-19 data</a> from the New York Times:',kt,H,Rt,z,rs="This creates a <code>states</code> table in the <code>us_covid_data.db</code> database which you can now load into a dataset.",Ut,L,os='To connect to the database, you’ll need the <a href="https://docs.sqlalchemy.org/en/13/core/engines.html#database-urls" rel="nofollow">URI string</a> that identifies your database. Connecting to a database with a URI caches the returned dataset. The URI string differs for each database dialect, so be sure to check the <a href="https://docs.sqlalchemy.org/en/13/core/engines.html#database-urls" rel="nofollow">Database URLs</a> for whichever database you’re using.',Zt,Q,ds="For SQLite, it is:",Yt,S,Gt,V,ms='Load the table by passing the table name and URI to <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_sql">from_sql()</a>:',Xt,E,It,B,cs='Then you can use all of 🤗 Datasets process features like <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> for example:',Ft,D,Nt,W,fs="You can also load a dataset from a SQL query instead of an entire table, which is useful for querying and joining multiple tables.",Ht,P,hs='Load the dataset by passing your query and URI to <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_sql">from_sql()</a>:',zt,A,Lt,K,us='Then you can use all of 🤗 Datasets process features like <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> for example:',Qt,O,St,tt,Vt,st,gs='You can also connect and load a dataset from a PostgreSQL database, however we won’t directly demonstrate how in the documentation because the example is only meant to be run in a notebook. Instead, take a look at how to install and setup a PostgreSQL server in this <a href="https://colab.research.google.com/github/nateraw/huggingface-hub-examples/blob/main/sql_with_huggingface_datasets.ipynb#scrollTo=d83yGQMPHGFi" rel="nofollow">notebook</a>!',Et,at,Ms='After you’ve setup your PostgreSQL database, you can use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_sql">from_sql()</a> method to load a dataset from a table or query.',Bt,nt,Dt;return M=new et({props:{title:"Load tabular data",local:"load-tabular-data",headingTag:"h1"}}),J=new et({props:{title:"CSV files",local:"csv-files",headingTag:"h2"}}),w=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTIybXlfZmlsZS5jc3YlMjIpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTVCJTIybXlfZmlsZV8xLmNzdiUyMiUyQyUyMCUyMm15X2ZpbGVfMi5jc3YlMjIlMkMlMjAlMjJteV9maWxlXzMuY3N2JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=<span class="hljs-string">&quot;my_file.csv&quot;</span>)

<span class="hljs-comment"># load multiple CSV files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=[<span class="hljs-string">&quot;my_file_1.csv&quot;</span>, <span class="hljs-string">&quot;my_file_2.csv&quot;</span>, <span class="hljs-string">&quot;my_file_3.csv&quot;</span>])`,wrap:!1}}),b=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTdCJTIydHJhaW4lMjIlM0ElMjAlNUIlMjJteV90cmFpbl9maWxlXzEuY3N2JTIyJTJDJTIwJTIybXlfdHJhaW5fZmlsZV8yLmNzdiUyMiU1RCUyQyUyMCUyMnRlc3QlMjIlM0ElMjAlMjJteV90ZXN0X2ZpbGUuY3N2JTIyJTdEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files={<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;my_train_file_1.csv&quot;</span>, <span class="hljs-string">&quot;my_train_file_2.csv&quot;</span>], <span class="hljs-string">&quot;test&quot;</span>: <span class="hljs-string">&quot;my_test_file.csv&quot;</span>})',wrap:!1}}),x=new u({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZsaG9lc3RxJTJGZGVtbzElMkZyZXNvbHZlJTJGbWFpbiUyRmRhdGElMkYlMjIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdjc3YnJTJDJTIwZGF0YV9maWxlcyUzRCU3QiUyMnRyYWluJTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0cmFpbi5jc3YlMjIlMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0ZXN0LmNzdiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>base_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/lhoestq/demo1/resolve/main/data/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;csv&#x27;</span>, data_files={<span class="hljs-string">&quot;train&quot;</span>: base_url + <span class="hljs-string">&quot;train.csv&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.csv&quot;</span>})`,wrap:!1}}),q=new u({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZkb21haW4ub3JnJTJGdHJhaW5fZGF0YS56aXAlMjIlMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTdCJTIydHJhaW4lMjIlM0ElMjB1cmwlN0QlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://domain.org/train_data.zip&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&quot;train&quot;</span>: url}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files)`,wrap:!1}}),v=new et({props:{title:"Pandas DataFrames",local:"pandas-dataframes",headingTag:"h2"}}),R=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEFkZiUyMCUzRCUyMHBkLnJlYWRfY3N2KCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmltb2RlbHMlMkZjcmVkaXQtY2FyZCUyRnJhdyUyRm1haW4lMkZ0cmFpbi5jc3YlMjIpJTBBZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZGYpJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9wYW5kYXMoZGYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># create a Pandas DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;https://huggingface.co/datasets/imodels/credit-card/raw/main/train.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.DataFrame(df)
<span class="hljs-comment"># load Dataset from Pandas DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = Dataset.from_pandas(df)`,wrap:!1}}),Z=new u({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fcGFuZGFzKHRyYWluX2RmJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEF0ZXN0X2RzJTIwJTNEJTIwRGF0YXNldC5mcm9tX3BhbmRhcyh0ZXN0X2RmJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds = Dataset.from_pandas(train_df, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds = Dataset.from_pandas(test_df, split=<span class="hljs-string">&quot;test&quot;</span>)`,wrap:!1}}),G=new et({props:{title:"Databases",local:"databases",headingTag:"h2"}}),I=new et({props:{title:"SQLite",local:"sqlite",headingTag:"h3"}}),H=new u({props:{code:"aW1wb3J0JTIwc3FsaXRlMyUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEFjb25uJTIwJTNEJTIwc3FsaXRlMy5jb25uZWN0KCUyMnVzX2NvdmlkX2RhdGEuZGIlMjIpJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZueXRpbWVzJTJGY292aWQtMTktZGF0YSUyRm1hc3RlciUyRnVzLXN0YXRlcy5jc3YlMjIpJTBBZGYudG9fc3FsKCUyMnN0YXRlcyUyMiUyQyUyMGNvbm4lMkMlMjBpZl9leGlzdHMlM0QlMjJyZXBsYWNlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> sqlite3
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>conn = sqlite3.connect(<span class="hljs-string">&quot;us_covid_data.db&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;https://raw.githubusercontent.com/nytimes/covid-19-data/master/us-states.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_sql(<span class="hljs-string">&quot;states&quot;</span>, conn, if_exists=<span class="hljs-string">&quot;replace&quot;</span>)`,wrap:!1}}),S=new u({props:{code:"dXJpJTIwJTNEJTIwJTIyc3FsaXRlJTNBJTJGJTJGJTJGdXNfY292aWRfZGF0YS5kYiUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>uri = <span class="hljs-string">&quot;sqlite:///us_covid_data.db&quot;</span>',wrap:!1}}),E=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX3NxbCglMjJzdGF0ZXMlMjIlMkMlMjB1cmkpJTBBZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_sql(<span class="hljs-string">&quot;states&quot;</span>, uri)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;index&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;state&#x27;</span>, <span class="hljs-string">&#x27;fips&#x27;</span>, <span class="hljs-string">&#x27;cases&#x27;</span>, <span class="hljs-string">&#x27;deaths&#x27;</span>],
    num_rows: <span class="hljs-number">54382</span>
})`,wrap:!1}}),D=new u({props:{code:"ZHMuZmlsdGVyKGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyc3RhdGUlMjIlNUQlMjAlM0QlM0QlMjAlMjJDYWxpZm9ybmlhJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;state&quot;</span>] == <span class="hljs-string">&quot;California&quot;</span>)',wrap:!1}}),A=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX3NxbCgnU0VMRUNUJTIwKiUyMEZST00lMjBzdGF0ZXMlMjBXSEVSRSUyMHN0YXRlJTNEJTIyQ2FsaWZvcm5pYSUyMiUzQiclMkMlMjB1cmkpJTBBZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_sql(<span class="hljs-string">&#x27;SELECT * FROM states WHERE state=&quot;California&quot;;&#x27;</span>, uri)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;index&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;state&#x27;</span>, <span class="hljs-string">&#x27;fips&#x27;</span>, <span class="hljs-string">&#x27;cases&#x27;</span>, <span class="hljs-string">&#x27;deaths&#x27;</span>],
    num_rows: <span class="hljs-number">1019</span>
})`,wrap:!1}}),O=new u({props:{code:"ZHMuZmlsdGVyKGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyY2FzZXMlMjIlNUQlMjAlM0UlMjAxMDAwMCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;cases&quot;</span>] &gt; <span class="hljs-number">10000</span>)',wrap:!1}}),tt=new et({props:{title:"PostgreSQL",local:"postgresql",headingTag:"h3"}}),{c(){g=p("meta"),pt=l(),lt=p("p"),it=l(),o(M.$$.fragment),rt=l(),y=p("p"),y.textContent=Pt,ot=l(),j=p("ul"),j.innerHTML=At,dt=l(),o(J.$$.fragment),mt=l(),T=p("p"),T.innerHTML=Kt,ct=l(),o(w.$$.fragment),ft=l(),$=p("p"),$.textContent=Ot,ht=l(),o(b.$$.fragment),ut=l(),_=p("p"),_.textContent=ts,gt=l(),o(x.$$.fragment),Mt=l(),C=p("p"),C.textContent=ss,yt=l(),o(q.$$.fragment),jt=l(),o(v.$$.fragment),Jt=l(),k=p("p"),k.innerHTML=as,Tt=l(),o(R.$$.fragment),wt=l(),U=p("p"),U.innerHTML=es,$t=l(),o(Z.$$.fragment),bt=l(),Y=p("p"),Y.innerHTML=ls,_t=l(),o(G.$$.fragment),xt=l(),X=p("p"),X.textContent=ns,Ct=l(),o(I.$$.fragment),qt=l(),F=p("p"),F.textContent=ps,vt=l(),N=p("p"),N.innerHTML=is,kt=l(),o(H.$$.fragment),Rt=l(),z=p("p"),z.innerHTML=rs,Ut=l(),L=p("p"),L.innerHTML=os,Zt=l(),Q=p("p"),Q.textContent=ds,Yt=l(),o(S.$$.fragment),Gt=l(),V=p("p"),V.innerHTML=ms,Xt=l(),o(E.$$.fragment),It=l(),B=p("p"),B.innerHTML=cs,Ft=l(),o(D.$$.fragment),Nt=l(),W=p("p"),W.textContent=fs,Ht=l(),P=p("p"),P.innerHTML=hs,zt=l(),o(A.$$.fragment),Lt=l(),K=p("p"),K.innerHTML=us,Qt=l(),o(O.$$.fragment),St=l(),o(tt.$$.fragment),Vt=l(),st=p("p"),st.innerHTML=gs,Et=l(),at=p("p"),at.innerHTML=Ms,Bt=l(),nt=p("p"),this.h()},l(t){const s=_s("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(a),pt=n(t),lt=i(t,"P",{}),ys(lt).forEach(a),it=n(t),d(M.$$.fragment,t),rt=n(t),y=i(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1wme3lm"&&(y.textContent=Pt),ot=n(t),j=i(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1nq9ez5"&&(j.innerHTML=At),dt=n(t),d(J.$$.fragment,t),mt=n(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1yf2wzv"&&(T.innerHTML=Kt),ct=n(t),d(w.$$.fragment,t),ft=n(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-qtb2i7"&&($.textContent=Ot),ht=n(t),d(b.$$.fragment,t),ut=n(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1e176xs"&&(_.textContent=ts),gt=n(t),d(x.$$.fragment,t),Mt=n(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1swu4q4"&&(C.textContent=ss),yt=n(t),d(q.$$.fragment,t),jt=n(t),d(v.$$.fragment,t),Jt=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1vxlu4a"&&(k.innerHTML=as),Tt=n(t),d(R.$$.fragment,t),wt=n(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-11xgfy5"&&(U.innerHTML=es),$t=n(t),d(Z.$$.fragment,t),bt=n(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-dgrtkz"&&(Y.innerHTML=ls),_t=n(t),d(G.$$.fragment,t),xt=n(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1wga9b8"&&(X.textContent=ns),Ct=n(t),d(I.$$.fragment,t),qt=n(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1rscjmw"&&(F.textContent=ps),vt=n(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-m8crgu"&&(N.innerHTML=is),kt=n(t),d(H.$$.fragment,t),Rt=n(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-e7mw7n"&&(z.innerHTML=rs),Ut=n(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1l5btzf"&&(L.innerHTML=os),Zt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hulh3i"&&(Q.textContent=ds),Yt=n(t),d(S.$$.fragment,t),Gt=n(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-91542z"&&(V.innerHTML=ms),Xt=n(t),d(E.$$.fragment,t),It=n(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-dy6g1x"&&(B.innerHTML=cs),Ft=n(t),d(D.$$.fragment,t),Nt=n(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-zt9jdv"&&(W.textContent=fs),Ht=n(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-8dropk"&&(P.innerHTML=hs),zt=n(t),d(A.$$.fragment,t),Lt=n(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-dy6g1x"&&(K.innerHTML=us),Qt=n(t),d(O.$$.fragment,t),St=n(t),d(tt.$$.fragment,t),Vt=n(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-83xeoy"&&(st.innerHTML=gs),Et=n(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-am0i54"&&(at.innerHTML=Ms),Bt=n(t),nt=i(t,"P",{}),ys(nt).forEach(a),this.h()},h(){js(g,"name","hf:doc:metadata"),js(g,"content",qs)},m(t,s){xs(document.head,g),e(t,pt,s),e(t,lt,s),e(t,it,s),m(M,t,s),e(t,rt,s),e(t,y,s),e(t,ot,s),e(t,j,s),e(t,dt,s),m(J,t,s),e(t,mt,s),e(t,T,s),e(t,ct,s),m(w,t,s),e(t,ft,s),e(t,$,s),e(t,ht,s),m(b,t,s),e(t,ut,s),e(t,_,s),e(t,gt,s),m(x,t,s),e(t,Mt,s),e(t,C,s),e(t,yt,s),m(q,t,s),e(t,jt,s),m(v,t,s),e(t,Jt,s),e(t,k,s),e(t,Tt,s),m(R,t,s),e(t,wt,s),e(t,U,s),e(t,$t,s),m(Z,t,s),e(t,bt,s),e(t,Y,s),e(t,_t,s),m(G,t,s),e(t,xt,s),e(t,X,s),e(t,Ct,s),m(I,t,s),e(t,qt,s),e(t,F,s),e(t,vt,s),e(t,N,s),e(t,kt,s),m(H,t,s),e(t,Rt,s),e(t,z,s),e(t,Ut,s),e(t,L,s),e(t,Zt,s),e(t,Q,s),e(t,Yt,s),m(S,t,s),e(t,Gt,s),e(t,V,s),e(t,Xt,s),m(E,t,s),e(t,It,s),e(t,B,s),e(t,Ft,s),m(D,t,s),e(t,Nt,s),e(t,W,s),e(t,Ht,s),e(t,P,s),e(t,zt,s),m(A,t,s),e(t,Lt,s),e(t,K,s),e(t,Qt,s),m(O,t,s),e(t,St,s),m(tt,t,s),e(t,Vt,s),e(t,st,s),e(t,Et,s),e(t,at,s),e(t,Bt,s),e(t,nt,s),Dt=!0},p:Ts,i(t){Dt||(c(M.$$.fragment,t),c(J.$$.fragment,t),c(w.$$.fragment,t),c(b.$$.fragment,t),c(x.$$.fragment,t),c(q.$$.fragment,t),c(v.$$.fragment,t),c(R.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(I.$$.fragment,t),c(H.$$.fragment,t),c(S.$$.fragment,t),c(E.$$.fragment,t),c(D.$$.fragment,t),c(A.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),Dt=!0)},o(t){f(M.$$.fragment,t),f(J.$$.fragment,t),f(w.$$.fragment,t),f(b.$$.fragment,t),f(x.$$.fragment,t),f(q.$$.fragment,t),f(v.$$.fragment,t),f(R.$$.fragment,t),f(Z.$$.fragment,t),f(G.$$.fragment,t),f(I.$$.fragment,t),f(H.$$.fragment,t),f(S.$$.fragment,t),f(E.$$.fragment,t),f(D.$$.fragment,t),f(A.$$.fragment,t),f(O.$$.fragment,t),f(tt.$$.fragment,t),Dt=!1},d(t){t&&(a(pt),a(lt),a(it),a(rt),a(y),a(ot),a(j),a(dt),a(mt),a(T),a(ct),a(ft),a($),a(ht),a(ut),a(_),a(gt),a(Mt),a(C),a(yt),a(jt),a(Jt),a(k),a(Tt),a(wt),a(U),a($t),a(bt),a(Y),a(_t),a(xt),a(X),a(Ct),a(qt),a(F),a(vt),a(N),a(kt),a(Rt),a(z),a(Ut),a(L),a(Zt),a(Q),a(Yt),a(Gt),a(V),a(Xt),a(It),a(B),a(Ft),a(Nt),a(W),a(Ht),a(P),a(zt),a(Lt),a(K),a(Qt),a(St),a(Vt),a(st),a(Et),a(at),a(Bt),a(nt)),a(g),h(M,t),h(J,t),h(w,t),h(b,t),h(x,t),h(q,t),h(v,t),h(R,t),h(Z,t),h(G,t),h(I,t),h(H,t),h(S,t),h(E,t),h(D,t),h(A,t),h(O,t),h(tt,t)}}}const qs='{"title":"Load tabular data","local":"load-tabular-data","sections":[{"title":"CSV files","local":"csv-files","sections":[],"depth":2},{"title":"Pandas DataFrames","local":"pandas-dataframes","sections":[],"depth":2},{"title":"Databases","local":"databases","sections":[{"title":"SQLite","local":"sqlite","sections":[],"depth":3},{"title":"PostgreSQL","local":"postgresql","sections":[],"depth":3}],"depth":2}],"depth":1}';function vs(Wt){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends $s{constructor(g){super(),bs(this,g,vs,Cs,Js,{})}}export{Ys as component};
