import{s as Ja,o as Ta,n as ja}from"../chunks/scheduler.bdbef820.js";import{S as wa,i as Ua,g as r,s as n,r as h,A as ka,h as i,f as t,c as l,j as Ma,u,x as o,k as ga,y as Ia,a as e,v as d,d as f,t as y,w as M}from"../chunks/index.c0aea24a.js";import{T as $a}from"../chunks/Tip.31005f7d.js";import{C as la}from"../chunks/CodeBlock.6ccca92e.js";import{H as na}from"../chunks/Heading.2eb892cb.js";function ba(v){let p,g='In a different session, a Spark DataFrame doesn’t have the same <a href="https://spark.apache.org/docs/3.2.0/api/python/reference/api/pyspark.sql.DataFrame.semanticHash.html" rel="nofollow">semantic hash</a>, and it will rerun a Spark job and store it in a new cache.';return{c(){p=r("p"),p.innerHTML=g},l(m){p=i(m,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1m6gjz4"&&(p.innerHTML=g)},m(m,Z){e(m,p,Z)},p:ja,d(m){m&&t(p)}}}function _a(v){let p,g,m,Z,J,W,T,pa='This document is a quick introduction to using 🤗 Datasets with Spark, with a particular focus on how to load a Spark DataFrame into a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object.',z,j,ra="From there, you have fast access to any element and you can use it as a data loader to train models.",S,w,x,U,ia=`A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast reads from arrays in the dataset to PyTorch, TensorFlow and JAX tensors.
The Arrow table is memory mapped from disk, which can load datasets bigger than your available RAM.`,X,k,ma='You can get a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> from a Spark DataFrame using <code>Dataset.from_spark()</code>:',B,I,E,$,oa='The Spark workers write the dataset on disk in a cache directory as Arrow files, and the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> is loaded from there.',H,b,ca='Alternatively, you can skip materialization by using <code>IterableDataset.from_spark()</code>, which returns an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',N,_,L,C,V,R,ha=`When using <code>Dataset.from_spark()</code>, the resulting <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> is cached; if you call <code>Dataset.from_spark()</code> multiple
times on the same DataFrame it won’t re-run the Spark job that writes the dataset as Arrow files on disk.`,A,F,ua=`You can set the cache location by passing <code>cache_dir=</code> to <code>Dataset.from_spark()</code>.
Make sure to use a disk that is available to both your workers and your current machine (the driver).`,P,c,K,D,O,Q,da=`If your dataset is made of images, audio data or N-dimensional arrays, you can specify the <code>features=</code> argument in
<code>Dataset.from_spark()</code> (or <code>IterableDataset.from_spark()</code>):`,aa,q,sa,G,fa='You can check the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Features">Features</a> documentation to know about all the feature types available.',ta,Y,ea;return J=new na({props:{title:"Use with Spark",local:"use-with-spark",headingTag:"h1"}}),w=new na({props:{title:"Load from Spark",local:"load-from-spark",headingTag:"h2"}}),I=new la({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRmJTIwJTNEJTIwc3BhcmsuY3JlYXRlRGF0YUZyYW1lKCUwQSUyMCUyMCUyMCUyMGRhdGElM0QlNUIlNUIxJTJDJTIwJTIyRWxpYSUyMiU1RCUyQyUyMCU1QjIlMkMlMjAlMjJUZW8lMjIlNUQlMkMlMjAlNUIzJTJDJTIwJTIyRmFuZyUyMiU1RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJpZCUyMiUyQyUyMCUyMm5hbWUlMjIlNUQlMkMlMEEpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fc3BhcmsoZGYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>df = spark.createDataFrame(
<span class="hljs-meta">... </span>    data=[[<span class="hljs-number">1</span>, <span class="hljs-string">&quot;Elia&quot;</span>], [<span class="hljs-number">2</span>, <span class="hljs-string">&quot;Teo&quot;</span>], [<span class="hljs-number">3</span>, <span class="hljs-string">&quot;Fang&quot;</span>]],
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_spark(df)`,wrap:!1}}),_=new la({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwSXRlcmFibGVEYXRhc2V0JTBBZGYlMjAlM0QlMjBzcGFyay5jcmVhdGVEYXRhRnJhbWUoJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCU1QiU1QjElMkMlMjAlMjJFbGlhJTIyJTVEJTJDJTIwJTVCMiUyQyUyMCUyMlRlbyUyMiU1RCUyQyUyMCU1QjMlMkMlMjAlMjJGYW5nJTIyJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmlkJTIyJTJDJTIwJTIybmFtZSUyMiU1RCUyQyUwQSklMEFkcyUyMCUzRCUyMEl0ZXJhYmxlRGF0YXNldC5mcm9tX3NwYXJrKGRmKSUwQXByaW50KG5leHQoaXRlcihkcykpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> IterableDataset
<span class="hljs-meta">&gt;&gt;&gt; </span>df = spark.createDataFrame(
<span class="hljs-meta">... </span>    data=[[<span class="hljs-number">1</span>, <span class="hljs-string">&quot;Elia&quot;</span>], [<span class="hljs-number">2</span>, <span class="hljs-string">&quot;Teo&quot;</span>], [<span class="hljs-number">3</span>, <span class="hljs-string">&quot;Fang&quot;</span>]],
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = IterableDataset.from_spark(df)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(ds)))
{<span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Elia&quot;</span>}`,wrap:!1}}),C=new na({props:{title:"Caching",local:"caching",headingTag:"h3"}}),c=new $a({props:{warning:!0,$$slots:{default:[ba]},$$scope:{ctx:v}}}),D=new na({props:{title:"Feature types",local:"feature-types",headingTag:"h3"}}),q=new la({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwSW1hZ2UlMkMlMjBWYWx1ZSUwQWRhdGElMjAlM0QlMjAlNUIoMCUyQyUyMG9wZW4oJTIyaW1hZ2UucG5nJTIyJTJDJTIwJTIycmIlMjIpLnJlYWQoKSklNUQlMEFkZiUyMCUzRCUyMHNwYXJrLmNyZWF0ZURhdGFGcmFtZShkYXRhJTJDJTIwJTIyaWR4JTNBJTIwaW50JTJDJTIwaW1hZ2UlM0ElMjBiaW5hcnklMjIpJTBBJTIzJTIwQWxzbyUyMHdvcmtzJTIwaWYlMjB5b3UlMjBoYXZlJTIwYXJyYXlzJTBBJTIzJTIwZGF0YSUyMCUzRCUyMCU1QigwJTJDJTIwbnAuemVyb3Moc2hhcGUlM0QoMzIlMkMlMjAzMiUyQyUyMDMpJTJDJTIwZHR5cGUlM0RucC5pbnQzMikudG9saXN0KCkpJTVEJTBBJTIzJTIwZGYlMjAlM0QlMjBzcGFyay5jcmVhdGVEYXRhRnJhbWUoZGF0YSUyQyUyMCUyMmlkeCUzQSUyMGludCUyQyUyMGltYWdlJTNBJTIwYXJyYXklM0NhcnJheSUzQ2FycmF5JTNDaW50JTNFJTNFJTNFJTIyKSUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaWR4JTIyJTNBJTIwVmFsdWUoJTIyaW50NjQlMjIpJTJDJTIwJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fc3BhcmsoZGYlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Image, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [(<span class="hljs-number">0</span>, <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;image.png&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read())]
<span class="hljs-meta">&gt;&gt;&gt; </span>df = spark.createDataFrame(data, <span class="hljs-string">&quot;idx: int, image: binary&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Also works if you have arrays</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># data = [(0, np.zeros(shape=(32, 32, 3), dtype=np.int32).tolist())]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># df = spark.createDataFrame(data, &quot;idx: int, image: array&lt;array&lt;array&lt;int&gt;&gt;&gt;&quot;)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;idx&quot;</span>: Value(<span class="hljs-string">&quot;int64&quot;</span>), <span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = Dataset.from_spark(df, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=RGB size=32x32&gt;}`,wrap:!1}}),{c(){p=r("meta"),g=n(),m=r("p"),Z=n(),h(J.$$.fragment),W=n(),T=r("p"),T.innerHTML=pa,z=n(),j=r("p"),j.textContent=ra,S=n(),h(w.$$.fragment),x=n(),U=r("p"),U.innerHTML=ia,X=n(),k=r("p"),k.innerHTML=ma,B=n(),h(I.$$.fragment),E=n(),$=r("p"),$.innerHTML=oa,H=n(),b=r("p"),b.innerHTML=ca,N=n(),h(_.$$.fragment),L=n(),h(C.$$.fragment),V=n(),R=r("p"),R.innerHTML=ha,A=n(),F=r("p"),F.innerHTML=ua,P=n(),h(c.$$.fragment),K=n(),h(D.$$.fragment),O=n(),Q=r("p"),Q.innerHTML=da,aa=n(),h(q.$$.fragment),sa=n(),G=r("p"),G.innerHTML=fa,ta=n(),Y=r("p"),this.h()},l(a){const s=ka("svelte-u9bgzb",document.head);p=i(s,"META",{name:!0,content:!0}),s.forEach(t),g=l(a),m=i(a,"P",{}),Ma(m).forEach(t),Z=l(a),u(J.$$.fragment,a),W=l(a),T=i(a,"P",{"data-svelte-h":!0}),o(T)!=="svelte-n01qzp"&&(T.innerHTML=pa),z=l(a),j=i(a,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1pvlf1d"&&(j.textContent=ra),S=l(a),u(w.$$.fragment,a),x=l(a),U=i(a,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1qkrgz7"&&(U.innerHTML=ia),X=l(a),k=i(a,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1r572x2"&&(k.innerHTML=ma),B=l(a),u(I.$$.fragment,a),E=l(a),$=i(a,"P",{"data-svelte-h":!0}),o($)!=="svelte-kc65ui"&&($.innerHTML=oa),H=l(a),b=i(a,"P",{"data-svelte-h":!0}),o(b)!=="svelte-eu4ytu"&&(b.innerHTML=ca),N=l(a),u(_.$$.fragment,a),L=l(a),u(C.$$.fragment,a),V=l(a),R=i(a,"P",{"data-svelte-h":!0}),o(R)!=="svelte-176k11x"&&(R.innerHTML=ha),A=l(a),F=i(a,"P",{"data-svelte-h":!0}),o(F)!=="svelte-n6wfk7"&&(F.innerHTML=ua),P=l(a),u(c.$$.fragment,a),K=l(a),u(D.$$.fragment,a),O=l(a),Q=i(a,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-9b4dmt"&&(Q.innerHTML=da),aa=l(a),u(q.$$.fragment,a),sa=l(a),G=i(a,"P",{"data-svelte-h":!0}),o(G)!=="svelte-iwja1a"&&(G.innerHTML=fa),ta=l(a),Y=i(a,"P",{}),Ma(Y).forEach(t),this.h()},h(){ga(p,"name","hf:doc:metadata"),ga(p,"content",Ca)},m(a,s){Ia(document.head,p),e(a,g,s),e(a,m,s),e(a,Z,s),d(J,a,s),e(a,W,s),e(a,T,s),e(a,z,s),e(a,j,s),e(a,S,s),d(w,a,s),e(a,x,s),e(a,U,s),e(a,X,s),e(a,k,s),e(a,B,s),d(I,a,s),e(a,E,s),e(a,$,s),e(a,H,s),e(a,b,s),e(a,N,s),d(_,a,s),e(a,L,s),d(C,a,s),e(a,V,s),e(a,R,s),e(a,A,s),e(a,F,s),e(a,P,s),d(c,a,s),e(a,K,s),d(D,a,s),e(a,O,s),e(a,Q,s),e(a,aa,s),d(q,a,s),e(a,sa,s),e(a,G,s),e(a,ta,s),e(a,Y,s),ea=!0},p(a,[s]){const ya={};s&2&&(ya.$$scope={dirty:s,ctx:a}),c.$set(ya)},i(a){ea||(f(J.$$.fragment,a),f(w.$$.fragment,a),f(I.$$.fragment,a),f(_.$$.fragment,a),f(C.$$.fragment,a),f(c.$$.fragment,a),f(D.$$.fragment,a),f(q.$$.fragment,a),ea=!0)},o(a){y(J.$$.fragment,a),y(w.$$.fragment,a),y(I.$$.fragment,a),y(_.$$.fragment,a),y(C.$$.fragment,a),y(c.$$.fragment,a),y(D.$$.fragment,a),y(q.$$.fragment,a),ea=!1},d(a){a&&(t(g),t(m),t(Z),t(W),t(T),t(z),t(j),t(S),t(x),t(U),t(X),t(k),t(B),t(E),t($),t(H),t(b),t(N),t(L),t(V),t(R),t(A),t(F),t(P),t(K),t(O),t(Q),t(aa),t(sa),t(G),t(ta),t(Y)),t(p),M(J,a),M(w,a),M(I,a),M(_,a),M(C,a),M(c,a),M(D,a),M(q,a)}}}const Ca='{"title":"Use with Spark","local":"use-with-spark","sections":[{"title":"Load from Spark","local":"load-from-spark","sections":[{"title":"Caching","local":"caching","sections":[],"depth":3},{"title":"Feature types","local":"feature-types","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ra(v){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends wa{constructor(p){super(),Ua(this,p,Ra,_a,Ja,{})}}export{Za as component};
