import{s as ia,n as pa,o as ra}from"../chunks/scheduler.bdbef820.js";import{S as oa,i as ma,g as i,s as n,r as o,A as ca,h as p,f as s,c as l,j as na,u as m,x as r,k as la,y as da,a as t,v as c,d,t as h,w as g}from"../chunks/index.c0aea24a.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as K}from"../chunks/Heading.2eb892cb.js";function ha(qe){let u,ae,O,se,b,te,j,ze='There are two types of dataset objects, a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and then an ✨ <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> ✨. A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> provides fast random access to the rows, and memory-mapping so that loading even large datasets only uses a relatively small amount of device memory. But for really, really big datasets that won’t even fit on disk or in memory, an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> allows you to access and use the dataset without waiting for it to download completely!',ne,x,He='This tutorial will show you how to load and access a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',le,w,ie,y,Ye='When you load a dataset split, you’ll get a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. You can do many things with a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, which is why it’s important to learn how to manipulate and interact with the data stored inside.',pe,$,Qe='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset, but feel free to load any dataset you’d like and follow along!',re,M,oe,_,me,k,Le='A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> contains columns of data, and each column can be a different type of data. The <em>index</em>, or axis label, is used to access examples from the dataset. For example, indexing by the row returns a dictionary of an example from the dataset:',ce,T,de,v,Pe="Use the <code>-</code> operator to start from the end of the dataset:",he,U,ge,I,We="Indexing by the column name returns a list of all the values in the column:",fe,J,ue,C,Ne="You can combine row and column name indexing to return a specific value at a position:",be,G,je,R,Se="But it is important to remember that indexing order matters, especially when working with large audio and image datasets. Indexing by the column name returns all the values in the column first, then loads the value at that position. For large datasets, it may be slower to index by the column name first.",xe,Z,we,D,ye,X,Ee="Slicing returns a slice - or subset - of the dataset, which is useful for viewing several rows at once. To slice a dataset, use the <code>:</code> operator to specify a range of positions.",$e,B,Me,F,_e,q,Ve='An <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is loaded when you set the <code>streaming</code> parameter to <code>True</code> in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',ke,z,Te,H,Ae='You can also create an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> from an <em>existing</em> <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, but it is faster than streaming mode because the dataset is streamed from local files:',ve,Y,Ue,Q,Ke='An <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> progressively iterates over a dataset one example at a time, so you don’t have to wait for the whole dataset to download before you can use it. As you can imagine, this is quite useful for large datasets you want to use immediately!',Ie,L,Oe='However, this means an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>’s behavior is different from a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>. You don’t get random access to examples in an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. Instead, you should iterate over its elements, for example, by calling <code>next(iter())</code> or with a <code>for</code> loop to return the next item from the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Je,P,Ce,W,ea='You can return a subset of the dataset with a specific number of examples in it with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a>:',Ge,N,Re,S,aa='But unlike <a href="access/#slicing">slicing</a>, <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> creates a new <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Ze,E,De,V,sa='Interested in learning more about the differences between these two types of datasets? Learn more about them in the <a href="about_mapstyle_vs_iterable">Differences between <code>Dataset</code> and <code>IterableDataset</code></a> conceptual guide.',Xe,A,ta='To get more hands-on with these datasets types, check out the <a href="process">Process</a> guide to learn how to preprocess a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or the <a href="stream">Stream</a> guide to learn how to preprocess an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Be,ee,Fe;return b=new K({props:{title:"Know your dataset",local:"know-your-dataset",headingTag:"h1"}}),w=new K({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),M=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),_=new K({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),T=new f({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Get the first row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>}`,wrap:!1}}),U=new f({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:`<span class="hljs-comment"># Get the last row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[-<span class="hljs-number">1</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>}`,wrap:!1}}),J=new f({props:{code:"ZGF0YXNldCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;text&quot;</span>]
[<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
 <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
 <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
 ...,
 <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>]`,wrap:!1}}),G=new f({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>`,wrap:!1}}),Z=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXRleHQlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMnRleHQlMjIlNUQlMEFlbmRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBcHJpbnQoZiUyMkVsYXBzZWQlMjB0aW1lJTNBJTIwJTdCZW5kX3RpbWUlMjAtJTIwc3RhcnRfdGltZSUzQS40ZiU3RCUyMHNlY29uZHMlMjIpJTBBJTBBc3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBdGV4dCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCMCU1RCUwQWVuZF90aW1lJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyRWxhcHNlZCUyMHRpbWUlM0ElMjAlN0JlbmRfdGltZSUyMC0lMjBzdGFydF90aW1lJTNBLjRmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0031</span> seconds

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-string">&quot;text&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0094</span> seconds`,wrap:!1}}),D=new K({props:{title:"Slicing",local:"slicing",headingTag:"h3"}}),B=new f({props:{code:"ZGF0YXNldCU1QiUzQTMlNUQlMEElMEFkYXRhc2V0JTVCMyUzQTYlNUQ=",highlighted:`<span class="hljs-comment"># Get the first three rows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
  <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
  <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>]}

<span class="hljs-comment"># Get rows between three and six</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">3</span>:<span class="hljs-number">6</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>,
  <span class="hljs-string">&quot;emerges as something rare , an issue movie that&#x27;s so honest and keenly observed that it doesn&#x27;t feel like one .&quot;</span>,
  <span class="hljs-string">&#x27;the film provides some great insight into the neurotic mindset of all comics -- even those who have reached the absolute top of the game .&#x27;</span>]}`,wrap:!1}}),F=new K({props:{title:"IterableDataset",local:"iterabledataset",headingTag:"h2"}}),z=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F5C520</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()`,wrap:!1}}),P=new f({props:{code:"bmV4dChpdGVyKGl0ZXJhYmxlX2RhdGFzZXQpKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGl0ZXJhYmxlX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(iterable_dataset))
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F59B50</span>&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DE82B0</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),N=new f({props:{code:"bGlzdChpdGVyYWJsZV9kYXRhc2V0LnRha2UoMykp",highlighted:`<span class="hljs-comment"># Get first three examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(iterable_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DEE9D0</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x512 at <span class="hljs-number">0x7F7479DE8190</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x383 at <span class="hljs-number">0x7F7479DE8310</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}]`,wrap:!1}}),E=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){u=i("meta"),ae=n(),O=i("p"),se=n(),o(b.$$.fragment),te=n(),j=i("p"),j.innerHTML=ze,ne=n(),x=i("p"),x.innerHTML=He,le=n(),o(w.$$.fragment),ie=n(),y=i("p"),y.innerHTML=Ye,pe=n(),$=i("p"),$.innerHTML=Qe,re=n(),o(M.$$.fragment),oe=n(),o(_.$$.fragment),me=n(),k=i("p"),k.innerHTML=Le,ce=n(),o(T.$$.fragment),de=n(),v=i("p"),v.innerHTML=Pe,he=n(),o(U.$$.fragment),ge=n(),I=i("p"),I.textContent=We,fe=n(),o(J.$$.fragment),ue=n(),C=i("p"),C.textContent=Ne,be=n(),o(G.$$.fragment),je=n(),R=i("p"),R.textContent=Se,xe=n(),o(Z.$$.fragment),we=n(),o(D.$$.fragment),ye=n(),X=i("p"),X.innerHTML=Ee,$e=n(),o(B.$$.fragment),Me=n(),o(F.$$.fragment),_e=n(),q=i("p"),q.innerHTML=Ve,ke=n(),o(z.$$.fragment),Te=n(),H=i("p"),H.innerHTML=Ae,ve=n(),o(Y.$$.fragment),Ue=n(),Q=i("p"),Q.innerHTML=Ke,Ie=n(),L=i("p"),L.innerHTML=Oe,Je=n(),o(P.$$.fragment),Ce=n(),W=i("p"),W.innerHTML=ea,Ge=n(),o(N.$$.fragment),Re=n(),S=i("p"),S.innerHTML=aa,Ze=n(),o(E.$$.fragment),De=n(),V=i("p"),V.innerHTML=sa,Xe=n(),A=i("p"),A.innerHTML=ta,Be=n(),ee=i("p"),this.h()},l(e){const a=ca("svelte-u9bgzb",document.head);u=p(a,"META",{name:!0,content:!0}),a.forEach(s),ae=l(e),O=p(e,"P",{}),na(O).forEach(s),se=l(e),m(b.$$.fragment,e),te=l(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1tk0foc"&&(j.innerHTML=ze),ne=l(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1rz4ptz"&&(x.innerHTML=He),le=l(e),m(w.$$.fragment,e),ie=l(e),y=p(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1ye32n5"&&(y.innerHTML=Ye),pe=l(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-jz751l"&&($.innerHTML=Qe),re=l(e),m(M.$$.fragment,e),oe=l(e),m(_.$$.fragment,e),me=l(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-cwlj39"&&(k.innerHTML=Le),ce=l(e),m(T.$$.fragment,e),de=l(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-18jqw8v"&&(v.innerHTML=Pe),he=l(e),m(U.$$.fragment,e),ge=l(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-18othzs"&&(I.textContent=We),fe=l(e),m(J.$$.fragment,e),ue=l(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1gzsqvo"&&(C.textContent=Ne),be=l(e),m(G.$$.fragment,e),je=l(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-158alym"&&(R.textContent=Se),xe=l(e),m(Z.$$.fragment,e),we=l(e),m(D.$$.fragment,e),ye=l(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gt5d64"&&(X.innerHTML=Ee),$e=l(e),m(B.$$.fragment,e),Me=l(e),m(F.$$.fragment,e),_e=l(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-10fogjp"&&(q.innerHTML=Ve),ke=l(e),m(z.$$.fragment,e),Te=l(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-gfcs15"&&(H.innerHTML=Ae),ve=l(e),m(Y.$$.fragment,e),Ue=l(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-bs8hma"&&(Q.innerHTML=Ke),Ie=l(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1dgqf8f"&&(L.innerHTML=Oe),Je=l(e),m(P.$$.fragment,e),Ce=l(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-qblcng"&&(W.innerHTML=ea),Ge=l(e),m(N.$$.fragment,e),Re=l(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-w7qh4t"&&(S.innerHTML=aa),Ze=l(e),m(E.$$.fragment,e),De=l(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-51y7bk"&&(V.innerHTML=sa),Xe=l(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1r0xrkk"&&(A.innerHTML=ta),Be=l(e),ee=p(e,"P",{}),na(ee).forEach(s),this.h()},h(){la(u,"name","hf:doc:metadata"),la(u,"content",ga)},m(e,a){da(document.head,u),t(e,ae,a),t(e,O,a),t(e,se,a),c(b,e,a),t(e,te,a),t(e,j,a),t(e,ne,a),t(e,x,a),t(e,le,a),c(w,e,a),t(e,ie,a),t(e,y,a),t(e,pe,a),t(e,$,a),t(e,re,a),c(M,e,a),t(e,oe,a),c(_,e,a),t(e,me,a),t(e,k,a),t(e,ce,a),c(T,e,a),t(e,de,a),t(e,v,a),t(e,he,a),c(U,e,a),t(e,ge,a),t(e,I,a),t(e,fe,a),c(J,e,a),t(e,ue,a),t(e,C,a),t(e,be,a),c(G,e,a),t(e,je,a),t(e,R,a),t(e,xe,a),c(Z,e,a),t(e,we,a),c(D,e,a),t(e,ye,a),t(e,X,a),t(e,$e,a),c(B,e,a),t(e,Me,a),c(F,e,a),t(e,_e,a),t(e,q,a),t(e,ke,a),c(z,e,a),t(e,Te,a),t(e,H,a),t(e,ve,a),c(Y,e,a),t(e,Ue,a),t(e,Q,a),t(e,Ie,a),t(e,L,a),t(e,Je,a),c(P,e,a),t(e,Ce,a),t(e,W,a),t(e,Ge,a),c(N,e,a),t(e,Re,a),t(e,S,a),t(e,Ze,a),c(E,e,a),t(e,De,a),t(e,V,a),t(e,Xe,a),t(e,A,a),t(e,Be,a),t(e,ee,a),Fe=!0},p:pa,i(e){Fe||(d(b.$$.fragment,e),d(w.$$.fragment,e),d(M.$$.fragment,e),d(_.$$.fragment,e),d(T.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),Fe=!0)},o(e){h(b.$$.fragment,e),h(w.$$.fragment,e),h(M.$$.fragment,e),h(_.$$.fragment,e),h(T.$$.fragment,e),h(U.$$.fragment,e),h(J.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),Fe=!1},d(e){e&&(s(ae),s(O),s(se),s(te),s(j),s(ne),s(x),s(le),s(ie),s(y),s(pe),s($),s(re),s(oe),s(me),s(k),s(ce),s(de),s(v),s(he),s(ge),s(I),s(fe),s(ue),s(C),s(be),s(je),s(R),s(xe),s(we),s(ye),s(X),s($e),s(Me),s(_e),s(q),s(ke),s(Te),s(H),s(ve),s(Ue),s(Q),s(Ie),s(L),s(Je),s(Ce),s(W),s(Ge),s(Re),s(S),s(Ze),s(De),s(V),s(Xe),s(A),s(Be),s(ee)),s(u),g(b,e),g(w,e),g(M,e),g(_,e),g(T,e),g(U,e),g(J,e),g(G,e),g(Z,e),g(D,e),g(B,e),g(F,e),g(z,e),g(Y,e),g(P,e),g(N,e),g(E,e)}}}const ga='{"title":"Know your dataset","local":"know-your-dataset","sections":[{"title":"Dataset","local":"dataset","sections":[{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Slicing","local":"slicing","sections":[],"depth":3}],"depth":2},{"title":"IterableDataset","local":"iterabledataset","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function fa(qe){return ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wa extends oa{constructor(u){super(),ma(this,u,fa,ha,ia,{})}}export{wa as component};
