import{s as ts,n as es,o as as}from"../chunks/scheduler.9039eef2.js";import{S as ns,i as ss,g as o,s,r as p,A as ls,h as i,f as a,c as l,j as Ha,u as d,x as r,k as Ya,l as On,y as _,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.ded8f90d.js";import{D as Kn}from"../chunks/Docstring.a2ba2b54.js";import{C as f}from"../chunks/CodeBlock.8580f3e8.js";import{H as M}from"../chunks/Heading.f027f30d.js";function os(tn){let T,pe,ie,de,j,ce,k,en="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",me,J,an='Check out a complete flexible example inside <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts</code></a> folder.',ue,C,he,$,nn=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,fe,x,Me,F,sn="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",ye,v,ln="You can also construct a model outside of the trainer and pass it as follows:",Te,I,ge,G,on='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',we,R,be,Z,Ue,z,rn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,_e,B,je,A,pn="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",ke,S,Je,E,Ce,N,dn="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",$e,X,xe,V,cn="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Fe,Q,mn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",ve,W,un="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Ie,q,Ge,L,hn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Re,H,Ze,Y,ze,D,fn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Be,P,Ae,O,Mn="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Se,K,Ee,tt,yn='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Ne,et,Xe,at,Tn='<a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',Ve,nt,Qe,st,gn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",We,lt,qe,ot,wn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Le,it,He,rt,bn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Ye,pt,De,dt,Un='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',Pe,ct,Oe,mt,_n="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Ke,ut,ta,ht,jn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",ea,ft,aa,Mt,kn="Note that in case of training adapters, we manually add a saving callback to automatically save the adapters only:",na,yt,sa,Tt,Jn="If you want to add more callbacks, make sure to add this one as well to properly save the adapters only during training.",la,gt,oa,wt,Cn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",ia,bt,ra,Ut,$n="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",pa,_t,da,jt,ca,kt,xn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,ma,Jt,ua,Ct,Fn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,ha,$t,fa,xt,vn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Ma,Ft,ya,vt,In="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",Ta,It,ga,Gt,Gn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",wa,Rt,Rn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",ba,Zt,Zn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Ua,zt,_a,Bt,zn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",ja,At,ka,St,Bn="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",Ja,Et,Ca,Nt,An=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,$a,Xt,Sn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",xa,Vt,Fa,Qt,En='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',va,Wt,Nn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",Ia,w,Xn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Ga,qt,Vn="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",Ra,Lt,Za,Ht,Qn='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',za,b,Wn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Ba,Yt,qn='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Aa,Dt,Sa,Pt,Ln="Pay attention to the following best practices when training a model with that trainer:",Ea,Ot,Hn='<li><a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Na,Kt,Xa,g,te,Da,se,Yn=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Va,ee,Qa,y,ae,Pa,le,Dn=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Oa,ne,Ka,oe,Pn=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0\`):
Id of the end of sequence token if the passed tokenizer does not have an EOS token.
shuffle (‘bool’, <em>optional</em>, defaults to True)
Shuffle the examples before they are returned`,Wa,re,qa;return j=new M({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),C=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),x=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),I=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),R=new M({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new M({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),S=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),E=new M({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),X=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),q=new f({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCklMjAlMjAlMjA=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)   ',wrap:!1}}),H=new f({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),Y=new M({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),P=new f({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),K=new f({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),et=new M({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),nt=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),lt=new M({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),it=new f({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),pt=new M({props:{title:"Control over the pretrained model",local:"trl.SFTTrainer",headingTag:"h3"}}),ct=new f({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

\`\`\`python
...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
)

trainer.train()`,wrap:!1}}),ut=new M({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),ft=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),yt=new f({props:{code:"Y2xhc3MlMjBQZWZ0U2F2aW5nQ2FsbGJhY2soVHJhaW5lckNhbGxiYWNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX3NhdmUoc2VsZiUyQyUyMGFyZ3MlMkMlMjBzdGF0ZSUyQyUyMGNvbnRyb2wlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGVja3BvaW50X3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5vdXRwdXRfZGlyJTJDJTIwZiUyMmNoZWNrcG9pbnQtJTdCc3RhdGUuZ2xvYmFsX3N0ZXAlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTVCJTIybW9kZWwlMjIlNUQuc2F2ZV9wcmV0cmFpbmVkKGNoZWNrcG9pbnRfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTIwaW4lMjBvcy5saXN0ZGlyKGNoZWNrcG9pbnRfcGF0aCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5yZW1vdmUob3MucGF0aC5qb2luKGNoZWNrcG9pbnRfcGF0aCUyQyUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PeftSavingCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_save</span>(<span class="hljs-params">self, args, state, control, **kwargs</span>):
        checkpoint_path = os.path.join(args.output_dir, <span class="hljs-string">f&quot;checkpoint-<span class="hljs-subst">{state.global_step}</span>&quot;</span>)
        kwargs[<span class="hljs-string">&quot;model&quot;</span>].save_pretrained(checkpoint_path)

        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pytorch_model.bin&quot;</span> <span class="hljs-keyword">in</span> os.listdir(checkpoint_path):
            os.remove(os.path.join(checkpoint_path, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>))`,wrap:!1}}),gt=new f({props:{code:"JTBBJTBB",highlighted:`...

callbacks = [YourCustomCallback(), PeftSavingCallback()]

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
    callbacks=callbacks
)

trainer.train()`,wrap:!1}}),bt=new M({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),_t=new f({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),jt=new M({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Jt=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),$t=new M({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Ft=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),It=new f({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),zt=new M({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),At=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Et=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Vt=new M({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),Lt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),Dt=new M({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Kt=new M({props:{title:"SFTTrainer",local:"sfttrainer",headingTag:"h2"}}),te=new Kn({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[peft.config.PeftConfig] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = False"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to <code>compute_accuracy</code>) &#x2014;
The metrics to use for evaluation. If no metrics are specified, the default metric (<code>compute_accuracy</code>) will be used.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L49"}}),ee=new M({props:{title:"ConstantLengthDataset",local:"constantlengthdataset",headingTag:"h2"}}),ae=new Kn({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"*args",val:""},{name:"**kwds",val:""}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L482"}}),ne=new M({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),pe=s(),ie=o("p"),de=s(),p(j.$$.fragment),ce=s(),k=o("p"),k.textContent=en,me=s(),J=o("p"),J.innerHTML=an,ue=s(),p(C.$$.fragment),he=s(),$=o("p"),$.innerHTML=nn,fe=s(),p(x.$$.fragment),Me=s(),F=o("p"),F.innerHTML=sn,ye=s(),v=o("p"),v.textContent=ln,Te=s(),p(I.$$.fragment),ge=s(),G=o("p"),G.innerHTML=on,we=s(),p(R.$$.fragment),be=s(),p(Z.$$.fragment),Ue=s(),z=o("p"),z.innerHTML=rn,_e=s(),p(B.$$.fragment),je=s(),A=o("p"),A.innerHTML=pn,ke=s(),p(S.$$.fragment),Je=s(),p(E.$$.fragment),Ce=s(),N=o("p"),N.innerHTML=dn,$e=s(),p(X.$$.fragment),xe=s(),V=o("p"),V.innerHTML=cn,Fe=s(),Q=o("ul"),Q.innerHTML=mn,ve=s(),W=o("p"),W.innerHTML=un,Ie=s(),p(q.$$.fragment),Ge=s(),L=o("p"),L.innerHTML=hn,Re=s(),p(H.$$.fragment),Ze=s(),p(Y.$$.fragment),ze=s(),D=o("p"),D.innerHTML=fn,Be=s(),p(P.$$.fragment),Ae=s(),O=o("p"),O.innerHTML=Mn,Se=s(),p(K.$$.fragment),Ee=s(),tt=o("p"),tt.innerHTML=yn,Ne=s(),p(et.$$.fragment),Xe=s(),at=o("p"),at.innerHTML=Tn,Ve=s(),p(nt.$$.fragment),Qe=s(),st=o("p"),st.innerHTML=gn,We=s(),p(lt.$$.fragment),qe=s(),ot=o("p"),ot.innerHTML=wn,Le=s(),p(it.$$.fragment),He=s(),rt=o("p"),rt.innerHTML=bn,Ye=s(),p(pt.$$.fragment),De=s(),dt=o("p"),dt.innerHTML=Un,Pe=s(),p(ct.$$.fragment),Oe=s(),mt=o("p"),mt.innerHTML=_n,Ke=s(),p(ut.$$.fragment),ta=s(),ht=o("p"),ht.textContent=jn,ea=s(),p(ft.$$.fragment),aa=s(),Mt=o("p"),Mt.textContent=kn,na=s(),p(yt.$$.fragment),sa=s(),Tt=o("p"),Tt.textContent=Jn,la=s(),p(gt.$$.fragment),oa=s(),wt=o("p"),wt.innerHTML=Cn,ia=s(),p(bt.$$.fragment),ra=s(),Ut=o("p"),Ut.innerHTML=$n,pa=s(),p(_t.$$.fragment),da=s(),p(jt.$$.fragment),ca=s(),kt=o("p"),kt.textContent=xn,ma=s(),p(Jt.$$.fragment),ua=s(),Ct=o("p"),Ct.textContent=Fn,ha=s(),p($t.$$.fragment),fa=s(),xt=o("p"),xt.innerHTML=vn,Ma=s(),p(Ft.$$.fragment),ya=s(),vt=o("p"),vt.innerHTML=In,Ta=s(),p(It.$$.fragment),ga=s(),Gt=o("p"),Gt.innerHTML=Gn,wa=s(),Rt=o("p"),Rt.textContent=Rn,ba=s(),Zt=o("table"),Zt.innerHTML=Zn,Ua=s(),p(zt.$$.fragment),_a=s(),Bt=o("p"),Bt.innerHTML=zn,ja=s(),p(At.$$.fragment),ka=s(),St=o("p"),St.innerHTML=Bn,Ja=s(),p(Et.$$.fragment),Ca=s(),Nt=o("p"),Nt.textContent=An,$a=s(),Xt=o("p"),Xt.textContent=Sn,xa=s(),p(Vt.$$.fragment),Fa=s(),Qt=o("p"),Qt.innerHTML=En,va=s(),Wt=o("blockquote"),Wt.innerHTML=Nn,Ia=s(),w=o("div"),w.innerHTML=Xn,Ga=s(),qt=o("p"),qt.innerHTML=Vn,Ra=s(),p(Lt.$$.fragment),Za=s(),Ht=o("p"),Ht.innerHTML=Qn,za=s(),b=o("div"),b.innerHTML=Wn,Ba=s(),Yt=o("p"),Yt.innerHTML=qn,Aa=s(),p(Dt.$$.fragment),Sa=s(),Pt=o("p"),Pt.textContent=Ln,Ea=s(),Ot=o("ul"),Ot.innerHTML=Hn,Na=s(),p(Kt.$$.fragment),Xa=s(),g=o("div"),p(te.$$.fragment),Da=s(),se=o("p"),se.innerHTML=Yn,Va=s(),p(ee.$$.fragment),Qa=s(),y=o("div"),p(ae.$$.fragment),Pa=s(),le=o("p"),le.textContent=Dn,Oa=s(),p(ne.$$.fragment),Ka=s(),oe=o("p"),oe.innerHTML=Pn,Wa=s(),re=o("p"),this.h()},l(t){const e=ls("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(a),pe=l(t),ie=i(t,"P",{}),Ha(ie).forEach(a),de=l(t),d(j.$$.fragment,t),ce=l(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-o839x3"&&(k.textContent=en),me=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-sgh7d7"&&(J.innerHTML=an),ue=l(t),d(C.$$.fragment,t),he=l(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-8asaew"&&($.innerHTML=nn),fe=l(t),d(x.$$.fragment,t),Me=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1gbidw"&&(F.innerHTML=sn),ye=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ulikv8"&&(v.textContent=ln),Te=l(t),d(I.$$.fragment,t),ge=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ryagwl"&&(G.innerHTML=on),we=l(t),d(R.$$.fragment,t),be=l(t),d(Z.$$.fragment,t),Ue=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-13sbeoj"&&(z.innerHTML=rn),_e=l(t),d(B.$$.fragment,t),je=l(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1a743rp"&&(A.innerHTML=pn),ke=l(t),d(S.$$.fragment,t),Je=l(t),d(E.$$.fragment,t),Ce=l(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-dfggk8"&&(N.innerHTML=dn),$e=l(t),d(X.$$.fragment,t),xe=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-xlwe87"&&(V.innerHTML=cn),Fe=l(t),Q=i(t,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1enki0k"&&(Q.innerHTML=mn),ve=l(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14yxh0m"&&(W.innerHTML=un),Ie=l(t),d(q.$$.fragment,t),Ge=l(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-13h81gp"&&(L.innerHTML=hn),Re=l(t),d(H.$$.fragment,t),Ze=l(t),d(Y.$$.fragment,t),ze=l(t),D=i(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-cqsf2h"&&(D.innerHTML=fn),Be=l(t),d(P.$$.fragment,t),Ae=l(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-l25vq0"&&(O.innerHTML=Mn),Se=l(t),d(K.$$.fragment,t),Ee=l(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1iqmdsd"&&(tt.innerHTML=yn),Ne=l(t),d(et.$$.fragment,t),Xe=l(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1a4epj8"&&(at.innerHTML=Tn),Ve=l(t),d(nt.$$.fragment,t),Qe=l(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-wtbvzy"&&(st.innerHTML=gn),We=l(t),d(lt.$$.fragment,t),qe=l(t),ot=i(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-iejqw3"&&(ot.innerHTML=wn),Le=l(t),d(it.$$.fragment,t),He=l(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-qqgn8q"&&(rt.innerHTML=bn),Ye=l(t),d(pt.$$.fragment,t),De=l(t),dt=i(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-oxgwyg"&&(dt.innerHTML=Un),Pe=l(t),d(ct.$$.fragment,t),Oe=l(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1rnsxc5"&&(mt.innerHTML=_n),Ke=l(t),d(ut.$$.fragment,t),ta=l(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-11jfbzz"&&(ht.textContent=jn),ea=l(t),d(ft.$$.fragment,t),aa=l(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1iplhln"&&(Mt.textContent=kn),na=l(t),d(yt.$$.fragment,t),sa=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-645tfb"&&(Tt.textContent=Jn),la=l(t),d(gt.$$.fragment,t),oa=l(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-pwdaav"&&(wt.innerHTML=Cn),ia=l(t),d(bt.$$.fragment,t),ra=l(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-zbh7v5"&&(Ut.innerHTML=$n),pa=l(t),d(_t.$$.fragment,t),da=l(t),d(jt.$$.fragment,t),ca=l(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-fyvvsj"&&(kt.textContent=xn),ma=l(t),d(Jt.$$.fragment,t),ua=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-yypgof"&&(Ct.textContent=Fn),ha=l(t),d($t.$$.fragment,t),fa=l(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-yugu96"&&(xt.innerHTML=vn),Ma=l(t),d(Ft.$$.fragment,t),ya=l(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1qms4cl"&&(vt.innerHTML=In),Ta=l(t),d(It.$$.fragment,t),ga=l(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-qe5zfz"&&(Gt.innerHTML=Gn),wa=l(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-69u1rz"&&(Rt.textContent=Rn),ba=l(t),Zt=i(t,"TABLE",{"data-svelte-h":!0}),r(Zt)!=="svelte-8fq96j"&&(Zt.innerHTML=Zn),Ua=l(t),d(zt.$$.fragment,t),_a=l(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1rqlm78"&&(Bt.innerHTML=zn),ja=l(t),d(At.$$.fragment,t),ka=l(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-sqoxna"&&(St.innerHTML=Bn),Ja=l(t),d(Et.$$.fragment,t),Ca=l(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-vfpk19"&&(Nt.textContent=An),$a=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-zatc00"&&(Xt.textContent=Sn),xa=l(t),d(Vt.$$.fragment,t),Fa=l(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-6trhkk"&&(Qt.innerHTML=En),va=l(t),Wt=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Wt)!=="svelte-1ejl1pl"&&(Wt.innerHTML=Nn),Ia=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=Xn),Ga=l(t),qt=i(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-7jwpzy"&&(qt.innerHTML=Vn),Ra=l(t),d(Lt.$$.fragment,t),Za=l(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-sqj12"&&(Ht.innerHTML=Qn),za=l(t),b=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(b)!=="svelte-a1m5gi"&&(b.innerHTML=Wn),Ba=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-rwofnh"&&(Yt.innerHTML=qn),Aa=l(t),d(Dt.$$.fragment,t),Sa=l(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-g801h1"&&(Pt.textContent=Ln),Ea=l(t),Ot=i(t,"UL",{"data-svelte-h":!0}),r(Ot)!=="svelte-1mmsr46"&&(Ot.innerHTML=Hn),Na=l(t),d(Kt.$$.fragment,t),Xa=l(t),g=i(t,"DIV",{class:!0});var La=Ha(g);d(te.$$.fragment,La),Da=l(La),se=i(La,"P",{"data-svelte-h":!0}),r(se)!=="svelte-14oyph8"&&(se.innerHTML=Yn),La.forEach(a),Va=l(t),d(ee.$$.fragment,t),Qa=l(t),y=i(t,"DIV",{class:!0});var U=Ha(y);d(ae.$$.fragment,U),Pa=l(U),le=i(U,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1dlriq1"&&(le.textContent=Dn),Oa=l(U),d(ne.$$.fragment,U),Ka=l(U),oe=i(U,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1quwuq5"&&(oe.innerHTML=Pn),U.forEach(a),Wa=l(t),re=i(t,"P",{}),Ha(re).forEach(a),this.h()},h(){Ya(T,"name","hf:doc:metadata"),Ya(T,"content",is),On(w,"text-align","center"),On(b,"text-align","center"),Ya(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ya(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){_(document.head,T),n(t,pe,e),n(t,ie,e),n(t,de,e),c(j,t,e),n(t,ce,e),n(t,k,e),n(t,me,e),n(t,J,e),n(t,ue,e),c(C,t,e),n(t,he,e),n(t,$,e),n(t,fe,e),c(x,t,e),n(t,Me,e),n(t,F,e),n(t,ye,e),n(t,v,e),n(t,Te,e),c(I,t,e),n(t,ge,e),n(t,G,e),n(t,we,e),c(R,t,e),n(t,be,e),c(Z,t,e),n(t,Ue,e),n(t,z,e),n(t,_e,e),c(B,t,e),n(t,je,e),n(t,A,e),n(t,ke,e),c(S,t,e),n(t,Je,e),c(E,t,e),n(t,Ce,e),n(t,N,e),n(t,$e,e),c(X,t,e),n(t,xe,e),n(t,V,e),n(t,Fe,e),n(t,Q,e),n(t,ve,e),n(t,W,e),n(t,Ie,e),c(q,t,e),n(t,Ge,e),n(t,L,e),n(t,Re,e),c(H,t,e),n(t,Ze,e),c(Y,t,e),n(t,ze,e),n(t,D,e),n(t,Be,e),c(P,t,e),n(t,Ae,e),n(t,O,e),n(t,Se,e),c(K,t,e),n(t,Ee,e),n(t,tt,e),n(t,Ne,e),c(et,t,e),n(t,Xe,e),n(t,at,e),n(t,Ve,e),c(nt,t,e),n(t,Qe,e),n(t,st,e),n(t,We,e),c(lt,t,e),n(t,qe,e),n(t,ot,e),n(t,Le,e),c(it,t,e),n(t,He,e),n(t,rt,e),n(t,Ye,e),c(pt,t,e),n(t,De,e),n(t,dt,e),n(t,Pe,e),c(ct,t,e),n(t,Oe,e),n(t,mt,e),n(t,Ke,e),c(ut,t,e),n(t,ta,e),n(t,ht,e),n(t,ea,e),c(ft,t,e),n(t,aa,e),n(t,Mt,e),n(t,na,e),c(yt,t,e),n(t,sa,e),n(t,Tt,e),n(t,la,e),c(gt,t,e),n(t,oa,e),n(t,wt,e),n(t,ia,e),c(bt,t,e),n(t,ra,e),n(t,Ut,e),n(t,pa,e),c(_t,t,e),n(t,da,e),c(jt,t,e),n(t,ca,e),n(t,kt,e),n(t,ma,e),c(Jt,t,e),n(t,ua,e),n(t,Ct,e),n(t,ha,e),c($t,t,e),n(t,fa,e),n(t,xt,e),n(t,Ma,e),c(Ft,t,e),n(t,ya,e),n(t,vt,e),n(t,Ta,e),c(It,t,e),n(t,ga,e),n(t,Gt,e),n(t,wa,e),n(t,Rt,e),n(t,ba,e),n(t,Zt,e),n(t,Ua,e),c(zt,t,e),n(t,_a,e),n(t,Bt,e),n(t,ja,e),c(At,t,e),n(t,ka,e),n(t,St,e),n(t,Ja,e),c(Et,t,e),n(t,Ca,e),n(t,Nt,e),n(t,$a,e),n(t,Xt,e),n(t,xa,e),c(Vt,t,e),n(t,Fa,e),n(t,Qt,e),n(t,va,e),n(t,Wt,e),n(t,Ia,e),n(t,w,e),n(t,Ga,e),n(t,qt,e),n(t,Ra,e),c(Lt,t,e),n(t,Za,e),n(t,Ht,e),n(t,za,e),n(t,b,e),n(t,Ba,e),n(t,Yt,e),n(t,Aa,e),c(Dt,t,e),n(t,Sa,e),n(t,Pt,e),n(t,Ea,e),n(t,Ot,e),n(t,Na,e),c(Kt,t,e),n(t,Xa,e),n(t,g,e),c(te,g,null),_(g,Da),_(g,se),n(t,Va,e),c(ee,t,e),n(t,Qa,e),n(t,y,e),c(ae,y,null),_(y,Pa),_(y,le),_(y,Oa),c(ne,y,null),_(y,Ka),_(y,oe),n(t,Wa,e),n(t,re,e),qa=!0},p:es,i(t){qa||(m(j.$$.fragment,t),m(C.$$.fragment,t),m(x.$$.fragment,t),m(I.$$.fragment,t),m(R.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(S.$$.fragment,t),m(E.$$.fragment,t),m(X.$$.fragment,t),m(q.$$.fragment,t),m(H.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),m(nt.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(yt.$$.fragment,t),m(gt.$$.fragment,t),m(bt.$$.fragment,t),m(_t.$$.fragment,t),m(jt.$$.fragment,t),m(Jt.$$.fragment,t),m($t.$$.fragment,t),m(Ft.$$.fragment,t),m(It.$$.fragment,t),m(zt.$$.fragment,t),m(At.$$.fragment,t),m(Et.$$.fragment,t),m(Vt.$$.fragment,t),m(Lt.$$.fragment,t),m(Dt.$$.fragment,t),m(Kt.$$.fragment,t),m(te.$$.fragment,t),m(ee.$$.fragment,t),m(ae.$$.fragment,t),m(ne.$$.fragment,t),qa=!0)},o(t){u(j.$$.fragment,t),u(C.$$.fragment,t),u(x.$$.fragment,t),u(I.$$.fragment,t),u(R.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(S.$$.fragment,t),u(E.$$.fragment,t),u(X.$$.fragment,t),u(q.$$.fragment,t),u(H.$$.fragment,t),u(Y.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(lt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(ft.$$.fragment,t),u(yt.$$.fragment,t),u(gt.$$.fragment,t),u(bt.$$.fragment,t),u(_t.$$.fragment,t),u(jt.$$.fragment,t),u(Jt.$$.fragment,t),u($t.$$.fragment,t),u(Ft.$$.fragment,t),u(It.$$.fragment,t),u(zt.$$.fragment,t),u(At.$$.fragment,t),u(Et.$$.fragment,t),u(Vt.$$.fragment,t),u(Lt.$$.fragment,t),u(Dt.$$.fragment,t),u(Kt.$$.fragment,t),u(te.$$.fragment,t),u(ee.$$.fragment,t),u(ae.$$.fragment,t),u(ne.$$.fragment,t),qa=!1},d(t){t&&(a(pe),a(ie),a(de),a(ce),a(k),a(me),a(J),a(ue),a(he),a($),a(fe),a(Me),a(F),a(ye),a(v),a(Te),a(ge),a(G),a(we),a(be),a(Ue),a(z),a(_e),a(je),a(A),a(ke),a(Je),a(Ce),a(N),a($e),a(xe),a(V),a(Fe),a(Q),a(ve),a(W),a(Ie),a(Ge),a(L),a(Re),a(Ze),a(ze),a(D),a(Be),a(Ae),a(O),a(Se),a(Ee),a(tt),a(Ne),a(Xe),a(at),a(Ve),a(Qe),a(st),a(We),a(qe),a(ot),a(Le),a(He),a(rt),a(Ye),a(De),a(dt),a(Pe),a(Oe),a(mt),a(Ke),a(ta),a(ht),a(ea),a(aa),a(Mt),a(na),a(sa),a(Tt),a(la),a(oa),a(wt),a(ia),a(ra),a(Ut),a(pa),a(da),a(ca),a(kt),a(ma),a(ua),a(Ct),a(ha),a(fa),a(xt),a(Ma),a(ya),a(vt),a(Ta),a(ga),a(Gt),a(wa),a(Rt),a(ba),a(Zt),a(Ua),a(_a),a(Bt),a(ja),a(ka),a(St),a(Ja),a(Ca),a(Nt),a($a),a(Xt),a(xa),a(Fa),a(Qt),a(va),a(Wt),a(Ia),a(w),a(Ga),a(qt),a(Ra),a(Za),a(Ht),a(za),a(b),a(Ba),a(Yt),a(Aa),a(Sa),a(Pt),a(Ea),a(Ot),a(Na),a(Xa),a(g),a(Va),a(Qa),a(y),a(Wa),a(re)),a(T),h(j,t),h(C,t),h(x,t),h(I,t),h(R,t),h(Z,t),h(B,t),h(S,t),h(E,t),h(X,t),h(q,t),h(H,t),h(Y,t),h(P,t),h(K,t),h(et,t),h(nt,t),h(lt,t),h(it,t),h(pt,t),h(ct,t),h(ut,t),h(ft,t),h(yt,t),h(gt,t),h(bt,t),h(_t,t),h(jt,t),h(Jt,t),h($t,t),h(Ft,t),h(It,t),h(zt,t),h(At,t),h(Et,t),h(Vt,t),h(Lt,t),h(Dt,t),h(Kt,t),h(te),h(ee,t),h(ae),h(ne)}}}const is='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"trl.SFTTrainer","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"SFTTrainer","local":"sfttrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"constantlengthdataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function rs(tn){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends ns{constructor(T){super(),ss(this,T,rs,os,ts,{})}}export{hs as component};
