import{s as Rt,n as Ft,o as Xt}from"../chunks/scheduler.9039eef2.js";import{S as Gt,i as Vt,g as l,s as a,r as m,A as Yt,h as i,f as n,c as r,j as _,u as h,x as d,k as v,l as Kt,y as s,a as o,v as g,d as u,t as f,w as M}from"../chunks/index.ded8f90d.js";import{D as x}from"../chunks/Docstring.a2ba2b54.js";import{C as _t}from"../chunks/CodeBlock.8580f3e8.js";import{H as se}from"../chunks/Heading.f027f30d.js";function en(vt){let b,we,ve,je,I,Ue,P,bt='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/dpo.py" rel="nofollow"><code>examples/dpo.py</code></a>.',Ce,D,wt="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",$e,A,Je,O,jt='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',xe,w,Ut='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',Ie,q,Ct="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Pe,k,$t="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",De,L,Jt="for example:",Ae,E,Oe,N,xt="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",qe,W,ke,B,It="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Le,H,Ee,z,Pt="For a detailed example have a look at the <code>examples/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Ne,S,We,Q,Dt="After this one can then call:",Be,Z,He,R,At="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",ze,F,Se,X,Ot=`Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.
The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.`,Qe,G,Ze,V,qt="While training and evaluating we record the following reward metrics:",Re,Y,kt="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Fe,K,Xe,c,ee,ot,de,Lt="Initialize DPOTrainer.",at,y,te,rt,ce,Et="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",lt,pe,Nt="We do this to avoid doing two forward passes, because it’s faster for FSDP.",it,j,ne,st,me,Wt="Concatenate the chosen and rejected inputs into a single tensor.",dt,U,oe,ct,he,Bt="Compute the DPO loss for a batch of policy and reference model log probabilities.",pt,T,ae,mt,ge,Ht=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ht,ue,zt="Works both with or without labels.",gt,C,re,ut,fe,St="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",ft,$,le,Mt,Me,Qt="Generate samples from the model and reference model for the given batch of inputs.",yt,J,ie,Tt,ye,Zt="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ge,be,Ve;return I=new se({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),A=new se({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),E=new _t({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),W=new se({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),H=new se({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),S=new _t({props:{code:"JTIwZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:` dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Z=new _t({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),F=new se({props:{title:"Loss function",local:"loss-function",headingTag:"h2"}}),G=new se({props:{title:"Logging",local:"logging",headingTag:"h2"}}),K=new se({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),ee=new x({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss or <code>&quot;hinge&quot;</code> loss from SLiC paper.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value. This argument is required if you want to use the default data collator.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L46"}}),te=new x({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L409"}}),ne=new x({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),oe=new x({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ae=new x({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L600"}}),re=new x({props:{name:"get_batch_metrics",anchor:"trl.DPOTrainer.get_batch_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L447"}}),le=new x({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L520"}}),ie=new x({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L649"}}),{c(){b=l("meta"),we=a(),ve=l("p"),je=a(),m(I.$$.fragment),Ue=a(),P=l("p"),P.innerHTML=bt,Ce=a(),D=l("p"),D.textContent=wt,$e=a(),m(A.$$.fragment),Je=a(),O=l("p"),O.innerHTML=jt,xe=a(),w=l("div"),w.innerHTML=Ut,Ie=a(),q=l("p"),q.innerHTML=Ct,Pe=a(),k=l("ul"),k.innerHTML=$t,De=a(),L=l("p"),L.textContent=Jt,Ae=a(),m(E.$$.fragment),Oe=a(),N=l("p"),N.innerHTML=xt,qe=a(),m(W.$$.fragment),ke=a(),B=l("p"),B.innerHTML=It,Le=a(),m(H.$$.fragment),Ee=a(),z=l("p"),z.innerHTML=Pt,Ne=a(),m(S.$$.fragment),We=a(),Q=l("p"),Q.textContent=Dt,Be=a(),m(Z.$$.fragment),He=a(),R=l("p"),R.innerHTML=At,ze=a(),m(F.$$.fragment),Se=a(),X=l("p"),X.innerHTML=Ot,Qe=a(),m(G.$$.fragment),Ze=a(),V=l("p"),V.textContent=qt,Re=a(),Y=l("ul"),Y.innerHTML=kt,Fe=a(),m(K.$$.fragment),Xe=a(),c=l("div"),m(ee.$$.fragment),ot=a(),de=l("p"),de.textContent=Lt,at=a(),y=l("div"),m(te.$$.fragment),rt=a(),ce=l("p"),ce.textContent=Et,lt=a(),pe=l("p"),pe.textContent=Nt,it=a(),j=l("div"),m(ne.$$.fragment),st=a(),me=l("p"),me.textContent=Wt,dt=a(),U=l("div"),m(oe.$$.fragment),ct=a(),he=l("p"),he.textContent=Bt,pt=a(),T=l("div"),m(ae.$$.fragment),mt=a(),ge=l("p"),ge.innerHTML=Ht,ht=a(),ue=l("p"),ue.textContent=zt,gt=a(),C=l("div"),m(re.$$.fragment),ut=a(),fe=l("p"),fe.textContent=St,ft=a(),$=l("div"),m(le.$$.fragment),Mt=a(),Me=l("p"),Me.textContent=Qt,yt=a(),J=l("div"),m(ie.$$.fragment),Tt=a(),ye=l("p"),ye.innerHTML=Zt,Ge=a(),be=l("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(n),we=r(e),ve=i(e,"P",{}),_(ve).forEach(n),je=r(e),h(I.$$.fragment,e),Ue=r(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-mupna9"&&(P.innerHTML=bt),Ce=r(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-xh4sh7"&&(D.textContent=wt),$e=r(e),h(A.$$.fragment,e),Je=r(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-dcawbe"&&(O.innerHTML=jt),xe=r(e),w=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(w)!=="svelte-z15c7z"&&(w.innerHTML=Ut),Ie=r(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-cb9b0v"&&(q.innerHTML=Ct),Pe=r(e),k=i(e,"UL",{"data-svelte-h":!0}),d(k)!=="svelte-17vxuta"&&(k.innerHTML=$t),De=r(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1gl9mvz"&&(L.textContent=Jt),Ae=r(e),h(E.$$.fragment,e),Oe=r(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1a8oxjk"&&(N.innerHTML=xt),qe=r(e),h(W.$$.fragment,e),ke=r(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-174yw9s"&&(B.innerHTML=It),Le=r(e),h(H.$$.fragment,e),Ee=r(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-18wrw32"&&(z.innerHTML=Pt),Ne=r(e),h(S.$$.fragment,e),We=r(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1lg6q1l"&&(Q.textContent=Dt),Be=r(e),h(Z.$$.fragment,e),He=r(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1ac5mum"&&(R.innerHTML=At),ze=r(e),h(F.$$.fragment,e),Se=r(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1rg5a0y"&&(X.innerHTML=Ot),Qe=r(e),h(G.$$.fragment,e),Ze=r(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-132s7j9"&&(V.textContent=qt),Re=r(e),Y=i(e,"UL",{"data-svelte-h":!0}),d(Y)!=="svelte-1oji3mm"&&(Y.innerHTML=kt),Fe=r(e),h(K.$$.fragment,e),Xe=r(e),c=i(e,"DIV",{class:!0});var p=_(c);h(ee.$$.fragment,p),ot=r(p),de=i(p,"P",{"data-svelte-h":!0}),d(de)!=="svelte-n6cc8y"&&(de.textContent=Lt),at=r(p),y=i(p,"DIV",{class:!0});var Te=_(y);h(te.$$.fragment,Te),rt=r(Te),ce=i(Te,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-16i1nac"&&(ce.textContent=Et),lt=r(Te),pe=i(Te,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-tgti68"&&(pe.textContent=Nt),Te.forEach(n),it=r(p),j=i(p,"DIV",{class:!0});var Ye=_(j);h(ne.$$.fragment,Ye),st=r(Ye),me=i(Ye,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1cvsgkk"&&(me.textContent=Wt),Ye.forEach(n),dt=r(p),U=i(p,"DIV",{class:!0});var Ke=_(U);h(oe.$$.fragment,Ke),ct=r(Ke),he=i(Ke,"P",{"data-svelte-h":!0}),d(he)!=="svelte-ymgxq7"&&(he.textContent=Bt),Ke.forEach(n),pt=r(p),T=i(p,"DIV",{class:!0});var _e=_(T);h(ae.$$.fragment,_e),mt=r(_e),ge=i(_e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-8qlty5"&&(ge.innerHTML=Ht),ht=r(_e),ue=i(_e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1tyo99t"&&(ue.textContent=zt),_e.forEach(n),gt=r(p),C=i(p,"DIV",{class:!0});var et=_(C);h(re.$$.fragment,et),ut=r(et),fe=i(et,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-11q8u7l"&&(fe.textContent=St),et.forEach(n),ft=r(p),$=i(p,"DIV",{class:!0});var tt=_($);h(le.$$.fragment,tt),Mt=r(tt),Me=i(tt,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-18uwvbi"&&(Me.textContent=Qt),tt.forEach(n),yt=r(p),J=i(p,"DIV",{class:!0});var nt=_(J);h(ie.$$.fragment,nt),Tt=r(nt),ye=i(nt,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-nqksfz"&&(ye.innerHTML=Zt),nt.forEach(n),p.forEach(n),Ge=r(e),be=i(e,"P",{}),_(be).forEach(n),this.h()},h(){v(b,"name","hf:doc:metadata"),v(b,"content",tn),Kt(w,"text-align","center"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,b),o(e,we,t),o(e,ve,t),o(e,je,t),g(I,e,t),o(e,Ue,t),o(e,P,t),o(e,Ce,t),o(e,D,t),o(e,$e,t),g(A,e,t),o(e,Je,t),o(e,O,t),o(e,xe,t),o(e,w,t),o(e,Ie,t),o(e,q,t),o(e,Pe,t),o(e,k,t),o(e,De,t),o(e,L,t),o(e,Ae,t),g(E,e,t),o(e,Oe,t),o(e,N,t),o(e,qe,t),g(W,e,t),o(e,ke,t),o(e,B,t),o(e,Le,t),g(H,e,t),o(e,Ee,t),o(e,z,t),o(e,Ne,t),g(S,e,t),o(e,We,t),o(e,Q,t),o(e,Be,t),g(Z,e,t),o(e,He,t),o(e,R,t),o(e,ze,t),g(F,e,t),o(e,Se,t),o(e,X,t),o(e,Qe,t),g(G,e,t),o(e,Ze,t),o(e,V,t),o(e,Re,t),o(e,Y,t),o(e,Fe,t),g(K,e,t),o(e,Xe,t),o(e,c,t),g(ee,c,null),s(c,ot),s(c,de),s(c,at),s(c,y),g(te,y,null),s(y,rt),s(y,ce),s(y,lt),s(y,pe),s(c,it),s(c,j),g(ne,j,null),s(j,st),s(j,me),s(c,dt),s(c,U),g(oe,U,null),s(U,ct),s(U,he),s(c,pt),s(c,T),g(ae,T,null),s(T,mt),s(T,ge),s(T,ht),s(T,ue),s(c,gt),s(c,C),g(re,C,null),s(C,ut),s(C,fe),s(c,ft),s(c,$),g(le,$,null),s($,Mt),s($,Me),s(c,yt),s(c,J),g(ie,J,null),s(J,Tt),s(J,ye),o(e,Ge,t),o(e,be,t),Ve=!0},p:Ft,i(e){Ve||(u(I.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(S.$$.fragment,e),u(Z.$$.fragment,e),u(F.$$.fragment,e),u(G.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),Ve=!0)},o(e){f(I.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(W.$$.fragment,e),f(H.$$.fragment,e),f(S.$$.fragment,e),f(Z.$$.fragment,e),f(F.$$.fragment,e),f(G.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),Ve=!1},d(e){e&&(n(we),n(ve),n(je),n(Ue),n(P),n(Ce),n(D),n($e),n(Je),n(O),n(xe),n(w),n(Ie),n(q),n(Pe),n(k),n(De),n(L),n(Ae),n(Oe),n(N),n(qe),n(ke),n(B),n(Le),n(Ee),n(z),n(Ne),n(We),n(Q),n(Be),n(He),n(R),n(ze),n(Se),n(X),n(Qe),n(Ze),n(V),n(Re),n(Y),n(Fe),n(Xe),n(c),n(Ge),n(be)),n(b),M(I,e),M(A,e),M(E,e),M(W,e),M(H,e),M(S,e),M(Z,e),M(F,e),M(G,e),M(K,e),M(ee),M(te),M(ne),M(oe),M(ae),M(re),M(le),M(ie)}}}const tn='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss function","local":"loss-function","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function nn(vt){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends Gt{constructor(b){super(),Vt(this,b,nn,en,Rt,{})}}export{dn as component};
