import{s as Mn,o as on,n as cn}from"../chunks/scheduler.f7e1785c.js";import{S as mn,i as hn,g as p,s as a,r as M,A as yn,h as i,f as l,c as n,j as rn,u as o,x as r,k as Ls,y as dn,a as s,v as c,d as m,t as h,w as y}from"../chunks/index.9f8f0838.js";import{T as un}from"../chunks/Tip.4575d9cf.js";import{C as d}from"../chunks/CodeBlock.b3510e34.js";import{H as J}from"../chunks/Heading.6643a2f7.js";function wn(Wt){let u,j=`In our example we will be using approximately 40 hours of training data. If you’d like to follow along using the Google Colab free tier GPU,
you will need to reduce the amount of training data to approximately 10-15 hours, and reduce the number of training steps.`;return{c(){u=p("p"),u.textContent=j},l(w){u=i(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-jn3a6r"&&(u.textContent=j)},m(w,Gt){s(w,u,Gt)},p:cn,d(w){w&&l(u)}}}function Jn(Wt){let u,j,w,Gt,b,_t,C,Ps=`Now that you are familiar with the text-to-speech task and internal workings of the SpeechT5 model that was pre-trained
on English language data, let’s see how we can fine-tune it to another language.`,Xt,I,Rt,g,Ks="Make sure that you have a GPU if you want to reproduce this example. In a notebook, you can check with the following command:",Yt,$,Qt,T,Nt,k,Os="You’ll also need some additional dependencies:",At,x,zt,Z,ea="Finally, don’t forget to log in to your Hugging Face account so that you could upload and share your model with the community:",Ft,v,Et,V,Ht,G,ta=`For this example we’ll take the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. While we will be using the Dutch language subset, feel free to pick another subset.`,qt,B,la=`This is an automated speech recognition (ASR) dataset, so, as mentioned before, it is not the most suitable
option for training TTS models. However, it will be good enough for this exercise.`,St,W,sa="Let’s load the data:",Dt,_,Lt,X,aa="<strong>Output:</strong>",Pt,R,Kt,Y,na=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,Ot,Q,el,N,tl,A,pa=`Let’s begin by defining the model checkpoint to use and loading the appropriate processor that contains both tokenizer,
and feature extractor that we will need to prepare the data for training:`,ll,z,sl,F,al,E,ia="First, for preparing the text, we’ll need the tokenizer part of the processor, so let’s get it:",nl,H,pl,q,ra="Let’s take a look at an example:",il,S,rl,D,Ma="<strong>Output:</strong>",Ml,L,ol,P,oa=`What you may notice is that the dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which
feature to use as the text input, it will be important to know that the SpeechT5 tokenizer doesn’t have any tokens for
numbers. In <code>normalized_text</code> the numbers are written out as text. Thus, it is a better fit, and we should use <code>normalized_text</code>
as input text.`,cl,K,ca=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,ml,O,ma=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, we’ll write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,hl,ee,yl,te,ha=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,dl,le,ul,se,ya="<strong>Output:</strong>",wl,ae,Jl,ne,da=`To handle the unsupported characters identified in the previous step, we can define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,Tl,pe,Ul,ie,ua="Now that we have dealt with special characters in the text, it’s time to shift the focus to the audio data.",fl,re,jl,Me,wa=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,bl,oe,Cl,ce,Ja="By plotting a histogram you can get a sense of how much data there is for each speaker.",Il,me,gl,U,Ta='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',$l,he,Ua=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,kl,ye,xl,de,fa="Let’s check how many speakers remain:",Zl,ue,vl,we,ja="<strong>Output:</strong>",Vl,Je,Gl,Te,ba="Let’s see how many examples are left:",Bl,Ue,Wl,fe,Ca="<strong>Output:</strong>",_l,je,Xl,be,Ia="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Rl,Ce,ga=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Yl,Ie,Ql,ge,$a=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,Nl,$e,ka=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,Al,ke,zl,xe,xa=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,Fl,Ze,Za=`For optimal results, we would need to train an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language. If you’d like to train your own
X-vector model, you can use <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">this script</a>
as an example.`,El,ve,Hl,Ve,va=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,ql,Ge,Sl,Be,Va="Verify the processing is correct by looking at a single example:",Dl,We,Ll,_e,Ga="<strong>Output:</strong>",Pl,Xe,Kl,Re,Ba="Speaker embeddings should be a 512-element vector:",Ol,Ye,es,Qe,Wa="<strong>Output:</strong>",ts,Ne,ls,Ae,_a="The labels should be a log-mel spectrogram with 80 mel bins.",ss,ze,as,f,Xa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ns,Fe,Ra=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,ps,Ee,Ya="Now we need to apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",is,He,rs,qe,Qa=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,Ms,Se,os,De,Na="<strong>Output:</strong>",cs,Le,ms,Pe,Aa="Next, create a basic train/test split:",hs,Ke,ys,Oe,ds,et,za=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with
the special value <code>-100</code>. This special value instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,us,tt,ws,lt,Fa=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,Js,st,Ts,at,Us,nt,Ea="Load the pre-trained model from the same checkpoint as you used for loading the processor:",fs,pt,js,it,Ha=`The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training, and re-enable cache for
generation to speed-up inference time:`,bs,rt,Cs,Mt,qa=`Define the training arguments. Here we are not computing any evaluation metrics during the training process,
we’ll talk about evaluation later in this chapter. Instead, we’ll only look at the loss:`,Is,ot,gs,ct,Sa="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",$s,mt,ks,ht,Da=`And with that, we’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,xs,yt,Zs,dt,La="Push the final model to the 🤗 Hub:",vs,ut,Vs,wt,Gs,Jt,Pa=`Once you have fine-tuned a model, you can use it for inference! Load the model from the 🤗 Hub (make sure to use your
account name in the following code snippet):`,Bs,Tt,Ws,Ut,Ka="Pick an example, here we’ll take one from the test dataset. Obtain a speaker embedding.",_s,ft,Xs,jt,Oa="Define some input text and tokenize it.",Rs,bt,Ys,Ct,en="Preprocess the input text:",Qs,It,Ns,gt,tn="Instantiate a vocoder and generate speech:",As,$t,zs,kt,ln="Ready to listen to the result?",Fs,xt,Es,Zt,sn=`Obtaining satisfactory results from this model on a new language can be challenging. The quality of the speaker
embeddings can be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,Hs,vt,an=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,qs,Vt,nn="In the next section, we’ll talk about how we evaluate text-to-speech models.",Ss,Bt,Ds;return b=new J({props:{title:"Fine-tuning SpeechT5",local:"fine-tuning-speecht5",headingTag:"h1"}}),I=new J({props:{title:"House-keeping",local:"house-keeping",headingTag:"h2"}}),$=new d({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),T=new un({props:{warning:!0,$$slots:{default:[wn]},$$scope:{ctx:Wt}}}),x=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),v=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),V=new J({props:{title:"The dataset",local:"the-dataset",headingTag:"h2"}}),_=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),R=new d({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),Q=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),N=new J({props:{title:"Preprocessing the data",local:"preprocessing-the-data",headingTag:"h2"}}),z=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),F=new J({props:{title:"Text cleanup for SpeechT5 tokenization",local:"text-cleanup-for-speecht5-tokenization",headingTag:"h3"}}),H=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),S=new d({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),L=new d({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),ee=new d({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),le=new d({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),ae=new d({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),pe=new d({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),re=new J({props:{title:"Speakers",local:"speakers",headingTag:"h3"}}),oe=new d({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),me=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),ye=new d({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),ue=new d({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),Je=new d({props:{code:"NDI=",highlighted:"42",wrap:!1}}),Ue=new d({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),je=new d({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),Ie=new J({props:{title:"Speaker embeddings",local:"speaker-embeddings",headingTag:"h3"}}),ke=new d({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),ve=new J({props:{title:"Processing the dataset",local:"processing-the-dataset",headingTag:"h3"}}),Ge=new d({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),We=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Xe=new d({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Ye=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Ne=new d({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),ze=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),He=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Se=new d({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Le=new d({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Ke=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Oe=new J({props:{title:"Data collator",local:"data-collator",headingTag:"h3"}}),tt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),st=new d({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),at=new J({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),pt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),rt=new d({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),ot=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),mt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),yt=new d({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ut=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),wt=new J({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Tt=new d({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),ft=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),bt=new d({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),It=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),$t=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),xt=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),{c(){u=p("meta"),j=a(),w=p("p"),Gt=a(),M(b.$$.fragment),_t=a(),C=p("p"),C.textContent=Ps,Xt=a(),M(I.$$.fragment),Rt=a(),g=p("p"),g.textContent=Ks,Yt=a(),M($.$$.fragment),Qt=a(),M(T.$$.fragment),Nt=a(),k=p("p"),k.textContent=Os,At=a(),M(x.$$.fragment),zt=a(),Z=p("p"),Z.textContent=ea,Ft=a(),M(v.$$.fragment),Et=a(),M(V.$$.fragment),Ht=a(),G=p("p"),G.innerHTML=ta,qt=a(),B=p("p"),B.textContent=la,St=a(),W=p("p"),W.textContent=sa,Dt=a(),M(_.$$.fragment),Lt=a(),X=p("p"),X.innerHTML=aa,Pt=a(),M(R.$$.fragment),Kt=a(),Y=p("p"),Y.textContent=na,Ot=a(),M(Q.$$.fragment),el=a(),M(N.$$.fragment),tl=a(),A=p("p"),A.textContent=pa,ll=a(),M(z.$$.fragment),sl=a(),M(F.$$.fragment),al=a(),E=p("p"),E.textContent=ia,nl=a(),M(H.$$.fragment),pl=a(),q=p("p"),q.textContent=ra,il=a(),M(S.$$.fragment),rl=a(),D=p("p"),D.innerHTML=Ma,Ml=a(),M(L.$$.fragment),ol=a(),P=p("p"),P.innerHTML=oa,cl=a(),K=p("p"),K.innerHTML=ca,ml=a(),O=p("p"),O.innerHTML=ma,hl=a(),M(ee.$$.fragment),yl=a(),te=p("p"),te.textContent=ha,dl=a(),M(le.$$.fragment),ul=a(),se=p("p"),se.innerHTML=ya,wl=a(),M(ae.$$.fragment),Jl=a(),ne=p("p"),ne.innerHTML=da,Tl=a(),M(pe.$$.fragment),Ul=a(),ie=p("p"),ie.textContent=ua,fl=a(),M(re.$$.fragment),jl=a(),Me=p("p"),Me.textContent=wa,bl=a(),M(oe.$$.fragment),Cl=a(),ce=p("p"),ce.textContent=Ja,Il=a(),M(me.$$.fragment),gl=a(),U=p("div"),U.innerHTML=Ta,$l=a(),he=p("p"),he.textContent=Ua,kl=a(),M(ye.$$.fragment),xl=a(),de=p("p"),de.textContent=fa,Zl=a(),M(ue.$$.fragment),vl=a(),we=p("p"),we.innerHTML=ja,Vl=a(),M(Je.$$.fragment),Gl=a(),Te=p("p"),Te.textContent=ba,Bl=a(),M(Ue.$$.fragment),Wl=a(),fe=p("p"),fe.innerHTML=Ca,_l=a(),M(je.$$.fragment),Xl=a(),be=p("p"),be.textContent=Ia,Rl=a(),Ce=p("p"),Ce.textContent=ga,Yl=a(),M(Ie.$$.fragment),Ql=a(),ge=p("p"),ge.innerHTML=$a,Nl=a(),$e=p("p"),$e.innerHTML=ka,Al=a(),M(ke.$$.fragment),zl=a(),xe=p("p"),xe.innerHTML=xa,Fl=a(),Ze=p("p"),Ze.innerHTML=Za,El=a(),M(ve.$$.fragment),Hl=a(),Ve=p("p"),Ve.innerHTML=va,ql=a(),M(Ge.$$.fragment),Sl=a(),Be=p("p"),Be.textContent=Va,Dl=a(),M(We.$$.fragment),Ll=a(),_e=p("p"),_e.innerHTML=Ga,Pl=a(),M(Xe.$$.fragment),Kl=a(),Re=p("p"),Re.textContent=Ba,Ol=a(),M(Ye.$$.fragment),es=a(),Qe=p("p"),Qe.innerHTML=Wa,ts=a(),M(Ne.$$.fragment),ls=a(),Ae=p("p"),Ae.textContent=_a,ss=a(),M(ze.$$.fragment),as=a(),f=p("div"),f.innerHTML=Xa,ns=a(),Fe=p("p"),Fe.textContent=Ra,ps=a(),Ee=p("p"),Ee.textContent=Ya,is=a(),M(He.$$.fragment),rs=a(),qe=p("p"),qe.textContent=Qa,Ms=a(),M(Se.$$.fragment),os=a(),De=p("p"),De.innerHTML=Na,cs=a(),M(Le.$$.fragment),ms=a(),Pe=p("p"),Pe.textContent=Aa,hs=a(),M(Ke.$$.fragment),ys=a(),M(Oe.$$.fragment),ds=a(),et=p("p"),et.innerHTML=za,us=a(),M(tt.$$.fragment),ws=a(),lt=p("p"),lt.textContent=Fa,Js=a(),M(st.$$.fragment),Ts=a(),M(at.$$.fragment),Us=a(),nt=p("p"),nt.textContent=Ea,fs=a(),M(pt.$$.fragment),js=a(),it=p("p"),it.innerHTML=Ha,bs=a(),M(rt.$$.fragment),Cs=a(),Mt=p("p"),Mt.textContent=qa,Is=a(),M(ot.$$.fragment),gs=a(),ct=p("p"),ct.innerHTML=Sa,$s=a(),M(mt.$$.fragment),ks=a(),ht=p("p"),ht.innerHTML=Da,xs=a(),M(yt.$$.fragment),Zs=a(),dt=p("p"),dt.textContent=La,vs=a(),M(ut.$$.fragment),Vs=a(),M(wt.$$.fragment),Gs=a(),Jt=p("p"),Jt.textContent=Pa,Bs=a(),M(Tt.$$.fragment),Ws=a(),Ut=p("p"),Ut.textContent=Ka,_s=a(),M(ft.$$.fragment),Xs=a(),jt=p("p"),jt.textContent=Oa,Rs=a(),M(bt.$$.fragment),Ys=a(),Ct=p("p"),Ct.textContent=en,Qs=a(),M(It.$$.fragment),Ns=a(),gt=p("p"),gt.textContent=tn,As=a(),M($t.$$.fragment),zs=a(),kt=p("p"),kt.textContent=ln,Fs=a(),M(xt.$$.fragment),Es=a(),Zt=p("p"),Zt.textContent=sn,Hs=a(),vt=p("p"),vt.innerHTML=an,qs=a(),Vt=p("p"),Vt.textContent=nn,Ss=a(),Bt=p("p"),this.h()},l(e){const t=yn("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),j=n(e),w=i(e,"P",{}),rn(w).forEach(l),Gt=n(e),o(b.$$.fragment,e),_t=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-6isf2f"&&(C.textContent=Ps),Xt=n(e),o(I.$$.fragment,e),Rt=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1pl1dgp"&&(g.textContent=Ks),Yt=n(e),o($.$$.fragment,e),Qt=n(e),o(T.$$.fragment,e),Nt=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9u3xmt"&&(k.textContent=Os),At=n(e),o(x.$$.fragment,e),zt=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1lsy5mj"&&(Z.textContent=ea),Ft=n(e),o(v.$$.fragment,e),Et=n(e),o(V.$$.fragment,e),Ht=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ixb96o"&&(G.innerHTML=ta),qt=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1p30ok7"&&(B.textContent=la),St=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1soaqfm"&&(W.textContent=sa),Dt=n(e),o(_.$$.fragment,e),Lt=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1mvdyro"&&(X.innerHTML=aa),Pt=n(e),o(R.$$.fragment,e),Kt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1xdebij"&&(Y.textContent=na),Ot=n(e),o(Q.$$.fragment,e),el=n(e),o(N.$$.fragment,e),tl=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1k7tad6"&&(A.textContent=pa),ll=n(e),o(z.$$.fragment,e),sl=n(e),o(F.$$.fragment,e),al=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-a1pl49"&&(E.textContent=ia),nl=n(e),o(H.$$.fragment,e),pl=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-17epgem"&&(q.textContent=ra),il=n(e),o(S.$$.fragment,e),rl=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1mvdyro"&&(D.innerHTML=Ma),Ml=n(e),o(L.$$.fragment,e),ol=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-y5gqfm"&&(P.innerHTML=oa),cl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1qiuc1m"&&(K.innerHTML=ca),ml=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-19dff1r"&&(O.innerHTML=ma),hl=n(e),o(ee.$$.fragment,e),yl=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-fefaym"&&(te.textContent=ha),dl=n(e),o(le.$$.fragment,e),ul=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1mvdyro"&&(se.innerHTML=ya),wl=n(e),o(ae.$$.fragment,e),Jl=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-akzhx6"&&(ne.innerHTML=da),Tl=n(e),o(pe.$$.fragment,e),Ul=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-hhu8o3"&&(ie.textContent=ua),fl=n(e),o(re.$$.fragment,e),jl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1edo483"&&(Me.textContent=wa),bl=n(e),o(oe.$$.fragment,e),Cl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1hah56a"&&(ce.textContent=Ja),Il=n(e),o(me.$$.fragment,e),gl=n(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-1uufiik"&&(U.innerHTML=Ta),$l=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ujf40"&&(he.textContent=Ua),kl=n(e),o(ye.$$.fragment,e),xl=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-g2dd32"&&(de.textContent=fa),Zl=n(e),o(ue.$$.fragment,e),vl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1mvdyro"&&(we.innerHTML=ja),Vl=n(e),o(Je.$$.fragment,e),Gl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-hbes5t"&&(Te.textContent=ba),Bl=n(e),o(Ue.$$.fragment,e),Wl=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1mvdyro"&&(fe.innerHTML=Ca),_l=n(e),o(je.$$.fragment,e),Xl=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-oizlk1"&&(be.textContent=Ia),Rl=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1n0u7fp"&&(Ce.textContent=ga),Yl=n(e),o(Ie.$$.fragment,e),Ql=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1xdfpy2"&&(ge.innerHTML=$a),Nl=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-7nncma"&&($e.innerHTML=ka),Al=n(e),o(ke.$$.fragment,e),zl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1mtxkxr"&&(xe.innerHTML=xa),Fl=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-15ol8sg"&&(Ze.innerHTML=Za),El=n(e),o(ve.$$.fragment,e),Hl=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1tlidee"&&(Ve.innerHTML=va),ql=n(e),o(Ge.$$.fragment,e),Sl=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-17mzfft"&&(Be.textContent=Va),Dl=n(e),o(We.$$.fragment,e),Ll=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1mvdyro"&&(_e.innerHTML=Ga),Pl=n(e),o(Xe.$$.fragment,e),Kl=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1mqg4ck"&&(Re.textContent=Ba),Ol=n(e),o(Ye.$$.fragment,e),es=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1mvdyro"&&(Qe.innerHTML=Wa),ts=n(e),o(Ne.$$.fragment,e),ls=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-f7g58h"&&(Ae.textContent=_a),ss=n(e),o(ze.$$.fragment,e),as=n(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-j4o1b8"&&(f.innerHTML=Xa),ns=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1t9vz0y"&&(Fe.textContent=Ra),ps=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-7crb3r"&&(Ee.textContent=Ya),is=n(e),o(He.$$.fragment,e),rs=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-wvyh3r"&&(qe.textContent=Qa),Ms=n(e),o(Se.$$.fragment,e),os=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1mvdyro"&&(De.innerHTML=Na),cs=n(e),o(Le.$$.fragment,e),ms=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-12gx63x"&&(Pe.textContent=Aa),hs=n(e),o(Ke.$$.fragment,e),ys=n(e),o(Oe.$$.fragment,e),ds=n(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-rsy2my"&&(et.innerHTML=za),us=n(e),o(tt.$$.fragment,e),ws=n(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-u623yc"&&(lt.textContent=Fa),Js=n(e),o(st.$$.fragment,e),Ts=n(e),o(at.$$.fragment,e),Us=n(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1kkriue"&&(nt.textContent=Ea),fs=n(e),o(pt.$$.fragment,e),js=n(e),it=i(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1fpvhw6"&&(it.innerHTML=Ha),bs=n(e),o(rt.$$.fragment,e),Cs=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1af5qye"&&(Mt.textContent=qa),Is=n(e),o(ot.$$.fragment,e),gs=n(e),ct=i(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1yq1u47"&&(ct.innerHTML=Sa),$s=n(e),o(mt.$$.fragment,e),ks=n(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-98ddde"&&(ht.innerHTML=Da),xs=n(e),o(yt.$$.fragment,e),Zs=n(e),dt=i(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-hefgo2"&&(dt.textContent=La),vs=n(e),o(ut.$$.fragment,e),Vs=n(e),o(wt.$$.fragment,e),Gs=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-vqys4o"&&(Jt.textContent=Pa),Bs=n(e),o(Tt.$$.fragment,e),Ws=n(e),Ut=i(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-kiuzrb"&&(Ut.textContent=Ka),_s=n(e),o(ft.$$.fragment,e),Xs=n(e),jt=i(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1sn5mu7"&&(jt.textContent=Oa),Rs=n(e),o(bt.$$.fragment,e),Ys=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1sf6bxe"&&(Ct.textContent=en),Qs=n(e),o(It.$$.fragment,e),Ns=n(e),gt=i(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1kfdmvn"&&(gt.textContent=tn),As=n(e),o($t.$$.fragment,e),zs=n(e),kt=i(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-jp0xjb"&&(kt.textContent=ln),Fs=n(e),o(xt.$$.fragment,e),Es=n(e),Zt=i(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-yji0sl"&&(Zt.textContent=sn),Hs=n(e),vt=i(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-6lmfh0"&&(vt.innerHTML=an),qs=n(e),Vt=i(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-bv2cz9"&&(Vt.textContent=nn),Ss=n(e),Bt=i(e,"P",{}),rn(Bt).forEach(l),this.h()},h(){Ls(u,"name","hf:doc:metadata"),Ls(u,"content",Tn),Ls(U,"class","flex justify-center"),Ls(f,"class","flex justify-center")},m(e,t){dn(document.head,u),s(e,j,t),s(e,w,t),s(e,Gt,t),c(b,e,t),s(e,_t,t),s(e,C,t),s(e,Xt,t),c(I,e,t),s(e,Rt,t),s(e,g,t),s(e,Yt,t),c($,e,t),s(e,Qt,t),c(T,e,t),s(e,Nt,t),s(e,k,t),s(e,At,t),c(x,e,t),s(e,zt,t),s(e,Z,t),s(e,Ft,t),c(v,e,t),s(e,Et,t),c(V,e,t),s(e,Ht,t),s(e,G,t),s(e,qt,t),s(e,B,t),s(e,St,t),s(e,W,t),s(e,Dt,t),c(_,e,t),s(e,Lt,t),s(e,X,t),s(e,Pt,t),c(R,e,t),s(e,Kt,t),s(e,Y,t),s(e,Ot,t),c(Q,e,t),s(e,el,t),c(N,e,t),s(e,tl,t),s(e,A,t),s(e,ll,t),c(z,e,t),s(e,sl,t),c(F,e,t),s(e,al,t),s(e,E,t),s(e,nl,t),c(H,e,t),s(e,pl,t),s(e,q,t),s(e,il,t),c(S,e,t),s(e,rl,t),s(e,D,t),s(e,Ml,t),c(L,e,t),s(e,ol,t),s(e,P,t),s(e,cl,t),s(e,K,t),s(e,ml,t),s(e,O,t),s(e,hl,t),c(ee,e,t),s(e,yl,t),s(e,te,t),s(e,dl,t),c(le,e,t),s(e,ul,t),s(e,se,t),s(e,wl,t),c(ae,e,t),s(e,Jl,t),s(e,ne,t),s(e,Tl,t),c(pe,e,t),s(e,Ul,t),s(e,ie,t),s(e,fl,t),c(re,e,t),s(e,jl,t),s(e,Me,t),s(e,bl,t),c(oe,e,t),s(e,Cl,t),s(e,ce,t),s(e,Il,t),c(me,e,t),s(e,gl,t),s(e,U,t),s(e,$l,t),s(e,he,t),s(e,kl,t),c(ye,e,t),s(e,xl,t),s(e,de,t),s(e,Zl,t),c(ue,e,t),s(e,vl,t),s(e,we,t),s(e,Vl,t),c(Je,e,t),s(e,Gl,t),s(e,Te,t),s(e,Bl,t),c(Ue,e,t),s(e,Wl,t),s(e,fe,t),s(e,_l,t),c(je,e,t),s(e,Xl,t),s(e,be,t),s(e,Rl,t),s(e,Ce,t),s(e,Yl,t),c(Ie,e,t),s(e,Ql,t),s(e,ge,t),s(e,Nl,t),s(e,$e,t),s(e,Al,t),c(ke,e,t),s(e,zl,t),s(e,xe,t),s(e,Fl,t),s(e,Ze,t),s(e,El,t),c(ve,e,t),s(e,Hl,t),s(e,Ve,t),s(e,ql,t),c(Ge,e,t),s(e,Sl,t),s(e,Be,t),s(e,Dl,t),c(We,e,t),s(e,Ll,t),s(e,_e,t),s(e,Pl,t),c(Xe,e,t),s(e,Kl,t),s(e,Re,t),s(e,Ol,t),c(Ye,e,t),s(e,es,t),s(e,Qe,t),s(e,ts,t),c(Ne,e,t),s(e,ls,t),s(e,Ae,t),s(e,ss,t),c(ze,e,t),s(e,as,t),s(e,f,t),s(e,ns,t),s(e,Fe,t),s(e,ps,t),s(e,Ee,t),s(e,is,t),c(He,e,t),s(e,rs,t),s(e,qe,t),s(e,Ms,t),c(Se,e,t),s(e,os,t),s(e,De,t),s(e,cs,t),c(Le,e,t),s(e,ms,t),s(e,Pe,t),s(e,hs,t),c(Ke,e,t),s(e,ys,t),c(Oe,e,t),s(e,ds,t),s(e,et,t),s(e,us,t),c(tt,e,t),s(e,ws,t),s(e,lt,t),s(e,Js,t),c(st,e,t),s(e,Ts,t),c(at,e,t),s(e,Us,t),s(e,nt,t),s(e,fs,t),c(pt,e,t),s(e,js,t),s(e,it,t),s(e,bs,t),c(rt,e,t),s(e,Cs,t),s(e,Mt,t),s(e,Is,t),c(ot,e,t),s(e,gs,t),s(e,ct,t),s(e,$s,t),c(mt,e,t),s(e,ks,t),s(e,ht,t),s(e,xs,t),c(yt,e,t),s(e,Zs,t),s(e,dt,t),s(e,vs,t),c(ut,e,t),s(e,Vs,t),c(wt,e,t),s(e,Gs,t),s(e,Jt,t),s(e,Bs,t),c(Tt,e,t),s(e,Ws,t),s(e,Ut,t),s(e,_s,t),c(ft,e,t),s(e,Xs,t),s(e,jt,t),s(e,Rs,t),c(bt,e,t),s(e,Ys,t),s(e,Ct,t),s(e,Qs,t),c(It,e,t),s(e,Ns,t),s(e,gt,t),s(e,As,t),c($t,e,t),s(e,zs,t),s(e,kt,t),s(e,Fs,t),c(xt,e,t),s(e,Es,t),s(e,Zt,t),s(e,Hs,t),s(e,vt,t),s(e,qs,t),s(e,Vt,t),s(e,Ss,t),s(e,Bt,t),Ds=!0},p(e,[t]){const pn={};t&2&&(pn.$$scope={dirty:t,ctx:e}),T.$set(pn)},i(e){Ds||(m(b.$$.fragment,e),m(I.$$.fragment,e),m($.$$.fragment,e),m(T.$$.fragment,e),m(x.$$.fragment,e),m(v.$$.fragment,e),m(V.$$.fragment,e),m(_.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(ue.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(ke.$$.fragment,e),m(ve.$$.fragment,e),m(Ge.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(Ne.$$.fragment,e),m(ze.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(Le.$$.fragment,e),m(Ke.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(mt.$$.fragment,e),m(yt.$$.fragment,e),m(ut.$$.fragment,e),m(wt.$$.fragment,e),m(Tt.$$.fragment,e),m(ft.$$.fragment,e),m(bt.$$.fragment,e),m(It.$$.fragment,e),m($t.$$.fragment,e),m(xt.$$.fragment,e),Ds=!0)},o(e){h(b.$$.fragment,e),h(I.$$.fragment,e),h($.$$.fragment,e),h(T.$$.fragment,e),h(x.$$.fragment,e),h(v.$$.fragment,e),h(V.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h(ke.$$.fragment,e),h(ve.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(ze.$$.fragment,e),h(He.$$.fragment,e),h(Se.$$.fragment,e),h(Le.$$.fragment,e),h(Ke.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h(rt.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),h(yt.$$.fragment,e),h(ut.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(ft.$$.fragment,e),h(bt.$$.fragment,e),h(It.$$.fragment,e),h($t.$$.fragment,e),h(xt.$$.fragment,e),Ds=!1},d(e){e&&(l(j),l(w),l(Gt),l(_t),l(C),l(Xt),l(Rt),l(g),l(Yt),l(Qt),l(Nt),l(k),l(At),l(zt),l(Z),l(Ft),l(Et),l(Ht),l(G),l(qt),l(B),l(St),l(W),l(Dt),l(Lt),l(X),l(Pt),l(Kt),l(Y),l(Ot),l(el),l(tl),l(A),l(ll),l(sl),l(al),l(E),l(nl),l(pl),l(q),l(il),l(rl),l(D),l(Ml),l(ol),l(P),l(cl),l(K),l(ml),l(O),l(hl),l(yl),l(te),l(dl),l(ul),l(se),l(wl),l(Jl),l(ne),l(Tl),l(Ul),l(ie),l(fl),l(jl),l(Me),l(bl),l(Cl),l(ce),l(Il),l(gl),l(U),l($l),l(he),l(kl),l(xl),l(de),l(Zl),l(vl),l(we),l(Vl),l(Gl),l(Te),l(Bl),l(Wl),l(fe),l(_l),l(Xl),l(be),l(Rl),l(Ce),l(Yl),l(Ql),l(ge),l(Nl),l($e),l(Al),l(zl),l(xe),l(Fl),l(Ze),l(El),l(Hl),l(Ve),l(ql),l(Sl),l(Be),l(Dl),l(Ll),l(_e),l(Pl),l(Kl),l(Re),l(Ol),l(es),l(Qe),l(ts),l(ls),l(Ae),l(ss),l(as),l(f),l(ns),l(Fe),l(ps),l(Ee),l(is),l(rs),l(qe),l(Ms),l(os),l(De),l(cs),l(ms),l(Pe),l(hs),l(ys),l(ds),l(et),l(us),l(ws),l(lt),l(Js),l(Ts),l(Us),l(nt),l(fs),l(js),l(it),l(bs),l(Cs),l(Mt),l(Is),l(gs),l(ct),l($s),l(ks),l(ht),l(xs),l(Zs),l(dt),l(vs),l(Vs),l(Gs),l(Jt),l(Bs),l(Ws),l(Ut),l(_s),l(Xs),l(jt),l(Rs),l(Ys),l(Ct),l(Qs),l(Ns),l(gt),l(As),l(zs),l(kt),l(Fs),l(Es),l(Zt),l(Hs),l(vt),l(qs),l(Vt),l(Ss),l(Bt)),l(u),y(b,e),y(I,e),y($,e),y(T,e),y(x,e),y(v,e),y(V,e),y(_,e),y(R,e),y(Q,e),y(N,e),y(z,e),y(F,e),y(H,e),y(S,e),y(L,e),y(ee,e),y(le,e),y(ae,e),y(pe,e),y(re,e),y(oe,e),y(me,e),y(ye,e),y(ue,e),y(Je,e),y(Ue,e),y(je,e),y(Ie,e),y(ke,e),y(ve,e),y(Ge,e),y(We,e),y(Xe,e),y(Ye,e),y(Ne,e),y(ze,e),y(He,e),y(Se,e),y(Le,e),y(Ke,e),y(Oe,e),y(tt,e),y(st,e),y(at,e),y(pt,e),y(rt,e),y(ot,e),y(mt,e),y(yt,e),y(ut,e),y(wt,e),y(Tt,e),y(ft,e),y(bt,e),y(It,e),y($t,e),y(xt,e)}}}const Tn='{"title":"Fine-tuning SpeechT5","local":"fine-tuning-speecht5","sections":[{"title":"House-keeping","local":"house-keeping","sections":[],"depth":2},{"title":"The dataset","local":"the-dataset","sections":[],"depth":2},{"title":"Preprocessing the data","local":"preprocessing-the-data","sections":[{"title":"Text cleanup for SpeechT5 tokenization","local":"text-cleanup-for-speecht5-tokenization","sections":[],"depth":3},{"title":"Speakers","local":"speakers","sections":[],"depth":3},{"title":"Speaker embeddings","local":"speaker-embeddings","sections":[],"depth":3},{"title":"Processing the dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Data collator","local":"data-collator","sections":[],"depth":3}],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Un(Wt){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends mn{constructor(u){super(),hn(this,u,Un,Jn,Mn,{})}}export{gn as component};
