import{s as Kr,n as Br,o as Gr}from"../chunks/scheduler.9039eef2.js";import{S as Yr,i as Zr,g as o,s as a,r as d,A as Jr,h as r,f as s,c as n,j as _,u as c,x as i,k as u,y as t,a as b,v as m,d as p,t as g,w as h}from"../chunks/index.ded8f90d.js";import{D as f}from"../chunks/Docstring.a2ba2b54.js";import{H as F}from"../chunks/Heading.f027f30d.js";function Qr(Ko){let M,fa,_a,va,ge,ba,he,Bo=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,Ta,_e,xa,S,ue,fn,mt,Go="Configuration class for PPOTrainer",$a,fe,Pa,x,ve,vn,pt,Yo=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,bn,R,be,Tn,gt,Zo="Calculate model outputs in multiple batches.",xn,V,Te,$n,ht,Jo="Compute per token rewards from scores and KL-penalty.",Pn,j,xe,On,_t,Qo="Creates and saves a model card for a TRL model.",wn,U,$e,Dn,ut,Xo="Gather stats from all processes. Useful in the context of distributed training.",yn,W,Pe,kn,ft,er=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,Cn,K,Oe,Fn,vt,tr="A function that logs all the training stats. Call it at the end of each epoch.",Ln,B,we,Nn,bt,ar="Calculate policy and value losses.",zn,G,De,In,Tt,nr="Prepare the dataloader for training.",qn,Y,ye,Mn,xt,or="Record training step statistics.",Sn,Z,ke,En,$t,rr="Run a PPO optimisation step given a list of queries, model responses, and rewards.",An,J,Ce,Hn,Pt,sr="Train one PPO minibatch",Oa,Fe,wa,k,Le,Rn,Ot,ir='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a> class.',Vn,wt,lr=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Da,Ne,ya,O,ze,jn,Dt,dr=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,Un,yt,cr=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Wn,kt,mr="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Kn,Ct,pr=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,ka,Ie,Ca,E,qe,Bn,Ft,gr=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Fa,Me,La,v,Se,Gn,Lt,hr="Initialize DPOTrainer.",Yn,Q,Ee,Zn,Nt,_r=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Jn,X,Ae,Qn,zt,ur="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Xn,L,He,eo,It,fr="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",to,qt,vr="We do this to avoid doing two forward passes, because it’s faster for FSDP.",ao,ee,Re,no,Mt,br="Concatenate the chosen and rejected inputs into a single tensor.",oo,te,Ve,ro,St,Tr="Compute the DPO loss for a batch of policy and reference model log probabilities.",so,N,je,io,Et,xr=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,lo,At,$r="Works both with or without labels.",co,ae,Ue,mo,Ht,Pr="Compute the log probabilities of the given labels under the given logits.",po,ne,We,go,Rt,Or="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",ho,oe,Ke,_o,Vt,wr="Generate samples from the model and reference model for the given batch of inputs.",uo,z,Be,fo,jt,Dr="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",vo,Ut,yr="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",bo,I,Ge,To,Wt,kr="Returns the training <code>~torch.utils.data.DataLoader</code>.",xo,Kt,Cr="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",$o,re,Ye,Po,Bt,Fr="Log <code>logs</code> on the various objects watching training, including stored metrics.",Oo,se,Ze,wo,Gt,Lr="Context manager for handling null reference model (that is, peft adapter manipulation).",Do,w,Je,yo,Yt,Nr="Tokenize a single row from a DPO specific dataset.",ko,Zt,zr=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Co,Jt,Ir=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Na,Qe,za,A,Xe,Fo,Qt,qr="Configuration class for DDPOTrainer",Ia,et,qa,P,tt,Lo,Xt,Mr=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,No,ie,at,zo,ea,Sr="Calculate the loss for a batch of an unpacked sample",Io,le,nt,qo,ta,Er="Creates and saves a model card for a TRL model.",Mo,D,ot,So,aa,Ar="Perform a single step of training.",Eo,na,Hr="Side Effects:",Ao,oa,Rr="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",Ho,de,rt,Ro,ra,Vr="Train the model for a given number of epochs",Ma,st,Sa,C,it,Vo,sa,jr="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",jo,ce,lt,Uo,ia,Ur="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",Ea,dt,Aa,H,ct,Wo,la,Wr="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",Ha,ua,Ra;return ge=new F({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),_e=new F({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),ue=new f({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L34"}}),fe=new F({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ve=new f({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L109"}}),be=new f({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L941",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),Te=new f({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1078",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),xe=new f({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1386"}}),$e=new f({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Pe=new f({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),Oe=new f({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1313"}}),we=new f({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1160"}}),De=new f({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),ye=new f({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1249",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),ke=new f({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Ce=new f({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1032",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),Fe=new F({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),Le=new f({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": int = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Optional = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_config.py#L21"}}),Ne=new F({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),ze=new f({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L36"}}),Ie=new F({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),qe=new f({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets
eval_packing &#x2014; (<code>Optional[bool]</code>, <em>optional</em>):
Whether to pack the eval dataset as well. Defaults to <code>packing</code> if <code>None</code> is passed.`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L55"}}),Me=new F({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Se=new f({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOTrainer.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOTrainer.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOTrainer.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOTrainer.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L65"}}),Ee=new f({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L550"}}),Ae=new f({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L758"}}),He=new f({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L961"}}),Re=new f({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Ve=new f({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L844",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),je=new f({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1180"}}),Ue=new f({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),We=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1008"}}),Ke=new f({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1090"}}),Be=new f({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L498"}}),Ge=new f({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L455"}}),Ye=new f({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1230"}}),Ze=new f({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L746"}}),Je=new f({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L600"}}),Qe=new F({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),Xe=new f({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": Optional = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": Optional = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": Optional = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_config.py#L11"}}),et=new F({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),tt=new f({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": Callable"},{name:"prompt_function",val:": Callable"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L55"}}),at=new f({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),nt=new f({props:{name:"create_model_card",anchor:"trl.DDPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL DDPO Model'"}],parametersDescription:[{anchor:"trl.DDPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.DDPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL DDPO Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L606"}}),ot=new f({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),rt=new f({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L596"}}),st=new F({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),it=new f({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"data_collator",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"truncation_mode",val:": Optional = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L39"}}),lt=new f({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"texts",val:": Optional = None"},{name:"texts_labels",val:": Optional = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),dt=new F({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),ct=new f({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/main/trl/core.py#L209"}}),{c(){M=o("meta"),fa=a(),_a=o("p"),va=a(),d(ge.$$.fragment),ba=a(),he=o("p"),he.innerHTML=Bo,Ta=a(),d(_e.$$.fragment),xa=a(),S=o("div"),d(ue.$$.fragment),fn=a(),mt=o("p"),mt.textContent=Go,$a=a(),d(fe.$$.fragment),Pa=a(),x=o("div"),d(ve.$$.fragment),vn=a(),pt=o("p"),pt.innerHTML=Yo,bn=a(),R=o("div"),d(be.$$.fragment),Tn=a(),gt=o("p"),gt.textContent=Zo,xn=a(),V=o("div"),d(Te.$$.fragment),$n=a(),ht=o("p"),ht.textContent=Jo,Pn=a(),j=o("div"),d(xe.$$.fragment),On=a(),_t=o("p"),_t.textContent=Qo,wn=a(),U=o("div"),d($e.$$.fragment),Dn=a(),ut=o("p"),ut.textContent=Xo,yn=a(),W=o("div"),d(Pe.$$.fragment),kn=a(),ft=o("p"),ft.innerHTML=er,Cn=a(),K=o("div"),d(Oe.$$.fragment),Fn=a(),vt=o("p"),vt.textContent=tr,Ln=a(),B=o("div"),d(we.$$.fragment),Nn=a(),bt=o("p"),bt.textContent=ar,zn=a(),G=o("div"),d(De.$$.fragment),In=a(),Tt=o("p"),Tt.textContent=nr,qn=a(),Y=o("div"),d(ye.$$.fragment),Mn=a(),xt=o("p"),xt.textContent=or,Sn=a(),Z=o("div"),d(ke.$$.fragment),En=a(),$t=o("p"),$t.textContent=rr,An=a(),J=o("div"),d(Ce.$$.fragment),Hn=a(),Pt=o("p"),Pt.textContent=sr,Oa=a(),d(Fe.$$.fragment),wa=a(),k=o("div"),d(Le.$$.fragment),Rn=a(),Ot=o("p"),Ot.innerHTML=ir,Vn=a(),wt=o("p"),wt.innerHTML=lr,Da=a(),d(Ne.$$.fragment),ya=a(),O=o("div"),d(ze.$$.fragment),jn=a(),Dt=o("p"),Dt.innerHTML=dr,Un=a(),yt=o("p"),yt.innerHTML=cr,Wn=a(),kt=o("ul"),kt.innerHTML=mr,Kn=a(),Ct=o("p"),Ct.innerHTML=pr,ka=a(),d(Ie.$$.fragment),Ca=a(),E=o("div"),d(qe.$$.fragment),Bn=a(),Ft=o("p"),Ft.innerHTML=gr,Fa=a(),d(Me.$$.fragment),La=a(),v=o("div"),d(Se.$$.fragment),Gn=a(),Lt=o("p"),Lt.textContent=hr,Yn=a(),Q=o("div"),d(Ee.$$.fragment),Zn=a(),Nt=o("p"),Nt.innerHTML=_r,Jn=a(),X=o("div"),d(Ae.$$.fragment),Qn=a(),zt=o("p"),zt.textContent=ur,Xn=a(),L=o("div"),d(He.$$.fragment),eo=a(),It=o("p"),It.textContent=fr,to=a(),qt=o("p"),qt.textContent=vr,ao=a(),ee=o("div"),d(Re.$$.fragment),no=a(),Mt=o("p"),Mt.textContent=br,oo=a(),te=o("div"),d(Ve.$$.fragment),ro=a(),St=o("p"),St.textContent=Tr,so=a(),N=o("div"),d(je.$$.fragment),io=a(),Et=o("p"),Et.innerHTML=xr,lo=a(),At=o("p"),At.textContent=$r,co=a(),ae=o("div"),d(Ue.$$.fragment),mo=a(),Ht=o("p"),Ht.textContent=Pr,po=a(),ne=o("div"),d(We.$$.fragment),go=a(),Rt=o("p"),Rt.textContent=Or,ho=a(),oe=o("div"),d(Ke.$$.fragment),_o=a(),Vt=o("p"),Vt.textContent=wr,uo=a(),z=o("div"),d(Be.$$.fragment),fo=a(),jt=o("p"),jt.innerHTML=Dr,vo=a(),Ut=o("p"),Ut.innerHTML=yr,bo=a(),I=o("div"),d(Ge.$$.fragment),To=a(),Wt=o("p"),Wt.innerHTML=kr,xo=a(),Kt=o("p"),Kt.innerHTML=Cr,$o=a(),re=o("div"),d(Ye.$$.fragment),Po=a(),Bt=o("p"),Bt.innerHTML=Fr,Oo=a(),se=o("div"),d(Ze.$$.fragment),wo=a(),Gt=o("p"),Gt.textContent=Lr,Do=a(),w=o("div"),d(Je.$$.fragment),yo=a(),Yt=o("p"),Yt.textContent=Nr,ko=a(),Zt=o("p"),Zt.textContent=zr,Co=a(),Jt=o("p"),Jt.textContent=Ir,Na=a(),d(Qe.$$.fragment),za=a(),A=o("div"),d(Xe.$$.fragment),Fo=a(),Qt=o("p"),Qt.textContent=qr,Ia=a(),d(et.$$.fragment),qa=a(),P=o("div"),d(tt.$$.fragment),Lo=a(),Xt=o("p"),Xt.innerHTML=Mr,No=a(),ie=o("div"),d(at.$$.fragment),zo=a(),ea=o("p"),ea.textContent=Sr,Io=a(),le=o("div"),d(nt.$$.fragment),qo=a(),ta=o("p"),ta.textContent=Er,Mo=a(),D=o("div"),d(ot.$$.fragment),So=a(),aa=o("p"),aa.textContent=Ar,Eo=a(),na=o("p"),na.textContent=Hr,Ao=a(),oa=o("ul"),oa.innerHTML=Rr,Ho=a(),de=o("div"),d(rt.$$.fragment),Ro=a(),ra=o("p"),ra.textContent=Vr,Ma=a(),d(st.$$.fragment),Sa=a(),C=o("div"),d(it.$$.fragment),Vo=a(),sa=o("p"),sa.textContent=jr,jo=a(),ce=o("div"),d(lt.$$.fragment),Uo=a(),ia=o("p"),ia.textContent=Ur,Ea=a(),d(dt.$$.fragment),Aa=a(),H=o("div"),d(ct.$$.fragment),Wo=a(),la=o("p"),la.innerHTML=Wr,Ha=a(),ua=o("p"),this.h()},l(e){const l=Jr("svelte-u9bgzb",document.head);M=r(l,"META",{name:!0,content:!0}),l.forEach(s),fa=n(e),_a=r(e,"P",{}),_(_a).forEach(s),va=n(e),c(ge.$$.fragment,e),ba=n(e),he=r(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-dxrcnp"&&(he.innerHTML=Bo),Ta=n(e),c(_e.$$.fragment,e),xa=n(e),S=r(e,"DIV",{class:!0});var Va=_(S);c(ue.$$.fragment,Va),fn=n(Va),mt=r(Va,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-aondqr"&&(mt.textContent=Go),Va.forEach(s),$a=n(e),c(fe.$$.fragment,e),Pa=n(e),x=r(e,"DIV",{class:!0});var $=_(x);c(ve.$$.fragment,$),vn=n($),pt=r($,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-hys9rl"&&(pt.innerHTML=Yo),bn=n($),R=r($,"DIV",{class:!0});var ja=_(R);c(be.$$.fragment,ja),Tn=n(ja),gt=r(ja,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-185nst0"&&(gt.textContent=Zo),ja.forEach(s),xn=n($),V=r($,"DIV",{class:!0});var Ua=_(V);c(Te.$$.fragment,Ua),$n=n(Ua),ht=r(Ua,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-3nt516"&&(ht.textContent=Jo),Ua.forEach(s),Pn=n($),j=r($,"DIV",{class:!0});var Wa=_(j);c(xe.$$.fragment,Wa),On=n(Wa),_t=r(Wa,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-3jfrz9"&&(_t.textContent=Qo),Wa.forEach(s),wn=n($),U=r($,"DIV",{class:!0});var Ka=_(U);c($e.$$.fragment,Ka),Dn=n(Ka),ut=r(Ka,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-lcc1u3"&&(ut.textContent=Xo),Ka.forEach(s),yn=n($),W=r($,"DIV",{class:!0});var Ba=_(W);c(Pe.$$.fragment,Ba),kn=n(Ba),ft=r(Ba,"P",{"data-svelte-h":!0}),i(ft)!=="svelte-1gqqzmu"&&(ft.innerHTML=er),Ba.forEach(s),Cn=n($),K=r($,"DIV",{class:!0});var Ga=_(K);c(Oe.$$.fragment,Ga),Fn=n(Ga),vt=r(Ga,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-ffqz5"&&(vt.textContent=tr),Ga.forEach(s),Ln=n($),B=r($,"DIV",{class:!0});var Ya=_(B);c(we.$$.fragment,Ya),Nn=n(Ya),bt=r(Ya,"P",{"data-svelte-h":!0}),i(bt)!=="svelte-febvhf"&&(bt.textContent=ar),Ya.forEach(s),zn=n($),G=r($,"DIV",{class:!0});var Za=_(G);c(De.$$.fragment,Za),In=n(Za),Tt=r(Za,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-1hbodkw"&&(Tt.textContent=nr),Za.forEach(s),qn=n($),Y=r($,"DIV",{class:!0});var Ja=_(Y);c(ye.$$.fragment,Ja),Mn=n(Ja),xt=r(Ja,"P",{"data-svelte-h":!0}),i(xt)!=="svelte-1hfgx92"&&(xt.textContent=or),Ja.forEach(s),Sn=n($),Z=r($,"DIV",{class:!0});var Qa=_(Z);c(ke.$$.fragment,Qa),En=n(Qa),$t=r(Qa,"P",{"data-svelte-h":!0}),i($t)!=="svelte-yrsdu6"&&($t.textContent=rr),Qa.forEach(s),An=n($),J=r($,"DIV",{class:!0});var Xa=_(J);c(Ce.$$.fragment,Xa),Hn=n(Xa),Pt=r(Xa,"P",{"data-svelte-h":!0}),i(Pt)!=="svelte-3k7k5e"&&(Pt.textContent=sr),Xa.forEach(s),$.forEach(s),Oa=n(e),c(Fe.$$.fragment,e),wa=n(e),k=r(e,"DIV",{class:!0});var da=_(k);c(Le.$$.fragment,da),Rn=n(da),Ot=r(da,"P",{"data-svelte-h":!0}),i(Ot)!=="svelte-1alpag9"&&(Ot.innerHTML=ir),Vn=n(da),wt=r(da,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1xl7jqc"&&(wt.innerHTML=lr),da.forEach(s),Da=n(e),c(Ne.$$.fragment,e),ya=n(e),O=r(e,"DIV",{class:!0});var q=_(O);c(ze.$$.fragment,q),jn=n(q),Dt=r(q,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-qafafj"&&(Dt.innerHTML=dr),Un=n(q),yt=r(q,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-bkmbwh"&&(yt.innerHTML=cr),Wn=n(q),kt=r(q,"UL",{"data-svelte-h":!0}),i(kt)!=="svelte-1ytuxgw"&&(kt.innerHTML=mr),Kn=n(q),Ct=r(q,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-18tbp4c"&&(Ct.innerHTML=pr),q.forEach(s),ka=n(e),c(Ie.$$.fragment,e),Ca=n(e),E=r(e,"DIV",{class:!0});var en=_(E);c(qe.$$.fragment,en),Bn=n(en),Ft=r(en,"P",{"data-svelte-h":!0}),i(Ft)!=="svelte-14oyph8"&&(Ft.innerHTML=gr),en.forEach(s),Fa=n(e),c(Me.$$.fragment,e),La=n(e),v=r(e,"DIV",{class:!0});var T=_(v);c(Se.$$.fragment,T),Gn=n(T),Lt=r(T,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-n6cc8y"&&(Lt.textContent=hr),Yn=n(T),Q=r(T,"DIV",{class:!0});var tn=_(Q);c(Ee.$$.fragment,tn),Zn=n(tn),Nt=r(tn,"P",{"data-svelte-h":!0}),i(Nt)!=="svelte-mcz8nm"&&(Nt.innerHTML=_r),tn.forEach(s),Jn=n(T),X=r(T,"DIV",{class:!0});var an=_(X);c(Ae.$$.fragment,an),Qn=n(an),zt=r(an,"P",{"data-svelte-h":!0}),i(zt)!=="svelte-10t1062"&&(zt.textContent=ur),an.forEach(s),Xn=n(T),L=r(T,"DIV",{class:!0});var ca=_(L);c(He.$$.fragment,ca),eo=n(ca),It=r(ca,"P",{"data-svelte-h":!0}),i(It)!=="svelte-16i1nac"&&(It.textContent=fr),to=n(ca),qt=r(ca,"P",{"data-svelte-h":!0}),i(qt)!=="svelte-tgti68"&&(qt.textContent=vr),ca.forEach(s),ao=n(T),ee=r(T,"DIV",{class:!0});var nn=_(ee);c(Re.$$.fragment,nn),no=n(nn),Mt=r(nn,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-1cvsgkk"&&(Mt.textContent=br),nn.forEach(s),oo=n(T),te=r(T,"DIV",{class:!0});var on=_(te);c(Ve.$$.fragment,on),ro=n(on),St=r(on,"P",{"data-svelte-h":!0}),i(St)!=="svelte-ymgxq7"&&(St.textContent=Tr),on.forEach(s),so=n(T),N=r(T,"DIV",{class:!0});var ma=_(N);c(je.$$.fragment,ma),io=n(ma),Et=r(ma,"P",{"data-svelte-h":!0}),i(Et)!=="svelte-8qlty5"&&(Et.innerHTML=xr),lo=n(ma),At=r(ma,"P",{"data-svelte-h":!0}),i(At)!=="svelte-1tyo99t"&&(At.textContent=$r),ma.forEach(s),co=n(T),ae=r(T,"DIV",{class:!0});var rn=_(ae);c(Ue.$$.fragment,rn),mo=n(rn),Ht=r(rn,"P",{"data-svelte-h":!0}),i(Ht)!=="svelte-4nmimv"&&(Ht.textContent=Pr),rn.forEach(s),po=n(T),ne=r(T,"DIV",{class:!0});var sn=_(ne);c(We.$$.fragment,sn),go=n(sn),Rt=r(sn,"P",{"data-svelte-h":!0}),i(Rt)!=="svelte-11q8u7l"&&(Rt.textContent=Or),sn.forEach(s),ho=n(T),oe=r(T,"DIV",{class:!0});var ln=_(oe);c(Ke.$$.fragment,ln),_o=n(ln),Vt=r(ln,"P",{"data-svelte-h":!0}),i(Vt)!=="svelte-18uwvbi"&&(Vt.textContent=wr),ln.forEach(s),uo=n(T),z=r(T,"DIV",{class:!0});var pa=_(z);c(Be.$$.fragment,pa),fo=n(pa),jt=r(pa,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-xesobz"&&(jt.innerHTML=Dr),vo=n(pa),Ut=r(pa,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-qg43tm"&&(Ut.innerHTML=yr),pa.forEach(s),bo=n(T),I=r(T,"DIV",{class:!0});var ga=_(I);c(Ge.$$.fragment,ga),To=n(ga),Wt=r(ga,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-dkae9b"&&(Wt.innerHTML=kr),xo=n(ga),Kt=r(ga,"P",{"data-svelte-h":!0}),i(Kt)!=="svelte-hmd5cw"&&(Kt.innerHTML=Cr),ga.forEach(s),$o=n(T),re=r(T,"DIV",{class:!0});var dn=_(re);c(Ye.$$.fragment,dn),Po=n(dn),Bt=r(dn,"P",{"data-svelte-h":!0}),i(Bt)!=="svelte-nqksfz"&&(Bt.innerHTML=Fr),dn.forEach(s),Oo=n(T),se=r(T,"DIV",{class:!0});var cn=_(se);c(Ze.$$.fragment,cn),wo=n(cn),Gt=r(cn,"P",{"data-svelte-h":!0}),i(Gt)!=="svelte-17kjsy4"&&(Gt.textContent=Lr),cn.forEach(s),Do=n(T),w=r(T,"DIV",{class:!0});var me=_(w);c(Je.$$.fragment,me),yo=n(me),Yt=r(me,"P",{"data-svelte-h":!0}),i(Yt)!=="svelte-1861yti"&&(Yt.textContent=Nr),ko=n(me),Zt=r(me,"P",{"data-svelte-h":!0}),i(Zt)!=="svelte-1mn1gnw"&&(Zt.textContent=zr),Co=n(me),Jt=r(me,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-1xvpyih"&&(Jt.textContent=Ir),me.forEach(s),T.forEach(s),Na=n(e),c(Qe.$$.fragment,e),za=n(e),A=r(e,"DIV",{class:!0});var mn=_(A);c(Xe.$$.fragment,mn),Fo=n(mn),Qt=r(mn,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-2zpx1f"&&(Qt.textContent=qr),mn.forEach(s),Ia=n(e),c(et.$$.fragment,e),qa=n(e),P=r(e,"DIV",{class:!0});var y=_(P);c(tt.$$.fragment,y),Lo=n(y),Xt=r(y,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-8q861t"&&(Xt.innerHTML=Mr),No=n(y),ie=r(y,"DIV",{class:!0});var pn=_(ie);c(at.$$.fragment,pn),zo=n(pn),ea=r(pn,"P",{"data-svelte-h":!0}),i(ea)!=="svelte-1ag17u3"&&(ea.textContent=Sr),pn.forEach(s),Io=n(y),le=r(y,"DIV",{class:!0});var gn=_(le);c(nt.$$.fragment,gn),qo=n(gn),ta=r(gn,"P",{"data-svelte-h":!0}),i(ta)!=="svelte-3jfrz9"&&(ta.textContent=Er),gn.forEach(s),Mo=n(y),D=r(y,"DIV",{class:!0});var pe=_(D);c(ot.$$.fragment,pe),So=n(pe),aa=r(pe,"P",{"data-svelte-h":!0}),i(aa)!=="svelte-r6y15n"&&(aa.textContent=Ar),Eo=n(pe),na=r(pe,"P",{"data-svelte-h":!0}),i(na)!=="svelte-imqqfp"&&(na.textContent=Hr),Ao=n(pe),oa=r(pe,"UL",{"data-svelte-h":!0}),i(oa)!=="svelte-105j238"&&(oa.innerHTML=Rr),pe.forEach(s),Ho=n(y),de=r(y,"DIV",{class:!0});var hn=_(de);c(rt.$$.fragment,hn),Ro=n(hn),ra=r(hn,"P",{"data-svelte-h":!0}),i(ra)!=="svelte-1an944l"&&(ra.textContent=Vr),hn.forEach(s),y.forEach(s),Ma=n(e),c(st.$$.fragment,e),Sa=n(e),C=r(e,"DIV",{class:!0});var ha=_(C);c(it.$$.fragment,ha),Vo=n(ha),sa=r(ha,"P",{"data-svelte-h":!0}),i(sa)!=="svelte-xqyw6w"&&(sa.textContent=jr),jo=n(ha),ce=r(ha,"DIV",{class:!0});var _n=_(ce);c(lt.$$.fragment,_n),Uo=n(_n),ia=r(_n,"P",{"data-svelte-h":!0}),i(ia)!=="svelte-v7dhdf"&&(ia.textContent=Ur),_n.forEach(s),ha.forEach(s),Ea=n(e),c(dt.$$.fragment,e),Aa=n(e),H=r(e,"DIV",{class:!0});var un=_(H);c(ct.$$.fragment,un),Wo=n(un),la=r(un,"P",{"data-svelte-h":!0}),i(la)!=="svelte-1aeuhep"&&(la.innerHTML=Wr),un.forEach(s),Ha=n(e),ua=r(e,"P",{}),_(ua).forEach(s),this.h()},h(){u(M,"name","hf:doc:metadata"),u(M,"content",Xr),u(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,M),b(e,fa,l),b(e,_a,l),b(e,va,l),m(ge,e,l),b(e,ba,l),b(e,he,l),b(e,Ta,l),m(_e,e,l),b(e,xa,l),b(e,S,l),m(ue,S,null),t(S,fn),t(S,mt),b(e,$a,l),m(fe,e,l),b(e,Pa,l),b(e,x,l),m(ve,x,null),t(x,vn),t(x,pt),t(x,bn),t(x,R),m(be,R,null),t(R,Tn),t(R,gt),t(x,xn),t(x,V),m(Te,V,null),t(V,$n),t(V,ht),t(x,Pn),t(x,j),m(xe,j,null),t(j,On),t(j,_t),t(x,wn),t(x,U),m($e,U,null),t(U,Dn),t(U,ut),t(x,yn),t(x,W),m(Pe,W,null),t(W,kn),t(W,ft),t(x,Cn),t(x,K),m(Oe,K,null),t(K,Fn),t(K,vt),t(x,Ln),t(x,B),m(we,B,null),t(B,Nn),t(B,bt),t(x,zn),t(x,G),m(De,G,null),t(G,In),t(G,Tt),t(x,qn),t(x,Y),m(ye,Y,null),t(Y,Mn),t(Y,xt),t(x,Sn),t(x,Z),m(ke,Z,null),t(Z,En),t(Z,$t),t(x,An),t(x,J),m(Ce,J,null),t(J,Hn),t(J,Pt),b(e,Oa,l),m(Fe,e,l),b(e,wa,l),b(e,k,l),m(Le,k,null),t(k,Rn),t(k,Ot),t(k,Vn),t(k,wt),b(e,Da,l),m(Ne,e,l),b(e,ya,l),b(e,O,l),m(ze,O,null),t(O,jn),t(O,Dt),t(O,Un),t(O,yt),t(O,Wn),t(O,kt),t(O,Kn),t(O,Ct),b(e,ka,l),m(Ie,e,l),b(e,Ca,l),b(e,E,l),m(qe,E,null),t(E,Bn),t(E,Ft),b(e,Fa,l),m(Me,e,l),b(e,La,l),b(e,v,l),m(Se,v,null),t(v,Gn),t(v,Lt),t(v,Yn),t(v,Q),m(Ee,Q,null),t(Q,Zn),t(Q,Nt),t(v,Jn),t(v,X),m(Ae,X,null),t(X,Qn),t(X,zt),t(v,Xn),t(v,L),m(He,L,null),t(L,eo),t(L,It),t(L,to),t(L,qt),t(v,ao),t(v,ee),m(Re,ee,null),t(ee,no),t(ee,Mt),t(v,oo),t(v,te),m(Ve,te,null),t(te,ro),t(te,St),t(v,so),t(v,N),m(je,N,null),t(N,io),t(N,Et),t(N,lo),t(N,At),t(v,co),t(v,ae),m(Ue,ae,null),t(ae,mo),t(ae,Ht),t(v,po),t(v,ne),m(We,ne,null),t(ne,go),t(ne,Rt),t(v,ho),t(v,oe),m(Ke,oe,null),t(oe,_o),t(oe,Vt),t(v,uo),t(v,z),m(Be,z,null),t(z,fo),t(z,jt),t(z,vo),t(z,Ut),t(v,bo),t(v,I),m(Ge,I,null),t(I,To),t(I,Wt),t(I,xo),t(I,Kt),t(v,$o),t(v,re),m(Ye,re,null),t(re,Po),t(re,Bt),t(v,Oo),t(v,se),m(Ze,se,null),t(se,wo),t(se,Gt),t(v,Do),t(v,w),m(Je,w,null),t(w,yo),t(w,Yt),t(w,ko),t(w,Zt),t(w,Co),t(w,Jt),b(e,Na,l),m(Qe,e,l),b(e,za,l),b(e,A,l),m(Xe,A,null),t(A,Fo),t(A,Qt),b(e,Ia,l),m(et,e,l),b(e,qa,l),b(e,P,l),m(tt,P,null),t(P,Lo),t(P,Xt),t(P,No),t(P,ie),m(at,ie,null),t(ie,zo),t(ie,ea),t(P,Io),t(P,le),m(nt,le,null),t(le,qo),t(le,ta),t(P,Mo),t(P,D),m(ot,D,null),t(D,So),t(D,aa),t(D,Eo),t(D,na),t(D,Ao),t(D,oa),t(P,Ho),t(P,de),m(rt,de,null),t(de,Ro),t(de,ra),b(e,Ma,l),m(st,e,l),b(e,Sa,l),b(e,C,l),m(it,C,null),t(C,Vo),t(C,sa),t(C,jo),t(C,ce),m(lt,ce,null),t(ce,Uo),t(ce,ia),b(e,Ea,l),m(dt,e,l),b(e,Aa,l),b(e,H,l),m(ct,H,null),t(H,Wo),t(H,la),b(e,Ha,l),b(e,ua,l),Ra=!0},p:Br,i(e){Ra||(p(ge.$$.fragment,e),p(_e.$$.fragment,e),p(ue.$$.fragment,e),p(fe.$$.fragment,e),p(ve.$$.fragment,e),p(be.$$.fragment,e),p(Te.$$.fragment,e),p(xe.$$.fragment,e),p($e.$$.fragment,e),p(Pe.$$.fragment,e),p(Oe.$$.fragment,e),p(we.$$.fragment,e),p(De.$$.fragment,e),p(ye.$$.fragment,e),p(ke.$$.fragment,e),p(Ce.$$.fragment,e),p(Fe.$$.fragment,e),p(Le.$$.fragment,e),p(Ne.$$.fragment,e),p(ze.$$.fragment,e),p(Ie.$$.fragment,e),p(qe.$$.fragment,e),p(Me.$$.fragment,e),p(Se.$$.fragment,e),p(Ee.$$.fragment,e),p(Ae.$$.fragment,e),p(He.$$.fragment,e),p(Re.$$.fragment,e),p(Ve.$$.fragment,e),p(je.$$.fragment,e),p(Ue.$$.fragment,e),p(We.$$.fragment,e),p(Ke.$$.fragment,e),p(Be.$$.fragment,e),p(Ge.$$.fragment,e),p(Ye.$$.fragment,e),p(Ze.$$.fragment,e),p(Je.$$.fragment,e),p(Qe.$$.fragment,e),p(Xe.$$.fragment,e),p(et.$$.fragment,e),p(tt.$$.fragment,e),p(at.$$.fragment,e),p(nt.$$.fragment,e),p(ot.$$.fragment,e),p(rt.$$.fragment,e),p(st.$$.fragment,e),p(it.$$.fragment,e),p(lt.$$.fragment,e),p(dt.$$.fragment,e),p(ct.$$.fragment,e),Ra=!0)},o(e){g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Pe.$$.fragment,e),g(Oe.$$.fragment,e),g(we.$$.fragment,e),g(De.$$.fragment,e),g(ye.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(Fe.$$.fragment,e),g(Le.$$.fragment,e),g(Ne.$$.fragment,e),g(ze.$$.fragment,e),g(Ie.$$.fragment,e),g(qe.$$.fragment,e),g(Me.$$.fragment,e),g(Se.$$.fragment,e),g(Ee.$$.fragment,e),g(Ae.$$.fragment,e),g(He.$$.fragment,e),g(Re.$$.fragment,e),g(Ve.$$.fragment,e),g(je.$$.fragment,e),g(Ue.$$.fragment,e),g(We.$$.fragment,e),g(Ke.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(Ye.$$.fragment,e),g(Ze.$$.fragment,e),g(Je.$$.fragment,e),g(Qe.$$.fragment,e),g(Xe.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(at.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(rt.$$.fragment,e),g(st.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),Ra=!1},d(e){e&&(s(fa),s(_a),s(va),s(ba),s(he),s(Ta),s(xa),s(S),s($a),s(Pa),s(x),s(Oa),s(wa),s(k),s(Da),s(ya),s(O),s(ka),s(Ca),s(E),s(Fa),s(La),s(v),s(Na),s(za),s(A),s(Ia),s(qa),s(P),s(Ma),s(Sa),s(C),s(Ea),s(Aa),s(H),s(Ha),s(ua)),s(M),h(ge,e),h(_e,e),h(ue),h(fe,e),h(ve),h(be),h(Te),h(xe),h($e),h(Pe),h(Oe),h(we),h(De),h(ye),h(ke),h(Ce),h(Fe,e),h(Le),h(Ne,e),h(ze),h(Ie,e),h(qe),h(Me,e),h(Se),h(Ee),h(Ae),h(He),h(Re),h(Ve),h(je),h(Ue),h(We),h(Ke),h(Be),h(Ge),h(Ye),h(Ze),h(Je),h(Qe,e),h(Xe),h(et,e),h(tt),h(at),h(nt),h(ot),h(rt),h(st,e),h(it),h(lt),h(dt,e),h(ct)}}}const Xr='{"title":"Trainer","local":"trainer","sections":[{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function es(Ko){return Gr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends Yr{constructor(M){super(),Zr(this,M,es,Qr,Kr,{})}}export{rs as component};
