import{s as ks,n as Bs,o as _s}from"../chunks/scheduler.85c25b89.js";import{S as Gs,i as Ns,g as m,s as e,r as i,H as Qs,A as Rs,h as p,f as t,c as n,j as ws,u as r,x as o,E as Es,k as vs,y as Vs,a as l,v as c,d as h,t as g,w as d}from"../chunks/index.c9bcf812.js";import{C as E}from"../chunks/CodeBlock.94efc595.js";import{H as X}from"../chunks/Heading.3c6e5b17.js";function Ys(ys){let M,H,V,z,w,S,y,js="<strong>RegNetX</strong> is a convolutional network design space with simple, regular models with parameters: depth $d$, initial width $w_{0} &gt; 0$, and slope $w_{a} &gt; 0$, and generates a different block width $u_{j}$ for each block $j &lt; d$. The key restriction for the RegNet types of model is that there is a linear parameterisation of block widths (the design space only contains models with this linear structure):",A,R,F,Zs='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>j</mi><mo>=</mo><mi>w</mi><mi mathvariant="normal">_</mi><mn>0</mn><mo>+</mo><mi>w</mi><mi mathvariant="normal">_</mi><mi>a</mi><mo>⋅</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> u\\_{j} = w\\_{0} + w\\_{a}\\cdot{j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9695em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9544em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord">0</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7545em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal">a</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">⋅</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span></span></span>',L,j,Js="For <strong>RegNetX</strong> we have additional restrictions: we set $b = 1$ (the bottleneck ratio), $12 \\leq d \\leq 28$, and $w_{m} \\geq 2$ (the width multiplier).",D,J,P,T,Ts="To load a pretrained model:",q,u,K,b,us="To load and preprocess the image:",O,f,ss,U,bs="To get the model predictions:",as,$,ts,I,fs="To get the top-5 predictions class names:",ls,x,es,C,Us="Replace the model name with the variant you want to use, e.g. <code>regnetx_002</code>. You can find the IDs in the model summaries at the top of this page.",ns,W,$s='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ms,v,ps,Z,Is="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",is,k,rs,B,xs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,os,_,cs,G,Cs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',hs,N,gs,Q,ds,Y,Ms;return w=new X({props:{title:"RegNetX",local:"regnetx",headingTag:"h1"}}),J=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new E({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlZ25ldHhfMDAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnetx_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new E({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new E({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new E({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVnbmV0eF8wMDInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnetx_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),_=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new E({props:{code:"JTQwbWlzYyU3QnJhZG9zYXZvdmljMjAyMGRlc2lnbmluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRGVzaWduaW5nJTIwTmV0d29yayUyMERlc2lnbiUyMFNwYWNlcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QklsaWphJTIwUmFkb3Nhdm92aWMlMjBhbmQlMjBSYWolMjBQcmF0ZWVrJTIwS29zYXJhanUlMjBhbmQlMjBSb3NzJTIwR2lyc2hpY2slMjBhbmQlMjBLYWltaW5nJTIwSGUlMjBhbmQlMjBQaW90ciUyMERvbGwlQzMlQTFyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjc4JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{radosavovic2020designing,
      title={Designing Network Design Spaces}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Ilija Radosavovic and Raj Prateek Kosaraju and Ross Girshick and Kaiming He and Piotr Dollár}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2003.13678}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){M=m("meta"),H=e(),V=m("p"),z=e(),i(w.$$.fragment),S=e(),y=m("p"),y.innerHTML=js,A=e(),R=m("p"),F=new Qs(!1),L=e(),j=m("p"),j.innerHTML=Js,D=e(),i(J.$$.fragment),P=e(),T=m("p"),T.textContent=Ts,q=e(),i(u.$$.fragment),K=e(),b=m("p"),b.textContent=us,O=e(),i(f.$$.fragment),ss=e(),U=m("p"),U.textContent=bs,as=e(),i($.$$.fragment),ts=e(),I=m("p"),I.textContent=fs,ls=e(),i(x.$$.fragment),es=e(),C=m("p"),C.innerHTML=Us,ns=e(),W=m("p"),W.innerHTML=$s,ms=e(),i(v.$$.fragment),ps=e(),Z=m("p"),Z.textContent=Is,is=e(),i(k.$$.fragment),rs=e(),B=m("p"),B.innerHTML=xs,os=e(),i(_.$$.fragment),cs=e(),G=m("p"),G.innerHTML=Cs,hs=e(),i(N.$$.fragment),gs=e(),i(Q.$$.fragment),ds=e(),Y=m("p"),this.h()},l(s){const a=Rs("svelte-u9bgzb",document.head);M=p(a,"META",{name:!0,content:!0}),a.forEach(t),H=n(s),V=p(s,"P",{}),ws(V).forEach(t),z=n(s),r(w.$$.fragment,s),S=n(s),y=p(s,"P",{"data-svelte-h":!0}),o(y)!=="svelte-11cu0pz"&&(y.innerHTML=js),A=n(s),R=p(s,"P",{});var Ws=ws(R);F=Es(Ws,!1),Ws.forEach(t),L=n(s),j=p(s,"P",{"data-svelte-h":!0}),o(j)!=="svelte-mi3jox"&&(j.innerHTML=Js),D=n(s),r(J.$$.fragment,s),P=n(s),T=p(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-18ywhxh"&&(T.textContent=Ts),q=n(s),r(u.$$.fragment,s),K=n(s),b=p(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1c2ipa8"&&(b.textContent=us),O=n(s),r(f.$$.fragment,s),ss=n(s),U=p(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1n9qsq1"&&(U.textContent=bs),as=n(s),r($.$$.fragment,s),ts=n(s),I=p(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-19cnvx1"&&(I.textContent=fs),ls=n(s),r(x.$$.fragment,s),es=n(s),C=p(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-o836lw"&&(C.innerHTML=Us),ns=n(s),W=p(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1wmi3ea"&&(W.innerHTML=$s),ms=n(s),r(v.$$.fragment,s),ps=n(s),Z=p(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-9sr7nh"&&(Z.textContent=Is),is=n(s),r(k.$$.fragment,s),rs=n(s),B=p(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1kguc51"&&(B.innerHTML=xs),os=n(s),r(_.$$.fragment,s),cs=n(s),G=p(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1n0coha"&&(G.innerHTML=Cs),hs=n(s),r(N.$$.fragment,s),gs=n(s),r(Q.$$.fragment,s),ds=n(s),Y=p(s,"P",{}),ws(Y).forEach(t),this.h()},h(){vs(M,"name","hf:doc:metadata"),vs(M,"content",Xs),F.a=null},m(s,a){Vs(document.head,M),l(s,H,a),l(s,V,a),l(s,z,a),c(w,s,a),l(s,S,a),l(s,y,a),l(s,A,a),l(s,R,a),F.m(Zs,R),l(s,L,a),l(s,j,a),l(s,D,a),c(J,s,a),l(s,P,a),l(s,T,a),l(s,q,a),c(u,s,a),l(s,K,a),l(s,b,a),l(s,O,a),c(f,s,a),l(s,ss,a),l(s,U,a),l(s,as,a),c($,s,a),l(s,ts,a),l(s,I,a),l(s,ls,a),c(x,s,a),l(s,es,a),l(s,C,a),l(s,ns,a),l(s,W,a),l(s,ms,a),c(v,s,a),l(s,ps,a),l(s,Z,a),l(s,is,a),c(k,s,a),l(s,rs,a),l(s,B,a),l(s,os,a),c(_,s,a),l(s,cs,a),l(s,G,a),l(s,hs,a),c(N,s,a),l(s,gs,a),c(Q,s,a),l(s,ds,a),l(s,Y,a),Ms=!0},p:Bs,i(s){Ms||(h(w.$$.fragment,s),h(J.$$.fragment,s),h(u.$$.fragment,s),h(f.$$.fragment,s),h($.$$.fragment,s),h(x.$$.fragment,s),h(v.$$.fragment,s),h(k.$$.fragment,s),h(_.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),Ms=!0)},o(s){g(w.$$.fragment,s),g(J.$$.fragment,s),g(u.$$.fragment,s),g(f.$$.fragment,s),g($.$$.fragment,s),g(x.$$.fragment,s),g(v.$$.fragment,s),g(k.$$.fragment,s),g(_.$$.fragment,s),g(N.$$.fragment,s),g(Q.$$.fragment,s),Ms=!1},d(s){s&&(t(H),t(V),t(z),t(S),t(y),t(A),t(R),t(L),t(j),t(D),t(P),t(T),t(q),t(K),t(b),t(O),t(ss),t(U),t(as),t(ts),t(I),t(ls),t(es),t(C),t(ns),t(W),t(ms),t(ps),t(Z),t(is),t(rs),t(B),t(os),t(cs),t(G),t(hs),t(gs),t(ds),t(Y)),t(M),d(w,s),d(J,s),d(u,s),d(f,s),d($,s),d(x,s),d(v,s),d(k,s),d(_,s),d(N,s),d(Q,s)}}}const Xs='{"title":"RegNetX","local":"regnetx","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Hs(ys){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ls extends Gs{constructor(M){super(),Ns(this,M,Hs,Ys,ks,{})}}export{Ls as component};
