import{s as Yt,o as At,n as Xt}from"../chunks/scheduler.b108d059.js";import{S as St,i as Vt,g as i,s as l,r as p,A as Ht,h as o,f as a,c as n,j as Zt,u as d,x as g,k as Wt,y as Rt,a as s,v as c,d as h,t as f,w as m}from"../chunks/index.008de539.js";import{T as _t}from"../chunks/Tip.aeb15ab7.js";import{C as M}from"../chunks/CodeBlock.3968c746.js";import{H as w}from"../chunks/Heading.88bfeb84.js";function Nt(me){let r,y='For the full list of available tasks/pipelines, check out <a href="#available-tasks">this table</a>.';return{c(){r=i("p"),r.innerHTML=y},l(u){r=o(u,"P",{"data-svelte-h":!0}),g(r)!=="svelte-gomgj3"&&(r.innerHTML=y)},m(u,T){s(u,r,T)},p:Xt,d(u){u&&a(r)}}}function zt(me){let r,y='By default, models will be downloaded from the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> and stored in <a href="https://developer.mozilla.org/en-US/docs/Web/API/Cache" rel="nofollow">browser cache</a>, but there are ways to specify custom models and cache locations. For more information see <a href="./custom_usage">here</a>.';return{c(){r=i("p"),r.innerHTML=y},l(u){r=o(u,"P",{"data-svelte-h":!0}),g(r)!=="svelte-197t2db"&&(r.innerHTML=y)},m(u,T){s(u,r,T)},p:Xt,d(u){u&&a(r)}}}function Et(me){let r,y,u,T,J,ue,U,dt='Just like the <a href="https://github.com/huggingface/transformers" rel="nofollow">transformers Python library</a>, Transformers.js provides users with a simple way to leverage the power of transformers. The <code>pipeline()</code> function is the easiest and fastest way to use a pretrained model for inference.',we,j,ye,x,Me,k,ct="Start by creating an instance of <code>pipeline()</code> and specifying a task you want to use it for. For example, to create a sentiment analysis pipeline, you can do:",Te,$,je,v,ht="When running for the first time, the <code>pipeline</code> will download and cache the default pretrained model associated with the task. This can take a while, but subsequent calls will be much faster.",be,b,Je,G,ft="You can now use the classifier on your target text by calling it as a function:",Ue,I,xe,B,mt="If you have multiple inputs, you can pass them as an array:",ke,Q,$e,C,gt="You can also specify a different model to use for the pipeline by passing it as the second argument to the <code>pipeline()</code> function. For example, to use a different model for sentiment analysis (like one trained to predict sentiment of a review as a number of stars between 1 and 5), you can do:",ve,Z,Ge,W,ut='Transformers.js supports loading any model hosted on the Hugging Face Hub, provided it has ONNX weights (located in a subfolder called <code>onnx</code>). For more information on how to convert your PyTorch, TensorFlow, or JAX model to ONNX, see the <a href="./custom_usage#convert-your-models-to-onnx">conversion section</a>.',Ie,_,wt="The <code>pipeline()</code> function is a great way to quickly use a pretrained model for inference, as it takes care of all the preprocessing and postprocessing for you. For example, if you want to perform Automatic Speech Recognition (ASR) using OpenAI’s Whisper model, you can do:",Be,X,Qe,Y,Ce,A,Ze,S,yt=`We offer a variety of options to control how models are loaded from the Hugging Face Hub (or locally).
By default, the <em>quantized</em> version of the model is used, which is smaller and faster, but usually less accurate.
To override this behaviour (i.e., use the unquantized model), you can use a custom <code>PretrainedOptions</code> object
as the third parameter to the <code>pipeline</code> function:`,We,V,_e,H,Mt=`You can also specify which revision of the model to use, by passing a <code>revision</code> parameter.
Since the Hugging Face Hub uses a git-based versioning system, you can use any valid git revision specifier (e.g., branch name or commit hash)`,Xe,R,Ye,N,Tt='For the full list of options, check out the <a href="./api/utils/hub#module_utils/hub..PretrainedOptions">PretrainedOptions</a> documentation.',Ae,z,Se,E,jt="Many pipelines have additional options that you can specify. For example, when using a model that does multilingual translation, you can specify the source and target languages like this:",Ve,F,He,L,bt='When using models that support auto-regressive generation, you can specify generation parameters like the number of new tokens, sampling methods, temperature, repetition penalty, and much more. For a full list of available parameters, see to the <a href="./api/utils/generation#module_utils/generation.GenerationConfig">GenerationConfig</a> class.',Re,P,Jt="For example, to generate a poem using <code>LaMini-Flan-T5-783M</code>, you can do:",Ne,D,ze,O,Ut="which outputs:",Ee,q,Fe,K,xt=`For more information on the available options for each pipeline, refer to the <a href="./api/pipelines">API Reference</a>.
If you would like more control over the inference process, you can use the <a href="./api/models"><code>AutoModel</code></a>, <a href="./api/tokenizers"><code>AutoTokenizer</code></a>, or <a href="./api/processors"><code>AutoProcessor</code></a> classes instead.`,Le,ee,Pe,te,De,ae,Oe,se,kt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/conversational" rel="nofollow">Conversational</a></td> <td><code>conversational</code></td> <td>Generating conversational text that is relevant, coherent and knowledgable given a prompt.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill-Mask</a></td> <td><code>fill-mask</code></td> <td>Masking some of the words in a sentence and predicting which words should replace those masks.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FillMaskPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=fill-mask&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td><code>question-answering</code></td> <td>Retrieve the answer to a question from a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.QuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td><code>sentence-similarity</code></td> <td>Determining how similar two texts are.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td><code>summarization</code></td> <td>Producing a shorter version of a document while preserving its important information.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.SummarizationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=summarization&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td><code>table-question-answering</code></td> <td>Answering a question about information from a given table.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td><code>text-classification</code> or <code>sentiment-analysis</code></td> <td>Assigning a label or class to a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#completion-generation-models" rel="nofollow">Text Generation</a></td> <td><code>text-generation</code></td> <td>Producing new text by predicting the next word in a sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#text-to-text-generation-models" rel="nofollow">Text-to-text Generation</a></td> <td><code>text2text-generation</code></td> <td>Converting one text sequence into another text sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.Text2TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text2text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td><code>token-classification</code> or <code>ner</code></td> <td>Assigning a label to each token in a text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TokenClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=token-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td><code>translation</code></td> <td>Converting text from one language to another.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TranslationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=translation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero-Shot Classification</a></td> <td><code>zero-shot-classification</code></td> <td>Classifying text into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',qe,le,Ke,ne,$t='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a></td> <td><code>depth-estimation</code></td> <td>Predicting the depth of objects present in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td><code>image-classification</code></td> <td>Assigning a label or class to an entire image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td><code>image-segmentation</code></td> <td>Divides an image into segments where each pixel is mapped to an object. This task has multiple variants such as instance segmentation, panoptic segmentation and semantic segmentation.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageSegmentationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-segmentation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td><code>image-to-image</code></td> <td>Transforming a source image to match the characteristics of a target image or a target image domain.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/mask-generation" rel="nofollow">Mask Generation</a></td> <td><code>mask-generation</code></td> <td>Generate masks for the objects in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td><code>object-detection</code></td> <td>Identify objects of certain defined classes within an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/video-classification" rel="nofollow">Video Classification</a></td> <td>n/a</td> <td>Assigning a label or class to an entire video.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/unconditional-image-generation" rel="nofollow">Unconditional Image Generation</a></td> <td>n/a</td> <td>Generating images with no condition in any context (like a prompt text or another image).</td> <td>❌</td></tr></tbody>',et,ie,tt,oe,vt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td><code>audio-classification</code></td> <td>Assigning a label or class to a given audio.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>n/a</td> <td>Generating audio from an input audio source.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td><code>automatic-speech-recognition</code></td> <td>Transcribing a given audio into text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AutomaticSpeechRecognitionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td><code>text-to-speech</code> or <code>text-to-audio</code></td> <td>Generating natural-sounding speech given text input.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextToAudioPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-to-audio&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',at,re,st,pe,Gt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>n/a</td> <td>Classifying a target category (a group) based on set of attributes.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>n/a</td> <td>Predicting a numerical value given a set of attributes.</td> <td>❌</td></tr></tbody>',lt,de,nt,ce,It='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Document Question Answering</a></td> <td><code>document-question-answering</code></td> <td>Answering questions on document images.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DocumentQuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=document-question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td><code>feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original dataset.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td><code>image-to-text</code></td> <td>Output text from a given image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToTextPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-text&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td><code>text-to-image</code></td> <td>Generates images from input text.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td><code>visual-question-answering</code></td> <td>Answering open-ended questions based on an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot Image Classification</a></td> <td><code>zero-shot-image-classification</code></td> <td>Classifying images into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',it,he,ot,fe,Bt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/reinforcement-learning" rel="nofollow">Reinforcement Learning</a></td> <td>n/a</td> <td>Learning from actions by interacting with an environment through trial and error and receiving rewards (negative or positive) as feedback.</td> <td>❌</td></tr></tbody>',rt,ge,pt;return J=new w({props:{title:"The pipeline API",local:"the-pipeline-api",headingTag:"h1"}}),j=new _t({props:{$$slots:{default:[Nt]},$$scope:{ctx:me}}}),x=new w({props:{title:"The basics",local:"the-basics",headingTag:"h2"}}),$=new M({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0I=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);`,wrap:!1}}),b=new _t({props:{$$slots:{default:[zt]},$$scope:{ctx:me}}}),I=new M({props:{code:"bGV0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdJJTIwbG92ZSUyMHRyYW5zZm9ybWVycyEnKSUzQiUwQSUyRiUyRiUyMCU1QiU3QidsYWJlbCclM0ElMjAnUE9TSVRJVkUnJTJDJTIwJ3Njb3JlJyUzQSUyMDAuOTk5OCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}]</span>`,wrap:!1}}),Q=new M({props:{code:"bGV0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCU1QidJJTIwbG92ZSUyMHRyYW5zZm9ybWVycyEnJTJDJTIwJ0klMjBoYXRlJTIwdHJhbnNmb3JtZXJzISclNUQpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4JTdEJTJDJTIwJTdCJ2xhYmVsJyUzQSUyMCdORUdBVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTgyJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>([<span class="hljs-string">&#x27;I love transformers!&#x27;</span>, <span class="hljs-string">&#x27;I hate transformers!&#x27;</span>]);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}, {&#x27;label&#x27;: &#x27;NEGATIVE&#x27;, &#x27;score&#x27;: 0.9982}]</span>`,wrap:!1}}),Z=new M({props:{code:"bGV0JTIwcmV2aWV3ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdzZW50aW1lbnQtYW5hbHlzaXMnJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1tdWx0aWxpbmd1YWwtdW5jYXNlZC1zZW50aW1lbnQnKSUzQiUwQSUwQWxldCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwcmV2aWV3ZXIoJ1RoZSUyMFNoYXdzaGFuayUyMFJlZGVtcHRpb24lMjBpcyUyMGElMjB0cnVlJTIwbWFzdGVycGllY2UlMjBvZiUyMGNpbmVtYS4nKSUzQiUwQSUyRiUyRiUyMCU1QiU3QmxhYmVsJTNBJTIwJzUlMjBzdGFycyclMkMlMjBzY29yZSUzQSUyMDAuODE2NzkyOTY0OTM1MzAyNyU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> reviewer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);

<span class="hljs-keyword">let</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">reviewer</span>(<span class="hljs-string">&#x27;The Shawshank Redemption is a true masterpiece of cinema.&#x27;</span>);
<span class="hljs-comment">// [{label: &#x27;5 stars&#x27;, score: 0.8167929649353027}]</span>`,wrap:!1}}),X=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjBBdXRvbWF0aWMlMjBTcGVlY2glMjBSZWNvZ25pdGlvbiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbC5lbicpJTNCJTBBJTBBJTJGJTJGJTIwVHJhbnNjcmliZSUyMGFuJTIwYXVkaW8lMjBmaWxlJTJDJTIwbG9hZGVkJTIwZnJvbSUyMGElMjBVUkwuJTBBbGV0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcignaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYycpJTNCJTBBJTJGJTJGJTIwJTdCdGV4dCUzQSUyMCclMjBJJTIwaGF2ZSUyMGElMjBkcmVhbSUyMHRoYXQlMjBvbmUlMjBkYXklMjB0aGlzJTIwbmF0aW9uJTIwd2lsbCUyMHJpc2UlMjB1cCUyMGFuZCUyMGxpdmUlMjBvdXQlMjB0aGUlMjB0cnVlJTIwbWVhbmluZyUyMG9mJTIwaXRzJTIwY3JlZWQuJyU3RA==",highlighted:`<span class="hljs-comment">// Allocate a pipeline for Automatic Speech Recognition</span>
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small.en&#x27;</span>);

<span class="hljs-comment">// Transcribe an audio file, loaded from a URL.</span>
<span class="hljs-keyword">let</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>);
<span class="hljs-comment">// {text: &#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;}</span>`,wrap:!1}}),Y=new w({props:{title:"Pipeline options",local:"pipeline-options",headingTag:"h2"}}),A=new w({props:{title:"Loading",local:"loading",headingTag:"h3"}}),V=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGlvbiUyMGElMjBwaXBlbGluZSUyMGZvciUyMGZlYXR1cmUlMjBleHRyYWN0aW9uJTJDJTIwdXNpbmclMjB0aGUlMjB1bnF1YW50aXplZCUyMG1vZGVsJTBBY29uc3QlMjBwaXBlJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1YW50aXplZCUzQSUyMGZhbHNlJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-comment">// Allocation a pipeline for feature extraction, using the unquantized model</span>
<span class="hljs-keyword">const</span> pipe = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>, {
    <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span>,
});`,wrap:!1}}),R=new M({props:{code:"bGV0JTIwdHJhbnNjcmliZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJyUyQyUyMCdYZW5vdmElMkZ3aGlzcGVyLXRpbnkuZW4nJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwcmV2aXNpb24lM0ElMjAnb3V0cHV0X2F0dGVudGlvbnMnJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});`,wrap:!1}}),z=new w({props:{title:"Running",local:"running",headingTag:"h3"}}),F=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGlvbiUyMGElMjBwaXBlbGluZSUyMGZvciUyMHRyYW5zbGF0aW9uJTBBbGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBJTBBJTJGJTJGJTIwVHJhbnNsYXRlJTIwZnJvbSUyMEVuZ2xpc2glMjB0byUyMEdyZWVrJTBBbGV0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCdJJTIwbGlrZSUyMHRvJTIwd2FsayUyMG15JTIwZG9nLiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjBzcmNfbGFuZyUzQSUyMCdlbmdfTGF0biclMkMlMEElMjAlMjAlMjAlMjB0Z3RfbGFuZyUzQSUyMCdlbGxfR3JlayclMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTIwJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCclQ0UlOUMlQ0UlQkYlQ0YlODUlMjAlQ0UlQjElQ0YlODElQ0UlQUQlQ0YlODMlQ0UlQjUlQ0UlQjklMjAlQ0UlQkQlQ0UlQjElMjAlQ0YlODAlQ0UlQjUlQ0YlODElQ0YlODAlQ0UlQjElQ0YlODQlQ0UlQUMlQ0YlODklMjAlQ0YlODQlQ0UlQkYlMjAlQ0YlODMlQ0UlQkElQ0YlODUlQ0UlQkIlQ0UlQUYlMjAlQ0UlQkMlQ0UlQkYlQ0YlODUuJyUyMCU3RCUyMCU1RCUwQSUwQSUyRiUyRiUyMFRyYW5zbGF0ZSUyMGJhY2slMjB0byUyMEVuZ2xpc2glMEFsZXQlMjByZXN1bHQyJTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKHJlc3VsdCU1QjAlNUQudHJhbnNsYXRpb25fdGV4dCUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHNyY19sYW5nJTNBJTIwJ2VsbF9HcmVrJyUyQyUwQSUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuZ19MYXRuJyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlMjAlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0klMjBsaWtlJTIwdG8lMjB3YWxrJTIwbXklMjBkb2cuJyUyMCU3RCUyMCU1RA==",highlighted:`<span class="hljs-comment">// Allocation a pipeline for translation</span>
<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);

<span class="hljs-comment">// Translate from English to Greek</span>
<span class="hljs-keyword">let</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;I like to walk my dog.&#x27;</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;Μου αρέσει να περπατάω το σκυλί μου.&#x27; } ]</span>

<span class="hljs-comment">// Translate back to English</span>
<span class="hljs-keyword">let</span> result2 = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(result[<span class="hljs-number">0</span>].<span class="hljs-property">translation_text</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;I like to walk my dog.&#x27; } ]</span>`,wrap:!1}}),D=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0MnRleHQtZ2VuZXJhdGlvbiUwQWxldCUyMHBvZXQlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0MnRleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGTGFNaW5pLUZsYW4tVDUtNzgzTScpJTNCJTBBbGV0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBwb2V0KCdXcml0ZSUyMG1lJTIwYSUyMGxvdmUlMjBwb2VtJTIwYWJvdXQlMjBjaGVlc2UuJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwMjAwJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjklMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0ElMjAyLjAlMkMlMEElMjAlMjAlMjAlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzQSUyMDMlMkMlMEElMEElMjAlMjAlMjAlMjAlMkYlMkYlMjB0b3BfayUzQSUyMDIwJTJDJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwZG9fc2FtcGxlJTNBJTIwdHJ1ZSUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-comment">// Allocate a pipeline for text2text-generation</span>
<span class="hljs-keyword">let</span> poet = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">poet</span>(<span class="hljs-string">&#x27;Write me a love poem about cheese.&#x27;</span>, {
    <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">200</span>,
    <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">2.0</span>,
    <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">3</span>,

    <span class="hljs-comment">// top_k: 20,</span>
    <span class="hljs-comment">// do_sample: true,</span>
});`,wrap:!1}}),q=new M({props:{code:"Q2hlZXNlJTJDJTIwb2glMjBjaGVlc2UhJTIwWW91J3JlJTIwdGhlJTIwcGVyZmVjdCUyMGNvbWZvcnQlMjBmb29kLiUwQVlvdXIlMjB0ZXh0dXJlJTIwc28lMjBzbW9vdGglMjBhbmQlMjBjcmVhbXklMjB5b3UlMjBjYW4lMjBuZXZlciUyMGdldCUyMG9sZC4lMEFXaXRoJTIwZXZlcnklMjBiaXRlJTIwaXQlMjBtZWx0cyUyMGluJTIweW91ciUyMG1vdXRoJTIwbGlrZSUyMGJ1dHRlcnklMjBkZWxpZ2h0cyUwQXRoYXQlMjBtYWtlJTIwbWUlMjBmZWVsJTIwcmlnaHQlMjBhdCUyMGhvbWUlMjB3aXRoJTIwdGhpcyUyMHN3ZWV0JTIwdHJlYXQlMjBvZiUyMG1pbmUuJTIwJTBBJTBBRnJvbSUyMGNsYXNzaWMlMjB0byUyMGJvbGQlMjBmbGF2b3IlMjBjb21iaW5hdGlvbnMlMkMlMEFJJTIwbG92ZSUyMGhvdyUyMHZlcnNhdGlsZSUyMHlvdSUyMGFyZSUyMGFzJTIwYW4lMjBpbmdyZWRpZW50JTIwdG9vJTNGJTBBQ2hlZGRhciUyMGlzJTIwbXklMjBnby10byUyMGZvciUyMGFueSUyMG9jY2FzaW9uJTIwb3IlMjBtb29kJTNCJTIwJTBBSXQlMjBhZGRzJTIwZGVwdGglMjBhbmQlMjByaWNobmVzcyUyMHdpdGhvdXQlMjBiZWluZyUyMG92ZXJwb3dlcmluZyUyMGl0cyUyMHRhc3RlJTIwYnVkcyUyMGFsb25l",highlighted:`Cheese, oh cheese! You&#x27;re <span class="hljs-keyword">the</span> perfect comfort food.
Your texture so smooth <span class="hljs-keyword">and</span> creamy you can never <span class="hljs-keyword">get</span> old.
With <span class="hljs-keyword">every</span> bite <span class="hljs-keyword">it</span> melts <span class="hljs-keyword">in</span> your mouth like buttery delights
<span class="hljs-keyword">that</span> make <span class="hljs-keyword">me</span> feel right <span class="hljs-keyword">at</span> home <span class="hljs-keyword">with</span> this sweet treat <span class="hljs-keyword">of</span> mine. 

From classic <span class="hljs-keyword">to</span> bold flavor combinations,
I love how versatile you are <span class="hljs-keyword">as</span> an ingredient too?
Cheddar <span class="hljs-keyword">is</span> <span class="hljs-keyword">my</span> go-<span class="hljs-keyword">to</span> <span class="hljs-keyword">for</span> any occasion <span class="hljs-keyword">or</span> mood; 
It adds depth <span class="hljs-keyword">and</span> richness <span class="hljs-keyword">without</span> being overpowering <span class="hljs-keyword">its</span> taste buds alone`,wrap:!1}}),ee=new w({props:{title:"Available tasks",local:"available-tasks",headingTag:"h2"}}),te=new w({props:{title:"Tasks",local:"tasks",headingTag:"h3"}}),ae=new w({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h4"}}),le=new w({props:{title:"Vision",local:"vision",headingTag:"h4"}}),ie=new w({props:{title:"Audio",local:"audio",headingTag:"h4"}}),re=new w({props:{title:"Tabular",local:"tabular",headingTag:"h4"}}),de=new w({props:{title:"Multimodal",local:"multimodal",headingTag:"h4"}}),he=new w({props:{title:"Reinforcement Learning",local:"reinforcement-learning",headingTag:"h4"}}),{c(){r=i("meta"),y=l(),u=i("p"),T=l(),p(J.$$.fragment),ue=l(),U=i("p"),U.innerHTML=dt,we=l(),p(j.$$.fragment),ye=l(),p(x.$$.fragment),Me=l(),k=i("p"),k.innerHTML=ct,Te=l(),p($.$$.fragment),je=l(),v=i("p"),v.innerHTML=ht,be=l(),p(b.$$.fragment),Je=l(),G=i("p"),G.textContent=ft,Ue=l(),p(I.$$.fragment),xe=l(),B=i("p"),B.textContent=mt,ke=l(),p(Q.$$.fragment),$e=l(),C=i("p"),C.innerHTML=gt,ve=l(),p(Z.$$.fragment),Ge=l(),W=i("p"),W.innerHTML=ut,Ie=l(),_=i("p"),_.innerHTML=wt,Be=l(),p(X.$$.fragment),Qe=l(),p(Y.$$.fragment),Ce=l(),p(A.$$.fragment),Ze=l(),S=i("p"),S.innerHTML=yt,We=l(),p(V.$$.fragment),_e=l(),H=i("p"),H.innerHTML=Mt,Xe=l(),p(R.$$.fragment),Ye=l(),N=i("p"),N.innerHTML=Tt,Ae=l(),p(z.$$.fragment),Se=l(),E=i("p"),E.textContent=jt,Ve=l(),p(F.$$.fragment),He=l(),L=i("p"),L.innerHTML=bt,Re=l(),P=i("p"),P.innerHTML=Jt,Ne=l(),p(D.$$.fragment),ze=l(),O=i("p"),O.textContent=Ut,Ee=l(),p(q.$$.fragment),Fe=l(),K=i("p"),K.innerHTML=xt,Le=l(),p(ee.$$.fragment),Pe=l(),p(te.$$.fragment),De=l(),p(ae.$$.fragment),Oe=l(),se=i("table"),se.innerHTML=kt,qe=l(),p(le.$$.fragment),Ke=l(),ne=i("table"),ne.innerHTML=$t,et=l(),p(ie.$$.fragment),tt=l(),oe=i("table"),oe.innerHTML=vt,at=l(),p(re.$$.fragment),st=l(),pe=i("table"),pe.innerHTML=Gt,lt=l(),p(de.$$.fragment),nt=l(),ce=i("table"),ce.innerHTML=It,it=l(),p(he.$$.fragment),ot=l(),fe=i("table"),fe.innerHTML=Bt,rt=l(),ge=i("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(a),y=n(e),u=o(e,"P",{}),Zt(u).forEach(a),T=n(e),d(J.$$.fragment,e),ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),g(U)!=="svelte-i79xeb"&&(U.innerHTML=dt),we=n(e),d(j.$$.fragment,e),ye=n(e),d(x.$$.fragment,e),Me=n(e),k=o(e,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1fxrwx6"&&(k.innerHTML=ct),Te=n(e),d($.$$.fragment,e),je=n(e),v=o(e,"P",{"data-svelte-h":!0}),g(v)!=="svelte-q94tv7"&&(v.innerHTML=ht),be=n(e),d(b.$$.fragment,e),Je=n(e),G=o(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1iimk7d"&&(G.textContent=ft),Ue=n(e),d(I.$$.fragment,e),xe=n(e),B=o(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1rl0sgr"&&(B.textContent=mt),ke=n(e),d(Q.$$.fragment,e),$e=n(e),C=o(e,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1ceakdm"&&(C.innerHTML=gt),ve=n(e),d(Z.$$.fragment,e),Ge=n(e),W=o(e,"P",{"data-svelte-h":!0}),g(W)!=="svelte-6d1hww"&&(W.innerHTML=ut),Ie=n(e),_=o(e,"P",{"data-svelte-h":!0}),g(_)!=="svelte-16cwp52"&&(_.innerHTML=wt),Be=n(e),d(X.$$.fragment,e),Qe=n(e),d(Y.$$.fragment,e),Ce=n(e),d(A.$$.fragment,e),Ze=n(e),S=o(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-1fmte3u"&&(S.innerHTML=yt),We=n(e),d(V.$$.fragment,e),_e=n(e),H=o(e,"P",{"data-svelte-h":!0}),g(H)!=="svelte-1ocw6xp"&&(H.innerHTML=Mt),Xe=n(e),d(R.$$.fragment,e),Ye=n(e),N=o(e,"P",{"data-svelte-h":!0}),g(N)!=="svelte-166r3ga"&&(N.innerHTML=Tt),Ae=n(e),d(z.$$.fragment,e),Se=n(e),E=o(e,"P",{"data-svelte-h":!0}),g(E)!=="svelte-1pm722b"&&(E.textContent=jt),Ve=n(e),d(F.$$.fragment,e),He=n(e),L=o(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1ml0f50"&&(L.innerHTML=bt),Re=n(e),P=o(e,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1tl1lis"&&(P.innerHTML=Jt),Ne=n(e),d(D.$$.fragment,e),ze=n(e),O=o(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-1aqxlp5"&&(O.textContent=Ut),Ee=n(e),d(q.$$.fragment,e),Fe=n(e),K=o(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-iq082d"&&(K.innerHTML=xt),Le=n(e),d(ee.$$.fragment,e),Pe=n(e),d(te.$$.fragment,e),De=n(e),d(ae.$$.fragment,e),Oe=n(e),se=o(e,"TABLE",{"data-svelte-h":!0}),g(se)!=="svelte-1cx9utv"&&(se.innerHTML=kt),qe=n(e),d(le.$$.fragment,e),Ke=n(e),ne=o(e,"TABLE",{"data-svelte-h":!0}),g(ne)!=="svelte-4h860n"&&(ne.innerHTML=$t),et=n(e),d(ie.$$.fragment,e),tt=n(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),g(oe)!=="svelte-vw70ih"&&(oe.innerHTML=vt),at=n(e),d(re.$$.fragment,e),st=n(e),pe=o(e,"TABLE",{"data-svelte-h":!0}),g(pe)!=="svelte-1rd81se"&&(pe.innerHTML=Gt),lt=n(e),d(de.$$.fragment,e),nt=n(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),g(ce)!=="svelte-1b6cz3g"&&(ce.innerHTML=It),it=n(e),d(he.$$.fragment,e),ot=n(e),fe=o(e,"TABLE",{"data-svelte-h":!0}),g(fe)!=="svelte-73s5wc"&&(fe.innerHTML=Bt),rt=n(e),ge=o(e,"P",{}),Zt(ge).forEach(a),this.h()},h(){Wt(r,"name","hf:doc:metadata"),Wt(r,"content",Ft)},m(e,t){Rt(document.head,r),s(e,y,t),s(e,u,t),s(e,T,t),c(J,e,t),s(e,ue,t),s(e,U,t),s(e,we,t),c(j,e,t),s(e,ye,t),c(x,e,t),s(e,Me,t),s(e,k,t),s(e,Te,t),c($,e,t),s(e,je,t),s(e,v,t),s(e,be,t),c(b,e,t),s(e,Je,t),s(e,G,t),s(e,Ue,t),c(I,e,t),s(e,xe,t),s(e,B,t),s(e,ke,t),c(Q,e,t),s(e,$e,t),s(e,C,t),s(e,ve,t),c(Z,e,t),s(e,Ge,t),s(e,W,t),s(e,Ie,t),s(e,_,t),s(e,Be,t),c(X,e,t),s(e,Qe,t),c(Y,e,t),s(e,Ce,t),c(A,e,t),s(e,Ze,t),s(e,S,t),s(e,We,t),c(V,e,t),s(e,_e,t),s(e,H,t),s(e,Xe,t),c(R,e,t),s(e,Ye,t),s(e,N,t),s(e,Ae,t),c(z,e,t),s(e,Se,t),s(e,E,t),s(e,Ve,t),c(F,e,t),s(e,He,t),s(e,L,t),s(e,Re,t),s(e,P,t),s(e,Ne,t),c(D,e,t),s(e,ze,t),s(e,O,t),s(e,Ee,t),c(q,e,t),s(e,Fe,t),s(e,K,t),s(e,Le,t),c(ee,e,t),s(e,Pe,t),c(te,e,t),s(e,De,t),c(ae,e,t),s(e,Oe,t),s(e,se,t),s(e,qe,t),c(le,e,t),s(e,Ke,t),s(e,ne,t),s(e,et,t),c(ie,e,t),s(e,tt,t),s(e,oe,t),s(e,at,t),c(re,e,t),s(e,st,t),s(e,pe,t),s(e,lt,t),c(de,e,t),s(e,nt,t),s(e,ce,t),s(e,it,t),c(he,e,t),s(e,ot,t),s(e,fe,t),s(e,rt,t),s(e,ge,t),pt=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),j.$set(Qt);const Ct={};t&2&&(Ct.$$scope={dirty:t,ctx:e}),b.$set(Ct)},i(e){pt||(h(J.$$.fragment,e),h(j.$$.fragment,e),h(x.$$.fragment,e),h($.$$.fragment,e),h(b.$$.fragment,e),h(I.$$.fragment,e),h(Q.$$.fragment,e),h(Z.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(q.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),pt=!0)},o(e){f(J.$$.fragment,e),f(j.$$.fragment,e),f(x.$$.fragment,e),f($.$$.fragment,e),f(b.$$.fragment,e),f(I.$$.fragment,e),f(Q.$$.fragment,e),f(Z.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(D.$$.fragment,e),f(q.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),pt=!1},d(e){e&&(a(y),a(u),a(T),a(ue),a(U),a(we),a(ye),a(Me),a(k),a(Te),a(je),a(v),a(be),a(Je),a(G),a(Ue),a(xe),a(B),a(ke),a($e),a(C),a(ve),a(Ge),a(W),a(Ie),a(_),a(Be),a(Qe),a(Ce),a(Ze),a(S),a(We),a(_e),a(H),a(Xe),a(Ye),a(N),a(Ae),a(Se),a(E),a(Ve),a(He),a(L),a(Re),a(P),a(Ne),a(ze),a(O),a(Ee),a(Fe),a(K),a(Le),a(Pe),a(De),a(Oe),a(se),a(qe),a(Ke),a(ne),a(et),a(tt),a(oe),a(at),a(st),a(pe),a(lt),a(nt),a(ce),a(it),a(ot),a(fe),a(rt),a(ge)),a(r),m(J,e),m(j,e),m(x,e),m($,e),m(b,e),m(I,e),m(Q,e),m(Z,e),m(X,e),m(Y,e),m(A,e),m(V,e),m(R,e),m(z,e),m(F,e),m(D,e),m(q,e),m(ee,e),m(te,e),m(ae,e),m(le,e),m(ie,e),m(re,e),m(de,e),m(he,e)}}}const Ft='{"title":"The pipeline API","local":"the-pipeline-api","sections":[{"title":"The basics","local":"the-basics","sections":[],"depth":2},{"title":"Pipeline options","local":"pipeline-options","sections":[{"title":"Loading","local":"loading","sections":[],"depth":3},{"title":"Running","local":"running","sections":[],"depth":3}],"depth":2},{"title":"Available tasks","local":"available-tasks","sections":[{"title":"Tasks","local":"tasks","sections":[{"title":"Natural Language Processing","local":"natural-language-processing","sections":[],"depth":4},{"title":"Vision","local":"vision","sections":[],"depth":4},{"title":"Audio","local":"audio","sections":[],"depth":4},{"title":"Tabular","local":"tabular","sections":[],"depth":4},{"title":"Multimodal","local":"multimodal","sections":[],"depth":4},{"title":"Reinforcement Learning","local":"reinforcement-learning","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Lt(me){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ea extends St{constructor(r){super(),Vt(this,r,Lt,Et,Yt,{})}}export{ea as component};
