import{s as wa,n as Oa,o as Ja}from"../chunks/scheduler.a2b4ca8e.js";import{S as $a,i as ja,g as r,s as o,r as c,A as Ca,h as s,f as t,c as l,j as v,u as g,x as p,k as b,y as n,a as i,v as h,d as u,t as _,w as f}from"../chunks/index.f6e1d51d.js";import{D as M}from"../chunks/Docstring.e7c4afb2.js";import{C as Wt}from"../chunks/CodeBlock.9607aa3b.js";import{H as ue,E as xa}from"../chunks/EditOnGithub.d27dc01b.js";function Ia(St){let J,qe,Re,Ee,A,Be,N,Vt='<a href="https://arxiv.org/abs/2403.07691" rel="nofollow">Odds Ratio Preference Optimization</a> (ORPO) by Jiwoo Hong, Noah Lee, and James Thorne studies the crucial role of SFT within the context of preference alignment. Using preference data the method posits that a minor penalty for the disfavored generation together with a strong adaption signal to the chosen response via a simple log odds ratio term appended to the NLL loss is sufficient for preference-aligned SFT.',Le,R,Yt="Thus ORPO is a reference model-free preference optimization algorithm eliminating the necessity for an additional preference alignment phase thus saving compute and memory.",ze,F,Qt='The official code can be found <a href="https://github.com/xfactlab/orpo" rel="nofollow">xfactlab/orpo</a>.',De,q,He,E,Xt="The ORPO trainer expects a format identical to the DPO trainer, which should include three entries. These entries should be named as follows:",Ge,B,Zt="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",We,L,Kt="for example:",Se,z,Ve,D,ea="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. Note that a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Ye,H,Qe,G,ta="The ORPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Xe,W,Ze,S,aa="For a detailed example have a look at the <code>examples/scripts/orpo.py</code> script. At a high level we need to initialize the <code>ORPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that ORPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong> The <code>beta</code> refers to the hyperparameter <code>lambda</code> in eq. (6) of the paper and refers to the weighting of the relative odd ratio loss in the standard cross-entropy loss used for SFT.",Ke,V,et,Y,na="After this one can then call:",tt,Q,at,X,nt,Z,oa="While training and evaluating we record the following reward metrics:",ot,K,la="<li><p><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</p></li> <li><p><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</p></li> <li><p><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</p></li> <li><p><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</p></li> <li><p><code>log_odds_chosen</code>: the mean log odds ratio of the chosen responses over the rejected responses</p></li> <li><p><code>log_odds_ratio</code>: the mean of the <code>log(sigmoid(log_odds_chosen))</code></p></li> <li><p><code>nll_loss</code>: the mean negative log likelihood loss from the SFT part of the loss over chosen responses</p></li>",lt,ee,rt,d,te,bt,_e,ra="Initialize ORPOTrainer.",Tt,$,ae,Mt,fe,sa=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,yt,w,ne,wt,ve,ia="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ot,be,da="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Jt,j,oe,$t,Te,pa="Concatenate the chosen and rejected inputs into a single tensor.",jt,O,le,Ct,Me,ma=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,xt,ye,ca="Works both with or without labels.",It,C,re,Ut,we,ga="Compute the log probabilities of the given labels under the given logits.",Pt,x,se,kt,Oe,ha="Compute the ORPO loss and other metrics for the given batch of inputs for train or test.",At,I,ie,Nt,Je,ua="Generate samples from the model and reference model for the given batch of inputs.",Rt,U,de,Ft,$e,_a="Log <code>logs</code> on the various objects watching training, including stored metrics.",qt,P,pe,Et,je,fa="Compute ORPO’s odds ratio (OR) loss for a batch of policy and reference model log probabilities.",Bt,T,me,Lt,Ce,va="Tokenize a single row from a ORPO specific dataset.",zt,xe,ba=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Dt,Ie,Ta=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,st,ce,it,y,ge,Ht,Ue,Ma='ORPOConfig collects all training arguments related to the <a href="/docs/trl/main/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a> class.',Gt,Pe,ya=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,dt,he,pt,Fe,mt;return A=new ue({props:{title:"ORPO Trainer",local:"orpo-trainer",headingTag:"h1"}}),q=new ue({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),z=new Wt({props:{code:"b3Jwb19kYXRhc2V0X2RpY3QlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWxsbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhvdyUyMGFyZSUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHlvdXIlMjBuYW1lJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGljaCUyMGlzJTIwdGhlJTIwYmVzdCUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGljaCUyMGlzJTIwdGhlJTIwYmVzdCUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGljaCUyMGlzJTIwdGhlJTIwYmVzdCUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBNYXJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBNYXJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGVhdmUlMjBtZSUyMGFsb25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGFtJTIwbm90JTIwZmluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXRzJTIwaXQlMjB0byUyMHlvdSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBkb250JTIwaGF2ZSUyMGElMjBuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YXNjcmlwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdE",highlighted:`orpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),H=new ue({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),W=new ue({props:{title:"Using the ORPOTrainer",local:"using-the-orpotrainer",headingTag:"h2"}}),V=new Wt({props:{code:"b3Jwb19jb25maWclMjAlM0QlMjBPUlBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJldGElM0QwLjElMkMlMjAlMjMlMjB0aGUlMjBsYW1iZGElMkZhbHBoYSUyMGh5cGVycGFyYW1ldGVyJTIwaW4lMjB0aGUlMjBwYXBlciUyRmNvZGUlMEEpJTBBJTBBb3Jwb190cmFpbmVyJTIwJTNEJTIwT1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEb3Jwb19jb25maWclMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSk=",highlighted:`orpo_config = ORPOConfig(
    beta=<span class="hljs-number">0.1</span>, <span class="hljs-comment"># the lambda/alpha hyperparameter in the paper/code</span>
)

orpo_trainer = ORPOTrainer(
    model,
    args=orpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Q=new Wt({props:{code:"b3Jwb190cmFpbmVyLnRyYWluKCk=",highlighted:"orpo_trainer.train()",wrap:!1}}),X=new ue({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ee=new ue({props:{title:"ORPOTrainer",local:"trl.ORPOTrainer",headingTag:"h2"}}),te=new M({props:{name:"class trl.ORPOTrainer",anchor:"trl.ORPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.ORPOTrainer.args",description:`<strong>args</strong> (<code>ORPOConfig</code>) &#x2014;
The ORPO config arguments to use for training.`,name:"args"},{anchor:"trl.ORPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.ORPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.ORPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.ORPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.ORPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.ORPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.ORPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.ORPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.ORPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.ORPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L62"}}),ae=new M({props:{name:"build_tokenized_answer",anchor:"trl.ORPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L334"}}),ne=new M({props:{name:"concatenated_forward",anchor:"trl.ORPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L667"}}),oe=new M({props:{name:"concatenated_inputs",anchor:"trl.ORPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L535",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),le=new M({props:{name:"evaluation_loop",anchor:"trl.ORPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L867"}}),re=new M({props:{name:"get_batch_logps",anchor:"trl.ORPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L629",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),se=new M({props:{name:"get_batch_loss_metrics",anchor:"trl.ORPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L738"}}),ie=new M({props:{name:"get_batch_samples",anchor:"trl.ORPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L802"}}),de=new M({props:{name:"log",anchor:"trl.ORPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.ORPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L915"}}),pe=new M({props:{name:"odds_ratio_loss",anchor:"trl.ORPOTrainer.odds_ratio_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L597",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the ORPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The log odds ratio of the chosen responses over the rejected responses ratio for logging purposes.
The <code>log(sigmoid(log_odds_chosen))</code> for logging purposes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),me=new M({props:{name:"tokenize_row",anchor:"trl.ORPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_trainer.py#L384"}}),ce=new ue({props:{title:"ORPOConfig",local:"trl.ORPOConfig",headingTag:"h2"}}),ge=new M({props:{name:"class trl.ORPOConfig",anchor:"trl.ORPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.ORPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.ORPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the completions. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.ORPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in ORPO loss (lambda/alpha in paper/code) that is the weight of the relative loss ratio in the SFT loss.`,name:"beta"},{anchor:"trl.ORPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.ORPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.ORPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.ORPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.ORPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.ORPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.ORPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.ORPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/orpo_config.py#L20"}}),he=new xa({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/orpo_trainer.md"}}),{c(){J=r("meta"),qe=o(),Re=r("p"),Ee=o(),c(A.$$.fragment),Be=o(),N=r("p"),N.innerHTML=Vt,Le=o(),R=r("p"),R.textContent=Yt,ze=o(),F=r("p"),F.innerHTML=Qt,De=o(),c(q.$$.fragment),He=o(),E=r("p"),E.textContent=Xt,Ge=o(),B=r("ul"),B.innerHTML=Zt,We=o(),L=r("p"),L.textContent=Kt,Se=o(),c(z.$$.fragment),Ve=o(),D=r("p"),D.innerHTML=ea,Ye=o(),c(H.$$.fragment),Qe=o(),G=r("p"),G.innerHTML=ta,Xe=o(),c(W.$$.fragment),Ze=o(),S=r("p"),S.innerHTML=aa,Ke=o(),c(V.$$.fragment),et=o(),Y=r("p"),Y.textContent=na,tt=o(),c(Q.$$.fragment),at=o(),c(X.$$.fragment),nt=o(),Z=r("p"),Z.textContent=oa,ot=o(),K=r("ul"),K.innerHTML=la,lt=o(),c(ee.$$.fragment),rt=o(),d=r("div"),c(te.$$.fragment),bt=o(),_e=r("p"),_e.textContent=ra,Tt=o(),$=r("div"),c(ae.$$.fragment),Mt=o(),fe=r("p"),fe.innerHTML=sa,yt=o(),w=r("div"),c(ne.$$.fragment),wt=o(),ve=r("p"),ve.textContent=ia,Ot=o(),be=r("p"),be.textContent=da,Jt=o(),j=r("div"),c(oe.$$.fragment),$t=o(),Te=r("p"),Te.textContent=pa,jt=o(),O=r("div"),c(le.$$.fragment),Ct=o(),Me=r("p"),Me.innerHTML=ma,xt=o(),ye=r("p"),ye.textContent=ca,It=o(),C=r("div"),c(re.$$.fragment),Ut=o(),we=r("p"),we.textContent=ga,Pt=o(),x=r("div"),c(se.$$.fragment),kt=o(),Oe=r("p"),Oe.textContent=ha,At=o(),I=r("div"),c(ie.$$.fragment),Nt=o(),Je=r("p"),Je.textContent=ua,Rt=o(),U=r("div"),c(de.$$.fragment),Ft=o(),$e=r("p"),$e.innerHTML=_a,qt=o(),P=r("div"),c(pe.$$.fragment),Et=o(),je=r("p"),je.textContent=fa,Bt=o(),T=r("div"),c(me.$$.fragment),Lt=o(),Ce=r("p"),Ce.textContent=va,zt=o(),xe=r("p"),xe.textContent=ba,Dt=o(),Ie=r("p"),Ie.textContent=Ta,st=o(),c(ce.$$.fragment),it=o(),y=r("div"),c(ge.$$.fragment),Ht=o(),Ue=r("p"),Ue.innerHTML=Ma,Gt=o(),Pe=r("p"),Pe.innerHTML=ya,dt=o(),c(he.$$.fragment),pt=o(),Fe=r("p"),this.h()},l(e){const a=Ca("svelte-u9bgzb",document.head);J=s(a,"META",{name:!0,content:!0}),a.forEach(t),qe=l(e),Re=s(e,"P",{}),v(Re).forEach(t),Ee=l(e),g(A.$$.fragment,e),Be=l(e),N=s(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-yhecos"&&(N.innerHTML=Vt),Le=l(e),R=s(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-14fu8cb"&&(R.textContent=Yt),ze=l(e),F=s(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-awkpkf"&&(F.innerHTML=Qt),De=l(e),g(q.$$.fragment,e),He=l(e),E=s(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1i2ldsp"&&(E.textContent=Xt),Ge=l(e),B=s(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-17vxuta"&&(B.innerHTML=Zt),We=l(e),L=s(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1gl9mvz"&&(L.textContent=Kt),Se=l(e),g(z.$$.fragment,e),Ve=l(e),D=s(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-74izzd"&&(D.innerHTML=ea),Ye=l(e),g(H.$$.fragment,e),Qe=l(e),G=s(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-s4moud"&&(G.innerHTML=ta),Xe=l(e),g(W.$$.fragment,e),Ze=l(e),S=s(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ec97r1"&&(S.innerHTML=aa),Ke=l(e),g(V.$$.fragment,e),et=l(e),Y=s(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1lg6q1l"&&(Y.textContent=na),tt=l(e),g(Q.$$.fragment,e),at=l(e),g(X.$$.fragment,e),nt=l(e),Z=s(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-132s7j9"&&(Z.textContent=oa),ot=l(e),K=s(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-m19ud7"&&(K.innerHTML=la),lt=l(e),g(ee.$$.fragment,e),rt=l(e),d=s(e,"DIV",{class:!0});var m=v(d);g(te.$$.fragment,m),bt=l(m),_e=s(m,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1ggwo37"&&(_e.textContent=ra),Tt=l(m),$=s(m,"DIV",{class:!0});var ct=v($);g(ae.$$.fragment,ct),Mt=l(ct),fe=s(ct,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-mcz8nm"&&(fe.innerHTML=sa),ct.forEach(t),yt=l(m),w=s(m,"DIV",{class:!0});var ke=v(w);g(ne.$$.fragment,ke),wt=l(ke),ve=s(ke,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-16i1nac"&&(ve.textContent=ia),Ot=l(ke),be=s(ke,"P",{"data-svelte-h":!0}),p(be)!=="svelte-tgti68"&&(be.textContent=da),ke.forEach(t),Jt=l(m),j=s(m,"DIV",{class:!0});var gt=v(j);g(oe.$$.fragment,gt),$t=l(gt),Te=s(gt,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1cvsgkk"&&(Te.textContent=pa),gt.forEach(t),jt=l(m),O=s(m,"DIV",{class:!0});var Ae=v(O);g(le.$$.fragment,Ae),Ct=l(Ae),Me=s(Ae,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-8qlty5"&&(Me.innerHTML=ma),xt=l(Ae),ye=s(Ae,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1tyo99t"&&(ye.textContent=ca),Ae.forEach(t),It=l(m),C=s(m,"DIV",{class:!0});var ht=v(C);g(re.$$.fragment,ht),Ut=l(ht),we=s(ht,"P",{"data-svelte-h":!0}),p(we)!=="svelte-4nmimv"&&(we.textContent=ga),ht.forEach(t),Pt=l(m),x=s(m,"DIV",{class:!0});var ut=v(x);g(se.$$.fragment,ut),kt=l(ut),Oe=s(ut,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-ndgk7s"&&(Oe.textContent=ha),ut.forEach(t),At=l(m),I=s(m,"DIV",{class:!0});var _t=v(I);g(ie.$$.fragment,_t),Nt=l(_t),Je=s(_t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-18uwvbi"&&(Je.textContent=ua),_t.forEach(t),Rt=l(m),U=s(m,"DIV",{class:!0});var ft=v(U);g(de.$$.fragment,ft),Ft=l(ft),$e=s(ft,"P",{"data-svelte-h":!0}),p($e)!=="svelte-nqksfz"&&($e.innerHTML=_a),ft.forEach(t),qt=l(m),P=s(m,"DIV",{class:!0});var vt=v(P);g(pe.$$.fragment,vt),Et=l(vt),je=s(vt,"P",{"data-svelte-h":!0}),p(je)!=="svelte-y2dr0o"&&(je.textContent=fa),vt.forEach(t),Bt=l(m),T=s(m,"DIV",{class:!0});var k=v(T);g(me.$$.fragment,k),Lt=l(k),Ce=s(k,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-xlsvih"&&(Ce.textContent=va),zt=l(k),xe=s(k,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1mn1gnw"&&(xe.textContent=ba),Dt=l(k),Ie=s(k,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1xvpyih"&&(Ie.textContent=Ta),k.forEach(t),m.forEach(t),st=l(e),g(ce.$$.fragment,e),it=l(e),y=s(e,"DIV",{class:!0});var Ne=v(y);g(ge.$$.fragment,Ne),Ht=l(Ne),Ue=s(Ne,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-t2n6nv"&&(Ue.innerHTML=Ma),Gt=l(Ne),Pe=s(Ne,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1xl7jqc"&&(Pe.innerHTML=ya),Ne.forEach(t),dt=l(e),g(he.$$.fragment,e),pt=l(e),Fe=s(e,"P",{}),v(Fe).forEach(t),this.h()},h(){b(J,"name","hf:doc:metadata"),b(J,"content",Ua),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,J),i(e,qe,a),i(e,Re,a),i(e,Ee,a),h(A,e,a),i(e,Be,a),i(e,N,a),i(e,Le,a),i(e,R,a),i(e,ze,a),i(e,F,a),i(e,De,a),h(q,e,a),i(e,He,a),i(e,E,a),i(e,Ge,a),i(e,B,a),i(e,We,a),i(e,L,a),i(e,Se,a),h(z,e,a),i(e,Ve,a),i(e,D,a),i(e,Ye,a),h(H,e,a),i(e,Qe,a),i(e,G,a),i(e,Xe,a),h(W,e,a),i(e,Ze,a),i(e,S,a),i(e,Ke,a),h(V,e,a),i(e,et,a),i(e,Y,a),i(e,tt,a),h(Q,e,a),i(e,at,a),h(X,e,a),i(e,nt,a),i(e,Z,a),i(e,ot,a),i(e,K,a),i(e,lt,a),h(ee,e,a),i(e,rt,a),i(e,d,a),h(te,d,null),n(d,bt),n(d,_e),n(d,Tt),n(d,$),h(ae,$,null),n($,Mt),n($,fe),n(d,yt),n(d,w),h(ne,w,null),n(w,wt),n(w,ve),n(w,Ot),n(w,be),n(d,Jt),n(d,j),h(oe,j,null),n(j,$t),n(j,Te),n(d,jt),n(d,O),h(le,O,null),n(O,Ct),n(O,Me),n(O,xt),n(O,ye),n(d,It),n(d,C),h(re,C,null),n(C,Ut),n(C,we),n(d,Pt),n(d,x),h(se,x,null),n(x,kt),n(x,Oe),n(d,At),n(d,I),h(ie,I,null),n(I,Nt),n(I,Je),n(d,Rt),n(d,U),h(de,U,null),n(U,Ft),n(U,$e),n(d,qt),n(d,P),h(pe,P,null),n(P,Et),n(P,je),n(d,Bt),n(d,T),h(me,T,null),n(T,Lt),n(T,Ce),n(T,zt),n(T,xe),n(T,Dt),n(T,Ie),i(e,st,a),h(ce,e,a),i(e,it,a),i(e,y,a),h(ge,y,null),n(y,Ht),n(y,Ue),n(y,Gt),n(y,Pe),i(e,dt,a),h(he,e,a),i(e,pt,a),i(e,Fe,a),mt=!0},p:Oa,i(e){mt||(u(A.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(X.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),mt=!0)},o(e){_(A.$$.fragment,e),_(q.$$.fragment,e),_(z.$$.fragment,e),_(H.$$.fragment,e),_(W.$$.fragment,e),_(V.$$.fragment,e),_(Q.$$.fragment,e),_(X.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(ce.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),mt=!1},d(e){e&&(t(qe),t(Re),t(Ee),t(Be),t(N),t(Le),t(R),t(ze),t(F),t(De),t(He),t(E),t(Ge),t(B),t(We),t(L),t(Se),t(Ve),t(D),t(Ye),t(Qe),t(G),t(Xe),t(Ze),t(S),t(Ke),t(et),t(Y),t(tt),t(at),t(nt),t(Z),t(ot),t(K),t(lt),t(rt),t(d),t(st),t(it),t(y),t(dt),t(pt),t(Fe)),t(J),f(A,e),f(q,e),f(z,e),f(H,e),f(W,e),f(V,e),f(Q,e),f(X,e),f(ee,e),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(se),f(ie),f(de),f(pe),f(me),f(ce,e),f(ge),f(he,e)}}}const Ua='{"title":"ORPO Trainer","local":"orpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the ORPOTrainer","local":"using-the-orpotrainer","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"ORPOTrainer","local":"trl.ORPOTrainer","sections":[],"depth":2},{"title":"ORPOConfig","local":"trl.ORPOConfig","sections":[],"depth":2}],"depth":1}';function Pa(St){return Ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends $a{constructor(J){super(),ja(this,J,Pa,Ia,wa,{})}}export{qa as component};
