import{s as Aa,n as Na,o as qa}from"../chunks/scheduler.a2b4ca8e.js";import{S as Fa,i as Ea,g as i,s as n,r as p,A as La,h as s,f as t,c as o,j as v,u as h,x as d,k as b,y as l,a as r,v as g,d as u,t as _,w as f}from"../chunks/index.f6e1d51d.js";import{D as C}from"../chunks/Docstring.e7c4afb2.js";import{C as ea}from"../chunks/CodeBlock.9607aa3b.js";import{H as A,E as za}from"../chunks/EditOnGithub.d27dc01b.js";function Da(ta){let $,Be,ze,He,N,We,q,aa=`Contrastive Preference Optimization (CPO) as introduced in the paper <a href="https://huggingface.co/papers/2401.08417" rel="nofollow">Contrastive Preference Optimization: Pushing the Boundaries of LLM Performance in Machine Translation</a> by Haoran Xu, Amr Sharaf, Yunmo Chen, Weiting Tan, Lingfeng Shen, Benjamin Van Durme, Kenton Murray, and Young Jin Kim. At a high-level, CPO  trains models to
avoid generating adequate, but not perfect translations in Machine Translation (MT) tasks. However, CPO is a general approximation to the DPO loss and can be applied to other domains like chat.`,Se,F,na="CPO aims to mitigate two fundamental shortcomings of SFT. First, SFT’s methodology of minimizing the discrepancy between predicted outputs and gold-standard references inherently caps model performance at the quality level of the training data. Secondly, SFT lacks a mechanism to prevent the model from rejecting mistakes in translations. The CPO objective is derived from the DPO objective.",Qe,E,Ze,L,oa="The CPO trainer expects a format identical to the DPO trainer, which should include three entries. These entries should be named as follows:",Re,z,la="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Xe,D,ra="for example:",Ge,B,Ve,H,ia="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Ye,W,Ke,S,sa="The CPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",et,Q,tt,Z,da="For a detailed example have a look at the <code>examples/scripts/cpo.py</code> script. At a high level we need to initialize the <code>CPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that CPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong> The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above.",at,R,nt,X,ca="After this one can then call:",ot,G,lt,V,rt,Y,ma="Given the preference data, the <code>CPOTrainer</code> uses the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",it,K,pa='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>CPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',st,ee,ha='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the CPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike CPO which is summed only).',dt,te,ga='The <a href="https://arxiv.org/abs/2405.14734" rel="nofollow">SimPO</a> is an alternative loss that adds a reward margin, allows for length normalization, and does not use BC regularization. To use this loss, we can use SimPO easily by turning on<code>loss_type=&quot;simpo&quot;</code> in the <code>CPOConfig</code>.',ct,ae,mt,ne,ua="While training and evaluating we record the following reward metrics:",pt,oe,_a="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>nll_loss</code>: the mean negative log likelihood loss of the policy model for the chosen responses</li>",ht,le,gt,c,re,Ut,Me,fa="Initialize CPOTrainer.",xt,j,ie,Ot,Ce,va=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Pt,T,se,Jt,ye,ba="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",It,Te,Ma="We do this to avoid doing two forward passes, because it’s faster for FSDP.",kt,U,de,At,we,Ca="Concatenate the chosen and rejected inputs into a single tensor.",Nt,x,ce,qt,$e,ya="Compute the CPO loss for a batch of policy and reference model log probabilities.",Ft,w,me,Et,je,Ta=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Lt,Ue,wa="Works both with or without labels.",zt,O,pe,Dt,xe,$a="Compute the log probabilities of the given labels under the given logits.",Bt,P,he,Ht,Oe,ja="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",Wt,J,ge,St,Pe,Ua="Generate samples from the model and reference model for the given batch of inputs.",Qt,I,ue,Zt,Je,xa="Log <code>logs</code> on the various objects watching training, including stored metrics.",Rt,M,_e,Xt,Ie,Oa="Tokenize a single row from a CPO specific dataset.",Gt,ke,Pa=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Vt,Ae,Ja=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,ut,fe,_t,y,ve,Yt,Ne,Ia='CPOConfig collects all training arguments related to the <a href="/docs/trl/main/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a> class.',Kt,qe,ka=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ft,be,vt,De,bt;return N=new A({props:{title:"CPO Trainer",local:"cpo-trainer",headingTag:"h1"}}),E=new A({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),B=new ea({props:{code:"Y3BvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`cpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),W=new A({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),Q=new A({props:{title:"Using the CPOTrainer",local:"using-the-cpotrainer",headingTag:"h2"}}),R=new ea({props:{code:"Y3BvX2NvbmZpZyUyMCUzRCUyMENQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWNwb190cmFpbmVyJTIwJTNEJTIwQ1BPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RjcG9fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`cpo_config = CPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

cpo_trainer = CPOTrainer(
    model,
    args=cpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),G=new ea({props:{code:"Y3BvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"cpo_trainer.train()",wrap:!1}}),V=new A({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),ae=new A({props:{title:"Logging",local:"logging",headingTag:"h2"}}),le=new A({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),re=new C({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L55"}}),ie=new C({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L307"}}),se=new C({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L659"}}),de=new C({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L508",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),ce=new C({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L570",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),me=new C({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L855"}}),pe=new C({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L621",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),he=new C({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L728"}}),ge=new C({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L790"}}),ue=new C({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L903"}}),_e=new C({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L357"}}),fe=new A({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),ve=new C({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"simpo_gamma",val:": float = 0.5"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in CPO loss.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>sigmoid</code>) &#x2014;
The type of loss to use. This argument is required if you want to use the default data collator.`,name:"loss_type"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.simpo_gamma",description:`<strong>simpo_gamma</strong> (<code>float</code>, defaults to <code>0.5</code>) &#x2014;
A target reward margin for the SimPO loss, used only when the &#x201C;simpo&#x201D; option is enabled.`,name:"simpo_gamma"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_config.py#L20"}}),be=new za({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/cpo_trainer.mdx"}}),{c(){$=i("meta"),Be=n(),ze=i("p"),He=n(),p(N.$$.fragment),We=n(),q=i("p"),q.innerHTML=aa,Se=n(),F=i("p"),F.textContent=na,Qe=n(),p(E.$$.fragment),Ze=n(),L=i("p"),L.textContent=oa,Re=n(),z=i("ul"),z.innerHTML=la,Xe=n(),D=i("p"),D.textContent=ra,Ge=n(),p(B.$$.fragment),Ve=n(),H=i("p"),H.innerHTML=ia,Ye=n(),p(W.$$.fragment),Ke=n(),S=i("p"),S.innerHTML=sa,et=n(),p(Q.$$.fragment),tt=n(),Z=i("p"),Z.innerHTML=da,at=n(),p(R.$$.fragment),nt=n(),X=i("p"),X.textContent=ca,ot=n(),p(G.$$.fragment),lt=n(),p(V.$$.fragment),rt=n(),Y=i("p"),Y.innerHTML=ma,it=n(),K=i("p"),K.innerHTML=pa,st=n(),ee=i("p"),ee.innerHTML=ha,dt=n(),te=i("p"),te.innerHTML=ga,ct=n(),p(ae.$$.fragment),mt=n(),ne=i("p"),ne.textContent=ua,pt=n(),oe=i("ul"),oe.innerHTML=_a,ht=n(),p(le.$$.fragment),gt=n(),c=i("div"),p(re.$$.fragment),Ut=n(),Me=i("p"),Me.textContent=fa,xt=n(),j=i("div"),p(ie.$$.fragment),Ot=n(),Ce=i("p"),Ce.innerHTML=va,Pt=n(),T=i("div"),p(se.$$.fragment),Jt=n(),ye=i("p"),ye.textContent=ba,It=n(),Te=i("p"),Te.textContent=Ma,kt=n(),U=i("div"),p(de.$$.fragment),At=n(),we=i("p"),we.textContent=Ca,Nt=n(),x=i("div"),p(ce.$$.fragment),qt=n(),$e=i("p"),$e.textContent=ya,Ft=n(),w=i("div"),p(me.$$.fragment),Et=n(),je=i("p"),je.innerHTML=Ta,Lt=n(),Ue=i("p"),Ue.textContent=wa,zt=n(),O=i("div"),p(pe.$$.fragment),Dt=n(),xe=i("p"),xe.textContent=$a,Bt=n(),P=i("div"),p(he.$$.fragment),Ht=n(),Oe=i("p"),Oe.textContent=ja,Wt=n(),J=i("div"),p(ge.$$.fragment),St=n(),Pe=i("p"),Pe.textContent=Ua,Qt=n(),I=i("div"),p(ue.$$.fragment),Zt=n(),Je=i("p"),Je.innerHTML=xa,Rt=n(),M=i("div"),p(_e.$$.fragment),Xt=n(),Ie=i("p"),Ie.textContent=Oa,Gt=n(),ke=i("p"),ke.textContent=Pa,Vt=n(),Ae=i("p"),Ae.textContent=Ja,ut=n(),p(fe.$$.fragment),_t=n(),y=i("div"),p(ve.$$.fragment),Yt=n(),Ne=i("p"),Ne.innerHTML=Ia,Kt=n(),qe=i("p"),qe.innerHTML=ka,ft=n(),p(be.$$.fragment),vt=n(),De=i("p"),this.h()},l(e){const a=La("svelte-u9bgzb",document.head);$=s(a,"META",{name:!0,content:!0}),a.forEach(t),Be=o(e),ze=s(e,"P",{}),v(ze).forEach(t),He=o(e),h(N.$$.fragment,e),We=o(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1grcdr2"&&(q.innerHTML=aa),Se=o(e),F=s(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-10wbspk"&&(F.textContent=na),Qe=o(e),h(E.$$.fragment,e),Ze=o(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1t3enyx"&&(L.textContent=oa),Re=o(e),z=s(e,"UL",{"data-svelte-h":!0}),d(z)!=="svelte-17vxuta"&&(z.innerHTML=la),Xe=o(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1gl9mvz"&&(D.textContent=ra),Ge=o(e),h(B.$$.fragment,e),Ve=o(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1a8oxjk"&&(H.innerHTML=ia),Ye=o(e),h(W.$$.fragment,e),Ke=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-187gqrp"&&(S.innerHTML=sa),et=o(e),h(Q.$$.fragment,e),tt=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1mkccty"&&(Z.innerHTML=da),at=o(e),h(R.$$.fragment,e),nt=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1lg6q1l"&&(X.textContent=ca),ot=o(e),h(G.$$.fragment,e),lt=o(e),h(V.$$.fragment,e),rt=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1nbvuj3"&&(Y.innerHTML=ma),it=o(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-v1u5f4"&&(K.innerHTML=pa),st=o(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-j24bt8"&&(ee.innerHTML=ha),dt=o(e),te=s(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1n1kqd3"&&(te.innerHTML=ga),ct=o(e),h(ae.$$.fragment,e),mt=o(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-132s7j9"&&(ne.textContent=ua),pt=o(e),oe=s(e,"UL",{"data-svelte-h":!0}),d(oe)!=="svelte-yjg2sp"&&(oe.innerHTML=_a),ht=o(e),h(le.$$.fragment,e),gt=o(e),c=s(e,"DIV",{class:!0});var m=v(c);h(re.$$.fragment,m),Ut=o(m),Me=s(m,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1qqtmoh"&&(Me.textContent=fa),xt=o(m),j=s(m,"DIV",{class:!0});var Mt=v(j);h(ie.$$.fragment,Mt),Ot=o(Mt),Ce=s(Mt,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-mcz8nm"&&(Ce.innerHTML=va),Mt.forEach(t),Pt=o(m),T=s(m,"DIV",{class:!0});var Fe=v(T);h(se.$$.fragment,Fe),Jt=o(Fe),ye=s(Fe,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-16i1nac"&&(ye.textContent=ba),It=o(Fe),Te=s(Fe,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-tgti68"&&(Te.textContent=Ma),Fe.forEach(t),kt=o(m),U=s(m,"DIV",{class:!0});var Ct=v(U);h(de.$$.fragment,Ct),At=o(Ct),we=s(Ct,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1cvsgkk"&&(we.textContent=Ca),Ct.forEach(t),Nt=o(m),x=s(m,"DIV",{class:!0});var yt=v(x);h(ce.$$.fragment,yt),qt=o(yt),$e=s(yt,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1l2rxe2"&&($e.textContent=ya),yt.forEach(t),Ft=o(m),w=s(m,"DIV",{class:!0});var Ee=v(w);h(me.$$.fragment,Ee),Et=o(Ee),je=s(Ee,"P",{"data-svelte-h":!0}),d(je)!=="svelte-8qlty5"&&(je.innerHTML=Ta),Lt=o(Ee),Ue=s(Ee,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1tyo99t"&&(Ue.textContent=wa),Ee.forEach(t),zt=o(m),O=s(m,"DIV",{class:!0});var Tt=v(O);h(pe.$$.fragment,Tt),Dt=o(Tt),xe=s(Tt,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-4nmimv"&&(xe.textContent=$a),Tt.forEach(t),Bt=o(m),P=s(m,"DIV",{class:!0});var wt=v(P);h(he.$$.fragment,wt),Ht=o(wt),Oe=s(wt,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-4kzfyw"&&(Oe.textContent=ja),wt.forEach(t),Wt=o(m),J=s(m,"DIV",{class:!0});var $t=v(J);h(ge.$$.fragment,$t),St=o($t),Pe=s($t,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-18uwvbi"&&(Pe.textContent=Ua),$t.forEach(t),Qt=o(m),I=s(m,"DIV",{class:!0});var jt=v(I);h(ue.$$.fragment,jt),Zt=o(jt),Je=s(jt,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-nqksfz"&&(Je.innerHTML=xa),jt.forEach(t),Rt=o(m),M=s(m,"DIV",{class:!0});var k=v(M);h(_e.$$.fragment,k),Xt=o(k),Ie=s(k,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1a53vwp"&&(Ie.textContent=Oa),Gt=o(k),ke=s(k,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1mn1gnw"&&(ke.textContent=Pa),Vt=o(k),Ae=s(k,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1xvpyih"&&(Ae.textContent=Ja),k.forEach(t),m.forEach(t),ut=o(e),h(fe.$$.fragment,e),_t=o(e),y=s(e,"DIV",{class:!0});var Le=v(y);h(ve.$$.fragment,Le),Yt=o(Le),Ne=s(Le,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1r4c2kx"&&(Ne.innerHTML=Ia),Kt=o(Le),qe=s(Le,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1xl7jqc"&&(qe.innerHTML=ka),Le.forEach(t),ft=o(e),h(be.$$.fragment,e),vt=o(e),De=s(e,"P",{}),v(De).forEach(t),this.h()},h(){b($,"name","hf:doc:metadata"),b($,"content",Ba),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){l(document.head,$),r(e,Be,a),r(e,ze,a),r(e,He,a),g(N,e,a),r(e,We,a),r(e,q,a),r(e,Se,a),r(e,F,a),r(e,Qe,a),g(E,e,a),r(e,Ze,a),r(e,L,a),r(e,Re,a),r(e,z,a),r(e,Xe,a),r(e,D,a),r(e,Ge,a),g(B,e,a),r(e,Ve,a),r(e,H,a),r(e,Ye,a),g(W,e,a),r(e,Ke,a),r(e,S,a),r(e,et,a),g(Q,e,a),r(e,tt,a),r(e,Z,a),r(e,at,a),g(R,e,a),r(e,nt,a),r(e,X,a),r(e,ot,a),g(G,e,a),r(e,lt,a),g(V,e,a),r(e,rt,a),r(e,Y,a),r(e,it,a),r(e,K,a),r(e,st,a),r(e,ee,a),r(e,dt,a),r(e,te,a),r(e,ct,a),g(ae,e,a),r(e,mt,a),r(e,ne,a),r(e,pt,a),r(e,oe,a),r(e,ht,a),g(le,e,a),r(e,gt,a),r(e,c,a),g(re,c,null),l(c,Ut),l(c,Me),l(c,xt),l(c,j),g(ie,j,null),l(j,Ot),l(j,Ce),l(c,Pt),l(c,T),g(se,T,null),l(T,Jt),l(T,ye),l(T,It),l(T,Te),l(c,kt),l(c,U),g(de,U,null),l(U,At),l(U,we),l(c,Nt),l(c,x),g(ce,x,null),l(x,qt),l(x,$e),l(c,Ft),l(c,w),g(me,w,null),l(w,Et),l(w,je),l(w,Lt),l(w,Ue),l(c,zt),l(c,O),g(pe,O,null),l(O,Dt),l(O,xe),l(c,Bt),l(c,P),g(he,P,null),l(P,Ht),l(P,Oe),l(c,Wt),l(c,J),g(ge,J,null),l(J,St),l(J,Pe),l(c,Qt),l(c,I),g(ue,I,null),l(I,Zt),l(I,Je),l(c,Rt),l(c,M),g(_e,M,null),l(M,Xt),l(M,Ie),l(M,Gt),l(M,ke),l(M,Vt),l(M,Ae),r(e,ut,a),g(fe,e,a),r(e,_t,a),r(e,y,a),g(ve,y,null),l(y,Yt),l(y,Ne),l(y,Kt),l(y,qe),r(e,ft,a),g(be,e,a),r(e,vt,a),r(e,De,a),bt=!0},p:Na,i(e){bt||(u(N.$$.fragment,e),u(E.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(fe.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),bt=!0)},o(e){_(N.$$.fragment,e),_(E.$$.fragment,e),_(B.$$.fragment,e),_(W.$$.fragment,e),_(Q.$$.fragment,e),_(R.$$.fragment,e),_(G.$$.fragment,e),_(V.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(fe.$$.fragment,e),_(ve.$$.fragment,e),_(be.$$.fragment,e),bt=!1},d(e){e&&(t(Be),t(ze),t(He),t(We),t(q),t(Se),t(F),t(Qe),t(Ze),t(L),t(Re),t(z),t(Xe),t(D),t(Ge),t(Ve),t(H),t(Ye),t(Ke),t(S),t(et),t(tt),t(Z),t(at),t(nt),t(X),t(ot),t(lt),t(rt),t(Y),t(it),t(K),t(st),t(ee),t(dt),t(te),t(ct),t(mt),t(ne),t(pt),t(oe),t(ht),t(gt),t(c),t(ut),t(_t),t(y),t(ft),t(vt),t(De)),t($),f(N,e),f(E,e),f(B,e),f(W,e),f(Q,e),f(R,e),f(G,e),f(V,e),f(ae,e),f(le,e),f(re),f(ie),f(se),f(de),f(ce),f(me),f(pe),f(he),f(ge),f(ue),f(_e),f(fe,e),f(ve),f(be,e)}}}const Ba='{"title":"CPO Trainer","local":"cpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the CPOTrainer","local":"using-the-cpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2}],"depth":1}';function Ha(ta){return qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends Fa{constructor($){super(),Ea(this,$,Ha,Da,Aa,{})}}export{Xa as component};
