import{s as ka,n as _a,o as xa}from"../chunks/scheduler.7da89386.js";import{S as qa,i as Wa,g as i,s as l,r as c,A as Za,h as p,f as t,c as n,j as $a,u as r,x as o,k as Ks,y as Ha,a,v as M,d as u,t as y,w as m}from"../chunks/index.20910acc.js";import{C as h}from"../chunks/CodeBlock.143bd81e.js";import{H as d,E as Ba}from"../chunks/getInferenceSnippets.375cdad5.js";function Ea(Wt){let j,Os,Ps,se,f,ee,w,Zt="🤗 Evaluate provides access to a wide range of evaluation tools. It covers a range of modalities such as text, computer vision, audio, etc. as well as tools to evaluate models or datasets. These tools are split into three categories.",te,C,ae,g,Ht="There are different aspects of a typical machine learning pipeline that can be evaluated and for each aspect 🤗 Evaluate provides a tool:",le,b,Bt='<li><strong>Metric</strong>: A metric is used to evaluate a model’s performance and usually involves the model’s predictions as well as some ground truth labels. You can find all integrated metrics at <a href="https://huggingface.co/evaluate-metric" rel="nofollow">evaluate-metric</a>.</li> <li><strong>Comparison</strong>: A comparison is used to compare two models. This can for example be done by comparing their predictions to ground truth labels and computing their agreement. You can find all integrated comparisons at <a href="https://huggingface.co/evaluate-comparison" rel="nofollow">evaluate-comparison</a>.</li> <li><strong>Measurement</strong>: The dataset is as important as the model trained on it. With measurements one can investigate a dataset’s properties. You can find all integrated measurements at <a href="https://huggingface.co/evaluate-measurement" rel="nofollow">evaluate-measurement</a>.</li>',ne,I,Et='Each of these evaluation modules live on Hugging Face Hub as a Space. They come with an interactive widget and a documentation card documenting its use and limitations. For example <a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">accuracy</a>:',ie,U,Yt='<img src="https://huggingface.co/datasets/evaluate/media/resolve/main/metric-widget.png" width="400"/>',pe,v,Gt='Each metric, comparison, and measurement is a separate Python module, but for using any of them, there is a single entry point: <a href="/docs/evaluate/main/en/package_reference/loading_methods#evaluate.load">evaluate.load()</a>!',oe,A,ce,$,Vt="Any metric, comparison, or measurement is loaded with the <code>evaluate.load</code> function:",re,k,Me,_,Qt="If you want to make sure you are loading the right type of evaluation (especially if there are name clashes) you can explicitly pass the type:",ue,x,ye,q,me,W,Rt="Besides the modules implemented in 🤗 Evaluate you can also load any community module by specifying the repository ID of the metric implementation:",he,Z,de,H,St='See the <a href="/docs/evaluate/main/en/creating_and_sharing">Creating and Sharing Guide</a> for information about uploading custom metrics.',je,B,Ue,E,Xt='With <a href="/docs/evaluate/main/en/package_reference/loading_methods#evaluate.list_evaluation_modules">list_evaluation_modules()</a> you can check what modules are available on the hub. You can also filter for a specific modules and skip community metrics if you want. You can also see additional information such as likes:',Te,Y,Je,G,fe,V,Nt='All evalution modules come with a range of useful attributes that help to use a module stored in a <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModuleInfo">EvaluationModuleInfo</a> object.',we,Q,zt="<thead><tr><th>Attribute</th> <th>Description</th></tr></thead> <tbody><tr><td><code>description</code></td> <td>A short description of the evaluation module.</td></tr> <tr><td><code>citation</code></td> <td>A BibTex string for citation when available.</td></tr> <tr><td><code>features</code></td> <td>A <code>Features</code> object defining the input format.</td></tr> <tr><td><code>inputs_description</code></td> <td>This is equivalent to the modules docstring.</td></tr> <tr><td><code>homepage</code></td> <td>The homepage of the module.</td></tr> <tr><td><code>license</code></td> <td>The license of the module.</td></tr> <tr><td><code>codebase_urls</code></td> <td>Link to the code behind the module.</td></tr> <tr><td><code>reference_urls</code></td> <td>Additional reference URLs.</td></tr></tbody>",Ce,R,Ft="Let’s have a look at a few examples. First, let’s look at the <code>description</code> attribute of the accuracy metric:",ge,S,be,X,Lt="You can see that it describes how the metric works in theory. If you use this metric for your work, especially if it is an academic publication you want to reference it properly. For that you can look at the <code>citation</code> attribute:",Ie,N,ve,z,Pt="Before we can apply a metric or other evaluation module to a use-case, we need to know what the input format of the metric is:",Ae,F,$e,T,Dt="<p>Note that features always describe the type of a single input element. In general we will add lists of elements so you can always think of a list around the types in <code>features</code>. Evaluate accepts various input formats (Python lists, NumPy arrays, PyTorch tensors, etc.) and converts them to an appropriate format for storage and computation.</p>",ke,L,_e,P,Kt="Now that we know how the evaluation module works and what should go in there we want to actually use it! When it comes to computing the actual score there are two main ways to do it:",xe,D,Ot="<li>All-in-one</li> <li>Incremental</li>",qe,K,sa='In the incremental approach the necessary inputs are added to the module with <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.add">EvaluationModule.add()</a> or <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.add_batch">EvaluationModule.add_batch()</a> and the score is calculated at the end with <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.compute">EvaluationModule.compute()</a>. Alternatively, one can pass all the inputs at once to <code>compute()</code>. Let’s have a look at the two approaches.',We,O,Ze,ss,ea="The simplest way to calculate the score of an evaluation module is by calling <code>compute()</code> directly with the necessary inputs. Simply pass the inputs as seen in <code>features</code> to the <code>compute()</code> method.",He,es,Be,ts,ta="Evaluation modules return the results in a dictionary. However, in some instances you build up the predictions iteratively or in a distributed fashion in which case <code>add()</code> or <code>add_batch()</code> are useful.",Ee,as,Ye,ls,aa="In many evaluation pipelines you build the predictions iteratively such as in a for-loop. In that case you could store the predictions in a list and at the end pass them to <code>compute()</code>. With <code>add()</code> and <code>add_batch()</code> you can circumvent the step of storing the predictions separately. If you are only creating single predictions at a time you can use <code>add()</code>:",Ge,ns,Ve,is,la="Once you have gathered all predictions you can call <code>compute()</code> to compute the score based on all stored values. When getting predictions and references in batches you can use <code>add_batch()</code> which adds a list elements for later processing. The rest works as with <code>add()</code>:",Qe,ps,Re,os,na="This is especially useful when you need to get the predictions from your model in batches:",Se,cs,Xe,rs,Ne,Ms,ia='Computing metrics in a distributed environment can be tricky. Metric evaluation is executed in separate Python processes, or nodes, on different subsets of a dataset. Typically, when a metric score is additive (<code>f(AuB) = f(A) + f(B)</code>), you can use distributed reduce operations to gather the scores for each subset of the dataset. But when a metric is non-additive (<code>f(AuB) ≠ f(A) + f(B)</code>), it’s not that simple. For example, you can’t take the sum of the <a href="https://huggingface.co/spaces/evaluate-metric/f1" rel="nofollow">F1</a> scores of each data subset as your <strong>final metric</strong>.',ze,us,pa="A common way to overcome this issue is to fallback on single process evaluation. The metrics are evaluated on a single GPU, which becomes inefficient.",Fe,ys,oa="🤗 Evaluate solves this issue by only computing the final metric on the first node. The predictions and references are computed and provided to the metric separately for each node. These are temporarily stored in an Apache Arrow table, avoiding cluttering the GPU or CPU memory. When you are ready to <code>compute()</code> the final metric, the first node is able to access the predictions and references stored on all the other nodes. Once it has gathered all the predictions and references, <code>compute()</code> will perform the final metric evaluation.",Le,ms,ca="This solution allows 🤗 Evaluate to perform distributed predictions, which is important for evaluation speed in distributed settings. At the same time, you can also use complex non-additive metrics without wasting valuable GPU or CPU memory.",Pe,hs,De,ds,ra='Often one wants to not only evaluate a single metric but a range of different metrics capturing different aspects of a model. E.g. for classification it is usually a good idea to compute F1-score, recall, and precision in addition to accuracy to get a better picture of model performance. Naturally, you can load a bunch of metrics and call them sequentially. However, a more convenient way is to use the <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.combine">combine()</a> function to bundle them together:',Ke,js,Oe,Us,Ma="The <code>combine</code> function accepts both the list of names of the metrics as well as an instantiated modules. The <code>compute</code> call then computes each metric:",st,Ts,et,Js,tt,fs,ua='Saving and sharing evaluation results is an important step. We provide the <a href="/docs/evaluate/main/en/package_reference/saving_methods#evaluate.save">evaluate.save()</a> function to easily save metrics results. You can either pass a specific filename or a directory. In the latter case, the results are saved in a file with an automatically created file name. Besides the directory or file name, the function takes any key-value pairs as inputs and stores them in a JSON file.',at,ws,lt,Cs,ya="The content of the JSON file look like the following:",nt,gs,it,bs,ma="In addition to the specified fields, it also contains useful system information for reproducing the results.",pt,Is,ha='Besides storing the results locally, you should report them on the model’s repository on the Hub. With the <a href="/docs/evaluate/main/en/package_reference/hub_methods#evaluate.push_to_hub">evaluate.push_to_hub()</a> function, you can easily report evaluation results to the model’s repository:',ot,vs,ct,As,rt,$s,da='The <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.evaluator">evaluate.evaluator()</a> provides automated evaluation and only requires a model, dataset, metric in contrast to the metrics in <code>EvaluationModule</code>s that require the model’s predictions. As such it is easier to evaluate a model on a dataset with a given metric as the inference is handled internally. To make that possible it uses the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.pipeline" rel="nofollow">pipeline</a> abstraction from <code>transformers</code>. However, you can use your own framework as long as it follows the <code>pipeline</code> interface.',Mt,ks,ja="To make an evaluation with the <code>evaluator</code> let’s load a <code>transformers</code> pipeline (but you can pass your own custom inference class for any framework as long as it follows the pipeline call API) with an model trained on IMDb, the IMDb test split and the accuracy metric.",ut,_s,yt,xs,Ua="Then you can create an evaluator for text classification and pass the three objects to the <code>compute()</code> method. With the label mapping <code>evaluate</code> provides a method to align the pipeline outputs with the label column in the dataset:",mt,qs,ht,Ws,Ta="Calculating the value of the metric alone is often not enough to know if a model performs significantly better than another one. With <em>bootstrapping</em> <code>evaluate</code> computes confidence intervals and the standard error which helps estimate how stable a score is:",dt,Zs,jt,Hs,Ja="The evaluator expects a <code>&quot;text&quot;</code> and <code>&quot;label&quot;</code> column for the data input. If your dataset differs you can provide the columns with the keywords <code>input_column=&quot;text&quot;</code> and <code>label_column=&quot;label&quot;</code>. Currently only <code>&quot;text-classification&quot;</code> is supported with more tasks being added in the future.",Ut,Bs,Tt,Es,fa="When comparing several models, sometimes it’s hard to spot the differences in their performance simply by looking at their scores. Also often there is not a single best model but there are trade-offs between e.g. latency and accuracy as larger models might have better performance but are also slower. We are gradually adding different visualization approaches, such as plots, to make choosing the best model for a use-case easier.",Jt,Ys,wa="For instance, if you have a list of results from multiple models (as dictionaries), you can feed them into the <code>radar_plot()</code> function:",ft,Gs,wt,Vs,Ca="Which lets you visually compare the 4 models and choose the optimal one for you, based on one or several metrics:",Ct,J,ga='<img src="https://huggingface.co/datasets/evaluate/media/resolve/main/example_viz.png" width="400"/>',gt,Qs,bt,Rs,ba='It can be useful to evaluate models on a variety of different tasks to understand their downstream performance. The <a href="evaluation_suite">EvaluationSuite</a> enables evaluation of models on a collection of tasks. Tasks can be constructed as (<a href="base_evaluator">evaluator</a>, dataset, metric) tuples and passed to an <a href="evaluation_suite">EvaluationSuite</a> stored on the Hugging Face Hub as a Space, or locally as a Python script. See the <a href="base_evaluator">evaluator documentation</a> for a list of currently supported tasks.',It,Ss,Ia="<code>EvaluationSuite</code> scripts can be defined as follows, and supports Python code for data preprocessing.",vt,Xs,At,Ns,va="Evaluation can be run by loading the <code>EvaluationSuite</code> and calling the <code>run()</code> method with a model or pipeline.",$t,zs,kt,Fs,Aa='<thead><tr><th align="right">accuracy</th> <th align="right">total_time_in_seconds</th> <th align="right">samples_per_second</th> <th align="left">latency_in_seconds</th> <th align="left">task_name</th></tr></thead> <tbody><tr><td align="right">0.3</td> <td align="right">4.62804</td> <td align="right">2.16074</td> <td align="left">0.462804</td> <td align="left">imdb</td></tr> <tr><td align="right">0</td> <td align="right">0.686388</td> <td align="right">14.569</td> <td align="left">0.0686388</td> <td align="left">sst2</td></tr></tbody>',_t,Ls,xt,Ds,qt;return f=new d({props:{title:"A quick tour",local:"a-quick-tour",headingTag:"h1"}}),C=new d({props:{title:"Types of evaluations",local:"types-of-evaluations",headingTag:"h2"}}),A=new d({props:{title:"Load",local:"load",headingTag:"h2"}}),k=new h({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate
<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),x=new h({props:{code:"d29yZF9sZW5ndGglMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndvcmRfbGVuZ3RoJTIyJTJDJTIwbW9kdWxlX3R5cGUlM0QlMjJtZWFzdXJlbWVudCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>word_length = evaluate.load(<span class="hljs-string">&quot;word_length&quot;</span>, module_type=<span class="hljs-string">&quot;measurement&quot;</span>)',wrap:!1}}),q=new d({props:{title:"Community modules",local:"community-modules",headingTag:"h3"}}),Z=new h({props:{code:"ZWxlbWVudF9jb3VudCUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIybHZ3ZXJyYSUyRmVsZW1lbnRfY291bnQlMjIlMkMlMjBtb2R1bGVfdHlwZSUzRCUyMm1lYXN1cmVtZW50JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>element_count = evaluate.load(<span class="hljs-string">&quot;lvwerra/element_count&quot;</span>, module_type=<span class="hljs-string">&quot;measurement&quot;</span>)',wrap:!1}}),B=new d({props:{title:"List available modules",local:"list-available-modules",headingTag:"h3"}}),Y=new h({props:{code:"ZXZhbHVhdGUubGlzdF9ldmFsdWF0aW9uX21vZHVsZXMoJTBBJTIwJTIwbW9kdWxlX3R5cGUlM0QlMjJjb21wYXJpc29uJTIyJTJDJTBBJTIwJTIwaW5jbHVkZV9jb21tdW5pdHklM0RGYWxzZSUyQyUwQSUyMCUyMHdpdGhfZGV0YWlscyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>evaluate.list_evaluation_modules(
<span class="hljs-meta">... </span>  module_type=<span class="hljs-string">&quot;comparison&quot;</span>,
<span class="hljs-meta">... </span>  include_community=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>  with_details=<span class="hljs-literal">True</span>)

[{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;mcnemar&#x27;</span>, <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;comparison&#x27;</span>, <span class="hljs-string">&#x27;community&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;likes&#x27;</span>: <span class="hljs-number">1</span>},
 {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;exact_match&#x27;</span>, <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;comparison&#x27;</span>, <span class="hljs-string">&#x27;community&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;likes&#x27;</span>: <span class="hljs-number">0</span>}]`,wrap:!1}}),G=new d({props:{title:"Module attributes",local:"module-attributes",headingTag:"h2"}}),S=new h({props:{code:"YWNjdXJhY3klMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQWFjY3VyYWN5LmRlc2NyaXB0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy.description
Accuracy <span class="hljs-keyword">is</span> the proportion of correct predictions among the total number of cases processed. It can be computed <span class="hljs-keyword">with</span>:
Accuracy = (TP + TN) / (TP + TN + FP + FN)
 Where:
TP: <span class="hljs-literal">True</span> positive
TN: <span class="hljs-literal">True</span> negative
FP: <span class="hljs-literal">False</span> positive
FN: <span class="hljs-literal">False</span> negative`,wrap:!1}}),N=new h({props:{code:"YWNjdXJhY3kuY2l0YXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy.citation
<span class="hljs-meta">@article{scikit-learn,</span>
  title={Scikit-learn: Machine Learning <span class="hljs-keyword">in</span> {P}ython},
  author={Pedregosa, F. <span class="hljs-keyword">and</span> Varoquaux, G. <span class="hljs-keyword">and</span> Gramfort, A. <span class="hljs-keyword">and</span> Michel, V.
         <span class="hljs-keyword">and</span> Thirion, B. <span class="hljs-keyword">and</span> Grisel, O. <span class="hljs-keyword">and</span> Blondel, M. <span class="hljs-keyword">and</span> Prettenhofer, P.
         <span class="hljs-keyword">and</span> Weiss, R. <span class="hljs-keyword">and</span> Dubourg, V. <span class="hljs-keyword">and</span> Vanderplas, J. <span class="hljs-keyword">and</span> Passos, A. <span class="hljs-keyword">and</span>
         Cournapeau, D. <span class="hljs-keyword">and</span> Brucher, M. <span class="hljs-keyword">and</span> Perrot, M. <span class="hljs-keyword">and</span> Duchesnay, E.},
  journal={Journal of Machine Learning Research},
  volume={<span class="hljs-number">12</span>},
  pages={<span class="hljs-number">2825</span>--<span class="hljs-number">2830</span>},
  year={<span class="hljs-number">2011</span>}
}`,wrap:!1}}),F=new h({props:{code:"YWNjdXJhY3kuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy.features
{
    <span class="hljs-string">&#x27;predictions&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
    <span class="hljs-string">&#x27;references&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)
}`,wrap:!1}}),L=new d({props:{title:"Compute",local:"compute",headingTag:"h2"}}),O=new d({props:{title:"How to compute",local:"how-to-compute",headingTag:"h3"}}),es=new h({props:{code:"YWNjdXJhY3kuY29tcHV0ZShyZWZlcmVuY2VzJTNEJTVCMCUyQzElMkMwJTJDMSU1RCUyQyUyMHByZWRpY3Rpb25zJTNEJTVCMSUyQzAlMkMwJTJDMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy.compute(references=[<span class="hljs-number">0</span>,<span class="hljs-number">1</span>,<span class="hljs-number">0</span>,<span class="hljs-number">1</span>], predictions=[<span class="hljs-number">1</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">1</span>])
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.5</span>}`,wrap:!1}}),as=new d({props:{title:"Calculate a single metric or a batch of metrics",local:"calculate-a-single-metric-or-a-batch-of-metrics",headingTag:"h3"}}),ns=new h({props:{code:"Zm9yJTIwcmVmJTJDJTIwcHJlZCUyMGluJTIwemlwKCU1QjAlMkMxJTJDMCUyQzElNUQlMkMlMjAlNUIxJTJDMCUyQzAlMkMxJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGFjY3VyYWN5LmFkZChyZWZlcmVuY2VzJTNEcmVmJTJDJTIwcHJlZGljdGlvbnMlM0RwcmVkKSUwQWFjY3VyYWN5LmNvbXB1dGUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> ref, pred <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>([<span class="hljs-number">0</span>,<span class="hljs-number">1</span>,<span class="hljs-number">0</span>,<span class="hljs-number">1</span>], [<span class="hljs-number">1</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">1</span>]):
<span class="hljs-meta">&gt;&gt;&gt; </span>    accuracy.add(references=ref, predictions=pred)
<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy.compute()
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.5</span>}`,wrap:!1}}),ps=new h({props:{code:"Zm9yJTIwcmVmcyUyQyUyMHByZWRzJTIwaW4lMjB6aXAoJTVCJTVCMCUyQzElNUQlMkMlNUIwJTJDMSU1RCU1RCUyQyUyMCU1QiU1QjElMkMwJTVEJTJDJTVCMCUyQzElNUQlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYWNjdXJhY3kuYWRkX2JhdGNoKHJlZmVyZW5jZXMlM0RyZWZzJTJDJTIwcHJlZGljdGlvbnMlM0RwcmVkcyklMEFhY2N1cmFjeS5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> refs, preds <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>([[<span class="hljs-number">0</span>,<span class="hljs-number">1</span>],[<span class="hljs-number">0</span>,<span class="hljs-number">1</span>]], [[<span class="hljs-number">1</span>,<span class="hljs-number">0</span>],[<span class="hljs-number">0</span>,<span class="hljs-number">1</span>]]):
<span class="hljs-meta">&gt;&gt;&gt; </span>    accuracy.add_batch(references=refs, predictions=preds)
<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy.compute()
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.5</span>}`,wrap:!1}}),cs=new h({props:{code:"Zm9yJTIwbW9kZWxfaW5wdXRzJTJDJTIwZ29sZF9zdGFuZGFyZHMlMjBpbiUyMGV2YWx1YXRpb25fZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbW9kZWwobW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocmVmZXJlbmNlcyUzRGdvbGRfc3RhbmRhcmRzJTJDJTIwcHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyklMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> model_inputs, gold_standards <span class="hljs-keyword">in</span> evaluation_dataset:
<span class="hljs-meta">&gt;&gt;&gt; </span>    predictions = model(model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>    metric.add_batch(references=gold_standards, predictions=predictions)
<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`,wrap:!1}}),rs=new d({props:{title:"Distributed evaluation",local:"distributed-evaluation",headingTag:"h3"}}),hs=new d({props:{title:"Combining several evaluations",local:"combining-several-evaluations",headingTag:"h2"}}),js=new h({props:{code:"Y2xmX21ldHJpY3MlMjAlM0QlMjBldmFsdWF0ZS5jb21iaW5lKCU1QiUyMmFjY3VyYWN5JTIyJTJDJTIwJTIyZjElMjIlMkMlMjAlMjJwcmVjaXNpb24lMjIlMkMlMjAlMjJyZWNhbGwlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>clf_metrics = evaluate.combine([<span class="hljs-string">&quot;accuracy&quot;</span>, <span class="hljs-string">&quot;f1&quot;</span>, <span class="hljs-string">&quot;precision&quot;</span>, <span class="hljs-string">&quot;recall&quot;</span>])',wrap:!1}}),Ts=new h({props:{code:"Y2xmX21ldHJpY3MuY29tcHV0ZShwcmVkaWN0aW9ucyUzRCU1QjAlMkMlMjAxJTJDJTIwMCU1RCUyQyUyMHJlZmVyZW5jZXMlM0QlNUIwJTJDJTIwMSUyQyUyMDElNUQpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>clf_metrics.compute(predictions=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>], references=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>])

{
  <span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.667</span>,
  <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.667</span>,
  <span class="hljs-string">&#x27;precision&#x27;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&#x27;recall&#x27;</span>: <span class="hljs-number">0.5</span>
}`,wrap:!1}}),Js=new d({props:{title:"Save and push to the Hub",local:"save-and-push-to-the-hub",headingTag:"h2"}}),ws=new h({props:{code:"cmVzdWx0JTIwJTNEJTIwYWNjdXJhY3kuY29tcHV0ZShyZWZlcmVuY2VzJTNEJTVCMCUyQzElMkMwJTJDMSU1RCUyQyUyMHByZWRpY3Rpb25zJTNEJTVCMSUyQzAlMkMwJTJDMSU1RCklMEElMEFoeXBlcnBhcmFtcyUyMCUzRCUyMCU3QiUyMm1vZGVsJTIyJTNBJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlN0QlMEFldmFsdWF0ZS5zYXZlKCUyMi4lMkZyZXN1bHRzJTJGJTIyJTJDJTIwZXhwZXJpbWVudCUzRCUyMnJ1biUyMDQyJTIyJTJDJTIwKipyZXN1bHQlMkMlMjAqKmh5cGVycGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>result = accuracy.compute(references=[<span class="hljs-number">0</span>,<span class="hljs-number">1</span>,<span class="hljs-number">0</span>,<span class="hljs-number">1</span>], predictions=[<span class="hljs-number">1</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">1</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>hyperparams = {<span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;bert-base-uncased&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluate.save(<span class="hljs-string">&quot;./results/&quot;</span>, experiment=<span class="hljs-string">&quot;run 42&quot;</span>, **result, **hyperparams)
PosixPath(<span class="hljs-string">&#x27;results/result-2022_05_30-22_09_11.json&#x27;</span>)`,wrap:!1}}),gs=new h({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZXhwZXJpbWVudCUyMiUzQSUyMCUyMnJ1biUyMDQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWNjdXJhY3klMjIlM0ElMjAwLjUlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbCUyMiUzQSUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyX3RpbWVzdGFtcCUyMiUzQSUyMCUyMjIwMjItMDUtMzBUMjIlM0EwOSUzQTExLjk1OTQ2OSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMl9naXRfY29tbWl0X2hhc2glMjIlM0ElMjAlMjIxMjM0NTY3ODlhYmNkZWZnaGlqa2wlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJfZXZhbHVhdGVfdmVyc2lvbiUyMiUzQSUyMCUyMjAuMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyX3B5dGhvbl92ZXJzaW9uJTIyJTNBJTIwJTIyMy45LjEyJTIwKG1haW4lMkMlMjBNYXIlMjAyNiUyMDIwMjIlMkMlMjAxNSUzQTUxJTNBMTUpJTIwJTVDbiU1QkNsYW5nJTIwMTMuMS42JTIwKGNsYW5nLTEzMTYuMC4yMS4yKSU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMl9pbnRlcnByZXRlcl9wYXRoJTIyJTNBJTIwJTIyJTJGVXNlcnMlMkZsZWFuZHJvJTJGZ2l0JTJGZXZhbHVhdGUlMkZlbnYlMkZiaW4lMkZweXRob24lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;experiment&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;run 42&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;accuracy&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.5</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;_timestamp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;2022-05-30T22:09:11.959469&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;_git_commit_hash&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;123456789abcdefghijkl&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;_evaluate_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.1.0&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;_python_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3.9.12 (main, Mar 26 2022, 15:51:15) \\n[Clang 13.1.6 (clang-1316.0.21.2)]&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;_interpreter_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/Users/leandro/git/evaluate/env/bin/python&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),vs=new h({props:{code:"ZXZhbHVhdGUucHVzaF90b19odWIoJTBBJTIwJTIwbW9kZWxfaWQlM0QlMjJodWdnaW5nZmFjZSUyRmdwdDItd2lraXRleHQyJTIyJTJDJTIwJTIwJTIzJTIwbW9kZWwlMjByZXBvc2l0b3J5JTIwb24lMjBodWIlMEElMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBtZXRyaWMlMjB2YWx1ZSUwQSUyMCUyMG1ldHJpY190eXBlJTNEJTIyYmxldSUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG1ldHJpYyUyMG5hbWUlMkMlMjBlLmcuJTIwYWNjdXJhY3kubmFtZSUwQSUyMCUyMG1ldHJpY19uYW1lJTNEJTIyQkxFVSUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHByZXR0eSUyMG5hbWUlMjB3aGljaCUyMGlzJTIwZGlzcGxheWVkJTBBJTIwJTIwZGF0YXNldF90eXBlJTNEJTIyd2lraXRleHQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkYXRhc2V0JTIwbmFtZSUyMG9uJTIwdGhlJTIwaHViJTBBJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyV2lraVRleHQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBwcmV0dHklMjBuYW1lJTBBJTIwJTIwZGF0YXNldF9zcGxpdCUzRCUyMnRlc3QlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkYXRhc2V0JTIwc3BsaXQlMjB1c2VkJTBBJTIwJTIwdGFza190eXBlJTNEJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdGFzayUyMGlkJTJDJTIwc2VlJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZldmFsdWF0ZSUyRmJsb2IlMkZtYWluJTJGc3JjJTJGZXZhbHVhdGUlMkZjb25maWcucHklMjNMMTU0LUwxOTIlMEElMjAlMjB0YXNrX25hbWUlM0QlMjJUZXh0JTIwR2VuZXJhdGlvbiUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHByZXR0eSUyMG5hbWUlMjBmb3IlMjB0YXNrJTBBKQ==",highlighted:`evaluate.push_to_hub(
  model_id=<span class="hljs-string">&quot;huggingface/gpt2-wikitext2&quot;</span>,  <span class="hljs-comment"># model repository on hub</span>
  metric_value=<span class="hljs-number">0.5</span>,                       <span class="hljs-comment"># metric value</span>
  metric_type=<span class="hljs-string">&quot;bleu&quot;</span>,                     <span class="hljs-comment"># metric name, e.g. accuracy.name</span>
  metric_name=<span class="hljs-string">&quot;BLEU&quot;</span>,                     <span class="hljs-comment"># pretty name which is displayed</span>
  dataset_type=<span class="hljs-string">&quot;wikitext&quot;</span>,                <span class="hljs-comment"># dataset name on the hub</span>
  dataset_name=<span class="hljs-string">&quot;WikiText&quot;</span>,                <span class="hljs-comment"># pretty name</span>
  dataset_split=<span class="hljs-string">&quot;test&quot;</span>,                   <span class="hljs-comment"># dataset split used</span>
  task_type=<span class="hljs-string">&quot;text-generation&quot;</span>,            <span class="hljs-comment"># task id, see https://github.com/huggingface/evaluate/blob/main/src/evaluate/config.py#L154-L192</span>
  task_name=<span class="hljs-string">&quot;Text Generation&quot;</span>             <span class="hljs-comment"># pretty name for task</span>
)`,wrap:!1}}),As=new d({props:{title:"Evaluator",local:"evaluator",headingTag:"h2"}}),_s=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwZXZhbHVhdG9yJTBBaW1wb3J0JTIwZXZhbHVhdGUlMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUyMGRldmljZSUzRDApJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWRiJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKS5zaHVmZmxlKCkuc2VsZWN0KHJhbmdlKDEwMDApKSUwQW1ldHJpYyUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator
<span class="hljs-keyword">import</span> evaluate

pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=<span class="hljs-number">0</span>)
data = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>).shuffle().select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),qs=new h({props:{code:"dGFza19ldmFsdWF0b3IlMjAlM0QlMjBldmFsdWF0b3IoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFyZXN1bHRzJTIwJTNEJTIwdGFza19ldmFsdWF0b3IuY29tcHV0ZShtb2RlbF9vcl9waXBlbGluZSUzRHBpcGUlMkMlMjBkYXRhJTNEZGF0YSUyQyUyMG1ldHJpYyUzRG1ldHJpYyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0QlN0IlMjJORUdBVElWRSUyMiUzQSUyMDAlMkMlMjAlMjJQT1NJVElWRSUyMiUzQSUyMDElN0QlMkMpJTBBJTBBcHJpbnQocmVzdWx0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>task_evaluator = evaluator(<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>results = task_evaluator.compute(model_or_pipeline=pipe, data=data, metric=metric,
<span class="hljs-meta">... </span>                       label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>},)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.934</span>}`,wrap:!1}}),Zs=new h({props:{code:"cmVzdWx0cyUyMCUzRCUyMGV2YWwuY29tcHV0ZShtb2RlbF9vcl9waXBlbGluZSUzRHBpcGUlMkMlMjBkYXRhJTNEZGF0YSUyQyUyMG1ldHJpYyUzRG1ldHJpYyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0QlN0IlMjJORUdBVElWRSUyMiUzQSUyMDAlMkMlMjAlMjJQT1NJVElWRSUyMiUzQSUyMDElN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJhdGVneSUzRCUyMmJvb3RzdHJhcCUyMiUyQyUyMG5fcmVzYW1wbGVzJTNEMjAwKSUwQSUwQXByaW50KHJlc3VsdHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>results = <span class="hljs-built_in">eval</span>.compute(model_or_pipeline=pipe, data=data, metric=metric,
<span class="hljs-meta">... </span>                       label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>},
<span class="hljs-meta">... </span>                       strategy=<span class="hljs-string">&quot;bootstrap&quot;</span>, n_resamples=<span class="hljs-number">200</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)
{<span class="hljs-string">&#x27;accuracy&#x27;</span>:
    {
      <span class="hljs-string">&#x27;confidence_interval&#x27;</span>: (<span class="hljs-number">0.906</span>, <span class="hljs-number">0.9406749892841922</span>),
      <span class="hljs-string">&#x27;standard_error&#x27;</span>: <span class="hljs-number">0.00865213251082787</span>,
      <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.923</span>
    }
}`,wrap:!1}}),Bs=new d({props:{title:"Visualization",local:"visualization",headingTag:"h2"}}),Gs=new h({props:{code:"JTBBZGF0YSUyMCUzRCUyMCU1QiUwQW1vZGVsX25hbWVzJTIwJTNEJTIwJTVCJTIyTW9kZWwlMjAxJTIyJTJDJTIwJTIyTW9kZWwlMjAyJTIyJTJDJTIwJTIyTW9kZWwlMjAzJTIyJTJDJTIwJTIyTW9kZWwlMjA0JTIyJTVEJTBBcGxvdCUyMCUzRCUyMHJhZGFyX3Bsb3QoZGF0YSUzRGRhdGElMkMlMjBtb2RlbF9uYW1lcyUzRG1vZGVsX25hbWVzKSUwQXBsb3Quc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> evaluate.visualization <span class="hljs-keyword">import</span> radar_plot

<span class="hljs-meta">&gt;&gt;&gt; </span>data = [
   {<span class="hljs-string">&quot;accuracy&quot;</span>: <span class="hljs-number">0.99</span>, <span class="hljs-string">&quot;precision&quot;</span>: <span class="hljs-number">0.8</span>, <span class="hljs-string">&quot;f1&quot;</span>: <span class="hljs-number">0.95</span>, <span class="hljs-string">&quot;latency_in_seconds&quot;</span>: <span class="hljs-number">33.6</span>},
   {<span class="hljs-string">&quot;accuracy&quot;</span>: <span class="hljs-number">0.98</span>, <span class="hljs-string">&quot;precision&quot;</span>: <span class="hljs-number">0.87</span>, <span class="hljs-string">&quot;f1&quot;</span>: <span class="hljs-number">0.91</span>, <span class="hljs-string">&quot;latency_in_seconds&quot;</span>: <span class="hljs-number">11.2</span>},
   {<span class="hljs-string">&quot;accuracy&quot;</span>: <span class="hljs-number">0.98</span>, <span class="hljs-string">&quot;precision&quot;</span>: <span class="hljs-number">0.78</span>, <span class="hljs-string">&quot;f1&quot;</span>: <span class="hljs-number">0.88</span>, <span class="hljs-string">&quot;latency_in_seconds&quot;</span>: <span class="hljs-number">87.6</span>}, 
   {<span class="hljs-string">&quot;accuracy&quot;</span>: <span class="hljs-number">0.88</span>, <span class="hljs-string">&quot;precision&quot;</span>: <span class="hljs-number">0.78</span>, <span class="hljs-string">&quot;f1&quot;</span>: <span class="hljs-number">0.81</span>, <span class="hljs-string">&quot;latency_in_seconds&quot;</span>: <span class="hljs-number">101.6</span>}
   ]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_names = [<span class="hljs-string">&quot;Model 1&quot;</span>, <span class="hljs-string">&quot;Model 2&quot;</span>, <span class="hljs-string">&quot;Model 3&quot;</span>, <span class="hljs-string">&quot;Model 4&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>plot = radar_plot(data=data, model_names=model_names)
<span class="hljs-meta">&gt;&gt;&gt; </span>plot.show()`,wrap:!1}}),Qs=new d({props:{title:"Running evaluation on a suite of tasks",local:"running-evaluation-on-a-suite-of-tasks",headingTag:"h2"}}),Xs=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> evaluate.evaluation_suite <span class="hljs-keyword">import</span> SubTask

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Suite</span>(evaluate.EvaluationSuite):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, name</span>):
        <span class="hljs-built_in">super</span>().__init__(name)

        self.suite = [
            SubTask(
                task_type=<span class="hljs-string">&quot;text-classification&quot;</span>,
                data=<span class="hljs-string">&quot;imdb&quot;</span>,
                split=<span class="hljs-string">&quot;test[:1]&quot;</span>,
                args_for_task={
                    <span class="hljs-string">&quot;metric&quot;</span>: <span class="hljs-string">&quot;accuracy&quot;</span>,
                    <span class="hljs-string">&quot;input_column&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;label_column&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>,
                    <span class="hljs-string">&quot;label_mapping&quot;</span>: {
                        <span class="hljs-string">&quot;LABEL_0&quot;</span>: <span class="hljs-number">0.0</span>,
                        <span class="hljs-string">&quot;LABEL_1&quot;</span>: <span class="hljs-number">1.0</span>
                    }
                }
            ),
            SubTask(
                task_type=<span class="hljs-string">&quot;text-classification&quot;</span>,
                data=<span class="hljs-string">&quot;sst2&quot;</span>,
                split=<span class="hljs-string">&quot;test[:1]&quot;</span>,
                args_for_task={
                    <span class="hljs-string">&quot;metric&quot;</span>: <span class="hljs-string">&quot;accuracy&quot;</span>,
                    <span class="hljs-string">&quot;input_column&quot;</span>: <span class="hljs-string">&quot;sentence&quot;</span>,
                    <span class="hljs-string">&quot;label_column&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>,
                    <span class="hljs-string">&quot;label_mapping&quot;</span>: {
                        <span class="hljs-string">&quot;LABEL_0&quot;</span>: <span class="hljs-number">0.0</span>,
                        <span class="hljs-string">&quot;LABEL_1&quot;</span>: <span class="hljs-number">1.0</span>
                    }
                }
            )
        ]`,wrap:!1}}),zs=new h({props:{code:"ZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwRXZhbHVhdGlvblN1aXRlJTBBc3VpdGUlMjAlM0QlMjBFdmFsdWF0aW9uU3VpdGUubG9hZCgnbWF0aGVtYWtpdHRlbiUyRnNlbnRpbWVudC1ldmFsdWF0aW9uLXN1aXRlJyklMEFyZXN1bHRzJTIwJTNEJTIwc3VpdGUucnVuKCUyMmh1Z2dpbmdmYWNlJTJGcHJ1bmViZXJ0LWJhc2UtdW5jYXNlZC02LWZpbmVwcnVuZWQtdy1kaXN0aWwtbW5saSUyMik=",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> EvaluationSuite</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">suite = EvaluationSuite.load(<span class="hljs-string">&#x27;mathemakitten/sentiment-evaluation-suite&#x27;</span>)</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">results = suite.run(<span class="hljs-string">&quot;huggingface/prunebert-base-uncased-6-finepruned-w-distil-mnli&quot;</span>)</span>`,wrap:!1}}),Ls=new Ba({props:{source:"https://github.com/huggingface/evaluate/blob/main/docs/source/a_quick_tour.mdx"}}),{c(){j=i("meta"),Os=l(),Ps=i("p"),se=l(),c(f.$$.fragment),ee=l(),w=i("p"),w.textContent=Zt,te=l(),c(C.$$.fragment),ae=l(),g=i("p"),g.textContent=Ht,le=l(),b=i("ul"),b.innerHTML=Bt,ne=l(),I=i("p"),I.innerHTML=Et,ie=l(),U=i("div"),U.innerHTML=Yt,pe=l(),v=i("p"),v.innerHTML=Gt,oe=l(),c(A.$$.fragment),ce=l(),$=i("p"),$.innerHTML=Vt,re=l(),c(k.$$.fragment),Me=l(),_=i("p"),_.textContent=Qt,ue=l(),c(x.$$.fragment),ye=l(),c(q.$$.fragment),me=l(),W=i("p"),W.textContent=Rt,he=l(),c(Z.$$.fragment),de=l(),H=i("p"),H.innerHTML=St,je=l(),c(B.$$.fragment),Ue=l(),E=i("p"),E.innerHTML=Xt,Te=l(),c(Y.$$.fragment),Je=l(),c(G.$$.fragment),fe=l(),V=i("p"),V.innerHTML=Nt,we=l(),Q=i("table"),Q.innerHTML=zt,Ce=l(),R=i("p"),R.innerHTML=Ft,ge=l(),c(S.$$.fragment),be=l(),X=i("p"),X.innerHTML=Lt,Ie=l(),c(N.$$.fragment),ve=l(),z=i("p"),z.textContent=Pt,Ae=l(),c(F.$$.fragment),$e=l(),T=i("blockquote"),T.innerHTML=Dt,ke=l(),c(L.$$.fragment),_e=l(),P=i("p"),P.textContent=Kt,xe=l(),D=i("ol"),D.innerHTML=Ot,qe=l(),K=i("p"),K.innerHTML=sa,We=l(),c(O.$$.fragment),Ze=l(),ss=i("p"),ss.innerHTML=ea,He=l(),c(es.$$.fragment),Be=l(),ts=i("p"),ts.innerHTML=ta,Ee=l(),c(as.$$.fragment),Ye=l(),ls=i("p"),ls.innerHTML=aa,Ge=l(),c(ns.$$.fragment),Ve=l(),is=i("p"),is.innerHTML=la,Qe=l(),c(ps.$$.fragment),Re=l(),os=i("p"),os.textContent=na,Se=l(),c(cs.$$.fragment),Xe=l(),c(rs.$$.fragment),Ne=l(),Ms=i("p"),Ms.innerHTML=ia,ze=l(),us=i("p"),us.textContent=pa,Fe=l(),ys=i("p"),ys.innerHTML=oa,Le=l(),ms=i("p"),ms.textContent=ca,Pe=l(),c(hs.$$.fragment),De=l(),ds=i("p"),ds.innerHTML=ra,Ke=l(),c(js.$$.fragment),Oe=l(),Us=i("p"),Us.innerHTML=Ma,st=l(),c(Ts.$$.fragment),et=l(),c(Js.$$.fragment),tt=l(),fs=i("p"),fs.innerHTML=ua,at=l(),c(ws.$$.fragment),lt=l(),Cs=i("p"),Cs.textContent=ya,nt=l(),c(gs.$$.fragment),it=l(),bs=i("p"),bs.textContent=ma,pt=l(),Is=i("p"),Is.innerHTML=ha,ot=l(),c(vs.$$.fragment),ct=l(),c(As.$$.fragment),rt=l(),$s=i("p"),$s.innerHTML=da,Mt=l(),ks=i("p"),ks.innerHTML=ja,ut=l(),c(_s.$$.fragment),yt=l(),xs=i("p"),xs.innerHTML=Ua,mt=l(),c(qs.$$.fragment),ht=l(),Ws=i("p"),Ws.innerHTML=Ta,dt=l(),c(Zs.$$.fragment),jt=l(),Hs=i("p"),Hs.innerHTML=Ja,Ut=l(),c(Bs.$$.fragment),Tt=l(),Es=i("p"),Es.textContent=fa,Jt=l(),Ys=i("p"),Ys.innerHTML=wa,ft=l(),c(Gs.$$.fragment),wt=l(),Vs=i("p"),Vs.textContent=Ca,Ct=l(),J=i("div"),J.innerHTML=ga,gt=l(),c(Qs.$$.fragment),bt=l(),Rs=i("p"),Rs.innerHTML=ba,It=l(),Ss=i("p"),Ss.innerHTML=Ia,vt=l(),c(Xs.$$.fragment),At=l(),Ns=i("p"),Ns.innerHTML=va,$t=l(),c(zs.$$.fragment),kt=l(),Fs=i("table"),Fs.innerHTML=Aa,_t=l(),c(Ls.$$.fragment),xt=l(),Ds=i("p"),this.h()},l(s){const e=Za("svelte-u9bgzb",document.head);j=p(e,"META",{name:!0,content:!0}),e.forEach(t),Os=n(s),Ps=p(s,"P",{}),$a(Ps).forEach(t),se=n(s),r(f.$$.fragment,s),ee=n(s),w=p(s,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1j07n93"&&(w.textContent=Zt),te=n(s),r(C.$$.fragment,s),ae=n(s),g=p(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1m3k4ru"&&(g.textContent=Ht),le=n(s),b=p(s,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-dsr3mv"&&(b.innerHTML=Bt),ne=n(s),I=p(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-10lnpjf"&&(I.innerHTML=Et),ie=n(s),U=p(s,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1u0ctbl"&&(U.innerHTML=Yt),pe=n(s),v=p(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-7mwz24"&&(v.innerHTML=Gt),oe=n(s),r(A.$$.fragment,s),ce=n(s),$=p(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-1skqbca"&&($.innerHTML=Vt),re=n(s),r(k.$$.fragment,s),Me=n(s),_=p(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1u9jlzi"&&(_.textContent=Qt),ue=n(s),r(x.$$.fragment,s),ye=n(s),r(q.$$.fragment,s),me=n(s),W=p(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-172k455"&&(W.textContent=Rt),he=n(s),r(Z.$$.fragment,s),de=n(s),H=p(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-14gaawr"&&(H.innerHTML=St),je=n(s),r(B.$$.fragment,s),Ue=n(s),E=p(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-tdby5t"&&(E.innerHTML=Xt),Te=n(s),r(Y.$$.fragment,s),Je=n(s),r(G.$$.fragment,s),fe=n(s),V=p(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-12b2kxj"&&(V.innerHTML=Nt),we=n(s),Q=p(s,"TABLE",{"data-svelte-h":!0}),o(Q)!=="svelte-5veeh0"&&(Q.innerHTML=zt),Ce=n(s),R=p(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1414ywc"&&(R.innerHTML=Ft),ge=n(s),r(S.$$.fragment,s),be=n(s),X=p(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1anocpn"&&(X.innerHTML=Lt),Ie=n(s),r(N.$$.fragment,s),ve=n(s),z=p(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1jd7w6h"&&(z.textContent=Pt),Ae=n(s),r(F.$$.fragment,s),$e=n(s),T=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-2566m3"&&(T.innerHTML=Dt),ke=n(s),r(L.$$.fragment,s),_e=n(s),P=p(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-vmt7rv"&&(P.textContent=Kt),xe=n(s),D=p(s,"OL",{"data-svelte-h":!0}),o(D)!=="svelte-1wb6m9u"&&(D.innerHTML=Ot),qe=n(s),K=p(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-dd9fwy"&&(K.innerHTML=sa),We=n(s),r(O.$$.fragment,s),Ze=n(s),ss=p(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1qlkzhd"&&(ss.innerHTML=ea),He=n(s),r(es.$$.fragment,s),Be=n(s),ts=p(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-gjnmuk"&&(ts.innerHTML=ta),Ee=n(s),r(as.$$.fragment,s),Ye=n(s),ls=p(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-1m051l4"&&(ls.innerHTML=aa),Ge=n(s),r(ns.$$.fragment,s),Ve=n(s),is=p(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-dy6vdz"&&(is.innerHTML=la),Qe=n(s),r(ps.$$.fragment,s),Re=n(s),os=p(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1xf1wgv"&&(os.textContent=na),Se=n(s),r(cs.$$.fragment,s),Xe=n(s),r(rs.$$.fragment,s),Ne=n(s),Ms=p(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-fetmj"&&(Ms.innerHTML=ia),ze=n(s),us=p(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1tqog7c"&&(us.textContent=pa),Fe=n(s),ys=p(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-gyyzuk"&&(ys.innerHTML=oa),Le=n(s),ms=p(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-ukalmq"&&(ms.textContent=ca),Pe=n(s),r(hs.$$.fragment,s),De=n(s),ds=p(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-wme5rr"&&(ds.innerHTML=ra),Ke=n(s),r(js.$$.fragment,s),Oe=n(s),Us=p(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-13z9gnh"&&(Us.innerHTML=Ma),st=n(s),r(Ts.$$.fragment,s),et=n(s),r(Js.$$.fragment,s),tt=n(s),fs=p(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-bjlw33"&&(fs.innerHTML=ua),at=n(s),r(ws.$$.fragment,s),lt=n(s),Cs=p(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-x28agk"&&(Cs.textContent=ya),nt=n(s),r(gs.$$.fragment,s),it=n(s),bs=p(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-1j5fdcg"&&(bs.textContent=ma),pt=n(s),Is=p(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-18ykifj"&&(Is.innerHTML=ha),ot=n(s),r(vs.$$.fragment,s),ct=n(s),r(As.$$.fragment,s),rt=n(s),$s=p(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1sa5tcd"&&($s.innerHTML=da),Mt=n(s),ks=p(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-myrcia"&&(ks.innerHTML=ja),ut=n(s),r(_s.$$.fragment,s),yt=n(s),xs=p(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-19jk2fo"&&(xs.innerHTML=Ua),mt=n(s),r(qs.$$.fragment,s),ht=n(s),Ws=p(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-fvn7gh"&&(Ws.innerHTML=Ta),dt=n(s),r(Zs.$$.fragment,s),jt=n(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-53c6xd"&&(Hs.innerHTML=Ja),Ut=n(s),r(Bs.$$.fragment,s),Tt=n(s),Es=p(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-2emoqr"&&(Es.textContent=fa),Jt=n(s),Ys=p(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-7j394z"&&(Ys.innerHTML=wa),ft=n(s),r(Gs.$$.fragment,s),wt=n(s),Vs=p(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-a677ee"&&(Vs.textContent=Ca),Ct=n(s),J=p(s,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1kqtfj4"&&(J.innerHTML=ga),gt=n(s),r(Qs.$$.fragment,s),bt=n(s),Rs=p(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-n87bz9"&&(Rs.innerHTML=ba),It=n(s),Ss=p(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-x8r59q"&&(Ss.innerHTML=Ia),vt=n(s),r(Xs.$$.fragment,s),At=n(s),Ns=p(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-mtm0nc"&&(Ns.innerHTML=va),$t=n(s),r(zs.$$.fragment,s),kt=n(s),Fs=p(s,"TABLE",{"data-svelte-h":!0}),o(Fs)!=="svelte-g1mim"&&(Fs.innerHTML=Aa),_t=n(s),r(Ls.$$.fragment,s),xt=n(s),Ds=p(s,"P",{}),$a(Ds).forEach(t),this.h()},h(){Ks(j,"name","hf:doc:metadata"),Ks(j,"content",Ya),Ks(U,"class","flex justify-center"),Ks(T,"class","tip"),Ks(J,"class","flex justify-center")},m(s,e){Ha(document.head,j),a(s,Os,e),a(s,Ps,e),a(s,se,e),M(f,s,e),a(s,ee,e),a(s,w,e),a(s,te,e),M(C,s,e),a(s,ae,e),a(s,g,e),a(s,le,e),a(s,b,e),a(s,ne,e),a(s,I,e),a(s,ie,e),a(s,U,e),a(s,pe,e),a(s,v,e),a(s,oe,e),M(A,s,e),a(s,ce,e),a(s,$,e),a(s,re,e),M(k,s,e),a(s,Me,e),a(s,_,e),a(s,ue,e),M(x,s,e),a(s,ye,e),M(q,s,e),a(s,me,e),a(s,W,e),a(s,he,e),M(Z,s,e),a(s,de,e),a(s,H,e),a(s,je,e),M(B,s,e),a(s,Ue,e),a(s,E,e),a(s,Te,e),M(Y,s,e),a(s,Je,e),M(G,s,e),a(s,fe,e),a(s,V,e),a(s,we,e),a(s,Q,e),a(s,Ce,e),a(s,R,e),a(s,ge,e),M(S,s,e),a(s,be,e),a(s,X,e),a(s,Ie,e),M(N,s,e),a(s,ve,e),a(s,z,e),a(s,Ae,e),M(F,s,e),a(s,$e,e),a(s,T,e),a(s,ke,e),M(L,s,e),a(s,_e,e),a(s,P,e),a(s,xe,e),a(s,D,e),a(s,qe,e),a(s,K,e),a(s,We,e),M(O,s,e),a(s,Ze,e),a(s,ss,e),a(s,He,e),M(es,s,e),a(s,Be,e),a(s,ts,e),a(s,Ee,e),M(as,s,e),a(s,Ye,e),a(s,ls,e),a(s,Ge,e),M(ns,s,e),a(s,Ve,e),a(s,is,e),a(s,Qe,e),M(ps,s,e),a(s,Re,e),a(s,os,e),a(s,Se,e),M(cs,s,e),a(s,Xe,e),M(rs,s,e),a(s,Ne,e),a(s,Ms,e),a(s,ze,e),a(s,us,e),a(s,Fe,e),a(s,ys,e),a(s,Le,e),a(s,ms,e),a(s,Pe,e),M(hs,s,e),a(s,De,e),a(s,ds,e),a(s,Ke,e),M(js,s,e),a(s,Oe,e),a(s,Us,e),a(s,st,e),M(Ts,s,e),a(s,et,e),M(Js,s,e),a(s,tt,e),a(s,fs,e),a(s,at,e),M(ws,s,e),a(s,lt,e),a(s,Cs,e),a(s,nt,e),M(gs,s,e),a(s,it,e),a(s,bs,e),a(s,pt,e),a(s,Is,e),a(s,ot,e),M(vs,s,e),a(s,ct,e),M(As,s,e),a(s,rt,e),a(s,$s,e),a(s,Mt,e),a(s,ks,e),a(s,ut,e),M(_s,s,e),a(s,yt,e),a(s,xs,e),a(s,mt,e),M(qs,s,e),a(s,ht,e),a(s,Ws,e),a(s,dt,e),M(Zs,s,e),a(s,jt,e),a(s,Hs,e),a(s,Ut,e),M(Bs,s,e),a(s,Tt,e),a(s,Es,e),a(s,Jt,e),a(s,Ys,e),a(s,ft,e),M(Gs,s,e),a(s,wt,e),a(s,Vs,e),a(s,Ct,e),a(s,J,e),a(s,gt,e),M(Qs,s,e),a(s,bt,e),a(s,Rs,e),a(s,It,e),a(s,Ss,e),a(s,vt,e),M(Xs,s,e),a(s,At,e),a(s,Ns,e),a(s,$t,e),M(zs,s,e),a(s,kt,e),a(s,Fs,e),a(s,_t,e),M(Ls,s,e),a(s,xt,e),a(s,Ds,e),qt=!0},p:_a,i(s){qt||(u(f.$$.fragment,s),u(C.$$.fragment,s),u(A.$$.fragment,s),u(k.$$.fragment,s),u(x.$$.fragment,s),u(q.$$.fragment,s),u(Z.$$.fragment,s),u(B.$$.fragment,s),u(Y.$$.fragment,s),u(G.$$.fragment,s),u(S.$$.fragment,s),u(N.$$.fragment,s),u(F.$$.fragment,s),u(L.$$.fragment,s),u(O.$$.fragment,s),u(es.$$.fragment,s),u(as.$$.fragment,s),u(ns.$$.fragment,s),u(ps.$$.fragment,s),u(cs.$$.fragment,s),u(rs.$$.fragment,s),u(hs.$$.fragment,s),u(js.$$.fragment,s),u(Ts.$$.fragment,s),u(Js.$$.fragment,s),u(ws.$$.fragment,s),u(gs.$$.fragment,s),u(vs.$$.fragment,s),u(As.$$.fragment,s),u(_s.$$.fragment,s),u(qs.$$.fragment,s),u(Zs.$$.fragment,s),u(Bs.$$.fragment,s),u(Gs.$$.fragment,s),u(Qs.$$.fragment,s),u(Xs.$$.fragment,s),u(zs.$$.fragment,s),u(Ls.$$.fragment,s),qt=!0)},o(s){y(f.$$.fragment,s),y(C.$$.fragment,s),y(A.$$.fragment,s),y(k.$$.fragment,s),y(x.$$.fragment,s),y(q.$$.fragment,s),y(Z.$$.fragment,s),y(B.$$.fragment,s),y(Y.$$.fragment,s),y(G.$$.fragment,s),y(S.$$.fragment,s),y(N.$$.fragment,s),y(F.$$.fragment,s),y(L.$$.fragment,s),y(O.$$.fragment,s),y(es.$$.fragment,s),y(as.$$.fragment,s),y(ns.$$.fragment,s),y(ps.$$.fragment,s),y(cs.$$.fragment,s),y(rs.$$.fragment,s),y(hs.$$.fragment,s),y(js.$$.fragment,s),y(Ts.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(gs.$$.fragment,s),y(vs.$$.fragment,s),y(As.$$.fragment,s),y(_s.$$.fragment,s),y(qs.$$.fragment,s),y(Zs.$$.fragment,s),y(Bs.$$.fragment,s),y(Gs.$$.fragment,s),y(Qs.$$.fragment,s),y(Xs.$$.fragment,s),y(zs.$$.fragment,s),y(Ls.$$.fragment,s),qt=!1},d(s){s&&(t(Os),t(Ps),t(se),t(ee),t(w),t(te),t(ae),t(g),t(le),t(b),t(ne),t(I),t(ie),t(U),t(pe),t(v),t(oe),t(ce),t($),t(re),t(Me),t(_),t(ue),t(ye),t(me),t(W),t(he),t(de),t(H),t(je),t(Ue),t(E),t(Te),t(Je),t(fe),t(V),t(we),t(Q),t(Ce),t(R),t(ge),t(be),t(X),t(Ie),t(ve),t(z),t(Ae),t($e),t(T),t(ke),t(_e),t(P),t(xe),t(D),t(qe),t(K),t(We),t(Ze),t(ss),t(He),t(Be),t(ts),t(Ee),t(Ye),t(ls),t(Ge),t(Ve),t(is),t(Qe),t(Re),t(os),t(Se),t(Xe),t(Ne),t(Ms),t(ze),t(us),t(Fe),t(ys),t(Le),t(ms),t(Pe),t(De),t(ds),t(Ke),t(Oe),t(Us),t(st),t(et),t(tt),t(fs),t(at),t(lt),t(Cs),t(nt),t(it),t(bs),t(pt),t(Is),t(ot),t(ct),t(rt),t($s),t(Mt),t(ks),t(ut),t(yt),t(xs),t(mt),t(ht),t(Ws),t(dt),t(jt),t(Hs),t(Ut),t(Tt),t(Es),t(Jt),t(Ys),t(ft),t(wt),t(Vs),t(Ct),t(J),t(gt),t(bt),t(Rs),t(It),t(Ss),t(vt),t(At),t(Ns),t($t),t(kt),t(Fs),t(_t),t(xt),t(Ds)),t(j),m(f,s),m(C,s),m(A,s),m(k,s),m(x,s),m(q,s),m(Z,s),m(B,s),m(Y,s),m(G,s),m(S,s),m(N,s),m(F,s),m(L,s),m(O,s),m(es,s),m(as,s),m(ns,s),m(ps,s),m(cs,s),m(rs,s),m(hs,s),m(js,s),m(Ts,s),m(Js,s),m(ws,s),m(gs,s),m(vs,s),m(As,s),m(_s,s),m(qs,s),m(Zs,s),m(Bs,s),m(Gs,s),m(Qs,s),m(Xs,s),m(zs,s),m(Ls,s)}}}const Ya='{"title":"A quick tour","local":"a-quick-tour","sections":[{"title":"Types of evaluations","local":"types-of-evaluations","sections":[],"depth":2},{"title":"Load","local":"load","sections":[{"title":"Community modules","local":"community-modules","sections":[],"depth":3},{"title":"List available modules","local":"list-available-modules","sections":[],"depth":3}],"depth":2},{"title":"Module attributes","local":"module-attributes","sections":[],"depth":2},{"title":"Compute","local":"compute","sections":[{"title":"How to compute","local":"how-to-compute","sections":[],"depth":3},{"title":"Calculate a single metric or a batch of metrics","local":"calculate-a-single-metric-or-a-batch-of-metrics","sections":[],"depth":3},{"title":"Distributed evaluation","local":"distributed-evaluation","sections":[],"depth":3}],"depth":2},{"title":"Combining several evaluations","local":"combining-several-evaluations","sections":[],"depth":2},{"title":"Save and push to the Hub","local":"save-and-push-to-the-hub","sections":[],"depth":2},{"title":"Evaluator","local":"evaluator","sections":[],"depth":2},{"title":"Visualization","local":"visualization","sections":[],"depth":2},{"title":"Running evaluation on a suite of tasks","local":"running-evaluation-on-a-suite-of-tasks","sections":[],"depth":2}],"depth":1}';function Ga(Wt){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends qa{constructor(j){super(),Wa(this,j,Ga,Ea,ka,{})}}export{Xa as component};
