# Built-in Tools

Ready-to-use tool implementations provided by the `smolagents` library.

These built-in tools are concrete implementations of the [Tool](/docs/smolagents/v1.22.0/en/reference/tools#smolagents.Tool) base class, each designed for specific tasks such as web searching, Python code execution, webpage retrieval, and user interaction.
You can use these tools directly in your agents without having to implement the underlying functionality yourself.
Each tool handles a particular capability and follows a consistent interface, making it easy to compose them into powerful agent workflows.

The built-in tools can be categorized by their primary functions:
- **Information Retrieval**: Search and retrieve information from the web and specific knowledge sources.
  - [ApiWebSearchTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.ApiWebSearchTool)
  - [DuckDuckGoSearchTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.DuckDuckGoSearchTool)
  - [GoogleSearchTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.GoogleSearchTool)
  - [WebSearchTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.WebSearchTool)
  - [WikipediaSearchTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.WikipediaSearchTool)
- **Web Interaction**: Fetch and process content from specific web pages.
  - [VisitWebpageTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.VisitWebpageTool)
- **Code Execution**: Dynamic execution of Python code for computational tasks.
  - [PythonInterpreterTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.PythonInterpreterTool)
- **User Interaction**: Enable Human-in-the-Loop collaboration between agents and users.
  - [UserInputTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.UserInputTool): Collect input from users.
- **Speech Processing**: Convert audio to textual data.
  - [SpeechToTextTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.SpeechToTextTool)
- **Workflow Control**: Manage and direct the flow of agent operations.
  - [FinalAnswerTool](/docs/smolagents/v1.22.0/en/reference/default_tools#smolagents.FinalAnswerTool): Conclude agent workflow with final response.

## ApiWebSearchTool[[smolagents.ApiWebSearchTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.ApiWebSearchTool</name><anchor>smolagents.ApiWebSearchTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L246</source><parameters>[{"name": "endpoint", "val": ": str = ''"}, {"name": "api_key", "val": ": str = ''"}, {"name": "api_key_name", "val": ": str = ''"}, {"name": "headers", "val": ": dict = None"}, {"name": "params", "val": ": dict = None"}, {"name": "rate_limit", "val": ": float | None = 1.0"}]</parameters><paramsdesc>- **endpoint** (`str`) -- API endpoint URL. Defaults to Brave Search API.
- **api_key** (`str`) -- API key for authentication.
- **api_key_name** (`str`) -- Environment variable name containing the API key. Defaults to "BRAVE_API_KEY".
- **headers** (`dict`, *optional*) -- Headers for API requests.
- **params** (`dict`, *optional*) -- Parameters for API requests.
- **rate_limit** (`float`, default `1.0`) -- Maximum queries per second. Set to `None` to disable rate limiting.</paramsdesc><paramgroups>0</paramgroups></docstring>
Web search tool that performs API-based searches.
By default, it uses the Brave Search API.

This tool implements a rate limiting mechanism to ensure compliance with API usage policies.
By default, it limits requests to 1 query per second.



<ExampleCodeBlock anchor="smolagents.ApiWebSearchTool.example">

Examples:
```python
>>> from smolagents import ApiWebSearchTool
>>> web_search_tool = ApiWebSearchTool(rate_limit=50.0)
>>> results = web_search_tool("Hugging Face")
>>> print(results)
```

</ExampleCodeBlock>


</div>

## DuckDuckGoSearchTool[[smolagents.DuckDuckGoSearchTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.DuckDuckGoSearchTool</name><anchor>smolagents.DuckDuckGoSearchTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L101</source><parameters>[{"name": "max_results", "val": ": int = 10"}, {"name": "rate_limit", "val": ": float | None = 1.0"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **max_results** (`int`, default `10`) -- Maximum number of search results to return.
- **rate_limit** (`float`, default `1.0`) -- Maximum queries per second. Set to `None` to disable rate limiting.
- ****kwargs** -- Additional keyword arguments for the `DDGS` client.</paramsdesc><paramgroups>0</paramgroups></docstring>
Web search tool that performs searches using the DuckDuckGo search engine.



<ExampleCodeBlock anchor="smolagents.DuckDuckGoSearchTool.example">

Examples:
```python
>>> from smolagents import DuckDuckGoSearchTool
>>> web_search_tool = DuckDuckGoSearchTool(max_results=5, rate_limit=2.0)
>>> results = web_search_tool("Hugging Face")
>>> print(results)
```

</ExampleCodeBlock>


</div>

## FinalAnswerTool[[smolagents.FinalAnswerTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.FinalAnswerTool</name><anchor>smolagents.FinalAnswerTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L80</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## GoogleSearchTool[[smolagents.GoogleSearchTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.GoogleSearchTool</name><anchor>smolagents.GoogleSearchTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L159</source><parameters>[{"name": "provider", "val": ": str = 'serpapi'"}]</parameters></docstring>


</div>

## PythonInterpreterTool[[smolagents.PythonInterpreterTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.PythonInterpreterTool</name><anchor>smolagents.PythonInterpreterTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L38</source><parameters>[{"name": "*args", "val": ""}, {"name": "authorized_imports", "val": " = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## SpeechToTextTool[[smolagents.SpeechToTextTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.SpeechToTextTool</name><anchor>smolagents.SpeechToTextTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L606</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## UserInputTool[[smolagents.UserInputTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.UserInputTool</name><anchor>smolagents.UserInputTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L90</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## VisitWebpageTool[[smolagents.VisitWebpageTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.VisitWebpageTool</name><anchor>smolagents.VisitWebpageTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L451</source><parameters>[{"name": "max_output_length", "val": ": int = 40000"}]</parameters></docstring>


</div>

## WebSearchTool[[smolagents.WebSearchTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.WebSearchTool</name><anchor>smolagents.WebSearchTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L339</source><parameters>[{"name": "max_results", "val": ": int = 10"}, {"name": "engine", "val": ": str = 'duckduckgo'"}]</parameters></docstring>


</div>

## WikipediaSearchTool[[smolagents.WikipediaSearchTool]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.WikipediaSearchTool</name><anchor>smolagents.WikipediaSearchTool</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/default_tools.py#L507</source><parameters>[{"name": "user_agent", "val": ": str = 'Smolagents (myemail@example.com)'"}, {"name": "language", "val": ": str = 'en'"}, {"name": "content_type", "val": ": str = 'text'"}, {"name": "extract_format", "val": ": str = 'WIKI'"}]</parameters><paramsdesc>- **user_agent** (`str`) -- Custom user-agent string to identify the project. This is required as per Wikipedia API policies.
  See: https://foundation.wikimedia.org/wiki/Policy:Wikimedia_Foundation_User-Agent_Policy
- **language** (`str`, default `"en"`) -- Language in which to retrieve Wikipedia article.
  See: http://meta.wikimedia.org/wiki/List_of_Wikipedias
- **content_type** (`Literal["summary", "text"]`, default `"text"`) -- Type of content to fetch. Can be "summary" for a short summary or "text" for the full article.
- **extract_format** (`Literal["HTML", "WIKI"]`, default `"WIKI"`) -- Extraction format of the output. Can be `"WIKI"` or `"HTML"`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Search Wikipedia and return the summary or full text of the requested article, along with the page URL.



<ExampleCodeBlock anchor="smolagents.WikipediaSearchTool.example">

Example:
```python
>>> from smolagents import CodeAgent, InferenceClientModel, WikipediaSearchTool
>>> agent = CodeAgent(
>>>     tools=[
>>>            WikipediaSearchTool(
>>>                user_agent="MyResearchBot (myemail@example.com)",
>>>                language="en",
>>>                content_type="summary",  # or "text"
>>>                extract_format="WIKI",
>>>            )
>>>        ],
>>>     model=InferenceClientModel(),
>>> )
>>> agent.run("Python_(programming_language)")
```

</ExampleCodeBlock>


</div>

<EditOnGithub source="https://github.com/huggingface/smolagents/blob/main/docs/source/en/reference/default_tools.md" />