import{s as ln,o as cn,n as x}from"../chunks/scheduler.9bc65507.js";import{S as dn,i as mn,g as m,s as a,r as p,A as fn,h as f,f as r,c as i,j as $,u as h,x as F,k as v,y as c,a as d,v as g,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as Se}from"../chunks/Tip.c2ecdbf4.js";import{D as W}from"../chunks/Docstring.17db21ae.js";import{C as De}from"../chunks/CodeBlock.54a9f38d.js";import{E as Qe}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as O}from"../chunks/Heading.342b1fa6.js";function pn(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVmZmljaWVudEZvcm1lckNvbmZpZyUyQyUyMEVmZmljaWVudEZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEVmZmljaWVudEZvcm1lciUyMGVmZmljaWVudGZvcm1lci1sMSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBFZmZpY2llbnRGb3JtZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBFZmZpY2llbnRGb3JtZXJNb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZWZmaWNpZW50Zm9ybWVyLWwzJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnRGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EfficientFormerConfig, EfficientFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a EfficientFormer efficientformer-l1 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = EfficientFormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a EfficientFormerModel (with random weights) from the efficientformer-l3 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function hn(M){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function gn(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudEZvcm1lck1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEFtb2RlbCUyMCUzRCUyMEVmZmljaWVudEZvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerModel.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">448</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function un(M){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function _n(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudEZvcm1lckZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQW1vZGVsJTIwJTNEJTIwRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc25hcC1yZXNlYXJjaCUyRmVmZmljaWVudGZvcm1lci1sMS0zMDAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientFormerForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerForImageClassification.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
Egyptian cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function bn(M){let t,y=`This model supports inference-only. Fine-tuning with distillation (i.e. with a teacher) is not yet
supported.`;return{c(){t=m("p"),t.textContent=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-1gp6z48"&&(t.textContent=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function yn(M){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function Tn(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudEZvcm1lckZvckltYWdlQ2xhc3NpZmljYXRpb25XaXRoVGVhY2hlciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc25hcC1yZXNlYXJjaCUyRmVmZmljaWVudGZvcm1lci1sMS0zMDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnRGb3JtZXJGb3JJbWFnZUNsYXNzaWZpY2F0aW9uV2l0aFRlYWNoZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientFormerForImageClassificationWithTeacher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerForImageClassificationWithTeacher.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
Egyptian cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function Fn(M){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function wn(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRWZmaWNpZW50Rm9ybWVyTW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGRWZmaWNpZW50Rm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFEfficientFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFEfficientFormerModel.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">448</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function Mn(M){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function $n(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc25hcC1yZXNlYXJjaCUyRmVmZmljaWVudGZvcm1lci1sMS0zMDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkVmZmljaWVudEZvcm1lckZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFEfficientFormerForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFEfficientFormerForImageClassification.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_281`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function vn(M){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=y},l(s){t=f(s,"P",{"data-svelte-h":!0}),F(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(s,l){d(s,t,l)},p:x,d(s){s&&r(t)}}}function Cn(M){let t,y="Example:",s,l,T;return l=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbldpdGhUZWFjaGVyJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbldpdGhUZWFjaGVyLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSkpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFEfficientFormerForImageClassificationWithTeacher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFEfficientFormerForImageClassificationWithTeacher.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_281`,wrap:!1}}),{c(){t=m("p"),t.textContent=y,s=a(),p(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),F(t)!=="svelte-11lpom8"&&(t.textContent=y),s=i(o),h(l.$$.fragment,o)},m(o,w){d(o,t,w),d(o,s,w),g(l,o,w),T=!0},p:x,i(o){T||(u(l.$$.fragment,o),T=!0)},o(o){_(l.$$.fragment,o),T=!1},d(o){o&&(r(t),r(s)),b(l,o)}}}function En(M){let t,y,s,l,T,o,w,Tt,be,Uo=`The EfficientFormer model was proposed in <a href="https://arxiv.org/abs/2206.01191" rel="nofollow">EfficientFormer: Vision Transformers at MobileNet Speed</a>
by Yanyu Li, Geng Yuan, Yang Wen, Eric Hu, Georgios Evangelidis, Sergey Tulyakov, Yanzhi Wang, Jian Ren.  EfficientFormer proposes a
dimension-consistent pure transformer that can be run on mobile devices for dense prediction tasks like image classification, object
detection and semantic segmentation.`,Ft,ye,zo="The abstract from the paper is the following:",wt,Te,Vo=`<em>Vision Transformers (ViT) have shown rapid progress in computer vision tasks, achieving promising results on various benchmarks.
However, due to the massive number of parameters and model design, e.g., attention mechanism, ViT-based models are generally
times slower than lightweight convolutional networks. Therefore, the deployment of ViT for real-time applications is particularly
challenging, especially on resource-constrained hardware such as mobile devices. Recent efforts try to reduce the computation
complexity of ViT through network architecture search or hybrid design with MobileNet block, yet the inference speed is still
unsatisfactory. This leads to an important question: can transformers run as fast as MobileNet while obtaining high performance?
To answer this, we first revisit the network architecture and operators used in ViT-based models and identify inefficient designs.
Then we introduce a dimension-consistent pure transformer (without MobileNet blocks) as a design paradigm.
Finally, we perform latency-driven slimming to get a series of final models dubbed EfficientFormer.
Extensive experiments show the superiority of EfficientFormer in performance and speed on mobile devices.
Our fastest model, EfficientFormer-L1, achieves 79.2% top-1 accuracy on ImageNet-1K with only 1.6 ms inference latency on
iPhone 12 (compiled with CoreML), which { runs as fast as MobileNetV2×1.4 (1.6 ms, 74.7% top-1),} and our largest model,
EfficientFormer-L7, obtains 83.3% accuracy with only 7.0 ms latency. Our work proves that properly designed transformers can
reach extremely low latency on mobile devices while maintaining high performance.</em>`,Mt,Fe,No=`This model was contributed by <a href="https://huggingface.co/novice03" rel="nofollow">novice03</a> and <a href="https://huggingface.co/Bearnardd" rel="nofollow">Bearnardd</a>.
The original code can be found <a href="https://github.com/snap-research/EfficientFormer" rel="nofollow">here</a>. The TensorFlow version of this model was added by <a href="https://huggingface.co/D-Roberts" rel="nofollow">D-Roberts</a>.`,$t,we,vt,Me,ko='<li><a href="../tasks/image_classification">Image classification task guide</a></li>',Ct,$e,Et,j,ve,qt,Ae,Ro=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a>. It is used to
instantiate an EfficientFormer model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the EfficientFormer
<a href="https://huggingface.co/snap-research/efficientformer-l1" rel="nofollow">snap-research/efficientformer-l1</a> architecture.`,Xt,Oe,Go=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ht,ne,Wt,Ce,It,P,Ee,Yt,Ke,Po="Constructs a EfficientFormer image processor.",St,se,We,Qt,et,Bo="Preprocess an image or batch of images.",xt,Ie,jt,B,xe,Dt,tt,Lo=`The bare EfficientFormer Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#nn.Module" rel="nofollow">nn.Module</a> subclass. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,At,V,je,Ot,ot,qo='The <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Kt,re,eo,ae,Zt,Ze,Jt,Z,Je,to,nt,Xo=`EfficientFormer Model transformer with an image classification head on top (a linear layer on top of the final
hidden state of the [CLS] token) e.g. for ImageNet.`,oo,st,Ho=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#nn.Module" rel="nofollow">nn.Module</a> subclass. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,no,N,Ue,so,rt,Yo='The <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassification">EfficientFormerForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',ro,ie,ao,le,Ut,ze,zt,C,Ve,io,at,So=`EfficientFormer Model transformer with image classification heads on top (a linear layer on top of the final hidden
state of the [CLS] token and a linear layer on top of the final hidden state of the distillation token) e.g. for
ImageNet.`,lo,ce,co,it,Qo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#nn.Module" rel="nofollow">nn.Module</a> subclass. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,mo,k,Ne,fo,lt,Do='The <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a> forward method, overrides the <code>__call__</code> special method.',po,de,ho,me,Vt,ke,Nt,L,Re,go,ct,Ao=`The bare EfficientFormer Model transformer outputting raw hidden-states without any specific head on top.
This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,uo,R,Ge,_o,dt,Oo='The <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> forward method, overrides the <code>__call__</code> special method.',bo,fe,yo,pe,kt,Pe,Rt,J,Be,To,mt,Ko=`EfficientFormer Model transformer with an image classification head on top of pooled last hidden state, e.g. for
ImageNet.`,Fo,ft,en=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,wo,G,Le,Mo,pt,tn='The <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassification">TFEfficientFormerForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',$o,he,vo,ge,Gt,qe,Pt,E,Xe,Co,ht,on=`EfficientFormer Model transformer with image classification heads on top (a linear layer on top of the final hidden
state and a linear layer on top of the final hidden state of the distillation token) e.g. for ImageNet.`,Eo,gt,nn=`.. warning::
This model supports inference-only. Fine-tuning with distillation (i.e. with a teacher) is not yet
supported.`,Wo,ut,sn=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,Io,I,He,xo,_t,rn='The <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassificationWithTeacher">TFEfficientFormerForImageClassificationWithTeacher</a> forward method, overrides the <code>__call__</code> special method.',jo,ue,Zo,bt,an=`<li><strong>Output</strong> type of <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a>.
logits (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores as the average of the cls_logits and distillation logits.
cls_logits (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the classification head (i.e. the linear layer on top of the final hidden state of the
class token).
distillation_logits (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the distillation head (i.e. the linear layer on top of the final hidden state of the
distillation token).
hidden_states (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when
<code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.
attentions (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when
<code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>`,Jo,_e,Bt,yt,Lt;return T=new O({props:{title:"EfficientFormer",local:"efficientformer",headingTag:"h1"}}),w=new O({props:{title:"Overview",local:"overview",headingTag:"h2"}}),we=new O({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),$e=new O({props:{title:"EfficientFormerConfig",local:"transformers.EfficientFormerConfig",headingTag:"h2"}}),ve=new W({props:{name:"class transformers.EfficientFormerConfig",anchor:"transformers.EfficientFormerConfig",parameters:[{name:"depths",val:": typing.List[int] = [3, 2, 6, 4]"},{name:"hidden_sizes",val:": typing.List[int] = [48, 96, 224, 448]"},{name:"downsamples",val:": typing.List[bool] = [True, True, True, True]"},{name:"dim",val:": int = 448"},{name:"key_dim",val:": int = 32"},{name:"attention_ratio",val:": int = 4"},{name:"resolution",val:": int = 7"},{name:"num_hidden_layers",val:": int = 5"},{name:"num_attention_heads",val:": int = 8"},{name:"mlp_expansion_ratio",val:": int = 4"},{name:"hidden_dropout_prob",val:": float = 0.0"},{name:"patch_size",val:": int = 16"},{name:"num_channels",val:": int = 3"},{name:"pool_size",val:": int = 3"},{name:"downsample_patch_size",val:": int = 3"},{name:"downsample_stride",val:": int = 2"},{name:"downsample_pad",val:": int = 1"},{name:"drop_path_rate",val:": float = 0.0"},{name:"num_meta3d_blocks",val:": int = 1"},{name:"distillation",val:": bool = True"},{name:"use_layer_scale",val:": bool = True"},{name:"layer_scale_init_value",val:": float = 1e-05"},{name:"hidden_act",val:": str = 'gelu'"},{name:"initializer_range",val:": float = 0.02"},{name:"layer_norm_eps",val:": float = 1e-12"},{name:"image_size",val:": int = 224"},{name:"batch_norm_eps",val:": float = 1e-05"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientFormerConfig.depths",description:`<strong>depths</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[3, 2, 6, 4]</code>) &#x2014;
Depth of each stage.`,name:"depths"},{anchor:"transformers.EfficientFormerConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[48, 96, 224, 448]</code>) &#x2014;
Dimensionality of each stage.`,name:"hidden_sizes"},{anchor:"transformers.EfficientFormerConfig.downsamples",description:`<strong>downsamples</strong> (<code>List(bool)</code>, <em>optional</em>, defaults to <code>[True, True, True, True]</code>) &#x2014;
Whether or not to downsample inputs between two stages.`,name:"downsamples"},{anchor:"transformers.EfficientFormerConfig.dim",description:`<strong>dim</strong> (<code>int</code>, <em>optional</em>, defaults to 448) &#x2014;
Number of channels in Meta3D layers`,name:"dim"},{anchor:"transformers.EfficientFormerConfig.key_dim",description:`<strong>key_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size of the key in meta3D block.`,name:"key_dim"},{anchor:"transformers.EfficientFormerConfig.attention_ratio",description:`<strong>attention_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Ratio of the dimension of the query and value to the dimension of the key in MSHA block`,name:"attention_ratio"},{anchor:"transformers.EfficientFormerConfig.resolution",description:`<strong>resolution</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of each patch`,name:"resolution"},{anchor:"transformers.EfficientFormerConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.EfficientFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the 3D MetaBlock.`,name:"num_attention_heads"},{anchor:"transformers.EfficientFormerConfig.mlp_expansion_ratio",description:`<strong>mlp_expansion_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Ratio of size of the hidden dimensionality of an MLP to the dimensionality of its input.`,name:"mlp_expansion_ratio"},{anchor:"transformers.EfficientFormerConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.EfficientFormerConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.EfficientFormerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.EfficientFormerConfig.pool_size",description:`<strong>pool_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Kernel size of pooling layers.`,name:"pool_size"},{anchor:"transformers.EfficientFormerConfig.downsample_patch_size",description:`<strong>downsample_patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The size of patches in downsampling layers.`,name:"downsample_patch_size"},{anchor:"transformers.EfficientFormerConfig.downsample_stride",description:`<strong>downsample_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The stride of convolution kernels in downsampling layers.`,name:"downsample_stride"},{anchor:"transformers.EfficientFormerConfig.downsample_pad",description:`<strong>downsample_pad</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding in downsampling layers.`,name:"downsample_pad"},{anchor:"transformers.EfficientFormerConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Rate at which to increase dropout probability in DropPath.`,name:"drop_path_rate"},{anchor:"transformers.EfficientFormerConfig.num_meta3d_blocks",description:`<strong>num_meta3d_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of 3D MetaBlocks in the last stage.`,name:"num_meta3d_blocks"},{anchor:"transformers.EfficientFormerConfig.distillation",description:`<strong>distillation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a distillation head.`,name:"distillation"},{anchor:"transformers.EfficientFormerConfig.use_layer_scale",description:`<strong>use_layer_scale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to scale outputs from token mixers.`,name:"use_layer_scale"},{anchor:"transformers.EfficientFormerConfig.layer_scale_init_value",description:`<strong>layer_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
Factor by which outputs from token mixers are scaled.`,name:"layer_scale_init_value"},{anchor:"transformers.EfficientFormerConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.EfficientFormerConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.EfficientFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.EfficientFormerConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>224</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/configuration_efficientformer.py#L32"}}),ne=new Qe({props:{anchor:"transformers.EfficientFormerConfig.example",$$slots:{default:[pn]},$$scope:{ctx:M}}}),Ce=new O({props:{title:"EfficientFormerImageProcessor",local:"transformers.EfficientFormerImageProcessor",headingTag:"h2"}}),Ee=new W({props:{name:"class transformers.EfficientFormerImageProcessor",anchor:"transformers.EfficientFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.EfficientFormerImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.EfficientFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.EfficientFormerImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.EfficientFormerImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.EfficientFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.EfficientFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.EfficientFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.EfficientFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/image_processing_efficientformer.py#L45"}}),We=new W({props:{name:"preprocess",anchor:"transformers.EfficientFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientFormerImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PILImageResampling</code> filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/image_processing_efficientformer.py#L160"}}),Ie=new O({props:{title:"EfficientFormerModel",local:"transformers.EfficientFormerModel",headingTag:"h2"}}),xe=new W({props:{name:"class transformers.EfficientFormerModel",anchor:"transformers.EfficientFormerModel",parameters:[{name:"config",val:": EfficientFormerConfig"}],parametersDescription:[{anchor:"transformers.EfficientFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_efficientformer.py#L557"}}),je=new W({props:{name:"forward",anchor:"transformers.EfficientFormerModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor.preprocess">ViTImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.EfficientFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_efficientformer.py#L569",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Se({props:{$$slots:{default:[hn]},$$scope:{ctx:M}}}),ae=new Qe({props:{anchor:"transformers.EfficientFormerModel.forward.example",$$slots:{default:[gn]},$$scope:{ctx:M}}}),Ze=new O({props:{title:"EfficientFormerForImageClassification",local:"transformers.EfficientFormerForImageClassification",headingTag:"h2"}}),Je=new W({props:{name:"class transformers.EfficientFormerForImageClassification",anchor:"transformers.EfficientFormerForImageClassification",parameters:[{name:"config",val:": EfficientFormerConfig"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_efficientformer.py#L619"}}),Ue=new W({props:{name:"forward",anchor:"transformers.EfficientFormerForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor.preprocess">ViTImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientFormerForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.EfficientFormerForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientFormerForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.EfficientFormerForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_efficientformer.py#L634",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Se({props:{$$slots:{default:[un]},$$scope:{ctx:M}}}),le=new Qe({props:{anchor:"transformers.EfficientFormerForImageClassification.forward.example",$$slots:{default:[_n]},$$scope:{ctx:M}}}),ze=new O({props:{title:"EfficientFormerForImageClassificationWithTeacher",local:"transformers.EfficientFormerForImageClassificationWithTeacher",headingTag:"h2"}}),Ve=new W({props:{name:"class transformers.EfficientFormerForImageClassificationWithTeacher",anchor:"transformers.EfficientFormerForImageClassificationWithTeacher",parameters:[{name:"config",val:": EfficientFormerConfig"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_efficientformer.py#L749"}}),ce=new Se({props:{warning:!0,$$slots:{default:[bn]},$$scope:{ctx:M}}}),Ne=new W({props:{name:"forward",anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor.preprocess">ViTImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_efficientformer.py#L766",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.efficientformer.modeling_efficientformer.EfficientFormerForImageClassificationWithTeacherOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores as the average of the cls_logits and distillation logits.</li>
<li><strong>cls_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the classification head (i.e. the linear layer on top of the final hidden state of the
class token).</li>
<li><strong>distillation_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the distillation head (i.e. the linear layer on top of the final hidden state of the
distillation token).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.efficientformer.modeling_efficientformer.EfficientFormerForImageClassificationWithTeacherOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new Se({props:{$$slots:{default:[yn]},$$scope:{ctx:M}}}),me=new Qe({props:{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.example",$$slots:{default:[Tn]},$$scope:{ctx:M}}}),ke=new O({props:{title:"TFEfficientFormerModel",local:"transformers.TFEfficientFormerModel",headingTag:"h2"}}),Re=new W({props:{name:"class transformers.TFEfficientFormerModel",anchor:"transformers.TFEfficientFormerModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFEfficientFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L775"}}),Ge=new W({props:{name:"call",anchor:"transformers.TFEfficientFormerModel.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFEfficientFormerModel.call.pixel_values",description:`<strong>pixel_values</strong> ((<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">EfficientFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFEfficientFormerModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFEfficientFormerModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFEfficientFormerModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),fe=new Se({props:{$$slots:{default:[Fn]},$$scope:{ctx:M}}}),pe=new Qe({props:{anchor:"transformers.TFEfficientFormerModel.call.example",$$slots:{default:[wn]},$$scope:{ctx:M}}}),Pe=new O({props:{title:"TFEfficientFormerForImageClassification",local:"transformers.TFEfficientFormerForImageClassification",headingTag:"h2"}}),Be=new W({props:{name:"class transformers.TFEfficientFormerForImageClassification",anchor:"transformers.TFEfficientFormerForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L815"}}),Le=new W({props:{name:"call",anchor:"transformers.TFEfficientFormerForImageClassification.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"labels",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> ((<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">EfficientFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L829",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_tf_outputs.TFImageClassifierOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called
feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_tf_outputs.TFImageClassifierOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),he=new Se({props:{$$slots:{default:[Mn]},$$scope:{ctx:M}}}),ge=new Qe({props:{anchor:"transformers.TFEfficientFormerForImageClassification.call.example",$$slots:{default:[$n]},$$scope:{ctx:M}}}),qe=new O({props:{title:"TFEfficientFormerForImageClassificationWithTeacher",local:"transformers.TFEfficientFormerForImageClassificationWithTeacher",headingTag:"h2"}}),Xe=new W({props:{name:"class transformers.TFEfficientFormerForImageClassificationWithTeacher",anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L920"}}),He=new W({props:{name:"call",anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.pixel_values",description:`<strong>pixel_values</strong> ((<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">EfficientFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L939",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.efficientformer.modeling_tf_efficientformer.TFEfficientFormerForImageClassificationWithTeacherOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.efficientformer.modeling_tf_efficientformer.TFEfficientFormerForImageClassificationWithTeacherOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),ue=new Se({props:{$$slots:{default:[vn]},$$scope:{ctx:M}}}),_e=new Qe({props:{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.example",$$slots:{default:[Cn]},$$scope:{ctx:M}}}),{c(){t=m("meta"),y=a(),s=m("p"),l=a(),p(T.$$.fragment),o=a(),p(w.$$.fragment),Tt=a(),be=m("p"),be.innerHTML=Uo,Ft=a(),ye=m("p"),ye.textContent=zo,wt=a(),Te=m("p"),Te.innerHTML=Vo,Mt=a(),Fe=m("p"),Fe.innerHTML=No,$t=a(),p(we.$$.fragment),vt=a(),Me=m("ul"),Me.innerHTML=ko,Ct=a(),p($e.$$.fragment),Et=a(),j=m("div"),p(ve.$$.fragment),qt=a(),Ae=m("p"),Ae.innerHTML=Ro,Xt=a(),Oe=m("p"),Oe.innerHTML=Go,Ht=a(),p(ne.$$.fragment),Wt=a(),p(Ce.$$.fragment),It=a(),P=m("div"),p(Ee.$$.fragment),Yt=a(),Ke=m("p"),Ke.textContent=Po,St=a(),se=m("div"),p(We.$$.fragment),Qt=a(),et=m("p"),et.textContent=Bo,xt=a(),p(Ie.$$.fragment),jt=a(),B=m("div"),p(xe.$$.fragment),Dt=a(),tt=m("p"),tt.innerHTML=Lo,At=a(),V=m("div"),p(je.$$.fragment),Ot=a(),ot=m("p"),ot.innerHTML=qo,Kt=a(),p(re.$$.fragment),eo=a(),p(ae.$$.fragment),Zt=a(),p(Ze.$$.fragment),Jt=a(),Z=m("div"),p(Je.$$.fragment),to=a(),nt=m("p"),nt.textContent=Xo,oo=a(),st=m("p"),st.innerHTML=Ho,no=a(),N=m("div"),p(Ue.$$.fragment),so=a(),rt=m("p"),rt.innerHTML=Yo,ro=a(),p(ie.$$.fragment),ao=a(),p(le.$$.fragment),Ut=a(),p(ze.$$.fragment),zt=a(),C=m("div"),p(Ve.$$.fragment),io=a(),at=m("p"),at.textContent=So,lo=a(),p(ce.$$.fragment),co=a(),it=m("p"),it.innerHTML=Qo,mo=a(),k=m("div"),p(Ne.$$.fragment),fo=a(),lt=m("p"),lt.innerHTML=Do,po=a(),p(de.$$.fragment),ho=a(),p(me.$$.fragment),Vt=a(),p(ke.$$.fragment),Nt=a(),L=m("div"),p(Re.$$.fragment),go=a(),ct=m("p"),ct.innerHTML=Ao,uo=a(),R=m("div"),p(Ge.$$.fragment),_o=a(),dt=m("p"),dt.innerHTML=Oo,bo=a(),p(fe.$$.fragment),yo=a(),p(pe.$$.fragment),kt=a(),p(Pe.$$.fragment),Rt=a(),J=m("div"),p(Be.$$.fragment),To=a(),mt=m("p"),mt.textContent=Ko,Fo=a(),ft=m("p"),ft.innerHTML=en,wo=a(),G=m("div"),p(Le.$$.fragment),Mo=a(),pt=m("p"),pt.innerHTML=tn,$o=a(),p(he.$$.fragment),vo=a(),p(ge.$$.fragment),Gt=a(),p(qe.$$.fragment),Pt=a(),E=m("div"),p(Xe.$$.fragment),Co=a(),ht=m("p"),ht.textContent=on,Eo=a(),gt=m("p"),gt.textContent=nn,Wo=a(),ut=m("p"),ut.innerHTML=sn,Io=a(),I=m("div"),p(He.$$.fragment),xo=a(),_t=m("p"),_t.innerHTML=rn,jo=a(),p(ue.$$.fragment),Zo=a(),bt=m("ul"),bt.innerHTML=an,Jo=a(),p(_e.$$.fragment),Bt=a(),yt=m("p"),this.h()},l(e){const n=fn("svelte-u9bgzb",document.head);t=f(n,"META",{name:!0,content:!0}),n.forEach(r),y=i(e),s=f(e,"P",{}),$(s).forEach(r),l=i(e),h(T.$$.fragment,e),o=i(e),h(w.$$.fragment,e),Tt=i(e),be=f(e,"P",{"data-svelte-h":!0}),F(be)!=="svelte-48qc0w"&&(be.innerHTML=Uo),Ft=i(e),ye=f(e,"P",{"data-svelte-h":!0}),F(ye)!=="svelte-vfdo9a"&&(ye.textContent=zo),wt=i(e),Te=f(e,"P",{"data-svelte-h":!0}),F(Te)!=="svelte-1w1hunj"&&(Te.innerHTML=Vo),Mt=i(e),Fe=f(e,"P",{"data-svelte-h":!0}),F(Fe)!=="svelte-e302oa"&&(Fe.innerHTML=No),$t=i(e),h(we.$$.fragment,e),vt=i(e),Me=f(e,"UL",{"data-svelte-h":!0}),F(Me)!=="svelte-1f2rorg"&&(Me.innerHTML=ko),Ct=i(e),h($e.$$.fragment,e),Et=i(e),j=f(e,"DIV",{class:!0});var q=$(j);h(ve.$$.fragment,q),qt=i(q),Ae=f(q,"P",{"data-svelte-h":!0}),F(Ae)!=="svelte-1jwsha1"&&(Ae.innerHTML=Ro),Xt=i(q),Oe=f(q,"P",{"data-svelte-h":!0}),F(Oe)!=="svelte-o55m63"&&(Oe.innerHTML=Go),Ht=i(q),h(ne.$$.fragment,q),q.forEach(r),Wt=i(e),h(Ce.$$.fragment,e),It=i(e),P=f(e,"DIV",{class:!0});var ee=$(P);h(Ee.$$.fragment,ee),Yt=i(ee),Ke=f(ee,"P",{"data-svelte-h":!0}),F(Ke)!=="svelte-48xdfc"&&(Ke.textContent=Po),St=i(ee),se=f(ee,"DIV",{class:!0});var Ye=$(se);h(We.$$.fragment,Ye),Qt=i(Ye),et=f(Ye,"P",{"data-svelte-h":!0}),F(et)!=="svelte-1x3yxsa"&&(et.textContent=Bo),Ye.forEach(r),ee.forEach(r),xt=i(e),h(Ie.$$.fragment,e),jt=i(e),B=f(e,"DIV",{class:!0});var te=$(B);h(xe.$$.fragment,te),Dt=i(te),tt=f(te,"P",{"data-svelte-h":!0}),F(tt)!=="svelte-adm7u9"&&(tt.innerHTML=Lo),At=i(te),V=f(te,"DIV",{class:!0});var X=$(V);h(je.$$.fragment,X),Ot=i(X),ot=f(X,"P",{"data-svelte-h":!0}),F(ot)!=="svelte-1xhmbgv"&&(ot.innerHTML=qo),Kt=i(X),h(re.$$.fragment,X),eo=i(X),h(ae.$$.fragment,X),X.forEach(r),te.forEach(r),Zt=i(e),h(Ze.$$.fragment,e),Jt=i(e),Z=f(e,"DIV",{class:!0});var H=$(Z);h(Je.$$.fragment,H),to=i(H),nt=f(H,"P",{"data-svelte-h":!0}),F(nt)!=="svelte-qa8pu3"&&(nt.textContent=Xo),oo=i(H),st=f(H,"P",{"data-svelte-h":!0}),F(st)!=="svelte-11dly9a"&&(st.innerHTML=Ho),no=i(H),N=f(H,"DIV",{class:!0});var Y=$(N);h(Ue.$$.fragment,Y),so=i(Y),rt=f(Y,"P",{"data-svelte-h":!0}),F(rt)!=="svelte-l11q55"&&(rt.innerHTML=Yo),ro=i(Y),h(ie.$$.fragment,Y),ao=i(Y),h(le.$$.fragment,Y),Y.forEach(r),H.forEach(r),Ut=i(e),h(ze.$$.fragment,e),zt=i(e),C=f(e,"DIV",{class:!0});var U=$(C);h(Ve.$$.fragment,U),io=i(U),at=f(U,"P",{"data-svelte-h":!0}),F(at)!=="svelte-105ubol"&&(at.textContent=So),lo=i(U),h(ce.$$.fragment,U),co=i(U),it=f(U,"P",{"data-svelte-h":!0}),F(it)!=="svelte-11dly9a"&&(it.innerHTML=Qo),mo=i(U),k=f(U,"DIV",{class:!0});var S=$(k);h(Ne.$$.fragment,S),fo=i(S),lt=f(S,"P",{"data-svelte-h":!0}),F(lt)!=="svelte-1jfqpqh"&&(lt.innerHTML=Do),po=i(S),h(de.$$.fragment,S),ho=i(S),h(me.$$.fragment,S),S.forEach(r),U.forEach(r),Vt=i(e),h(ke.$$.fragment,e),Nt=i(e),L=f(e,"DIV",{class:!0});var oe=$(L);h(Re.$$.fragment,oe),go=i(oe),ct=f(oe,"P",{"data-svelte-h":!0}),F(ct)!=="svelte-1nm4rof"&&(ct.innerHTML=Ao),uo=i(oe),R=f(oe,"DIV",{class:!0});var Q=$(R);h(Ge.$$.fragment,Q),_o=i(Q),dt=f(Q,"P",{"data-svelte-h":!0}),F(dt)!=="svelte-guhxz3"&&(dt.innerHTML=Oo),bo=i(Q),h(fe.$$.fragment,Q),yo=i(Q),h(pe.$$.fragment,Q),Q.forEach(r),oe.forEach(r),kt=i(e),h(Pe.$$.fragment,e),Rt=i(e),J=f(e,"DIV",{class:!0});var D=$(J);h(Be.$$.fragment,D),To=i(D),mt=f(D,"P",{"data-svelte-h":!0}),F(mt)!=="svelte-iwgv3e"&&(mt.textContent=Ko),Fo=i(D),ft=f(D,"P",{"data-svelte-h":!0}),F(ft)!=="svelte-1y4qz5o"&&(ft.innerHTML=en),wo=i(D),G=f(D,"DIV",{class:!0});var A=$(G);h(Le.$$.fragment,A),Mo=i(A),pt=f(A,"P",{"data-svelte-h":!0}),F(pt)!=="svelte-1ynqyg9"&&(pt.innerHTML=tn),$o=i(A),h(he.$$.fragment,A),vo=i(A),h(ge.$$.fragment,A),A.forEach(r),D.forEach(r),Gt=i(e),h(qe.$$.fragment,e),Pt=i(e),E=f(e,"DIV",{class:!0});var z=$(E);h(Xe.$$.fragment,z),Co=i(z),ht=f(z,"P",{"data-svelte-h":!0}),F(ht)!=="svelte-yw5jbc"&&(ht.textContent=on),Eo=i(z),gt=f(z,"P",{"data-svelte-h":!0}),F(gt)!=="svelte-tyl86q"&&(gt.textContent=nn),Wo=i(z),ut=f(z,"P",{"data-svelte-h":!0}),F(ut)!=="svelte-1y4qz5o"&&(ut.innerHTML=sn),Io=i(z),I=f(z,"DIV",{class:!0});var K=$(I);h(He.$$.fragment,K),xo=i(K),_t=f(K,"P",{"data-svelte-h":!0}),F(_t)!=="svelte-1lt049t"&&(_t.innerHTML=rn),jo=i(K),h(ue.$$.fragment,K),Zo=i(K),bt=f(K,"UL",{"data-svelte-h":!0}),F(bt)!=="svelte-1a3b7bw"&&(bt.innerHTML=an),Jo=i(K),h(_e.$$.fragment,K),K.forEach(r),z.forEach(r),Bt=i(e),yt=f(e,"P",{}),$(yt).forEach(r),this.h()},h(){v(t,"name","hf:doc:metadata"),v(t,"content",Wn),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){c(document.head,t),d(e,y,n),d(e,s,n),d(e,l,n),g(T,e,n),d(e,o,n),g(w,e,n),d(e,Tt,n),d(e,be,n),d(e,Ft,n),d(e,ye,n),d(e,wt,n),d(e,Te,n),d(e,Mt,n),d(e,Fe,n),d(e,$t,n),g(we,e,n),d(e,vt,n),d(e,Me,n),d(e,Ct,n),g($e,e,n),d(e,Et,n),d(e,j,n),g(ve,j,null),c(j,qt),c(j,Ae),c(j,Xt),c(j,Oe),c(j,Ht),g(ne,j,null),d(e,Wt,n),g(Ce,e,n),d(e,It,n),d(e,P,n),g(Ee,P,null),c(P,Yt),c(P,Ke),c(P,St),c(P,se),g(We,se,null),c(se,Qt),c(se,et),d(e,xt,n),g(Ie,e,n),d(e,jt,n),d(e,B,n),g(xe,B,null),c(B,Dt),c(B,tt),c(B,At),c(B,V),g(je,V,null),c(V,Ot),c(V,ot),c(V,Kt),g(re,V,null),c(V,eo),g(ae,V,null),d(e,Zt,n),g(Ze,e,n),d(e,Jt,n),d(e,Z,n),g(Je,Z,null),c(Z,to),c(Z,nt),c(Z,oo),c(Z,st),c(Z,no),c(Z,N),g(Ue,N,null),c(N,so),c(N,rt),c(N,ro),g(ie,N,null),c(N,ao),g(le,N,null),d(e,Ut,n),g(ze,e,n),d(e,zt,n),d(e,C,n),g(Ve,C,null),c(C,io),c(C,at),c(C,lo),g(ce,C,null),c(C,co),c(C,it),c(C,mo),c(C,k),g(Ne,k,null),c(k,fo),c(k,lt),c(k,po),g(de,k,null),c(k,ho),g(me,k,null),d(e,Vt,n),g(ke,e,n),d(e,Nt,n),d(e,L,n),g(Re,L,null),c(L,go),c(L,ct),c(L,uo),c(L,R),g(Ge,R,null),c(R,_o),c(R,dt),c(R,bo),g(fe,R,null),c(R,yo),g(pe,R,null),d(e,kt,n),g(Pe,e,n),d(e,Rt,n),d(e,J,n),g(Be,J,null),c(J,To),c(J,mt),c(J,Fo),c(J,ft),c(J,wo),c(J,G),g(Le,G,null),c(G,Mo),c(G,pt),c(G,$o),g(he,G,null),c(G,vo),g(ge,G,null),d(e,Gt,n),g(qe,e,n),d(e,Pt,n),d(e,E,n),g(Xe,E,null),c(E,Co),c(E,ht),c(E,Eo),c(E,gt),c(E,Wo),c(E,ut),c(E,Io),c(E,I),g(He,I,null),c(I,xo),c(I,_t),c(I,jo),g(ue,I,null),c(I,Zo),c(I,bt),c(I,Jo),g(_e,I,null),d(e,Bt,n),d(e,yt,n),Lt=!0},p(e,[n]){const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),ne.$set(q);const ee={};n&2&&(ee.$$scope={dirty:n,ctx:e}),re.$set(ee);const Ye={};n&2&&(Ye.$$scope={dirty:n,ctx:e}),ae.$set(Ye);const te={};n&2&&(te.$$scope={dirty:n,ctx:e}),ie.$set(te);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),le.$set(X);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),ce.$set(H);const Y={};n&2&&(Y.$$scope={dirty:n,ctx:e}),de.$set(Y);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),me.$set(U);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),fe.$set(S);const oe={};n&2&&(oe.$$scope={dirty:n,ctx:e}),pe.$set(oe);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),he.$set(Q);const D={};n&2&&(D.$$scope={dirty:n,ctx:e}),ge.$set(D);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),ue.$set(A);const z={};n&2&&(z.$$scope={dirty:n,ctx:e}),_e.$set(z)},i(e){Lt||(u(T.$$.fragment,e),u(w.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(ve.$$.fragment,e),u(ne.$$.fragment,e),u(Ce.$$.fragment,e),u(Ee.$$.fragment,e),u(We.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u(je.$$.fragment,e),u(re.$$.fragment,e),u(ae.$$.fragment,e),u(Ze.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(ze.$$.fragment,e),u(Ve.$$.fragment,e),u(ce.$$.fragment,e),u(Ne.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ke.$$.fragment,e),u(Re.$$.fragment,e),u(Ge.$$.fragment,e),u(fe.$$.fragment,e),u(pe.$$.fragment,e),u(Pe.$$.fragment,e),u(Be.$$.fragment,e),u(Le.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(qe.$$.fragment,e),u(Xe.$$.fragment,e),u(He.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),Lt=!0)},o(e){_(T.$$.fragment,e),_(w.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(ve.$$.fragment,e),_(ne.$$.fragment,e),_(Ce.$$.fragment,e),_(Ee.$$.fragment,e),_(We.$$.fragment,e),_(Ie.$$.fragment,e),_(xe.$$.fragment,e),_(je.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(Ze.$$.fragment,e),_(Je.$$.fragment,e),_(Ue.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(ze.$$.fragment,e),_(Ve.$$.fragment,e),_(ce.$$.fragment,e),_(Ne.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(ke.$$.fragment,e),_(Re.$$.fragment,e),_(Ge.$$.fragment,e),_(fe.$$.fragment,e),_(pe.$$.fragment,e),_(Pe.$$.fragment,e),_(Be.$$.fragment,e),_(Le.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(qe.$$.fragment,e),_(Xe.$$.fragment,e),_(He.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),Lt=!1},d(e){e&&(r(y),r(s),r(l),r(o),r(Tt),r(be),r(Ft),r(ye),r(wt),r(Te),r(Mt),r(Fe),r($t),r(vt),r(Me),r(Ct),r(Et),r(j),r(Wt),r(It),r(P),r(xt),r(jt),r(B),r(Zt),r(Jt),r(Z),r(Ut),r(zt),r(C),r(Vt),r(Nt),r(L),r(kt),r(Rt),r(J),r(Gt),r(Pt),r(E),r(Bt),r(yt)),r(t),b(T,e),b(w,e),b(we,e),b($e,e),b(ve),b(ne),b(Ce,e),b(Ee),b(We),b(Ie,e),b(xe),b(je),b(re),b(ae),b(Ze,e),b(Je),b(Ue),b(ie),b(le),b(ze,e),b(Ve),b(ce),b(Ne),b(de),b(me),b(ke,e),b(Re),b(Ge),b(fe),b(pe),b(Pe,e),b(Be),b(Le),b(he),b(ge),b(qe,e),b(Xe),b(He),b(ue),b(_e)}}}const Wn='{"title":"EfficientFormer","local":"efficientformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"EfficientFormerConfig","local":"transformers.EfficientFormerConfig","sections":[],"depth":2},{"title":"EfficientFormerImageProcessor","local":"transformers.EfficientFormerImageProcessor","sections":[],"depth":2},{"title":"EfficientFormerModel","local":"transformers.EfficientFormerModel","sections":[],"depth":2},{"title":"EfficientFormerForImageClassification","local":"transformers.EfficientFormerForImageClassification","sections":[],"depth":2},{"title":"EfficientFormerForImageClassificationWithTeacher","local":"transformers.EfficientFormerForImageClassificationWithTeacher","sections":[],"depth":2},{"title":"TFEfficientFormerModel","local":"transformers.TFEfficientFormerModel","sections":[],"depth":2},{"title":"TFEfficientFormerForImageClassification","local":"transformers.TFEfficientFormerForImageClassification","sections":[],"depth":2},{"title":"TFEfficientFormerForImageClassificationWithTeacher","local":"transformers.TFEfficientFormerForImageClassificationWithTeacher","sections":[],"depth":2}],"depth":1}';function In(M){return cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends dn{constructor(t){super(),mn(this,t,In,En,ln,{})}}export{Nn as component};
