import{s as io,o as lo,n as O}from"../chunks/scheduler.9bc65507.js";import{S as co,i as mo,g as c,s as i,r as u,A as po,h as m,f as s,c as d,j as P,u as _,x as g,k as W,y as r,a as p,v as b,d as y,t as T,w as v}from"../chunks/index.707bf1b6.js";import{T as Wt}from"../chunks/Tip.c2ecdbf4.js";import{D as E}from"../chunks/Docstring.17db21ae.js";import{C as Ee}from"../chunks/CodeBlock.54a9f38d.js";import{E as Re}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as be}from"../chunks/Heading.342b1fa6.js";function fo(w){let o,I="Idefics modeling code in Transformers is for finetuning and inferencing the pre-trained Idefics models.",l,a,f="To train a new Idefics model from scratch use the m4 codebase (a link will be provided once it’s made public)";return{c(){o=c("p"),o.textContent=I,l=i(),a=c("p"),a.textContent=f},l(t){o=m(t,"P",{"data-svelte-h":!0}),g(o)!=="svelte-34c9bw"&&(o.textContent=I),l=d(t),a=m(t,"P",{"data-svelte-h":!0}),g(a)!=="svelte-bofl57"&&(a.textContent=f)},m(t,h){p(t,o,h),p(t,l,h),p(t,a,h)},p:O,d(t){t&&(s(o),s(l),s(a))}}}function go(w){let o,I="Example:",l,a,f;return a=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElkZWZpY3NNb2RlbCUyQyUyMElkZWZpY3NDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSWRlZmljcyUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSWRlZmljc0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMElkZWZpY3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsModel, IdeficsConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Idefics idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IdeficsConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=c("p"),o.textContent=I,l=i(),u(a.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),g(o)!=="svelte-11lpom8"&&(o.textContent=I),l=d(t),_(a.$$.fragment,t)},m(t,h){p(t,o,h),p(t,l,h),b(a,t,h),f=!0},p:O,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){T(a.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),v(a,t)}}}function ho(w){let o,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=I},l(l){o=m(l,"P",{"data-svelte-h":!0}),g(o)!=="svelte-fincs2"&&(o.innerHTML=I)},m(l,a){p(l,o,a)},p:O,d(l){l&&s(o)}}}function uo(w){let o,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=I},l(l){o=m(l,"P",{"data-svelte-h":!0}),g(o)!=="svelte-fincs2"&&(o.innerHTML=I)},m(l,a){p(l,o,a)},p:O,d(l){l&&s(o)}}}function _o(w){let o,I="Example:",l,a,f;return a=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0JTBBJTBBbW9kZWwlMjAlM0QlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0LmZyb21fcHJldHJhaW5lZChQQVRIX1RPX0NPTlZFUlRFRF9XRUlHSFRTKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKFBBVEhfVE9fQ09OVkVSVEVEX1RPS0VOSVpFUiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXJzJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, IdeficsForVisionText2Text

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(PATH_TO_CONVERTED_WEIGHTS)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(PATH_TO_CONVERTED_TOKENIZER)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?\\nI&#x27;m not consciours, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=I,l=i(),u(a.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),g(o)!=="svelte-11lpom8"&&(o.textContent=I),l=d(t),_(a.$$.fragment,t)},m(t,h){p(t,o,h),p(t,l,h),b(a,t,h),f=!0},p:O,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){T(a.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),v(a,t)}}}function bo(w){let o,I="Example:",l,a,f;return a=new Ee({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmN1dGUtcGhvdG9zLW9mLWNhdHMtaW4tZ3Jhc3MtMTU5MzE4NDc3Ny5qcGclMjIlMEFpbWclMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLmZldGNoX2ltYWdlcyglNUJ1cmwlNUQpJTVCMCU1RCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1nJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMEFuJTIwaW1hZ2UlMjBvZiUyMHR3byUyMGtpdHRlbnMlMjBpbiUyMGdyYXNzLiUwQSUwQSUyMCUyMCUyMCUyMCUyMlVzZXIlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmRvZy1wdW5zLTE1ODE3MDgyMDguanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMTAwKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)
url = <span class="hljs-string">&quot;https://hips.hearstapps.com/hmg-prod/images/cute-photos-of-cats-in-grass-1593184777.jpg&quot;</span>
img = processor.image_processor.fetch_images([url])[<span class="hljs-number">0</span>]

prompts = [
    <span class="hljs-string">&quot;User:&quot;</span>,
    img,
    <span class="hljs-string">&quot;Describe this image.
t: An image of two kittens in grass.

    &quot;</span>User:<span class="hljs-string">&quot;,
    &quot;</span>https://hips.hearstapps.com/hmg-prod/images/dog-puns-<span class="hljs-number">1581708208.j</span>pg<span class="hljs-string">&quot;,
    &quot;</span>Describe this image.
t:<span class="hljs-string">&quot;,
]

inputs = processor(prompts, return_tensors=&quot;</span>pt<span class="hljs-string">&quot;)
generated_ids = model.generate(**inputs, max_length=100)
generated_text = processor.batch_decode(generated_ids, skip_special_tokens=True)[0]</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=I,l=i(),u(a.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),g(o)!=="svelte-11lpom8"&&(o.textContent=I),l=d(t),_(a.$$.fragment,t)},m(t,h){p(t,o,h),p(t,l,h),b(a,t,h),f=!0},p:O,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){T(a.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),v(a,t)}}}function yo(w){let o,I="In this example the <code>prompts</code> will be converted into:",l,a,f;return a=new Ee({props:{code:"JTNDcyUzRVVzZXIlM0ElM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUzQ2ltYWdlJTNFJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0VEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMEFBc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBraXR0ZW5zJTIwaW4lMjBncmFzcy4lMEFVc2VyJTNBJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBQXNzaXN0YW50JTNBJw==",highlighted:`&lt;s&gt;<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span>: <span class="hljs-title class_">An</span> image of two kittens <span class="hljs-keyword">in</span> grass.
<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span><span class="hljs-symbol">:<span class="hljs-string">&#x27;</span></span>`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=I,l=i(),u(a.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),g(o)!=="svelte-c8byn"&&(o.innerHTML=I),l=d(t),_(a.$$.fragment,t)},m(t,h){p(t,o,h),p(t,l,h),b(a,t,h),f=!0},p:O,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){T(a.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),v(a,t)}}}function To(w){let o,I="To do training do:",l,a,f;return a=new Ee({props:{code:"aW1hZ2VfdHJhbnNmb3JtJTIwJTNEJTIwdHJhbnNmb3Jtcy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tUmVzaXplZENyb3AoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHclMkMlMjBoKSUyQyUyMHNjYWxlJTNEKDAuOSUyQyUyMDEuMCklMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUNVQklDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKG1lYW4lM0RzZWxmLmltYWdlX21lYW4lMkMlMjBzdGQlM0RzZWxmLmltYWdlX3N0ZCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdHMlMkMlMjB0cmFuc2Zvcm0lM0RpbWFnZV90cmFuc2Zvcm0lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`image_transform = transforms.Compose(
    [
        transforms.RandomResizedCrop(
            (w, h), scale=(<span class="hljs-number">0.9</span>, <span class="hljs-number">1.0</span>), interpolation=transforms.InterpolationMode.BICUBIC
        ),
        transforms.ToTensor(),
        transforms.Normalize(mean=self.image_mean, std=self.image_std),
    ]
)
inputs = processor(prompts, transform=image_transform, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=I,l=i(),u(a.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),g(o)!=="svelte-1jbe3nb"&&(o.textContent=I),l=d(t),_(a.$$.fragment,t)},m(t,h){p(t,o,h),p(t,l,h),b(a,t,h),f=!0},p:O,i(t){f||(y(a.$$.fragment,t),f=!0)},o(t){T(a.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),v(a,t)}}}function vo(w){let o,I,l,a,f,t,h,He,Q,Zt='The IDEFICS model was proposed in <a href="https://huggingface.co/papers/2306.16527" rel="nofollow">OBELICS: An Open Web-Scale Filtered Dataset of Interleaved Image-Text Documents</a> by Hugo Laurençon, Lucile Saulnier, Léo Tronchon, Stas Bekman, Amanpreet Singh, Anton Lozhkov, Thomas Wang, Siddharth Karamcheti, Alexander M. Rush, Douwe Kiela, Matthieu Cord, Victor Sanh',Se,K,Vt="The abstract from the paper is the following:",Be,ee,Lt="<em>Large multimodal models trained on natural documents, which interleave images and text, outperform models trained on image-text pairs on various multimodal benchmarks that require reasoning over one or multiple images to generate a text. However, the datasets used to train these models have not been released, and the collection process has not been fully specified. We introduce the OBELICS dataset, an open web-scale filtered dataset of interleaved image-text documents comprising 141 million web pages extracted from Common Crawl, 353 million associated images, and 115 billion text tokens. We describe the dataset creation process, present comprehensive filtering rules, and provide an analysis of the dataset’s content. To show the viability of OBELISC, we train an 80 billion parameters vision and language model on the dataset and obtain competitive performance on various multimodal benchmarks. We release the code to reproduce the dataset along with the dataset itself.</em>",De,te,Rt='This model was contributed by <a href="https://huggingface.co/HuggingFaceM4" rel="nofollow">HuggingFaceM4</a>. The original code can be found <a href="INSERT%20LINK%20TO%20GITHUB%20REPO%20HERE">here</a>. (TODO: don’t have a public link yet).',Ae,H,qe,oe,Ge,$,ne,at,ye,Et=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a>. It is used to instantiate an
Idefics model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Idefics-9B.`,rt,Te,Ht='e.g. <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">HuggingFaceM4/idefics-9b</a>',it,ve,St=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,dt,S,Xe,se,Ye,k,ae,lt,Ie,Bt=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ct,Me,Dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mt,xe,At="Transformer decoder consisting of <code>config.num_hidden_layers</code> layers. Each layer is a <code>IdeficsDecoderLayer</code>",pt,Z,re,ft,we,qt='The <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> forward method, overrides the <code>__call__</code> special method.',gt,B,Oe,ie,Qe,V,de,ht,J,le,ut,$e,Gt='The <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',_t,D,bt,A,Ke,ce,et,F,me,yt,ke,Xt="Constructs a Idefics image processor.",Tt,q,pe,vt,ze,Yt="Preprocess a batch of images.",tt,fe,ot,z,ge,It,Ce,Ot="Constructs a IDEFICS processor which wraps a LLama tokenizer and IDEFICS image processor into a single processor.",Mt,Ue,Qt=`<a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See
the docstring of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,xt,M,he,wt,Je,Kt=`This method takes batched or non-batched prompts made of text and images and converts them into prompts that
the model was trained on and prepares the image pixel values for the model to process.`,$t,Fe,eo="Detailed explanation:",kt,je,to="Each entry in <code>prompts</code> is either a text to be passed as is or an image that will be processed.",zt,Ne,oo="An image can be either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",Ct,Pe,no=`When the processor encounters an image it’ll inject <code>&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;</code>
entry into the prompt.`,Ut,G,Jt,X,Ft,We,so=`and the two images will be massaged using <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">IdeficsImageProcessor.<strong>call</strong>()</a> method and placed inside the
<code>pixel_values</code> dict entry of the return value.`,jt,Ze,ao=`This example also examplifies that images can be passed as objects or as text urls. It can be seen that the
first image is passed as object and the second one as a url.`,Nt,Y,Pt,Ve,ro="In order to help debug prompt generation enable <code>debug=True</code> which will show you what’s happening.",nt,Le,st;return f=new be({props:{title:"IDEFICS",local:"idefics",headingTag:"h1"}}),h=new be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new Wt({props:{warning:!0,$$slots:{default:[fo]},$$scope:{ctx:w}}}),oe=new be({props:{title:"IdeficsConfig",local:"transformers.IdeficsConfig",headingTag:"h2"}}),ne=new E({props:{name:"class transformers.IdeficsConfig",anchor:"transformers.IdeficsConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"additional_vocab_size",val:" = 0"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.02"},{name:"alpha_initializer",val:" = 'zeros'"},{name:"alphas_initializer_range",val:" = 0.0"},{name:"alpha_type",val:" = 'float'"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"cross_layer_interval",val:" = 1"},{name:"qk_layer_norms",val:" = False"},{name:"freeze_text_layers",val:" = True"},{name:"freeze_text_module_exceptions",val:" = []"},{name:"freeze_lm_head",val:" = False"},{name:"freeze_vision_layers",val:" = True"},{name:"freeze_vision_module_exceptions",val:" = []"},{name:"use_resampler",val:" = False"},{name:"vision_config",val:" = None"},{name:"perceiver_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsConfig.additional_vocab_size",description:`<strong>additional_vocab_size</strong> (<code>int</code>, *optional\`, defaults to 0) &#x2014;
Additional vocabulary size of the model, typically for the special &#x201D;<img>&#x201D; token. Additional vocab tokens
are always trainable whereas regular vocab tokens can be frozen or not.`,name:"additional_vocab_size"},{anchor:"transformers.IdeficsConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Idefics model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">~IdeficsModel</a>`,name:"vocab_size"},{anchor:"transformers.IdeficsConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.IdeficsConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.IdeficsConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IdeficsConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IdeficsConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.IdeficsConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.IdeficsConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_initializer",description:`<strong>alpha_initializer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;zeros&quot;</code>) &#x2014;
Initialization type for the alphas.`,name:"alpha_initializer"},{anchor:"transformers.IdeficsConfig.alphas_initializer_range",description:`<strong>alphas_initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing the alphas in the Gated Cross
Attention.`,name:"alphas_initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_type",description:`<strong>alpha_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;float&quot;</code>) &#x2014;
Whether the gating alphas should be vectors or single floats.`,name:"alpha_type"},{anchor:"transformers.IdeficsConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.IdeficsConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.IdeficsConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.IdeficsConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.IdeficsConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.IdeficsConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.IdeficsConfig.cross_layer_interval",description:`<strong>cross_layer_interval</strong> (<code>int</code>, <em>optional</em>, default to 1) &#x2014;
Interval for cross attention (from text to image) layers.`,name:"cross_layer_interval"},{anchor:"transformers.IdeficsConfig.qk_layer_norms",description:"<strong>qk_layer_norms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to add layer norm after q and k",name:"qk_layer_norms"},{anchor:"transformers.IdeficsConfig.freeze_text_layers",description:"<strong>freeze_text_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to freeze text layers",name:"freeze_text_layers"},{anchor:"transformers.IdeficsConfig.freeze_text_module_exceptions",description:`<strong>freeze_text_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing text layers when <code>freeze_text_layers</code> is <code>True</code>`,name:"freeze_text_module_exceptions"},{anchor:"transformers.IdeficsConfig.freeze_lm_head",description:"<strong>freeze_lm_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to freeze lm head",name:"freeze_lm_head"},{anchor:"transformers.IdeficsConfig.freeze_vision_layers",description:"<strong>freeze_vision_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;  Whether to freeze vision layers",name:"freeze_vision_layers"},{anchor:"transformers.IdeficsConfig.freeze_vision_module_exceptions",description:`<strong>freeze_vision_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing vision layers when <code>freeze_vision_layers</code> is <code>True</code>`,name:"freeze_vision_module_exceptions"},{anchor:"transformers.IdeficsConfig.use_resampler",description:"<strong>use_resampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to use the Resampler",name:"use_resampler"},{anchor:"transformers.IdeficsConfig.vision_config",description:"<strong>vision_config</strong> (<code>IdeficsVisionConfig</code>,  <em>optional</em>) &#x2014; Custom vision config or dict",name:"vision_config"},{anchor:"transformers.IdeficsConfig.perceiver_config",description:"<strong>perceiver_config</strong> (<code>IdeficsPerceiverConfig</code>,  <em>optional</em>) &#x2014; Custom perceiver config or dict",name:"perceiver_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/configuration_idefics.py#L159"}}),S=new Re({props:{anchor:"transformers.IdeficsConfig.example",$$slots:{default:[go]},$$scope:{ctx:w}}}),se=new be({props:{title:"IdeficsModel",local:"transformers.IdeficsModel",headingTag:"h2"}}),ae=new E({props:{name:"class transformers.IdeficsModel",anchor:"transformers.IdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"}],parametersDescription:[{anchor:"transformers.IdeficsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; IdeficsConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1052"}}),re=new E({props:{name:"forward",anchor:"transformers.IdeficsModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_encoder_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"perceiver_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.IdeficsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1154"}}),B=new Wt({props:{$$slots:{default:[ho]},$$scope:{ctx:w}}}),ie=new be({props:{title:"IdeficsForVisionText2Text",local:"transformers.IdeficsForVisionText2Text",headingTag:"h2"}}),de=new E({props:{name:"class transformers.IdeficsForVisionText2Text",anchor:"transformers.IdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1406"}}),le=new E({props:{name:"forward",anchor:"transformers.IdeficsForVisionText2Text.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_encoder_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"perceiver_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.IdeficsForVisionText2Text.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsForVisionText2Text.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsForVisionText2Text.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsForVisionText2Text.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsForVisionText2Text.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/modeling_idefics.py#L1464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new Wt({props:{$$slots:{default:[uo]},$$scope:{ctx:w}}}),A=new Re({props:{anchor:"transformers.IdeficsForVisionText2Text.forward.example",$$slots:{default:[_o]},$$scope:{ctx:w}}}),ce=new be({props:{title:"IdeficsImageProcessor",local:"transformers.IdeficsImageProcessor",headingTag:"h2"}}),me=new E({props:{name:"class transformers.IdeficsImageProcessor",anchor:"transformers.IdeficsImageProcessor",parameters:[{name:"image_size",val:": int = 224"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_num_channels",val:": typing.Optional[int] = 3"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of image channels.`,name:"image_num_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/image_processing_idefics.py#L51"}}),pe=new E({props:{name:"preprocess",anchor:"transformers.IdeficsImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"image_num_channels",val:": typing.Optional[int] = 3"},{name:"image_size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"transform",val:": typing.Callable = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_size</code>) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_num_channels</code>) &#x2014;
Number of image channels.`,name:"image_num_channels"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can
be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.preprocess.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple transforms. If <code>None</code> - an inference mode is
assumed - and then a preset of inference-specific transforms will be applied to the images`,name:"transform"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/image_processing_idefics.py#L87",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a PyTorch tensor of the processed images</p>
`}}),fe=new be({props:{title:"IdeficsProcessor",local:"transformers.IdeficsProcessor",headingTag:"h2"}}),ge=new E({props:{name:"class transformers.IdeficsProcessor",anchor:"transformers.IdeficsProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:" = None"},{name:"image_size",val:" = 224"},{name:"add_end_of_utterance_token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.image_processor",description:`<strong>image_processor</strong> (<code>IdeficsImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.IdeficsProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.IdeficsProcessor.image_size",description:"<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014; Image size (assuming a square image)",name:"image_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/processing_idefics.py#L108"}}),he=new E({props:{name:"__call__",anchor:"transformers.IdeficsProcessor.__call__",parameters:[{name:"prompts",val:": typing.Union[typing.List[str], typing.List[typing.List[str]]]"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"transform",val:": typing.Callable = None"},{name:"add_eos_token",val:" = False"},{name:"add_end_of_utterance_token",val:" = None"},{name:"debug",val:" = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = <TensorType.PYTORCH: 'pt'>"}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.__call__.prompts",description:`<strong>prompts</strong> (<code>Union[List[TextInput], [List[List[TextInput]]]]</code>) &#x2014;
either a single prompt or a batched list of prompts - see the detailed description immediately after
the end of the arguments doc section.`,name:"prompts"},{anchor:"transformers.IdeficsProcessor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.IdeficsProcessor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.IdeficsProcessor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates truncation to cut input sequences longer than <code>max_length</code> to <code>max_length</code>.`,name:"truncation"},{anchor:"transformers.IdeficsProcessor.__call__.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple functions. If <code>None</code> a preset inference-specific
set of transforms will be applied to the images`,name:"transform"},{anchor:"transformers.IdeficsProcessor.__call__.add_eos_token",description:"<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;\nAdds <code>eos_token</code> at the end of the final prompt if True`",name:"add_eos_token"},{anchor:"transformers.IdeficsProcessor.__call__.add_end_of_utterance_token",description:`<strong>add_end_of_utterance_token</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to automatically add <code>&lt;end_of_utterance&gt;</code> after each prompt&#x2019;s text input (unless followed by an
image). If <code>None</code> the tokenizer will be checked instead and if this token is found in
<code>additional_special_tokens</code> then the value will be <code>True</code>.`,name:"add_end_of_utterance_token"},{anchor:"transformers.IdeficsProcessor.__call__.debug",description:`<strong>debug</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
<code>True</code> value will help debug prompt generation by dumping useful information`,name:"debug"},{anchor:"transformers.IdeficsProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>TensorType.PYTORCH</code>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics/processing_idefics.py#L148",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>input_ids</code>, <code>attention_mask</code>, <code>pixel_values</code>, <code>image_attention_mask</code> which can be
directly passed to <code>model.generate</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a dict with entries</p>
`}}),G=new Re({props:{anchor:"transformers.IdeficsProcessor.__call__.example",$$slots:{default:[bo]},$$scope:{ctx:w}}}),X=new Re({props:{anchor:"transformers.IdeficsProcessor.__call__.example-2",$$slots:{default:[yo]},$$scope:{ctx:w}}}),Y=new Re({props:{anchor:"transformers.IdeficsProcessor.__call__.example-3",$$slots:{default:[To]},$$scope:{ctx:w}}}),{c(){o=c("meta"),I=i(),l=c("p"),a=i(),u(f.$$.fragment),t=i(),u(h.$$.fragment),He=i(),Q=c("p"),Q.innerHTML=Zt,Se=i(),K=c("p"),K.textContent=Vt,Be=i(),ee=c("p"),ee.innerHTML=Lt,De=i(),te=c("p"),te.innerHTML=Rt,Ae=i(),u(H.$$.fragment),qe=i(),u(oe.$$.fragment),Ge=i(),$=c("div"),u(ne.$$.fragment),at=i(),ye=c("p"),ye.innerHTML=Et,rt=i(),Te=c("p"),Te.innerHTML=Ht,it=i(),ve=c("p"),ve.innerHTML=St,dt=i(),u(S.$$.fragment),Xe=i(),u(se.$$.fragment),Ye=i(),k=c("div"),u(ae.$$.fragment),lt=i(),Ie=c("p"),Ie.innerHTML=Bt,ct=i(),Me=c("p"),Me.innerHTML=Dt,mt=i(),xe=c("p"),xe.innerHTML=At,pt=i(),Z=c("div"),u(re.$$.fragment),ft=i(),we=c("p"),we.innerHTML=qt,gt=i(),u(B.$$.fragment),Oe=i(),u(ie.$$.fragment),Qe=i(),V=c("div"),u(de.$$.fragment),ht=i(),J=c("div"),u(le.$$.fragment),ut=i(),$e=c("p"),$e.innerHTML=Gt,_t=i(),u(D.$$.fragment),bt=i(),u(A.$$.fragment),Ke=i(),u(ce.$$.fragment),et=i(),F=c("div"),u(me.$$.fragment),yt=i(),ke=c("p"),ke.textContent=Xt,Tt=i(),q=c("div"),u(pe.$$.fragment),vt=i(),ze=c("p"),ze.textContent=Yt,tt=i(),u(fe.$$.fragment),ot=i(),z=c("div"),u(ge.$$.fragment),It=i(),Ce=c("p"),Ce.textContent=Ot,Mt=i(),Ue=c("p"),Ue.innerHTML=Qt,xt=i(),M=c("div"),u(he.$$.fragment),wt=i(),Je=c("p"),Je.textContent=Kt,$t=i(),Fe=c("p"),Fe.textContent=eo,kt=i(),je=c("p"),je.innerHTML=to,zt=i(),Ne=c("p"),Ne.innerHTML=oo,Ct=i(),Pe=c("p"),Pe.innerHTML=no,Ut=i(),u(G.$$.fragment),Jt=i(),u(X.$$.fragment),Ft=i(),We=c("p"),We.innerHTML=so,jt=i(),Ze=c("p"),Ze.textContent=ao,Nt=i(),u(Y.$$.fragment),Pt=i(),Ve=c("p"),Ve.innerHTML=ro,nt=i(),Le=c("p"),this.h()},l(e){const n=po("svelte-u9bgzb",document.head);o=m(n,"META",{name:!0,content:!0}),n.forEach(s),I=d(e),l=m(e,"P",{}),P(l).forEach(s),a=d(e),_(f.$$.fragment,e),t=d(e),_(h.$$.fragment,e),He=d(e),Q=m(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-jddp08"&&(Q.innerHTML=Zt),Se=d(e),K=m(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-vfdo9a"&&(K.textContent=Vt),Be=d(e),ee=m(e,"P",{"data-svelte-h":!0}),g(ee)!=="svelte-18xi2yr"&&(ee.innerHTML=Lt),De=d(e),te=m(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-1nhi3a3"&&(te.innerHTML=Rt),Ae=d(e),_(H.$$.fragment,e),qe=d(e),_(oe.$$.fragment,e),Ge=d(e),$=m(e,"DIV",{class:!0});var C=P($);_(ne.$$.fragment,C),at=d(C),ye=m(C,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-vk0gw8"&&(ye.innerHTML=Et),rt=d(C),Te=m(C,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-n7bqeh"&&(Te.innerHTML=Ht),it=d(C),ve=m(C,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-o55m63"&&(ve.innerHTML=St),dt=d(C),_(S.$$.fragment,C),C.forEach(s),Xe=d(e),_(se.$$.fragment,e),Ye=d(e),k=m(e,"DIV",{class:!0});var U=P(k);_(ae.$$.fragment,U),lt=d(U),Ie=m(U,"P",{"data-svelte-h":!0}),g(Ie)!=="svelte-4n5ccz"&&(Ie.innerHTML=Bt),ct=d(U),Me=m(U,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-hswkmf"&&(Me.innerHTML=Dt),mt=d(U),xe=m(U,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-1rhjct8"&&(xe.innerHTML=At),pt=d(U),Z=m(U,"DIV",{class:!0});var L=P(Z);_(re.$$.fragment,L),ft=d(L),we=m(L,"P",{"data-svelte-h":!0}),g(we)!=="svelte-fnr21g"&&(we.innerHTML=qt),gt=d(L),_(B.$$.fragment,L),L.forEach(s),U.forEach(s),Oe=d(e),_(ie.$$.fragment,e),Qe=d(e),V=m(e,"DIV",{class:!0});var ue=P(V);_(de.$$.fragment,ue),ht=d(ue),J=m(ue,"DIV",{class:!0});var j=P(J);_(le.$$.fragment,j),ut=d(j),$e=m(j,"P",{"data-svelte-h":!0}),g($e)!=="svelte-1mawjh8"&&($e.innerHTML=Gt),_t=d(j),_(D.$$.fragment,j),bt=d(j),_(A.$$.fragment,j),j.forEach(s),ue.forEach(s),Ke=d(e),_(ce.$$.fragment,e),et=d(e),F=m(e,"DIV",{class:!0});var R=P(F);_(me.$$.fragment,R),yt=d(R),ke=m(R,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-1m1ucrf"&&(ke.textContent=Xt),Tt=d(R),q=m(R,"DIV",{class:!0});var _e=P(q);_(pe.$$.fragment,_e),vt=d(_e),ze=m(_e,"P",{"data-svelte-h":!0}),g(ze)!=="svelte-1xds4wy"&&(ze.textContent=Yt),_e.forEach(s),R.forEach(s),tt=d(e),_(fe.$$.fragment,e),ot=d(e),z=m(e,"DIV",{class:!0});var N=P(z);_(ge.$$.fragment,N),It=d(N),Ce=m(N,"P",{"data-svelte-h":!0}),g(Ce)!=="svelte-ntsjs9"&&(Ce.textContent=Ot),Mt=d(N),Ue=m(N,"P",{"data-svelte-h":!0}),g(Ue)!=="svelte-9y5i42"&&(Ue.innerHTML=Qt),xt=d(N),M=m(N,"DIV",{class:!0});var x=P(M);_(he.$$.fragment,x),wt=d(x),Je=m(x,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-1dgzv8j"&&(Je.textContent=Kt),$t=d(x),Fe=m(x,"P",{"data-svelte-h":!0}),g(Fe)!=="svelte-qv5ndj"&&(Fe.textContent=eo),kt=d(x),je=m(x,"P",{"data-svelte-h":!0}),g(je)!=="svelte-xvvltg"&&(je.innerHTML=to),zt=d(x),Ne=m(x,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-15i05k0"&&(Ne.innerHTML=oo),Ct=d(x),Pe=m(x,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-gstss4"&&(Pe.innerHTML=no),Ut=d(x),_(G.$$.fragment,x),Jt=d(x),_(X.$$.fragment,x),Ft=d(x),We=m(x,"P",{"data-svelte-h":!0}),g(We)!=="svelte-1tgg2du"&&(We.innerHTML=so),jt=d(x),Ze=m(x,"P",{"data-svelte-h":!0}),g(Ze)!=="svelte-9aj4iv"&&(Ze.textContent=ao),Nt=d(x),_(Y.$$.fragment,x),Pt=d(x),Ve=m(x,"P",{"data-svelte-h":!0}),g(Ve)!=="svelte-1drva0b"&&(Ve.innerHTML=ro),x.forEach(s),N.forEach(s),nt=d(e),Le=m(e,"P",{}),P(Le).forEach(s),this.h()},h(){W(o,"name","hf:doc:metadata"),W(o,"content",Io),W($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){r(document.head,o),p(e,I,n),p(e,l,n),p(e,a,n),b(f,e,n),p(e,t,n),b(h,e,n),p(e,He,n),p(e,Q,n),p(e,Se,n),p(e,K,n),p(e,Be,n),p(e,ee,n),p(e,De,n),p(e,te,n),p(e,Ae,n),b(H,e,n),p(e,qe,n),b(oe,e,n),p(e,Ge,n),p(e,$,n),b(ne,$,null),r($,at),r($,ye),r($,rt),r($,Te),r($,it),r($,ve),r($,dt),b(S,$,null),p(e,Xe,n),b(se,e,n),p(e,Ye,n),p(e,k,n),b(ae,k,null),r(k,lt),r(k,Ie),r(k,ct),r(k,Me),r(k,mt),r(k,xe),r(k,pt),r(k,Z),b(re,Z,null),r(Z,ft),r(Z,we),r(Z,gt),b(B,Z,null),p(e,Oe,n),b(ie,e,n),p(e,Qe,n),p(e,V,n),b(de,V,null),r(V,ht),r(V,J),b(le,J,null),r(J,ut),r(J,$e),r(J,_t),b(D,J,null),r(J,bt),b(A,J,null),p(e,Ke,n),b(ce,e,n),p(e,et,n),p(e,F,n),b(me,F,null),r(F,yt),r(F,ke),r(F,Tt),r(F,q),b(pe,q,null),r(q,vt),r(q,ze),p(e,tt,n),b(fe,e,n),p(e,ot,n),p(e,z,n),b(ge,z,null),r(z,It),r(z,Ce),r(z,Mt),r(z,Ue),r(z,xt),r(z,M),b(he,M,null),r(M,wt),r(M,Je),r(M,$t),r(M,Fe),r(M,kt),r(M,je),r(M,zt),r(M,Ne),r(M,Ct),r(M,Pe),r(M,Ut),b(G,M,null),r(M,Jt),b(X,M,null),r(M,Ft),r(M,We),r(M,jt),r(M,Ze),r(M,Nt),b(Y,M,null),r(M,Pt),r(M,Ve),p(e,nt,n),p(e,Le,n),st=!0},p(e,[n]){const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),H.$set(C);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),S.$set(U);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),B.$set(L);const ue={};n&2&&(ue.$$scope={dirty:n,ctx:e}),D.$set(ue);const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),A.$set(j);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),G.$set(R);const _e={};n&2&&(_e.$$scope={dirty:n,ctx:e}),X.$set(_e);const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),Y.$set(N)},i(e){st||(y(f.$$.fragment,e),y(h.$$.fragment,e),y(H.$$.fragment,e),y(oe.$$.fragment,e),y(ne.$$.fragment,e),y(S.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(B.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(le.$$.fragment,e),y(D.$$.fragment,e),y(A.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(pe.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(he.$$.fragment,e),y(G.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),st=!0)},o(e){T(f.$$.fragment,e),T(h.$$.fragment,e),T(H.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(S.$$.fragment,e),T(se.$$.fragment,e),T(ae.$$.fragment,e),T(re.$$.fragment,e),T(B.$$.fragment,e),T(ie.$$.fragment,e),T(de.$$.fragment,e),T(le.$$.fragment,e),T(D.$$.fragment,e),T(A.$$.fragment,e),T(ce.$$.fragment,e),T(me.$$.fragment,e),T(pe.$$.fragment,e),T(fe.$$.fragment,e),T(ge.$$.fragment,e),T(he.$$.fragment,e),T(G.$$.fragment,e),T(X.$$.fragment,e),T(Y.$$.fragment,e),st=!1},d(e){e&&(s(I),s(l),s(a),s(t),s(He),s(Q),s(Se),s(K),s(Be),s(ee),s(De),s(te),s(Ae),s(qe),s(Ge),s($),s(Xe),s(Ye),s(k),s(Oe),s(Qe),s(V),s(Ke),s(et),s(F),s(tt),s(ot),s(z),s(nt),s(Le)),s(o),v(f,e),v(h,e),v(H,e),v(oe,e),v(ne),v(S),v(se,e),v(ae),v(re),v(B),v(ie,e),v(de),v(le),v(D),v(A),v(ce,e),v(me),v(pe),v(fe,e),v(ge),v(he),v(G),v(X),v(Y)}}}const Io='{"title":"IDEFICS","local":"idefics","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"IdeficsConfig","local":"transformers.IdeficsConfig","sections":[],"depth":2},{"title":"IdeficsModel","local":"transformers.IdeficsModel","sections":[],"depth":2},{"title":"IdeficsForVisionText2Text","local":"transformers.IdeficsForVisionText2Text","sections":[],"depth":2},{"title":"IdeficsImageProcessor","local":"transformers.IdeficsImageProcessor","sections":[],"depth":2},{"title":"IdeficsProcessor","local":"transformers.IdeficsProcessor","sections":[],"depth":2}],"depth":1}';function Mo(w){return lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jo extends co{constructor(o){super(),mo(this,o,Mo,vo,io,{})}}export{Jo as component};
