import{s as Ia,f as aa,n as Ga,o as Za}from"../chunks/scheduler.9bc65507.js";import{S as Ba,i as Wa,g as i,s as n,r as L,m as o,H as w,A as Pa,h as p,f as t,c as l,j as N,u as A,x as d,n as r,B as f,k as g,y as m,a as e,v as Q,d as S,t as Y,w as F}from"../chunks/index.707bf1b6.js";import{C as ta}from"../chunks/CodeBlock.54a9f38d.js";import{D as $a}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as ea}from"../chunks/Heading.342b1fa6.js";function Ea(na){let v,ts,ss,es,_,ns,J,ls,U,la=`Perplexity (PPL) is one of the most common metrics for evaluating language models. Before diving in, we should note
that the metric applies specifically to classical language models (sometimes called autoregressive or causal language
models) and is not well defined for masked language models like BERT (see <a href="model_summary">summary of the models</a>).`,is,u,Fs,ps,xa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi>x</mi><mn>0</mn></msub><mo separator="true">,</mo><msub><mi>x</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">X = (x_0, x_1, \\dots, x_t)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',ms,os,Ma='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex">X</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',rs,cs,K,hs,ka='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>PPL</mtext><mo stretchy="false">(</mo><mi>X</mi><mo stretchy="false">)</mo><mo>=</mo><mi>exp</mi><mo>⁡</mo><mrow><mo fence="true">{</mo><mrow><mo>−</mo><mfrac><mn>1</mn><mi>t</mi></mfrac><munderover><mo>∑</mo><mi>i</mi><mi>t</mi></munderover><mi>log</mi><mo>⁡</mo><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub><mo stretchy="false">)</mo></mrow><mo fence="true">}</mo></mrow></mrow><annotation encoding="application/x-tex">\\text{PPL}(X) = \\exp \\left\\{ {-\\frac{1}{t}\\sum_i^t \\log p_\\theta (x_i|x_{&lt;i}) } \\right\\}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">PPL</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.0582em;vertical-align:-1.2777em;"></span><span class="mop">exp</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">{</span></span><span class="mord"><span class="mord">−</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal">t</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7806em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size4">}</span></span></span></span></span></span></span>',ds,y,Ks,gs,Ta='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>log</mi><mo>⁡</mo><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\log p_\\theta (x_i|x_{&lt;i})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',us,ys,_a='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub></mrow><annotation encoding="application/x-tex">x_{&lt;i}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6079em;vertical-align:-0.1774em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span></span></span></span>',ws,fs,j,ia=`This is also equivalent to the exponentiation of the cross-entropy between the data and model predictions. For more
intuition about perplexity and its relationship to Bits Per Character (BPC) and data compression, check out this
<a href="https://thegradient.pub/understanding-evaluation-metrics-for-language-models/" rel="nofollow">fantastic blog post on The Gradient</a>.`,vs,C,bs,z,pa=`If we weren’t limited by a model’s context size, we would evaluate the model’s perplexity by autoregressively
factorizing a sequence and conditioning on the entire preceding subsequence at each step, as shown below.`,xs,b,ma,Ms,c,Ds,I,oa="GPT-2",Os,ks,Ja='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>t</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>t</mi></mrow></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_\\theta(x_t|x_{&lt;t})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Ts,_s,Ua='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi></mrow><annotation encoding="application/x-tex">t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6151em;"></span><span class="mord mathnormal">t</span></span></span></span>',Js,Us,h,sa,js,ja='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi></mrow><annotation encoding="application/x-tex">k</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span></span></span></span>',Cs,zs,Ca='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>t</mi></msub></mrow><annotation encoding="application/x-tex">x_t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Is,Gs,za='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi><mo>−</mo><mn>1</mn></mrow><annotation encoding="application/x-tex">k-1</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.0833em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Zs,Bs,x,ra,Ws,G,ca=`This is quick to compute since the perplexity of each segment can be computed in one forward pass, but serves as a poor
approximation of the fully-factorized perplexity and will typically yield a higher (worse) PPL because the model will
have less context at most of the prediction steps.`,Ps,Z,ha=`Instead, the PPL of fixed-length models should be evaluated with a sliding-window strategy. This involves repeatedly
sliding the context window so that the model has more context when making each prediction.`,$s,M,da,Es,B,ga=`This is a closer approximation to the true decomposition of the sequence probability and will typically yield a more
favorable score. The downside is that it requires a separate forward pass for each token in the corpus. A good
practical compromise is to employ a strided sliding window, moving the context by larger strides rather than sliding by
1 token a time. This allows computation to proceed much faster while still giving the model a large context to make
predictions at each step.`,Xs,W,qs,P,ua="Let’s demonstrate this process with GPT-2.",Hs,$,Rs,E,ya=`We’ll load in the WikiText-2 dataset and evaluate the perplexity using a few different sliding-window strategies. Since
this dataset is small and we’re just doing one forward pass over the set, we can just load and encode the entire
dataset in memory.`,Vs,X,Ls,q,wa=`With 🤗 Transformers, we can simply pass the <code>input_ids</code> as the <code>labels</code> to our model, and the average negative
log-likelihood for each token is returned as the loss. With our sliding window approach, however, there is overlap in
the tokens we pass to the model at each iteration. We don’t want the log-likelihood for the tokens we’re just treating
as context to be included in our loss, so we can set these targets to <code>-100</code> so that they are ignored. The following
is an example of how we could do this with a stride of <code>512</code>. This means that the model will have at least 512 tokens
for context when calculating the conditional likelihood of any one token (provided there are 512 preceding tokens
available to condition on).`,Ns,H,As,R,fa=`Running this with the stride length equal to the max input length is equivalent to the suboptimal, non-sliding-window
strategy we discussed above. The smaller the stride, the more context the model will have in making each prediction,
and the better the reported perplexity will typically be.`,Qs,V,va=`When we run the above with <code>stride = 1024</code>, i.e. no overlap, the resulting PPL is <code>19.44</code>, which is about the same
as the <code>19.93</code> reported in the GPT-2 paper. By using <code>stride = 512</code> and thereby employing our striding window
strategy, this jumps down to <code>16.45</code>. This is not only a more favorable score, but is calculated in a way that is
closer to the true autoregressive decomposition of a sequence likelihood.`,Ss,as,Ys;return _=new ea({props:{title:"Perplexity of fixed-length models",local:"perplexity-of-fixed-length-models",headingTag:"h1"}}),J=new $a({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/perplexity.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/perplexity.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/perplexity.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/perplexity.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/perplexity.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/perplexity.ipynb"}]}}),C=new ea({props:{title:"Calculating PPL with fixed-length models",local:"calculating-ppl-with-fixed-length-models",headingTag:"h2"}}),W=new ea({props:{title:"Example: Calculating perplexity with GPT-2 in 🤗 Transformers",local:"example-calculating-perplexity-with-gpt-2-in--transformers",headingTag:"h2"}}),$=new ta({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJMTUhlYWRNb2RlbCUyQyUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ3B0Mi1sYXJnZSUyMiUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCkudG8oZGV2aWNlKSUwQXRva2VuaXplciUyMCUzRCUyMEdQVDJUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2LMHeadModel, GPT2TokenizerFast

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id = <span class="hljs-string">&quot;gpt2-large&quot;</span>
model = GPT2LMHeadModel.from_pretrained(model_id).to(device)
tokenizer = GPT2TokenizerFast.from_pretrained(model_id)`,wrap:!1}}),X=new ta({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdGVzdCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMCUyMndpa2l0ZXh0LTItcmF3LXYxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKSUwQWVuY29kaW5ncyUyMCUzRCUyMHRva2VuaXplciglMjIlNUNuJTVDbiUyMi5qb2luKHRlc3QlNUIlMjJ0ZXh0JTIyJTVEKSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

test = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
encodings = tokenizer(<span class="hljs-string">&quot;\\n\\n&quot;</span>.join(test[<span class="hljs-string">&quot;text&quot;</span>]), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),H=new ta({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHFkbSUyMGltcG9ydCUyMHRxZG0lMEElMEFtYXhfbGVuZ3RoJTIwJTNEJTIwbW9kZWwuY29uZmlnLm5fcG9zaXRpb25zJTBBc3RyaWRlJTIwJTNEJTIwNTEyJTBBc2VxX2xlbiUyMCUzRCUyMGVuY29kaW5ncy5pbnB1dF9pZHMuc2l6ZSgxKSUwQSUwQW5sbHMlMjAlM0QlMjAlNUIlNUQlMEFwcmV2X2VuZF9sb2MlMjAlM0QlMjAwJTBBZm9yJTIwYmVnaW5fbG9jJTIwaW4lMjB0cWRtKHJhbmdlKDAlMkMlMjBzZXFfbGVuJTJDJTIwc3RyaWRlKSklM0ElMEElMjAlMjAlMjAlMjBlbmRfbG9jJTIwJTNEJTIwbWluKGJlZ2luX2xvYyUyMCUyQiUyMG1heF9sZW5ndGglMkMlMjBzZXFfbGVuKSUwQSUyMCUyMCUyMCUyMHRyZ19sZW4lMjAlM0QlMjBlbmRfbG9jJTIwLSUyMHByZXZfZW5kX2xvYyUyMCUyMCUyMyUyMG1heSUyMGJlJTIwZGlmZmVyZW50JTIwZnJvbSUyMHN0cmlkZSUyMG9uJTIwbGFzdCUyMGxvb3AlMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjBlbmNvZGluZ3MuaW5wdXRfaWRzJTVCJTNBJTJDJTIwYmVnaW5fbG9jJTNBZW5kX2xvYyU1RC50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X2lkcyUyMCUzRCUyMGlucHV0X2lkcy5jbG9uZSgpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X2lkcyU1QiUzQSUyQyUyMCUzQS10cmdfbGVuJTVEJTIwJTNEJTIwLTEwMCUwQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEdGFyZ2V0X2lkcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb3NzJTIwaXMlMjBjYWxjdWxhdGVkJTIwdXNpbmclMjBDcm9zc0VudHJvcHlMb3NzJTIwd2hpY2glMjBhdmVyYWdlcyUyMG92ZXIlMjB2YWxpZCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME4uQi4lMjB0aGUlMjBtb2RlbCUyMG9ubHklMjBjYWxjdWxhdGVzJTIwbG9zcyUyMG92ZXIlMjB0cmdfbGVuJTIwLSUyMDElMjBsYWJlbHMlMkMlMjBiZWNhdXNlJTIwaXQlMjBpbnRlcm5hbGx5JTIwc2hpZnRzJTIwdGhlJTIwbGFiZWxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdG8lMjB0aGUlMjBsZWZ0JTIwYnklMjAxLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5lZ19sb2dfbGlrZWxpaG9vZCUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUwQSUyMCUyMCUyMCUyMG5sbHMuYXBwZW5kKG5lZ19sb2dfbGlrZWxpaG9vZCklMEElMEElMjAlMjAlMjAlMjBwcmV2X2VuZF9sb2MlMjAlM0QlMjBlbmRfbG9jJTBBJTIwJTIwJTIwJTIwaWYlMjBlbmRfbG9jJTIwJTNEJTNEJTIwc2VxX2xlbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBcHBsJTIwJTNEJTIwdG9yY2guZXhwKHRvcmNoLnN0YWNrKG5sbHMpLm1lYW4oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

max_length = model.config.n_positions
stride = <span class="hljs-number">512</span>
seq_len = encodings.input_ids.size(<span class="hljs-number">1</span>)

nlls = []
prev_end_loc = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> begin_loc <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, seq_len, stride)):
    end_loc = <span class="hljs-built_in">min</span>(begin_loc + max_length, seq_len)
    trg_len = end_loc - prev_end_loc  <span class="hljs-comment"># may be different from stride on last loop</span>
    input_ids = encodings.input_ids[:, begin_loc:end_loc].to(device)
    target_ids = input_ids.clone()
    target_ids[:, :-trg_len] = -<span class="hljs-number">100</span>

    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(input_ids, labels=target_ids)

        <span class="hljs-comment"># loss is calculated using CrossEntropyLoss which averages over valid labels</span>
        <span class="hljs-comment"># N.B. the model only calculates loss over trg_len - 1 labels, because it internally shifts the labels</span>
        <span class="hljs-comment"># to the left by 1.</span>
        neg_log_likelihood = outputs.loss

    nlls.append(neg_log_likelihood)

    prev_end_loc = end_loc
    <span class="hljs-keyword">if</span> end_loc == seq_len:
        <span class="hljs-keyword">break</span>

ppl = torch.exp(torch.stack(nlls).mean())`,wrap:!1}}),{c(){v=i("meta"),ts=n(),ss=i("p"),es=n(),L(_.$$.fragment),ns=n(),L(J.$$.fragment),ls=n(),U=i("p"),U.innerHTML=la,is=n(),u=i("p"),Fs=o(`Perplexity is defined as the exponentiated average negative log-likelihood of a sequence. If we have a tokenized
sequence `),ps=new w(!1),ms=o(", then the perplexity of "),os=new w(!1),rs=o(" is,"),cs=n(),K=i("p"),hs=new w(!1),ds=n(),y=i("p"),Ks=o("where "),gs=new w(!1),us=o(" is the log-likelihood of the ith token conditioned on the preceding tokens "),ys=new w(!1),ws=o(" according to our model. Intuitively, it can be thought of as an evaluation of the model’s ability to predict uniformly among the set of specified tokens in a corpus. Importantly, this means that the tokenization procedure has a direct impact on a model’s perplexity which should always be taken into consideration when comparing different models."),fs=n(),j=i("p"),j.innerHTML=ia,vs=n(),L(C.$$.fragment),bs=n(),z=i("p"),z.textContent=pa,xs=n(),b=i("img"),Ms=n(),c=i("p"),Ds=o(`When working with approximate models, however, we typically have a constraint on the number of tokens the model can
process. The largest version of `),I=i("a"),I.textContent=oa,Os=o(`, for example, has a fixed length of 1024 tokens, so we
cannot calculate `),ks=new w(!1),Ts=o(" directly when "),_s=new w(!1),Js=o(" is greater than 1024."),Us=n(),h=i("p"),sa=o(`Instead, the sequence is typically broken into subsequences equal to the model’s maximum input size. If a model’s max
input size is `),js=new w(!1),Cs=o(", we then approximate the likelihood of a token "),zs=new w(!1),Is=o(` by conditioning only on the
`),Gs=new w(!1),Zs=o(` tokens that precede it rather than the entire context. When evaluating the model’s perplexity of a
sequence, a tempting but suboptimal approach is to break the sequence into disjoint chunks and add up the decomposed
log-likelihoods of each segment independently.`),Bs=n(),x=i("img"),Ws=n(),G=i("p"),G.textContent=ca,Ps=n(),Z=i("p"),Z.textContent=ha,$s=n(),M=i("img"),Es=n(),B=i("p"),B.textContent=ga,Xs=n(),L(W.$$.fragment),qs=n(),P=i("p"),P.textContent=ua,Hs=n(),L($.$$.fragment),Rs=n(),E=i("p"),E.textContent=ya,Vs=n(),L(X.$$.fragment),Ls=n(),q=i("p"),q.innerHTML=wa,Ns=n(),L(H.$$.fragment),As=n(),R=i("p"),R.textContent=fa,Qs=n(),V=i("p"),V.innerHTML=va,Ss=n(),as=i("p"),this.h()},l(s){const a=Pa("svelte-u9bgzb",document.head);v=p(a,"META",{name:!0,content:!0}),a.forEach(t),ts=l(s),ss=p(s,"P",{}),N(ss).forEach(t),es=l(s),A(_.$$.fragment,s),ns=l(s),A(J.$$.fragment,s),ls=l(s),U=p(s,"P",{"data-svelte-h":!0}),d(U)!=="svelte-syn4xn"&&(U.innerHTML=la),is=l(s),u=p(s,"P",{});var D=N(u);Fs=r(D,`Perplexity is defined as the exponentiated average negative log-likelihood of a sequence. If we have a tokenized
sequence `),ps=f(D,!1),ms=r(D,", then the perplexity of "),os=f(D,!1),rs=r(D," is,"),D.forEach(t),cs=l(s),K=p(s,"P",{});var ba=N(K);hs=f(ba,!1),ba.forEach(t),ds=l(s),y=p(s,"P",{});var O=N(y);Ks=r(O,"where "),gs=f(O,!1),us=r(O," is the log-likelihood of the ith token conditioned on the preceding tokens "),ys=f(O,!1),ws=r(O," according to our model. Intuitively, it can be thought of as an evaluation of the model’s ability to predict uniformly among the set of specified tokens in a corpus. Importantly, this means that the tokenization procedure has a direct impact on a model’s perplexity which should always be taken into consideration when comparing different models."),O.forEach(t),fs=l(s),j=p(s,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10yo7ds"&&(j.innerHTML=ia),vs=l(s),A(C.$$.fragment,s),bs=l(s),z=p(s,"P",{"data-svelte-h":!0}),d(z)!=="svelte-nt0thp"&&(z.textContent=pa),xs=l(s),b=p(s,"IMG",{width:!0,alt:!0,src:!0}),Ms=l(s),c=p(s,"P",{});var k=N(c);Ds=r(k,`When working with approximate models, however, we typically have a constraint on the number of tokens the model can
process. The largest version of `),I=p(k,"A",{href:!0,"data-svelte-h":!0}),d(I)!=="svelte-1kdeo4m"&&(I.textContent=oa),Os=r(k,`, for example, has a fixed length of 1024 tokens, so we
cannot calculate `),ks=f(k,!1),Ts=r(k," directly when "),_s=f(k,!1),Js=r(k," is greater than 1024."),k.forEach(t),Us=l(s),h=p(s,"P",{});var T=N(h);sa=r(T,`Instead, the sequence is typically broken into subsequences equal to the model’s maximum input size. If a model’s max
input size is `),js=f(T,!1),Cs=r(T,", we then approximate the likelihood of a token "),zs=f(T,!1),Is=r(T,` by conditioning only on the
`),Gs=f(T,!1),Zs=r(T,` tokens that precede it rather than the entire context. When evaluating the model’s perplexity of a
sequence, a tempting but suboptimal approach is to break the sequence into disjoint chunks and add up the decomposed
log-likelihoods of each segment independently.`),T.forEach(t),Bs=l(s),x=p(s,"IMG",{width:!0,alt:!0,src:!0}),Ws=l(s),G=p(s,"P",{"data-svelte-h":!0}),d(G)!=="svelte-19oj8tf"&&(G.textContent=ca),Ps=l(s),Z=p(s,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-w5z9wi"&&(Z.textContent=ha),$s=l(s),M=p(s,"IMG",{width:!0,alt:!0,src:!0}),Es=l(s),B=p(s,"P",{"data-svelte-h":!0}),d(B)!=="svelte-zqbk5w"&&(B.textContent=ga),Xs=l(s),A(W.$$.fragment,s),qs=l(s),P=p(s,"P",{"data-svelte-h":!0}),d(P)!=="svelte-atwk84"&&(P.textContent=ua),Hs=l(s),A($.$$.fragment,s),Rs=l(s),E=p(s,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1jth08f"&&(E.textContent=ya),Vs=l(s),A(X.$$.fragment,s),Ls=l(s),q=p(s,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1jepp38"&&(q.innerHTML=wa),Ns=l(s),A(H.$$.fragment,s),As=l(s),R=p(s,"P",{"data-svelte-h":!0}),d(R)!=="svelte-6e6tqv"&&(R.textContent=fa),Qs=l(s),V=p(s,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1um3qvs"&&(V.innerHTML=va),Ss=l(s),as=p(s,"P",{}),N(as).forEach(t),this.h()},h(){g(v,"name","hf:doc:metadata"),g(v,"content",Xa),ps.a=ms,os.a=rs,hs.a=null,gs.a=us,ys.a=ws,g(b,"width","600"),g(b,"alt","Full decomposition of a sequence with unlimited context length"),aa(b.src,ma="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_full.gif")||g(b,"src",ma),g(I,"href","model_doc/gpt2"),ks.a=Ts,_s.a=Js,js.a=Cs,zs.a=Is,Gs.a=Zs,g(x,"width","600"),g(x,"alt","Suboptimal PPL not taking advantage of full available context"),aa(x.src,ra="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_chunked.gif")||g(x,"src",ra),g(M,"width","600"),g(M,"alt","Sliding window PPL taking advantage of all available context"),aa(M.src,da="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_sliding.gif")||g(M,"src",da)},m(s,a){m(document.head,v),e(s,ts,a),e(s,ss,a),e(s,es,a),Q(_,s,a),e(s,ns,a),Q(J,s,a),e(s,ls,a),e(s,U,a),e(s,is,a),e(s,u,a),m(u,Fs),ps.m(xa,u),m(u,ms),os.m(Ma,u),m(u,rs),e(s,cs,a),e(s,K,a),hs.m(ka,K),e(s,ds,a),e(s,y,a),m(y,Ks),gs.m(Ta,y),m(y,us),ys.m(_a,y),m(y,ws),e(s,fs,a),e(s,j,a),e(s,vs,a),Q(C,s,a),e(s,bs,a),e(s,z,a),e(s,xs,a),e(s,b,a),e(s,Ms,a),e(s,c,a),m(c,Ds),m(c,I),m(c,Os),ks.m(Ja,c),m(c,Ts),_s.m(Ua,c),m(c,Js),e(s,Us,a),e(s,h,a),m(h,sa),js.m(ja,h),m(h,Cs),zs.m(Ca,h),m(h,Is),Gs.m(za,h),m(h,Zs),e(s,Bs,a),e(s,x,a),e(s,Ws,a),e(s,G,a),e(s,Ps,a),e(s,Z,a),e(s,$s,a),e(s,M,a),e(s,Es,a),e(s,B,a),e(s,Xs,a),Q(W,s,a),e(s,qs,a),e(s,P,a),e(s,Hs,a),Q($,s,a),e(s,Rs,a),e(s,E,a),e(s,Vs,a),Q(X,s,a),e(s,Ls,a),e(s,q,a),e(s,Ns,a),Q(H,s,a),e(s,As,a),e(s,R,a),e(s,Qs,a),e(s,V,a),e(s,Ss,a),e(s,as,a),Ys=!0},p:Ga,i(s){Ys||(S(_.$$.fragment,s),S(J.$$.fragment,s),S(C.$$.fragment,s),S(W.$$.fragment,s),S($.$$.fragment,s),S(X.$$.fragment,s),S(H.$$.fragment,s),Ys=!0)},o(s){Y(_.$$.fragment,s),Y(J.$$.fragment,s),Y(C.$$.fragment,s),Y(W.$$.fragment,s),Y($.$$.fragment,s),Y(X.$$.fragment,s),Y(H.$$.fragment,s),Ys=!1},d(s){s&&(t(ts),t(ss),t(es),t(ns),t(ls),t(U),t(is),t(u),t(cs),t(K),t(ds),t(y),t(fs),t(j),t(vs),t(bs),t(z),t(xs),t(b),t(Ms),t(c),t(Us),t(h),t(Bs),t(x),t(Ws),t(G),t(Ps),t(Z),t($s),t(M),t(Es),t(B),t(Xs),t(qs),t(P),t(Hs),t(Rs),t(E),t(Vs),t(Ls),t(q),t(Ns),t(As),t(R),t(Qs),t(V),t(Ss),t(as)),t(v),F(_,s),F(J,s),F(C,s),F(W,s),F($,s),F(X,s),F(H,s)}}}const Xa='{"title":"Perplexity of fixed-length models","local":"perplexity-of-fixed-length-models","sections":[{"title":"Calculating PPL with fixed-length models","local":"calculating-ppl-with-fixed-length-models","sections":[],"depth":2},{"title":"Example: Calculating perplexity with GPT-2 in 🤗 Transformers","local":"example-calculating-perplexity-with-gpt-2-in--transformers","sections":[],"depth":2}],"depth":1}';function qa(na){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Aa extends Ba{constructor(v){super(),Wa(this,v,qa,Ea,Ia,{})}}export{Aa as component};
