import{s as mo,o as fo,n as Qe}from"../chunks/scheduler.9bc65507.js";import{S as po,i as ho,g as s,s as o,r as g,A as go,h as i,f as c,c as n,j as C,u,x as f,k as $,y as t,a as w,v as _,d as b,t as y,w as v}from"../chunks/index.707bf1b6.js";import{T as so}from"../chunks/Tip.c2ecdbf4.js";import{D as T}from"../chunks/Docstring.17db21ae.js";import{C as lo}from"../chunks/CodeBlock.54a9f38d.js";import{E as io}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as co}from"../chunks/Heading.342b1fa6.js";function uo(U){let d,k=`A configuration file can be loaded and saved to disk. Loading the configuration file and using this file to
initialize a model does <strong>not</strong> load the model weights. It only affects the model’s configuration.`;return{c(){d=s("p"),d.innerHTML=k},l(m){d=i(m,"P",{"data-svelte-h":!0}),f(d)!=="svelte-s3sff7"&&(d.innerHTML=k)},m(m,h){w(m,d,h)},p:Qe,d(m){m&&c(d)}}}function _o(U){let d,k="Examples:",m,h,x;return h=new lo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMGNvbmZpZyUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBY29uZmlnLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBjb25maWclMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFjb25maWcucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the config to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
config.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the config to an organization with the name &quot;my-finetuned-bert&quot;.</span>
config.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){d=s("p"),d.textContent=k,m=o(),g(h.$$.fragment)},l(l){d=i(l,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=k),m=n(l),u(h.$$.fragment,l)},m(l,P){w(l,d,P),w(l,m,P),_(h,l,P),x=!0},p:Qe,i(l){x||(b(h.$$.fragment,l),x=!0)},o(l){y(h.$$.fragment,l),x=!1},d(l){l&&(c(d),c(m)),v(h,l)}}}function bo(U){let d,k="Examples:",m,h,x;return h=new lo({props:{code:"JTIzJTIwV2UlMjBjYW4ndCUyMGluc3RhbnRpYXRlJTIwZGlyZWN0bHklMjB0aGUlMjBiYXNlJTIwY2xhc3MlMjAqUHJldHJhaW5lZENvbmZpZyolMjBzbyUyMGxldCdzJTIwc2hvdyUyMHRoZSUyMGV4YW1wbGVzJTIwb24lMjBhJTBBJTIzJTIwZGVyaXZlZCUyMGNsYXNzJTNBJTIwQmVydENvbmZpZyUwQWNvbmZpZyUyMCUzRCUyMEJlcnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBKSUyMCUyMCUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEJlcnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMEEpJTIwJTIwJTIzJTIwRS5nLiUyMGNvbmZpZyUyMChvciUyMG1vZGVsKSUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqJTBBY29uZmlnJTIwJTNEJTIwQmVydENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSUyQyUyMGZvbyUzREZhbHNlKSUwQWFzc2VydCUyMGNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUyMCUzRCUzRCUyMFRydWUlMEFjb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwQmVydENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUlMkMlMjBmb28lM0RGYWxzZSUyQyUyMHJldHVybl91bnVzZWRfa3dhcmdzJTNEVHJ1ZSUwQSklMEFhc3NlcnQlMjBjb25maWcub3V0cHV0X2F0dGVudGlvbnMlMjAlM0QlM0QlMjBUcnVlJTBBYXNzZXJ0JTIwdW51c2VkX2t3YXJncyUyMCUzRCUzRCUyMCU3QiUyMmZvbyUyMiUzQSUyMEZhbHNlJTdE",highlighted:`<span class="hljs-comment"># We can&#x27;t instantiate directly the base class *PretrainedConfig* so let&#x27;s show the examples on a</span>
<span class="hljs-comment"># derived class: BertConfig</span>
config = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
)  <span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
config = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;./test/saved_model/&quot;</span>
)  <span class="hljs-comment"># E.g. config (or model) was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
config = BertConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/my_configuration.json&quot;</span>)
config = BertConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-keyword">assert</span> config.output_attentions == <span class="hljs-literal">True</span>
config, unused_kwargs = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
)
<span class="hljs-keyword">assert</span> config.output_attentions == <span class="hljs-literal">True</span>
<span class="hljs-keyword">assert</span> unused_kwargs == {<span class="hljs-string">&quot;foo&quot;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){d=s("p"),d.textContent=k,m=o(),g(h.$$.fragment)},l(l){d=i(l,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=k),m=n(l),u(h.$$.fragment,l)},m(l,P){w(l,d,P),w(l,m,P),_(h,l,P),x=!0},p:Qe,i(l){x||(b(h.$$.fragment,l),x=!0)},o(l){y(h.$$.fragment,l),x=!1},d(l){l&&(c(d),c(m)),v(h,l)}}}function yo(U){let d,k="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){d=s("p"),d.textContent=k},l(m){d=i(m,"P",{"data-svelte-h":!0}),f(d)!=="svelte-15rpg4"&&(d.textContent=k)},m(m,h){w(m,d,h)},p:Qe,d(m){m&&c(d)}}}function vo(U){let d,k,m,h,x,l,P,It=`The base class <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> implements the common methods for loading/saving a configuration
either from a local file or directory, or from a pretrained model configuration provided by the library (downloaded
from HuggingFace’s AWS S3 repository).`,De,X,Dt=`Each derived config class implements model specific attributes. Common attributes present in all config classes are:
<code>hidden_size</code>, <code>num_attention_heads</code>, and <code>num_hidden_layers</code>. Text models further implement:
<code>vocab_size</code>.`,qe,Y,He,r,Q,Oe,he,qt=`Base class for all configuration classes. Handles a few parameters common to all models’ configurations as well as
methods for loading/downloading/saving configurations.`,Ke,W,et,ge,Ht="Class attributes (overridden by derived classes):",tt,ue,Vt=`<li><strong>model_type</strong> (<code>str</code>) — An identifier for the model type, serialized into the JSON file, and used to recreate
the correct object in <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>.</li> <li><strong>is_composition</strong> (<code>bool</code>) — Whether the config class is composed of multiple sub-configs. In this case the
config has to be initialized from two or more configs of type <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> like:
<a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderConfig">EncoderDecoderConfig</a> or <a href="/docs/transformers/main/en/model_doc/rag#transformers.RagConfig">~RagConfig</a>.</li> <li><strong>keys_to_ignore_at_inference</strong> (<code>List[str]</code>) — A list of keys to ignore by default when looking at dictionary
outputs of the model during inference.</li> <li><strong>attribute_map</strong> (<code>Dict[str, str]</code>) — A dict that maps model specific attribute names to the standardized
naming of attributes.</li>`,ot,_e,Nt="Common attributes (present in all subclasses):",nt,be,Bt=`<li><strong>vocab_size</strong> (<code>int</code>) — The number of tokens in the vocabulary, which is also the first dimension of the
embeddings matrix (this attribute may be missing for models that don’t have a text modality like ViT).</li> <li><strong>hidden_size</strong> (<code>int</code>) — The hidden size of the model.</li> <li><strong>num_attention_heads</strong> (<code>int</code>) — The number of attention heads used in the multi-head attention layers of the
model.</li> <li><strong>num_hidden_layers</strong> (<code>int</code>) — The number of blocks in the model.</li>`,rt,j,O,at,ye,Et="Upload the configuration file to the 🤗 Model Hub.",st,L,it,F,K,dt,ve,St=`Checks whether the passed dictionary and its nested dicts have a <em>torch_dtype</em> key and if it’s not None,
converts torch.dtype to a string of just the type. For example, <code>torch.float32</code> get converted into <em>“float32”</em>
string, which can then be stored in the json format.`,ct,I,ee,lt,we,Rt='Instantiates a <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> from a Python dictionary of parameters.',mt,D,te,ft,xe,At='Instantiates a <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> from the path to a JSON file of parameters.',pt,z,oe,ht,Ce,Gt='Instantiate a <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> (or a derived class) from a pretrained model configuration.',gt,q,ut,H,ne,_t,$e,Xt=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> using <code>from_dict</code>.`,bt,J,re,yt,ke,Yt=`Register this class with a given auto class. This should only be used for custom configurations as the ones in
the library are already mapped with <code>AutoConfig</code>.`,vt,V,wt,N,ae,xt,Pe,Qt=`Save a configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a> class method.`,Ct,B,se,$t,Te,Ot="Serializes this instance to a Python dictionary.",kt,E,ie,Pt,Me,Kt=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Tt,S,de,Mt,Ue,eo="Save this instance to a JSON file.",Ut,R,ce,jt,je,to="Serializes this instance to a JSON string.",zt,A,le,Jt,ze,oo="Updates attributes of this class with attributes from <code>config_dict</code>.",Zt,M,me,Wt,Je,no="Updates attributes of this class with attributes from <code>update_str</code>.",Lt,Ze,ro=`The expected format is ints, floats and strings as is, and for booleans use <code>true</code> or <code>false</code>. For example:
“n_embd=10,resid_pdrop=0.2,scale_attn_weights=false,summary_type=cls_index”`,Ft,We,ao="The keys to change have to already exist in the config object.",Ve,Ie,Ne;return x=new co({props:{title:"Configuration",local:"configuration",headingTag:"h1"}}),Y=new co({props:{title:"PretrainedConfig",local:"transformers.PretrainedConfig",headingTag:"h2"}}),Q=new T({props:{name:"class transformers.PretrainedConfig",anchor:"transformers.PretrainedConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.name_or_path",description:`<strong>name_or_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
Store the string that was passed to <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">PreTrainedModel.from_pretrained()</a> or
<a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">TFPreTrainedModel.from_pretrained()</a> as <code>pretrained_model_name_or_path</code> if the configuration was created
with such a method.`,name:"name_or_path"},{anchor:"transformers.PretrainedConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should return all hidden-states.`,name:"output_hidden_states"},{anchor:"transformers.PretrainedConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should returns all attentions.`,name:"output_attentions"},{anchor:"transformers.PretrainedConfig.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PretrainedConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.PretrainedConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as decoder or not (in which case it&#x2019;s used as an encoder).`,name:"is_decoder"},{anchor:"transformers.PretrainedConfig.cross_attention_hidden_size**",description:`<strong>cross_attention_hidden_size**</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
The hidden size of the cross-attention layer in case the model is used as a decoder in an encoder-decoder
setting and the cross-attention hidden dimension differs from <code>self.config.hidden_size</code>.`,name:"cross_attention_hidden_size**"},{anchor:"transformers.PretrainedConfig.add_cross_attention",description:`<strong>add_cross_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cross-attention layers should be added to the model. Note, this option is only relevant for models
that can be used as decoder models within the <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> class, which consists of all models
in <code>AUTO_MODELS_FOR_CAUSAL_LM</code>.`,name:"add_cross_attention"},{anchor:"transformers.PretrainedConfig.tie_encoder_decoder",description:`<strong>tie_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether all encoder weights should be tied to their equivalent decoder weights. This requires the encoder
and decoder model to have the exact same parameter names.`,name:"tie_encoder_decoder"},{anchor:"transformers.PretrainedConfig.prune_heads",description:`<strong>prune_heads</strong> (<code>Dict[int, List[int]]</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Pruned heads of the model. The keys are the selected layer indices and the associated values, the list of
heads to prune in said layer.</p>
<p>For instance <code>{1: [0, 2], 2: [2, 3]}</code> will prune heads 0 and 2 on layer 1 and heads 2 and 3 on layer 2.`,name:"prune_heads"},{anchor:"transformers.PretrainedConfig.chunk_size_feed_forward",description:`<strong>chunk_size_feed_forward</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The chunk size of all feed forward layers in the residual attention blocks. A chunk size of <code>0</code> means that
the feed forward layer is not chunked. A chunk size of n means that the feed forward layer processes <code>n</code> &lt;
sequence_length embeddings at a time. For more information on feed forward chunking, see <a href="../glossary.html#feed-forward-chunking">How does Feed
Forward Chunking work?</a>.`,name:"chunk_size_feed_forward"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L49",parameterGroups:[{title:"Parameters for sequence generation",parametersDescription:[{anchor:"transformers.PretrainedConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Maximum length that will be used by default in the <code>generate</code> method of the model.`,name:"max_length"},{anchor:"transformers.PretrainedConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum length that will be used by default in the <code>generate</code> method of the model.`,name:"min_length"},{anchor:"transformers.PretrainedConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag that will be used by default in the <code>generate</code> method of the model. Whether or not to use sampling ;
use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.PretrainedConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag that will be used by default in the <code>generate</code> method of the model. Whether to stop the beam search
when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.PretrainedConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search that will be used by default in the <code>generate</code> method of the model. 1 means
no beam search.`,name:"num_beams"},{anchor:"transformers.PretrainedConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams
that will be used by default in the <code>generate</code> method of the model. 1 means no group beam search.`,name:"num_beam_groups"},{anchor:"transformers.PretrainedConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Value to control diversity for group beam search. that will be used by default in the <code>generate</code> method of
the model. 0 means no diversity penalty. The higher the penalty, the more diverse are the outputs.`,name:"diversity_penalty"},{anchor:"transformers.PretrainedConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities that will be used by default in the <code>generate</code> method
of the model. Must be strictly positive.`,name:"temperature"},{anchor:"transformers.PretrainedConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
Number of highest probability vocabulary tokens to keep for top-k-filtering that will be used by default in
the <code>generate</code> method of the model.`,name:"top_k"},{anchor:"transformers.PretrainedConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Value that will be used by default in the <code>generate</code> method of the model for <code>top_p</code>. If set to float &lt; 1,
only the most probable tokens with probabilities that add up to <code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.PretrainedConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.PretrainedConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Parameter for repetition penalty that will be used by default in the <code>generate</code> method of the model. 1.0
means no penalty.`,name:"repetition_penalty"},{anchor:"transformers.PretrainedConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.PretrainedConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; Value that will be used by default in the &#x2014;
<code>generate</code> method of the model for <code>no_repeat_ngram_size</code>. If set to int &gt; 0, all ngrams of that size can
only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.PretrainedConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; Value that will be used by &#x2014;
default in the <code>generate</code> method of the model for <code>encoder_no_repeat_ngram_size</code>. If set to int &gt; 0, all
ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the <code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.PretrainedConfig.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated that will be used by default in the <code>generate</code>
method of the model. In order to get the tokens of the words that should not appear in the generated text,
use <code>tokenizer.encode(bad_word, add_prefix_space=True)</code>.`,name:"bad_words_ids"},{anchor:"transformers.PretrainedConfig.num_return_sequences",description:`<strong>num_return_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of independently computed returned sequences for each element in the batch that will be used by
default in the <code>generate</code> method of the model.`,name:"num_return_sequences"},{anchor:"transformers.PretrainedConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should return the logits when used for generation.`,name:"output_scores"},{anchor:"transformers.PretrainedConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a <code>torch.LongTensor</code>.`,name:"return_dict_in_generate"},{anchor:"transformers.PretrainedConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.PretrainedConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"forced_eos_token_id"},{anchor:"transformers.PretrainedConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"}]},{title:"Parameters for fine-tuning tasks",parametersDescription:[{anchor:"transformers.PretrainedConfig.architectures",description:`<strong>architectures</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Model architectures that can be used with the model pretrained weights.`,name:"architectures"},{anchor:"transformers.PretrainedConfig.finetuning_task",description:`<strong>finetuning_task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the task used to fine-tune the model. This can be used when converting from an original (TensorFlow
or PyTorch) checkpoint.`,name:"finetuning_task"},{anchor:"transformers.PretrainedConfig.id2label",description:`<strong>id2label</strong> (<code>Dict[int, str]</code>, <em>optional</em>) &#x2014;
A map from index (for instance prediction index, or target index) to label.`,name:"id2label"},{anchor:"transformers.PretrainedConfig.label2id",description:"<strong>label2id</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014; A map from label to index for the model.",name:"label2id"},{anchor:"transformers.PretrainedConfig.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of labels to use in the last layer added to the model, typically for a classification task.`,name:"num_labels"},{anchor:"transformers.PretrainedConfig.task_specific_params",description:`<strong>task_specific_params</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to store for the current task.`,name:"task_specific_params"},{anchor:"transformers.PretrainedConfig.problem_type",description:`<strong>problem_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Problem type for <code>XxxForSequenceClassification</code> models. Can be one of <code>&quot;regression&quot;</code>,
<code>&quot;single_label_classification&quot;</code> or <code>&quot;multi_label_classification&quot;</code>.`,name:"problem_type"}]},{title:"Parameters linked to the tokenizer",parametersDescription:[{anchor:"transformers.PretrainedConfig.tokenizer_class",description:`<strong>tokenizer_class</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the associated tokenizer class to use (if none is set, will use the tokenizer associated to the
model by default).`,name:"tokenizer_class"},{anchor:"transformers.PretrainedConfig.prefix",description:`<strong>prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A specific prompt that should be added at the beginning of each text before calling the model.`,name:"prefix"},{anchor:"transformers.PretrainedConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>beginning-of-stream</em> token.",name:"bos_token_id"},{anchor:"transformers.PretrainedConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.PretrainedConfig.eos_token_id",description:"<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>end-of-stream</em> token.",name:"eos_token_id"},{anchor:"transformers.PretrainedConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"},{anchor:"transformers.PretrainedConfig.sep_token_id",description:"<strong>sep_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>separation</em> token.",name:"sep_token_id"}]},{title:"PyTorch specific parameters",parametersDescription:[{anchor:"transformers.PretrainedConfig.torchscript",description:`<strong>torchscript</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should be used with Torchscript.`,name:"torchscript"},{anchor:"transformers.PretrainedConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied. Note that this is only relevant if the
model has a output word embedding layer.`,name:"tie_word_embeddings"},{anchor:"transformers.PretrainedConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The <code>dtype</code> of the weights. This attribute can be used to initialize the model to a non-default <code>dtype</code>
(which is normally <code>float32</code>) and thus allow for optimal storage allocation. For example, if the saved
model is <code>float16</code>, ideally we want to load it back using the minimal amount of memory needed to load
<code>float16</code> weights. Since the config object is stored in plain text, this attribute contains just the
floating type string without the <code>torch.</code> prefix. For example, for <code>torch.float16</code> \`<code>torch_dtype</code> is the
<code>&quot;float16&quot;</code> string.</p>
<p>This attribute is currently not being used during model loading time, but this may change in the future
versions. But we can already start preparing for the future by saving the dtype with save_pretrained.`,name:"torch_dtype"}]},{title:"TensorFlow specific parameters",parametersDescription:[{anchor:"transformers.PretrainedConfig.use_bfloat16",description:`<strong>use_bfloat16</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should use BFloat16 scalars (only used by some TensorFlow models).`,name:"use_bfloat16"},{anchor:"transformers.PretrainedConfig.tf_legacy_loss",description:`<strong>tf_legacy_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should use legacy TensorFlow losses. Legacy losses have variable output shapes and may
not be XLA-compatible. This option is here for backward compatibility and will be removed in Transformers
v5.`,name:"tf_legacy_loss"}]}]}}),W=new so({props:{$$slots:{default:[uo]},$$scope:{ctx:U}}}),O=new T({props:{name:"push_to_hub",anchor:"transformers.PretrainedConfig.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": typing.Optional[bool] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = '10GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = False"},{name:"revision",val:": str = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your config to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.PretrainedConfig.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.PretrainedConfig.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload config&quot;</code>.`,name:"commit_message"},{anchor:"transformers.PretrainedConfig.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.PretrainedConfig.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.PretrainedConfig.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;10GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>).`,name:"max_shard_size"},{anchor:"transformers.PretrainedConfig.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.PretrainedConfig.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.PretrainedConfig.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L786"}}),L=new io({props:{anchor:"transformers.PretrainedConfig.push_to_hub.example",$$slots:{default:[_o]},$$scope:{ctx:U}}}),K=new T({props:{name:"dict_torch_dtype_to_str",anchor:"transformers.PretrainedConfig.dict_torch_dtype_to_str",parameters:[{name:"d",val:": typing.Dict[str, typing.Any]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L983"}}),ee=new T({props:{name:"from_dict",anchor:"transformers.PretrainedConfig.from_dict",parameters:[{name:"config_dict",val:": typing.Dict[str, typing.Any]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_dict.config_dict",description:`<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the configuration object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.get_config_dict">get_config_dict()</a> method.`,name:"config_dict"},{anchor:"transformers.PretrainedConfig.from_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L724",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),te=new T({props:{name:"from_json_file",anchor:"transformers.PretrainedConfig.from_json_file",parameters:[{name:"json_file",val:": typing.Union[str, os.PathLike]"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_json_file.json_file",description:`<strong>json_file</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file containing the parameters.`,name:"json_file"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from that JSON file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),oe=new T({props:{name:"from_pretrained",anchor:"transformers.PretrainedConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved configuration JSON <em>file</em>, e.g., <code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.PretrainedConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.PretrainedConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.PretrainedConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.PretrainedConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.PretrainedConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PretrainedConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.PretrainedConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.PretrainedConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.PretrainedConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L498",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),q=new io({props:{anchor:"transformers.PretrainedConfig.from_pretrained.example",$$slots:{default:[bo]},$$scope:{ctx:U}}}),ne=new T({props:{name:"get_config_dict",anchor:"transformers.PretrainedConfig.get_config_dict",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.get_config_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L601",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the configuration object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),re=new T({props:{name:"register_for_auto_class",anchor:"transformers.PretrainedConfig.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoConfig'"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoConfig&quot;</code>) &#x2014;
The auto class to register this new configuration with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L995"}}),V=new so({props:{warning:!0,$$slots:{default:[yo]},$$scope:{ctx:U}}}),ae=new T({props:{name:"save_pretrained",anchor:"transformers.PretrainedConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.PretrainedConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.PretrainedConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L424"}}),se=new T({props:{name:"to_dict",anchor:"transformers.PretrainedConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L864",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),ie=new T({props:{name:"to_diff_dict",anchor:"transformers.PretrainedConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L810",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),de=new T({props:{name:"to_json_file",anchor:"transformers.PretrainedConfig.to_json_file",parameters:[{name:"json_file_path",val:": typing.Union[str, os.PathLike]"},{name:"use_diff",val:": bool = True"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this configuration instance&#x2019;s parameters will be saved.`,name:"json_file_path"},{anchor:"transformers.PretrainedConfig.to_json_file.use_diff",description:`<strong>use_diff</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, only the difference between the config instance and the default <code>PretrainedConfig()</code>
is serialized to JSON file.`,name:"use_diff"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L921"}}),ce=new T({props:{name:"to_json_string",anchor:"transformers.PretrainedConfig.to_json_string",parameters:[{name:"use_diff",val:": bool = True"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.to_json_string.use_diff",description:`<strong>use_diff</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, only the difference between the config instance and the default <code>PretrainedConfig()</code>
is serialized to JSON string.`,name:"use_diff"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L903",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this configuration instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),le=new T({props:{name:"update",anchor:"transformers.PretrainedConfig.update",parameters:[{name:"config_dict",val:": typing.Dict[str, typing.Any]"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.update.config_dict",description:"<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014; Dictionary of attributes that should be updated for this class.",name:"config_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L935"}}),me=new T({props:{name:"update_from_string",anchor:"transformers.PretrainedConfig.update_from_string",parameters:[{name:"update_str",val:": str"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.update_from_string.update_str",description:"<strong>update_str</strong> (<code>str</code>) &#x2014; String with attributes that should be updated for this class.",name:"update_str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L945"}}),{c(){d=s("meta"),k=o(),m=s("p"),h=o(),g(x.$$.fragment),l=o(),P=s("p"),P.innerHTML=It,De=o(),X=s("p"),X.innerHTML=Dt,qe=o(),g(Y.$$.fragment),He=o(),r=s("div"),g(Q.$$.fragment),Oe=o(),he=s("p"),he.textContent=qt,Ke=o(),g(W.$$.fragment),et=o(),ge=s("p"),ge.textContent=Ht,tt=o(),ue=s("ul"),ue.innerHTML=Vt,ot=o(),_e=s("p"),_e.textContent=Nt,nt=o(),be=s("ul"),be.innerHTML=Bt,rt=o(),j=s("div"),g(O.$$.fragment),at=o(),ye=s("p"),ye.textContent=Et,st=o(),g(L.$$.fragment),it=o(),F=s("div"),g(K.$$.fragment),dt=o(),ve=s("p"),ve.innerHTML=St,ct=o(),I=s("div"),g(ee.$$.fragment),lt=o(),we=s("p"),we.innerHTML=Rt,mt=o(),D=s("div"),g(te.$$.fragment),ft=o(),xe=s("p"),xe.innerHTML=At,pt=o(),z=s("div"),g(oe.$$.fragment),ht=o(),Ce=s("p"),Ce.innerHTML=Gt,gt=o(),g(q.$$.fragment),ut=o(),H=s("div"),g(ne.$$.fragment),_t=o(),$e=s("p"),$e.innerHTML=Xt,bt=o(),J=s("div"),g(re.$$.fragment),yt=o(),ke=s("p"),ke.innerHTML=Yt,vt=o(),g(V.$$.fragment),wt=o(),N=s("div"),g(ae.$$.fragment),xt=o(),Pe=s("p"),Pe.innerHTML=Qt,Ct=o(),B=s("div"),g(se.$$.fragment),$t=o(),Te=s("p"),Te.textContent=Ot,kt=o(),E=s("div"),g(ie.$$.fragment),Pt=o(),Me=s("p"),Me.textContent=Kt,Tt=o(),S=s("div"),g(de.$$.fragment),Mt=o(),Ue=s("p"),Ue.textContent=eo,Ut=o(),R=s("div"),g(ce.$$.fragment),jt=o(),je=s("p"),je.textContent=to,zt=o(),A=s("div"),g(le.$$.fragment),Jt=o(),ze=s("p"),ze.innerHTML=oo,Zt=o(),M=s("div"),g(me.$$.fragment),Wt=o(),Je=s("p"),Je.innerHTML=no,Lt=o(),Ze=s("p"),Ze.innerHTML=ro,Ft=o(),We=s("p"),We.textContent=ao,Ve=o(),Ie=s("p"),this.h()},l(e){const p=go("svelte-u9bgzb",document.head);d=i(p,"META",{name:!0,content:!0}),p.forEach(c),k=n(e),m=i(e,"P",{}),C(m).forEach(c),h=n(e),u(x.$$.fragment,e),l=n(e),P=i(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-1hsuq13"&&(P.innerHTML=It),De=n(e),X=i(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1fich0i"&&(X.innerHTML=Dt),qe=n(e),u(Y.$$.fragment,e),He=n(e),r=i(e,"DIV",{class:!0});var a=C(r);u(Q.$$.fragment,a),Oe=n(a),he=i(a,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1p9qi0i"&&(he.textContent=qt),Ke=n(a),u(W.$$.fragment,a),et=n(a),ge=i(a,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-1qxxkvo"&&(ge.textContent=Ht),tt=n(a),ue=i(a,"UL",{"data-svelte-h":!0}),f(ue)!=="svelte-1250f4i"&&(ue.innerHTML=Vt),ot=n(a),_e=i(a,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-1yi3c0w"&&(_e.textContent=Nt),nt=n(a),be=i(a,"UL",{"data-svelte-h":!0}),f(be)!=="svelte-1cjcwii"&&(be.innerHTML=Bt),rt=n(a),j=i(a,"DIV",{class:!0});var Z=C(j);u(O.$$.fragment,Z),at=n(Z),ye=i(Z,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-j50kqf"&&(ye.textContent=Et),st=n(Z),u(L.$$.fragment,Z),Z.forEach(c),it=n(a),F=i(a,"DIV",{class:!0});var fe=C(F);u(K.$$.fragment,fe),dt=n(fe),ve=i(fe,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-m61tyl"&&(ve.innerHTML=St),fe.forEach(c),ct=n(a),I=i(a,"DIV",{class:!0});var pe=C(I);u(ee.$$.fragment,pe),lt=n(pe),we=i(pe,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1pj9b5l"&&(we.innerHTML=Rt),pe.forEach(c),mt=n(a),D=i(a,"DIV",{class:!0});var Be=C(D);u(te.$$.fragment,Be),ft=n(Be),xe=i(Be,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1otsf4s"&&(xe.innerHTML=At),Be.forEach(c),pt=n(a),z=i(a,"DIV",{class:!0});var Le=C(z);u(oe.$$.fragment,Le),ht=n(Le),Ce=i(Le,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-4eardg"&&(Ce.innerHTML=Gt),gt=n(Le),u(q.$$.fragment,Le),Le.forEach(c),ut=n(a),H=i(a,"DIV",{class:!0});var Ee=C(H);u(ne.$$.fragment,Ee),_t=n(Ee),$e=i(Ee,"P",{"data-svelte-h":!0}),f($e)!=="svelte-587d4s"&&($e.innerHTML=Xt),Ee.forEach(c),bt=n(a),J=i(a,"DIV",{class:!0});var Fe=C(J);u(re.$$.fragment,Fe),yt=n(Fe),ke=i(Fe,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-30y31e"&&(ke.innerHTML=Yt),vt=n(Fe),u(V.$$.fragment,Fe),Fe.forEach(c),wt=n(a),N=i(a,"DIV",{class:!0});var Se=C(N);u(ae.$$.fragment,Se),xt=n(Se),Pe=i(Se,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1g6lu"&&(Pe.innerHTML=Qt),Se.forEach(c),Ct=n(a),B=i(a,"DIV",{class:!0});var Re=C(B);u(se.$$.fragment,Re),$t=n(Re),Te=i(Re,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-1ww3wqq"&&(Te.textContent=Ot),Re.forEach(c),kt=n(a),E=i(a,"DIV",{class:!0});var Ae=C(E);u(ie.$$.fragment,Ae),Pt=n(Ae),Me=i(Ae,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1p6bdas"&&(Me.textContent=Kt),Ae.forEach(c),Tt=n(a),S=i(a,"DIV",{class:!0});var Ge=C(S);u(de.$$.fragment,Ge),Mt=n(Ge),Ue=i(Ge,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1g70y32"&&(Ue.textContent=eo),Ge.forEach(c),Ut=n(a),R=i(a,"DIV",{class:!0});var Xe=C(R);u(ce.$$.fragment,Xe),jt=n(Xe),je=i(Xe,"P",{"data-svelte-h":!0}),f(je)!=="svelte-5ayq1f"&&(je.textContent=to),Xe.forEach(c),zt=n(a),A=i(a,"DIV",{class:!0});var Ye=C(A);u(le.$$.fragment,Ye),Jt=n(Ye),ze=i(Ye,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-1hh5fg7"&&(ze.innerHTML=oo),Ye.forEach(c),Zt=n(a),M=i(a,"DIV",{class:!0});var G=C(M);u(me.$$.fragment,G),Wt=n(G),Je=i(G,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-a2aodj"&&(Je.innerHTML=no),Lt=n(G),Ze=i(G,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-179z5e8"&&(Ze.innerHTML=ro),Ft=n(G),We=i(G,"P",{"data-svelte-h":!0}),f(We)!=="svelte-5bouux"&&(We.textContent=ao),G.forEach(c),a.forEach(c),Ve=n(e),Ie=i(e,"P",{}),C(Ie).forEach(c),this.h()},h(){$(d,"name","hf:doc:metadata"),$(d,"content",wo),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,d),w(e,k,p),w(e,m,p),w(e,h,p),_(x,e,p),w(e,l,p),w(e,P,p),w(e,De,p),w(e,X,p),w(e,qe,p),_(Y,e,p),w(e,He,p),w(e,r,p),_(Q,r,null),t(r,Oe),t(r,he),t(r,Ke),_(W,r,null),t(r,et),t(r,ge),t(r,tt),t(r,ue),t(r,ot),t(r,_e),t(r,nt),t(r,be),t(r,rt),t(r,j),_(O,j,null),t(j,at),t(j,ye),t(j,st),_(L,j,null),t(r,it),t(r,F),_(K,F,null),t(F,dt),t(F,ve),t(r,ct),t(r,I),_(ee,I,null),t(I,lt),t(I,we),t(r,mt),t(r,D),_(te,D,null),t(D,ft),t(D,xe),t(r,pt),t(r,z),_(oe,z,null),t(z,ht),t(z,Ce),t(z,gt),_(q,z,null),t(r,ut),t(r,H),_(ne,H,null),t(H,_t),t(H,$e),t(r,bt),t(r,J),_(re,J,null),t(J,yt),t(J,ke),t(J,vt),_(V,J,null),t(r,wt),t(r,N),_(ae,N,null),t(N,xt),t(N,Pe),t(r,Ct),t(r,B),_(se,B,null),t(B,$t),t(B,Te),t(r,kt),t(r,E),_(ie,E,null),t(E,Pt),t(E,Me),t(r,Tt),t(r,S),_(de,S,null),t(S,Mt),t(S,Ue),t(r,Ut),t(r,R),_(ce,R,null),t(R,jt),t(R,je),t(r,zt),t(r,A),_(le,A,null),t(A,Jt),t(A,ze),t(r,Zt),t(r,M),_(me,M,null),t(M,Wt),t(M,Je),t(M,Lt),t(M,Ze),t(M,Ft),t(M,We),w(e,Ve,p),w(e,Ie,p),Ne=!0},p(e,[p]){const a={};p&2&&(a.$$scope={dirty:p,ctx:e}),W.$set(a);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),L.$set(Z);const fe={};p&2&&(fe.$$scope={dirty:p,ctx:e}),q.$set(fe);const pe={};p&2&&(pe.$$scope={dirty:p,ctx:e}),V.$set(pe)},i(e){Ne||(b(x.$$.fragment,e),b(Y.$$.fragment,e),b(Q.$$.fragment,e),b(W.$$.fragment,e),b(O.$$.fragment,e),b(L.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(q.$$.fragment,e),b(ne.$$.fragment,e),b(re.$$.fragment,e),b(V.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(le.$$.fragment,e),b(me.$$.fragment,e),Ne=!0)},o(e){y(x.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(W.$$.fragment,e),y(O.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(q.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(V.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(ce.$$.fragment,e),y(le.$$.fragment,e),y(me.$$.fragment,e),Ne=!1},d(e){e&&(c(k),c(m),c(h),c(l),c(P),c(De),c(X),c(qe),c(He),c(r),c(Ve),c(Ie)),c(d),v(x,e),v(Y,e),v(Q),v(W),v(O),v(L),v(K),v(ee),v(te),v(oe),v(q),v(ne),v(re),v(V),v(ae),v(se),v(ie),v(de),v(ce),v(le),v(me)}}}const wo='{"title":"Configuration","local":"configuration","sections":[{"title":"PretrainedConfig","local":"transformers.PretrainedConfig","sections":[],"depth":2}],"depth":1}';function xo(U){return fo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jo extends po{constructor(d){super(),ho(this,d,xo,vo,mo,{})}}export{jo as component};
