import{s as zl,n as Vl,o as Wl}from"../chunks/scheduler.889ebb13.js";import{S as Bl,i as Rl,g as p,s as e,r as c,A as El,h as M,f as t,c as n,j as vl,u as j,x as i,k as _l,y as ql,a,v as m,d as o,t as U,w as h}from"../chunks/index.b9ddb21d.js";import{C as J}from"../chunks/CodeBlock.15ac7ec2.js";import{H as cs}from"../chunks/Heading.77ad4fb6.js";function Hl(Ml){let y,os,js,Us,T,hs,g,Js,r,il=`LLM（Language Model）のますます一般的な使用事例の1つは「チャット」です。
チャットのコンテキストでは、通常の言語モデルのように単一のテキストストリングを継続するのではなく、モデルは1つ以上の「メッセージ」からなる会話を継続します。
各メッセージには「ロール」とメッセージテキストが含まれます。`,ys,w,cl=`最も一般的に、これらのロールはユーザーからのメッセージには「ユーザー」、モデルからのメッセージには「アシスタント」が割り当てられます。
一部のモデルは「システム」ロールもサポートしています。
システムメッセージは通常会話の開始時に送信され、モデルの動作方法に関する指示が含まれます。`,Ts,d,jl=`すべての言語モデル、チャット用に微調整されたモデルを含むすべてのモデルは、トークンのリニアシーケンスで動作し、ロールに特有の特別な処理を持ちません。
つまり、ロール情報は通常、メッセージ間に制御トークンを追加して注入され、メッセージの境界と関連するロールを示すことで提供されます。`,gs,I,ml=`残念ながら、トークンの使用方法については（まだ！）標準が存在せず、異なるモデルはチャット用のフォーマットや制御トークンが大きく異なる形式でトレーニングされています。
これはユーザーにとって実際の問題になる可能性があります。正しいフォーマットを使用しないと、モデルは入力に混乱し、パフォーマンスが本来よりも遥かに低下します。
これが「チャットテンプレート」が解決しようとする問題です。`,rs,u,ol=`チャット会話は通常、各辞書が「ロール」と「コンテンツ」のキーを含み、単一のチャットメッセージを表すリストとして表現されます。
チャットテンプレートは、指定されたモデルの会話を単一のトークン化可能なシーケンスにどのようにフォーマットするかを指定するJinjaテンプレートを含む文字列です。
トークナイザとこの情報を保存することにより、モデルが期待する形式の入力データを取得できるようになります。`,ws,C,Ul="さっそく、<code>BlenderBot</code> モデルを使用した例を示して具体的にしましょう。<code>BlenderBot</code> のデフォルトテンプレートは非常にシンプルで、ほとんどが対話のラウンド間に空白を追加するだけです。",ds,x,Is,f,hl=`指定された通り、チャット全体が単一の文字列にまとめられています。デフォルトの設定である「tokenize=True」を使用すると、
その文字列もトークン化されます。しかし、より複雑なテンプレートが実際にどのように機能するかを確認するために、
「meta-llama/Llama-2-7b-chat-hf」モデルを使用してみましょう。ただし、このモデルはゲート付きアクセスを持っており、
このコードを実行する場合は<a href="https://huggingface.co/meta-llama/Llama-2-7b-chat-hf" rel="nofollow">リポジトリでアクセスをリクエスト</a>する必要があります。`,us,b,Cs,N,Jl="今回、トークナイザは制御トークン [INST] と [/INST] を追加しました。これらはユーザーメッセージの開始と終了を示すためのものです（ただし、アシスタントメッセージには適用されません！）",xs,Q,fs,A,yl="モデルのチャットテンプレートは、<code>tokenizer.chat_template</code>属性に格納されています。チャットテンプレートが設定されていない場合、そのモデルクラスのデフォルトテンプレートが代わりに使用されます。<code>BlenderBot</code>のテンプレートを見てみましょう:",bs,$,Ns,Z,Tl=`これは少し抑圧的ですね。可読性を高めるために、新しい行とインデントを追加しましょう。
各ブロックの直前の空白と、ブロックの直後の最初の改行は、デフォルトでJinjaの <code>trim_blocks</code> および <code>lstrip_blocks</code> フラグを使用して削除します。
これにより、インデントと改行を含むテンプレートを書いても正常に機能することができます。`,Qs,S,As,k,gl=`これが初めて見る方へ、これは<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinjaテンプレート</a>です。
Jinjaはテキストを生成するためのシンプルなコードを記述できるテンプレート言語です。多くの点で、コードと
構文はPythonに似ています。純粋なPythonでは、このテンプレートは次のようになるでしょう：`,$s,G,Zs,v,rl="実際に、このテンプレートは次の3つのことを行います：",Ss,_,wl="<li>各メッセージに対して、メッセージがユーザーメッセージである場合、それの前に空白を追加し、それ以外の場合は何も表示しません。</li> <li>メッセージの内容を追加します。</li> <li>メッセージが最後のメッセージでない場合、その後に2つのスペースを追加します。最後のメッセージの後にはEOSトークンを表示します。</li>",ks,z,dl=`これは非常にシンプルなテンプレートです。制御トークンを追加しないし、モデルに対する指示を伝える一般的な方法である「システム」メッセージをサポートしていません。
ただし、Jinjaはこれらのことを行うための多くの柔軟性を提供しています！
LLaMAがフォーマットする方法に類似した入力をフォーマットするためのJinjaテンプレートを見てみましょう
（実際のLLaMAテンプレートはデフォルトのシステムメッセージの処理や、一般的なシステムメッセージの処理が若干異なるため、
実際のコードではこのテンプレートを使用しないでください！）`,Gs,V,vs,W,Il=`願わくば、少し見つめていただければ、このテンプレートが何を行っているかがわかるかもしれません。
このテンプレートは、各メッセージの「役割」に基づいて特定のトークンを追加します。これらのトークンは、メッセージを送信した人を表すものです。
ユーザー、アシスタント、およびシステムメッセージは、それらが含まれるトークンによってモデルによって明確に区別されます。`,_s,B,zs,R,ul=`簡単です。単純にJinjaテンプレートを書いて、<code>tokenizer.chat_template</code>を設定します。
他のモデルから既存のテンプレートを始点にして、必要に応じて編集すると便利かもしれません！
例えば、上記のLLaMAテンプレートを取って、アシスタントメッセージに”[ASST]“と”[/ASST]“を追加できます。`,Vs,E,Ws,q,Cl=`次に、単に<code>tokenizer.chat_template</code>属性を設定してください。
次回、<code>apply_chat_template()</code>を使用する際に、新しいテンプレートが使用されます！
この属性は<code>tokenizer_config.json</code>ファイルに保存されるため、<code>push_to_hub()</code>を使用して
新しいテンプレートをHubにアップロードし、みんなが正しいテンプレートを使用していることを確認できます！`,Bs,H,Rs,X,xl=`<code>apply_chat_template()</code> メソッドは、あなたのチャットテンプレートを使用するために <code>ConversationalPipeline</code> クラスによって呼び出されます。
したがって、正しいチャットテンプレートを設定すると、あなたのモデルは自動的に <code>ConversationalPipeline</code> と互換性があるようになります。`,Es,F,qs,Y,fl=`チャットテンプレートの導入前に、チャットの処理はモデルクラスレベルでハードコードされていました。
後方互換性のために、このクラス固有の処理をデフォルトテンプレートとして保持し、クラスレベルで設定されています。
モデルにチャットテンプレートが設定されていない場合、ただしモデルクラスのデフォルトテンプレートがある場合、
<code>ConversationalPipeline</code>クラスや<code>apply_chat_template</code>などのメソッドはクラステンプレートを使用します。
トークナイザのデフォルトのチャットテンプレートを確認するには、<code>tokenizer.default_chat_template</code>属性をチェックしてください。`,Hs,L,bl=`これは、後方互換性のために純粋に行っていることで、既存のワークフローを壊さないようにしています。
モデルにとってクラステンプレートが適切である場合でも、デフォルトテンプレートをオーバーライドして
<code>chat_template</code>属性を明示的に設定することを強くお勧めします。これにより、ユーザーにとって
モデルがチャット用に正しく構成されていることが明確になり、デフォルトテンプレートが変更されたり廃止された場合に備えることができます。`,Xs,P,Fs,D,Nl=`すでにチャットのトレーニングを受けたモデルのテンプレートを設定する場合、テンプレートがトレーニング中にモデルが見たメッセージのフォーマットとまったく一致することを確認する必要があります。
そうでない場合、性能の低下を経験する可能性が高いです。これはモデルをさらにトレーニングしている場合でも同様です - チャットトークンを一定に保つと、おそらく最高の性能が得られます。
これはトークン化と非常に類似しており、通常はトレーニング中に使用されたトークン化と正確に一致する場合に、推論またはファインチューニングの際に最良の性能が得られます。`,Ys,K,Ql=`一方、ゼロからモデルをトレーニングするか、チャットのためにベース言語モデルをファインチューニングする場合、適切なテンプレートを選択する自由度があります。
LLM（Language Model）はさまざまな入力形式を処理できるほどスマートです。クラス固有のテンプレートがないモデル用のデフォルトテンプレートは、一般的なユースケースに対して良い柔軟な選択肢です。
これは、<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatMLフォーマット</a>に従ったもので、多くのユースケースに適しています。次のようになります：`,Ls,O,Ps,ss,Al="If you like this one, here it is in one-liner form, ready to copy into your code:",Ds,ls,Ks,ts,$l=`このテンプレートは、各メッセージを「“」トークンで囲み、役割を文字列として単純に記述します。
これにより、トレーニングで使用する役割に対する柔軟性が得られます。出力は以下のようになります：`,Os,as,sl,es,Zl=`「ユーザー」、「システム」、および「アシスタント」の役割は、チャットの標準です。
特に、<code>ConversationalPipeline</code>との連携をスムーズに行う場合には、これらの役割を使用することをお勧めします。ただし、これらの役割に制約はありません。テンプレートは非常に柔軟で、任意の文字列を役割として使用できます。`,ll,ns,tl,ps,Sl=`チャットモデルを持っている場合、そのモデルの<code>tokenizer.chat_template</code>属性を設定し、<code>apply_chat_template()</code>を使用してテストする必要があります。
これはモデルの所有者でない場合でも適用されます。モデルのリポジトリが空のチャットテンプレートを使用している場合、またはデフォルトのクラステンプレートを使用している場合でも、
この属性を適切に設定できるように<a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">プルリクエスト</a>を開いてください。`,al,Ms,kl=`一度属性が設定されれば、それで完了です！ <code>tokenizer.apply_chat_template</code>は、そのモデルに対して正しく動作するようになります。これは、
<code>ConversationalPipeline</code>などの場所でも自動的にサポートされます。`,el,is,Gl=`モデルがこの属性を持つことを確認することで、オープンソースモデルの全コミュニティがそのフルパワーを使用できるようになります。
フォーマットの不一致はこの分野に悩み続け、パフォーマンスに黙って影響を与えてきました。それを終わらせる時が来ました！`,nl,ms,pl;return T=new cs({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),g=new cs({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),x=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),b=new J({props:{code:"JTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGxpa2UlMjB0byUyMHNob3clMjBvZmYlMjBob3clMjBjaGF0JTIwdGVtcGxhdGluZyUyMHdvcmtzISUyMiU3RCUyQyUwQSU1RCUwQQ==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

&gt;&gt; chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

&gt;&gt; tokenizer.use_default_system_prompt = <span class="hljs-literal">False</span>
&gt;&gt; tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today? &lt;/s&gt;&lt;s&gt;[INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),Q=new cs({props:{title:"How do chat templates work?",local:"how-do-chat-templates-work",headingTag:"h2"}}),$=new J({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),S=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),G=new J({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),V=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),B=new cs({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h2"}}),E=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),H=new J({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),F=new cs({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h2"}}),P=new cs({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h2"}}),O=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ls=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),as=new J({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful chatbot that will <span class="hljs-built_in">do</span> its best not to say anything so stupid that people tweet about it.&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
How are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing great!&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),ns=new cs({props:{title:"I want to use chat templates! How should I get started?",local:"i-want-to-use-chat-templates-how-should-i-get-started",headingTag:"h2"}}),{c(){y=p("meta"),os=e(),js=p("p"),Us=e(),c(T.$$.fragment),hs=e(),c(g.$$.fragment),Js=e(),r=p("p"),r.textContent=il,ys=e(),w=p("p"),w.textContent=cl,Ts=e(),d=p("p"),d.textContent=jl,gs=e(),I=p("p"),I.textContent=ml,rs=e(),u=p("p"),u.textContent=ol,ws=e(),C=p("p"),C.innerHTML=Ul,ds=e(),c(x.$$.fragment),Is=e(),f=p("p"),f.innerHTML=hl,us=e(),c(b.$$.fragment),Cs=e(),N=p("p"),N.textContent=Jl,xs=e(),c(Q.$$.fragment),fs=e(),A=p("p"),A.innerHTML=yl,bs=e(),c($.$$.fragment),Ns=e(),Z=p("p"),Z.innerHTML=Tl,Qs=e(),c(S.$$.fragment),As=e(),k=p("p"),k.innerHTML=gl,$s=e(),c(G.$$.fragment),Zs=e(),v=p("p"),v.textContent=rl,Ss=e(),_=p("ol"),_.innerHTML=wl,ks=e(),z=p("p"),z.textContent=dl,Gs=e(),c(V.$$.fragment),vs=e(),W=p("p"),W.textContent=Il,_s=e(),c(B.$$.fragment),zs=e(),R=p("p"),R.innerHTML=ul,Vs=e(),c(E.$$.fragment),Ws=e(),q=p("p"),q.innerHTML=Cl,Bs=e(),c(H.$$.fragment),Rs=e(),X=p("p"),X.innerHTML=xl,Es=e(),c(F.$$.fragment),qs=e(),Y=p("p"),Y.innerHTML=fl,Hs=e(),L=p("p"),L.innerHTML=bl,Xs=e(),c(P.$$.fragment),Fs=e(),D=p("p"),D.textContent=Nl,Ys=e(),K=p("p"),K.innerHTML=Ql,Ls=e(),c(O.$$.fragment),Ps=e(),ss=p("p"),ss.textContent=Al,Ds=e(),c(ls.$$.fragment),Ks=e(),ts=p("p"),ts.textContent=$l,Os=e(),c(as.$$.fragment),sl=e(),es=p("p"),es.innerHTML=Zl,ll=e(),c(ns.$$.fragment),tl=e(),ps=p("p"),ps.innerHTML=Sl,al=e(),Ms=p("p"),Ms.innerHTML=kl,el=e(),is=p("p"),is.textContent=Gl,nl=e(),ms=p("p"),this.h()},l(s){const l=El("svelte-u9bgzb",document.head);y=M(l,"META",{name:!0,content:!0}),l.forEach(t),os=n(s),js=M(s,"P",{}),vl(js).forEach(t),Us=n(s),j(T.$$.fragment,s),hs=n(s),j(g.$$.fragment,s),Js=n(s),r=M(s,"P",{"data-svelte-h":!0}),i(r)!=="svelte-jcsv73"&&(r.textContent=il),ys=n(s),w=M(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1mxrdfa"&&(w.textContent=cl),Ts=n(s),d=M(s,"P",{"data-svelte-h":!0}),i(d)!=="svelte-cfkcz6"&&(d.textContent=jl),gs=n(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1bxzw8o"&&(I.textContent=ml),rs=n(s),u=M(s,"P",{"data-svelte-h":!0}),i(u)!=="svelte-s4iwrm"&&(u.textContent=ol),ws=n(s),C=M(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-16z6my6"&&(C.innerHTML=Ul),ds=n(s),j(x.$$.fragment,s),Is=n(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1fy4nei"&&(f.innerHTML=hl),us=n(s),j(b.$$.fragment,s),Cs=n(s),N=M(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-5sqrb2"&&(N.textContent=Jl),xs=n(s),j(Q.$$.fragment,s),fs=n(s),A=M(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-pa95ib"&&(A.innerHTML=yl),bs=n(s),j($.$$.fragment,s),Ns=n(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-nbi27v"&&(Z.innerHTML=Tl),Qs=n(s),j(S.$$.fragment,s),As=n(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-2fl0dp"&&(k.innerHTML=gl),$s=n(s),j(G.$$.fragment,s),Zs=n(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1gikd0q"&&(v.textContent=rl),Ss=n(s),_=M(s,"OL",{"data-svelte-h":!0}),i(_)!=="svelte-13hrl3j"&&(_.innerHTML=wl),ks=n(s),z=M(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-7a7s95"&&(z.textContent=dl),Gs=n(s),j(V.$$.fragment,s),vs=n(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1sw12sq"&&(W.textContent=Il),_s=n(s),j(B.$$.fragment,s),zs=n(s),R=M(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1706a1k"&&(R.innerHTML=ul),Vs=n(s),j(E.$$.fragment,s),Ws=n(s),q=M(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-ixihr9"&&(q.innerHTML=Cl),Bs=n(s),j(H.$$.fragment,s),Rs=n(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-zfpmhe"&&(X.innerHTML=xl),Es=n(s),j(F.$$.fragment,s),qs=n(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-tbutjc"&&(Y.innerHTML=fl),Hs=n(s),L=M(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-t6wo99"&&(L.innerHTML=bl),Xs=n(s),j(P.$$.fragment,s),Fs=n(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-ixwipa"&&(D.textContent=Nl),Ys=n(s),K=M(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-rms13q"&&(K.innerHTML=Ql),Ls=n(s),j(O.$$.fragment,s),Ps=n(s),ss=M(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-33pzk5"&&(ss.textContent=Al),Ds=n(s),j(ls.$$.fragment,s),Ks=n(s),ts=M(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-14x3uea"&&(ts.textContent=$l),Os=n(s),j(as.$$.fragment,s),sl=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-b979ui"&&(es.innerHTML=Zl),ll=n(s),j(ns.$$.fragment,s),tl=n(s),ps=M(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1t4e7wt"&&(ps.innerHTML=Sl),al=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-1ufv0c0"&&(Ms.innerHTML=kl),el=n(s),is=M(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-16sk2j3"&&(is.textContent=Gl),nl=n(s),ms=M(s,"P",{}),vl(ms).forEach(t),this.h()},h(){_l(y,"name","hf:doc:metadata"),_l(y,"content",Xl)},m(s,l){ql(document.head,y),a(s,os,l),a(s,js,l),a(s,Us,l),m(T,s,l),a(s,hs,l),m(g,s,l),a(s,Js,l),a(s,r,l),a(s,ys,l),a(s,w,l),a(s,Ts,l),a(s,d,l),a(s,gs,l),a(s,I,l),a(s,rs,l),a(s,u,l),a(s,ws,l),a(s,C,l),a(s,ds,l),m(x,s,l),a(s,Is,l),a(s,f,l),a(s,us,l),m(b,s,l),a(s,Cs,l),a(s,N,l),a(s,xs,l),m(Q,s,l),a(s,fs,l),a(s,A,l),a(s,bs,l),m($,s,l),a(s,Ns,l),a(s,Z,l),a(s,Qs,l),m(S,s,l),a(s,As,l),a(s,k,l),a(s,$s,l),m(G,s,l),a(s,Zs,l),a(s,v,l),a(s,Ss,l),a(s,_,l),a(s,ks,l),a(s,z,l),a(s,Gs,l),m(V,s,l),a(s,vs,l),a(s,W,l),a(s,_s,l),m(B,s,l),a(s,zs,l),a(s,R,l),a(s,Vs,l),m(E,s,l),a(s,Ws,l),a(s,q,l),a(s,Bs,l),m(H,s,l),a(s,Rs,l),a(s,X,l),a(s,Es,l),m(F,s,l),a(s,qs,l),a(s,Y,l),a(s,Hs,l),a(s,L,l),a(s,Xs,l),m(P,s,l),a(s,Fs,l),a(s,D,l),a(s,Ys,l),a(s,K,l),a(s,Ls,l),m(O,s,l),a(s,Ps,l),a(s,ss,l),a(s,Ds,l),m(ls,s,l),a(s,Ks,l),a(s,ts,l),a(s,Os,l),m(as,s,l),a(s,sl,l),a(s,es,l),a(s,ll,l),m(ns,s,l),a(s,tl,l),a(s,ps,l),a(s,al,l),a(s,Ms,l),a(s,el,l),a(s,is,l),a(s,nl,l),a(s,ms,l),pl=!0},p:Vl,i(s){pl||(o(T.$$.fragment,s),o(g.$$.fragment,s),o(x.$$.fragment,s),o(b.$$.fragment,s),o(Q.$$.fragment,s),o($.$$.fragment,s),o(S.$$.fragment,s),o(G.$$.fragment,s),o(V.$$.fragment,s),o(B.$$.fragment,s),o(E.$$.fragment,s),o(H.$$.fragment,s),o(F.$$.fragment,s),o(P.$$.fragment,s),o(O.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),o(ns.$$.fragment,s),pl=!0)},o(s){U(T.$$.fragment,s),U(g.$$.fragment,s),U(x.$$.fragment,s),U(b.$$.fragment,s),U(Q.$$.fragment,s),U($.$$.fragment,s),U(S.$$.fragment,s),U(G.$$.fragment,s),U(V.$$.fragment,s),U(B.$$.fragment,s),U(E.$$.fragment,s),U(H.$$.fragment,s),U(F.$$.fragment,s),U(P.$$.fragment,s),U(O.$$.fragment,s),U(ls.$$.fragment,s),U(as.$$.fragment,s),U(ns.$$.fragment,s),pl=!1},d(s){s&&(t(os),t(js),t(Us),t(hs),t(Js),t(r),t(ys),t(w),t(Ts),t(d),t(gs),t(I),t(rs),t(u),t(ws),t(C),t(ds),t(Is),t(f),t(us),t(Cs),t(N),t(xs),t(fs),t(A),t(bs),t(Ns),t(Z),t(Qs),t(As),t(k),t($s),t(Zs),t(v),t(Ss),t(_),t(ks),t(z),t(Gs),t(vs),t(W),t(_s),t(zs),t(R),t(Vs),t(Ws),t(q),t(Bs),t(Rs),t(X),t(Es),t(qs),t(Y),t(Hs),t(L),t(Xs),t(Fs),t(D),t(Ys),t(K),t(Ls),t(Ps),t(ss),t(Ds),t(Ks),t(ts),t(Os),t(sl),t(es),t(ll),t(tl),t(ps),t(al),t(Ms),t(el),t(is),t(nl),t(ms)),t(y),h(T,s),h(g,s),h(x,s),h(b,s),h(Q,s),h($,s),h(S,s),h(G,s),h(V,s),h(B,s),h(E,s),h(H,s),h(F,s),h(P,s),h(O,s),h(ls,s),h(as,s),h(ns,s)}}}const Xl='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do chat templates work?","local":"how-do-chat-templates-work","sections":[],"depth":2},{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":2},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":2},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":2},{"title":"I want to use chat templates! How should I get started?","local":"i-want-to-use-chat-templates-how-should-i-get-started","sections":[],"depth":2}],"depth":1}';function Fl(Ml){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Bl{constructor(y){super(),Rl(this,y,Fl,Hl,zl,{})}}export{Kl as component};
