import{s as Gt,o as Vt,n as Se}from"../chunks/scheduler.889ebb13.js";import{S as Yt,i as xt,g as a,s as n,r as o,A as Qt,h as i,f as t,c as M,j as vt,u as m,x as p,k as Xt,y as Et,a as s,v as c,d as J,t as d,w}from"../chunks/index.b9ddb21d.js";import{T as Fe}from"../chunks/Tip.ebe17e87.js";import{C as j}from"../chunks/CodeBlock.15ac7ec2.js";import{H as Nl}from"../chunks/Heading.77ad4fb6.js";function Ht(f){let y,r="モデルがライブラリ内のモデルと非常に似ている場合、このモデルと同じ構成を再利用できます。";return{c(){y=a("p"),y.textContent=r},l(T){y=i(T,"P",{"data-svelte-h":!0}),p(y)!=="svelte-ezhjpv"&&(y.textContent=r)},m(T,U){s(T,y,U)},p:Se,d(T){T&&t(y)}}}function zt(f){let y,r="このAPIは実験的であり、次のリリースでわずかな変更があるかもしれません。";return{c(){y=a("p"),y.textContent=r},l(T){y=i(T,"P",{"data-svelte-h":!0}),p(y)!=="svelte-x2rm6d"&&(y.textContent=r)},m(T,U){s(T,y,U)},p:Se,d(T){T&&t(y)}}}function Ft(f){let y,r="ライブラリからモデリングファイルをコピーする場合、ファイルの先頭にあるすべての相対インポートを<code>transformers</code>パッケージからインポートに置き換える必要があります。";return{c(){y=a("p"),y.innerHTML=r},l(T){y=i(T,"P",{"data-svelte-h":!0}),p(y)!=="svelte-18u9vuk"&&(y.innerHTML=r)},m(T,U){s(T,y,U)},p:Se,d(T){T&&t(y)}}}function St(f){let y,r,T,U,I,Wl,Z,Le="🤗 Transformersライブラリは、簡単に拡張できるように設計されています。すべてのモデルはリポジトリの特定のサブフォルダに完全にコード化されており、抽象化はありません。したがって、モデリングファイルをコピーして調整することが簡単です。",Rl,_,qe="新しいモデルを書いている場合、ゼロから始める方が簡単かもしれません。このチュートリアルでは、カスタムモデルとその設定をどのように書き、Transformers内で使用できるようにし、コードに依存する共同体と共有する方法を説明します。ライブラリに存在しない場合でも、誰でも使用できるようにします。",vl,h,Pe='これを実証するために、<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timmライブラリ</a>のResNetクラスを<code>PreTrainedModel</code>にラップすることによって、ResNetモデルを使用します。',Xl,g,Gl,A,De="モデルに取り組む前に、まずその設定を書きましょう。モデルの設定は、モデルを構築するために必要なすべての情報を含むオブジェクトです。次のセクションで見るように、モデルは初期化するために<code>config</code>しか受け取ることができないため、そのオブジェクトができるだけ完全である必要があります。",Vl,$,Ke="この例では、ResNetクラスのいくつかの引数を取得し、調整したいかもしれないとします。異なる設定は、異なるタイプのResNetを提供します。その後、これらの引数を確認した後、それらの引数を単に格納します。",Yl,k,xl,N,Oe="重要なことを3つ覚えておくべきポイントは次のとおりです：",Ql,B,lt="<li><code>PretrainedConfig</code> を継承する必要があります。</li> <li>あなたの <code>PretrainedConfig</code> の <code>__init__</code> は任意の kwargs を受け入れる必要があります。</li> <li>これらの <code>kwargs</code> は親クラスの <code>__init__</code> に渡す必要があります。</li>",El,W,et=`継承は、🤗 Transformers ライブラリのすべての機能を取得できるようにするためです。他の2つの制約は、
<code>PretrainedConfig</code> が設定しているフィールド以外にも多くのフィールドを持っていることから来ています。
<code>from_pretrained</code> メソッドで設定を再ロードする場合、これらのフィールドはあなたの設定に受け入れられ、
その後、親クラスに送信される必要があります。`,Hl,R,tt=`設定の <code>model_type</code> を定義すること（ここでは <code>model_type=&quot;resnet&quot;</code>）は、
自動クラスにモデルを登録したい場合を除いては必須ではありません（最後のセクションを参照）。`,zl,v,st=`これで、ライブラリの他のモデル設定と同様に、設定を簡単に作成して保存できます。
以下は、resnet50d 設定を作成して保存する方法の例です：`,Fl,X,Sl,G,nt="これにより、<code>custom-resnet</code> フォルダ内に <code>config.json</code> という名前のファイルが保存されます。その後、<code>from_pretrained</code> メソッドを使用して構成を再ロードできます。",Ll,V,ql,Y,Mt="また、<code>PretrainedConfig</code> クラスの他のメソッドを使用することもできます。たとえば、<code>push_to_hub()</code> を使用して、設定を直接 Hub にアップロードできます。",Pl,x,Dl,Q,at="ResNet の設定ができたので、モデルを書き始めることができます。実際には2つのモデルを書きます。1つはバッチの画像から隠れた特徴を抽出するモデル（<code>BertModel</code> のようなもの）で、もう1つは画像分類に適したモデル（<code>BertForSequenceClassification</code> のようなもの）です。",Kl,E,it="前述したように、この例をシンプルに保つために、モデルの緩いラッパーのみを書きます。このクラスを書く前に行う必要がある唯一のことは、ブロックタイプと実際のブロッククラスの間のマップです。その後、すべてを <code>ResNet</code> クラスに渡して設定からモデルを定義します：",Ol,H,le,z,pt="画像を分類するモデルの場合、forwardメソッドを変更するだけです：",ee,F,te,S,yt=`両方の場合、<code>PreTrainedModel</code>から継承し、<code>config</code>を使用してスーパークラスの初期化を呼び出します（通常の<code>torch.nn.Module</code>を書くときのような感じです）。
<code>config_class</code>を設定する行は必須ではありませんが、（最後のセクションを参照）、モデルを自動クラスに登録したい場合に使用できます。`,se,u,ne,L,ot=`モデルが返す内容は何でも構いませんが、ラベルが渡されるときに損失を含む辞書を返す（<code>ResnetModelForImageClassification</code>のように行ったもの）と、
モデルを<code>Trainer</code>クラス内で直接使用できるようになります。独自のトレーニングループまたは他のライブラリを使用する予定である限り、
別の出力形式を使用することも問題ありません。`,Me,q,mt="さて、モデルクラスができたので、1つ作成しましょう：",ae,P,ie,D,ct=`再度、<code>PreTrainedModel</code>のいずれかのメソッド、例えば<code>save_pretrained()</code>や
<code>push_to_hub()</code>などを使用できます。次のセクションでは、モデルの重みをコードと一緒に
Hugging Face Hub にプッシュする方法を見てみます。
しかし、まずはモデル内に事前学習済みの重みをロードしましょう。`,pe,K,Jt=`独自のユースケースでは、おそらく独自のデータでカスタムモデルをトレーニングすることになるでしょう。
このチュートリアルではスピードアップのために、resnet50dの事前学習済みバージョンを使用します。
私たちのモデルはそれをラップするだけなので、これらの重みを転送するのは簡単です：`,ye,O,oe,ll,dt=`さて、<code>save_pretrained()</code>または<code>push_to_hub()</code>を実行したときに、
モデルのコードが保存されるようにする方法を見てみましょう。`,me,el,ce,C,Je,tl,wt=`まず、モデルが<code>.py</code>ファイルに完全に定義されていることを確認してください。
ファイルは相対インポートを他のファイルに依存できますが、すべてのファイルが同じディレクトリにある限り（まだこの機能ではサブモジュールはサポートしていません）、問題ありません。
この例では、現在の作業ディレクトリ内に名前が「resnet_model」のフォルダを作成し、その中に<code>modeling_resnet.py</code>ファイルと<code>configuration_resnet.py</code>ファイルを定義します。
構成ファイルには<code>ResnetConfig</code>のコードが含まれ、モデリングファイルには<code>ResnetModel</code>と<code>ResnetModelForImageClassification</code>のコードが含まれています。`,de,sl,we,nl,Tt="<code>__init__.py</code>は空であっても問題ありません。Pythonが<code>resnet_model</code>をモジュールとして検出できるようにするために存在します。",Te,b,je,Ml,jt="既存の設定やモデルを再利用（またはサブクラス化）できることに注意してください。",re,al,rt="コミュニティとモデルを共有するために、次の手順に従ってください：まず、新しく作成したファイルからResNetモデルと設定をインポートします：",Ue,il,fe,pl,Ut="次に、<code>save_pretrained</code>メソッドを使用してこれらのオブジェクトのコードファイルをコピーし、特定のAutoクラス（特にモデルの場合）に正しく登録するようライブラリに指示する必要があります。次のように実行します：",ue,yl,Ce,ol,ft=`注意: 設定については自動クラスを指定する必要はありません（設定用の自動クラスは1つしかなく、<code>AutoConfig</code>です）が、
モデルについては異なります。カスタムモデルは多くの異なるタスクに適している可能性があるため、
モデルが正確な自動クラスのうちどれに適しているかを指定する必要があります。`,be,ml,ut="次に、前述のように設定とモデルを作成しましょう：",Ie,cl,Ze,Jl,Ct="モデルをHubに送信するには、ログインしていることを確認してください。ターミナルで次のコマンドを実行します：",_e,dl,he,wl,bt="またはノートブックから：",ge,Tl,Ae,jl,It="次に、次のようにして、独自の名前空間にプッシュできます（または、メンバーである組織にプッシュできます）：",$e,rl,ke,Ul,Zt='モデリングの重みとJSON形式の構成に加えて、このフォルダー「custom-resnet50d」内のモデリングおよび構成「.py」ファイルもコピーされ、結果はHubにアップロードされました。結果はこの<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>で確認できます。',Ne,fl,_t='詳細については、<a href="model_sharing">Hubへのプッシュ方法</a>を参照してください。',Be,ul,We,Cl,ht=`自動クラスと <code>from_pretrained</code> メソッドを使用して、リポジトリ内のカスタムコードファイルと共に任意の構成、モデル、またはトークナイザを使用できます。 Hubにアップロードされるすべてのファイルとコードはマルウェアのスキャンが実施されます（詳細は<a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hubセキュリティ</a>ドキュメンテーションを参照してください）、しかし、依然として悪意のあるコードを実行しないために、モデルコードと作者を確認する必要があります。
<code>trust_remote_code=True</code> を設定してカスタムコードを持つモデルを使用できます：`,Re,bl,ve,Il,gt="コミットハッシュを「revision」として渡すことも強く推奨されています。これにより、モデルの作者がコードを悪意のある新しい行で更新しなかったことを確認できます（モデルの作者を完全に信頼している場合を除きます）。",Xe,Zl,Ge,_l,At="モデルリポジトリのコミット履歴をブラウジングする際には、任意のコミットのコミットハッシュを簡単にコピーできるボタンがあります。",Ve,hl,Ye,gl,$t=`🤗 Transformersを拡張するライブラリを作成している場合、独自のモデルを含めるために自動クラスを拡張したい場合があります。
これはコードをHubにプッシュすることとは異なり、ユーザーはカスタムモデルを取得するためにあなたのライブラリをインポートする必要があります
（Hubからモデルコードを自動的にダウンロードするのとは対照的です）。`,xe,Al,kt=`構成に既存のモデルタイプと異なる <code>model_type</code> 属性がある限り、またあなたのモデルクラスが適切な <code>config_class</code> 属性を持っている限り、
次のようにそれらを自動クラスに追加できます：`,Qe,$l,Ee,kl,Nt=`注意: <code>AutoConfig</code> にカスタム設定を登録する際の最初の引数は、カスタム設定の <code>model_type</code> と一致する必要があります。
また、任意の自動モデルクラスにカスタムモデルを登録する際の最初の引数は、それらのモデルの <code>config_class</code> と一致する必要があります。`,He,Bl,ze;return I=new Nl({props:{title:"Sharing custom models",local:"sharing-custom-models",headingTag:"h1"}}),g=new Nl({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),V=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),x=new Nl({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Fe({props:{$$slots:{default:[Ht]},$$scope:{ctx:f}}}),P=new j({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Nl({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),C=new Fe({props:{warning:!0,$$slots:{default:[zt]},$$scope:{ctx:f}}}),sl=new j({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Fe({props:{warning:!0,$$slots:{default:[Ft]},$$scope:{ctx:f}}}),il=new j({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),yl=new j({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),cl=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),dl=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Tl=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),rl=new j({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ul=new Nl({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),bl=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Zl=new j({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Nl({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),$l=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){y=a("meta"),r=n(),T=a("p"),U=n(),o(I.$$.fragment),Wl=n(),Z=a("p"),Z.textContent=Le,Rl=n(),_=a("p"),_.textContent=qe,vl=n(),h=a("p"),h.innerHTML=Pe,Xl=n(),o(g.$$.fragment),Gl=n(),A=a("p"),A.innerHTML=De,Vl=n(),$=a("p"),$.textContent=Ke,Yl=n(),o(k.$$.fragment),xl=n(),N=a("p"),N.textContent=Oe,Ql=n(),B=a("ul"),B.innerHTML=lt,El=n(),W=a("p"),W.innerHTML=et,Hl=n(),R=a("p"),R.innerHTML=tt,zl=n(),v=a("p"),v.textContent=st,Fl=n(),o(X.$$.fragment),Sl=n(),G=a("p"),G.innerHTML=nt,Ll=n(),o(V.$$.fragment),ql=n(),Y=a("p"),Y.innerHTML=Mt,Pl=n(),o(x.$$.fragment),Dl=n(),Q=a("p"),Q.innerHTML=at,Kl=n(),E=a("p"),E.innerHTML=it,Ol=n(),o(H.$$.fragment),le=n(),z=a("p"),z.textContent=pt,ee=n(),o(F.$$.fragment),te=n(),S=a("p"),S.innerHTML=yt,se=n(),o(u.$$.fragment),ne=n(),L=a("p"),L.innerHTML=ot,Me=n(),q=a("p"),q.textContent=mt,ae=n(),o(P.$$.fragment),ie=n(),D=a("p"),D.innerHTML=ct,pe=n(),K=a("p"),K.textContent=Jt,ye=n(),o(O.$$.fragment),oe=n(),ll=a("p"),ll.innerHTML=dt,me=n(),o(el.$$.fragment),ce=n(),o(C.$$.fragment),Je=n(),tl=a("p"),tl.innerHTML=wt,de=n(),o(sl.$$.fragment),we=n(),nl=a("p"),nl.innerHTML=Tt,Te=n(),o(b.$$.fragment),je=n(),Ml=a("p"),Ml.textContent=jt,re=n(),al=a("p"),al.textContent=rt,Ue=n(),o(il.$$.fragment),fe=n(),pl=a("p"),pl.innerHTML=Ut,ue=n(),o(yl.$$.fragment),Ce=n(),ol=a("p"),ol.innerHTML=ft,be=n(),ml=a("p"),ml.textContent=ut,Ie=n(),o(cl.$$.fragment),Ze=n(),Jl=a("p"),Jl.textContent=Ct,_e=n(),o(dl.$$.fragment),he=n(),wl=a("p"),wl.textContent=bt,ge=n(),o(Tl.$$.fragment),Ae=n(),jl=a("p"),jl.textContent=It,$e=n(),o(rl.$$.fragment),ke=n(),Ul=a("p"),Ul.innerHTML=Zt,Ne=n(),fl=a("p"),fl.innerHTML=_t,Be=n(),o(ul.$$.fragment),We=n(),Cl=a("p"),Cl.innerHTML=ht,Re=n(),o(bl.$$.fragment),ve=n(),Il=a("p"),Il.textContent=gt,Xe=n(),o(Zl.$$.fragment),Ge=n(),_l=a("p"),_l.textContent=At,Ve=n(),o(hl.$$.fragment),Ye=n(),gl=a("p"),gl.textContent=$t,xe=n(),Al=a("p"),Al.innerHTML=kt,Qe=n(),o($l.$$.fragment),Ee=n(),kl=a("p"),kl.innerHTML=Nt,He=n(),Bl=a("p"),this.h()},l(l){const e=Qt("svelte-u9bgzb",document.head);y=i(e,"META",{name:!0,content:!0}),e.forEach(t),r=M(l),T=i(l,"P",{}),vt(T).forEach(t),U=M(l),m(I.$$.fragment,l),Wl=M(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-gxna3m"&&(Z.textContent=Le),Rl=M(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1nn0sjo"&&(_.textContent=qe),vl=M(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-tuv1gg"&&(h.innerHTML=Pe),Xl=M(l),m(g.$$.fragment,l),Gl=M(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-bwvin"&&(A.innerHTML=De),Vl=M(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1q4nzi3"&&($.textContent=Ke),Yl=M(l),m(k.$$.fragment,l),xl=M(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1xagbsn"&&(N.textContent=Oe),Ql=M(l),B=i(l,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-18ieeo"&&(B.innerHTML=lt),El=M(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1hhagdn"&&(W.innerHTML=et),Hl=M(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-u1g66p"&&(R.innerHTML=tt),zl=M(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1cqw2yw"&&(v.textContent=st),Fl=M(l),m(X.$$.fragment,l),Sl=M(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-j8wp82"&&(G.innerHTML=nt),Ll=M(l),m(V.$$.fragment,l),ql=M(l),Y=i(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-is793h"&&(Y.innerHTML=Mt),Pl=M(l),m(x.$$.fragment,l),Dl=M(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-83t4gv"&&(Q.innerHTML=at),Kl=M(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-rnqflg"&&(E.innerHTML=it),Ol=M(l),m(H.$$.fragment,l),le=M(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xqb496"&&(z.textContent=pt),ee=M(l),m(F.$$.fragment,l),te=M(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1gy8gfa"&&(S.innerHTML=yt),se=M(l),m(u.$$.fragment,l),ne=M(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-329yz4"&&(L.innerHTML=ot),Me=M(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-c12zx8"&&(q.textContent=mt),ae=M(l),m(P.$$.fragment,l),ie=M(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-vj3c9u"&&(D.innerHTML=ct),pe=M(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1ysoenl"&&(K.textContent=Jt),ye=M(l),m(O.$$.fragment,l),oe=M(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-1r8b02o"&&(ll.innerHTML=dt),me=M(l),m(el.$$.fragment,l),ce=M(l),m(C.$$.fragment,l),Je=M(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-12w8qw2"&&(tl.innerHTML=wt),de=M(l),m(sl.$$.fragment,l),we=M(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-161l0tk"&&(nl.innerHTML=Tt),Te=M(l),m(b.$$.fragment,l),je=M(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-1sofoh7"&&(Ml.textContent=jt),re=M(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-10ja7ra"&&(al.textContent=rt),Ue=M(l),m(il.$$.fragment,l),fe=M(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-14w73fp"&&(pl.innerHTML=Ut),ue=M(l),m(yl.$$.fragment,l),Ce=M(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1gzi3ms"&&(ol.innerHTML=ft),be=M(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-x4hehz"&&(ml.textContent=ut),Ie=M(l),m(cl.$$.fragment,l),Ze=M(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-4gjqmb"&&(Jl.textContent=Ct),_e=M(l),m(dl.$$.fragment,l),he=M(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-170hls0"&&(wl.textContent=bt),ge=M(l),m(Tl.$$.fragment,l),Ae=M(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-j85q6g"&&(jl.textContent=It),$e=M(l),m(rl.$$.fragment,l),ke=M(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1v5wui"&&(Ul.innerHTML=Zt),Ne=M(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-1r595oo"&&(fl.innerHTML=_t),Be=M(l),m(ul.$$.fragment,l),We=M(l),Cl=i(l,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1rhh9p5"&&(Cl.innerHTML=ht),Re=M(l),m(bl.$$.fragment,l),ve=M(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-6ln3mo"&&(Il.textContent=gt),Xe=M(l),m(Zl.$$.fragment,l),Ge=M(l),_l=i(l,"P",{"data-svelte-h":!0}),p(_l)!=="svelte-1mlo6re"&&(_l.textContent=At),Ve=M(l),m(hl.$$.fragment,l),Ye=M(l),gl=i(l,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1dtzfm7"&&(gl.textContent=$t),xe=M(l),Al=i(l,"P",{"data-svelte-h":!0}),p(Al)!=="svelte-1xrka00"&&(Al.innerHTML=kt),Qe=M(l),m($l.$$.fragment,l),Ee=M(l),kl=i(l,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-1eri869"&&(kl.innerHTML=Nt),He=M(l),Bl=i(l,"P",{}),vt(Bl).forEach(t),this.h()},h(){Xt(y,"name","hf:doc:metadata"),Xt(y,"content",Lt)},m(l,e){Et(document.head,y),s(l,r,e),s(l,T,e),s(l,U,e),c(I,l,e),s(l,Wl,e),s(l,Z,e),s(l,Rl,e),s(l,_,e),s(l,vl,e),s(l,h,e),s(l,Xl,e),c(g,l,e),s(l,Gl,e),s(l,A,e),s(l,Vl,e),s(l,$,e),s(l,Yl,e),c(k,l,e),s(l,xl,e),s(l,N,e),s(l,Ql,e),s(l,B,e),s(l,El,e),s(l,W,e),s(l,Hl,e),s(l,R,e),s(l,zl,e),s(l,v,e),s(l,Fl,e),c(X,l,e),s(l,Sl,e),s(l,G,e),s(l,Ll,e),c(V,l,e),s(l,ql,e),s(l,Y,e),s(l,Pl,e),c(x,l,e),s(l,Dl,e),s(l,Q,e),s(l,Kl,e),s(l,E,e),s(l,Ol,e),c(H,l,e),s(l,le,e),s(l,z,e),s(l,ee,e),c(F,l,e),s(l,te,e),s(l,S,e),s(l,se,e),c(u,l,e),s(l,ne,e),s(l,L,e),s(l,Me,e),s(l,q,e),s(l,ae,e),c(P,l,e),s(l,ie,e),s(l,D,e),s(l,pe,e),s(l,K,e),s(l,ye,e),c(O,l,e),s(l,oe,e),s(l,ll,e),s(l,me,e),c(el,l,e),s(l,ce,e),c(C,l,e),s(l,Je,e),s(l,tl,e),s(l,de,e),c(sl,l,e),s(l,we,e),s(l,nl,e),s(l,Te,e),c(b,l,e),s(l,je,e),s(l,Ml,e),s(l,re,e),s(l,al,e),s(l,Ue,e),c(il,l,e),s(l,fe,e),s(l,pl,e),s(l,ue,e),c(yl,l,e),s(l,Ce,e),s(l,ol,e),s(l,be,e),s(l,ml,e),s(l,Ie,e),c(cl,l,e),s(l,Ze,e),s(l,Jl,e),s(l,_e,e),c(dl,l,e),s(l,he,e),s(l,wl,e),s(l,ge,e),c(Tl,l,e),s(l,Ae,e),s(l,jl,e),s(l,$e,e),c(rl,l,e),s(l,ke,e),s(l,Ul,e),s(l,Ne,e),s(l,fl,e),s(l,Be,e),c(ul,l,e),s(l,We,e),s(l,Cl,e),s(l,Re,e),c(bl,l,e),s(l,ve,e),s(l,Il,e),s(l,Xe,e),c(Zl,l,e),s(l,Ge,e),s(l,_l,e),s(l,Ve,e),c(hl,l,e),s(l,Ye,e),s(l,gl,e),s(l,xe,e),s(l,Al,e),s(l,Qe,e),c($l,l,e),s(l,Ee,e),s(l,kl,e),s(l,He,e),s(l,Bl,e),ze=!0},p(l,[e]){const Bt={};e&2&&(Bt.$$scope={dirty:e,ctx:l}),u.$set(Bt);const Wt={};e&2&&(Wt.$$scope={dirty:e,ctx:l}),C.$set(Wt);const Rt={};e&2&&(Rt.$$scope={dirty:e,ctx:l}),b.$set(Rt)},i(l){ze||(J(I.$$.fragment,l),J(g.$$.fragment,l),J(k.$$.fragment,l),J(X.$$.fragment,l),J(V.$$.fragment,l),J(x.$$.fragment,l),J(H.$$.fragment,l),J(F.$$.fragment,l),J(u.$$.fragment,l),J(P.$$.fragment,l),J(O.$$.fragment,l),J(el.$$.fragment,l),J(C.$$.fragment,l),J(sl.$$.fragment,l),J(b.$$.fragment,l),J(il.$$.fragment,l),J(yl.$$.fragment,l),J(cl.$$.fragment,l),J(dl.$$.fragment,l),J(Tl.$$.fragment,l),J(rl.$$.fragment,l),J(ul.$$.fragment,l),J(bl.$$.fragment,l),J(Zl.$$.fragment,l),J(hl.$$.fragment,l),J($l.$$.fragment,l),ze=!0)},o(l){d(I.$$.fragment,l),d(g.$$.fragment,l),d(k.$$.fragment,l),d(X.$$.fragment,l),d(V.$$.fragment,l),d(x.$$.fragment,l),d(H.$$.fragment,l),d(F.$$.fragment,l),d(u.$$.fragment,l),d(P.$$.fragment,l),d(O.$$.fragment,l),d(el.$$.fragment,l),d(C.$$.fragment,l),d(sl.$$.fragment,l),d(b.$$.fragment,l),d(il.$$.fragment,l),d(yl.$$.fragment,l),d(cl.$$.fragment,l),d(dl.$$.fragment,l),d(Tl.$$.fragment,l),d(rl.$$.fragment,l),d(ul.$$.fragment,l),d(bl.$$.fragment,l),d(Zl.$$.fragment,l),d(hl.$$.fragment,l),d($l.$$.fragment,l),ze=!1},d(l){l&&(t(r),t(T),t(U),t(Wl),t(Z),t(Rl),t(_),t(vl),t(h),t(Xl),t(Gl),t(A),t(Vl),t($),t(Yl),t(xl),t(N),t(Ql),t(B),t(El),t(W),t(Hl),t(R),t(zl),t(v),t(Fl),t(Sl),t(G),t(Ll),t(ql),t(Y),t(Pl),t(Dl),t(Q),t(Kl),t(E),t(Ol),t(le),t(z),t(ee),t(te),t(S),t(se),t(ne),t(L),t(Me),t(q),t(ae),t(ie),t(D),t(pe),t(K),t(ye),t(oe),t(ll),t(me),t(ce),t(Je),t(tl),t(de),t(we),t(nl),t(Te),t(je),t(Ml),t(re),t(al),t(Ue),t(fe),t(pl),t(ue),t(Ce),t(ol),t(be),t(ml),t(Ie),t(Ze),t(Jl),t(_e),t(he),t(wl),t(ge),t(Ae),t(jl),t($e),t(ke),t(Ul),t(Ne),t(fl),t(Be),t(We),t(Cl),t(Re),t(ve),t(Il),t(Xe),t(Ge),t(_l),t(Ve),t(Ye),t(gl),t(xe),t(Al),t(Qe),t(Ee),t(kl),t(He),t(Bl)),t(y),w(I,l),w(g,l),w(k,l),w(X,l),w(V,l),w(x,l),w(H,l),w(F,l),w(u,l),w(P,l),w(O,l),w(el,l),w(C,l),w(sl,l),w(b,l),w(il,l),w(yl,l),w(cl,l),w(dl,l),w(Tl,l),w(rl,l),w(ul,l),w(bl,l),w(Zl,l),w(hl,l),w($l,l)}}}const Lt='{"title":"Sharing custom models","local":"sharing-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function qt(f){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Yt{constructor(y){super(),xt(this,y,qt,St,Gt,{})}}export{es as component};
