import{s as ml,f as ul,o as cl,n as dl}from"../chunks/scheduler.f6319a2a.js";import{S as Ml,i as yl,g as n,s,r as p,A as bl,h as i,f as l,c as a,j as pl,u as h,x as r,k as je,y as fl,a as o,v as d,d as m,t as c,w as M}from"../chunks/index.85aa684c.js";import{T as hl}from"../chunks/Tip.3d397a88.js";import{C as f}from"../chunks/CodeBlock.97b48fd2.js";import{D as gl}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as gt,E as wl}from"../chunks/EditOnGithub.006048dd.js";function Ul(wt){let u,b='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){u=n("p"),u.innerHTML=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1p1d9vw"&&(u.innerHTML=b)},m(y,g){o(y,u,g)},p:dl,d(y){y&&l(u)}}}function Tl(wt){let u,b="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){u=n("p"),u.textContent=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-h9mzfm"&&(u.textContent=b)},m(y,g){o(y,u,g)},p:dl,d(y){y&&l(u)}}}function Jl(wt){let u,b,y,g,T,vt,J,Ct,v,$e="Here, we’re going to see advanced tool usage.",jt,w,$t,C,_e='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',_t,j,It,$,Ie="A tool is mostly a function that an LLM can use in an agentic system.",Zt,_,Ze="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Gt,I,Ge="So it cannot be only a function. It should be a class.",Ht,Z,He="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",xt,G,xe="Here’s how it looks:",kt,H,Bt,x,ke='The custom tool subclasses <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',Rt,k,Be='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',Wt,B,Re="And that’s all it needs to be used in an agent!",Vt,R,We='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/main/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Qt,W,Ve='In this case, you can build your tool by subclassing <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> as described above.',At,V,Et,Q,Qe='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',St,A,Lt,E,Ae="For the push to Hub to work, your tool will need to respect some rules:",Nt,S,Ee='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',Ft,L,Se='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',qt,N,Le='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',Yt,F,Ne=`Then you can load the tool with <a href="/docs/smolagents/main/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,zt,q,Xt,Y,Pt,z,Fe='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',Dt,X,qe='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',Kt,P,Ye='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Ot,D,te,K,ze="And voilà, here’s your image! 🏖️",ee,Ut,Xe,le,O,Pe="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it.",oe,tt,se,et,ae,Tt,De,ne,lt,Ke="How cool is this? 🤩",ie,ot,re,st,Oe=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,ue,at,tl=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,pe,nt,he,it,de,rt,el="You can manage an agent’s toolbox by adding or replacing a tool.",me,ut,ll="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",ce,pt,Me,ht,ol="Now we can leverage the new tool:",ye,dt,be,U,fe,mt,sl=`Use the <code>agent.toolbox.update_tool()</code> method to replace an existing tool in the agent’s toolbox.
This is useful if your new tool is a one-to-one replacement of the existing tool because the agent already knows how to perform that specific task.
Just make sure the new tool follows the same API as the replaced tool or adapt the system prompt template to ensure all examples using the replaced tool are updated.`,ge,ct,we,Mt,al=`You can leverage tool collections by using the ToolCollection object, with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,Ue,yt,Te,bt,nl="To speed up the start, tools are loaded only if called by the agent.",Je,ft,ve,Jt,Ce;return T=new gt({props:{title:"Tools",local:"tools",headingTag:"h1"}}),J=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),w=new hl({props:{warning:!1,$$slots:{default:[Ul]},$$scope:{ctx:wt}}}),j=new gt({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),H=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),V=new gt({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new f({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),q=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new gt({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),D=new f({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),tt=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),et=new f({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),ot=new gt({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),nt=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),it=new gt({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),pt=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbGJveC5hZGRfdG9vbChtb2RlbF9kb3dubG9hZF90b29sKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.toolbox.add_tool(model_download_tool)`,wrap:!1}}),dt=new f({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new hl({props:{warning:!1,$$slots:{default:[Tl]},$$scope:{ctx:wt}}}),ct=new gt({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),yt=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ft=new wl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){u=n("meta"),b=s(),y=n("p"),g=s(),p(T.$$.fragment),vt=s(),p(J.$$.fragment),Ct=s(),v=n("p"),v.textContent=$e,jt=s(),p(w.$$.fragment),$t=s(),C=n("ul"),C.innerHTML=_e,_t=s(),p(j.$$.fragment),It=s(),$=n("p"),$.textContent=Ie,Zt=s(),_=n("p"),_.textContent=Ze,Gt=s(),I=n("p"),I.textContent=Ge,Ht=s(),Z=n("p"),Z.textContent=He,xt=s(),G=n("p"),G.textContent=xe,kt=s(),p(H.$$.fragment),Bt=s(),x=n("p"),x.innerHTML=ke,Rt=s(),k=n("ul"),k.innerHTML=Be,Wt=s(),B=n("p"),B.textContent=Re,Vt=s(),R=n("p"),R.innerHTML=We,Qt=s(),W=n("p"),W.innerHTML=Ve,At=s(),p(V.$$.fragment),Et=s(),Q=n("p"),Q.innerHTML=Qe,St=s(),p(A.$$.fragment),Lt=s(),E=n("p"),E.textContent=Ae,Nt=s(),S=n("ul"),S.innerHTML=Ee,Ft=s(),L=n("p"),L.innerHTML=Se,qt=s(),N=n("p"),N.innerHTML=Le,Yt=s(),F=n("p"),F.innerHTML=Ne,zt=s(),p(q.$$.fragment),Xt=s(),p(Y.$$.fragment),Pt=s(),z=n("p"),z.innerHTML=Fe,Dt=s(),X=n("p"),X.innerHTML=qe,Kt=s(),P=n("p"),P.innerHTML=Ye,Ot=s(),p(D.$$.fragment),te=s(),K=n("p"),K.textContent=ze,ee=s(),Ut=n("img"),le=s(),O=n("p"),O.innerHTML=Pe,oe=s(),p(tt.$$.fragment),se=s(),p(et.$$.fragment),ae=s(),Tt=n("img"),ne=s(),lt=n("p"),lt.textContent=Ke,ie=s(),p(ot.$$.fragment),re=s(),st=n("p"),st.innerHTML=Oe,ue=s(),at=n("p"),at.innerHTML=tl,pe=s(),p(nt.$$.fragment),he=s(),p(it.$$.fragment),de=s(),rt=n("p"),rt.textContent=el,me=s(),ut=n("p"),ut.innerHTML=ll,ce=s(),p(pt.$$.fragment),Me=s(),ht=n("p"),ht.textContent=ol,ye=s(),p(dt.$$.fragment),be=s(),p(U.$$.fragment),fe=s(),mt=n("p"),mt.innerHTML=sl,ge=s(),p(ct.$$.fragment),we=s(),Mt=n("p"),Mt.textContent=al,Ue=s(),p(yt.$$.fragment),Te=s(),bt=n("p"),bt.textContent=nl,Je=s(),p(ft.$$.fragment),ve=s(),Jt=n("p"),this.h()},l(t){const e=bl("svelte-u9bgzb",document.head);u=i(e,"META",{name:!0,content:!0}),e.forEach(l),b=a(t),y=i(t,"P",{}),pl(y).forEach(l),g=a(t),h(T.$$.fragment,t),vt=a(t),h(J.$$.fragment,t),Ct=a(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8951oz"&&(v.textContent=$e),jt=a(t),h(w.$$.fragment,t),$t=a(t),C=i(t,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gdosxb"&&(C.innerHTML=_e),_t=a(t),h(j.$$.fragment,t),It=a(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-50z9h0"&&($.textContent=Ie),Zt=a(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1llqfcr"&&(_.textContent=Ze),Gt=a(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-eilpgu"&&(I.textContent=Ge),Ht=a(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-suz7fy"&&(Z.textContent=He),xt=a(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x18ywb"&&(G.textContent=xe),kt=a(t),h(H.$$.fragment,t),Bt=a(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-prn7f3"&&(x.innerHTML=ke),Rt=a(t),k=i(t,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-xqgwuf"&&(k.innerHTML=Be),Wt=a(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-220ayw"&&(B.textContent=Re),Vt=a(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-13idprj"&&(R.innerHTML=We),Qt=a(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1lot62h"&&(W.innerHTML=Ve),At=a(t),h(V.$$.fragment,t),Et=a(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1p4y3bf"&&(Q.innerHTML=Qe),St=a(t),h(A.$$.fragment,t),Lt=a(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hoocvd"&&(E.textContent=Ae),Nt=a(t),S=i(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-cqj6gr"&&(S.innerHTML=Ee),Ft=a(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-4n5s3c"&&(L.innerHTML=Se),qt=a(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1knl8v8"&&(N.innerHTML=Le),Yt=a(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1skw0cc"&&(F.innerHTML=Ne),zt=a(t),h(q.$$.fragment,t),Xt=a(t),h(Y.$$.fragment,t),Pt=a(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-6y3nzn"&&(z.innerHTML=Fe),Dt=a(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xkj0c9"&&(X.innerHTML=qe),Kt=a(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gucs20"&&(P.innerHTML=Ye),Ot=a(t),h(D.$$.fragment,t),te=a(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-sgspwr"&&(K.textContent=ze),ee=a(t),Ut=i(t,"IMG",{src:!0}),le=a(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-3y2998"&&(O.innerHTML=Pe),oe=a(t),h(tt.$$.fragment,t),se=a(t),h(et.$$.fragment,t),ae=a(t),Tt=i(t,"IMG",{src:!0}),ne=a(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-i5dtbz"&&(lt.textContent=Ke),ie=a(t),h(ot.$$.fragment,t),re=a(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1rq40pf"&&(st.innerHTML=Oe),ue=a(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1g7jkvd"&&(at.innerHTML=tl),pe=a(t),h(nt.$$.fragment,t),he=a(t),h(it.$$.fragment,t),de=a(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1upp7uo"&&(rt.textContent=el),me=a(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-ocb8u2"&&(ut.innerHTML=ll),ce=a(t),h(pt.$$.fragment,t),Me=a(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-o3ledg"&&(ht.textContent=ol),ye=a(t),h(dt.$$.fragment,t),be=a(t),h(U.$$.fragment,t),fe=a(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-zx9fzv"&&(mt.innerHTML=sl),ge=a(t),h(ct.$$.fragment,t),we=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1wn4mt5"&&(Mt.textContent=al),Ue=a(t),h(yt.$$.fragment,t),Te=a(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-6r1jgt"&&(bt.textContent=nl),Je=a(t),h(ft.$$.fragment,t),ve=a(t),Jt=i(t,"P",{}),pl(Jt).forEach(l),this.h()},h(){je(u,"name","hf:doc:metadata"),je(u,"content",vl),ul(Ut.src,Xe="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||je(Ut,"src",Xe),ul(Tt.src,De="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||je(Tt,"src",De)},m(t,e){fl(document.head,u),o(t,b,e),o(t,y,e),o(t,g,e),d(T,t,e),o(t,vt,e),d(J,t,e),o(t,Ct,e),o(t,v,e),o(t,jt,e),d(w,t,e),o(t,$t,e),o(t,C,e),o(t,_t,e),d(j,t,e),o(t,It,e),o(t,$,e),o(t,Zt,e),o(t,_,e),o(t,Gt,e),o(t,I,e),o(t,Ht,e),o(t,Z,e),o(t,xt,e),o(t,G,e),o(t,kt,e),d(H,t,e),o(t,Bt,e),o(t,x,e),o(t,Rt,e),o(t,k,e),o(t,Wt,e),o(t,B,e),o(t,Vt,e),o(t,R,e),o(t,Qt,e),o(t,W,e),o(t,At,e),d(V,t,e),o(t,Et,e),o(t,Q,e),o(t,St,e),d(A,t,e),o(t,Lt,e),o(t,E,e),o(t,Nt,e),o(t,S,e),o(t,Ft,e),o(t,L,e),o(t,qt,e),o(t,N,e),o(t,Yt,e),o(t,F,e),o(t,zt,e),d(q,t,e),o(t,Xt,e),d(Y,t,e),o(t,Pt,e),o(t,z,e),o(t,Dt,e),o(t,X,e),o(t,Kt,e),o(t,P,e),o(t,Ot,e),d(D,t,e),o(t,te,e),o(t,K,e),o(t,ee,e),o(t,Ut,e),o(t,le,e),o(t,O,e),o(t,oe,e),d(tt,t,e),o(t,se,e),d(et,t,e),o(t,ae,e),o(t,Tt,e),o(t,ne,e),o(t,lt,e),o(t,ie,e),d(ot,t,e),o(t,re,e),o(t,st,e),o(t,ue,e),o(t,at,e),o(t,pe,e),d(nt,t,e),o(t,he,e),d(it,t,e),o(t,de,e),o(t,rt,e),o(t,me,e),o(t,ut,e),o(t,ce,e),d(pt,t,e),o(t,Me,e),o(t,ht,e),o(t,ye,e),d(dt,t,e),o(t,be,e),d(U,t,e),o(t,fe,e),o(t,mt,e),o(t,ge,e),d(ct,t,e),o(t,we,e),o(t,Mt,e),o(t,Ue,e),d(yt,t,e),o(t,Te,e),o(t,bt,e),o(t,Je,e),d(ft,t,e),o(t,ve,e),o(t,Jt,e),Ce=!0},p(t,[e]){const il={};e&2&&(il.$$scope={dirty:e,ctx:t}),w.$set(il);const rl={};e&2&&(rl.$$scope={dirty:e,ctx:t}),U.$set(rl)},i(t){Ce||(m(T.$$.fragment,t),m(J.$$.fragment,t),m(w.$$.fragment,t),m(j.$$.fragment,t),m(H.$$.fragment,t),m(V.$$.fragment,t),m(A.$$.fragment,t),m(q.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(ot.$$.fragment,t),m(nt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(U.$$.fragment,t),m(ct.$$.fragment,t),m(yt.$$.fragment,t),m(ft.$$.fragment,t),Ce=!0)},o(t){c(T.$$.fragment,t),c(J.$$.fragment,t),c(w.$$.fragment,t),c(j.$$.fragment,t),c(H.$$.fragment,t),c(V.$$.fragment,t),c(A.$$.fragment,t),c(q.$$.fragment,t),c(Y.$$.fragment,t),c(D.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(ot.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(dt.$$.fragment,t),c(U.$$.fragment,t),c(ct.$$.fragment,t),c(yt.$$.fragment,t),c(ft.$$.fragment,t),Ce=!1},d(t){t&&(l(b),l(y),l(g),l(vt),l(Ct),l(v),l(jt),l($t),l(C),l(_t),l(It),l($),l(Zt),l(_),l(Gt),l(I),l(Ht),l(Z),l(xt),l(G),l(kt),l(Bt),l(x),l(Rt),l(k),l(Wt),l(B),l(Vt),l(R),l(Qt),l(W),l(At),l(Et),l(Q),l(St),l(Lt),l(E),l(Nt),l(S),l(Ft),l(L),l(qt),l(N),l(Yt),l(F),l(zt),l(Xt),l(Pt),l(z),l(Dt),l(X),l(Kt),l(P),l(Ot),l(te),l(K),l(ee),l(Ut),l(le),l(O),l(oe),l(se),l(ae),l(Tt),l(ne),l(lt),l(ie),l(re),l(st),l(ue),l(at),l(pe),l(he),l(de),l(rt),l(me),l(ut),l(ce),l(Me),l(ht),l(ye),l(be),l(fe),l(mt),l(ge),l(we),l(Mt),l(Ue),l(Te),l(bt),l(Je),l(ve),l(Jt)),l(u),M(T,t),M(J,t),M(w,t),M(j,t),M(H,t),M(V,t),M(A,t),M(q,t),M(Y,t),M(D,t),M(tt,t),M(et,t),M(ot,t),M(nt,t),M(it,t),M(pt,t),M(dt,t),M(U,t),M(ct,t),M(yt,t),M(ft,t)}}}const vl='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3}],"depth":1}';function Cl(wt){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hl extends Ml{constructor(u){super(),yl(this,u,Cl,Jl,ml,{})}}export{Hl as component};
