import{s as Rn,o as Fn,n as Z}from"../chunks/scheduler.25b97de1.js";import{S as Nn,i as In,g as c,s as o,r as h,A as Pn,h as m,f as s,c as l,j as N,u as f,x as J,k as I,y as p,a as i,v as g,d as T,t as _,w as M}from"../chunks/index.d9030fc9.js";import{T as Sn}from"../chunks/Tip.baa67368.js";import{D as Y}from"../chunks/Docstring.ffac8efa.js";import{C as K}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Ve}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as S,E as zn}from"../chunks/EditOnGithub.91d95064.js";function Qn(C){let n,u="Example:",a,d,y;return d=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEElMjMlMjBZb3UlMjBjYW4lMjBjb25maXJtJTIwYm90aCUyMCVFNiU4NSVCNiVFNSVCRiU5QyUyMGFuZCUyMCVFNiU4NSVCNiVFNiU4NyU4OSUyMGFyZSUyMGVuY29kZWQlMjB0byUyMDE3NzUwJTBBdG9rZW5pemVyKCUyMiVFNSU5MCVCRSVFOCVCQyVBOSVFMyU4MSVBRiVFNyU4QyVBQiVFMyU4MSVBNyVFMyU4MSU4MiVFMyU4MiU4QiVGMCU5RiU5MCVBRiVFMyU4MCU4MiVFNSVBRSU5RiVFMyU4MSVBRiVFNiU4NSVCNiVFNSVCRiU5QyglRTYlODUlQjYlRTYlODclODkpJUU1JUE0JUE3JUU1JUFEJUE2JUU1JTg3JUJBJUU4JUJBJUFCJTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSUwQSUyMyUyMEJvdGglMjAlRTYlODUlQjYlRTUlQkYlOUMlMjBhbmQlMjAlRTYlODUlQjYlRTYlODclODklMjBhcmUlMjBkZWNvZGVkJTIwdG8lMjAlRTYlODUlQjYlRTUlQkYlOUMlMEF0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplciglMjIlRTUlOTAlQkUlRTglQkMlQTklRTMlODElQUYlRTclOEMlQUIlRTMlODElQTclRTMlODElODIlRTMlODIlOEIlRjAlOUYlOTAlQUYlRTMlODAlODIlRTUlQUUlOUYlRTMlODElQUYlRTYlODUlQjYlRTUlQkYlOUMoJUU2JTg1JUI2JUU2JTg3JTg5KSVFNSVBNCVBNyVFNSVBRCVBNiVFNSU4NyVCQSVFOCVCQSVBQiUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can confirm both 慶応 and 慶應 are encoded to 17750</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;吾輩は猫である🐯。実は慶応(慶應)大学出身&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[<span class="hljs-number">35993</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">34347</span>, <span class="hljs-number">31459</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">31448</span>, <span class="hljs-number">25</span>, <span class="hljs-number">30659</span>, <span class="hljs-number">35729</span>, <span class="hljs-number">35676</span>, <span class="hljs-number">32417</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35589</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35590</span>, <span class="hljs-number">321</span>, <span class="hljs-number">1281</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Both 慶応 and 慶應 are decoded to 慶応</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(tokenizer(<span class="hljs-string">&quot;吾輩は猫である🐯。実は慶応(慶應)大学出身&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-string">&#x27;吾輩は猫である🐯。実は慶応(慶応)大学出身&#x27;</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=u,a=o(),h(d.$$.fragment)},l(r){n=m(r,"P",{"data-svelte-h":!0}),J(n)!=="svelte-11lpom8"&&(n.textContent=u),a=l(r),f(d.$$.fragment,r)},m(r,U){i(r,n,U),i(r,a,U),g(d,r,U),y=!0},p:Z,i(r){y||(T(d.$$.fragment,r),y=!0)},o(r){_(d.$$.fragment,r),y=!1},d(r){r&&(s(n),s(a)),M(d,r)}}}function Zn(C){let n,u="Example for Prefix-LM:",a,d,y;return d=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEF0b2tlbml6ZXIoJTIyJUU1JUFFJTlGJUUzJTgxJUFGJUU2JTg1JUI2JUU1JUJGJTlDKCVFNiU4NSVCNiVFNiU4NyU4OSklRTUlQTQlQTclRTUlQUQlQTYlRTUlODclQkElRTglQkElQUIlMjIlMkMlMjBwcmVmaXhfdGV4dCUzRCUyMiVFNSU5MCVCRSVFOCVCQyVBOSVFMyU4MSVBRiVFNyU4QyVBQiVFMyU4MSVBNyVFMyU4MSU4MiVFMyU4MiU4QiVGMCU5RiU5MCVBRiVFMyU4MCU4MiUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMEElMjMlMjBNYXNrJTIwZm9yJTIwUHJlZml4LUxNJTIwaW5wdXRzJTBBdG9rZW5pemVyKCUyMiVFNSVBRSU5RiVFMyU4MSVBRiVFNiU4NSVCNiVFNSVCRiU5QyglRTYlODUlQjYlRTYlODclODkpJUU1JUE0JUE3JUU1JUFEJUE2JUU1JTg3JUJBJUU4JUJBJUFCJTIyJTJDJTIwcHJlZml4X3RleHQlM0QlMjIlRTUlOTAlQkUlRTglQkMlQTklRTMlODElQUYlRTclOEMlQUIlRTMlODElQTclRTMlODElODIlRTMlODIlOEIlRjAlOUYlOTAlQUYlRTMlODAlODIlMjIpJTVCJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;実は慶応(慶應)大学出身&quot;</span>, prefix_text=<span class="hljs-string">&quot;吾輩は猫である🐯。&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[<span class="hljs-number">35993</span>, <span class="hljs-number">34347</span>, <span class="hljs-number">31459</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">31448</span>, <span class="hljs-number">25</span>, <span class="hljs-number">30659</span>, <span class="hljs-number">35729</span>, <span class="hljs-number">35676</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">32417</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35589</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35590</span>, <span class="hljs-number">321</span>, <span class="hljs-number">1281</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask for Prefix-LM inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;実は慶応(慶應)大学出身&quot;</span>, prefix_text=<span class="hljs-string">&quot;吾輩は猫である🐯。&quot;</span>)[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=u,a=o(),h(d.$$.fragment)},l(r){n=m(r,"P",{"data-svelte-h":!0}),J(n)!=="svelte-sklucv"&&(n.textContent=u),a=l(r),f(d.$$.fragment,r)},m(r,U){i(r,n,U),i(r,a,U),g(d,r,U),y=!0},p:Z,i(r){y||(T(d.$$.fragment,r),y=!0)},o(r){_(d.$$.fragment,r),y=!1},d(r){r&&(s(n),s(a)),M(d,r)}}}function En(C){let n,u="Example for batch encode:",a,d,y;return d=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEF0b2tlbml6ZXIoJTVCJTVCJTIyJUU2JUFEJUE2JUU3JTk0JUIwJUU0JUJGJUExJUU3JThFJTg0JTIyJTJDJTIwJTIyJUUzJTgxJUFGJUUzJTgwJTgxJTIyJTVEJTJDJTIwJTVCJTIyJUU3JUI5JTk0JUU3JTk0JUIwJUU0JUJGJUExJUU5JTk1JUI3JTIyJTJDJTIwJTIyJUUzJTgxJUFFJUU5JTg1JThEJUU0JUI4JThCJUUzJTgxJUFFJUUzJTgwJTgxJTIyJTVEJTVEJTJDJTIwcGFkZGluZyUzRFRydWUpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBJTIzJTIwTWFzayUyMGZvciUyMFByZWZpeC1MTSUyMGlucHV0cyUwQXRva2VuaXplciglNUIlNUIlMjIlRTYlQUQlQTYlRTclOTQlQjAlRTQlQkYlQTElRTclOEUlODQlMjIlMkMlMjAlMjIlRTMlODElQUYlRTMlODAlODElMjIlNUQlMkMlMjAlNUIlMjIlRTclQjklOTQlRTclOTQlQjAlRTQlQkYlQTElRTklOTUlQjclMjIlMkMlMjAlMjIlRTMlODElQUUlRTklODUlOEQlRTQlQjglOEIlRTMlODElQUUlRTMlODAlODElMjIlNUQlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklNUIlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUwQSUwQSUyMyUyME1hc2slMjBmb3IlMjBwYWRkaW5nJTBBdG9rZW5pemVyKCU1QiU1QiUyMiVFNiVBRCVBNiVFNyU5NCVCMCVFNCVCRiVBMSVFNyU4RSU4NCUyMiUyQyUyMCUyMiVFMyU4MSVBRiVFMyU4MCU4MSUyMiU1RCUyQyUyMCU1QiUyMiVFNyVCOSU5NCVFNyU5NCVCMCVFNCVCRiVBMSVFOSU5NSVCNyUyMiUyQyUyMCUyMiVFMyU4MSVBRSVFOSU4NSU4RCVFNCVCOCU4QiVFMyU4MSVBRSVFMyU4MCU4MSUyMiU1RCU1RCUyQyUyMHBhZGRpbmclM0RUcnVlKSU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer([[<span class="hljs-string">&quot;武田信玄&quot;</span>, <span class="hljs-string">&quot;は、&quot;</span>], [<span class="hljs-string">&quot;織田信長&quot;</span>, <span class="hljs-string">&quot;の配下の、&quot;</span>]], padding=<span class="hljs-literal">True</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[[<span class="hljs-number">35993</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">8640</span>, <span class="hljs-number">25948</span>, <span class="hljs-number">35993</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">35675</span>, <span class="hljs-number">35999</span>, <span class="hljs-number">35999</span>], [<span class="hljs-number">35993</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">10382</span>, <span class="hljs-number">9868</span>, <span class="hljs-number">35993</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">30646</span>, <span class="hljs-number">9459</span>, <span class="hljs-number">30646</span>, <span class="hljs-number">35675</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask for Prefix-LM inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer([[<span class="hljs-string">&quot;武田信玄&quot;</span>, <span class="hljs-string">&quot;は、&quot;</span>], [<span class="hljs-string">&quot;織田信長&quot;</span>, <span class="hljs-string">&quot;の配下の、&quot;</span>]], padding=<span class="hljs-literal">True</span>)[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask for padding</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer([[<span class="hljs-string">&quot;武田信玄&quot;</span>, <span class="hljs-string">&quot;は、&quot;</span>], [<span class="hljs-string">&quot;織田信長&quot;</span>, <span class="hljs-string">&quot;の配下の、&quot;</span>]], padding=<span class="hljs-literal">True</span>)[<span class="hljs-string">&quot;attention_mask&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]`,wrap:!1}}),{c(){n=c("p"),n.textContent=u,a=o(),h(d.$$.fragment)},l(r){n=m(r,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1t2nozh"&&(n.textContent=u),a=l(r),f(d.$$.fragment,r)},m(r,U){i(r,n,U),i(r,a,U),g(d,r,U),y=!0},p:Z,i(r){y||(T(d.$$.fragment,r),y=!0)},o(r){_(d.$$.fragment,r),y=!1},d(r){r&&(s(n),s(a)),M(d,r)}}}function qn(C){let n,u="Example:",a,d,y;return d=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEF4X3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyKCUyMiVFRiVCRCVCMSVFRiVCRCVCMiVFRiVCRCVCMyVFRiVCRCVCNCUyMiklMEElMjMlMjBpbnB1dF9pZHMlM0ElMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBTT1QlMjAlN0MlMjBTRUclMjAlN0MlMjAlRUYlQkQlQjElMjAlN0MlMjAlRUYlQkQlQjIlMjAlN0MlMjAlRUYlQkQlQjMlMjAlN0MlMjAlRUYlQkQlQjQlMjAlN0MlMEElMjMlMjB0b2tlbl90eXBlX2lkcyUzQSUyMCU3QyUyMDElMjAlMjAlMjAlN0MlMjAwJTIwJTIwJTIwJTdDJTIwMCUyMCU3QyUyMDAlMjAlN0MlMjAwJTIwJTdDJTIwMCUyMCU3QyUwQSUwQXhfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTIyJTJDJTIwcHJlZml4X3RleHQlM0QlMjIlRUYlQkQlQjElRUYlQkQlQjIlRUYlQkQlQjMlRUYlQkQlQjQlMjIpJTBBJTIzJTIwaW5wdXRfaWRzJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwU09UJTIwJTdDJTIwJUVGJUJEJUIxJTIwJTdDJTIwJUVGJUJEJUIyJTIwJTdDJTIwJUVGJUJEJUIzJTIwJTdDJTIwJUVGJUJEJUI0JTIwJTdDJTIwU0VHJTIwJTdDJTBBJTIzJTIwdG9rZW5fdHlwZV9pZHMlM0ElMjAlN0MlMjAxJTIwJTIwJTIwJTdDJTIwMSUyMCU3QyUyMDElMjAlN0MlMjAxJTIwJTdDJTIwMSUyMCU3QyUyMDAlMjAlMjAlN0MlMEElMEF4X3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyKCUyMiVFRiVCRCVCMyVFRiVCRCVCNCUyMiUyQyUyMHByZWZpeF90ZXh0JTNEJTIyJUVGJUJEJUIxJUVGJUJEJUIyJTIyKSUwQSUyMyUyMGlucHV0X2lkcyUzQSUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMFNPVCUyMCU3QyUyMCVFRiVCRCVCMSUyMCU3QyUyMCVFRiVCRCVCMiUyMCU3QyUyMFNFRyUyMCU3QyUyMCVFRiVCRCVCMyUyMCU3QyUyMCVFRiVCRCVCNCUyMCU3QyUwQSUyMyUyMHRva2VuX3R5cGVfaWRzJTNBJTIwJTdDJTIwMSUyMCUyMCUyMCU3QyUyMDElMjAlN0MlMjAxJTIwJTdDJTIwMCUyMCUyMCUyMCU3QyUyMDAlMjAlN0MlMjAwJTIwJTdD",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;ｱｲｳｴ&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_ids:      | SOT | SEG | ｱ | ｲ | ｳ | ｴ |</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># token_type_ids: | 1   | 0   | 0 | 0 | 0 | 0 |</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;&quot;</span>, prefix_text=<span class="hljs-string">&quot;ｱｲｳｴ&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_ids:      | SOT | ｱ | ｲ | ｳ | ｴ | SEG |</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># token_type_ids: | 1   | 1 | 1 | 1 | 1 | 0  |</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;ｳｴ&quot;</span>, prefix_text=<span class="hljs-string">&quot;ｱｲ&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_ids:      | SOT | ｱ | ｲ | SEG | ｳ | ｴ |</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># token_type_ids: | 1   | 1 | 1 | 0   | 0 | 0 |</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=u,a=o(),h(d.$$.fragment)},l(r){n=m(r,"P",{"data-svelte-h":!0}),J(n)!=="svelte-11lpom8"&&(n.textContent=u),a=l(r),f(d.$$.fragment,r)},m(r,U){i(r,n,U),i(r,a,U),g(d,r,U),y=!0},p:Z,i(r){y||(T(d.$$.fragment,r),y=!0)},o(r){_(d.$$.fragment,r),y=!1},d(r){r&&(s(n),s(a)),M(d,r)}}}function Bn(C){let n,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),J(n)!=="svelte-fincs2"&&(n.innerHTML=u)},m(a,d){i(a,n,d)},p:Z,d(a){a&&s(n)}}}function Wn(C){let n,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),J(n)!=="svelte-fincs2"&&(n.innerHTML=u)},m(a,d){i(a,n,d)},p:Z,d(a){a&&s(n)}}}function An(C){let n,u;return n=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjB0cmFpbmVyX3V0aWxzJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpJTBBeF90b2tlbiUyMCUzRCUyMHRva2VuaXplciglMjIlRTclQjklOTQlRTclOTQlQjAlRTQlQkYlQTElRTklOTUlQjclRTMlODElQUYlRTMlODAlODElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXRyYWluZXJfdXRpbHMuc2V0X3NlZWQoMzApJTBBaW5wdXRfaWRzJTIwJTNEJTIweF90b2tlbi5pbnB1dF9pZHMudG8oZGV2aWNlKSUwQWdlbl90b2tlbiUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmRlY29kZShnZW5fdG9rZW4lNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer, trainer_utils

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;織田信長は、&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer_utils.set_seed(<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = x_token.input_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_token = model.generate(input_ids, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(gen_token[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;織田信長は、政治・軍事の中枢まで掌握した政治家であり、日本史上類を見ない驚異的な軍事侵攻を続け...&quot;</span>`,wrap:!1}}),{c(){h(n.$$.fragment)},l(a){f(n.$$.fragment,a)},m(a,d){g(n,a,d),u=!0},p:Z,i(a){u||(T(n.$$.fragment,a),u=!0)},o(a){_(n.$$.fragment,a),u=!1},d(a){M(n,a)}}}function On(C){let n,u;return n=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjB0cmFpbmVyX3V0aWxzJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpJTBBeF90b2tlbiUyMCUzRCUyMHRva2VuaXplciglMjIlMjIlMkMlMjBwcmVmaXhfdGV4dCUzRCUyMiVFNyVCOSU5NCVFNyU5NCVCMCVFNCVCRiVBMSVFOSU5NSVCNyVFMyU4MSVBRiVFMyU4MCU4MSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdHJhaW5lcl91dGlscy5zZXRfc2VlZCgzMCklMEFpbnB1dF9pZHMlMjAlM0QlMjB4X3Rva2VuLmlucHV0X2lkcy50byhkZXZpY2UpJTBBdG9rZW5fdHlwZV9pZHMlMjAlM0QlMjB4X3Rva2VuLnRva2VuX3R5cGVfaWRzLnRvKGRldmljZSklMEFnZW5fdG9rZW4lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjB0b2tlbl90eXBlX2lkcyUzRHRva2VuX3R5cGVfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEF0b2tlbml6ZXIuZGVjb2RlKGdlbl90b2tlbiU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer, trainer_utils

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;&quot;</span>, prefix_text=<span class="hljs-string">&quot;織田信長は、&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer_utils.set_seed(<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = x_token.input_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_type_ids = x_token.token_type_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_token = model.generate(input_ids, token_type_ids=token_type_ids, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(gen_token[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;織田信長は、政治・外交で数々の戦果を上げるが、1568年からは、いわゆる本能寺の変で細川晴元に暗殺される...&quot;</span>`,wrap:!1}}),{c(){h(n.$$.fragment)},l(a){f(n.$$.fragment,a)},m(a,d){g(n,a,d),u=!0},p:Z,i(a){u||(T(n.$$.fragment,a),u=!0)},o(a){_(n.$$.fragment,a),u=!1},d(a){M(n,a)}}}function Xn(C){let n,u;return n=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjB0cmFpbmVyX3V0aWxzJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpJTBBbWFza2VkX3NlbnRlbmNlJTIwJTNEJTIwJTIyJUU2JUFEJUE2JUU3JTk0JUIwJUU0JUJGJUExJUU3JThFJTg0JUUzJTgxJUFGJUUzJTgwJTgxJTNDJTdDaW5wdXRtYXNrJTdDJTNFJUU2JTk5JTgyJUU0JUJCJUEzJUUzJTgzJTk1JUUzJTgyJUExJUUzJTgzJUIzJUUzJTgxJUFBJUUzJTgyJTg5JUUzJTgxJTlDJUUzJTgxJUIyJUU2JThBJUJDJUUzJTgxJTk1JUUzJTgxJTg4JTNDJTdDaW5wdXRtYXNrJTdDJTNFJUUzJTgxJThEJUUzJTgxJTlGJUUzJTgxJTg0JUU1JTkwJThEJUU1JUIwJTg2JUUzJTgxJUFFJUU0JUI4JTgwJUU0JUJBJUJBJUUzJTgwJTgyJTIyJTBBeF90b2tlbiUyMCUzRCUyMHRva2VuaXplciglMjIlMjIlMkMlMjBwcmVmaXhfdGV4dCUzRG1hc2tlZF9zZW50ZW5jZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdHJhaW5lcl91dGlscy5zZXRfc2VlZCgzMCklMEFpbnB1dF9pZHMlMjAlM0QlMjB4X3Rva2VuLmlucHV0X2lkcy50byhkZXZpY2UpJTBBdG9rZW5fdHlwZV9pZHMlMjAlM0QlMjB4X3Rva2VuLnRva2VuX3R5cGVfaWRzLnRvKGRldmljZSklMEFvdXRfbG1fdG9rZW4lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjB0b2tlbl90eXBlX2lkcyUzRHRva2VuX3R5cGVfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFvdXRfbWxtX3Rva2VuJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwdG9rZW5fdHlwZV9pZHMlM0R0b2tlbl90eXBlX2lkcykubG9naXRzLmFyZ21heChheGlzJTNELTEpJTBBdG9rZW5pemVyLmRlY29kZShvdXRfbWxtX3Rva2VuJTVCMCU1RCklMEElMEF0b2tlbml6ZXIuZGVjb2RlKG91dF9sbV90b2tlbiU1QjAlNUQlNUJpbnB1dF9pZHMuc2hhcGUlNUIxJTVEJTIwJTNBJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer, trainer_utils

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>masked_sentence = <span class="hljs-string">&quot;武田信玄は、&lt;|inputmask|&gt;時代ファンならぜひ押さえ&lt;|inputmask|&gt;きたい名将の一人。&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;&quot;</span>, prefix_text=masked_sentence, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer_utils.set_seed(<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = x_token.input_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_type_ids = x_token.token_type_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_lm_token = model.generate(input_ids, token_type_ids=token_type_ids, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_mlm_token = model(input_ids, token_type_ids=token_type_ids).logits.argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(out_mlm_token[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;武田信玄は、戦国時代ファンならぜひ押さえておきたい名将の一人。&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(out_lm_token[<span class="hljs-number">0</span>][input_ids.shape[<span class="hljs-number">1</span>] :])
<span class="hljs-string">&quot;武田氏の三代に渡った武田家のひとり\\n甲斐市に住む、日本史上最大の戦国大名。...&quot;</span>`,wrap:!1}}),{c(){h(n.$$.fragment)},l(a){f(n.$$.fragment,a)},m(a,d){g(n,a,d),u=!0},p:Z,i(a){u||(T(n.$$.fragment,a),u=!0)},o(a){_(n.$$.fragment,a),u=!1},d(a){M(n,a)}}}function Hn(C){let n,u,a,d,y,r,U,Le,ee,nn="The GPTSAN-japanese model was released in the repository by Toshiyuki Sakamoto (tanreinama).",Ye,te,sn=`GPTSAN is a Japanese language model using Switch Transformer. It has the same structure as the model introduced as Prefix LM
in the T5 paper, and support both Text Generation and Masked Language Modeling tasks. These basic tasks similarly can
fine-tune for translation or summarization.`,Ke,ne,et,se,an="The <code>generate()</code> method can be used to generate text using GPTSAN-Japanese model.",tt,ae,nt,oe,st,le,on=`GPTSAN has some unique features. It has a model structure of Prefix-LM. It works as a shifted Masked Language Model for Prefix Input tokens. Un-prefixed inputs behave like normal generative models.
The Spout vector is a GPTSAN specific input. Spout is pre-trained with random inputs, but you can specify a class of text or an arbitrary vector during fine-tuning. This allows you to indicate the tendency of the generated text.
GPTSAN has a sparse Feed Forward based on Switch-Transformer. You can also add other layers and train them partially. See the original GPTSAN repository for details.`,at,re,ot,ie,ln=`GPTSAN has the structure of the model named Prefix-LM in the <code>T5</code> paper. (The original GPTSAN repository calls it <code>hybrid</code>)
In GPTSAN, the <code>Prefix</code> part of Prefix-LM, that is, the input position that can be referenced by both tokens, can be specified with any length.
Arbitrary lengths can also be specified differently for each batch.
This length applies to the text entered in <code>prefix_text</code> for the tokenizer.
The tokenizer returns the mask of the <code>Prefix</code> part of Prefix-LM as <code>token_type_ids</code>.
The model treats the part where <code>token_type_ids</code> is 1 as a <code>Prefix</code> part, that is, the input can refer to both tokens before and after.`,lt,pe,rt,de,rn=`Specifying the Prefix part is done with a mask passed to self-attention.
When token_type_ids=None or all zero, it is equivalent to regular causal mask`,it,ce,pn="for example:",pt,me,dn=`<blockquote><blockquote><p>x_token = tokenizer(“ｱｲｳｴ”)
input_ids:      | SOT | SEG | ｱ | ｲ | ｳ | ｴ |
token_type_ids: | 1   | 0   | 0 | 0 | 0 | 0 |
prefix_lm_mask:
SOT | 1 0 0 0 0 0 |
SEG | 1 1 0 0 0 0 |
ｱ   | 1 1 1 0 0 0 |
ｲ   | 1 1 1 1 0 0 |
ｳ   | 1 1 1 1 1 0 |
ｴ   | 1 1 1 1 1 1 |</p></blockquote></blockquote>`,dt,ue,cn=`<blockquote><blockquote><p>x_token = tokenizer(&quot;&quot;, prefix_text=“ｱｲｳｴ”)
input_ids:      | SOT | ｱ | ｲ | ｳ | ｴ | SEG |
token_type_ids: | 1   | 1 | 1 | 1 | 1 | 0  |
prefix_lm_mask:
SOT | 1 1 1 1 1 0 |
ｱ   | 1 1 1 1 1 0 |
ｲ   | 1 1 1 1 1 0 |
ｳ   | 1 1 1 1 1 0 |
ｴ   | 1 1 1 1 1 0 |
SEG | 1 1 1 1 1 1 |</p></blockquote></blockquote>`,ct,he,mn=`<blockquote><blockquote><p>x_token = tokenizer(“ｳｴ”, prefix_text=“ｱｲ”)
input_ids:      | SOT | ｱ | ｲ | SEG | ｳ | ｴ |
token_type_ids: | 1   | 1 | 1 | 0   | 0 | 0 |
prefix_lm_mask:
SOT | 1 1 1 0 0 0 |
ｱ   | 1 1 1 0 0 0 |
ｲ   | 1 1 1 0 0 0 |
SEG | 1 1 1 1 0 0 |
ｳ   | 1 1 1 1 1 0 |
ｴ   | 1 1 1 1 1 1 |</p></blockquote></blockquote>`,mt,fe,ut,ge,un=`A Spout Vector is a special vector for controlling text generation.
This vector is treated as the first embedding in self-attention to bring extraneous attention to the generated tokens.
In the pre-trained model published from <code>Tanrei/GPTSAN-japanese</code>, the Spout Vector is a 128-dimensional vector that passes through 8 fully connected layers in the model and is projected into the space acting as external attention.
The Spout Vector projected by the fully connected layer is split to be passed to all self-attentions.`,ht,Te,ft,G,_e,kt,Ge,hn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseModel">GPTSanJapaneseModel</a>. It is used to instantiate
a GPTSANJapanese model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the GPTSANJapanese
<a href="https://huggingface.co/Tanrei/GPTSAN-japanese" rel="nofollow">Tanrei/GPTSAN-japanese</a> architecture.`,Ct,Se,fn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,gt,Me,Tt,k,Je,xt,Re,gn="This tokenizer is based on GPTNeoXJapaneseTokenizer and has the following modifications",$t,Fe,Tn=`<li>Decoding byte0~byte255 tokens correctly</li> <li>Added bagofword token handling</li> <li>Return token_type_ids for Prefix-LM model
The bagofword token represents a repetition of the previous token and is converted to 3 consecutive tokens when
decoding In addition, the original Japanese special Sub-Word-Encoding has been released in this repository
(<a href="https://github.com/tanreinama/Japanese-BPEEncoder_V2" rel="nofollow">https://github.com/tanreinama/Japanese-BPEEncoder_V2</a>). The token_type_ids is a mask indicating the prefix input
position of the Prefix-LM model. To specify a prefix position, specify a prefix input for prefix_text, or specify a
sentence of the prefix part and the part after it as a text pair of batch input.</li>`,wt,E,vt,q,Vt,B,Gt,W,ye,St,Ne,_n="Converts a sequence of tokens (string) in a single string.",Rt,R,be,Ft,Ie,Mn=`The tokenizer returns token_type_ids as separators between the Prefix part and the rest.
token_type_ids is 1 for the Prefix part and 0 for the rest of the token.`,Nt,A,_t,Ue,Mt,$,je,It,Pe,Jn="The bare GPTSAN-japanese Model transformer outputting raw hidden-states without any specific head on top.",Pt,ze,yn=`The <a href="https://github.com/tanreinama/GPTSAN" rel="nofollow">GPTSAN-japanese</a> model was proposed in General-purpose Swich transformer
based Japanese language model`,zt,Qe,bn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qt,F,ke,Zt,Ze,Un='The <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseModel">GPTSanJapaneseModel</a> forward method, overrides the <code>__call__</code> special method.',Et,O,Jt,Ce,yt,w,xe,qt,Ee,jn="The bare GPTSAN-japanese Model with a language modeling head.",Bt,qe,kn=`The <a href="https://github.com/tanreinama/GPTSAN" rel="nofollow">GPTSAN-japanese</a> model was proposed in General-purpose Swich transformer
based Japanese language model`,Wt,Be,Cn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,At,b,$e,Ot,We,xn='The <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Xt,X,Ht,Ae,$n="Example:",Dt,Oe,wn="Text Generation with regular LM Model",Lt,H,Yt,Xe,vn="Text Generation with Prefix-LM Model",Kt,D,en,He,Vn="Simultaneously Text Generation And Masked Language Model",tn,L,bt,we,Ut,De,jt;return y=new S({props:{title:"GPTSAN-japanese",local:"gptsan-japanese",headingTag:"h1"}}),U=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new S({props:{title:"Usage example",local:"usage-example",headingTag:"h3"}}),ae=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyVGFucmVpJTJGR1BUU0FOLWphcGFuZXNlJTIyKS5jdWRhKCklMEF4X3RvayUyMCUzRCUyMHRva2VuaXplciglMjIlRTMlODElQUYlRTMlODAlODElMjIlMkMlMjBwcmVmaXhfdGV4dCUzRCUyMiVFNyVCOSU5NCVFNyU5NCVCMCVFNCVCRiVBMSVFOSU5NSVCNyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdG9yY2gubWFudWFsX3NlZWQoMCklMEFnZW5fdG9rJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoeF90b2suaW5wdXRfaWRzLmN1ZGEoKSUyQyUyMHRva2VuX3R5cGVfaWRzJTNEeF90b2sudG9rZW5fdHlwZV9pZHMuY3VkYSgpJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0b2tlbml6ZXIuZGVjb2RlKGdlbl90b2slNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).cuda()
<span class="hljs-meta">&gt;&gt;&gt; </span>x_tok = tokenizer(<span class="hljs-string">&quot;は、&quot;</span>, prefix_text=<span class="hljs-string">&quot;織田信長&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tok = model.generate(x_tok.input_ids.cuda(), token_type_ids=x_tok.token_type_ids.cuda(), max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(gen_tok[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;織田信長は、2004年に『戦国BASARA』のために、豊臣秀吉&#x27;</span>`,wrap:!1}}),oe=new S({props:{title:"GPTSAN Features",local:"gptsan-features",headingTag:"h2"}}),re=new S({props:{title:"Prefix-LM Model",local:"prefix-lm-model",headingTag:"h3"}}),pe=new S({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),fe=new S({props:{title:"Spout Vector",local:"spout-vector",headingTag:"h3"}}),Te=new S({props:{title:"GPTSanJapaneseConfig",local:"transformers.GPTSanJapaneseConfig",headingTag:"h2"}}),_e=new Y({props:{name:"class transformers.GPTSanJapaneseConfig",anchor:"transformers.GPTSanJapaneseConfig",parameters:[{name:"vocab_size",val:" = 36000"},{name:"max_position_embeddings",val:" = 1280"},{name:"d_model",val:" = 1024"},{name:"d_ff",val:" = 8192"},{name:"d_ext",val:" = 4096"},{name:"d_spout",val:" = 128"},{name:"num_switch_layers",val:" = 10"},{name:"num_ext_layers",val:" = 0"},{name:"num_heads",val:" = 16"},{name:"num_experts",val:" = 16"},{name:"expert_capacity",val:" = 128"},{name:"dropout_rate",val:" = 0.0"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"router_bias",val:" = False"},{name:"router_jitter_noise",val:" = 0.0"},{name:"router_dtype",val:" = 'float32'"},{name:"router_ignore_padding_tokens",val:" = False"},{name:"output_hidden_states",val:" = False"},{name:"output_attentions",val:" = False"},{name:"initializer_factor",val:" = 0.002"},{name:"output_router_logits",val:" = False"},{name:"use_cache",val:" = True"},{name:"separator_token_id",val:" = 35998"},{name:"pad_token_id",val:" = 35995"},{name:"eos_token_id",val:" = 35999"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 36000) &#x2014;
Vocabulary size of the GPTSANJapanese model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseModel">GPTSanJapaneseModel</a>.`,name:"vocab_size"},{anchor:"transformers.GPTSanJapaneseConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
The maximum sequence length that this model might ever be used with. Defaults set this to 1280.`,name:"max_position_embeddings"},{anchor:"transformers.GPTSanJapaneseConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.GPTSanJapaneseConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Size of the intermediate feed forward layer in each <code>SwitchTransformersBlock</code>.`,name:"d_ff"},{anchor:"transformers.GPTSanJapaneseConfig.d_ext",description:`<strong>d_ext</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Size of the intermediate feed forward layer in each Extra-layers.`,name:"d_ext"},{anchor:"transformers.GPTSanJapaneseConfig.d_spout",description:`<strong>d_spout</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Size of the <code>spout</code> vector.`,name:"d_spout"},{anchor:"transformers.GPTSanJapaneseConfig.num_switch_layers",description:`<strong>num_switch_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Switch Transformer layer.`,name:"num_switch_layers"},{anchor:"transformers.GPTSanJapaneseConfig.num_ext_layers",description:`<strong>num_ext_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of layers in the Extra-layers.`,name:"num_ext_layers"},{anchor:"transformers.GPTSanJapaneseConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.GPTSanJapaneseConfig.num_experts",description:`<strong>num_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of experts for each SwitchTransformer layer.`,name:"num_experts"},{anchor:"transformers.GPTSanJapaneseConfig.expert_capacity",description:`<strong>expert_capacity</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of tokens that can be stored in each expert. If set to 1, the model will behave like a regular
Transformer.`,name:"expert_capacity"},{anchor:"transformers.GPTSanJapaneseConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.GPTSanJapaneseConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GPTSanJapaneseConfig.router_bias",description:`<strong>router_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a bias to the router.`,name:"router_bias"},{anchor:"transformers.GPTSanJapaneseConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Amount of noise to add to the router. Set it to 0.0 during prediction or set small value (usually 1e-2)
during training.`,name:"router_jitter_noise"},{anchor:"transformers.GPTSanJapaneseConfig.router_dtype",description:`<strong>router_dtype</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;float32&quot;</code>) &#x2014;
The <code>dtype</code> used for the routers. It is preferable to keep the <code>dtype</code> to <code>&quot;float32&quot;</code> as specified in the
<em>selective precision</em> discussion in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">the paper</a>.`,name:"router_dtype"},{anchor:"transformers.GPTSanJapaneseConfig.router_ignore_padding_tokens",description:`<strong>router_ignore_padding_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to ignore padding tokens when routing.`,name:"router_ignore_padding_tokens"},{anchor:"transformers.GPTSanJapaneseConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTSanJapaneseConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers.`,name:"output_attentions"},{anchor:"transformers.GPTSanJapaneseConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.002) &#x2014;
A factor for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.GPTSanJapaneseConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether or not to return the router logits of all experts.`,name:"output_router_logits"},{anchor:"transformers.GPTSanJapaneseConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models)`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/configuration_gptsan_japanese.py#L24"}}),Me=new S({props:{title:"GPTSanJapaneseTokenizer",local:"transformers.GPTSanJapaneseTokenizer",headingTag:"h2"}}),Je=new Y({props:{name:"class transformers.GPTSanJapaneseTokenizer",anchor:"transformers.GPTSanJapaneseTokenizer",parameters:[{name:"vocab_file",val:""},{name:"emoji_file",val:""},{name:"unk_token",val:" = '<|nottoken|>'"},{name:"pad_token",val:" = '<|separator|>'"},{name:"bos_token",val:" = '<|startoftext|>'"},{name:"eos_token",val:" = '<|endoftext|>'"},{name:"sep_token",val:" = '<|segmenter|>'"},{name:"do_clean_text",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.GPTSanJapaneseTokenizer.emoji_file",description:`<strong>emoji_file</strong> (<code>str</code>) &#x2014;
File containing the emoji.`,name:"emoji_file"},{anchor:"transformers.GPTSanJapaneseTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|nottoken|&gt;&quot;</code>) &#x2014;
The token used for unknown charactor`,name:"unk_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|separator|&gt;&quot;</code>) &#x2014;
The token used for padding`,name:"pad_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|startoftext|&gt;&quot;</code>) &#x2014;
The beginning of sequence token.`,name:"bos_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|endoftext|&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|segmenter|&gt;&quot;</code>) &#x2014;
A special token to separate token to prefix part and general input part.`,name:"sep_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.do_clean_text",description:`<strong>do_clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean text for URL, EMAIL, TEL, Japanese DATE and Japanese PRICE.`,name:"do_clean_text"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/tokenization_gptsan_japanese.py#L62"}}),E=new Ve({props:{anchor:"transformers.GPTSanJapaneseTokenizer.example",$$slots:{default:[Qn]},$$scope:{ctx:C}}}),q=new Ve({props:{anchor:"transformers.GPTSanJapaneseTokenizer.example-2",$$slots:{default:[Zn]},$$scope:{ctx:C}}}),B=new Ve({props:{anchor:"transformers.GPTSanJapaneseTokenizer.example-3",$$slots:{default:[En]},$$scope:{ctx:C}}}),ye=new Y({props:{name:"convert_tokens_to_string",anchor:"transformers.GPTSanJapaneseTokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/tokenization_gptsan_japanese.py#L205"}}),be=new Y({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.GPTSanJapaneseTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/tokenization_gptsan_japanese.py#L288"}}),A=new Ve({props:{anchor:"transformers.GPTSanJapaneseTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[qn]},$$scope:{ctx:C}}}),Ue=new S({props:{title:"GPTSanJapaneseModel",local:"transformers.GPTSanJapaneseModel",headingTag:"h2"}}),je=new Y({props:{name:"class transformers.GPTSanJapaneseModel",anchor:"transformers.GPTSanJapaneseModel",parameters:[{name:"config",val:": GPTSanJapaneseConfig"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L850"}}),ke=new Y({props:{name:"forward",anchor:"transformers.GPTSanJapaneseModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"spout",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = False"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"num_precontext",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. GPTSAN-japanese is a model that generates sentence
continuations or predicts tokens at mask positions. Special tokens required for inputs to the model are
automatically appended.`,name:"input_ids"},{anchor:"transformers.GPTSanJapaneseModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTSanJapaneseModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
An input that masks the Prefix part in the Prefix-LM input. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>prefix</strong> input,</li>
<li>0 for tokens that are <strong>not-prefix</strong> input.</li>
</ul>`,name:"token_type_ids"},{anchor:"transformers.GPTSanJapaneseModel.forward.spout",description:`<strong>spout</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, config.d_spout)</code>) &#x2014;
This vector is transformed through an 8-layer FFN and can be used instead of <code>past_key_values</code>.`,name:"spout"},{anchor:"transformers.GPTSanJapaneseModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTSanJapaneseModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:`,name:"head_mask"},{anchor:"transformers.GPTSanJapaneseModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTSanJapaneseModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTSanJapaneseModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.GPTSanJapaneseModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTSanJapaneseModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTSanJapaneseModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GPTSanJapaneseModel.forward.router_logits",description:`<strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.
Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.`,name:"router_logits"},{anchor:"transformers.GPTSanJapaneseModel.forward.num_precontext",description:`<strong>num_precontext</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,1)</code>) &#x2014;
length of <code>hybrid</code> input tokens in the input. Tokens up to this length refer to both front and back like
BERT, tokens after that refer only to front like GPT. see also:
<a href="https://github.com/tanreinama/GPTSAN/blob/main/report/model.md" rel="nofollow">https://github.com/tanreinama/GPTSAN/blob/main/report/model.md</a>`,name:"num_precontext"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>MoEModelOutputWithPastAndCrossAttentions</code> or <code>tuple</code> if <code>return_dict</code> returns
MoEModelOutputWithPastAndCrossAttentions insted of tuple</p>
`}}),O=new Sn({props:{$$slots:{default:[Bn]},$$scope:{ctx:C}}}),Ce=new S({props:{title:"GPTSanJapaneseForConditionalGeneration",local:"transformers.GPTSanJapaneseForConditionalGeneration",headingTag:"h2"}}),xe=new Y({props:{name:"class transformers.GPTSanJapaneseForConditionalGeneration",anchor:"transformers.GPTSanJapaneseForConditionalGeneration",parameters:[{name:"config",val:": GPTSanJapaneseConfig"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L1099"}}),$e=new Y({props:{name:"forward",anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"spout",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = False"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. GPTSAN-japanese is a model that generates sentence
continuations or predicts tokens at mask positions. Special tokens required for inputs to the model are
automatically appended.`,name:"input_ids"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
An input that masks the Prefix part in the Prefix-LM input. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>prefix</strong> input,</li>
<li>0 for tokens that are <strong>not-prefix</strong> input.</li>
</ul>`,name:"token_type_ids"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.spout",description:`<strong>spout</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, config.d_spout)</code>) &#x2014;
This vector is transformed through an 8-layer FFN and can be used instead of <code>past_key_values</code>.`,name:"spout"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:`,name:"head_mask"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.router_logits",description:`<strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.
Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.`,name:"router_logits"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L1114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>MoECausalLMOutputWithPast</code> or <code>tuple</code> if <code>return_dict</code> returns MoECausalLMOutputWithPast insted of tuple</p>
`}}),X=new Sn({props:{$$slots:{default:[Wn]},$$scope:{ctx:C}}}),H=new Ve({props:{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.example",$$slots:{default:[An]},$$scope:{ctx:C}}}),D=new Ve({props:{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.example-2",$$slots:{default:[On]},$$scope:{ctx:C}}}),L=new Ve({props:{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.example-3",$$slots:{default:[Xn]},$$scope:{ctx:C}}}),we=new zn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/gptsan-japanese.md"}}),{c(){n=c("meta"),u=o(),a=c("p"),d=o(),h(y.$$.fragment),r=o(),h(U.$$.fragment),Le=o(),ee=c("p"),ee.textContent=nn,Ye=o(),te=c("p"),te.textContent=sn,Ke=o(),h(ne.$$.fragment),et=o(),se=c("p"),se.innerHTML=an,tt=o(),h(ae.$$.fragment),nt=o(),h(oe.$$.fragment),st=o(),le=c("p"),le.textContent=on,at=o(),h(re.$$.fragment),ot=o(),ie=c("p"),ie.innerHTML=ln,lt=o(),h(pe.$$.fragment),rt=o(),de=c("p"),de.textContent=rn,it=o(),ce=c("p"),ce.textContent=pn,pt=o(),me=c("blockquote"),me.innerHTML=dn,dt=o(),ue=c("blockquote"),ue.innerHTML=cn,ct=o(),he=c("blockquote"),he.innerHTML=mn,mt=o(),h(fe.$$.fragment),ut=o(),ge=c("p"),ge.innerHTML=un,ht=o(),h(Te.$$.fragment),ft=o(),G=c("div"),h(_e.$$.fragment),kt=o(),Ge=c("p"),Ge.innerHTML=hn,Ct=o(),Se=c("p"),Se.innerHTML=fn,gt=o(),h(Me.$$.fragment),Tt=o(),k=c("div"),h(Je.$$.fragment),xt=o(),Re=c("p"),Re.textContent=gn,$t=o(),Fe=c("ul"),Fe.innerHTML=Tn,wt=o(),h(E.$$.fragment),vt=o(),h(q.$$.fragment),Vt=o(),h(B.$$.fragment),Gt=o(),W=c("div"),h(ye.$$.fragment),St=o(),Ne=c("p"),Ne.textContent=_n,Rt=o(),R=c("div"),h(be.$$.fragment),Ft=o(),Ie=c("p"),Ie.textContent=Mn,Nt=o(),h(A.$$.fragment),_t=o(),h(Ue.$$.fragment),Mt=o(),$=c("div"),h(je.$$.fragment),It=o(),Pe=c("p"),Pe.textContent=Jn,Pt=o(),ze=c("p"),ze.innerHTML=yn,zt=o(),Qe=c("p"),Qe.innerHTML=bn,Qt=o(),F=c("div"),h(ke.$$.fragment),Zt=o(),Ze=c("p"),Ze.innerHTML=Un,Et=o(),h(O.$$.fragment),Jt=o(),h(Ce.$$.fragment),yt=o(),w=c("div"),h(xe.$$.fragment),qt=o(),Ee=c("p"),Ee.textContent=jn,Bt=o(),qe=c("p"),qe.innerHTML=kn,Wt=o(),Be=c("p"),Be.innerHTML=Cn,At=o(),b=c("div"),h($e.$$.fragment),Ot=o(),We=c("p"),We.innerHTML=xn,Xt=o(),h(X.$$.fragment),Ht=o(),Ae=c("p"),Ae.textContent=$n,Dt=o(),Oe=c("p"),Oe.textContent=wn,Lt=o(),h(H.$$.fragment),Yt=o(),Xe=c("p"),Xe.textContent=vn,Kt=o(),h(D.$$.fragment),en=o(),He=c("p"),He.textContent=Vn,tn=o(),h(L.$$.fragment),bt=o(),h(we.$$.fragment),Ut=o(),De=c("p"),this.h()},l(e){const t=Pn("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(s),u=l(e),a=m(e,"P",{}),N(a).forEach(s),d=l(e),f(y.$$.fragment,e),r=l(e),f(U.$$.fragment,e),Le=l(e),ee=m(e,"P",{"data-svelte-h":!0}),J(ee)!=="svelte-tknax7"&&(ee.textContent=nn),Ye=l(e),te=m(e,"P",{"data-svelte-h":!0}),J(te)!=="svelte-ydpvl8"&&(te.textContent=sn),Ke=l(e),f(ne.$$.fragment,e),et=l(e),se=m(e,"P",{"data-svelte-h":!0}),J(se)!=="svelte-1hxg3na"&&(se.innerHTML=an),tt=l(e),f(ae.$$.fragment,e),nt=l(e),f(oe.$$.fragment,e),st=l(e),le=m(e,"P",{"data-svelte-h":!0}),J(le)!=="svelte-ertpqo"&&(le.textContent=on),at=l(e),f(re.$$.fragment,e),ot=l(e),ie=m(e,"P",{"data-svelte-h":!0}),J(ie)!=="svelte-1rqeshc"&&(ie.innerHTML=ln),lt=l(e),f(pe.$$.fragment,e),rt=l(e),de=m(e,"P",{"data-svelte-h":!0}),J(de)!=="svelte-1xag9tb"&&(de.textContent=rn),it=l(e),ce=m(e,"P",{"data-svelte-h":!0}),J(ce)!=="svelte-1gl9mvz"&&(ce.textContent=pn),pt=l(e),me=m(e,"BLOCKQUOTE",{"data-svelte-h":!0}),J(me)!=="svelte-4r9qjo"&&(me.innerHTML=dn),dt=l(e),ue=m(e,"BLOCKQUOTE",{"data-svelte-h":!0}),J(ue)!=="svelte-1qp1s1n"&&(ue.innerHTML=cn),ct=l(e),he=m(e,"BLOCKQUOTE",{"data-svelte-h":!0}),J(he)!=="svelte-1use4j"&&(he.innerHTML=mn),mt=l(e),f(fe.$$.fragment,e),ut=l(e),ge=m(e,"P",{"data-svelte-h":!0}),J(ge)!=="svelte-4kiza2"&&(ge.innerHTML=un),ht=l(e),f(Te.$$.fragment,e),ft=l(e),G=m(e,"DIV",{class:!0});var P=N(G);f(_e.$$.fragment,P),kt=l(P),Ge=m(P,"P",{"data-svelte-h":!0}),J(Ge)!=="svelte-1xaa77o"&&(Ge.innerHTML=hn),Ct=l(P),Se=m(P,"P",{"data-svelte-h":!0}),J(Se)!=="svelte-o55m63"&&(Se.innerHTML=fn),P.forEach(s),gt=l(e),f(Me.$$.fragment,e),Tt=l(e),k=m(e,"DIV",{class:!0});var x=N(k);f(Je.$$.fragment,x),xt=l(x),Re=m(x,"P",{"data-svelte-h":!0}),J(Re)!=="svelte-1pkozbi"&&(Re.textContent=gn),$t=l(x),Fe=m(x,"UL",{"data-svelte-h":!0}),J(Fe)!=="svelte-12rov6i"&&(Fe.innerHTML=Tn),wt=l(x),f(E.$$.fragment,x),vt=l(x),f(q.$$.fragment,x),Vt=l(x),f(B.$$.fragment,x),Gt=l(x),W=m(x,"DIV",{class:!0});var ve=N(W);f(ye.$$.fragment,ve),St=l(ve),Ne=m(ve,"P",{"data-svelte-h":!0}),J(Ne)!=="svelte-b3k2yi"&&(Ne.textContent=_n),ve.forEach(s),Rt=l(x),R=m(x,"DIV",{class:!0});var z=N(R);f(be.$$.fragment,z),Ft=l(z),Ie=m(z,"P",{"data-svelte-h":!0}),J(Ie)!=="svelte-btxjfp"&&(Ie.textContent=Mn),Nt=l(z),f(A.$$.fragment,z),z.forEach(s),x.forEach(s),_t=l(e),f(Ue.$$.fragment,e),Mt=l(e),$=m(e,"DIV",{class:!0});var v=N($);f(je.$$.fragment,v),It=l(v),Pe=m(v,"P",{"data-svelte-h":!0}),J(Pe)!=="svelte-1jq56ze"&&(Pe.textContent=Jn),Pt=l(v),ze=m(v,"P",{"data-svelte-h":!0}),J(ze)!=="svelte-1sm4xoj"&&(ze.innerHTML=yn),zt=l(v),Qe=m(v,"P",{"data-svelte-h":!0}),J(Qe)!=="svelte-hswkmf"&&(Qe.innerHTML=bn),Qt=l(v),F=m(v,"DIV",{class:!0});var Q=N(F);f(ke.$$.fragment,Q),Zt=l(Q),Ze=m(Q,"P",{"data-svelte-h":!0}),J(Ze)!=="svelte-19ya390"&&(Ze.innerHTML=Un),Et=l(Q),f(O.$$.fragment,Q),Q.forEach(s),v.forEach(s),Jt=l(e),f(Ce.$$.fragment,e),yt=l(e),w=m(e,"DIV",{class:!0});var V=N(w);f(xe.$$.fragment,V),qt=l(V),Ee=m(V,"P",{"data-svelte-h":!0}),J(Ee)!=="svelte-mgq95n"&&(Ee.textContent=jn),Bt=l(V),qe=m(V,"P",{"data-svelte-h":!0}),J(qe)!=="svelte-1sm4xoj"&&(qe.innerHTML=kn),Wt=l(V),Be=m(V,"P",{"data-svelte-h":!0}),J(Be)!=="svelte-hswkmf"&&(Be.innerHTML=Cn),At=l(V),b=m(V,"DIV",{class:!0});var j=N(b);f($e.$$.fragment,j),Ot=l(j),We=m(j,"P",{"data-svelte-h":!0}),J(We)!=="svelte-1d362me"&&(We.innerHTML=xn),Xt=l(j),f(X.$$.fragment,j),Ht=l(j),Ae=m(j,"P",{"data-svelte-h":!0}),J(Ae)!=="svelte-11lpom8"&&(Ae.textContent=$n),Dt=l(j),Oe=m(j,"P",{"data-svelte-h":!0}),J(Oe)!=="svelte-14d7hu9"&&(Oe.textContent=wn),Lt=l(j),f(H.$$.fragment,j),Yt=l(j),Xe=m(j,"P",{"data-svelte-h":!0}),J(Xe)!=="svelte-11j4hh0"&&(Xe.textContent=vn),Kt=l(j),f(D.$$.fragment,j),en=l(j),He=m(j,"P",{"data-svelte-h":!0}),J(He)!=="svelte-t76udw"&&(He.textContent=Vn),tn=l(j),f(L.$$.fragment,j),j.forEach(s),V.forEach(s),bt=l(e),f(we.$$.fragment,e),Ut=l(e),De=m(e,"P",{}),N(De).forEach(s),this.h()},h(){I(n,"name","hf:doc:metadata"),I(n,"content",Dn),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,n),i(e,u,t),i(e,a,t),i(e,d,t),g(y,e,t),i(e,r,t),g(U,e,t),i(e,Le,t),i(e,ee,t),i(e,Ye,t),i(e,te,t),i(e,Ke,t),g(ne,e,t),i(e,et,t),i(e,se,t),i(e,tt,t),g(ae,e,t),i(e,nt,t),g(oe,e,t),i(e,st,t),i(e,le,t),i(e,at,t),g(re,e,t),i(e,ot,t),i(e,ie,t),i(e,lt,t),g(pe,e,t),i(e,rt,t),i(e,de,t),i(e,it,t),i(e,ce,t),i(e,pt,t),i(e,me,t),i(e,dt,t),i(e,ue,t),i(e,ct,t),i(e,he,t),i(e,mt,t),g(fe,e,t),i(e,ut,t),i(e,ge,t),i(e,ht,t),g(Te,e,t),i(e,ft,t),i(e,G,t),g(_e,G,null),p(G,kt),p(G,Ge),p(G,Ct),p(G,Se),i(e,gt,t),g(Me,e,t),i(e,Tt,t),i(e,k,t),g(Je,k,null),p(k,xt),p(k,Re),p(k,$t),p(k,Fe),p(k,wt),g(E,k,null),p(k,vt),g(q,k,null),p(k,Vt),g(B,k,null),p(k,Gt),p(k,W),g(ye,W,null),p(W,St),p(W,Ne),p(k,Rt),p(k,R),g(be,R,null),p(R,Ft),p(R,Ie),p(R,Nt),g(A,R,null),i(e,_t,t),g(Ue,e,t),i(e,Mt,t),i(e,$,t),g(je,$,null),p($,It),p($,Pe),p($,Pt),p($,ze),p($,zt),p($,Qe),p($,Qt),p($,F),g(ke,F,null),p(F,Zt),p(F,Ze),p(F,Et),g(O,F,null),i(e,Jt,t),g(Ce,e,t),i(e,yt,t),i(e,w,t),g(xe,w,null),p(w,qt),p(w,Ee),p(w,Bt),p(w,qe),p(w,Wt),p(w,Be),p(w,At),p(w,b),g($e,b,null),p(b,Ot),p(b,We),p(b,Xt),g(X,b,null),p(b,Ht),p(b,Ae),p(b,Dt),p(b,Oe),p(b,Lt),g(H,b,null),p(b,Yt),p(b,Xe),p(b,Kt),g(D,b,null),p(b,en),p(b,He),p(b,tn),g(L,b,null),i(e,bt,t),g(we,e,t),i(e,Ut,t),i(e,De,t),jt=!0},p(e,[t]){const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),E.$set(P);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),q.$set(x);const ve={};t&2&&(ve.$$scope={dirty:t,ctx:e}),B.$set(ve);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),A.$set(z);const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),O.$set(v);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),X.$set(Q);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),H.$set(V);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),D.$set(j);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),L.$set(Gn)},i(e){jt||(T(y.$$.fragment,e),T(U.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(oe.$$.fragment,e),T(re.$$.fragment,e),T(pe.$$.fragment,e),T(fe.$$.fragment,e),T(Te.$$.fragment,e),T(_e.$$.fragment,e),T(Me.$$.fragment,e),T(Je.$$.fragment,e),T(E.$$.fragment,e),T(q.$$.fragment,e),T(B.$$.fragment,e),T(ye.$$.fragment,e),T(be.$$.fragment,e),T(A.$$.fragment,e),T(Ue.$$.fragment,e),T(je.$$.fragment,e),T(ke.$$.fragment,e),T(O.$$.fragment,e),T(Ce.$$.fragment,e),T(xe.$$.fragment,e),T($e.$$.fragment,e),T(X.$$.fragment,e),T(H.$$.fragment,e),T(D.$$.fragment,e),T(L.$$.fragment,e),T(we.$$.fragment,e),jt=!0)},o(e){_(y.$$.fragment,e),_(U.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(Te.$$.fragment,e),_(_e.$$.fragment,e),_(Me.$$.fragment,e),_(Je.$$.fragment,e),_(E.$$.fragment,e),_(q.$$.fragment,e),_(B.$$.fragment,e),_(ye.$$.fragment,e),_(be.$$.fragment,e),_(A.$$.fragment,e),_(Ue.$$.fragment,e),_(je.$$.fragment,e),_(ke.$$.fragment,e),_(O.$$.fragment,e),_(Ce.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(X.$$.fragment,e),_(H.$$.fragment,e),_(D.$$.fragment,e),_(L.$$.fragment,e),_(we.$$.fragment,e),jt=!1},d(e){e&&(s(u),s(a),s(d),s(r),s(Le),s(ee),s(Ye),s(te),s(Ke),s(et),s(se),s(tt),s(nt),s(st),s(le),s(at),s(ot),s(ie),s(lt),s(rt),s(de),s(it),s(ce),s(pt),s(me),s(dt),s(ue),s(ct),s(he),s(mt),s(ut),s(ge),s(ht),s(ft),s(G),s(gt),s(Tt),s(k),s(_t),s(Mt),s($),s(Jt),s(yt),s(w),s(bt),s(Ut),s(De)),s(n),M(y,e),M(U,e),M(ne,e),M(ae,e),M(oe,e),M(re,e),M(pe,e),M(fe,e),M(Te,e),M(_e),M(Me,e),M(Je),M(E),M(q),M(B),M(ye),M(be),M(A),M(Ue,e),M(je),M(ke),M(O),M(Ce,e),M(xe),M($e),M(X),M(H),M(D),M(L),M(we,e)}}}const Dn='{"title":"GPTSAN-japanese","local":"gptsan-japanese","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Usage example","local":"usage-example","sections":[],"depth":3}],"depth":2},{"title":"GPTSAN Features","local":"gptsan-features","sections":[{"title":"Prefix-LM Model","local":"prefix-lm-model","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Spout Vector","local":"spout-vector","sections":[],"depth":3}],"depth":2},{"title":"GPTSanJapaneseConfig","local":"transformers.GPTSanJapaneseConfig","sections":[],"depth":2},{"title":"GPTSanJapaneseTokenizer","local":"transformers.GPTSanJapaneseTokenizer","sections":[],"depth":2},{"title":"GPTSanJapaneseModel","local":"transformers.GPTSanJapaneseModel","sections":[],"depth":2},{"title":"GPTSanJapaneseForConditionalGeneration","local":"transformers.GPTSanJapaneseForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Ln(C){return Fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends Nn{constructor(n){super(),In(this,n,Ln,Hn,Rn,{})}}export{os as component};
