import{s as Gt,n as Xt,o as Wt}from"../chunks/scheduler.6062bdaf.js";import{S as Tt,i as vt,g as i,s as l,r as c,A as Rt,h as p,f as e,c as n,j as Jt,u as r,x as o,k as Zt,y as zt,a as s,v as d,d as M,t as h,w as b}from"../chunks/index.4bca734e.js";import{C as _}from"../chunks/CodeBlock.cbbddafc.js";import{H as kt,E as Bt}from"../chunks/getInferenceSnippets.855730f4.js";function Nt(ct){let m,I,V,Q,u,x,y,rt="At its core, 🤗 Optimum uses <em>configuration objects</em> to define parameters for optimization on different accelerators. These objects are then used to instantiate dedicated <em>optimizers</em>, <em>quantizers</em>, and <em>pruners</em>.",H,j,dt="Before applying quantization or optimization, we first need to export our model to the ONNX format.",E,g,$,f,Mt="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",q,w,S,U,ht="In this example, we’ve quantized a model from the Hugging Face Hub, but it could also be a path to a local model directory. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",A,J,L,Z,bt="Similarly, you can apply static quantization by simply setting <code>is_static</code> to <code>True</code> when instantiating the <code>QuantizationConfig</code> object:",P,G,O,X,ut='Static quantization relies on feeding batches of data through the model to estimate the activation quantization parameters ahead of inference time. To support this, 🤗 Optimum allows you to provide a <em>calibration dataset</em>. The calibration dataset can be a simple <code>Dataset</code> object from the 🤗 Datasets library, or any dataset that’s hosted on the Hugging Face Hub. For this example, we’ll pick the <a href="https://huggingface.co/datasets/glue/viewer/sst2/test" rel="nofollow"><code>sst2</code></a> dataset that the model was originally trained on:',D,W,K,T,yt="As a final example, let’s take a look at applying <em>graph optimizations</em> techniques such as operator fusion and constant folding. As before, we load a configuration object, but this time by setting the optimization level instead of the quantization approach:",tt,v,at,R,jt="Next, we load an <em>optimizer</em> to apply these optimisations to our model:",et,z,st,k,gt="And that’s it - the model is now optimized and ready for inference! As you can see, the process is similar in each case:",lt,B,ft="<li>Define the optimization / quantization strategies via an <code>OptimizationConfig</code> / <code>QuantizationConfig</code> object</li> <li>Instantiate a <code>ORTQuantizer</code> or <code>ORTOptimizer</code> class</li> <li>Apply the <code>quantize()</code> or <code>optimize()</code> method</li> <li>Run inference</li>",nt,N,wt='Check out the <a href="https://github.com/huggingface/optimum/tree/main/examples" rel="nofollow"><code>examples</code></a> directory for more sophisticated usage.',it,C,Ut="Happy optimising 🤗!",pt,Y,ot,F,mt;return u=new kt({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),g=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMG9ubnglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the onnx model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),w=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),J=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xzX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBcmVzdWx0cyUyMCUzRCUyMGNsc19waXBlbGluZSglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>cls_pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cls_pipeline(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),G=new _({props:{code:"cWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNEVHJ1ZSUyQyUyMHBlcl9jaGFubmVsJTNERmFsc2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">True</span>, per_channel=<span class="hljs-literal">False</span>)',wrap:!1}}),W=new _({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZS5jb25maWd1cmF0aW9uJTIwaW1wb3J0JTIwQXV0b0NhbGlicmF0aW9uQ29uZmlnJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mbihleCUyQyUyMHRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXglNUIlMjJzZW50ZW5jZSUyMiU1RCklMEElMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBjYWxpYnJhdGlvbiUyMGRhdGFzZXQlMEFjYWxpYnJhdGlvbl9kYXRhc2V0JTIwJTNEJTIwcXVhbnRpemVyLmdldF9jYWxpYnJhdGlvbl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmdsdWUlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X2NvbmZpZ19uYW1lJTNEJTIyc3N0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lM0RwYXJ0aWFsKHByZXByb2Nlc3NfZm4lMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3NhbXBsZXMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSklMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBjYWxpYnJhdGlvbiUyMGNvbmZpZ3VyYXRpb24lMjBjb250YWluaW5nJTIwdGhlJTIwcGFyYW1ldGVycyUyMHJlbGF0ZWQlMjB0byUyMGNhbGlicmF0aW9uLiUwQWNhbGlicmF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9DYWxpYnJhdGlvbkNvbmZpZy5taW5tYXgoY2FsaWJyYXRpb25fZGF0YXNldCklMEElMjMlMjBQZXJmb3JtJTIwdGhlJTIwY2FsaWJyYXRpb24lMjBzdGVwJTNBJTIwY29tcHV0ZXMlMjB0aGUlMjBhY3RpdmF0aW9ucyUyMHF1YW50aXphdGlvbiUyMHJhbmdlcyUwQXJhbmdlcyUyMCUzRCUyMHF1YW50aXplci5maXQoJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUzRGNhbGlicmF0aW9uX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxpYnJhdGlvbl9jb25maWclM0RjYWxpYnJhdGlvbl9jb25maWclMkMlMEElMjAlMjAlMjAlMjBvcGVyYXRvcnNfdG9fcXVhbnRpemUlM0RxY29uZmlnLm9wZXJhdG9yc190b19xdWFudGl6ZSUyQyUwQSklMEElMjMlMjBBcHBseSUyMHN0YXRpYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUwQSUyMCUyMCUyMCUyMGNhbGlicmF0aW9uX3RlbnNvcnNfcmFuZ2UlM0RyYW5nZXMlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcWNvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoCalibrationConfig

<span class="hljs-comment"># Define the processing function to apply to each example after loading the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_fn</span>(<span class="hljs-params">ex, tokenizer</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(ex[<span class="hljs-string">&quot;sentence&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the calibration dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_dataset = quantizer.get_calibration_dataset(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;glue&quot;</span>,
<span class="hljs-meta">... </span>    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_function=partial(preprocess_fn, tokenizer=tokenizer),
<span class="hljs-meta">... </span>    num_samples=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the calibration configuration containing the parameters related to calibration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_config = AutoCalibrationConfig.minmax(calibration_dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform the calibration step: computes the activations quantization ranges</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ranges = quantizer.fit(
<span class="hljs-meta">... </span>    dataset=calibration_dataset,
<span class="hljs-meta">... </span>    calibration_config=calibration_config,
<span class="hljs-meta">... </span>    operators_to_quantize=qconfig.operators_to_quantize,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply static quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=save_directory,
<span class="hljs-meta">... </span>    calibration_tensors_range=ranges,
<span class="hljs-meta">... </span>    quantization_config=qconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),v=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyME9wdGltaXphdGlvbkNvbmZpZyUwQSUwQSUyMyUyMEhlcmUlMjB0aGUlMjBvcHRpbWl6YXRpb24lMjBsZXZlbCUyMGlzJTIwc2VsZWN0ZWQlMjB0byUyMGJlJTIwMSUyQyUyMGVuYWJsaW5nJTIwYmFzaWMlMjBvcHRpbWl6YXRpb25zJTIwc3VjaCUyMGFzJTIwcmVkdW5kYW50JTIwbm9kZSUyMGVsaW1pbmF0aW9ucyUyMGFuZCUyMGNvbnN0YW50JTIwZm9sZGluZy4lMjBIaWdoZXIlMjBvcHRpbWl6YXRpb24lMjBsZXZlbCUyMHdpbGwlMjByZXN1bHQlMjBpbiUyMGElMjBoYXJkd2FyZSUyMGRlcGVuZGVudCUyMG9wdGltaXplZCUyMGdyYXBoLiUwQW9wdGltaXphdGlvbl9jb25maWclMjAlM0QlMjBPcHRpbWl6YXRpb25Db25maWcob3B0aW1pemF0aW9uX2xldmVsJTNEMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> OptimizationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Here the optimization level is selected to be 1, enabling basic optimizations such as redundant node eliminations and constant folding. Higher optimization level will result in a hardware dependent optimized graph.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = OptimizationConfig(optimization_level=<span class="hljs-number">1</span>)`,wrap:!1}}),z=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRPcHRpbWl6ZXIlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBPUlRPcHRpbWl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ydF9tb2RlbCklMEElMEElMjMlMjBPcHRpbWl6ZSUyMHRoZSUyMG1vZGVsJTBBb3B0aW1pemVyLm9wdGltaXplKHNhdmVfZGlyJTNEc2F2ZV9kaXJlY3RvcnklMkMlMjBvcHRpbWl6YXRpb25fY29uZmlnJTNEb3B0aW1pemF0aW9uX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTOptimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Optimize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_directory, optimization_config=optimization_config)`,wrap:!1}}),Y=new Bt({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/quickstart.mdx"}}),{c(){m=i("meta"),I=l(),V=i("p"),Q=l(),c(u.$$.fragment),x=l(),y=i("p"),y.innerHTML=rt,H=l(),j=i("p"),j.textContent=dt,E=l(),c(g.$$.fragment),$=l(),f=i("p"),f.textContent=Mt,q=l(),c(w.$$.fragment),S=l(),U=i("p"),U.innerHTML=ht,A=l(),c(J.$$.fragment),L=l(),Z=i("p"),Z.innerHTML=bt,P=l(),c(G.$$.fragment),O=l(),X=i("p"),X.innerHTML=ut,D=l(),c(W.$$.fragment),K=l(),T=i("p"),T.innerHTML=yt,tt=l(),c(v.$$.fragment),at=l(),R=i("p"),R.innerHTML=jt,et=l(),c(z.$$.fragment),st=l(),k=i("p"),k.textContent=gt,lt=l(),B=i("ol"),B.innerHTML=ft,nt=l(),N=i("p"),N.innerHTML=wt,it=l(),C=i("p"),C.textContent=Ut,pt=l(),c(Y.$$.fragment),ot=l(),F=i("p"),this.h()},l(t){const a=Rt("svelte-u9bgzb",document.head);m=p(a,"META",{name:!0,content:!0}),a.forEach(e),I=n(t),V=p(t,"P",{}),Jt(V).forEach(e),Q=n(t),r(u.$$.fragment,t),x=n(t),y=p(t,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1vlvz9n"&&(y.innerHTML=rt),H=n(t),j=p(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1kzojza"&&(j.textContent=dt),E=n(t),r(g.$$.fragment,t),$=n(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-e7rpqh"&&(f.textContent=Mt),q=n(t),r(w.$$.fragment,t),S=n(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-o28jdo"&&(U.innerHTML=ht),A=n(t),r(J.$$.fragment,t),L=n(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-o27pzy"&&(Z.innerHTML=bt),P=n(t),r(G.$$.fragment,t),O=n(t),X=p(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-sm0oyj"&&(X.innerHTML=ut),D=n(t),r(W.$$.fragment,t),K=n(t),T=p(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-9hlkfw"&&(T.innerHTML=yt),tt=n(t),r(v.$$.fragment,t),at=n(t),R=p(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-xtipap"&&(R.innerHTML=jt),et=n(t),r(z.$$.fragment,t),st=n(t),k=p(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-8fcqft"&&(k.textContent=gt),lt=n(t),B=p(t,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-114qv5k"&&(B.innerHTML=ft),nt=n(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ka9cob"&&(N.innerHTML=wt),it=n(t),C=p(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1u3x3lz"&&(C.textContent=Ut),pt=n(t),r(Y.$$.fragment,t),ot=n(t),F=p(t,"P",{}),Jt(F).forEach(e),this.h()},h(){Zt(m,"name","hf:doc:metadata"),Zt(m,"content",Ct)},m(t,a){zt(document.head,m),s(t,I,a),s(t,V,a),s(t,Q,a),d(u,t,a),s(t,x,a),s(t,y,a),s(t,H,a),s(t,j,a),s(t,E,a),d(g,t,a),s(t,$,a),s(t,f,a),s(t,q,a),d(w,t,a),s(t,S,a),s(t,U,a),s(t,A,a),d(J,t,a),s(t,L,a),s(t,Z,a),s(t,P,a),d(G,t,a),s(t,O,a),s(t,X,a),s(t,D,a),d(W,t,a),s(t,K,a),s(t,T,a),s(t,tt,a),d(v,t,a),s(t,at,a),s(t,R,a),s(t,et,a),d(z,t,a),s(t,st,a),s(t,k,a),s(t,lt,a),s(t,B,a),s(t,nt,a),s(t,N,a),s(t,it,a),s(t,C,a),s(t,pt,a),d(Y,t,a),s(t,ot,a),s(t,F,a),mt=!0},p:Xt,i(t){mt||(M(u.$$.fragment,t),M(g.$$.fragment,t),M(w.$$.fragment,t),M(J.$$.fragment,t),M(G.$$.fragment,t),M(W.$$.fragment,t),M(v.$$.fragment,t),M(z.$$.fragment,t),M(Y.$$.fragment,t),mt=!0)},o(t){h(u.$$.fragment,t),h(g.$$.fragment,t),h(w.$$.fragment,t),h(J.$$.fragment,t),h(G.$$.fragment,t),h(W.$$.fragment,t),h(v.$$.fragment,t),h(z.$$.fragment,t),h(Y.$$.fragment,t),mt=!1},d(t){t&&(e(I),e(V),e(Q),e(x),e(y),e(H),e(j),e(E),e($),e(f),e(q),e(S),e(U),e(A),e(L),e(Z),e(P),e(O),e(X),e(D),e(K),e(T),e(tt),e(at),e(R),e(et),e(st),e(k),e(lt),e(B),e(nt),e(N),e(it),e(C),e(pt),e(ot),e(F)),e(m),b(u,t),b(g,t),b(w,t),b(J,t),b(G,t),b(W,t),b(v,t),b(z,t),b(Y,t)}}}const Ct='{"title":"Quickstart","local":"quickstart","sections":[],"depth":1}';function Yt(ct){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Tt{constructor(m){super(),vt(this,m,Yt,Nt,Gt,{})}}export{Qt as component};
