import{s as jt,f as It,n as Gt,o as Kt}from"../chunks/scheduler.37c15a92.js";import{S as Rt,i as Dt,g as i,s as n,r as o,H as xs,A as Ft,h as p,f as t,c as l,j as c,u as h,x as m,B as _s,k as Ts,y as Nt,a as e,v as g,d as u,t as y,w as f}from"../chunks/index.7cb9c9b8.js";import{H as v}from"../chunks/Heading.d3928e2a.js";function Jt(Ba){let r,Cs,Ls,$s,d,Hs,w,Ua="Now that we’ve studied the basics of multi-agents, we’re ready to go deeper. As mentioned in the introduction, we’re going <strong>to train agents in an adversarial game with SoccerTwos, a 2vs2 game</strong>.",Ps,b,Wa='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit10/soccertwos.gif" alt="SoccerTwos"/> <figcaption>This environment was made by the <a href="https://github.com/Unity-Technologies/ml-agents">Unity MLAgents Team</a></figcaption>',ks,x,zs,_,ja="Training agents correctly in an adversarial game can be <strong>quite complex</strong>.",Es,T,Ga="On the one hand, we need to find how to get a well-trained opponent to play against your training agent. And on the other hand, if you find a very good trained opponent, how will your agent improve its policy when the opponent is too strong?",As,L,Ka="Think of a child that just started to learn soccer. Playing against a very good soccer player will be useless since it will be too hard to win or at least get the ball from time to time. So the child will continuously lose without having time to learn a good policy.",Is,M,Ra="The best solution would be <strong>to have an opponent that is on the same level as the agent and will upgrade its level as the agent upgrades its own</strong>. Because if the opponent is too strong, we’ll learn nothing; if it is too weak, we’ll overlearn useless behavior against a stronger opponent then.",Os,C,Da="This solution is called <em>self-play</em>. In self-play, <strong>the agent uses former copies of itself (of its policy) as an opponent</strong>. This way, the agent will play against an agent of the same level (challenging but not too much), have opportunities to gradually improve its policy, and then update its opponent as it becomes better. It’s a way to bootstrap an opponent and progressively increase the opponent’s complexity.",Ss,$,Fa="It’s the same way humans learn in competition:",qs,H,Na="<li>We start to train against an opponent of similar level</li> <li>Then we learn from it, and when we acquire some skills, we can move further with stronger opponents.</li>",Bs,P,Ja="We do the same with self-play:",Us,k,Qa="<li>We <strong>start with a copy of our agent as an opponent</strong> this way, this opponent is on a similar level.</li> <li>We <strong>learn from it</strong> and, when we acquire some skills, we <strong>update our opponent with a more recent copy of our training policy</strong>.</li>",Ws,z,Va='The theory behind self-play is not something new. It was already used by Arthur Samuel’s checker player system in the fifties and by Gerald Tesauro’s TD-Gammon in 1995. If you want to learn more about the history of self-play <a href="https://blog.unity.com/technology/training-intelligent-adversaries-using-self-play-with-ml-agents" rel="nofollow">check out this very good blogpost by Andrew Cohen</a>',js,E,Gs,A,Xa="Self-Play is integrated into the MLAgents library and is managed by multiple hyperparameters that we’re going to study. But the main focus, as explained in the documentation, is the <strong>tradeoff between the skill level and generality of the final policy and the stability of learning</strong>.",Ks,I,Ya="Training against a set of slowly changing or unchanging adversaries with low diversity <strong>results in more stable training. But a risk to overfit if the change is too slow.</strong>",Rs,O,Za="So we need to control:",Ds,S,st=`<li>How <strong>often we change opponents</strong> with the <code>swap_steps</code> and <code>team_change</code> parameters.</li> <li>The <strong>number of opponents saved</strong> with the <code>window</code> parameter. A larger value of <code>window</code>
 means that an agent’s pool of opponents will contain a larger diversity of behaviors since it will contain policies from earlier in the training run.</li> <li>The <strong>probability of playing against the current self vs opponent</strong> sampled from the pool with <code>play_against_latest_model_ratio</code>. A larger value of <code>play_against_latest_model_ratio</code>
 indicates that an agent will be playing against the current opponent more often.</li> <li>The <strong>number of training steps before saving a new opponent</strong> with <code>save_steps</code> parameters. A larger value of <code>save_steps</code>
 will yield a set of opponents that cover a wider range of skill levels and possibly play styles since the policy receives more training.</li>`,Fs,q,at='To get more details about these hyperparameters, you definitely need <a href="https://github.com/Unity-Technologies/ml-agents/blob/develop/docs/Training-Configuration-File.md#self-play" rel="nofollow">to check out this part of the documentation</a>',Ns,B,Js,U,Qs,W,tt="In adversarial games, tracking the <strong>cumulative reward is not always a meaningful metric to track the learning progress:</strong> because this metric is <strong>dependent only on the skill of the opponent.</strong>",Vs,j,et="Instead, we’re using an <strong><em>ELO rating system</em></strong> (named after Arpad Elo) that calculates the <strong>relative skill level</strong> between 2 players from a given population in a zero-sum game.",Xs,G,nt="In a zero-sum game: one agent wins, and the other agent loses. It’s a mathematical representation of a situation in which each participant’s gain or loss of utility <strong>is exactly balanced by the gain or loss of the utility of the other participants.</strong> We talk about zero-sum games because the sum of utility is equal to zero.",Ys,K,lt="This ELO (starting at a specific score: frequently 1200) can decrease initially but should increase progressively during the training.",Zs,R,it="The Elo system is <strong>inferred from the losses and draws against other players.</strong> It means that player ratings depend <strong>on the ratings of their opponents and the results scored against them.</strong>",sa,D,pt="Elo defines an Elo score that is the relative skills of a player in a zero-sum game. <strong>We say relative because it depends on the performance of opponents.</strong>",aa,F,mt="The central idea is to think of the performance of a player <strong>as a random variable that is normally distributed.</strong>",ta,N,rt="The difference in rating between 2 players serves as <strong>the predictor of the outcomes of a match.</strong> If the player wins, but the probability of winning is high, it will only win a few points from its opponent since it means that it is much stronger than it.",ea,J,ot="After every game:",na,Q,ct="<li>The winning player takes <strong>points from the losing one.</strong></li> <li>The number of points is determined <strong>by the difference in the 2 players ratings (hence relative).</strong><ul><li>If the higher-rated player wins → few points will be taken from the lower-rated player.</li> <li>If the lower-rated player wins → a lot of points will be taken from the high-rated player.</li> <li>If it’s a draw → the lower-rated player gains a few points from the higher.</li></ul></li>",la,V,ht="So if A and B have rating Ra, and Rb, then the <strong>expected scores are</strong> given by:",ia,X,gt,pa,Y,ut="Then, at the end of the game, we need to update the player’s actual Elo score. We use a linear adjustment <strong>proportional to the amount by which the player over-performed or under-performed.</strong>",ma,Z,yt="We also define a maximum adjustment rating per game: K-factor.",ra,ss,ft="<li>K=16 for master.</li> <li>K=32 for weaker players.</li>",oa,as,vt="If Player A has Ea points but scored Sa points, then the player’s rating is updated using the formula:",ca,ts,dt,ha,es,ga,ns,wt="If we take an example:",ua,ls,bt="Player A has a rating of 2600",ya,is,xt="Player B has a rating of 2300",fa,ps,_t="<li>We first calculate the expected score:</li>",va,ys,da,Ot='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>E</mi><mi>A</mi></msub><mo>=</mo><mfrac><mn>1</mn><mrow><mn>1</mn><mo>+</mo><mn>1</mn><msup><mn>0</mn><mrow><mo stretchy="false">(</mo><mn>2300</mn><mo>−</mo><mn>2600</mn><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mn>400</mn></mrow></msup></mrow></mfrac><mo>=</mo><mn>0.849</mn></mrow><annotation encoding="application/x-tex">E_{A} = \\frac{1}{1+10^{(2300-2600)/400}} = 0.849 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">A</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2889em;vertical-align:-0.4438em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8451em;"><span style="top:-2.6146em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span><span class="mbin mtight">+</span><span class="mord mtight">1</span><span class="mord mtight"><span class="mord mtight">0</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.822em;"><span style="top:-2.822em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5357em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mtight">2300</span><span class="mbin mtight">−</span><span class="mord mtight">2600</span><span class="mclose mtight">)</span><span class="mord mtight">/400</span></span></span></span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4438em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.849</span></span></span></span>',wa,fs,ba,St='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>E</mi><mi>B</mi></msub><mo>=</mo><mfrac><mn>1</mn><mrow><mn>1</mn><mo>+</mo><mn>1</mn><msup><mn>0</mn><mrow><mo stretchy="false">(</mo><mn>2600</mn><mo>−</mo><mn>2300</mn><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mn>400</mn></mrow></msup></mrow></mfrac><mo>=</mo><mn>0.151</mn></mrow><annotation encoding="application/x-tex">E_{B} = \\frac{1}{1+10^{(2600-2300)/400}} = 0.151 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2889em;vertical-align:-0.4438em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8451em;"><span style="top:-2.6146em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span><span class="mbin mtight">+</span><span class="mord mtight">1</span><span class="mord mtight"><span class="mord mtight">0</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.822em;"><span style="top:-2.822em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5357em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mtight">2600</span><span class="mbin mtight">−</span><span class="mord mtight">2300</span><span class="mclose mtight">)</span><span class="mord mtight">/400</span></span></span></span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4438em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.151</span></span></span></span>',xa,ms,Tt="<li>If the organizers determined that K=16 and A wins, the new rating would be:</li>",_a,vs,Ta,qt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>A</mi></msub><mo>=</mo><mn>2600</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mn>0.849</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2602</mn></mrow><annotation encoding="application/x-tex">ELO_A = 2600 + 16*(1-0.849) = 2602 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">A</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2600</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.849</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2602</span></span></span></span>',La,ds,Ma,Bt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>B</mi></msub><mo>=</mo><mn>2300</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>0</mn><mo>−</mo><mn>0.151</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2298</mn></mrow><annotation encoding="application/x-tex">ELO_B = 2300 + 16*(0-0.151) = 2298 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2300</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">0</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.151</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2298</span></span></span></span>',Ca,rs,Lt="<li>If the organizers determined that K=16 and B wins, the new rating would be:</li>",$a,ws,Ha,Ut='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>A</mi></msub><mo>=</mo><mn>2600</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>0</mn><mo>−</mo><mn>0.849</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2586</mn></mrow><annotation encoding="application/x-tex">ELO_A = 2600 + 16*(0-0.849) = 2586 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">A</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2600</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">0</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.849</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2586</span></span></span></span>',Pa,bs,ka,Wt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>B</mi></msub><mo>=</mo><mn>2300</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mn>0.151</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2314</mn></mrow><annotation encoding="application/x-tex">ELO_B = 2300 + 16 *(1-0.151) = 2314 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2300</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.151</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2314</span></span></span></span>',za,os,Ea,cs,Mt="Using the ELO score has multiple advantages:",Aa,hs,Ct="<li>Points are <strong>always balanced</strong> (more points are exchanged when there is an unexpected outcome, but the sum is always the same).</li> <li>It is a <strong>self-corrected system</strong> since if a player wins against a weak player, they will only win a few points.</li> <li>It <strong>works with team games</strong>: we calculate the average for each team and use it in Elo.</li>",Ia,gs,Oa,us,$t="<li>ELO <strong>does not take into account the individual contribution</strong> of each people in the team.</li> <li>Rating deflation: <strong>a good rating requires skill over time to keep the same rating</strong>.</li> <li><strong>Can’t compare rating in history</strong>.</li>",Sa,Ms,qa;return d=new v({props:{title:"Self-Play: a classic technique to train competitive agents in adversarial games",local:"self-play-a-classic-technique-to-train-competitive-agents-in-adversarial-games",headingTag:"h1"}}),x=new v({props:{title:"What is Self-Play?",local:"what-is-self-play",headingTag:"h2"}}),E=new v({props:{title:"Self-Play in MLAgents",local:"self-play-in-mlagents",headingTag:"h2"}}),B=new v({props:{title:"The ELO Score to evaluate our agent",local:"the-elo-score-to-evaluate-our-agent",headingTag:"h2"}}),U=new v({props:{title:"What is ELO Score?",local:"what-is-elo-score",headingTag:"h3"}}),es=new v({props:{title:"Example",local:"example",headingTag:"h3"}}),os=new v({props:{title:"The Advantages",local:"the-advantages",headingTag:"h3"}}),gs=new v({props:{title:"The Disadvantages",local:"the-disadvantages",headingTag:"h3"}}),{c(){r=i("meta"),Cs=n(),Ls=i("p"),$s=n(),o(d.$$.fragment),Hs=n(),w=i("p"),w.innerHTML=Ua,Ps=n(),b=i("figure"),b.innerHTML=Wa,ks=n(),o(x.$$.fragment),zs=n(),_=i("p"),_.innerHTML=ja,Es=n(),T=i("p"),T.textContent=Ga,As=n(),L=i("p"),L.textContent=Ka,Is=n(),M=i("p"),M.innerHTML=Ra,Os=n(),C=i("p"),C.innerHTML=Da,Ss=n(),$=i("p"),$.textContent=Fa,qs=n(),H=i("ul"),H.innerHTML=Na,Bs=n(),P=i("p"),P.textContent=Ja,Us=n(),k=i("ul"),k.innerHTML=Qa,Ws=n(),z=i("p"),z.innerHTML=Va,js=n(),o(E.$$.fragment),Gs=n(),A=i("p"),A.innerHTML=Xa,Ks=n(),I=i("p"),I.innerHTML=Ya,Rs=n(),O=i("p"),O.textContent=Za,Ds=n(),S=i("ul"),S.innerHTML=st,Fs=n(),q=i("p"),q.innerHTML=at,Ns=n(),o(B.$$.fragment),Js=n(),o(U.$$.fragment),Qs=n(),W=i("p"),W.innerHTML=tt,Vs=n(),j=i("p"),j.innerHTML=et,Xs=n(),G=i("p"),G.innerHTML=nt,Ys=n(),K=i("p"),K.textContent=lt,Zs=n(),R=i("p"),R.innerHTML=it,sa=n(),D=i("p"),D.innerHTML=pt,aa=n(),F=i("p"),F.innerHTML=mt,ta=n(),N=i("p"),N.innerHTML=rt,ea=n(),J=i("p"),J.textContent=ot,na=n(),Q=i("ul"),Q.innerHTML=ct,la=n(),V=i("p"),V.innerHTML=ht,ia=n(),X=i("img"),pa=n(),Y=i("p"),Y.innerHTML=ut,ma=n(),Z=i("p"),Z.textContent=yt,ra=n(),ss=i("ul"),ss.innerHTML=ft,oa=n(),as=i("p"),as.textContent=vt,ca=n(),ts=i("img"),ha=n(),o(es.$$.fragment),ga=n(),ns=i("p"),ns.textContent=wt,ua=n(),ls=i("p"),ls.textContent=bt,ya=n(),is=i("p"),is.textContent=xt,fa=n(),ps=i("ul"),ps.innerHTML=_t,va=n(),ys=i("p"),da=new xs(!1),wa=n(),fs=i("p"),ba=new xs(!1),xa=n(),ms=i("ul"),ms.innerHTML=Tt,_a=n(),vs=i("p"),Ta=new xs(!1),La=n(),ds=i("p"),Ma=new xs(!1),Ca=n(),rs=i("ul"),rs.innerHTML=Lt,$a=n(),ws=i("p"),Ha=new xs(!1),Pa=n(),bs=i("p"),ka=new xs(!1),za=n(),o(os.$$.fragment),Ea=n(),cs=i("p"),cs.textContent=Mt,Aa=n(),hs=i("ul"),hs.innerHTML=Ct,Ia=n(),o(gs.$$.fragment),Oa=n(),us=i("ul"),us.innerHTML=$t,Sa=n(),Ms=i("p"),this.h()},l(s){const a=Ft("svelte-u9bgzb",document.head);r=p(a,"META",{name:!0,content:!0}),a.forEach(t),Cs=l(s),Ls=p(s,"P",{}),c(Ls).forEach(t),$s=l(s),h(d.$$.fragment,s),Hs=l(s),w=p(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-11761za"&&(w.innerHTML=Ua),Ps=l(s),b=p(s,"FIGURE",{"data-svelte-h":!0}),m(b)!=="svelte-100gprn"&&(b.innerHTML=Wa),ks=l(s),h(x.$$.fragment,s),zs=l(s),_=p(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-lpi75"&&(_.innerHTML=ja),Es=l(s),T=p(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-14lxxwh"&&(T.textContent=Ga),As=l(s),L=p(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-p0ulb9"&&(L.textContent=Ka),Is=l(s),M=p(s,"P",{"data-svelte-h":!0}),m(M)!=="svelte-u5xaw1"&&(M.innerHTML=Ra),Os=l(s),C=p(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1h64ov0"&&(C.innerHTML=Da),Ss=l(s),$=p(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-55g9r1"&&($.textContent=Fa),qs=l(s),H=p(s,"UL",{"data-svelte-h":!0}),m(H)!=="svelte-lzd6wo"&&(H.innerHTML=Na),Bs=l(s),P=p(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1o4lxst"&&(P.textContent=Ja),Us=l(s),k=p(s,"UL",{"data-svelte-h":!0}),m(k)!=="svelte-1emhb1j"&&(k.innerHTML=Qa),Ws=l(s),z=p(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-kbldhc"&&(z.innerHTML=Va),js=l(s),h(E.$$.fragment,s),Gs=l(s),A=p(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1ebc5gu"&&(A.innerHTML=Xa),Ks=l(s),I=p(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-10ql4ev"&&(I.innerHTML=Ya),Rs=l(s),O=p(s,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1ai24rk"&&(O.textContent=Za),Ds=l(s),S=p(s,"UL",{"data-svelte-h":!0}),m(S)!=="svelte-1mu3qvi"&&(S.innerHTML=st),Fs=l(s),q=p(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1cykdly"&&(q.innerHTML=at),Ns=l(s),h(B.$$.fragment,s),Js=l(s),h(U.$$.fragment,s),Qs=l(s),W=p(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1mqy8v4"&&(W.innerHTML=tt),Vs=l(s),j=p(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-gobmv7"&&(j.innerHTML=et),Xs=l(s),G=p(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1o35bla"&&(G.innerHTML=nt),Ys=l(s),K=p(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-15oqr9w"&&(K.textContent=lt),Zs=l(s),R=p(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-157lnkz"&&(R.innerHTML=it),sa=l(s),D=p(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1y39nsv"&&(D.innerHTML=pt),aa=l(s),F=p(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-131w5mi"&&(F.innerHTML=mt),ta=l(s),N=p(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1dcyvr4"&&(N.innerHTML=rt),ea=l(s),J=p(s,"P",{"data-svelte-h":!0}),m(J)!=="svelte-aiamx5"&&(J.textContent=ot),na=l(s),Q=p(s,"UL",{"data-svelte-h":!0}),m(Q)!=="svelte-f0z965"&&(Q.innerHTML=ct),la=l(s),V=p(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1arvr0c"&&(V.innerHTML=ht),ia=l(s),X=p(s,"IMG",{src:!0,alt:!0}),pa=l(s),Y=p(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-18tm8in"&&(Y.innerHTML=ut),ma=l(s),Z=p(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1rjqydl"&&(Z.textContent=yt),ra=l(s),ss=p(s,"UL",{"data-svelte-h":!0}),m(ss)!=="svelte-11vizph"&&(ss.innerHTML=ft),oa=l(s),as=p(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-vcvh8c"&&(as.textContent=vt),ca=l(s),ts=p(s,"IMG",{src:!0,alt:!0}),ha=l(s),h(es.$$.fragment,s),ga=l(s),ns=p(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-w96c5b"&&(ns.textContent=wt),ua=l(s),ls=p(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-1xxccyh"&&(ls.textContent=bt),ya=l(s),is=p(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-g7g8r5"&&(is.textContent=xt),fa=l(s),ps=p(s,"UL",{"data-svelte-h":!0}),m(ps)!=="svelte-6kyfto"&&(ps.innerHTML=_t),va=l(s),ys=p(s,"P",{});var Ht=c(ys);da=_s(Ht,!1),Ht.forEach(t),wa=l(s),fs=p(s,"P",{});var Pt=c(fs);ba=_s(Pt,!1),Pt.forEach(t),xa=l(s),ms=p(s,"UL",{"data-svelte-h":!0}),m(ms)!=="svelte-19f3iy9"&&(ms.innerHTML=Tt),_a=l(s),vs=p(s,"P",{});var kt=c(vs);Ta=_s(kt,!1),kt.forEach(t),La=l(s),ds=p(s,"P",{});var zt=c(ds);Ma=_s(zt,!1),zt.forEach(t),Ca=l(s),rs=p(s,"UL",{"data-svelte-h":!0}),m(rs)!=="svelte-1aqpfwy"&&(rs.innerHTML=Lt),$a=l(s),ws=p(s,"P",{});var Et=c(ws);Ha=_s(Et,!1),Et.forEach(t),Pa=l(s),bs=p(s,"P",{});var At=c(bs);ka=_s(At,!1),At.forEach(t),za=l(s),h(os.$$.fragment,s),Ea=l(s),cs=p(s,"P",{"data-svelte-h":!0}),m(cs)!=="svelte-9bi3av"&&(cs.textContent=Mt),Aa=l(s),hs=p(s,"UL",{"data-svelte-h":!0}),m(hs)!=="svelte-1uibl83"&&(hs.innerHTML=Ct),Ia=l(s),h(gs.$$.fragment,s),Oa=l(s),us=p(s,"UL",{"data-svelte-h":!0}),m(us)!=="svelte-s7jtcw"&&(us.innerHTML=$t),Sa=l(s),Ms=p(s,"P",{}),c(Ms).forEach(t),this.h()},h(){Ts(r,"name","hf:doc:metadata"),Ts(r,"content",Qt),It(X.src,gt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit10/elo1.png")||Ts(X,"src",gt),Ts(X,"alt","ELO Score"),It(ts.src,dt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit10/elo2.png")||Ts(ts,"src",dt),Ts(ts,"alt","ELO Score"),da.a=null,ba.a=null,Ta.a=null,Ma.a=null,Ha.a=null,ka.a=null},m(s,a){Nt(document.head,r),e(s,Cs,a),e(s,Ls,a),e(s,$s,a),g(d,s,a),e(s,Hs,a),e(s,w,a),e(s,Ps,a),e(s,b,a),e(s,ks,a),g(x,s,a),e(s,zs,a),e(s,_,a),e(s,Es,a),e(s,T,a),e(s,As,a),e(s,L,a),e(s,Is,a),e(s,M,a),e(s,Os,a),e(s,C,a),e(s,Ss,a),e(s,$,a),e(s,qs,a),e(s,H,a),e(s,Bs,a),e(s,P,a),e(s,Us,a),e(s,k,a),e(s,Ws,a),e(s,z,a),e(s,js,a),g(E,s,a),e(s,Gs,a),e(s,A,a),e(s,Ks,a),e(s,I,a),e(s,Rs,a),e(s,O,a),e(s,Ds,a),e(s,S,a),e(s,Fs,a),e(s,q,a),e(s,Ns,a),g(B,s,a),e(s,Js,a),g(U,s,a),e(s,Qs,a),e(s,W,a),e(s,Vs,a),e(s,j,a),e(s,Xs,a),e(s,G,a),e(s,Ys,a),e(s,K,a),e(s,Zs,a),e(s,R,a),e(s,sa,a),e(s,D,a),e(s,aa,a),e(s,F,a),e(s,ta,a),e(s,N,a),e(s,ea,a),e(s,J,a),e(s,na,a),e(s,Q,a),e(s,la,a),e(s,V,a),e(s,ia,a),e(s,X,a),e(s,pa,a),e(s,Y,a),e(s,ma,a),e(s,Z,a),e(s,ra,a),e(s,ss,a),e(s,oa,a),e(s,as,a),e(s,ca,a),e(s,ts,a),e(s,ha,a),g(es,s,a),e(s,ga,a),e(s,ns,a),e(s,ua,a),e(s,ls,a),e(s,ya,a),e(s,is,a),e(s,fa,a),e(s,ps,a),e(s,va,a),e(s,ys,a),da.m(Ot,ys),e(s,wa,a),e(s,fs,a),ba.m(St,fs),e(s,xa,a),e(s,ms,a),e(s,_a,a),e(s,vs,a),Ta.m(qt,vs),e(s,La,a),e(s,ds,a),Ma.m(Bt,ds),e(s,Ca,a),e(s,rs,a),e(s,$a,a),e(s,ws,a),Ha.m(Ut,ws),e(s,Pa,a),e(s,bs,a),ka.m(Wt,bs),e(s,za,a),g(os,s,a),e(s,Ea,a),e(s,cs,a),e(s,Aa,a),e(s,hs,a),e(s,Ia,a),g(gs,s,a),e(s,Oa,a),e(s,us,a),e(s,Sa,a),e(s,Ms,a),qa=!0},p:Gt,i(s){qa||(u(d.$$.fragment,s),u(x.$$.fragment,s),u(E.$$.fragment,s),u(B.$$.fragment,s),u(U.$$.fragment,s),u(es.$$.fragment,s),u(os.$$.fragment,s),u(gs.$$.fragment,s),qa=!0)},o(s){y(d.$$.fragment,s),y(x.$$.fragment,s),y(E.$$.fragment,s),y(B.$$.fragment,s),y(U.$$.fragment,s),y(es.$$.fragment,s),y(os.$$.fragment,s),y(gs.$$.fragment,s),qa=!1},d(s){s&&(t(Cs),t(Ls),t($s),t(Hs),t(w),t(Ps),t(b),t(ks),t(zs),t(_),t(Es),t(T),t(As),t(L),t(Is),t(M),t(Os),t(C),t(Ss),t($),t(qs),t(H),t(Bs),t(P),t(Us),t(k),t(Ws),t(z),t(js),t(Gs),t(A),t(Ks),t(I),t(Rs),t(O),t(Ds),t(S),t(Fs),t(q),t(Ns),t(Js),t(Qs),t(W),t(Vs),t(j),t(Xs),t(G),t(Ys),t(K),t(Zs),t(R),t(sa),t(D),t(aa),t(F),t(ta),t(N),t(ea),t(J),t(na),t(Q),t(la),t(V),t(ia),t(X),t(pa),t(Y),t(ma),t(Z),t(ra),t(ss),t(oa),t(as),t(ca),t(ts),t(ha),t(ga),t(ns),t(ua),t(ls),t(ya),t(is),t(fa),t(ps),t(va),t(ys),t(wa),t(fs),t(xa),t(ms),t(_a),t(vs),t(La),t(ds),t(Ca),t(rs),t($a),t(ws),t(Pa),t(bs),t(za),t(Ea),t(cs),t(Aa),t(hs),t(Ia),t(Oa),t(us),t(Sa),t(Ms)),t(r),f(d,s),f(x,s),f(E,s),f(B,s),f(U,s),f(es,s),f(os,s),f(gs,s)}}}const Qt='{"title":"Self-Play: a classic technique to train competitive agents in adversarial games","local":"self-play-a-classic-technique-to-train-competitive-agents-in-adversarial-games","sections":[{"title":"What is Self-Play?","local":"what-is-self-play","sections":[],"depth":2},{"title":"Self-Play in MLAgents","local":"self-play-in-mlagents","sections":[],"depth":2},{"title":"The ELO Score to evaluate our agent","local":"the-elo-score-to-evaluate-our-agent","sections":[{"title":"What is ELO Score?","local":"what-is-elo-score","sections":[],"depth":3},{"title":"Example","local":"example","sections":[],"depth":3},{"title":"The Advantages","local":"the-advantages","sections":[],"depth":3},{"title":"The Disadvantages","local":"the-disadvantages","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vt(Ba){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class se extends Rt{constructor(r){super(),Dt(this,r,Vt,Jt,jt,{})}}export{se as component};
