import{s as bl,n as Tl,o as fl}from"../chunks/scheduler.85c25b89.js";import{S as Ul,i as vl,g as a,s as p,u as c,A as Cl,h as n,f as l,c as i,j as h,v as M,y as m,k as o,o as r,a as s,w as j,d as y,t as d,x as u}from"../chunks/index.9633332f.js";import{I as mt}from"../chunks/IconCopyLink.a4acffac.js";import{C as K}from"../chunks/CodeBlock.00597c71.js";function Il(Dt){let w,ct,at,Mt,J,U,nt,x,St,O,Lt="DenseNet",jt,A,Pt='<strong>DenseNet</strong> is a type of convolutional neural network that utilises dense connections between layers, through <a href="http://www.paperswithcode.com/method/dense-block" rel="nofollow">Dense Blocks</a>, where we connect <em>all layers</em> (with matching feature-map sizes) directly with each other. To preserve the feed-forward nature, each layer obtains additional inputs from all preceding layers and passes on its own feature-maps to all subsequent layers.',yt,E,qt='The <strong>DenseNet Blur</strong> variant in this collection by Ross Wightman employs <a href="http://www.paperswithcode.com/method/blur-pooling" rel="nofollow">Blur Pooling</a>',dt,g,v,pt,N,Yt,tt,Kt="How do I use this model on an image?",ut,Z,Ot="To load a pretrained model:",wt,W,Jt,$,tl="To load and preprocess the image:",gt,B,bt,Q,ll="To get the model predictions:",Tt,R,ft,G,el="To get the top-5 predictions class names:",Ut,V,vt,_,sl="Replace the model name with the variant you want to use, e.g. <code>densenet121</code>. You can find the IDs in the model summaries at the top of this page.",Ct,H,al='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',It,b,C,it,S,Xt,lt,nl="How do I finetune this model?",kt,Y,pl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",xt,X,At,z,il=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Et,T,I,ot,F,zt,et,ol="How do I train this model?",Nt,D,rl='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zt,f,k,rt,L,Ft,st,hl="Citation",Wt,P,$t,q,Bt,ht,Qt;return x=new mt({}),N=new mt({}),W=new K({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RlbnNlbmV0MTIxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new K({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),R=new K({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),V=new K({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new mt({}),X=new K({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGVuc2VuZXQxMjEnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new mt({}),L=new mt({}),P=new K({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIdWFuZ0xXMTZhJTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCR2FvJTIwSHVhbmclMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVhbmclMjBMaXUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLaWxpYW4lMjBRLiUyMFdlaW5iZXJnZXIlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkRlbnNlbHklMjBDb25uZWN0ZWQlMjBDb252b2x1dGlvbmFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDguMDY5OTMlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA4LjA2OTkzJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwOC4wNjk5MyU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEwJTIwU2VwJTIwMjAxOCUyMDE1JTNBNDklM0EzMiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSHVhbmdMVzE2YS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HuangLW16a,
  author    = {Gao Huang and
               Zhuang Liu and
               Kilian Q. Weinberger},
  title     = {Densely Connected Convolutional Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1608.06993</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1608.06993</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1608.06993</span>},
  timestamp = {Mon, <span class="hljs-number">10</span> Sep <span class="hljs-number">2018</span> <span class="hljs-number">15</span>:<span class="hljs-number">49</span>:<span class="hljs-number">32</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HuangLW16a.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`}}),q=new K({props:{code:"JTQwbWlzYyU3QnJ3MjAxOXRpbW0lMkMlMEElMjAlMjBhdXRob3IlMjAlM0QlMjAlN0JSb3NzJTIwV2lnaHRtYW4lN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUzRCUyMCU3QlB5VG9yY2glMjBJbWFnZSUyME1vZGVscyU3RCUyQyUwQSUyMCUyMHllYXIlMjAlM0QlMjAlN0IyMDE5JTdEJTJDJTBBJTIwJTIwcHVibGlzaGVyJTIwJTNEJTIwJTdCR2l0SHViJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUzRCUyMCU3QkdpdEh1YiUyMHJlcG9zaXRvcnklN0QlMkMlMEElMjAlMjBkb2klMjAlM0QlMjAlN0IxMC41MjgxJTJGemVub2RvLjQ0MTQ4NjElN0QlMkMlMEElMjAlMjBob3dwdWJsaXNoZWQlMjAlM0QlMjAlN0IlNUN1cmwlN0JodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZyd2lnaHRtYW4lMkZweXRvcmNoLWltYWdlLW1vZGVscyU3RCU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{rw2019timm,
  author = {Ross Wightman}</span><span class="language-xml">,
  title = </span><span class="hljs-template-variable">{PyTorch Image Models}</span><span class="language-xml">,
  year = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  publisher = </span><span class="hljs-template-variable">{GitHub}</span><span class="language-xml">,
  journal = </span><span class="hljs-template-variable">{GitHub repository}</span><span class="language-xml">,
  doi = </span><span class="hljs-template-variable">{10.5281/zenodo.4414861}</span><span class="language-xml">,
  howpublished = </span><span class="hljs-template-variable">{\\url{https://github.com/rwightman/pytorch-image-models}</span><span class="language-xml">}
}</span>`}}),{c(){w=a("meta"),ct=p(),at=a("p"),Mt=p(),J=a("h1"),U=a("a"),nt=a("span"),c(x.$$.fragment),St=p(),O=a("span"),O.textContent=Lt,jt=p(),A=a("p"),A.innerHTML=Pt,yt=p(),E=a("p"),E.innerHTML=qt,dt=p(),g=a("h2"),v=a("a"),pt=a("span"),c(N.$$.fragment),Yt=p(),tt=a("span"),tt.textContent=Kt,ut=p(),Z=a("p"),Z.textContent=Ot,wt=p(),c(W.$$.fragment),Jt=p(),$=a("p"),$.textContent=tl,gt=p(),c(B.$$.fragment),bt=p(),Q=a("p"),Q.textContent=ll,Tt=p(),c(R.$$.fragment),ft=p(),G=a("p"),G.textContent=el,Ut=p(),c(V.$$.fragment),vt=p(),_=a("p"),_.innerHTML=sl,Ct=p(),H=a("p"),H.innerHTML=al,It=p(),b=a("h2"),C=a("a"),it=a("span"),c(S.$$.fragment),Xt=p(),lt=a("span"),lt.textContent=nl,kt=p(),Y=a("p"),Y.textContent=pl,xt=p(),c(X.$$.fragment),At=p(),z=a("p"),z.innerHTML=il,Et=p(),T=a("h2"),I=a("a"),ot=a("span"),c(F.$$.fragment),zt=p(),et=a("span"),et.textContent=ol,Nt=p(),D=a("p"),D.innerHTML=rl,Zt=p(),f=a("h2"),k=a("a"),rt=a("span"),c(L.$$.fragment),Ft=p(),st=a("span"),st.textContent=hl,Wt=p(),c(P.$$.fragment),$t=p(),c(q.$$.fragment),Bt=p(),ht=a("p"),this.h()},l(t){const e=Cl("svelte-1phssyn",document.head);w=n(e,"META",{name:!0,content:!0}),e.forEach(l),ct=i(t),at=n(t,"P",{}),h(at).forEach(l),Mt=i(t),J=n(t,"H1",{class:!0});var Rt=h(J);U=n(Rt,"A",{id:!0,class:!0,href:!0});var ml=h(U);nt=n(ml,"SPAN",{});var cl=h(nt);M(x.$$.fragment,cl),cl.forEach(l),ml.forEach(l),St=i(Rt),O=n(Rt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-cw8ckj"&&(O.textContent=Lt),Rt.forEach(l),jt=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-49zh7b"&&(A.innerHTML=Pt),yt=i(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-5gcm94"&&(E.innerHTML=qt),dt=i(t),g=n(t,"H2",{class:!0});var Gt=h(g);v=n(Gt,"A",{id:!0,class:!0,href:!0});var Ml=h(v);pt=n(Ml,"SPAN",{});var jl=h(pt);M(N.$$.fragment,jl),jl.forEach(l),Ml.forEach(l),Yt=i(Gt),tt=n(Gt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1c1hspn"&&(tt.textContent=Kt),Gt.forEach(l),ut=i(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Ot),wt=i(t),M(W.$$.fragment,t),Jt=i(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1c2ipa8"&&($.textContent=tl),gt=i(t),M(B.$$.fragment,t),bt=i(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1n9qsq1"&&(Q.textContent=ll),Tt=i(t),M(R.$$.fragment,t),ft=i(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-19cnvx1"&&(G.textContent=el),Ut=i(t),M(V.$$.fragment,t),vt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1bbpuw6"&&(_.innerHTML=sl),Ct=i(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1wmi3ea"&&(H.innerHTML=al),It=i(t),b=n(t,"H2",{class:!0});var Vt=h(b);C=n(Vt,"A",{id:!0,class:!0,href:!0});var yl=h(C);it=n(yl,"SPAN",{});var dl=h(it);M(S.$$.fragment,dl),dl.forEach(l),yl.forEach(l),Xt=i(Vt),lt=n(Vt,"SPAN",{"data-svelte-h":!0}),m(lt)!=="svelte-1viv4qv"&&(lt.textContent=nl),Vt.forEach(l),kt=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=pl),xt=i(t),M(X.$$.fragment,t),At=i(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1kguc51"&&(z.innerHTML=il),Et=i(t),T=n(t,"H2",{class:!0});var _t=h(T);I=n(_t,"A",{id:!0,class:!0,href:!0});var ul=h(I);ot=n(ul,"SPAN",{});var wl=h(ot);M(F.$$.fragment,wl),wl.forEach(l),ul.forEach(l),zt=i(_t),et=n(_t,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-1ce591d"&&(et.textContent=ol),_t.forEach(l),Nt=i(t),D=n(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1n0coha"&&(D.innerHTML=rl),Zt=i(t),f=n(t,"H2",{class:!0});var Ht=h(f);k=n(Ht,"A",{id:!0,class:!0,href:!0});var Jl=h(k);rt=n(Jl,"SPAN",{});var gl=h(rt);M(L.$$.fragment,gl),gl.forEach(l),Jl.forEach(l),Ft=i(Ht),st=n(Ht,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-15mb3gy"&&(st.textContent=hl),Ht.forEach(l),Wt=i(t),M(P.$$.fragment,t),$t=i(t),M(q.$$.fragment,t),Bt=i(t),ht=n(t,"P",{}),h(ht).forEach(l),this.h()},h(){o(w,"name","hf:doc:metadata"),o(w,"content",JSON.stringify(kl)),o(U,"id","densenet"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#densenet"),o(J,"class","relative group"),o(v,"id","how-do-i-use-this-model-on-an-image"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#how-do-i-use-this-model-on-an-image"),o(g,"class","relative group"),o(C,"id","how-do-i-finetune-this-model"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#how-do-i-finetune-this-model"),o(b,"class","relative group"),o(I,"id","how-do-i-train-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-train-this-model"),o(T,"class","relative group"),o(k,"id","citation"),o(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(k,"href","#citation"),o(f,"class","relative group")},m(t,e){r(document.head,w),s(t,ct,e),s(t,at,e),s(t,Mt,e),s(t,J,e),r(J,U),r(U,nt),j(x,nt,null),r(J,St),r(J,O),s(t,jt,e),s(t,A,e),s(t,yt,e),s(t,E,e),s(t,dt,e),s(t,g,e),r(g,v),r(v,pt),j(N,pt,null),r(g,Yt),r(g,tt),s(t,ut,e),s(t,Z,e),s(t,wt,e),j(W,t,e),s(t,Jt,e),s(t,$,e),s(t,gt,e),j(B,t,e),s(t,bt,e),s(t,Q,e),s(t,Tt,e),j(R,t,e),s(t,ft,e),s(t,G,e),s(t,Ut,e),j(V,t,e),s(t,vt,e),s(t,_,e),s(t,Ct,e),s(t,H,e),s(t,It,e),s(t,b,e),r(b,C),r(C,it),j(S,it,null),r(b,Xt),r(b,lt),s(t,kt,e),s(t,Y,e),s(t,xt,e),j(X,t,e),s(t,At,e),s(t,z,e),s(t,Et,e),s(t,T,e),r(T,I),r(I,ot),j(F,ot,null),r(T,zt),r(T,et),s(t,Nt,e),s(t,D,e),s(t,Zt,e),s(t,f,e),r(f,k),r(k,rt),j(L,rt,null),r(f,Ft),r(f,st),s(t,Wt,e),j(P,t,e),s(t,$t,e),j(q,t,e),s(t,Bt,e),s(t,ht,e),Qt=!0},p:Tl,i(t){Qt||(y(x.$$.fragment,t),y(N.$$.fragment,t),y(W.$$.fragment,t),y(B.$$.fragment,t),y(R.$$.fragment,t),y(V.$$.fragment,t),y(S.$$.fragment,t),y(X.$$.fragment,t),y(F.$$.fragment,t),y(L.$$.fragment,t),y(P.$$.fragment,t),y(q.$$.fragment,t),Qt=!0)},o(t){d(x.$$.fragment,t),d(N.$$.fragment,t),d(W.$$.fragment,t),d(B.$$.fragment,t),d(R.$$.fragment,t),d(V.$$.fragment,t),d(S.$$.fragment,t),d(X.$$.fragment,t),d(F.$$.fragment,t),d(L.$$.fragment,t),d(P.$$.fragment,t),d(q.$$.fragment,t),Qt=!1},d(t){t&&(l(ct),l(at),l(Mt),l(J),l(jt),l(A),l(yt),l(E),l(dt),l(g),l(ut),l(Z),l(wt),l(Jt),l($),l(gt),l(bt),l(Q),l(Tt),l(ft),l(G),l(Ut),l(vt),l(_),l(Ct),l(H),l(It),l(b),l(kt),l(Y),l(xt),l(At),l(z),l(Et),l(T),l(Nt),l(D),l(Zt),l(f),l(Wt),l($t),l(Bt),l(ht)),l(w),u(x),u(N),u(W,t),u(B,t),u(R,t),u(V,t),u(S),u(X,t),u(F),u(L),u(P,t),u(q,t)}}}const kl={local:"densenet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"DenseNet"};function xl(Dt){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wl extends Ul{constructor(w){super(),vl(this,w,xl,Il,bl,{})}}export{Wl as component};
