import{s as wn,o as jn,n as jt}from"../chunks/scheduler.37c15a92.js";import{S as Un,i as dn,g as p,s as n,r as m,m as it,H as ha,A as Jn,h as o,f as e,c as l,j as yt,u as c,x as i,n as rt,B as Ma,k as hn,y as T,a,v as h,d as M,t as y,w as u}from"../chunks/index.7cb9c9b8.js";import{T as ut}from"../chunks/Tip.d10b3fc9.js";import{Y as bn}from"../chunks/Youtube.8666c400.js";import{C as j}from"../chunks/CodeBlock.abae2786.js";import{C as Tn}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as wt,E as gn}from"../chunks/index.c99deea2.js";function fn(J){let r,U="💡 This section covers Unigram in depth, going as far as showing a full implementation. You can skip to the end if you just want a general overview of the tokenization algorithm.";return{c(){r=p("p"),r.textContent=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-11nzsd1"&&(r.textContent=U)},m(w,d){a(w,r,d)},p:jt,d(w){w&&e(r)}}}function Cn(J){let r,U="✏️ <strong>Now your turn!</strong> Write the code to compute the frequencies above and double-check that the results shown are correct, as well as the total sum.";return{c(){r=p("p"),r.innerHTML=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-kyc6dp"&&(r.innerHTML=U)},m(w,d){a(w,r,d)},p:jt,d(w){w&&e(r)}}}function In(J){let r,U="✏️ <strong>Now your turn!</strong> Determine the tokenization of the word <code>&quot;huggun&quot;</code>, and its score.";return{c(){r=p("p"),r.innerHTML=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-zwh8th"&&(r.innerHTML=U)},m(w,d){a(w,r,d)},p:jt,d(w){w&&e(r)}}}function kn(J){let r,U="💡 SentencePiece uses a more efficient algorithm called Enhanced Suffix Array (ESA) to create the initial vocabulary.";return{c(){r=p("p"),r.textContent=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1s00c64"&&(r.textContent=U)},m(w,d){a(w,r,d)},p:jt,d(w){w&&e(r)}}}function vn(J){let r,U="💡 This approach is very inefficient, so SentencePiece uses an approximation of the loss of the model without token X: instead of starting from scratch, it just replaces token X by its segmentation in the vocabulary that is left. This way, all the scores can be computed at once at the same time as the model loss.";return{c(){r=p("p"),r.textContent=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-p8xm7n"&&(r.textContent=U)},m(w,d){a(w,r,d)},p:jt,d(w){w&&e(r)}}}function $n(J){let r,U,w,d,A,Ut,Z,dt,_,ya="The Unigram algorithm is often used in SentencePiece, which is the tokenization algorithm used by models like AlBERT, T5, mBART, Big Bird, and XLNet.",Jt,N,bt,C,Tt,z,gt,V,ua="Compared to BPE and WordPiece, Unigram works in the other direction: it starts from a big vocabulary and removes tokens from it until it reaches the desired vocabulary size. There are several options to use to build that base vocabulary: we can take the most common substrings in pre-tokenized words, for instance, or apply BPE on the initial corpus with a large vocabulary size.",ft,Q,wa="At each step of the training, the Unigram algorithm computes a loss over the corpus given the current vocabulary. Then, for each symbol in the vocabulary, the algorithm computes how much the overall loss would increase if the symbol was removed, and looks for the symbols that would increase it the least. Those symbols have a lower effect on the overall loss over the corpus, so in a sense they are “less needed” and are the best candidates for removal.",Ct,I,pa,It,Mn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi></mrow><annotation encoding="application/x-tex">p</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">p</span></span></span></span>',kt,vt,B,ja="Note that we never remove the base characters, to make sure any word can be tokenized.",$t,G,Ua="Now, this is still a bit vague: the main part of the algorithm is to compute a loss over the corpus and see how it changes when we remove some tokens from the vocabulary, but we haven’t explained how to do this yet. This step relies on the tokenization algorithm of a Unigram model, so we’ll dive into this next.",qt,S,da="We’ll reuse the corpus from the previous examples:",xt,R,At,E,Ja="and for this example, we will take all strict substrings for the initial vocabulary :",Zt,H,_t,X,Nt,W,ba="A Unigram model is a type of language model that considers each token to be independent of the tokens before it. It’s the simplest language model, in the sense that the probability of token X given the previous context is just the probability of token X. So, if we used a Unigram language model to generate text, we would always predict the most common token.",zt,K,Ta="The probability of a given token is its frequency (the number of times we find it) in the original corpus, divided by the sum of all frequencies of all tokens in the vocabulary (to make sure the probabilities sum up to 1). For instance, <code>&quot;ug&quot;</code> is present in <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, and <code>&quot;hugs&quot;</code>, so it has a frequency of 20 in our corpus.",Vt,Y,ga="Here are the frequencies of all the possible subwords in the vocabulary:",Qt,D,Bt,F,fa="So, the sum of all frequencies is 210, and the probability of the subword <code>&quot;ug&quot;</code> is thus 20/210.",Gt,k,St,b,oa,mt,Ca='["p", "u", "g"]',ia,ct,Ia='"pug"',ra,Rt,yn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>P</mi><mo stretchy="false">(</mo><mo stretchy="false">[</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">]</mo><mo stretchy="false">)</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>=</mo><mfrac><mn>5</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>36</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>20</mn><mn>210</mn></mfrac><mo>=</mo><mn>0.000389</mn></mrow><annotation encoding="application/x-tex">P([``p&quot;, ``u&quot;, ``g&quot;]) = P(``p&quot;) \\times P(``u&quot;) \\times P(``g&quot;) = \\frac{5}{210} \\times \\frac{36}{210} \\times \\frac{20}{210} = 0.000389</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">([</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">])</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">5</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">36</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">20</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.000389</span></span></span></span></span>',Et,f,ma,ht,ka='["pu", "g"]',ca,Ht,un='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>P</mi><mo stretchy="false">(</mo><mo stretchy="false">[</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">]</mo><mo stretchy="false">)</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>=</mo><mfrac><mn>5</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>20</mn><mn>210</mn></mfrac><mo>=</mo><mn>0.0022676</mn></mrow><annotation encoding="application/x-tex">P([``pu&quot;, ``g&quot;]) = P(``pu&quot;) \\times P(``g&quot;) = \\frac{5}{210} \\times \\frac{20}{210} = 0.0022676</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">([</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">])</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">5</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">20</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.0022676</span></span></span></span></span>',Xt,P,va="so that one is way more likely. In general, tokenizations with the least tokens possible will have the highest probability (because of that division by 210 repeated for each token), which corresponds to what we want intuitively: to split a word into the least number of tokens possible.",Wt,L,$a="The tokenization of a word with the Unigram model is then the tokenization with the highest probability. In the example of <code>&quot;pug&quot;</code>, here are the probabilities we would get for each possible segmentation:",Kt,O,Yt,ss,qa="So, <code>&quot;pug&quot;</code> would be tokenized as <code>[&quot;p&quot;, &quot;ug&quot;]</code> or <code>[&quot;pu&quot;, &quot;g&quot;]</code>, depending on which of those segmentations is encountered first (note that in a larger corpus, equality cases like this will be rare).",Dt,ts,xa="In this case, it was easy to find all the possible segmentations and compute their probabilities, but in general it’s going to be a bit harder. There is a classic algorithm used for this, called the <em>Viterbi algorithm</em>. Essentially, we can build a graph to detect the possible segmentations of a given word by saying there is a branch from character <em>a</em> to character <em>b</em> if the subword from <em>a</em> to <em>b</em> is in the vocabulary, and attribute to that branch the probability of the subword.",Ft,es,Aa="To find the path in that graph that is going to have the best score the Viterbi algorithm determines, for each position in the word, the segmentation with the best score that ends at that position. Since we go from the beginning to the end, that best score can be found by looping through all subwords ending at the current position and then using the best tokenization score from the position this subword begins at. Then, we just have to unroll the path taken to arrive at the end.",Pt,as,Za="Let’s take a look at an example using our vocabulary and the word <code>&quot;unhug&quot;</code>. For each position, the subwords with the best scores ending there are the following:",Lt,ns,Ot,ls,_a="Thus <code>&quot;unhug&quot;</code> would be tokenized as <code>[&quot;un&quot;, &quot;hug&quot;]</code>.",se,v,te,ps,ee,os,Na="Now that we have seen how the tokenization works, we can dive a little more deeply into the loss used during training. At any given stage, this loss is computed by tokenizing every word in the corpus, using the current vocabulary and the Unigram model determined by the frequencies of each token in the corpus (as seen before).",ae,is,za="Each word in the corpus has a score, and the loss is the negative log likelihood of those scores — that is, the sum for all the words in the corpus of all the <code>-log(P(word))</code>.",ne,rs,Va="Let’s go back to our example with the following corpus:",le,ms,pe,cs,Qa="The tokenization of each word with their respective scores is:",oe,hs,ie,Ms,Ba="So the loss is:",re,ys,me,us,Ga="Now we need to compute how removing each token affects the loss. This is rather tedious, so we’ll just do it for two tokens here and save the whole process for when we have code to help us. In this (very) particular case, we had two equivalent tokenizations of all the words: as we saw earlier, for example, <code>&quot;pug&quot;</code> could be tokenized <code>[&quot;p&quot;, &quot;ug&quot;]</code> with the same score. Thus, removing the <code>&quot;pu&quot;</code> token from the vocabulary will give the exact same loss.",ce,ws,Sa="On the other hand, removing <code>&quot;hug&quot;</code> will make the loss worse, because the tokenization of <code>&quot;hug&quot;</code> and <code>&quot;hugs&quot;</code> will become:",he,js,Me,Us,Ra="These changes will cause the loss to rise by:",ye,ds,ue,Js,Ea="Therefore, the token <code>&quot;pu&quot;</code> will probably be removed from the vocabulary, but not <code>&quot;hug&quot;</code>.",we,bs,je,Ts,Ha="Now let’s implement everything we’ve seen so far in code. Like with BPE and WordPiece, this is not an efficient implementation of the Unigram algorithm (quite the opposite), but it should help you understand it a bit better.",Ue,gs,Xa="We will use the same corpus as before as an example:",de,fs,Je,Cs,Wa="This time, we will use <code>xlnet-base-cased</code> as our model:",be,Is,Te,ks,Ka="Like for BPE and WordPiece, we begin by counting the number of occurrences of each word in the corpus:",ge,vs,fe,$s,Ya="Then, we need to initialize our vocabulary to something larger than the vocab size we will want at the end. We have to include all the basic characters (otherwise we won’t be able to tokenize every word), but for the bigger substrings we’ll only keep the most common ones, so we sort them by frequency:",Ce,qs,Ie,xs,ke,As,Da="We group the characters with the best subwords to arrive at an initial vocabulary of size 300:",ve,Zs,$e,$,qe,_s,Fa="Next, we compute the sum of all frequencies, to convert the frequencies into probabilities. For our model we will store the logarithms of the probabilities, because it’s more numerically stable to add logarithms than to multiply small numbers, and this will simplify the computation of the loss of the model:",xe,Ns,Ae,zs,Pa="Now the main function is the one that tokenizes words using the Viterbi algorithm. As we saw before, that algorithm computes the best segmentation of each substring of the word, which we will store in a variable named <code>best_segmentations</code>. We will store one dictionary per position in the word (from 0 to its total length), with two keys: the index of the start of the last token in the best segmentation, and the score of the best segmentation. With the index of the start of the last token, we will be able to retrieve the full segmentation once the list is completely populated.",Ze,Vs,La="Populating the list is done with just two loops: the main loop goes over each start position, and the second loop tries all substrings beginning at that start position. If the substring is in the vocabulary, we have a new segmentation of the word up until that end position, which we compare to what is in <code>best_segmentations</code>.",_e,Qs,Oa="Once the main loop is finished, we just start from the end and hop from one start position to the next, recording the tokens as we go, until we reach the start of the word:",Ne,Bs,ze,Gs,sn="We can already try our initial model on some words:",Ve,Ss,Qe,Rs,Be,Es,tn="Now it’s easy to compute the loss of the model on the corpus!",Ge,Hs,Se,Xs,en="We can check it works on the model we have:",Re,Ws,Ee,Ks,He,Ys,an="Computing the scores for each token is not very hard either; we just have to compute the loss for the models obtained by deleting each token:",Xe,Ds,We,Fs,nn="We can try it on a given token:",Ke,Ps,Ye,Ls,ln="Since <code>&quot;ll&quot;</code> is used in the tokenization of <code>&quot;Hopefully&quot;</code>, and removing it will probably make us use the token <code>&quot;l&quot;</code> twice instead, we expect it will have a positive loss. <code>&quot;his&quot;</code> is only used inside the word <code>&quot;This&quot;</code>, which is tokenized as itself, so we expect it to have a zero loss. Here are the results:",De,Os,Fe,q,Pe,st,pn="With all of this in place, the last thing we need to do is add the special tokens used by the model to the vocabulary, then loop until we have pruned enough tokens from the vocabulary to reach our desired size:",Le,tt,Oe,et,on="Then, to tokenize some text, we just need to apply the pre-tokenization and then use our <code>encode_word()</code> function:",sa,at,ta,nt,ea,lt,rn="That’s it for Unigram! Hopefully by now you’re feeling like an expert in all things tokenizer. In the next section, we will delve into the building blocks of the 🤗 Tokenizers library, and show you how you can use them to build your own tokenizer.",aa,pt,na,Mt,la;return A=new wt({props:{title:"Unigram tokenization",local:"unigram-tokenization",headingTag:"h1"}}),Z=new Tn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section7.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section7.ipynb"}]}}),N=new bn({props:{id:"TGZfZVuF9Yc"}}),C=new ut({props:{$$slots:{default:[fn]},$$scope:{ctx:J}}}),z=new wt({props:{title:"Training algorithm",local:"training-algorithm",headingTag:"h2"}}),R=new j({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new j({props:{code:"JTVCJTIyaCUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaHUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJwdSUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJ1biUyMiUyQyUyMCUyMmIlMjIlMkMlMjAlMjJidSUyMiUyQyUyMCUyMnMlMjIlMkMlMjAlMjJodWclMjIlMkMlMjAlMjJncyUyMiUyQyUyMCUyMnVncyUyMiU1RA==",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;bu&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;gs&quot;</span>, <span class="hljs-string">&quot;ugs&quot;</span>]</span>',wrap:!1}}),X=new wt({props:{title:"Tokenization algorithm",local:"tokenization-algorithm",headingTag:"h2"}}),D=new j({props:{code:"KCUyMmglMjIlMkMlMjAxNSklMjAoJTIydSUyMiUyQyUyMDM2KSUyMCglMjJnJTIyJTJDJTIwMjApJTIwKCUyMmh1JTIyJTJDJTIwMTUpJTIwKCUyMnVnJTIyJTJDJTIwMjApJTIwKCUyMnAlMjIlMkMlMjAxNyklMjAoJTIycHUlMjIlMkMlMjAxNyklMjAoJTIybiUyMiUyQyUyMDE2KSUwQSglMjJ1biUyMiUyQyUyMDE2KSUyMCglMjJiJTIyJTJDJTIwNCklMjAoJTIyYnUlMjIlMkMlMjA0KSUyMCglMjJzJTIyJTJDJTIwNSklMjAoJTIyaHVnJTIyJTJDJTIwMTUpJTIwKCUyMmdzJTIyJTJDJTIwNSklMjAoJTIydWdzJTIyJTJDJTIwNSk=",highlighted:`(<span class="hljs-string">&quot;h&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;u&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">36</span>) (<span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">20</span>) (<span class="hljs-string">&quot;hu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">20</span>) (<span class="hljs-string">&quot;p&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">17</span>) (<span class="hljs-string">&quot;pu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">17</span>) (<span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">16</span>)
(<span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">16</span>) (<span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>) (<span class="hljs-string">&quot;bu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>) (<span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>) (<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;gs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>) (<span class="hljs-string">&quot;ugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)`,wrap:!1}}),k=new ut({props:{$$slots:{default:[Cn]},$$scope:{ctx:J}}}),O=new j({props:{code:"JTVCJTIycCUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwJTNBJTIwMC4wMDAzODklMEElNUIlMjJwJTIyJTJDJTIwJTIydWclMjIlNUQlMjAlM0ElMjAwLjAwMjI2NzYlMEElNUIlMjJwdSUyMiUyQyUyMCUyMmclMjIlNUQlMjAlM0ElMjAwLjAwMjI2NzY=",highlighted:`[<span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] : 0.000389
[<span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>] : 0.0022676
[<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] : 0.0022676`,wrap:!1}}),ns=new j({props:{code:"Q2hhcmFjdGVyJTIwMCUyMCh1KSUzQSUyMCUyMnUlMjIlMjAoc2NvcmUlMjAwLjE3MTQyOSklMEFDaGFyYWN0ZXIlMjAxJTIwKG4pJTNBJTIwJTIydW4lMjIlMjAoc2NvcmUlMjAwLjA3NjE5MSklMEFDaGFyYWN0ZXIlMjAyJTIwKGgpJTNBJTIwJTIydW4lMjIlMjAlMjJoJTIyJTIwKHNjb3JlJTIwMC4wMDU0NDIpJTBBQ2hhcmFjdGVyJTIwMyUyMCh1KSUzQSUyMCUyMnVuJTIyJTIwJTIyaHUlMjIlMjAoc2NvcmUlMjAwLjAwNTQ0MiklMEFDaGFyYWN0ZXIlMjA0JTIwKGcpJTNBJTIwJTIydW4lMjIlMjAlMjJodWclMjIlMjAoc2NvcmUlMjAwLjAwNTQ0Mik=",highlighted:`<span class="hljs-attribute">Character</span> <span class="hljs-number">0</span> (u): <span class="hljs-string">&quot;u&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">171429</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">1</span> (n): <span class="hljs-string">&quot;un&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">076191</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">2</span> (h): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;h&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">3</span> (u): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;hu&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">4</span> (g): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;hug&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)`,wrap:!1}}),v=new ut({props:{$$slots:{default:[In]},$$scope:{ctx:J}}}),ps=new wt({props:{title:"Back to training",local:"back-to-training",headingTag:"h2"}}),ms=new j({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),hs=new j({props:{code:"JTIyaHVnJTIyJTNBJTIwJTVCJTIyaHVnJTIyJTVEJTIwKHNjb3JlJTIwMC4wNzE0MjgpJTBBJTIycHVnJTIyJTNBJTIwJTVCJTIycHUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDc3MTApJTBBJTIycHVuJTIyJTNBJTIwJTVCJTIycHUlMjIlMkMlMjAlMjJuJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDYxNjgpJTBBJTIyYnVuJTIyJTNBJTIwJTVCJTIyYnUlMjIlMkMlMjAlMjJuJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDE0NTEpJTBBJTIyaHVncyUyMiUzQSUyMCU1QiUyMmh1ZyUyMiUyQyUyMCUyMnMlMjIlNUQlMjAoc2NvcmUlMjAwLjAwMTcwMSk=",highlighted:`<span class="hljs-string">&quot;hug&quot;</span>: [<span class="hljs-string">&quot;hug&quot;</span>] <span class="hljs-comment">(score 0.071428)</span>
<span class="hljs-string">&quot;pug&quot;</span>: [<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] <span class="hljs-comment">(score 0.007710)</span>
<span class="hljs-string">&quot;pun&quot;</span>: [<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>] <span class="hljs-comment">(score 0.006168)</span>
<span class="hljs-string">&quot;bun&quot;</span>: [<span class="hljs-string">&quot;bu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>] <span class="hljs-comment">(score 0.001451)</span>
<span class="hljs-string">&quot;hugs&quot;</span>: [<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>] <span class="hljs-comment">(score 0.001701)</span>`,wrap:!1}}),ys=new j({props:{code:"MTAlMjAqJTIwKC1sb2coMC4wNzE0MjgpKSUyMCUyQiUyMDUlMjAqJTIwKC1sb2coMC4wMDc3MTApKSUyMCUyQiUyMDEyJTIwKiUyMCgtbG9nKDAuMDA2MTY4KSklMjAlMkIlMjA0JTIwKiUyMCgtbG9nKDAuMDAxNDUxKSklMjAlMkIlMjA1JTIwKiUyMCgtbG9nKDAuMDAxNzAxKSklMjAlM0QlMjAxNjkuOA==",highlighted:'<span class="hljs-attribute">10</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">071428</span>)) + <span class="hljs-number">5</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">007710</span>)) + <span class="hljs-number">12</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">006168</span>)) + <span class="hljs-number">4</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">001451</span>)) + <span class="hljs-number">5</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">001701</span>)) = <span class="hljs-number">169</span>.<span class="hljs-number">8</span>',wrap:!1}}),js=new j({props:{code:"JTIyaHVnJTIyJTNBJTIwJTVCJTIyaHUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDY4MDIpJTBBJTIyaHVncyUyMiUzQSUyMCU1QiUyMmh1JTIyJTJDJTIwJTIyZ3MlMjIlNUQlMjAoc2NvcmUlMjAwLjAwMTcwMSk=",highlighted:`<span class="hljs-string">&quot;hug&quot;</span>: [<span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] <span class="hljs-comment">(score 0.006802)</span>
<span class="hljs-string">&quot;hugs&quot;</span>: [<span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;gs&quot;</span>] <span class="hljs-comment">(score 0.001701)</span>`,wrap:!1}}),ds=new j({props:{code:"LSUyMDEwJTIwKiUyMCgtbG9nKDAuMDcxNDI4KSklMjAlMkIlMjAxMCUyMColMjAoLWxvZygwLjAwNjgwMikpJTIwJTNEJTIwMjMuNQ==",highlighted:'- <span class="hljs-number">10</span> * (<span class="hljs-name">-log</span>(<span class="hljs-number">0.071428</span>)) + <span class="hljs-number">10</span> * (<span class="hljs-name">-log</span>(<span class="hljs-number">0.006802</span>)) = <span class="hljs-number">23.5</span>',wrap:!1}}),bs=new wt({props:{title:"Implementing Unigram",local:"implementing-unigram",headingTag:"h2"}}),fs=new j({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Is=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG5ldC1iYXNlLWNhc2VkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;xlnet-base-cased&quot;</span>)`,wrap:!1}}),vs=new j({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBd29yZF9mcmVxcw==",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

word_freqs`,wrap:!1}}),qs=new j({props:{code:"Y2hhcl9mcmVxcyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEFzdWJ3b3Jkc19mcmVxcyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEFmb3IlMjB3b3JkJTJDJTIwZnJlcSUyMGluJTIwd29yZF9mcmVxcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKHdvcmQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNoYXJfZnJlcXMlNUJ3b3JkJTVCaSU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMb29wJTIwdGhyb3VnaCUyMHRoZSUyMHN1YndvcmRzJTIwb2YlMjBsZW5ndGglMjBhdCUyMGxlYXN0JTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGolMjBpbiUyMHJhbmdlKGklMjAlMkIlMjAyJTJDJTIwbGVuKHdvcmQpJTIwJTJCJTIwMSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdWJ3b3Jkc19mcmVxcyU1QndvcmQlNUJpJTNBaiU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMEElMjMlMjBTb3J0JTIwc3Vid29yZHMlMjBieSUyMGZyZXF1ZW5jeSUwQXNvcnRlZF9zdWJ3b3JkcyUyMCUzRCUyMHNvcnRlZChzdWJ3b3Jkc19mcmVxcy5pdGVtcygpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIxJTVEJTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBc29ydGVkX3N1YndvcmRzJTVCJTNBMTAlNUQ=",highlighted:`char_freqs = defaultdict(<span class="hljs-built_in">int</span>)
subwords_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word)):
        char_freqs[word[i]] += freq
        <span class="hljs-comment"># Loop through the subwords of length at least 2</span>
        <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(i + <span class="hljs-number">2</span>, <span class="hljs-built_in">len</span>(word) + <span class="hljs-number">1</span>):
            subwords_freqs[word[i:j]] += freq

<span class="hljs-comment"># Sort subwords by frequency</span>
sorted_subwords = <span class="hljs-built_in">sorted</span>(subwords_freqs.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>], reverse=<span class="hljs-literal">True</span>)
sorted_subwords[:<span class="hljs-number">10</span>]`,wrap:!1}}),xs=new j({props:{code:"JTVCKCclRTIlOTYlODF0JyUyQyUyMDcpJTJDJTIwKCdpcyclMkMlMjA1KSUyQyUyMCgnZXInJTJDJTIwNSklMkMlMjAoJyVFMiU5NiU4MWEnJTJDJTIwNSklMkMlMjAoJyVFMiU5NiU4MXRvJyUyQyUyMDQpJTJDJTIwKCd0byclMkMlMjA0KSUyQyUyMCgnZW4nJTJDJTIwNCklMkMlMjAoJyVFMiU5NiU4MVQnJTJDJTIwMyklMkMlMjAoJyVFMiU5NiU4MVRoJyUyQyUyMDMpJTJDJTIwKCclRTIlOTYlODFUaGknJTJDJTIwMyklNUQ=",highlighted:'[(<span class="hljs-string">&#x27;▁t&#x27;</span>, <span class="hljs-number">7</span>), (<span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;▁a&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;▁T&#x27;</span>, <span class="hljs-number">3</span>), (<span class="hljs-string">&#x27;▁Th&#x27;</span>, <span class="hljs-number">3</span>), (<span class="hljs-string">&#x27;▁Thi&#x27;</span>, <span class="hljs-number">3</span>)]',wrap:!1}}),Zs=new j({props:{code:"dG9rZW5fZnJlcXMlMjAlM0QlMjBsaXN0KGNoYXJfZnJlcXMuaXRlbXMoKSklMjAlMkIlMjBzb3J0ZWRfc3Vid29yZHMlNUIlM0ElMjAzMDAlMjAtJTIwbGVuKGNoYXJfZnJlcXMpJTVEJTBBdG9rZW5fZnJlcXMlMjAlM0QlMjAlN0J0b2tlbiUzQSUyMGZyZXElMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzJTdE",highlighted:`token_freqs = <span class="hljs-built_in">list</span>(char_freqs.items()) + sorted_subwords[: <span class="hljs-number">300</span> - <span class="hljs-built_in">len</span>(char_freqs)]
token_freqs = {token: freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs}`,wrap:!1}}),$=new ut({props:{$$slots:{default:[kn]},$$scope:{ctx:J}}}),Ns=new j({props:{code:"ZnJvbSUyMG1hdGglMjBpbXBvcnQlMjBsb2clMEElMEF0b3RhbF9zdW0lMjAlM0QlMjBzdW0oJTVCZnJlcSUyMGZvciUyMHRva2VuJTJDJTIwZnJlcSUyMGluJTIwdG9rZW5fZnJlcXMuaXRlbXMoKSU1RCklMEFtb2RlbCUyMCUzRCUyMCU3QnRva2VuJTNBJTIwLWxvZyhmcmVxJTIwJTJGJTIwdG90YWxfc3VtKSUyMGZvciUyMHRva2VuJTJDJTIwZnJlcSUyMGluJTIwdG9rZW5fZnJlcXMuaXRlbXMoKSU3RA==",highlighted:`<span class="hljs-keyword">from</span> math <span class="hljs-keyword">import</span> log

total_sum = <span class="hljs-built_in">sum</span>([freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()])
model = {token: -log(freq / total_sum) <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()}`,wrap:!1}}),Bs=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_word</span>(<span class="hljs-params">word, model</span>):
    best_segmentations = [{<span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}] + [
        {<span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-literal">None</span>} <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word))
    ]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word)):
        <span class="hljs-comment"># This should be properly filled by the previous steps of the loop</span>
        best_score_at_start = best_segmentations[start_idx][<span class="hljs-string">&quot;score&quot;</span>]
        <span class="hljs-keyword">for</span> end_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(start_idx + <span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(word) + <span class="hljs-number">1</span>):
            token = word[start_idx:end_idx]
            <span class="hljs-keyword">if</span> token <span class="hljs-keyword">in</span> model <span class="hljs-keyword">and</span> best_score_at_start <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                score = model[token] + best_score_at_start
                <span class="hljs-comment"># If we have found a better segmentation ending at end_idx, we update</span>
                <span class="hljs-keyword">if</span> (
                    best_segmentations[end_idx][<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
                    <span class="hljs-keyword">or</span> best_segmentations[end_idx][<span class="hljs-string">&quot;score&quot;</span>] &gt; score
                ):
                    best_segmentations[end_idx] = {<span class="hljs-string">&quot;start&quot;</span>: start_idx, <span class="hljs-string">&quot;score&quot;</span>: score}

    segmentation = best_segmentations[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">if</span> segmentation[<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-comment"># We did not find a tokenization of the word -&gt; unknown</span>
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>], <span class="hljs-literal">None</span>

    score = segmentation[<span class="hljs-string">&quot;score&quot;</span>]
    start = segmentation[<span class="hljs-string">&quot;start&quot;</span>]
    end = <span class="hljs-built_in">len</span>(word)
    tokens = []
    <span class="hljs-keyword">while</span> start != <span class="hljs-number">0</span>:
        tokens.insert(<span class="hljs-number">0</span>, word[start:end])
        next_start = best_segmentations[start][<span class="hljs-string">&quot;start&quot;</span>]
        end = start
        start = next_start
    tokens.insert(<span class="hljs-number">0</span>, word[start:end])
    <span class="hljs-keyword">return</span> tokens, score`,wrap:!1}}),Ss=new j({props:{code:"cHJpbnQoZW5jb2RlX3dvcmQoJTIySG9wZWZ1bGx5JTIyJTJDJTIwbW9kZWwpKSUwQXByaW50KGVuY29kZV93b3JkKCUyMlRoaXMlMjIlMkMlMjBtb2RlbCkp",highlighted:`<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;Hopefully&quot;</span>, model))
<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;This&quot;</span>, model))`,wrap:!1}}),Rs=new j({props:{code:"KCU1QidIJyUyQyUyMCdvJyUyQyUyMCdwJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCd1JyUyQyUyMCdsbCclMkMlMjAneSclNUQlMkMlMjA0MS41MTU3NDk0NjAxNDAyKSUwQSglNUInVGhpcyclNUQlMkMlMjA2LjI4ODI2NzAzMDY5NDUzNSk=",highlighted:`([<span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;ll&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>], <span class="hljs-number">41.5157494601402</span>)
([<span class="hljs-string">&#x27;This&#x27;</span>], <span class="hljs-number">6.288267030694535</span>)`,wrap:!1}}),Hs=new j({props:{code:"ZGVmJTIwY29tcHV0ZV9sb3NzKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyQyUyMGZyZXElMjBpbiUyMHdvcmRfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lMkMlMjB3b3JkX2xvc3MlMjAlM0QlMjBlbmNvZGVfd29yZCh3b3JkJTJDJTIwbW9kZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUyQiUzRCUyMGZyZXElMjAqJTIwd29yZF9sb3NzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">model</span>):
    loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        _, word_loss = encode_word(word, model)
        loss += freq * word_loss
    <span class="hljs-keyword">return</span> loss`,wrap:!1}}),Ws=new j({props:{code:"Y29tcHV0ZV9sb3NzKG1vZGVsKQ==",highlighted:"compute_loss(model)",wrap:!1}}),Ks=new j({props:{code:"NDEzLjEwMzc3NjQyOTQwODc1",highlighted:'<span class="hljs-number">413.10377642940875</span>',wrap:!1}}),Ds=new j({props:{code:"aW1wb3J0JTIwY29weSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfc2NvcmVzKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2xvc3MlMjAlM0QlMjBjb21wdXRlX2xvc3MobW9kZWwpJTBBJTIwJTIwJTIwJTIwZm9yJTIwdG9rZW4lMkMlMjBzY29yZSUyMGluJTIwbW9kZWwuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdlJTIwYWx3YXlzJTIwa2VlcCUyMHRva2VucyUyMG9mJTIwbGVuZ3RoJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHRva2VuKSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250aW51ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX3dpdGhvdXRfdG9rZW4lMjAlM0QlMjBjb3B5LmRlZXBjb3B5KG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbF93aXRob3V0X3Rva2VuLnBvcCh0b2tlbiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY29yZXMlNUJ0b2tlbiU1RCUyMCUzRCUyMGNvbXB1dGVfbG9zcyhtb2RlbF93aXRob3V0X3Rva2VuKSUyMC0lMjBtb2RlbF9sb3NzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NvcmVz",highlighted:`<span class="hljs-keyword">import</span> copy


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_scores</span>(<span class="hljs-params">model</span>):
    scores = {}
    model_loss = compute_loss(model)
    <span class="hljs-keyword">for</span> token, score <span class="hljs-keyword">in</span> model.items():
        <span class="hljs-comment"># We always keep tokens of length 1</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(token) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        model_without_token = copy.deepcopy(model)
        _ = model_without_token.pop(token)
        scores[token] = compute_loss(model_without_token) - model_loss
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),Ps=new j({props:{code:"c2NvcmVzJTIwJTNEJTIwY29tcHV0ZV9zY29yZXMobW9kZWwpJTBBcHJpbnQoc2NvcmVzJTVCJTIybGwlMjIlNUQpJTBBcHJpbnQoc2NvcmVzJTVCJTIyaGlzJTIyJTVEKQ==",highlighted:`scores = compute_scores(model)
<span class="hljs-built_in">print</span>(scores[<span class="hljs-string">&quot;ll&quot;</span>])
<span class="hljs-built_in">print</span>(scores[<span class="hljs-string">&quot;his&quot;</span>])`,wrap:!1}}),Os=new j({props:{code:"Ni4zNzY0MTI0MDM2MjM4NzQlMEEwLjA=",highlighted:`<span class="hljs-number">6.376412403623874</span>
<span class="hljs-number">0.0</span>`,wrap:!1}}),q=new ut({props:{$$slots:{default:[vn]},$$scope:{ctx:J}}}),tt=new j({props:{code:"cGVyY2VudF90b19yZW1vdmUlMjAlM0QlMjAwLjElMEF3aGlsZSUyMGxlbihtb2RlbCklMjAlM0UlMjAxMDAlM0ElMEElMjAlMjAlMjAlMjBzY29yZXMlMjAlM0QlMjBjb21wdXRlX3Njb3Jlcyhtb2RlbCklMEElMjAlMjAlMjAlMjBzb3J0ZWRfc2NvcmVzJTIwJTNEJTIwc29ydGVkKHNjb3Jlcy5pdGVtcygpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlbW92ZSUyMHBlcmNlbnRfdG9fcmVtb3ZlJTIwdG9rZW5zJTIwd2l0aCUyMHRoZSUyMGxvd2VzdCUyMHNjb3Jlcy4lMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShpbnQobGVuKG1vZGVsKSUyMColMjBwZXJjZW50X3RvX3JlbW92ZSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyUyMCUzRCUyMHRva2VuX2ZyZXFzLnBvcChzb3J0ZWRfc2NvcmVzJTVCaSU1RCU1QjAlNUQpJTBBJTBBJTIwJTIwJTIwJTIwdG90YWxfc3VtJTIwJTNEJTIwc3VtKCU1QmZyZXElMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzLml0ZW1zKCklNUQpJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjAlN0J0b2tlbiUzQSUyMC1sb2coZnJlcSUyMCUyRiUyMHRvdGFsX3N1bSklMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzLml0ZW1zKCklN0Q=",highlighted:`percent_to_remove = <span class="hljs-number">0.1</span>
<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(model) &gt; <span class="hljs-number">100</span>:
    scores = compute_scores(model)
    sorted_scores = <span class="hljs-built_in">sorted</span>(scores.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>])
    <span class="hljs-comment"># Remove percent_to_remove tokens with the lowest scores.</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">int</span>(<span class="hljs-built_in">len</span>(model) * percent_to_remove)):
        _ = token_freqs.pop(sorted_scores[i][<span class="hljs-number">0</span>])

    total_sum = <span class="hljs-built_in">sum</span>([freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()])
    model = {token: -log(freq / total_sum) <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()}`,wrap:!1}}),at=new j({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVkX3RleHQlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZW5jb2RlZF93b3JkcyUyMCUzRCUyMCU1QmVuY29kZV93b3JkKHdvcmQlMkMlMjBtb2RlbCklNUIwJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwcHJlX3Rva2VuaXplZF90ZXh0JTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKGVuY29kZWRfd29yZHMlMkMlMjAlNUIlNUQpJTBBJTBBJTBBdG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UuJTIyJTJDJTIwbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text, model</span>):
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    encoded_words = [encode_word(word, model)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(encoded_words, [])


tokenize(<span class="hljs-string">&quot;This is the Hugging Face course.&quot;</span>, model)`,wrap:!1}}),nt=new j({props:{code:"JTVCJyVFMiU5NiU4MVRoaXMnJTJDJTIwJyVFMiU5NiU4MWlzJyUyQyUyMCclRTIlOTYlODF0aGUnJTJDJTIwJyVFMiU5NiU4MUh1Z2dpbmcnJTJDJTIwJyVFMiU5NiU4MUZhY2UnJTJDJTIwJyVFMiU5NiU4MSclMkMlMjAnYyclMkMlMjAnb3UnJTJDJTIwJ3InJTJDJTIwJ3MnJTJDJTIwJ2UnJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁This&#x27;</span>, <span class="hljs-string">&#x27;▁is&#x27;</span>, <span class="hljs-string">&#x27;▁the&#x27;</span>, <span class="hljs-string">&#x27;▁Hugging&#x27;</span>, <span class="hljs-string">&#x27;▁Face&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),pt=new gn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/7.mdx"}}),{c(){r=p("meta"),U=n(),w=p("p"),d=n(),m(A.$$.fragment),Ut=n(),m(Z.$$.fragment),dt=n(),_=p("p"),_.textContent=ya,Jt=n(),m(N.$$.fragment),bt=n(),m(C.$$.fragment),Tt=n(),m(z.$$.fragment),gt=n(),V=p("p"),V.textContent=ua,ft=n(),Q=p("p"),Q.textContent=wa,Ct=n(),I=p("p"),pa=it("This is all a very costly operation, so we don’t just remove the single symbol associated with the lowest loss increase, but the"),It=new ha(!1),kt=it(" (\\(p\\) being a hyperparameter you can control, usually 10 or 20) percent of the symbols associated with the lowest loss increase. This process is then repeated until the vocabulary has reached the desired size."),vt=n(),B=p("p"),B.textContent=ja,$t=n(),G=p("p"),G.textContent=Ua,qt=n(),S=p("p"),S.textContent=da,xt=n(),m(R.$$.fragment),At=n(),E=p("p"),E.textContent=Ja,Zt=n(),m(H.$$.fragment),_t=n(),m(X.$$.fragment),Nt=n(),W=p("p"),W.textContent=ba,zt=n(),K=p("p"),K.innerHTML=Ta,Vt=n(),Y=p("p"),Y.textContent=ga,Qt=n(),m(D.$$.fragment),Bt=n(),F=p("p"),F.innerHTML=fa,Gt=n(),m(k.$$.fragment),St=n(),b=p("p"),oa=it("Now, to tokenize a given word, we look at all the possible segmentations into tokens and compute the probability of each according to the Unigram model. Since all tokens are considered independent, this probability is just the product of the probability of each token. For instance, the tokenization "),mt=p("code"),mt.textContent=Ca,ia=it(" of "),ct=p("code"),ct.textContent=Ia,ra=it(` has the probability:
`),Rt=new ha(!1),Et=n(),f=p("p"),ma=it("Comparatively, the tokenization "),ht=p("code"),ht.textContent=ka,ca=it(` has the probability:
`),Ht=new ha(!1),Xt=n(),P=p("p"),P.textContent=va,Wt=n(),L=p("p"),L.innerHTML=$a,Kt=n(),m(O.$$.fragment),Yt=n(),ss=p("p"),ss.innerHTML=qa,Dt=n(),ts=p("p"),ts.innerHTML=xa,Ft=n(),es=p("p"),es.textContent=Aa,Pt=n(),as=p("p"),as.innerHTML=Za,Lt=n(),m(ns.$$.fragment),Ot=n(),ls=p("p"),ls.innerHTML=_a,se=n(),m(v.$$.fragment),te=n(),m(ps.$$.fragment),ee=n(),os=p("p"),os.textContent=Na,ae=n(),is=p("p"),is.innerHTML=za,ne=n(),rs=p("p"),rs.textContent=Va,le=n(),m(ms.$$.fragment),pe=n(),cs=p("p"),cs.textContent=Qa,oe=n(),m(hs.$$.fragment),ie=n(),Ms=p("p"),Ms.textContent=Ba,re=n(),m(ys.$$.fragment),me=n(),us=p("p"),us.innerHTML=Ga,ce=n(),ws=p("p"),ws.innerHTML=Sa,he=n(),m(js.$$.fragment),Me=n(),Us=p("p"),Us.textContent=Ra,ye=n(),m(ds.$$.fragment),ue=n(),Js=p("p"),Js.innerHTML=Ea,we=n(),m(bs.$$.fragment),je=n(),Ts=p("p"),Ts.textContent=Ha,Ue=n(),gs=p("p"),gs.textContent=Xa,de=n(),m(fs.$$.fragment),Je=n(),Cs=p("p"),Cs.innerHTML=Wa,be=n(),m(Is.$$.fragment),Te=n(),ks=p("p"),ks.textContent=Ka,ge=n(),m(vs.$$.fragment),fe=n(),$s=p("p"),$s.textContent=Ya,Ce=n(),m(qs.$$.fragment),Ie=n(),m(xs.$$.fragment),ke=n(),As=p("p"),As.textContent=Da,ve=n(),m(Zs.$$.fragment),$e=n(),m($.$$.fragment),qe=n(),_s=p("p"),_s.textContent=Fa,xe=n(),m(Ns.$$.fragment),Ae=n(),zs=p("p"),zs.innerHTML=Pa,Ze=n(),Vs=p("p"),Vs.innerHTML=La,_e=n(),Qs=p("p"),Qs.textContent=Oa,Ne=n(),m(Bs.$$.fragment),ze=n(),Gs=p("p"),Gs.textContent=sn,Ve=n(),m(Ss.$$.fragment),Qe=n(),m(Rs.$$.fragment),Be=n(),Es=p("p"),Es.textContent=tn,Ge=n(),m(Hs.$$.fragment),Se=n(),Xs=p("p"),Xs.textContent=en,Re=n(),m(Ws.$$.fragment),Ee=n(),m(Ks.$$.fragment),He=n(),Ys=p("p"),Ys.textContent=an,Xe=n(),m(Ds.$$.fragment),We=n(),Fs=p("p"),Fs.textContent=nn,Ke=n(),m(Ps.$$.fragment),Ye=n(),Ls=p("p"),Ls.innerHTML=ln,De=n(),m(Os.$$.fragment),Fe=n(),m(q.$$.fragment),Pe=n(),st=p("p"),st.textContent=pn,Le=n(),m(tt.$$.fragment),Oe=n(),et=p("p"),et.innerHTML=on,sa=n(),m(at.$$.fragment),ta=n(),m(nt.$$.fragment),ea=n(),lt=p("p"),lt.textContent=rn,aa=n(),m(pt.$$.fragment),na=n(),Mt=p("p"),this.h()},l(s){const t=Jn("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(e),U=l(s),w=o(s,"P",{}),yt(w).forEach(e),d=l(s),c(A.$$.fragment,s),Ut=l(s),c(Z.$$.fragment,s),dt=l(s),_=o(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1ogtfl7"&&(_.textContent=ya),Jt=l(s),c(N.$$.fragment,s),bt=l(s),c(C.$$.fragment,s),Tt=l(s),c(z.$$.fragment,s),gt=l(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-16vv0fb"&&(V.textContent=ua),ft=l(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1yvt99t"&&(Q.textContent=wa),Ct=l(s),I=o(s,"P",{});var ot=yt(I);pa=rt(ot,"This is all a very costly operation, so we don’t just remove the single symbol associated with the lowest loss increase, but the"),It=Ma(ot,!1),kt=rt(ot," (\\(p\\) being a hyperparameter you can control, usually 10 or 20) percent of the symbols associated with the lowest loss increase. This process is then repeated until the vocabulary has reached the desired size."),ot.forEach(e),vt=l(s),B=o(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1bd68el"&&(B.textContent=ja),$t=l(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-18sgwt4"&&(G.textContent=Ua),qt=l(s),S=o(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1rnxwlp"&&(S.textContent=da),xt=l(s),c(R.$$.fragment,s),At=l(s),E=o(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1sp8vuv"&&(E.textContent=Ja),Zt=l(s),c(H.$$.fragment,s),_t=l(s),c(X.$$.fragment,s),Nt=l(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-17i13c1"&&(W.textContent=ba),zt=l(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1ywxof8"&&(K.innerHTML=Ta),Vt=l(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1im6u9i"&&(Y.textContent=ga),Qt=l(s),c(D.$$.fragment,s),Bt=l(s),F=o(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-16cln8v"&&(F.innerHTML=fa),Gt=l(s),c(k.$$.fragment,s),St=l(s),b=o(s,"P",{});var g=yt(b);oa=rt(g,"Now, to tokenize a given word, we look at all the possible segmentations into tokens and compute the probability of each according to the Unigram model. Since all tokens are considered independent, this probability is just the product of the probability of each token. For instance, the tokenization "),mt=o(g,"CODE",{"data-svelte-h":!0}),i(mt)!=="svelte-1n2m4po"&&(mt.textContent=Ca),ia=rt(g," of "),ct=o(g,"CODE",{"data-svelte-h":!0}),i(ct)!=="svelte-1gjdq76"&&(ct.textContent=Ia),ra=rt(g,` has the probability:
`),Rt=Ma(g,!1),g.forEach(e),Et=l(s),f=o(s,"P",{});var x=yt(f);ma=rt(x,"Comparatively, the tokenization "),ht=o(x,"CODE",{"data-svelte-h":!0}),i(ht)!=="svelte-42m5r0"&&(ht.textContent=ka),ca=rt(x,` has the probability:
`),Ht=Ma(x,!1),x.forEach(e),Xt=l(s),P=o(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-g2doa3"&&(P.textContent=va),Wt=l(s),L=o(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-9ovu4k"&&(L.innerHTML=$a),Kt=l(s),c(O.$$.fragment,s),Yt=l(s),ss=o(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-by7atq"&&(ss.innerHTML=qa),Dt=l(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1re84pi"&&(ts.innerHTML=xa),Ft=l(s),es=o(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-4w9cp8"&&(es.textContent=Aa),Pt=l(s),as=o(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1v3e60i"&&(as.innerHTML=Za),Lt=l(s),c(ns.$$.fragment,s),Ot=l(s),ls=o(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-17ww2xx"&&(ls.innerHTML=_a),se=l(s),c(v.$$.fragment,s),te=l(s),c(ps.$$.fragment,s),ee=l(s),os=o(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1mxwvxi"&&(os.textContent=Na),ae=l(s),is=o(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-r1ko6w"&&(is.innerHTML=za),ne=l(s),rs=o(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1y2guu9"&&(rs.textContent=Va),le=l(s),c(ms.$$.fragment,s),pe=l(s),cs=o(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-smnwx3"&&(cs.textContent=Qa),oe=l(s),c(hs.$$.fragment,s),ie=l(s),Ms=o(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-14jcfwu"&&(Ms.textContent=Ba),re=l(s),c(ys.$$.fragment,s),me=l(s),us=o(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-1rsqmv"&&(us.innerHTML=Ga),ce=l(s),ws=o(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-1e3tr4j"&&(ws.innerHTML=Sa),he=l(s),c(js.$$.fragment,s),Me=l(s),Us=o(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-15gzb9u"&&(Us.textContent=Ra),ye=l(s),c(ds.$$.fragment,s),ue=l(s),Js=o(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-1gwabz2"&&(Js.innerHTML=Ea),we=l(s),c(bs.$$.fragment,s),je=l(s),Ts=o(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1p0q4mo"&&(Ts.textContent=Ha),Ue=l(s),gs=o(s,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-160kau6"&&(gs.textContent=Xa),de=l(s),c(fs.$$.fragment,s),Je=l(s),Cs=o(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-5hfan0"&&(Cs.innerHTML=Wa),be=l(s),c(Is.$$.fragment,s),Te=l(s),ks=o(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-1p0ikvu"&&(ks.textContent=Ka),ge=l(s),c(vs.$$.fragment,s),fe=l(s),$s=o(s,"P",{"data-svelte-h":!0}),i($s)!=="svelte-1njxouy"&&($s.textContent=Ya),Ce=l(s),c(qs.$$.fragment,s),Ie=l(s),c(xs.$$.fragment,s),ke=l(s),As=o(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-1rbeurr"&&(As.textContent=Da),ve=l(s),c(Zs.$$.fragment,s),$e=l(s),c($.$$.fragment,s),qe=l(s),_s=o(s,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-kpz2jw"&&(_s.textContent=Fa),xe=l(s),c(Ns.$$.fragment,s),Ae=l(s),zs=o(s,"P",{"data-svelte-h":!0}),i(zs)!=="svelte-1vp6twv"&&(zs.innerHTML=Pa),Ze=l(s),Vs=o(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-8o0mkc"&&(Vs.innerHTML=La),_e=l(s),Qs=o(s,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-76z975"&&(Qs.textContent=Oa),Ne=l(s),c(Bs.$$.fragment,s),ze=l(s),Gs=o(s,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-1riuhoo"&&(Gs.textContent=sn),Ve=l(s),c(Ss.$$.fragment,s),Qe=l(s),c(Rs.$$.fragment,s),Be=l(s),Es=o(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-ncpc2j"&&(Es.textContent=tn),Ge=l(s),c(Hs.$$.fragment,s),Se=l(s),Xs=o(s,"P",{"data-svelte-h":!0}),i(Xs)!=="svelte-p7t1po"&&(Xs.textContent=en),Re=l(s),c(Ws.$$.fragment,s),Ee=l(s),c(Ks.$$.fragment,s),He=l(s),Ys=o(s,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-emtee"&&(Ys.textContent=an),Xe=l(s),c(Ds.$$.fragment,s),We=l(s),Fs=o(s,"P",{"data-svelte-h":!0}),i(Fs)!=="svelte-qxfbyo"&&(Fs.textContent=nn),Ke=l(s),c(Ps.$$.fragment,s),Ye=l(s),Ls=o(s,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-zu2ggv"&&(Ls.innerHTML=ln),De=l(s),c(Os.$$.fragment,s),Fe=l(s),c(q.$$.fragment,s),Pe=l(s),st=o(s,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1vz3e3j"&&(st.textContent=pn),Le=l(s),c(tt.$$.fragment,s),Oe=l(s),et=o(s,"P",{"data-svelte-h":!0}),i(et)!=="svelte-m3sdwl"&&(et.innerHTML=on),sa=l(s),c(at.$$.fragment,s),ta=l(s),c(nt.$$.fragment,s),ea=l(s),lt=o(s,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-1hk3m3g"&&(lt.textContent=rn),aa=l(s),c(pt.$$.fragment,s),na=l(s),Mt=o(s,"P",{}),yt(Mt).forEach(e),this.h()},h(){hn(r,"name","hf:doc:metadata"),hn(r,"content",qn),It.a=kt,Rt.a=null,Ht.a=null},m(s,t){T(document.head,r),a(s,U,t),a(s,w,t),a(s,d,t),h(A,s,t),a(s,Ut,t),h(Z,s,t),a(s,dt,t),a(s,_,t),a(s,Jt,t),h(N,s,t),a(s,bt,t),h(C,s,t),a(s,Tt,t),h(z,s,t),a(s,gt,t),a(s,V,t),a(s,ft,t),a(s,Q,t),a(s,Ct,t),a(s,I,t),T(I,pa),It.m(Mn,I),T(I,kt),a(s,vt,t),a(s,B,t),a(s,$t,t),a(s,G,t),a(s,qt,t),a(s,S,t),a(s,xt,t),h(R,s,t),a(s,At,t),a(s,E,t),a(s,Zt,t),h(H,s,t),a(s,_t,t),h(X,s,t),a(s,Nt,t),a(s,W,t),a(s,zt,t),a(s,K,t),a(s,Vt,t),a(s,Y,t),a(s,Qt,t),h(D,s,t),a(s,Bt,t),a(s,F,t),a(s,Gt,t),h(k,s,t),a(s,St,t),a(s,b,t),T(b,oa),T(b,mt),T(b,ia),T(b,ct),T(b,ra),Rt.m(yn,b),a(s,Et,t),a(s,f,t),T(f,ma),T(f,ht),T(f,ca),Ht.m(un,f),a(s,Xt,t),a(s,P,t),a(s,Wt,t),a(s,L,t),a(s,Kt,t),h(O,s,t),a(s,Yt,t),a(s,ss,t),a(s,Dt,t),a(s,ts,t),a(s,Ft,t),a(s,es,t),a(s,Pt,t),a(s,as,t),a(s,Lt,t),h(ns,s,t),a(s,Ot,t),a(s,ls,t),a(s,se,t),h(v,s,t),a(s,te,t),h(ps,s,t),a(s,ee,t),a(s,os,t),a(s,ae,t),a(s,is,t),a(s,ne,t),a(s,rs,t),a(s,le,t),h(ms,s,t),a(s,pe,t),a(s,cs,t),a(s,oe,t),h(hs,s,t),a(s,ie,t),a(s,Ms,t),a(s,re,t),h(ys,s,t),a(s,me,t),a(s,us,t),a(s,ce,t),a(s,ws,t),a(s,he,t),h(js,s,t),a(s,Me,t),a(s,Us,t),a(s,ye,t),h(ds,s,t),a(s,ue,t),a(s,Js,t),a(s,we,t),h(bs,s,t),a(s,je,t),a(s,Ts,t),a(s,Ue,t),a(s,gs,t),a(s,de,t),h(fs,s,t),a(s,Je,t),a(s,Cs,t),a(s,be,t),h(Is,s,t),a(s,Te,t),a(s,ks,t),a(s,ge,t),h(vs,s,t),a(s,fe,t),a(s,$s,t),a(s,Ce,t),h(qs,s,t),a(s,Ie,t),h(xs,s,t),a(s,ke,t),a(s,As,t),a(s,ve,t),h(Zs,s,t),a(s,$e,t),h($,s,t),a(s,qe,t),a(s,_s,t),a(s,xe,t),h(Ns,s,t),a(s,Ae,t),a(s,zs,t),a(s,Ze,t),a(s,Vs,t),a(s,_e,t),a(s,Qs,t),a(s,Ne,t),h(Bs,s,t),a(s,ze,t),a(s,Gs,t),a(s,Ve,t),h(Ss,s,t),a(s,Qe,t),h(Rs,s,t),a(s,Be,t),a(s,Es,t),a(s,Ge,t),h(Hs,s,t),a(s,Se,t),a(s,Xs,t),a(s,Re,t),h(Ws,s,t),a(s,Ee,t),h(Ks,s,t),a(s,He,t),a(s,Ys,t),a(s,Xe,t),h(Ds,s,t),a(s,We,t),a(s,Fs,t),a(s,Ke,t),h(Ps,s,t),a(s,Ye,t),a(s,Ls,t),a(s,De,t),h(Os,s,t),a(s,Fe,t),h(q,s,t),a(s,Pe,t),a(s,st,t),a(s,Le,t),h(tt,s,t),a(s,Oe,t),a(s,et,t),a(s,sa,t),h(at,s,t),a(s,ta,t),h(nt,s,t),a(s,ea,t),a(s,lt,t),a(s,aa,t),h(pt,s,t),a(s,na,t),a(s,Mt,t),la=!0},p(s,[t]){const ot={};t&2&&(ot.$$scope={dirty:t,ctx:s}),C.$set(ot);const g={};t&2&&(g.$$scope={dirty:t,ctx:s}),k.$set(g);const x={};t&2&&(x.$$scope={dirty:t,ctx:s}),v.$set(x);const mn={};t&2&&(mn.$$scope={dirty:t,ctx:s}),$.$set(mn);const cn={};t&2&&(cn.$$scope={dirty:t,ctx:s}),q.$set(cn)},i(s){la||(M(A.$$.fragment,s),M(Z.$$.fragment,s),M(N.$$.fragment,s),M(C.$$.fragment,s),M(z.$$.fragment,s),M(R.$$.fragment,s),M(H.$$.fragment,s),M(X.$$.fragment,s),M(D.$$.fragment,s),M(k.$$.fragment,s),M(O.$$.fragment,s),M(ns.$$.fragment,s),M(v.$$.fragment,s),M(ps.$$.fragment,s),M(ms.$$.fragment,s),M(hs.$$.fragment,s),M(ys.$$.fragment,s),M(js.$$.fragment,s),M(ds.$$.fragment,s),M(bs.$$.fragment,s),M(fs.$$.fragment,s),M(Is.$$.fragment,s),M(vs.$$.fragment,s),M(qs.$$.fragment,s),M(xs.$$.fragment,s),M(Zs.$$.fragment,s),M($.$$.fragment,s),M(Ns.$$.fragment,s),M(Bs.$$.fragment,s),M(Ss.$$.fragment,s),M(Rs.$$.fragment,s),M(Hs.$$.fragment,s),M(Ws.$$.fragment,s),M(Ks.$$.fragment,s),M(Ds.$$.fragment,s),M(Ps.$$.fragment,s),M(Os.$$.fragment,s),M(q.$$.fragment,s),M(tt.$$.fragment,s),M(at.$$.fragment,s),M(nt.$$.fragment,s),M(pt.$$.fragment,s),la=!0)},o(s){y(A.$$.fragment,s),y(Z.$$.fragment,s),y(N.$$.fragment,s),y(C.$$.fragment,s),y(z.$$.fragment,s),y(R.$$.fragment,s),y(H.$$.fragment,s),y(X.$$.fragment,s),y(D.$$.fragment,s),y(k.$$.fragment,s),y(O.$$.fragment,s),y(ns.$$.fragment,s),y(v.$$.fragment,s),y(ps.$$.fragment,s),y(ms.$$.fragment,s),y(hs.$$.fragment,s),y(ys.$$.fragment,s),y(js.$$.fragment,s),y(ds.$$.fragment,s),y(bs.$$.fragment,s),y(fs.$$.fragment,s),y(Is.$$.fragment,s),y(vs.$$.fragment,s),y(qs.$$.fragment,s),y(xs.$$.fragment,s),y(Zs.$$.fragment,s),y($.$$.fragment,s),y(Ns.$$.fragment,s),y(Bs.$$.fragment,s),y(Ss.$$.fragment,s),y(Rs.$$.fragment,s),y(Hs.$$.fragment,s),y(Ws.$$.fragment,s),y(Ks.$$.fragment,s),y(Ds.$$.fragment,s),y(Ps.$$.fragment,s),y(Os.$$.fragment,s),y(q.$$.fragment,s),y(tt.$$.fragment,s),y(at.$$.fragment,s),y(nt.$$.fragment,s),y(pt.$$.fragment,s),la=!1},d(s){s&&(e(U),e(w),e(d),e(Ut),e(dt),e(_),e(Jt),e(bt),e(Tt),e(gt),e(V),e(ft),e(Q),e(Ct),e(I),e(vt),e(B),e($t),e(G),e(qt),e(S),e(xt),e(At),e(E),e(Zt),e(_t),e(Nt),e(W),e(zt),e(K),e(Vt),e(Y),e(Qt),e(Bt),e(F),e(Gt),e(St),e(b),e(Et),e(f),e(Xt),e(P),e(Wt),e(L),e(Kt),e(Yt),e(ss),e(Dt),e(ts),e(Ft),e(es),e(Pt),e(as),e(Lt),e(Ot),e(ls),e(se),e(te),e(ee),e(os),e(ae),e(is),e(ne),e(rs),e(le),e(pe),e(cs),e(oe),e(ie),e(Ms),e(re),e(me),e(us),e(ce),e(ws),e(he),e(Me),e(Us),e(ye),e(ue),e(Js),e(we),e(je),e(Ts),e(Ue),e(gs),e(de),e(Je),e(Cs),e(be),e(Te),e(ks),e(ge),e(fe),e($s),e(Ce),e(Ie),e(ke),e(As),e(ve),e($e),e(qe),e(_s),e(xe),e(Ae),e(zs),e(Ze),e(Vs),e(_e),e(Qs),e(Ne),e(ze),e(Gs),e(Ve),e(Qe),e(Be),e(Es),e(Ge),e(Se),e(Xs),e(Re),e(Ee),e(He),e(Ys),e(Xe),e(We),e(Fs),e(Ke),e(Ye),e(Ls),e(De),e(Fe),e(Pe),e(st),e(Le),e(Oe),e(et),e(sa),e(ta),e(ea),e(lt),e(aa),e(na),e(Mt)),e(r),u(A,s),u(Z,s),u(N,s),u(C,s),u(z,s),u(R,s),u(H,s),u(X,s),u(D,s),u(k,s),u(O,s),u(ns,s),u(v,s),u(ps,s),u(ms,s),u(hs,s),u(ys,s),u(js,s),u(ds,s),u(bs,s),u(fs,s),u(Is,s),u(vs,s),u(qs,s),u(xs,s),u(Zs,s),u($,s),u(Ns,s),u(Bs,s),u(Ss,s),u(Rs,s),u(Hs,s),u(Ws,s),u(Ks,s),u(Ds,s),u(Ps,s),u(Os,s),u(q,s),u(tt,s),u(at,s),u(nt,s),u(pt,s)}}}const qn='{"title":"Unigram tokenization","local":"unigram-tokenization","sections":[{"title":"Training algorithm","local":"training-algorithm","sections":[],"depth":2},{"title":"Tokenization algorithm","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Back to training","local":"back-to-training","sections":[],"depth":2},{"title":"Implementing Unigram","local":"implementing-unigram","sections":[],"depth":2}],"depth":1}';function xn(J){return jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bn extends Un{constructor(r){super(),dn(this,r,xn,$n,wn,{})}}export{Bn as component};
