import{s as Ue,f as Te,n as Je,o as ge}from"../chunks/scheduler.f7e1785c.js";import{S as be,i as Ce,g as o,s,r as _,A as Ie,h as i,f as l,c as n,j as ne,u as k,x as r,k as c,y as Ae,a,v as B,d as G,t as x,w as E}from"../chunks/index.9f8f0838.js";import{C as se}from"../chunks/CodeBlock.b3510e34.js";import{H as ve}from"../chunks/Heading.6643a2f7.js";function We(oe){let u,$,W,H,M,S,d,ie=`Now that we’ve fine-tuned a Whisper model for Dhivehi speech recognition, let’s go ahead and build a <a href="https://gradio.app" rel="nofollow">Gradio</a>
demo to showcase it to the community!`,Y,m,pe=`The first thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from
the section on <a href="asr_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned
model on the Hugging Face Hub, or one of the pre-trained <a href="https://huggingface.co/models?sort=downloads&amp;search=openai%2Fwhisper-" rel="nofollow">Whisper models</a>
to perform zero-shot speech recognition:`,V,h,Q,y,re=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We can then simply return the transcribed text as the output of the function. To ensure our
model can handle audio inputs of arbitrary length, we’ll enable <em>chunking</em> as described in the section
on <a href="asr_models">pre-trained models</a>:`,R,w,N,f,ue=`We’ll use the Gradio <a href="https://gradio.app/docs/#blocks" rel="nofollow">blocks</a> feature to launch two tabs on our demo: one for microphone
transcription, and the other for file upload.`,z,j,q,U,ce="Finally, we launch the Gradio demo using the two blocks that we’ve just defined:",X,T,F,J,Me="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",P,p,de,L,g,me="Should you wish to host your demo on the Hugging Face Hub, you can use this Space as a template for your fine-tuned model.",K,b,he='Click the link to duplicate the template demo to your account: <a href="https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true" rel="nofollow">https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true</a>',D,C,ye="We recommend giving your space a similar name to your fine-tuned model (e.g. whisper-small-dv-demo) and setting the visibility to “Public”.",O,I,we=`Once you’ve duplicated the Space to your account, click “Files and versions” -> “app.py” -> “edit”. Then change the
model identifier to your fine-tuned model (line 6). Scroll to the bottom of the page and click “Commit changes to main”.
The demo will reboot, this time using your fine-tuned model. You can share this demo with your friends and family so that
they can use the model that you’ve trained!`,ee,A,fe='Checkout our video tutorial to get a better understanding of how to duplicate the Space 👉️ <a href="https://www.youtube.com/watch?v=VQYuvl6-9VE" rel="nofollow">YouTube Video</a>',te,v,je="We look forward to seeing your demos on the Hub!",le,Z,ae;return M=new ve({props:{title:"Build a demo with Gradio",local:"build-a-demo-with-gradio",headingTag:"h1"}}),h=new se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItc21hbGwtZHYlMjIlMjAlMjAlMjMlMjB1cGRhdGUlMjB3aXRoJTIweW91ciUyMG1vZGVsJTIwaWQlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>  <span class="hljs-comment"># update with your model id</span>
pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model_id)`,wrap:!1}}),w=new se({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9zcGVlY2goZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zY3JpYmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMnNpbmhhbGVzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUyMCUyMyUyMHVwZGF0ZSUyMHdpdGglMjB0aGUlMjBsYW5ndWFnZSUyMHlvdSd2ZSUyMGZpbmUtdHVuZWQlMjBvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_speech</span>(<span class="hljs-params">filepath</span>):
    output = pipe(
        filepath,
        max_new_tokens=<span class="hljs-number">256</span>,
        generate_kwargs={
            <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>,
            <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;sinhalese&quot;</span>,
        },  <span class="hljs-comment"># update with the language you&#x27;ve fine-tuned on</span>
        chunk_length_s=<span class="hljs-number">30</span>,
        batch_size=<span class="hljs-number">8</span>,
    )
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),j=new se({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2VzJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3Iub3V0cHV0cy5UZXh0Ym94KCklMkMlMEEpJTBBJTBBZmlsZV90cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2VzJTNEJTIydXBsb2FkJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5vdXRwdXRzLlRleHRib3goKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(sources=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.outputs.Textbox(),
)

file_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(sources=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.outputs.Textbox(),
)`,wrap:!1}}),T=new se({props:{code:"d2l0aCUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjBnci5UYWJiZWRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCbWljX3RyYW5zY3JpYmUlMkMlMjBmaWxlX3RyYW5zY3JpYmUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjJUcmFuc2NyaWJlJTIwTWljcm9waG9uZSUyMiUyQyUyMCUyMlRyYW5zY3JpYmUlMjBBdWRpbyUyMEZpbGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface(
        [mic_transcribe, file_transcribe],
        [<span class="hljs-string">&quot;Transcribe Microphone&quot;</span>, <span class="hljs-string">&quot;Transcribe Audio File&quot;</span>],
    )

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){u=o("meta"),$=s(),W=o("p"),H=s(),_(M.$$.fragment),S=s(),d=o("p"),d.innerHTML=ie,Y=s(),m=o("p"),m.innerHTML=pe,V=s(),_(h.$$.fragment),Q=s(),y=o("p"),y.innerHTML=re,R=s(),_(w.$$.fragment),N=s(),f=o("p"),f.innerHTML=ue,z=s(),_(j.$$.fragment),q=s(),U=o("p"),U.textContent=ce,X=s(),_(T.$$.fragment),F=s(),J=o("p"),J.textContent=Me,P=s(),p=o("iframe"),L=s(),g=o("p"),g.textContent=me,K=s(),b=o("p"),b.innerHTML=he,D=s(),C=o("p"),C.textContent=ye,O=s(),I=o("p"),I.textContent=we,ee=s(),A=o("p"),A.innerHTML=fe,te=s(),v=o("p"),v.textContent=je,le=s(),Z=o("p"),this.h()},l(e){const t=Ie("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),$=n(e),W=i(e,"P",{}),ne(W).forEach(l),H=n(e),k(M.$$.fragment,e),S=n(e),d=i(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1q95dto"&&(d.innerHTML=ie),Y=n(e),m=i(e,"P",{"data-svelte-h":!0}),r(m)!=="svelte-ldnoqw"&&(m.innerHTML=pe),V=n(e),k(h.$$.fragment,e),Q=n(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-g873e4"&&(y.innerHTML=re),R=n(e),k(w.$$.fragment,e),N=n(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-wlltyj"&&(f.innerHTML=ue),z=n(e),k(j.$$.fragment,e),q=n(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1s2jh73"&&(U.textContent=ce),X=n(e),k(T.$$.fragment,e),F=n(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-10sf4ix"&&(J.textContent=Me),P=n(e),p=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ne(p).forEach(l),L=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ojipak"&&(g.textContent=me),K=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1uiun01"&&(b.innerHTML=he),D=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1oyez0p"&&(C.textContent=ye),O=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-7essz6"&&(I.textContent=we),ee=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-9wesld"&&(A.innerHTML=fe),te=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1v4hd0t"&&(v.textContent=je),le=n(e),Z=i(e,"P",{}),ne(Z).forEach(l),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",Ze),Te(p.src,de="https://course-demos-whisper-small.hf.space")||c(p,"src",de),c(p,"frameborder","0"),c(p,"height","450"),c(p,"title","Gradio app"),c(p,"class","container p-0 flex-grow space-iframe"),c(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),c(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Ae(document.head,u),a(e,$,t),a(e,W,t),a(e,H,t),B(M,e,t),a(e,S,t),a(e,d,t),a(e,Y,t),a(e,m,t),a(e,V,t),B(h,e,t),a(e,Q,t),a(e,y,t),a(e,R,t),B(w,e,t),a(e,N,t),a(e,f,t),a(e,z,t),B(j,e,t),a(e,q,t),a(e,U,t),a(e,X,t),B(T,e,t),a(e,F,t),a(e,J,t),a(e,P,t),a(e,p,t),a(e,L,t),a(e,g,t),a(e,K,t),a(e,b,t),a(e,D,t),a(e,C,t),a(e,O,t),a(e,I,t),a(e,ee,t),a(e,A,t),a(e,te,t),a(e,v,t),a(e,le,t),a(e,Z,t),ae=!0},p:Je,i(e){ae||(G(M.$$.fragment,e),G(h.$$.fragment,e),G(w.$$.fragment,e),G(j.$$.fragment,e),G(T.$$.fragment,e),ae=!0)},o(e){x(M.$$.fragment,e),x(h.$$.fragment,e),x(w.$$.fragment,e),x(j.$$.fragment,e),x(T.$$.fragment,e),ae=!1},d(e){e&&(l($),l(W),l(H),l(S),l(d),l(Y),l(m),l(V),l(Q),l(y),l(R),l(N),l(f),l(z),l(q),l(U),l(X),l(F),l(J),l(P),l(p),l(L),l(g),l(K),l(b),l(D),l(C),l(O),l(I),l(ee),l(A),l(te),l(v),l(le),l(Z)),l(u),E(M,e),E(h,e),E(w,e),E(j,e),E(T,e)}}}const Ze='{"title":"Build a demo with Gradio","local":"build-a-demo-with-gradio","sections":[],"depth":1}';function _e(oe){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends be{constructor(u){super(),Ce(this,u,_e,We,Ue,{})}}export{Ee as component};
