import{s as Cs,n as As,o as Hs}from"../chunks/scheduler.b108d059.js";import{S as Ls,i as Ms,g as o,s as r,r as m,A as ws,h as i,f as l,c as a,j as n,u as f,x as s,k as u,y as gs,a as d,v as p,d as h,t as c,w as T}from"../chunks/index.008de539.js";import{H as y,E as Es}from"../chunks/EditOnGithub.d1c48e3d.js";function Rs(ko){let v,bl,_l,xl,_,$l,F,Pl,b,Ko="Helper module for mathematical processing.",Cl,x,Oo=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Al,$,Bo='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.permute_data"><code>.permute_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.bankers_round"><code>.bankers_round(x)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',Hl,Ll,Ml,P,wl,C,gl,A,Do='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',El,H,jo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Rl,zl,kl,L,Kl,M,Ol,w,Io="Helper method to permute a <code>AnyTypedArray</code> directly",Bl,g,Uo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The permuted array and the new shape.',Dl,E,qo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",jl,Il,Ul,R,ql,z,Sl,k,So="Compute the softmax of an array of numbers.",Nl,K,No='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Gl,O,Go="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",Jl,Ql,Vl,B,Wl,D,Xl,j,Jo="Calculates the logarithm of the softmax function for the input array.",Yl,I,Qo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',Zl,U,Vo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",td,ed,ld,q,dd,S,rd,N,Wo="Calculates the dot product of two arrays.",ad,G,Xo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',od,J,Yo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",id,sd,ud,Q,nd,V,md,W,Zo="Get the top k items from an iterable, sorted by descending order",fd,X,ti='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The top k items, sorted by descending order',pd,Y,ei="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array&lt;any&gt;</code> | <code>TypedArray</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code> | <code>null</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",hd,cd,Td,Z,yd,tt,vd,et,li="Computes the cosine similarity between two arrays.",_d,lt,di='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',Fd,dt,ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",bd,xd,$d,rt,Pd,at,Cd,ot,ai="Calculates the magnitude of a given array.",Ad,it,oi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',Hd,st,ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",Ld,Md,wd,ut,gd,nt,Ed,mt,si="Returns the value and index of the minimum element in an array.",Rd,ft,ui='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',zd,pt,ni="<li><code>Error</code> If array is empty.</li>",kd,ht,mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Kd,Od,Bd,ct,Dd,Tt,jd,yt,fi="Returns the value and index of the maximum element in an array.",Id,vt,pi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',Ud,_t,hi="<li><code>Error</code> If array is empty.</li>",qd,Ft,ci="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Sd,Nd,Gd,bt,Jd,xt,Qd,$t,Ti="Performs median filter on the provided data. Padding is done by mirroring the data.",Vd,Pt,yi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Wd,Ct,vi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Xd,Yd,Zd,At,tr,Ht,er,Lt,_i="Helper function to round a number to a given number of decimals",lr,Mt,Fi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',dr,wt,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",rr,ar,or,gt,ir,Et,sr,Rt,xi=`Helper function to round a number to the nearest integer, with ties rounded to the nearest even number.
Also known as “bankers’ rounding”. This is the default rounding mode in python. For example:
1.5 rounds to 2 and 2.5 rounds to 2.`,ur,zt,$i='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',nr,kt,Pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>number</code></td><td><p>The number to round</p></td></tr></tbody>",mr,fr,pr,Kt,hr,Ot,cr,Bt,Ci="Implementation of Radix-4 FFT.",Tr,Dt,Ai=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,yr,jt,Hi='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',vr,It,Li='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',_r,Fr,br,Ut,xr,qt,$r,St,Mi="<strong>Throws</strong>:",Pr,Nt,wi="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",Cr,Gt,gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",Ar,Hr,Lr,Jt,Mr,Qt,wr,Vt,Ei="Create a complex number array with size <code>2 * size</code>",gr,Wt,Ri='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',Er,Rr,zr,Xt,kr,Yt,Kr,Zt,zi="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Or,te,ki='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Br,ee,Ki="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",Dr,jr,Ir,le,Ur,de,qr,re,Oi="Convert a real-valued input array to a complex-valued output array.",Sr,ae,Bi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Nr,oe,Di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Gr,Jr,Qr,ie,Vr,se,Wr,ue,ji="Completes the spectrum by adding its mirrored negative frequency components.",Xr,ne,Ii='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Yr,me,Ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>spectrum</td><td><code>Float64Array</code></td><td><p>The input spectrum.</p></td></tr></tbody>",Zr,ta,ea,fe,la,pe,da,he,qi="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",ra,ce,Si='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',aa,Te,Ni="<li><code>Error</code> Input and output buffers must be different.</li>",oa,ye,Gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",ia,sa,ua,ve,na,_e,ma,Fe,Ji=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,fa,be,Qi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',pa,xe,Vi="<li><code>Error</code> If the input and output buffers are the same.</li>",ha,$e,Wi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",ca,Ta,ya,Pe,va,Ce,_a,Ae,Xi=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,Fa,He,Yi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ba,Le,Zi="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",xa,Me,ts="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",$a,Pa,Ca,we,Aa,ge,Ha,Ee,es="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",La,Re,ls='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ma,ze,ds="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",wa,ga,Ea,ke,Ra,Ke,za,Oe,rs="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",ka,Be,as='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ka,De,os="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Oa,Ba,Da,je,ja,Ie,Ia,Ue,is="Performs radix-4 transformation on input data of length 8",Ua,qe,ss='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',qa,Se,us="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",Sa,Na,Ga,Ne,Ja,Ge,Qa,Je,ns="Real input radix-4 implementation",Va,Qe,ms='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Wa,Ve,fs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Xa,Ya,Za,We,to,Xe,eo,Ye,ps="Performs a single real input radix-2 transformation on the provided data",lo,Ze,hs='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',ro,tl,cs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",ao,oo,io,el,so,ll,uo,dl,Ts=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,no,rl,ys='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',mo,al,vs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",fo,po,ho,ol,co,il,To,sl,_s=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,yo,ul,Fs='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',vo,nl,bs='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',_o,Fo,bo,ml,xo,fl,$o,pl,xs="Constructs a new NP2FFT object.",Po,hl,$s="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",Co,Ao,Ho,cl,Lo,Tl,Mo,yl,Ps='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',wo,go,Eo,vl,Ro,Fl,zo;return F=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),C=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathspermutedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),D=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),S=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>",local:"utilsmathsgettopitemsitems-topk--code--code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),at=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),nt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Tt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),xt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths.bankers_round(x) ⇒ <code> number </code>",local:"utilsmathsbankersroundx--code-number-code",headingTag:"h2"}}),Ot=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),qt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),Qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),de=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>",local:"p2fftcompletespectrumspectrum--code-void-code",headingTag:"h3"}}),pe=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),_e=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ie=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),ll=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),il=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),fl=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),Tl=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),vl=new Es({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/maths.md"}}),{c(){v=o("meta"),bl=r(),_l=o("p"),xl=r(),_=o("a"),$l=r(),m(F.$$.fragment),Pl=r(),b=o("p"),b.textContent=Ko,Cl=r(),x=o("p"),x.textContent=Oo,Al=r(),$=o("ul"),$.innerHTML=Bo,Hl=r(),Ll=o("hr"),Ml=r(),P=o("a"),wl=r(),m(C.$$.fragment),gl=r(),A=o("p"),A.innerHTML=Do,El=r(),H=o("table"),H.innerHTML=jo,Rl=r(),zl=o("hr"),kl=r(),L=o("a"),Kl=r(),m(M.$$.fragment),Ol=r(),w=o("p"),w.innerHTML=Io,Bl=r(),g=o("p"),g.innerHTML=Uo,Dl=r(),E=o("table"),E.innerHTML=qo,jl=r(),Il=o("hr"),Ul=r(),R=o("a"),ql=r(),m(z.$$.fragment),Sl=r(),k=o("p"),k.textContent=So,Nl=r(),K=o("p"),K.innerHTML=No,Gl=r(),O=o("table"),O.innerHTML=Go,Jl=r(),Ql=o("hr"),Vl=r(),B=o("a"),Wl=r(),m(D.$$.fragment),Xl=r(),j=o("p"),j.textContent=Jo,Yl=r(),I=o("p"),I.innerHTML=Qo,Zl=r(),U=o("table"),U.innerHTML=Vo,td=r(),ed=o("hr"),ld=r(),q=o("a"),dd=r(),m(S.$$.fragment),rd=r(),N=o("p"),N.textContent=Wo,ad=r(),G=o("p"),G.innerHTML=Xo,od=r(),J=o("table"),J.innerHTML=Yo,id=r(),sd=o("hr"),ud=r(),Q=o("a"),nd=r(),m(V.$$.fragment),md=r(),W=o("p"),W.textContent=Zo,fd=r(),X=o("p"),X.innerHTML=ti,pd=r(),Y=o("table"),Y.innerHTML=ei,hd=r(),cd=o("hr"),Td=r(),Z=o("a"),yd=r(),m(tt.$$.fragment),vd=r(),et=o("p"),et.textContent=li,_d=r(),lt=o("p"),lt.innerHTML=di,Fd=r(),dt=o("table"),dt.innerHTML=ri,bd=r(),xd=o("hr"),$d=r(),rt=o("a"),Pd=r(),m(at.$$.fragment),Cd=r(),ot=o("p"),ot.textContent=ai,Ad=r(),it=o("p"),it.innerHTML=oi,Hd=r(),st=o("table"),st.innerHTML=ii,Ld=r(),Md=o("hr"),wd=r(),ut=o("a"),gd=r(),m(nt.$$.fragment),Ed=r(),mt=o("p"),mt.textContent=si,Rd=r(),ft=o("p"),ft.innerHTML=ui,zd=r(),pt=o("ul"),pt.innerHTML=ni,kd=r(),ht=o("table"),ht.innerHTML=mi,Kd=r(),Od=o("hr"),Bd=r(),ct=o("a"),Dd=r(),m(Tt.$$.fragment),jd=r(),yt=o("p"),yt.textContent=fi,Id=r(),vt=o("p"),vt.innerHTML=pi,Ud=r(),_t=o("ul"),_t.innerHTML=hi,qd=r(),Ft=o("table"),Ft.innerHTML=ci,Sd=r(),Nd=o("hr"),Gd=r(),bt=o("a"),Jd=r(),m(xt.$$.fragment),Qd=r(),$t=o("p"),$t.textContent=Ti,Vd=r(),Pt=o("p"),Pt.innerHTML=yi,Wd=r(),Ct=o("table"),Ct.innerHTML=vi,Xd=r(),Yd=o("hr"),Zd=r(),At=o("a"),tr=r(),m(Ht.$$.fragment),er=r(),Lt=o("p"),Lt.textContent=_i,lr=r(),Mt=o("p"),Mt.innerHTML=Fi,dr=r(),wt=o("table"),wt.innerHTML=bi,rr=r(),ar=o("hr"),or=r(),gt=o("a"),ir=r(),m(Et.$$.fragment),sr=r(),Rt=o("p"),Rt.textContent=xi,ur=r(),zt=o("p"),zt.innerHTML=$i,nr=r(),kt=o("table"),kt.innerHTML=Pi,mr=r(),fr=o("hr"),pr=r(),Kt=o("a"),hr=r(),m(Ot.$$.fragment),cr=r(),Bt=o("p"),Bt.textContent=Ci,Tr=r(),Dt=o("p"),Dt.innerHTML=Ai,yr=r(),jt=o("p"),jt.innerHTML=Hi,vr=r(),It=o("ul"),It.innerHTML=Li,_r=r(),Fr=o("hr"),br=r(),Ut=o("a"),xr=r(),m(qt.$$.fragment),$r=r(),St=o("p"),St.innerHTML=Mi,Pr=r(),Nt=o("ul"),Nt.innerHTML=wi,Cr=r(),Gt=o("table"),Gt.innerHTML=gi,Ar=r(),Hr=o("hr"),Lr=r(),Jt=o("a"),Mr=r(),m(Qt.$$.fragment),wr=r(),Vt=o("p"),Vt.innerHTML=Ei,gr=r(),Wt=o("p"),Wt.innerHTML=Ri,Er=r(),Rr=o("hr"),zr=r(),Xt=o("a"),kr=r(),m(Yt.$$.fragment),Kr=r(),Zt=o("p"),Zt.textContent=zi,Or=r(),te=o("p"),te.innerHTML=ki,Br=r(),ee=o("table"),ee.innerHTML=Ki,Dr=r(),jr=o("hr"),Ir=r(),le=o("a"),Ur=r(),m(de.$$.fragment),qr=r(),re=o("p"),re.textContent=Oi,Sr=r(),ae=o("p"),ae.innerHTML=Bi,Nr=r(),oe=o("table"),oe.innerHTML=Di,Gr=r(),Jr=o("hr"),Qr=r(),ie=o("a"),Vr=r(),m(se.$$.fragment),Wr=r(),ue=o("p"),ue.textContent=ji,Xr=r(),ne=o("p"),ne.innerHTML=Ii,Yr=r(),me=o("table"),me.innerHTML=Ui,Zr=r(),ta=o("hr"),ea=r(),fe=o("a"),la=r(),m(pe.$$.fragment),da=r(),he=o("p"),he.textContent=qi,ra=r(),ce=o("p"),ce.innerHTML=Si,aa=r(),Te=o("ul"),Te.innerHTML=Ni,oa=r(),ye=o("table"),ye.innerHTML=Gi,ia=r(),sa=o("hr"),ua=r(),ve=o("a"),na=r(),m(_e.$$.fragment),ma=r(),Fe=o("p"),Fe.textContent=Ji,fa=r(),be=o("p"),be.innerHTML=Qi,pa=r(),xe=o("ul"),xe.innerHTML=Vi,ha=r(),$e=o("table"),$e.innerHTML=Wi,ca=r(),Ta=o("hr"),ya=r(),Pe=o("a"),va=r(),m(Ce.$$.fragment),_a=r(),Ae=o("p"),Ae.innerHTML=Xi,Fa=r(),He=o("p"),He.innerHTML=Yi,ba=r(),Le=o("ul"),Le.innerHTML=Zi,xa=r(),Me=o("table"),Me.innerHTML=ts,$a=r(),Pa=o("hr"),Ca=r(),we=o("a"),Aa=r(),m(ge.$$.fragment),Ha=r(),Ee=o("p"),Ee.textContent=es,La=r(),Re=o("p"),Re.innerHTML=ls,Ma=r(),ze=o("table"),ze.innerHTML=ds,wa=r(),ga=o("hr"),Ea=r(),ke=o("a"),Ra=r(),m(Ke.$$.fragment),za=r(),Oe=o("p"),Oe.textContent=rs,ka=r(),Be=o("p"),Be.innerHTML=as,Ka=r(),De=o("table"),De.innerHTML=os,Oa=r(),Ba=o("hr"),Da=r(),je=o("a"),ja=r(),m(Ie.$$.fragment),Ia=r(),Ue=o("p"),Ue.textContent=is,Ua=r(),qe=o("p"),qe.innerHTML=ss,qa=r(),Se=o("table"),Se.innerHTML=us,Sa=r(),Na=o("hr"),Ga=r(),Ne=o("a"),Ja=r(),m(Ge.$$.fragment),Qa=r(),Je=o("p"),Je.textContent=ns,Va=r(),Qe=o("p"),Qe.innerHTML=ms,Wa=r(),Ve=o("table"),Ve.innerHTML=fs,Xa=r(),Ya=o("hr"),Za=r(),We=o("a"),to=r(),m(Xe.$$.fragment),eo=r(),Ye=o("p"),Ye.textContent=ps,lo=r(),Ze=o("p"),Ze.innerHTML=hs,ro=r(),tl=o("table"),tl.innerHTML=cs,ao=r(),oo=o("hr"),io=r(),el=o("a"),so=r(),m(ll.$$.fragment),uo=r(),dl=o("p"),dl.textContent=Ts,no=r(),rl=o("p"),rl.innerHTML=ys,mo=r(),al=o("table"),al.innerHTML=vs,fo=r(),po=o("hr"),ho=r(),ol=o("a"),co=r(),m(il.$$.fragment),To=r(),sl=o("p"),sl.textContent=_s,yo=r(),ul=o("p"),ul.innerHTML=Fs,vo=r(),nl=o("p"),nl.innerHTML=bs,_o=r(),Fo=o("hr"),bo=r(),ml=o("a"),xo=r(),m(fl.$$.fragment),$o=r(),pl=o("p"),pl.textContent=xs,Po=r(),hl=o("table"),hl.innerHTML=$s,Co=r(),Ao=o("hr"),Ho=r(),cl=o("a"),Lo=r(),m(Tl.$$.fragment),Mo=r(),yl=o("p"),yl.innerHTML=Ps,wo=r(),go=o("hr"),Eo=r(),m(vl.$$.fragment),Ro=r(),Fl=o("p"),this.h()},l(t){const e=ws("svelte-u9bgzb",document.head);v=i(e,"META",{name:!0,content:!0}),e.forEach(l),bl=a(t),_l=i(t,"P",{}),n(_l).forEach(l),xl=a(t),_=i(t,"A",{id:!0,class:!0}),n(_).forEach(l),$l=a(t),f(F.$$.fragment,t),Pl=a(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1d3zgi"&&(b.textContent=Ko),Cl=a(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-il3kl8"&&(x.textContent=Oo),Al=a(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-1av3l9x"&&($.innerHTML=Bo),Hl=a(t),Ll=i(t,"HR",{}),Ml=a(t),P=i(t,"A",{id:!0,class:!0}),n(P).forEach(l),wl=a(t),f(C.$$.fragment,t),gl=a(t),A=i(t,"P",{"data-svelte-h":!0}),s(A)!=="svelte-z8esp"&&(A.innerHTML=Do),El=a(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=jo),Rl=a(t),zl=i(t,"HR",{}),kl=a(t),L=i(t,"A",{id:!0,class:!0}),n(L).forEach(l),Kl=a(t),f(M.$$.fragment,t),Ol=a(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-1b1asvx"&&(w.innerHTML=Io),Bl=a(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-pth1sg"&&(g.innerHTML=Uo),Dl=a(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=qo),jl=a(t),Il=i(t,"HR",{}),Ul=a(t),R=i(t,"A",{id:!0,class:!0}),n(R).forEach(l),ql=a(t),f(z.$$.fragment,t),Sl=a(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=So),Nl=a(t),K=i(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-xvvopf"&&(K.innerHTML=No),Gl=a(t),O=i(t,"TABLE",{"data-svelte-h":!0}),s(O)!=="svelte-adoxzf"&&(O.innerHTML=Go),Jl=a(t),Ql=i(t,"HR",{}),Vl=a(t),B=i(t,"A",{id:!0,class:!0}),n(B).forEach(l),Wl=a(t),f(D.$$.fragment,t),Xl=a(t),j=i(t,"P",{"data-svelte-h":!0}),s(j)!=="svelte-5479oq"&&(j.textContent=Jo),Yl=a(t),I=i(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-m9boyl"&&(I.innerHTML=Qo),Zl=a(t),U=i(t,"TABLE",{"data-svelte-h":!0}),s(U)!=="svelte-5wetzk"&&(U.innerHTML=Vo),td=a(t),ed=i(t,"HR",{}),ld=a(t),q=i(t,"A",{id:!0,class:!0}),n(q).forEach(l),dd=a(t),f(S.$$.fragment,t),rd=a(t),N=i(t,"P",{"data-svelte-h":!0}),s(N)!=="svelte-1kaf4lx"&&(N.textContent=Wo),ad=a(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Xo),od=a(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Yo),id=a(t),sd=i(t,"HR",{}),ud=a(t),Q=i(t,"A",{id:!0,class:!0}),n(Q).forEach(l),nd=a(t),f(V.$$.fragment,t),md=a(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-s7mgi8"&&(W.textContent=Zo),fd=a(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-5oll1y"&&(X.innerHTML=ti),pd=a(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-n1lt7"&&(Y.innerHTML=ei),hd=a(t),cd=i(t,"HR",{}),Td=a(t),Z=i(t,"A",{id:!0,class:!0}),n(Z).forEach(l),yd=a(t),f(tt.$$.fragment,t),vd=a(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-6quqqj"&&(et.textContent=li),_d=a(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1y45k06"&&(lt.innerHTML=di),Fd=a(t),dt=i(t,"TABLE",{"data-svelte-h":!0}),s(dt)!=="svelte-nyqk4k"&&(dt.innerHTML=ri),bd=a(t),xd=i(t,"HR",{}),$d=a(t),rt=i(t,"A",{id:!0,class:!0}),n(rt).forEach(l),Pd=a(t),f(at.$$.fragment,t),Cd=a(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-132v21g"&&(ot.textContent=ai),Ad=a(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-odriss"&&(it.innerHTML=oi),Hd=a(t),st=i(t,"TABLE",{"data-svelte-h":!0}),s(st)!=="svelte-nbo00i"&&(st.innerHTML=ii),Ld=a(t),Md=i(t,"HR",{}),wd=a(t),ut=i(t,"A",{id:!0,class:!0}),n(ut).forEach(l),gd=a(t),f(nt.$$.fragment,t),Ed=a(t),mt=i(t,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-67h0u1"&&(mt.textContent=si),Rd=a(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-cs0f6n"&&(ft.innerHTML=ui),zd=a(t),pt=i(t,"UL",{"data-svelte-h":!0}),s(pt)!=="svelte-jusv8t"&&(pt.innerHTML=ni),kd=a(t),ht=i(t,"TABLE",{"data-svelte-h":!0}),s(ht)!=="svelte-mtkj0x"&&(ht.innerHTML=mi),Kd=a(t),Od=i(t,"HR",{}),Bd=a(t),ct=i(t,"A",{id:!0,class:!0}),n(ct).forEach(l),Dd=a(t),f(Tt.$$.fragment,t),jd=a(t),yt=i(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9vv4b"&&(yt.textContent=fi),Id=a(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-1ixuuwb"&&(vt.innerHTML=pi),Ud=a(t),_t=i(t,"UL",{"data-svelte-h":!0}),s(_t)!=="svelte-jusv8t"&&(_t.innerHTML=hi),qd=a(t),Ft=i(t,"TABLE",{"data-svelte-h":!0}),s(Ft)!=="svelte-oriydz"&&(Ft.innerHTML=ci),Sd=a(t),Nd=i(t,"HR",{}),Gd=a(t),bt=i(t,"A",{id:!0,class:!0}),n(bt).forEach(l),Jd=a(t),f(xt.$$.fragment,t),Qd=a(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-xb1vdd"&&($t.textContent=Ti),Vd=a(t),Pt=i(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-z8esp"&&(Pt.innerHTML=yi),Wd=a(t),Ct=i(t,"TABLE",{"data-svelte-h":!0}),s(Ct)!=="svelte-pk7ooi"&&(Ct.innerHTML=vi),Xd=a(t),Yd=i(t,"HR",{}),Zd=a(t),At=i(t,"A",{id:!0,class:!0}),n(At).forEach(l),tr=a(t),f(Ht.$$.fragment,t),er=a(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-11aka64"&&(Lt.textContent=_i),lr=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=Fi),dr=a(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-c6gnt1"&&(wt.innerHTML=bi),rr=a(t),ar=i(t,"HR",{}),or=a(t),gt=i(t,"A",{id:!0,class:!0}),n(gt).forEach(l),ir=a(t),f(Et.$$.fragment,t),sr=a(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-1xjiy33"&&(Rt.textContent=xi),ur=a(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-jttckh"&&(zt.innerHTML=$i),nr=a(t),kt=i(t,"TABLE",{"data-svelte-h":!0}),s(kt)!=="svelte-1uj9e15"&&(kt.innerHTML=Pi),mr=a(t),fr=i(t,"HR",{}),pr=a(t),Kt=i(t,"A",{id:!0,class:!0}),n(Kt).forEach(l),hr=a(t),f(Ot.$$.fragment,t),cr=a(t),Bt=i(t,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-16m1u76"&&(Bt.textContent=Ci),Tr=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-698ey0"&&(Dt.innerHTML=Ai),yr=a(t),jt=i(t,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-tjke50"&&(jt.innerHTML=Hi),vr=a(t),It=i(t,"UL",{"data-svelte-h":!0}),s(It)!=="svelte-1iua3xn"&&(It.innerHTML=Li),_r=a(t),Fr=i(t,"HR",{}),br=a(t),Ut=i(t,"A",{id:!0,class:!0}),n(Ut).forEach(l),xr=a(t),f(qt.$$.fragment,t),$r=a(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1fz4yns"&&(St.innerHTML=Mi),Pr=a(t),Nt=i(t,"UL",{"data-svelte-h":!0}),s(Nt)!=="svelte-ph0ovr"&&(Nt.innerHTML=wi),Cr=a(t),Gt=i(t,"TABLE",{"data-svelte-h":!0}),s(Gt)!=="svelte-a5vdxc"&&(Gt.innerHTML=gi),Ar=a(t),Hr=i(t,"HR",{}),Lr=a(t),Jt=i(t,"A",{id:!0,class:!0}),n(Jt).forEach(l),Mr=a(t),f(Qt.$$.fragment,t),wr=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-1rrw4ya"&&(Vt.innerHTML=Ei),gr=a(t),Wt=i(t,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1gdnoew"&&(Wt.innerHTML=Ri),Er=a(t),Rr=i(t,"HR",{}),zr=a(t),Xt=i(t,"A",{id:!0,class:!0}),n(Xt).forEach(l),kr=a(t),f(Yt.$$.fragment,t),Kr=a(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1693r4v"&&(Zt.textContent=zi),Or=a(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-33y4ax"&&(te.innerHTML=ki),Br=a(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1td0xj2"&&(ee.innerHTML=Ki),Dr=a(t),jr=i(t,"HR",{}),Ir=a(t),le=i(t,"A",{id:!0,class:!0}),n(le).forEach(l),Ur=a(t),f(de.$$.fragment,t),qr=a(t),re=i(t,"P",{"data-svelte-h":!0}),s(re)!=="svelte-rsnsrd"&&(re.textContent=Oi),Sr=a(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1xayhm7"&&(ae.innerHTML=Bi),Nr=a(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-1up5toh"&&(oe.innerHTML=Di),Gr=a(t),Jr=i(t,"HR",{}),Qr=a(t),ie=i(t,"A",{id:!0,class:!0}),n(ie).forEach(l),Vr=a(t),f(se.$$.fragment,t),Wr=a(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-id49q5"&&(ue.textContent=ji),Xr=a(t),ne=i(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-1dkdszr"&&(ne.innerHTML=Ii),Yr=a(t),me=i(t,"TABLE",{"data-svelte-h":!0}),s(me)!=="svelte-15tum1z"&&(me.innerHTML=Ui),Zr=a(t),ta=i(t,"HR",{}),ea=a(t),fe=i(t,"A",{id:!0,class:!0}),n(fe).forEach(l),la=a(t),f(pe.$$.fragment,t),da=a(t),he=i(t,"P",{"data-svelte-h":!0}),s(he)!=="svelte-846pp1"&&(he.textContent=qi),ra=a(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-1t2xajz"&&(ce.innerHTML=Si),aa=a(t),Te=i(t,"UL",{"data-svelte-h":!0}),s(Te)!=="svelte-173tqd8"&&(Te.innerHTML=Ni),oa=a(t),ye=i(t,"TABLE",{"data-svelte-h":!0}),s(ye)!=="svelte-1buvx7j"&&(ye.innerHTML=Gi),ia=a(t),sa=i(t,"HR",{}),ua=a(t),ve=i(t,"A",{id:!0,class:!0}),n(ve).forEach(l),na=a(t),f(_e.$$.fragment,t),ma=a(t),Fe=i(t,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-ozshoc"&&(Fe.textContent=Ji),fa=a(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-1t2xajz"&&(be.innerHTML=Qi),pa=a(t),xe=i(t,"UL",{"data-svelte-h":!0}),s(xe)!=="svelte-1ap3720"&&(xe.innerHTML=Vi),ha=a(t),$e=i(t,"TABLE",{"data-svelte-h":!0}),s($e)!=="svelte-lghmn6"&&($e.innerHTML=Wi),ca=a(t),Ta=i(t,"HR",{}),ya=a(t),Pe=i(t,"A",{id:!0,class:!0}),n(Pe).forEach(l),va=a(t),f(Ce.$$.fragment,t),_a=a(t),Ae=i(t,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-ijignt"&&(Ae.innerHTML=Xi),Fa=a(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1t2xajz"&&(He.innerHTML=Yi),ba=a(t),Le=i(t,"UL",{"data-svelte-h":!0}),s(Le)!=="svelte-1bp21xg"&&(Le.innerHTML=Zi),xa=a(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-edt5vq"&&(Me.innerHTML=ts),$a=a(t),Pa=i(t,"HR",{}),Ca=a(t),we=i(t,"A",{id:!0,class:!0}),n(we).forEach(l),Aa=a(t),f(ge.$$.fragment,t),Ha=a(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-3r4wxn"&&(Ee.textContent=es),La=a(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=ls),Ma=a(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-15z8087"&&(ze.innerHTML=ds),wa=a(t),ga=i(t,"HR",{}),Ea=a(t),ke=i(t,"A",{id:!0,class:!0}),n(ke).forEach(l),Ra=a(t),f(Ke.$$.fragment,t),za=a(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1jz5wqp"&&(Oe.textContent=rs),ka=a(t),Be=i(t,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1dkdszr"&&(Be.innerHTML=as),Ka=a(t),De=i(t,"TABLE",{"data-svelte-h":!0}),s(De)!=="svelte-fx5ob"&&(De.innerHTML=os),Oa=a(t),Ba=i(t,"HR",{}),Da=a(t),je=i(t,"A",{id:!0,class:!0}),n(je).forEach(l),ja=a(t),f(Ie.$$.fragment,t),Ia=a(t),Ue=i(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1baynqa"&&(Ue.textContent=is),Ua=a(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=ss),qa=a(t),Se=i(t,"TABLE",{"data-svelte-h":!0}),s(Se)!=="svelte-szv30n"&&(Se.innerHTML=us),Sa=a(t),Na=i(t,"HR",{}),Ga=a(t),Ne=i(t,"A",{id:!0,class:!0}),n(Ne).forEach(l),Ja=a(t),f(Ge.$$.fragment,t),Qa=a(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1gll44b"&&(Je.textContent=ns),Va=a(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=ms),Wa=a(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-159qhrx"&&(Ve.innerHTML=fs),Xa=a(t),Ya=i(t,"HR",{}),Za=a(t),We=i(t,"A",{id:!0,class:!0}),n(We).forEach(l),to=a(t),f(Xe.$$.fragment,t),eo=a(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1upf1p8"&&(Ye.textContent=ps),lo=a(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=hs),ro=a(t),tl=i(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-18nciet"&&(tl.innerHTML=cs),ao=a(t),oo=i(t,"HR",{}),io=a(t),el=i(t,"A",{id:!0,class:!0}),n(el).forEach(l),so=a(t),f(ll.$$.fragment,t),uo=a(t),dl=i(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-8fqhv2"&&(dl.textContent=Ts),no=a(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-1dkdszr"&&(rl.innerHTML=ys),mo=a(t),al=i(t,"TABLE",{"data-svelte-h":!0}),s(al)!=="svelte-pf887e"&&(al.innerHTML=vs),fo=a(t),po=i(t,"HR",{}),ho=a(t),ol=i(t,"A",{id:!0,class:!0}),n(ol).forEach(l),co=a(t),f(il.$$.fragment,t),To=a(t),sl=i(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-yw51a0"&&(sl.textContent=_s),yo=a(t),ul=i(t,"P",{"data-svelte-h":!0}),s(ul)!=="svelte-1gw6hta"&&(ul.innerHTML=Fs),vo=a(t),nl=i(t,"P",{"data-svelte-h":!0}),s(nl)!=="svelte-tjke50"&&(nl.innerHTML=bs),_o=a(t),Fo=i(t,"HR",{}),bo=a(t),ml=i(t,"A",{id:!0,class:!0}),n(ml).forEach(l),xo=a(t),f(fl.$$.fragment,t),$o=a(t),pl=i(t,"P",{"data-svelte-h":!0}),s(pl)!=="svelte-lvoqsi"&&(pl.textContent=xs),Po=a(t),hl=i(t,"TABLE",{"data-svelte-h":!0}),s(hl)!=="svelte-1gtay08"&&(hl.innerHTML=$s),Co=a(t),Ao=i(t,"HR",{}),Ho=a(t),cl=i(t,"A",{id:!0,class:!0}),n(cl).forEach(l),Lo=a(t),f(Tl.$$.fragment,t),Mo=a(t),yl=i(t,"P",{"data-svelte-h":!0}),s(yl)!=="svelte-9rr3v5"&&(yl.innerHTML=Ps),wo=a(t),go=i(t,"HR",{}),Eo=a(t),f(vl.$$.fragment,t),Ro=a(t),Fl=i(t,"P",{}),n(Fl).forEach(l),this.h()},h(){u(v,"name","hf:doc:metadata"),u(v,"content",zs),u(_,"id","module_utils/maths"),u(_,"class","group"),u(P,"id","module_utils/maths.interpolate_data"),u(P,"class","group"),u(L,"id","module_utils/maths.permute_data"),u(L,"class","group"),u(R,"id","module_utils/maths.softmax"),u(R,"class","group"),u(B,"id","module_utils/maths.log_softmax"),u(B,"class","group"),u(q,"id","module_utils/maths.dot"),u(q,"class","group"),u(Q,"id","module_utils/maths.getTopItems"),u(Q,"class","group"),u(Z,"id","module_utils/maths.cos_sim"),u(Z,"class","group"),u(rt,"id","module_utils/maths.magnitude"),u(rt,"class","group"),u(ut,"id","module_utils/maths.min"),u(ut,"class","group"),u(ct,"id","module_utils/maths.max"),u(ct,"class","group"),u(bt,"id","module_utils/maths.medianFilter"),u(bt,"class","group"),u(At,"id","module_utils/maths.round"),u(At,"class","group"),u(gt,"id","module_utils/maths.bankers_round"),u(gt,"class","group"),u(Kt,"id","module_utils/maths..P2FFT"),u(Kt,"class","group"),u(Ut,"id","new_module_utils/maths..P2FFT_new"),u(Ut,"class","group"),u(Jt,"id","module_utils/maths..P2FFT+createComplexArray"),u(Jt,"class","group"),u(Xt,"id","module_utils/maths..P2FFT+fromComplexArray"),u(Xt,"class","group"),u(le,"id","module_utils/maths..P2FFT+toComplexArray"),u(le,"class","group"),u(ie,"id","module_utils/maths..P2FFT+completeSpectrum"),u(ie,"class","group"),u(fe,"id","module_utils/maths..P2FFT+transform"),u(fe,"class","group"),u(ve,"id","module_utils/maths..P2FFT+realTransform"),u(ve,"class","group"),u(Pe,"id","module_utils/maths..P2FFT+inverseTransform"),u(Pe,"class","group"),u(we,"id","module_utils/maths..P2FFT+_transform4"),u(we,"class","group"),u(ke,"id","module_utils/maths..P2FFT+_singleTransform2"),u(ke,"class","group"),u(je,"id","module_utils/maths..P2FFT+_singleTransform4"),u(je,"class","group"),u(Ne,"id","module_utils/maths..P2FFT+_realTransform4"),u(Ne,"class","group"),u(We,"id","module_utils/maths..P2FFT+_singleRealTransform2"),u(We,"class","group"),u(el,"id","module_utils/maths..P2FFT+_singleRealTransform4"),u(el,"class","group"),u(ol,"id","module_utils/maths..NP2FFT"),u(ol,"class","group"),u(ml,"id","new_module_utils/maths..NP2FFT_new"),u(ml,"class","group"),u(cl,"id","module_utils/maths..AnyTypedArray"),u(cl,"class","group")},m(t,e){gs(document.head,v),d(t,bl,e),d(t,_l,e),d(t,xl,e),d(t,_,e),d(t,$l,e),p(F,t,e),d(t,Pl,e),d(t,b,e),d(t,Cl,e),d(t,x,e),d(t,Al,e),d(t,$,e),d(t,Hl,e),d(t,Ll,e),d(t,Ml,e),d(t,P,e),d(t,wl,e),p(C,t,e),d(t,gl,e),d(t,A,e),d(t,El,e),d(t,H,e),d(t,Rl,e),d(t,zl,e),d(t,kl,e),d(t,L,e),d(t,Kl,e),p(M,t,e),d(t,Ol,e),d(t,w,e),d(t,Bl,e),d(t,g,e),d(t,Dl,e),d(t,E,e),d(t,jl,e),d(t,Il,e),d(t,Ul,e),d(t,R,e),d(t,ql,e),p(z,t,e),d(t,Sl,e),d(t,k,e),d(t,Nl,e),d(t,K,e),d(t,Gl,e),d(t,O,e),d(t,Jl,e),d(t,Ql,e),d(t,Vl,e),d(t,B,e),d(t,Wl,e),p(D,t,e),d(t,Xl,e),d(t,j,e),d(t,Yl,e),d(t,I,e),d(t,Zl,e),d(t,U,e),d(t,td,e),d(t,ed,e),d(t,ld,e),d(t,q,e),d(t,dd,e),p(S,t,e),d(t,rd,e),d(t,N,e),d(t,ad,e),d(t,G,e),d(t,od,e),d(t,J,e),d(t,id,e),d(t,sd,e),d(t,ud,e),d(t,Q,e),d(t,nd,e),p(V,t,e),d(t,md,e),d(t,W,e),d(t,fd,e),d(t,X,e),d(t,pd,e),d(t,Y,e),d(t,hd,e),d(t,cd,e),d(t,Td,e),d(t,Z,e),d(t,yd,e),p(tt,t,e),d(t,vd,e),d(t,et,e),d(t,_d,e),d(t,lt,e),d(t,Fd,e),d(t,dt,e),d(t,bd,e),d(t,xd,e),d(t,$d,e),d(t,rt,e),d(t,Pd,e),p(at,t,e),d(t,Cd,e),d(t,ot,e),d(t,Ad,e),d(t,it,e),d(t,Hd,e),d(t,st,e),d(t,Ld,e),d(t,Md,e),d(t,wd,e),d(t,ut,e),d(t,gd,e),p(nt,t,e),d(t,Ed,e),d(t,mt,e),d(t,Rd,e),d(t,ft,e),d(t,zd,e),d(t,pt,e),d(t,kd,e),d(t,ht,e),d(t,Kd,e),d(t,Od,e),d(t,Bd,e),d(t,ct,e),d(t,Dd,e),p(Tt,t,e),d(t,jd,e),d(t,yt,e),d(t,Id,e),d(t,vt,e),d(t,Ud,e),d(t,_t,e),d(t,qd,e),d(t,Ft,e),d(t,Sd,e),d(t,Nd,e),d(t,Gd,e),d(t,bt,e),d(t,Jd,e),p(xt,t,e),d(t,Qd,e),d(t,$t,e),d(t,Vd,e),d(t,Pt,e),d(t,Wd,e),d(t,Ct,e),d(t,Xd,e),d(t,Yd,e),d(t,Zd,e),d(t,At,e),d(t,tr,e),p(Ht,t,e),d(t,er,e),d(t,Lt,e),d(t,lr,e),d(t,Mt,e),d(t,dr,e),d(t,wt,e),d(t,rr,e),d(t,ar,e),d(t,or,e),d(t,gt,e),d(t,ir,e),p(Et,t,e),d(t,sr,e),d(t,Rt,e),d(t,ur,e),d(t,zt,e),d(t,nr,e),d(t,kt,e),d(t,mr,e),d(t,fr,e),d(t,pr,e),d(t,Kt,e),d(t,hr,e),p(Ot,t,e),d(t,cr,e),d(t,Bt,e),d(t,Tr,e),d(t,Dt,e),d(t,yr,e),d(t,jt,e),d(t,vr,e),d(t,It,e),d(t,_r,e),d(t,Fr,e),d(t,br,e),d(t,Ut,e),d(t,xr,e),p(qt,t,e),d(t,$r,e),d(t,St,e),d(t,Pr,e),d(t,Nt,e),d(t,Cr,e),d(t,Gt,e),d(t,Ar,e),d(t,Hr,e),d(t,Lr,e),d(t,Jt,e),d(t,Mr,e),p(Qt,t,e),d(t,wr,e),d(t,Vt,e),d(t,gr,e),d(t,Wt,e),d(t,Er,e),d(t,Rr,e),d(t,zr,e),d(t,Xt,e),d(t,kr,e),p(Yt,t,e),d(t,Kr,e),d(t,Zt,e),d(t,Or,e),d(t,te,e),d(t,Br,e),d(t,ee,e),d(t,Dr,e),d(t,jr,e),d(t,Ir,e),d(t,le,e),d(t,Ur,e),p(de,t,e),d(t,qr,e),d(t,re,e),d(t,Sr,e),d(t,ae,e),d(t,Nr,e),d(t,oe,e),d(t,Gr,e),d(t,Jr,e),d(t,Qr,e),d(t,ie,e),d(t,Vr,e),p(se,t,e),d(t,Wr,e),d(t,ue,e),d(t,Xr,e),d(t,ne,e),d(t,Yr,e),d(t,me,e),d(t,Zr,e),d(t,ta,e),d(t,ea,e),d(t,fe,e),d(t,la,e),p(pe,t,e),d(t,da,e),d(t,he,e),d(t,ra,e),d(t,ce,e),d(t,aa,e),d(t,Te,e),d(t,oa,e),d(t,ye,e),d(t,ia,e),d(t,sa,e),d(t,ua,e),d(t,ve,e),d(t,na,e),p(_e,t,e),d(t,ma,e),d(t,Fe,e),d(t,fa,e),d(t,be,e),d(t,pa,e),d(t,xe,e),d(t,ha,e),d(t,$e,e),d(t,ca,e),d(t,Ta,e),d(t,ya,e),d(t,Pe,e),d(t,va,e),p(Ce,t,e),d(t,_a,e),d(t,Ae,e),d(t,Fa,e),d(t,He,e),d(t,ba,e),d(t,Le,e),d(t,xa,e),d(t,Me,e),d(t,$a,e),d(t,Pa,e),d(t,Ca,e),d(t,we,e),d(t,Aa,e),p(ge,t,e),d(t,Ha,e),d(t,Ee,e),d(t,La,e),d(t,Re,e),d(t,Ma,e),d(t,ze,e),d(t,wa,e),d(t,ga,e),d(t,Ea,e),d(t,ke,e),d(t,Ra,e),p(Ke,t,e),d(t,za,e),d(t,Oe,e),d(t,ka,e),d(t,Be,e),d(t,Ka,e),d(t,De,e),d(t,Oa,e),d(t,Ba,e),d(t,Da,e),d(t,je,e),d(t,ja,e),p(Ie,t,e),d(t,Ia,e),d(t,Ue,e),d(t,Ua,e),d(t,qe,e),d(t,qa,e),d(t,Se,e),d(t,Sa,e),d(t,Na,e),d(t,Ga,e),d(t,Ne,e),d(t,Ja,e),p(Ge,t,e),d(t,Qa,e),d(t,Je,e),d(t,Va,e),d(t,Qe,e),d(t,Wa,e),d(t,Ve,e),d(t,Xa,e),d(t,Ya,e),d(t,Za,e),d(t,We,e),d(t,to,e),p(Xe,t,e),d(t,eo,e),d(t,Ye,e),d(t,lo,e),d(t,Ze,e),d(t,ro,e),d(t,tl,e),d(t,ao,e),d(t,oo,e),d(t,io,e),d(t,el,e),d(t,so,e),p(ll,t,e),d(t,uo,e),d(t,dl,e),d(t,no,e),d(t,rl,e),d(t,mo,e),d(t,al,e),d(t,fo,e),d(t,po,e),d(t,ho,e),d(t,ol,e),d(t,co,e),p(il,t,e),d(t,To,e),d(t,sl,e),d(t,yo,e),d(t,ul,e),d(t,vo,e),d(t,nl,e),d(t,_o,e),d(t,Fo,e),d(t,bo,e),d(t,ml,e),d(t,xo,e),p(fl,t,e),d(t,$o,e),d(t,pl,e),d(t,Po,e),d(t,hl,e),d(t,Co,e),d(t,Ao,e),d(t,Ho,e),d(t,cl,e),d(t,Lo,e),p(Tl,t,e),d(t,Mo,e),d(t,yl,e),d(t,wo,e),d(t,go,e),d(t,Eo,e),p(vl,t,e),d(t,Ro,e),d(t,Fl,e),zo=!0},p:As,i(t){zo||(h(F.$$.fragment,t),h(C.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(S.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(at.$$.fragment,t),h(nt.$$.fragment,t),h(Tt.$$.fragment,t),h(xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Ot.$$.fragment,t),h(qt.$$.fragment,t),h(Qt.$$.fragment,t),h(Yt.$$.fragment,t),h(de.$$.fragment,t),h(se.$$.fragment,t),h(pe.$$.fragment,t),h(_e.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(Ie.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(il.$$.fragment,t),h(fl.$$.fragment,t),h(Tl.$$.fragment,t),h(vl.$$.fragment,t),zo=!0)},o(t){c(F.$$.fragment,t),c(C.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(D.$$.fragment,t),c(S.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(Tt.$$.fragment,t),c(xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Ot.$$.fragment,t),c(qt.$$.fragment,t),c(Qt.$$.fragment,t),c(Yt.$$.fragment,t),c(de.$$.fragment,t),c(se.$$.fragment,t),c(pe.$$.fragment,t),c(_e.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(Ie.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(il.$$.fragment,t),c(fl.$$.fragment,t),c(Tl.$$.fragment,t),c(vl.$$.fragment,t),zo=!1},d(t){t&&(l(bl),l(_l),l(xl),l(_),l($l),l(Pl),l(b),l(Cl),l(x),l(Al),l($),l(Hl),l(Ll),l(Ml),l(P),l(wl),l(gl),l(A),l(El),l(H),l(Rl),l(zl),l(kl),l(L),l(Kl),l(Ol),l(w),l(Bl),l(g),l(Dl),l(E),l(jl),l(Il),l(Ul),l(R),l(ql),l(Sl),l(k),l(Nl),l(K),l(Gl),l(O),l(Jl),l(Ql),l(Vl),l(B),l(Wl),l(Xl),l(j),l(Yl),l(I),l(Zl),l(U),l(td),l(ed),l(ld),l(q),l(dd),l(rd),l(N),l(ad),l(G),l(od),l(J),l(id),l(sd),l(ud),l(Q),l(nd),l(md),l(W),l(fd),l(X),l(pd),l(Y),l(hd),l(cd),l(Td),l(Z),l(yd),l(vd),l(et),l(_d),l(lt),l(Fd),l(dt),l(bd),l(xd),l($d),l(rt),l(Pd),l(Cd),l(ot),l(Ad),l(it),l(Hd),l(st),l(Ld),l(Md),l(wd),l(ut),l(gd),l(Ed),l(mt),l(Rd),l(ft),l(zd),l(pt),l(kd),l(ht),l(Kd),l(Od),l(Bd),l(ct),l(Dd),l(jd),l(yt),l(Id),l(vt),l(Ud),l(_t),l(qd),l(Ft),l(Sd),l(Nd),l(Gd),l(bt),l(Jd),l(Qd),l($t),l(Vd),l(Pt),l(Wd),l(Ct),l(Xd),l(Yd),l(Zd),l(At),l(tr),l(er),l(Lt),l(lr),l(Mt),l(dr),l(wt),l(rr),l(ar),l(or),l(gt),l(ir),l(sr),l(Rt),l(ur),l(zt),l(nr),l(kt),l(mr),l(fr),l(pr),l(Kt),l(hr),l(cr),l(Bt),l(Tr),l(Dt),l(yr),l(jt),l(vr),l(It),l(_r),l(Fr),l(br),l(Ut),l(xr),l($r),l(St),l(Pr),l(Nt),l(Cr),l(Gt),l(Ar),l(Hr),l(Lr),l(Jt),l(Mr),l(wr),l(Vt),l(gr),l(Wt),l(Er),l(Rr),l(zr),l(Xt),l(kr),l(Kr),l(Zt),l(Or),l(te),l(Br),l(ee),l(Dr),l(jr),l(Ir),l(le),l(Ur),l(qr),l(re),l(Sr),l(ae),l(Nr),l(oe),l(Gr),l(Jr),l(Qr),l(ie),l(Vr),l(Wr),l(ue),l(Xr),l(ne),l(Yr),l(me),l(Zr),l(ta),l(ea),l(fe),l(la),l(da),l(he),l(ra),l(ce),l(aa),l(Te),l(oa),l(ye),l(ia),l(sa),l(ua),l(ve),l(na),l(ma),l(Fe),l(fa),l(be),l(pa),l(xe),l(ha),l($e),l(ca),l(Ta),l(ya),l(Pe),l(va),l(_a),l(Ae),l(Fa),l(He),l(ba),l(Le),l(xa),l(Me),l($a),l(Pa),l(Ca),l(we),l(Aa),l(Ha),l(Ee),l(La),l(Re),l(Ma),l(ze),l(wa),l(ga),l(Ea),l(ke),l(Ra),l(za),l(Oe),l(ka),l(Be),l(Ka),l(De),l(Oa),l(Ba),l(Da),l(je),l(ja),l(Ia),l(Ue),l(Ua),l(qe),l(qa),l(Se),l(Sa),l(Na),l(Ga),l(Ne),l(Ja),l(Qa),l(Je),l(Va),l(Qe),l(Wa),l(Ve),l(Xa),l(Ya),l(Za),l(We),l(to),l(eo),l(Ye),l(lo),l(Ze),l(ro),l(tl),l(ao),l(oo),l(io),l(el),l(so),l(uo),l(dl),l(no),l(rl),l(mo),l(al),l(fo),l(po),l(ho),l(ol),l(co),l(To),l(sl),l(yo),l(ul),l(vo),l(nl),l(_o),l(Fo),l(bo),l(ml),l(xo),l($o),l(pl),l(Po),l(hl),l(Co),l(Ao),l(Ho),l(cl),l(Lo),l(Mo),l(yl),l(wo),l(go),l(Eo),l(Ro),l(Fl)),l(v),T(F,t),T(C,t),T(M,t),T(z,t),T(D,t),T(S,t),T(V,t),T(tt,t),T(at,t),T(nt,t),T(Tt,t),T(xt,t),T(Ht,t),T(Et,t),T(Ot,t),T(qt,t),T(Qt,t),T(Yt,t),T(de,t),T(se,t),T(pe,t),T(_e,t),T(Ce,t),T(ge,t),T(Ke,t),T(Ie,t),T(Ge,t),T(Xe,t),T(ll,t),T(il,t),T(fl,t),T(Tl,t),T(vl,t)}}}const zs='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathspermutedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>","local":"utilsmathsgettopitemsitems-topk--code--code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths.bankers_round(x) ⇒ <code> number </code>","local":"utilsmathsbankersroundx--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>","local":"p2fftcompletespectrumspectrum--code-void-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function ks(ko){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ls{constructor(v){super(),Ms(this,v,ks,Rs,Cs,{})}}export{Ds as component};
