import{s as Ue,f as me,n as re,o as ce}from"../chunks/scheduler.37c15a92.js";import{S as we,i as ue,g as a,s as n,r as i,A as Te,h as p,f as e,c as M,j as je,u as o,x as y,k as rl,y as Je,a as s,v as m,d as j,t as U,w as r}from"../chunks/index.2bf4358c.js";import{C as Ct}from"../chunks/CodeBlock.4e987730.js";import{H as ul}from"../chunks/Heading.8ada512a.js";import{E as be}from"../chunks/index.f9c0018f.js";function Ce(dt){let c,Tl,cl,Jl,w,bl,u,ht="在上一节中，我们学习了如何使用 Python 代码从头开始创建智能体，并且我们<strong>看到了这个过程是多么繁琐</strong>。幸运的是，许多智能体库通过<strong>为你处理大量繁重的工作</strong>来简化这项工作。",Cl,T,ft="在本教程中，<strong>你将创建你的第一个智能体</strong>，它能够执行图像生成、网络搜索、时区检查等更多操作！",dl,J,Bt="你还将把你的智能体<strong>发布到 Hugging Face Space 上，以便与朋友和同事分享</strong>。",hl,b,It="让我们开始吧！",fl,C,Bl,d,gt,Il,h,Zt="为了创建这个智能体，我们将使用 <code>smolagents</code>，这是一个<strong>提供轻松开发智能体框架的库</strong>。",gl,f,vt="这个轻量级库设计简洁，但它抽象了构建智能体的许多复杂性，使你能够专注于设计智能体的行为。",Zl,B,At='我们将在下一个单元中深入了解 smolagents。同时，你也可以查看这篇<a href="https://huggingface.co/blog/smolagents" target="_blank">博客文章</a>或该库的<a href="https://github.com/huggingface/smolagents" target="_blank">GitHub 仓库</a>。',vl,I,Wt="简而言之，<code>smolagents</code> 是一个专注于 <strong>codeAgent</strong> 的库，codeAgent 是一种通过代码块执行<strong>“操作”</strong>，然后通过执行代码<strong>“观察”</strong>结果的智能体。",Al,g,Ht="以下是我们将构建的一个示例！",Wl,Z,Et="我们为我们的智能体提供了一个<strong>图像生成工具</strong>，并要求它生成一张猫的图片。",Hl,v,Gt="<code>smolagents</code> 中的智能体将具有<strong>与我们之前构建的自定义智能体相同的行为</strong>：它将<strong>以循环的方式思考、行动和观察</strong>，直到得出最终答案：",El,A,_t='<a href="https://www.youtube.com/watch?v=PQDKcWiuln4" rel="nofollow">智能体流程</a>',Gl,W,Qt="很令人兴奋，对吧？",_l,H,Ql,E,Rt='首先，复制这个 Space：<a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',Rl,G,xt='<p>感谢 <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> 提供的这个模板！🙌</p>',xl,_,Xt="复制这个 Space 意味着<strong>在你的个人资料中创建一个本地副本</strong>：",Xl,Q,kt,kl,R,St="复制这个 Space 之后，<strong>你需要添加你的 Hugging Face API 令牌</strong>，以便你的<strong>智能体</strong>可以调用模型 API。",Sl,x,zt='<li>首先，从<a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens </a>获取一个具有<strong>推理权限</strong>的令牌，第4步需要用到。如果你已经有了，可以跳过此步。</li> <li>进入你的主页，找到刚才复制的空间，点击<strong>设置</strong>按钮。</li> <li>向下滚动到<strong>变量和密钥</strong>部分，点击<strong>新建密钥</strong>。</li> <li>创建一个名为<strong>HF_TOKEN</strong>的密钥，值为第一步获取到的令牌。</li> <li>点击<strong>保存</strong>。</li>',zl,X,Nt='在整个课程中，你唯一需要修改的文件是当前不完整的<strong>“app.py”</strong>。你可以在这里查看<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">模板中的原始文件</a>。要找到你的文件，请进入你复制的 Space，然后点击 <code>Files</code> 选项卡，再在目录列表中点击 <code>app.py</code>。',Nl,k,Ft="让我们一起分解代码：",Fl,S,Vt="<li>文件开头是一些简单但必要的库导入</li>",Vl,z,Ll,N,Lt="正如之前所述，我们将直接使用 <strong>smolagents</strong> 中的 <strong>CodeAgent</strong> 类。",$l,F,Yl,V,$t='现在让我们来了解一下工具！如果你需要回顾一下工具的相关内容，请随时回到课程的<a href="tools">工具</a>部分。',ql,L,Pl,$,Yt="这些工具是我们在这个部分鼓励你构建的东西！我们给你两个例子：",Kl,Y,qt="<li>一个<strong>不工作的虚拟工具</strong>，你可以修改它来制作一些有用的东西。</li> <li>一个<strong>实际工作的工具</strong>，它可以获取世界某地的当前时间。</li>",Dl,q,Pt="要定义你的工具，重要的是：",Ol,P,Kt="<li>为你的函数提供输入和输出类型，例如 <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>格式良好的文档字符串</strong>。<code>smolagents</code> 期望所有参数在文档字符串中都有<strong>文字描述</strong>。</li>",lt,K,tt,D,Dt='它使用 <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> 作为 LLM 引擎。这是一个非常强大的模型，我们将通过无服务器 API 访问它。',et,O,st,ll,Ot="这个智能体仍在使用我们在前面部分中看到的<code>InferenceClient</code>，它位于<strong>HfApiModel</strong>类的背后！",nt,tl,le="当我们介绍 Unit 2 中的框架时，我们会给出更深入的例子。目前，你需要专注于通过智能体的<code>tools</code>参数<strong>向工具列表中添加新工具</strong>。",Mt,el,te="例如，你可以使用代码第一行导入的<code>DuckDuckGoSearchTool</code>，或者你可以检查稍后从 Hub 加载的<code>image_generation_tool</code>。",at,sl,ee="<strong>添加工具将赋予你的智能体新的能力</strong>，在这里尝试发挥创意吧！",pt,nl,se="完整的”app.py”：",yt,Ml,it,al,ne="你的<strong>目标</strong>是熟悉 Space 和智能体。",ot,pl,Me="目前，模板中的智能体<strong>没有使用任何工具，所以尝试为它提供一些预制的工具，甚至自己动手制作一些新工具！</strong>",mt,yl,ae="我们非常期待在 Discord 频道 <strong>#agents-course-showcase</strong> 中看到你的精彩智能体成果！",jt,Ut,rt,il,pe="恭喜你，你已经构建了你的第一个智能体！不要犹豫，与你的朋友和同事分享吧。",ct,ol,ye="由于这是你的第一次尝试，如果有点小问题或速度有点慢，这是完全正常的。在未来的单元中，我们将学习如何构建更好的智能体。",wt,ml,ie="最好的学习方法是尝试，所以不要犹豫，去更新它，添加更多工具，尝试使用另一个模型，等等。",ut,jl,oe="在下一节中，你将完成最后的测验并获得证书！",Tt,Ul,Jt,wl,bt;return w=new ul({props:{title:"使用 smolagents 创建我们的第一个智能体",local:"使用-smolagents-创建我们的第一个智能体",headingTag:"h1"}}),C=new ul({props:{title:"什么是 smolagents？",local:"什么是-smolagents",headingTag:"h2"}}),H=new ul({props:{title:"让我们来构建我们的智能体！",local:"让我们来构建我们的智能体",headingTag:"h2"}}),z=new Ct({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),F=new ul({props:{title:"Tool（工具）",local:"tool工具",headingTag:"h3"}}),L=new Ct({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),K=new ul({props:{title:"The Agent（智能体）",local:"the-agent智能体",headingTag:"h3"}}),O=new Ct({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsX2Fuc3dlciklMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTNEcHJvbXB0X3RlbXBsYXRlcyUwQSklMEElMEFHcmFkaW9VSShhZ2VudCkubGF1bmNoKCk=",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),Ml=new Ct({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),Ul=new be({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/tutorial.mdx"}}),{c(){c=a("meta"),Tl=n(),cl=a("p"),Jl=n(),i(w.$$.fragment),bl=n(),u=a("p"),u.innerHTML=ht,Cl=n(),T=a("p"),T.innerHTML=ft,dl=n(),J=a("p"),J.innerHTML=Bt,hl=n(),b=a("p"),b.textContent=It,fl=n(),i(C.$$.fragment),Bl=n(),d=a("img"),Il=n(),h=a("p"),h.innerHTML=Zt,gl=n(),f=a("p"),f.textContent=vt,Zl=n(),B=a("p"),B.innerHTML=At,vl=n(),I=a("p"),I.innerHTML=Wt,Al=n(),g=a("p"),g.textContent=Ht,Wl=n(),Z=a("p"),Z.innerHTML=Et,Hl=n(),v=a("p"),v.innerHTML=Gt,El=n(),A=a("p"),A.innerHTML=_t,Gl=n(),W=a("p"),W.textContent=Qt,_l=n(),i(H.$$.fragment),Ql=n(),E=a("p"),E.innerHTML=Rt,Rl=n(),G=a("blockquote"),G.innerHTML=xt,xl=n(),_=a("p"),_.innerHTML=Xt,Xl=n(),Q=a("img"),kl=n(),R=a("p"),R.innerHTML=St,Sl=n(),x=a("ol"),x.innerHTML=zt,zl=n(),X=a("p"),X.innerHTML=Nt,Nl=n(),k=a("p"),k.textContent=Ft,Fl=n(),S=a("ul"),S.innerHTML=Vt,Vl=n(),i(z.$$.fragment),Ll=n(),N=a("p"),N.innerHTML=Lt,$l=n(),i(F.$$.fragment),Yl=n(),V=a("p"),V.innerHTML=$t,ql=n(),i(L.$$.fragment),Pl=n(),$=a("p"),$.textContent=Yt,Kl=n(),Y=a("ol"),Y.innerHTML=qt,Dl=n(),q=a("p"),q.textContent=Pt,Ol=n(),P=a("ol"),P.innerHTML=Kt,lt=n(),i(K.$$.fragment),tt=n(),D=a("p"),D.innerHTML=Dt,et=n(),i(O.$$.fragment),st=n(),ll=a("p"),ll.innerHTML=Ot,nt=n(),tl=a("p"),tl.innerHTML=le,Mt=n(),el=a("p"),el.innerHTML=te,at=n(),sl=a("p"),sl.innerHTML=ee,pt=n(),nl=a("p"),nl.textContent=se,yt=n(),i(Ml.$$.fragment),it=n(),al=a("p"),al.innerHTML=ne,ot=n(),pl=a("p"),pl.innerHTML=Me,mt=n(),yl=a("p"),yl.innerHTML=ae,jt=n(),Ut=a("hr"),rt=n(),il=a("p"),il.textContent=pe,ct=n(),ol=a("p"),ol.textContent=ye,wt=n(),ml=a("p"),ml.textContent=ie,ut=n(),jl=a("p"),jl.textContent=oe,Tt=n(),i(Ul.$$.fragment),Jt=n(),wl=a("p"),this.h()},l(l){const t=Te("svelte-u9bgzb",document.head);c=p(t,"META",{name:!0,content:!0}),t.forEach(e),Tl=M(l),cl=p(l,"P",{}),je(cl).forEach(e),Jl=M(l),o(w.$$.fragment,l),bl=M(l),u=p(l,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1ujhsd9"&&(u.innerHTML=ht),Cl=M(l),T=p(l,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1fz25zu"&&(T.innerHTML=ft),dl=M(l),J=p(l,"P",{"data-svelte-h":!0}),y(J)!=="svelte-vbbf2l"&&(J.innerHTML=Bt),hl=M(l),b=p(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-izpy37"&&(b.textContent=It),fl=M(l),o(C.$$.fragment,l),Bl=M(l),d=p(l,"IMG",{src:!0,alt:!0}),Il=M(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1p4ogmz"&&(h.innerHTML=Zt),gl=M(l),f=p(l,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1rnyukb"&&(f.textContent=vt),Zl=M(l),B=p(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-eka5kk"&&(B.innerHTML=At),vl=M(l),I=p(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1terpmt"&&(I.innerHTML=Wt),Al=M(l),g=p(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-teea68"&&(g.textContent=Ht),Wl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1rvw3dn"&&(Z.innerHTML=Et),Hl=M(l),v=p(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-k9hzof"&&(v.innerHTML=Gt),El=M(l),A=p(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-1wjb8et"&&(A.innerHTML=_t),Gl=M(l),W=p(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-zp6tm6"&&(W.textContent=Qt),_l=M(l),o(H.$$.fragment,l),Ql=M(l),E=p(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1ga3nhy"&&(E.innerHTML=Rt),Rl=M(l),G=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),y(G)!=="svelte-1szeww4"&&(G.innerHTML=xt),xl=M(l),_=p(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1lf9he9"&&(_.innerHTML=Xt),Xl=M(l),Q=p(l,"IMG",{src:!0,alt:!0}),kl=M(l),R=p(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-cqt9ni"&&(R.innerHTML=St),Sl=M(l),x=p(l,"OL",{"data-svelte-h":!0}),y(x)!=="svelte-sng7af"&&(x.innerHTML=zt),zl=M(l),X=p(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1rvndzh"&&(X.innerHTML=Nt),Nl=M(l),k=p(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-qzw9ae"&&(k.textContent=Ft),Fl=M(l),S=p(l,"UL",{"data-svelte-h":!0}),y(S)!=="svelte-7zqdyp"&&(S.innerHTML=Vt),Vl=M(l),o(z.$$.fragment,l),Ll=M(l),N=p(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-193ax9h"&&(N.innerHTML=Lt),$l=M(l),o(F.$$.fragment,l),Yl=M(l),V=p(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1y6flx0"&&(V.innerHTML=$t),ql=M(l),o(L.$$.fragment,l),Pl=M(l),$=p(l,"P",{"data-svelte-h":!0}),y($)!=="svelte-txzape"&&($.textContent=Yt),Kl=M(l),Y=p(l,"OL",{"data-svelte-h":!0}),y(Y)!=="svelte-1nki85t"&&(Y.innerHTML=qt),Dl=M(l),q=p(l,"P",{"data-svelte-h":!0}),y(q)!=="svelte-e5waqh"&&(q.textContent=Pt),Ol=M(l),P=p(l,"OL",{"data-svelte-h":!0}),y(P)!=="svelte-3glxb2"&&(P.innerHTML=Kt),lt=M(l),o(K.$$.fragment,l),tt=M(l),D=p(l,"P",{"data-svelte-h":!0}),y(D)!=="svelte-15wg5ed"&&(D.innerHTML=Dt),et=M(l),o(O.$$.fragment,l),st=M(l),ll=p(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-1ecqmc8"&&(ll.innerHTML=Ot),nt=M(l),tl=p(l,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-1trmkgr"&&(tl.innerHTML=le),Mt=M(l),el=p(l,"P",{"data-svelte-h":!0}),y(el)!=="svelte-1r29o7"&&(el.innerHTML=te),at=M(l),sl=p(l,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-1ex3pg"&&(sl.innerHTML=ee),pt=M(l),nl=p(l,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-1islpf0"&&(nl.textContent=se),yt=M(l),o(Ml.$$.fragment,l),it=M(l),al=p(l,"P",{"data-svelte-h":!0}),y(al)!=="svelte-1mbhzkl"&&(al.innerHTML=ne),ot=M(l),pl=p(l,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-1scg4wp"&&(pl.innerHTML=Me),mt=M(l),yl=p(l,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-o093cv"&&(yl.innerHTML=ae),jt=M(l),Ut=p(l,"HR",{}),rt=M(l),il=p(l,"P",{"data-svelte-h":!0}),y(il)!=="svelte-r2adc4"&&(il.textContent=pe),ct=M(l),ol=p(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-1eae468"&&(ol.textContent=ye),wt=M(l),ml=p(l,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-1vfq4lx"&&(ml.textContent=ie),ut=M(l),jl=p(l,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-o18u8f"&&(jl.textContent=oe),Tt=M(l),o(Ul.$$.fragment,l),Jt=M(l),wl=p(l,"P",{}),je(wl).forEach(e),this.h()},h(){rl(c,"name","hf:doc:metadata"),rl(c,"content",de),me(d.src,gt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||rl(d,"src",gt),rl(d,"alt","smolagents"),me(Q.src,kt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||rl(Q,"src",kt),rl(Q,"alt","复制")},m(l,t){Je(document.head,c),s(l,Tl,t),s(l,cl,t),s(l,Jl,t),m(w,l,t),s(l,bl,t),s(l,u,t),s(l,Cl,t),s(l,T,t),s(l,dl,t),s(l,J,t),s(l,hl,t),s(l,b,t),s(l,fl,t),m(C,l,t),s(l,Bl,t),s(l,d,t),s(l,Il,t),s(l,h,t),s(l,gl,t),s(l,f,t),s(l,Zl,t),s(l,B,t),s(l,vl,t),s(l,I,t),s(l,Al,t),s(l,g,t),s(l,Wl,t),s(l,Z,t),s(l,Hl,t),s(l,v,t),s(l,El,t),s(l,A,t),s(l,Gl,t),s(l,W,t),s(l,_l,t),m(H,l,t),s(l,Ql,t),s(l,E,t),s(l,Rl,t),s(l,G,t),s(l,xl,t),s(l,_,t),s(l,Xl,t),s(l,Q,t),s(l,kl,t),s(l,R,t),s(l,Sl,t),s(l,x,t),s(l,zl,t),s(l,X,t),s(l,Nl,t),s(l,k,t),s(l,Fl,t),s(l,S,t),s(l,Vl,t),m(z,l,t),s(l,Ll,t),s(l,N,t),s(l,$l,t),m(F,l,t),s(l,Yl,t),s(l,V,t),s(l,ql,t),m(L,l,t),s(l,Pl,t),s(l,$,t),s(l,Kl,t),s(l,Y,t),s(l,Dl,t),s(l,q,t),s(l,Ol,t),s(l,P,t),s(l,lt,t),m(K,l,t),s(l,tt,t),s(l,D,t),s(l,et,t),m(O,l,t),s(l,st,t),s(l,ll,t),s(l,nt,t),s(l,tl,t),s(l,Mt,t),s(l,el,t),s(l,at,t),s(l,sl,t),s(l,pt,t),s(l,nl,t),s(l,yt,t),m(Ml,l,t),s(l,it,t),s(l,al,t),s(l,ot,t),s(l,pl,t),s(l,mt,t),s(l,yl,t),s(l,jt,t),s(l,Ut,t),s(l,rt,t),s(l,il,t),s(l,ct,t),s(l,ol,t),s(l,wt,t),s(l,ml,t),s(l,ut,t),s(l,jl,t),s(l,Tt,t),m(Ul,l,t),s(l,Jt,t),s(l,wl,t),bt=!0},p:re,i(l){bt||(j(w.$$.fragment,l),j(C.$$.fragment,l),j(H.$$.fragment,l),j(z.$$.fragment,l),j(F.$$.fragment,l),j(L.$$.fragment,l),j(K.$$.fragment,l),j(O.$$.fragment,l),j(Ml.$$.fragment,l),j(Ul.$$.fragment,l),bt=!0)},o(l){U(w.$$.fragment,l),U(C.$$.fragment,l),U(H.$$.fragment,l),U(z.$$.fragment,l),U(F.$$.fragment,l),U(L.$$.fragment,l),U(K.$$.fragment,l),U(O.$$.fragment,l),U(Ml.$$.fragment,l),U(Ul.$$.fragment,l),bt=!1},d(l){l&&(e(Tl),e(cl),e(Jl),e(bl),e(u),e(Cl),e(T),e(dl),e(J),e(hl),e(b),e(fl),e(Bl),e(d),e(Il),e(h),e(gl),e(f),e(Zl),e(B),e(vl),e(I),e(Al),e(g),e(Wl),e(Z),e(Hl),e(v),e(El),e(A),e(Gl),e(W),e(_l),e(Ql),e(E),e(Rl),e(G),e(xl),e(_),e(Xl),e(Q),e(kl),e(R),e(Sl),e(x),e(zl),e(X),e(Nl),e(k),e(Fl),e(S),e(Vl),e(Ll),e(N),e($l),e(Yl),e(V),e(ql),e(Pl),e($),e(Kl),e(Y),e(Dl),e(q),e(Ol),e(P),e(lt),e(tt),e(D),e(et),e(st),e(ll),e(nt),e(tl),e(Mt),e(el),e(at),e(sl),e(pt),e(nl),e(yt),e(it),e(al),e(ot),e(pl),e(mt),e(yl),e(jt),e(Ut),e(rt),e(il),e(ct),e(ol),e(wt),e(ml),e(ut),e(jl),e(Tt),e(Jt),e(wl)),e(c),r(w,l),r(C,l),r(H,l),r(z,l),r(F,l),r(L,l),r(K,l),r(O,l),r(Ml,l),r(Ul,l)}}}const de='{"title":"使用 smolagents 创建我们的第一个智能体","local":"使用-smolagents-创建我们的第一个智能体","sections":[{"title":"什么是 smolagents？","local":"什么是-smolagents","sections":[],"depth":2},{"title":"让我们来构建我们的智能体！","local":"让我们来构建我们的智能体","sections":[{"title":"Tool（工具）","local":"tool工具","sections":[],"depth":3},{"title":"The Agent（智能体）","local":"the-agent智能体","sections":[],"depth":3}],"depth":2}],"depth":1}';function he(dt){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends we{constructor(c){super(),ue(this,c,he,Ce,Ue,{})}}export{ve as component};
