import{s as bs,n as Cs,o as Bs}from"../chunks/scheduler.7da89386.js";import{S as Zs,i as Ns,g as p,s as a,r as J,A as _s,h as i,f as l,c as n,j as Is,u as o,x as c,k as os,y as Rs,a as t,v as r,d as h,t as M,w as T}from"../chunks/index.0b7befd3.js";import{C as rs}from"../chunks/CodeBlock.ce33a881.js";import{H as W}from"../chunks/Heading.8a936589.js";function Gs(hs){let m,z,x,k,w,Y,j,Ms='Given the simplicity of the format, it’s very simple and efficient to fetch and parse metadata about Safetensors weights – i.e. the list of tensors, their types, and their shapes or numbers of parameters – using small <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Range_requests" rel="nofollow">(Range) HTTP requests</a>.',A,U,Ts='This parsing has been implemented in JS in <a href="https://huggingface.co/docs/huggingface.js/main/en/hub/modules#parsesafetensorsmetadata" rel="nofollow"><code>huggingface.js</code></a> (sample code follows below), but it would be similar in any language.',F,g,v,u,ms="There can be many potential use cases. For instance, we use it on the HuggingFace Hub to display info about models which have safetensors weights:",H,d,ds='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/safetensors/model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/safetensors/model-page-dark.png"/>',X,y,ys='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/safetensors/view-all-tensors-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/safetensors/view-all-tensors-dark.png"/>',q,f,L,I,D,b,ws='Using <a href="https://huggingface.co/docs/huggingface.js" rel="nofollow"><code>huggingface.js</code></a>',P,C,O,B,js="Depending on whether the safetensors weights are sharded into multiple files or not, the output of the call above will be:",K,Z,ss,N,Us="where the underlying <code>types</code> are the following:",es,_,ls,R,ts,G,gs='In this example python script, we are parsing metadata of <a href="https://huggingface.co/gpt2/blob/main/model.safetensors" rel="nofollow">gpt2</a>.',as,E,ns,V,ps,Q,us='For instance, here are the number of params per dtype for a few models on the HuggingFace Hub. Also see <a href="https://github.com/huggingface/safetensors/issues/44" rel="nofollow">this issue</a> for more examples of usage.',is,S,fs='<thead><tr><th>model</th> <th>safetensors</th> <th>params</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/gpt2?show_tensors=true" rel="nofollow">gpt2</a></td> <td>single-file</td> <td>{ ‘F32’ =&gt; 137022720 }</td></tr> <tr><td><a href="https://huggingface.co/roberta-base?show_tensors=true" rel="nofollow">roberta-base</a></td> <td>single-file</td> <td>{ ‘F32’ =&gt; 124697433, ‘I64’ =&gt; 514 }</td></tr> <tr><td><a href="https://huggingface.co/Jean-Baptiste/camembert-ner?show_tensors=true" rel="nofollow">Jean-Baptiste/camembert-ner</a></td> <td>single-file</td> <td>{ ‘F32’ =&gt; 110035205, ‘I64’ =&gt; 514 }</td></tr> <tr><td><a href="https://huggingface.co/roberta-large?show_tensors=true" rel="nofollow">roberta-large</a></td> <td>single-file</td> <td>{ ‘F32’ =&gt; 355412057, ‘I64’ =&gt; 514 }</td></tr> <tr><td><a href="https://huggingface.co/distilbert-base-german-cased?show_tensors=true" rel="nofollow">distilbert-base-german-cased</a></td> <td>single-file</td> <td>{ ‘F32’ =&gt; 67431550 }</td></tr> <tr><td><a href="https://huggingface.co/EleutherAI/gpt-neox-20b?show_tensors=true" rel="nofollow">EleutherAI/gpt-neox-20b</a></td> <td>sharded</td> <td>{ ‘F16’ =&gt; 20554568208, ‘U8’ =&gt; 184549376 }</td></tr> <tr><td><a href="https://huggingface.co/bigscience/bloom-560m?show_tensors=true" rel="nofollow">bigscience/bloom-560m</a></td> <td>single-file</td> <td>{ ‘F16’ =&gt; 559214592 }</td></tr> <tr><td><a href="https://huggingface.co/bigscience/bloom?show_tensors=true" rel="nofollow">bigscience/bloom</a></td> <td>sharded</td> <td>{ ‘BF16’ =&gt; 176247271424 }</td></tr> <tr><td><a href="https://huggingface.co/bigscience/bloom-3b?show_tensors=true" rel="nofollow">bigscience/bloom-3b</a></td> <td>single-file</td> <td>{ ‘F16’ =&gt; 3002557440 }</td></tr></tbody>',cs,$,Js;return w=new W({props:{title:"Metadata Parsing",local:"metadata-parsing",headingTag:"h1"}}),g=new W({props:{title:"Example use case",local:"example-use-case",headingTag:"h2"}}),f=new W({props:{title:"Usage",local:"usage",headingTag:"h2"}}),I=new W({props:{title:"JavaScript/TypeScript",local:"js",headingTag:"h3"}}),C=new rs({props:{code:"aW1wb3J0JTIwJTdCJTIwcGFyc2VTYWZldGVuc29yc01ldGFkYXRhJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjBpbmZvJTIwJTNEJTIwYXdhaXQlMjBwYXJzZVNhZmV0ZW5zb3JzTWV0YWRhdGEoJTdCJTBBJTA5cmVwbyUzQSUyMCU3QiUyMHR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJiaWdzY2llbmNlJTJGYmxvb20lMjIlMjAlN0QlMkMlMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2coaW5mbyklMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBzaGFyZGVkJTNBJTIwdHJ1ZSUyQyUwQSUyRiUyRiUyMCUyMCUyMGluZGV4JTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwbWV0YWRhdGElM0ElMjAlN0IlMjB0b3RhbF9zaXplJTNBJTIwMzUyNDk0NTQyODQ4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwd2VpZ2h0X21hcCUzQSUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMCUyMCdoLjAuaW5wdXRfbGF5ZXJub3JtLmJpYXMnJTNBJTIwJ21vZGVsXzAwMDAyLW9mLTAwMDcyLnNhZmV0ZW5zb3JzJyUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGhlYWRlcnMlM0ElMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjBfX21ldGFkYXRhX18lM0ElMjAlN0InZm9ybWF0JyUzQSUyMCdwdCclN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnaC4yLmF0dG4uY19hdHRuLndlaWdodCclM0ElMjAlN0InZHR5cGUnJTNBJTIwJ0YzMiclMkMlMjAnc2hhcGUnJTNBJTIwJTVCNzY4JTJDJTIwMjMwNCU1RCUyQyUyMCdkYXRhX29mZnNldHMnJTNBJTIwJTVCNTQxMDEyOTkyJTJDJTIwNTQ4MDkwODgwJTVEJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTdEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">import</span> { parseSafetensorsMetadata } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> info = <span class="hljs-keyword">await</span> <span class="hljs-title function_">parseSafetensorsMetadata</span>({
	<span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;bigscience/bloom&quot;</span> },
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(info)
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sharded: true,</span>
<span class="hljs-comment">//   index: {</span>
<span class="hljs-comment">//     metadata: { total_size: 352494542848 },</span>
<span class="hljs-comment">//     weight_map: {</span>
<span class="hljs-comment">//       &#x27;h.0.input_layernorm.bias&#x27;: &#x27;model_00002-of-00072.safetensors&#x27;,</span>
<span class="hljs-comment">//       ...</span>
<span class="hljs-comment">//     }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   headers: {</span>
<span class="hljs-comment">//     __metadata__: {&#x27;format&#x27;: &#x27;pt&#x27;},</span>
<span class="hljs-comment">//     &#x27;h.2.attn.c_attn.weight&#x27;: {&#x27;dtype&#x27;: &#x27;F32&#x27;, &#x27;shape&#x27;: [768, 2304], &#x27;data_offsets&#x27;: [541012992, 548090880]},</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Z=new rs({props:{code:"ZXhwb3J0JTIwdHlwZSUyMFNhZmV0ZW5zb3JzUGFyc2VGcm9tUmVwbyUyMCUzRCUwQSU3QyUyMCU3QiUwQSUwOSUwOXNoYXJkZWQlM0ElMjBmYWxzZSUzQiUwQSUwOSUwOWhlYWRlciUzQSUyMFNhZmV0ZW5zb3JzRmlsZUhlYWRlciUzQiUwQSUwOSU3RCUwQSU3QyUyMCU3QiUwQSUwOSUwOXNoYXJkZWQlM0ElMjB0cnVlJTNCJTBBJTA5JTA5aW5kZXglM0ElMjBTYWZldGVuc29yc0luZGV4SnNvbiUzQiUwQSUwOSUwOWhlYWRlcnMlM0ElMjBTYWZldGVuc29yc1NoYXJkZWRIZWFkZXJzJTNCJTBBJTA5JTdEJTNC",highlighted:`<span class="hljs-keyword">export</span> <span class="hljs-keyword">type</span> <span class="hljs-title class_">SafetensorsParseFromRepo</span> =
| {
		<span class="hljs-attr">sharded</span>: <span class="hljs-literal">false</span>;
		<span class="hljs-attr">header</span>: <span class="hljs-title class_">SafetensorsFileHeader</span>;
	}
| {
		<span class="hljs-attr">sharded</span>: <span class="hljs-literal">true</span>;
		<span class="hljs-attr">index</span>: <span class="hljs-title class_">SafetensorsIndexJson</span>;
		<span class="hljs-attr">headers</span>: <span class="hljs-title class_">SafetensorsShardedHeaders</span>;
	};`,wrap:!1}}),_=new rs({props:{code:"dHlwZSUyMEZpbGVOYW1lJTIwJTNEJTIwc3RyaW5nJTNCJTBBJTBBdHlwZSUyMFRlbnNvck5hbWUlMjAlM0QlMjBzdHJpbmclM0IlMEF0eXBlJTIwRHR5cGUlMjAlM0QlMjAlMjJGNjQlMjIlMjAlN0MlMjAlMjJGMzIlMjIlMjAlN0MlMjAlMjJGMTYlMjIlMjAlN0MlMjAlMjJCRjE2JTIyJTIwJTdDJTIwJTIySTY0JTIyJTIwJTdDJTIwJTIySTMyJTIyJTIwJTdDJTIwJTIySTE2JTIyJTIwJTdDJTIwJTIySTglMjIlMjAlN0MlMjAlMjJVOCUyMiUyMCU3QyUyMCUyMkJPT0wlMjIlM0IlMEElMEFpbnRlcmZhY2UlMjBUZW5zb3JJbmZvJTIwJTdCJTBBJTA5ZHR5cGUlM0ElMjBEdHlwZSUzQiUwQSUwOXNoYXBlJTNBJTIwbnVtYmVyJTVCJTVEJTNCJTBBJTA5ZGF0YV9vZmZzZXRzJTNBJTIwJTVCbnVtYmVyJTJDJTIwbnVtYmVyJTVEJTNCJTBBJTdEJTBBJTBBdHlwZSUyMFNhZmV0ZW5zb3JzRmlsZUhlYWRlciUyMCUzRCUyMFJlY29yZCUzQ1RlbnNvck5hbWUlMkMlMjBUZW5zb3JJbmZvJTNFJTIwJTI2JTIwJTdCJTBBJTA5X19tZXRhZGF0YV9fJTNBJTIwUmVjb3JkJTNDc3RyaW5nJTJDJTIwc3RyaW5nJTNFJTNCJTBBJTdEJTNCJTBBJTBBaW50ZXJmYWNlJTIwU2FmZXRlbnNvcnNJbmRleEpzb24lMjAlN0IlMEElMDl3ZWlnaHRfbWFwJTNBJTIwUmVjb3JkJTNDVGVuc29yTmFtZSUyQyUyMEZpbGVOYW1lJTNFJTNCJTBBJTdEJTBBJTBBZXhwb3J0JTIwdHlwZSUyMFNhZmV0ZW5zb3JzU2hhcmRlZEhlYWRlcnMlMjAlM0QlMjBSZWNvcmQlM0NGaWxlTmFtZSUyQyUyMFNhZmV0ZW5zb3JzRmlsZUhlYWRlciUzRSUzQiUwQQ==",highlighted:`<span class="hljs-keyword">type</span> <span class="hljs-title class_">FileName</span> = <span class="hljs-built_in">string</span>;

<span class="hljs-keyword">type</span> <span class="hljs-title class_">TensorName</span> = <span class="hljs-built_in">string</span>;
<span class="hljs-keyword">type</span> <span class="hljs-title class_">Dtype</span> = <span class="hljs-string">&quot;F64&quot;</span> | <span class="hljs-string">&quot;F32&quot;</span> | <span class="hljs-string">&quot;F16&quot;</span> | <span class="hljs-string">&quot;BF16&quot;</span> | <span class="hljs-string">&quot;I64&quot;</span> | <span class="hljs-string">&quot;I32&quot;</span> | <span class="hljs-string">&quot;I16&quot;</span> | <span class="hljs-string">&quot;I8&quot;</span> | <span class="hljs-string">&quot;U8&quot;</span> | <span class="hljs-string">&quot;BOOL&quot;</span>;

<span class="hljs-keyword">interface</span> <span class="hljs-title class_">TensorInfo</span> {
	<span class="hljs-attr">dtype</span>: <span class="hljs-title class_">Dtype</span>;
	<span class="hljs-attr">shape</span>: <span class="hljs-built_in">number</span>[];
	<span class="hljs-attr">data_offsets</span>: [<span class="hljs-built_in">number</span>, <span class="hljs-built_in">number</span>];
}

<span class="hljs-keyword">type</span> <span class="hljs-title class_">SafetensorsFileHeader</span> = <span class="hljs-title class_">Record</span>&lt;<span class="hljs-title class_">TensorName</span>, <span class="hljs-title class_">TensorInfo</span>&gt; &amp; {
	<span class="hljs-attr">__metadata__</span>: <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt;;
};

<span class="hljs-keyword">interface</span> <span class="hljs-title class_">SafetensorsIndexJson</span> {
	<span class="hljs-attr">weight_map</span>: <span class="hljs-title class_">Record</span>&lt;<span class="hljs-title class_">TensorName</span>, <span class="hljs-title class_">FileName</span>&gt;;
}

<span class="hljs-keyword">export</span> <span class="hljs-keyword">type</span> <span class="hljs-title class_">SafetensorsShardedHeaders</span> = <span class="hljs-title class_">Record</span>&lt;<span class="hljs-title class_">FileName</span>, <span class="hljs-title class_">SafetensorsFileHeader</span>&gt;;
`,wrap:!1}}),R=new W({props:{title:"Python",local:"python",headingTag:"h3"}}),E=new rs({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMjAlMjMlMjBwaXAlMjBpbnN0YWxsJTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBzdHJ1Y3QlMEElMEFkZWYlMjBwYXJzZV9zaW5nbGVfZmlsZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmV0Y2glMjB0aGUlMjBmaXJzdCUyMDglMjBieXRlcyUyMG9mJTIwdGhlJTIwZmlsZSUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0InUmFuZ2UnJTNBJTIwJ2J5dGVzJTNEMC03JyU3RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCUyQyUyMGhlYWRlcnMlM0RoZWFkZXJzKSUwQSUyMCUyMCUyMCUyMCUyMyUyMEludGVycHJldCUyMHRoZSUyMGJ5dGVzJTIwYXMlMjBhJTIwbGl0dGxlLWVuZGlhbiUyMHVuc2lnbmVkJTIwNjQtYml0JTIwaW50ZWdlciUwQSUyMCUyMCUyMCUyMGxlbmd0aF9vZl9oZWFkZXIlMjAlM0QlMjBzdHJ1Y3QudW5wYWNrKCclM0NRJyUyQyUyMHJlc3BvbnNlLmNvbnRlbnQpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMyUyMEZldGNoJTIwbGVuZ3RoX29mX2hlYWRlciUyMGJ5dGVzJTIwc3RhcnRpbmclMjBmcm9tJTIwdGhlJTIwOXRoJTIwYnl0ZSUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0InUmFuZ2UnJTNBJTIwZidieXRlcyUzRDgtJTdCNyUyMCUyQiUyMGxlbmd0aF9vZl9oZWFkZXIlN0QnJTdEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsJTJDJTIwaGVhZGVycyUzRGhlYWRlcnMpJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW50ZXJwcmV0JTIwdGhlJTIwcmVzcG9uc2UlMjBhcyUyMGElMjBKU09OJTIwb2JqZWN0JTBBJTIwJTIwJTIwJTIwaGVhZGVyJTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaGVhZGVyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmdwdDIlMkZyZXNvbHZlJTJGbWFpbiUyRm1vZGVsLnNhZmV0ZW5zb3JzJTIyJTBBaGVhZGVyJTIwJTNEJTIwcGFyc2Vfc2luZ2xlX2ZpbGUodXJsKSUwQSUwQXByaW50KGhlYWRlciklMEElMjMlMjAlN0IlMEElMjMlMjAlMjAlMjAlMjJfX21ldGFkYXRhX18lMjIlM0ElMjAlN0IlMjAlMjJmb3JtYXQlMjIlM0ElMjAlMjJwdCUyMiUyMCU3RCUyQyUwQSUyMyUyMCUyMCUyMCUyMmguMTAubG5fMS53ZWlnaHQlMjIlM0ElMjAlN0IlMEElMjMlMjAlMjAlMjAlMjAlMjAlMjJkdHlwZSUyMiUzQSUyMCUyMkYzMiUyMiUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMCUyMnNoYXBlJTIyJTNBJTIwJTVCNzY4JTVEJTJDJTBBJTIzJTIwJTIwJTIwJTIwJTIwJTIyZGF0YV9vZmZzZXRzJTIyJTNBJTIwJTVCMjIzMTU0MTc2JTJDJTIwMjIzMTU3MjQ4JTVEJTBBJTIzJTIwJTIwJTIwJTdEJTJDJTBBJTIzJTIwJTIwJTIwLi4uJTBBJTIzJTIwJTdE",highlighted:`<span class="hljs-keyword">import</span> requests <span class="hljs-comment"># pip install requests</span>
<span class="hljs-keyword">import</span> struct

<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_single_file</span>(<span class="hljs-params">url</span>):
    <span class="hljs-comment"># Fetch the first 8 bytes of the file</span>
    headers = {<span class="hljs-string">&#x27;Range&#x27;</span>: <span class="hljs-string">&#x27;bytes=0-7&#x27;</span>}
    response = requests.get(url, headers=headers)
    <span class="hljs-comment"># Interpret the bytes as a little-endian unsigned 64-bit integer</span>
    length_of_header = struct.unpack(<span class="hljs-string">&#x27;&lt;Q&#x27;</span>, response.content)[<span class="hljs-number">0</span>]
    <span class="hljs-comment"># Fetch length_of_header bytes starting from the 9th byte</span>
    headers = {<span class="hljs-string">&#x27;Range&#x27;</span>: <span class="hljs-string">f&#x27;bytes=8-<span class="hljs-subst">{<span class="hljs-number">7</span> + length_of_header}</span>&#x27;</span>}
    response = requests.get(url, headers=headers)
    <span class="hljs-comment"># Interpret the response as a JSON object</span>
    header = response.json()
    <span class="hljs-keyword">return</span> header

url = <span class="hljs-string">&quot;https://huggingface.co/gpt2/resolve/main/model.safetensors&quot;</span>
header = parse_single_file(url)

<span class="hljs-built_in">print</span>(header)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &quot;__metadata__&quot;: { &quot;format&quot;: &quot;pt&quot; },</span>
<span class="hljs-comment">#   &quot;h.10.ln_1.weight&quot;: {</span>
<span class="hljs-comment">#     &quot;dtype&quot;: &quot;F32&quot;,</span>
<span class="hljs-comment">#     &quot;shape&quot;: [768],</span>
<span class="hljs-comment">#     &quot;data_offsets&quot;: [223154176, 223157248]</span>
<span class="hljs-comment">#   },</span>
<span class="hljs-comment">#   ...</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),V=new W({props:{title:"Example output",local:"example-output",headingTag:"h2"}}),{c(){m=p("meta"),z=a(),x=p("p"),k=a(),J(w.$$.fragment),Y=a(),j=p("p"),j.innerHTML=Ms,A=a(),U=p("p"),U.innerHTML=Ts,F=a(),J(g.$$.fragment),v=a(),u=p("p"),u.textContent=ms,H=a(),d=p("div"),d.innerHTML=ds,X=a(),y=p("div"),y.innerHTML=ys,q=a(),J(f.$$.fragment),L=a(),J(I.$$.fragment),D=a(),b=p("p"),b.innerHTML=ws,P=a(),J(C.$$.fragment),O=a(),B=p("p"),B.textContent=js,K=a(),J(Z.$$.fragment),ss=a(),N=p("p"),N.innerHTML=Us,es=a(),J(_.$$.fragment),ls=a(),J(R.$$.fragment),ts=a(),G=p("p"),G.innerHTML=gs,as=a(),J(E.$$.fragment),ns=a(),J(V.$$.fragment),ps=a(),Q=p("p"),Q.innerHTML=us,is=a(),S=p("table"),S.innerHTML=fs,cs=a(),$=p("p"),this.h()},l(s){const e=_s("svelte-u9bgzb",document.head);m=i(e,"META",{name:!0,content:!0}),e.forEach(l),z=n(s),x=i(s,"P",{}),Is(x).forEach(l),k=n(s),o(w.$$.fragment,s),Y=n(s),j=i(s,"P",{"data-svelte-h":!0}),c(j)!=="svelte-buibb9"&&(j.innerHTML=Ms),A=n(s),U=i(s,"P",{"data-svelte-h":!0}),c(U)!=="svelte-yn06xm"&&(U.innerHTML=Ts),F=n(s),o(g.$$.fragment,s),v=n(s),u=i(s,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1njjf7m"&&(u.textContent=ms),H=n(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(d)!=="svelte-8bnguy"&&(d.innerHTML=ds),X=n(s),y=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(y)!=="svelte-1nx6ysg"&&(y.innerHTML=ys),q=n(s),o(f.$$.fragment,s),L=n(s),o(I.$$.fragment,s),D=n(s),b=i(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-141nxy4"&&(b.innerHTML=ws),P=n(s),o(C.$$.fragment,s),O=n(s),B=i(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-whtb1p"&&(B.textContent=js),K=n(s),o(Z.$$.fragment,s),ss=n(s),N=i(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1mtrq3h"&&(N.innerHTML=Us),es=n(s),o(_.$$.fragment,s),ls=n(s),o(R.$$.fragment,s),ts=n(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1mpl10c"&&(G.innerHTML=gs),as=n(s),o(E.$$.fragment,s),ns=n(s),o(V.$$.fragment,s),ps=n(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-6drwv0"&&(Q.innerHTML=us),is=n(s),S=i(s,"TABLE",{"data-svelte-h":!0}),c(S)!=="svelte-1p1f2se"&&(S.innerHTML=fs),cs=n(s),$=i(s,"P",{}),Is($).forEach(l),this.h()},h(){os(m,"name","hf:doc:metadata"),os(m,"content",Es),os(d,"class","flex justify-center"),os(y,"class","flex justify-center")},m(s,e){Rs(document.head,m),t(s,z,e),t(s,x,e),t(s,k,e),r(w,s,e),t(s,Y,e),t(s,j,e),t(s,A,e),t(s,U,e),t(s,F,e),r(g,s,e),t(s,v,e),t(s,u,e),t(s,H,e),t(s,d,e),t(s,X,e),t(s,y,e),t(s,q,e),r(f,s,e),t(s,L,e),r(I,s,e),t(s,D,e),t(s,b,e),t(s,P,e),r(C,s,e),t(s,O,e),t(s,B,e),t(s,K,e),r(Z,s,e),t(s,ss,e),t(s,N,e),t(s,es,e),r(_,s,e),t(s,ls,e),r(R,s,e),t(s,ts,e),t(s,G,e),t(s,as,e),r(E,s,e),t(s,ns,e),r(V,s,e),t(s,ps,e),t(s,Q,e),t(s,is,e),t(s,S,e),t(s,cs,e),t(s,$,e),Js=!0},p:Cs,i(s){Js||(h(w.$$.fragment,s),h(g.$$.fragment,s),h(f.$$.fragment,s),h(I.$$.fragment,s),h(C.$$.fragment,s),h(Z.$$.fragment,s),h(_.$$.fragment,s),h(R.$$.fragment,s),h(E.$$.fragment,s),h(V.$$.fragment,s),Js=!0)},o(s){M(w.$$.fragment,s),M(g.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(C.$$.fragment,s),M(Z.$$.fragment,s),M(_.$$.fragment,s),M(R.$$.fragment,s),M(E.$$.fragment,s),M(V.$$.fragment,s),Js=!1},d(s){s&&(l(z),l(x),l(k),l(Y),l(j),l(A),l(U),l(F),l(v),l(u),l(H),l(d),l(X),l(y),l(q),l(L),l(D),l(b),l(P),l(O),l(B),l(K),l(ss),l(N),l(es),l(ls),l(ts),l(G),l(as),l(ns),l(ps),l(Q),l(is),l(S),l(cs),l($)),l(m),T(w,s),T(g,s),T(f,s),T(I,s),T(C,s),T(Z,s),T(_,s),T(R,s),T(E,s),T(V,s)}}}const Es='{"title":"Metadata Parsing","local":"metadata-parsing","sections":[{"title":"Example use case","local":"example-use-case","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"JavaScript/TypeScript","local":"js","sections":[],"depth":3},{"title":"Python","local":"python","sections":[],"depth":3}],"depth":2},{"title":"Example output","local":"example-output","sections":[],"depth":2}],"depth":1}';function Vs(hs){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends Zs{constructor(m){super(),Ns(this,m,Vs,Gs,bs,{})}}export{$s as component};
