import{s as Mt,a as bt,n as yt,o as Tt}from"../chunks/scheduler.9cda857a.js";import{S as jt,i as Jt,e as n,s as l,c as p,h as St,a as o,d as s,b as i,f as Fe,j as r,g as c,k as g,l as vt,m as a,n as m,t as h,o as d,p as u}from"../chunks/index.f47f3121.js";import{C as $t}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as le}from"../chunks/CodeBlock.24d62f98.js";import{H as te,E as Ut}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function It(Ae){let w,ie,se,ne,M,Pe=`<p>The option to use Streamlit as the default built-in SDK for Spaces is deprecated.
If you wish to deploy a Space with Streamlit, please pick the Docker SDK, then use the Streamlit template.</p> <div class="flex justify-center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-streamlit-docker-sdk.png"/></div>`,oe,T,re,j,pe,J,Xe='<strong>Streamlit</strong> gives users freedom to build a full-featured web app with Python in a <em>reactive</em> way. Your code is rerun each time the state of the app changes. Streamlit is also great for data visualization and supports several charting libraries such as Bokeh, Plotly, and Altair. Read this <a href="https://huggingface.co/blog/streamlit-spaces" rel="nofollow">blog post</a> about building and hosting Streamlit apps in Spaces.',ce,S,De='Selecting <strong>Streamlit</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Space with the latest version of Streamlit by setting the <code>sdk</code> property to <code>streamlit</code> in your <code>README.md</code> file’s YAML block. If you’d like to change the Streamlit version, you can edit the <code>sdk_version</code> property.',me,v,Ve='To use Streamlit in a Space, select <strong>Streamlit</strong> as the SDK when you create a Space through the <a href="https://huggingface.co/new-space" rel="nofollow"><strong>New Space</strong> form</a>. This will create a repository with a <code>README.md</code> that contains the following properties in the YAML configuration block:',he,$,de,U,Ke='You can edit the <code>sdk_version</code>, but note that issues may occur when you use an unsupported Streamlit version. Not all Streamlit versions are supported, so please refer to the <a href="./spaces-config-reference">reference section</a> to see which versions are available.',ue,I,Oe='For in-depth information about Streamlit, refer to the <a href="https://docs.streamlit.io/" rel="nofollow">Streamlit documentation</a>.',fe,b,et="<p>Only port 8501 is allowed for Streamlit Spaces (default port). As a result if you provide a <code>config.toml</code> file for your Space make sure the default port is not overridden.</p>",ge,k,we,B,tt='In the following sections, you’ll learn the basics of creating a Space, configuring it, and deploying your code to it. We’ll create a <strong>Hot Dog Classifier</strong> Space with Streamlit that’ll be used to demo the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which can detect whether a given picture contains a hot dog 🌭',Me,Z,st='You can find a completed version of this hosted at <a href="https://huggingface.co/spaces/NimaBoscarino/hotdog-streamlit" rel="nofollow">NimaBoscarino/hotdog-streamlit</a>.',be,L,ye,H,at='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Streamlit</strong> as our SDK. Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing.',Te,C,je,W,lt='For the <strong>Hot Dog Classifier</strong> we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model, so we need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',Je,x,Se,z,it="The Spaces runtime will handle installing the dependencies!",ve,_,$e,N,nt="To create the Streamlit app, make a new file in the repository called <strong>app.py</strong>, and add the following code:",Ue,Q,Ie,R,ot='This Python script uses a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to load the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which is used by the Streamlit interface. The Streamlit app will expect you to upload an image, which it’ll then classify as <em>hot dog</em> or <em>not hot dog</em>. Once you’ve saved the code to the <strong>app.py</strong> file, visit the <strong>App</strong> tab to see your app in action!',ke,y,rt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit-dark.png"/>',Be,G,Ze,q,pt="You can use the HTML <code>&lt;iframe&gt;</code> tag to embed a Streamlit Space as an inline frame on other webpages. Simply include the URL of your Space, ending with the <code>.hf.space</code> suffix. To find the URL of your Space, you can use the “Embed this Space” button from the Spaces options.",Le,E,ct="For example, the demo above can be embedded in these docs with the following tag:",He,Y,Ce,f,mt,We,F,ht="Please note that we have added <code>?embed=true</code> to the URL, which activates the embed mode of the Streamlit app, removing some spacers and the footer for slim embeds.",xe,A,ze,P,dt='Streamlit has supported automatic iframe resizing since <a href="https://docs.streamlit.io/library/changelog#version-1170" rel="nofollow">1.17.0</a> so that the size of the parent iframe is automatically adjusted to fit the content volume of the embedded Streamlit application.',_e,X,ut='It relies on the <a href="https://github.com/davidjbradshaw/iframe-resizer" rel="nofollow"><code>iFrame Resizer</code></a> library, for which you need to add a few lines of code, as in the following example where',Ne,D,ft="<li><code>id</code> is set to <code>&lt;iframe /&gt;</code> that is used to specify the auto-resize target.</li> <li>The <code>iFrame Resizer</code> is loaded via the <code>script</code> tag.</li> <li>The <code>iFrameResize()</code> function is called with the ID of the target <code>iframe</code> element, so that its size changes automatically.</li>",Qe,V,gt='We can pass options to the first argument of <code>iFrameResize()</code>. See <a href="https://github.com/davidjbradshaw/iframe-resizer/blob/master/docs/parent_page/options.md" rel="nofollow">the document</a> for the details.',Re,K,Ge,O,wt='Additionally, you can checkout <a href="./spaces-embed">our documentation</a>.',qe,ee,Ee,ae,Ye;return T=new $t({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new te({props:{title:"Streamlit Spaces",local:"streamlit-spaces",headingTag:"h1"}}),$=new le({props:{code:"c2RrJTNBJTIwc3RyZWFtbGl0JTBBc2RrX3ZlcnNpb24lM0ElMjAxLjI1LjAlMjAlMjMlMjBUaGUlMjBsYXRlc3QlMjBzdXBwb3J0ZWQlMjB2ZXJzaW9u",highlighted:`<span class="hljs-attr">sdk:</span> <span class="hljs-string">streamlit</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">1.25</span><span class="hljs-number">.0</span> <span class="hljs-comment"># The latest supported version</span>`,wrap:!1}}),k=new te({props:{title:"Your First Streamlit Space: Hot Dog Classifier",local:"your-first-streamlit-space-hot-dog-classifier",headingTag:"h2"}}),L=new te({props:{title:"Create a new Streamlit Space",local:"create-a-new-streamlit-space",headingTag:"h2"}}),C=new te({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),x=new le({props:{code:"dHJhbnNmb3JtZXJzJTBBdG9yY2g=",highlighted:`<span class="hljs-attribute">transformers
torch</span>`,wrap:!1}}),_=new te({props:{title:"Create the Streamlit app",local:"create-the-streamlit-app",headingTag:"h2"}}),Q=new le({props:{code:"aW1wb3J0JTIwc3RyZWFtbGl0JTIwYXMlMjBzdCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRmhvdGRvZy1ub3QtaG90ZG9nJTIyKSUwQSUwQXN0LnRpdGxlKCUyMkhvdCUyMERvZyUzRiUyME9yJTIwTm90JTNGJTIyKSUwQSUwQWZpbGVfbmFtZSUyMCUzRCUyMHN0LmZpbGVfdXBsb2FkZXIoJTIyVXBsb2FkJTIwYSUyMGhvdCUyMGRvZyUyMGNhbmRpZGF0ZSUyMGltYWdlJTIyKSUwQSUwQWlmJTIwZmlsZV9uYW1lJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwY29sMSUyQyUyMGNvbDIlMjAlM0QlMjBzdC5jb2x1bW5zKDIpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGZpbGVfbmFtZSklMEElMjAlMjAlMjAlMjBjb2wxLmltYWdlKGltYWdlJTJDJTIwdXNlX2NvbHVtbl93aWR0aCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBwaXBlbGluZShpbWFnZSklMEElMEElMjAlMjAlMjAlMjBjb2wyLmhlYWRlciglMjJQcm9iYWJpbGl0aWVzJTIyKSUwQSUyMCUyMCUyMCUyMGZvciUyMHAlMjBpbiUyMHByZWRpY3Rpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sMi5zdWJoZWFkZXIoZiUyMiU3QiUyMHAlNUInbGFiZWwnJTVEJTIwJTdEJTNBJTIwJTdCJTIwcm91bmQocCU1QidzY29yZSclNUQlMjAqJTIwMTAwJTJDJTIwMSklN0QlMjUlMjIp",highlighted:`<span class="hljs-keyword">import</span> streamlit <span class="hljs-keyword">as</span> st
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;julien-c/hotdog-not-hotdog&quot;</span>)

st.title(<span class="hljs-string">&quot;Hot Dog? Or Not?&quot;</span>)

file_name = st.file_uploader(<span class="hljs-string">&quot;Upload a hot dog candidate image&quot;</span>)

<span class="hljs-keyword">if</span> file_name <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    col1, col2 = st.columns(<span class="hljs-number">2</span>)

    image = Image.<span class="hljs-built_in">open</span>(file_name)
    col1.image(image, use_column_width=<span class="hljs-literal">True</span>)
    predictions = pipeline(image)

    col2.header(<span class="hljs-string">&quot;Probabilities&quot;</span>)
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> predictions:
        col2.subheader(<span class="hljs-string">f&quot;<span class="hljs-subst">{ p[<span class="hljs-string">&#x27;label&#x27;</span>] }</span>: <span class="hljs-subst">{ <span class="hljs-built_in">round</span>(p[<span class="hljs-string">&#x27;score&#x27;</span>] * <span class="hljs-number">100</span>, <span class="hljs-number">1</span>)}</span>%&quot;</span>)`,wrap:!1}}),G=new te({props:{title:"Embed Streamlit Spaces on other webpages",local:"embed-streamlit-spaces-on-other-webpages",headingTag:"h2"}}),Y=new le({props:{code:"JTNDaWZyYW1lJTBBJTIwJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZOaW1hQm9zY2FyaW5vLWhvdGRvZy1zdHJlYW1saXQuaGYuc3BhY2UlM0ZlbWJlZCUzRHRydWUlMjIlMEElMjAlMjB0aXRsZSUzRCUyMk15JTIwYXdlc29tZSUyMFN0cmVhbWxpdCUyMFNwYWNlJTIyJTBBJTNFJTNDJTJGaWZyYW1lJTNF",highlighted:`&lt;iframe
  src<span class="hljs-operator">=</span><span class="hljs-string">&quot;https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true&quot;</span>
  title<span class="hljs-operator">=</span><span class="hljs-string">&quot;My awesome Streamlit Space&quot;</span>
&gt;&lt;/iframe&gt;`,wrap:!1}}),A=new te({props:{title:"Embed Streamlit Spaces with auto-resizing IFrames",local:"embed-streamlit-spaces-with-auto-resizing-iframes",headingTag:"h2"}}),K=new le({props:{code:"JTNDaWZyYW1lJTBBJTA5aWQlM0QlMjJ5b3VyLWlmcmFtZS1pZCUyMiUwQSUwOXNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGJTNDc3BhY2Utc3ViZG9tYWluJTNFLmhmLnNwYWNlJTIyJTBBJTA5ZnJhbWVib3JkZXIlM0QlMjIwJTIyJTBBJTA5d2lkdGglM0QlMjI4NTAlMjIlMEElMDloZWlnaHQlM0QlMjI0NTAlMjIlMEElM0UlM0MlMkZpZnJhbWUlM0UlMEElM0NzY3JpcHQlMjBzcmMlM0QlMjJodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkZpZnJhbWUtcmVzaXplciU0MDQuMy40JTJGanMlMkZpZnJhbWVSZXNpemVyLm1pbi5qcyUyMiUzRSUzQyUyRnNjcmlwdCUzRSUwQSUzQ3NjcmlwdCUzRSUwQSUyMCUyMGlGcmFtZVJlc2l6ZSglN0IlN0QlMkMlMjAlMjIlMjN5b3VyLWlmcmFtZS1pZCUyMiklMEElM0MlMkZzY3JpcHQlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">iframe</span>
	<span class="hljs-attr">id</span>=<span class="hljs-string">&quot;your-iframe-id&quot;</span>
	<span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://&lt;space-subdomain&gt;.hf.space&quot;</span>
	<span class="hljs-attr">frameborder</span>=<span class="hljs-string">&quot;0&quot;</span>
	<span class="hljs-attr">width</span>=<span class="hljs-string">&quot;850&quot;</span>
	<span class="hljs-attr">height</span>=<span class="hljs-string">&quot;450&quot;</span>
&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">iframe</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/iframe-resizer@4.3.4/js/iframeResizer.min.js&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span>&gt;</span><span class="language-javascript">
  <span class="hljs-title function_">iFrameResize</span>({}, <span class="hljs-string">&quot;#your-iframe-id&quot;</span>)
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),ee=new Ut({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-sdks-streamlit.md"}}),{c(){w=n("meta"),ie=l(),se=n("p"),ne=l(),M=n("blockquote"),M.innerHTML=Pe,oe=l(),p(T.$$.fragment),re=l(),p(j.$$.fragment),pe=l(),J=n("p"),J.innerHTML=Xe,ce=l(),S=n("p"),S.innerHTML=De,me=l(),v=n("p"),v.innerHTML=Ve,he=l(),p($.$$.fragment),de=l(),U=n("p"),U.innerHTML=Ke,ue=l(),I=n("p"),I.innerHTML=Oe,fe=l(),b=n("blockquote"),b.innerHTML=et,ge=l(),p(k.$$.fragment),we=l(),B=n("p"),B.innerHTML=tt,Me=l(),Z=n("p"),Z.innerHTML=st,be=l(),p(L.$$.fragment),ye=l(),H=n("p"),H.innerHTML=at,Te=l(),p(C.$$.fragment),je=l(),W=n("p"),W.innerHTML=lt,Je=l(),p(x.$$.fragment),Se=l(),z=n("p"),z.textContent=it,ve=l(),p(_.$$.fragment),$e=l(),N=n("p"),N.innerHTML=nt,Ue=l(),p(Q.$$.fragment),Ie=l(),R=n("p"),R.innerHTML=ot,ke=l(),y=n("div"),y.innerHTML=rt,Be=l(),p(G.$$.fragment),Ze=l(),q=n("p"),q.innerHTML=pt,Le=l(),E=n("p"),E.textContent=ct,He=l(),p(Y.$$.fragment),Ce=l(),f=n("iframe"),We=l(),F=n("p"),F.innerHTML=ht,xe=l(),p(A.$$.fragment),ze=l(),P=n("p"),P.innerHTML=dt,_e=l(),X=n("p"),X.innerHTML=ut,Ne=l(),D=n("ul"),D.innerHTML=ft,Qe=l(),V=n("p"),V.innerHTML=gt,Re=l(),p(K.$$.fragment),Ge=l(),O=n("p"),O.innerHTML=wt,qe=l(),p(ee.$$.fragment),Ee=l(),ae=n("p"),this.h()},l(e){const t=St("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),ie=i(e),se=o(e,"P",{}),Fe(se).forEach(s),ne=i(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-15gqg3q"&&(M.innerHTML=Pe),oe=i(e),c(T.$$.fragment,e),re=i(e),c(j.$$.fragment,e),pe=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-155nn9c"&&(J.innerHTML=Xe),ce=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-fhngw3"&&(S.innerHTML=De),me=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1lndvi6"&&(v.innerHTML=Ve),he=i(e),c($.$$.fragment,e),de=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-rlzh8f"&&(U.innerHTML=Ke),ue=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1i51m04"&&(I.innerHTML=Oe),fe=i(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1an92vd"&&(b.innerHTML=et),ge=i(e),c(k.$$.fragment,e),we=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-w37as0"&&(B.innerHTML=tt),Me=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1yuvt6i"&&(Z.innerHTML=st),be=i(e),c(L.$$.fragment,e),ye=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-7i2a6u"&&(H.innerHTML=at),Te=i(e),c(C.$$.fragment,e),je=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-12qvnza"&&(W.innerHTML=lt),Je=i(e),c(x.$$.fragment,e),Se=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-pc1ide"&&(z.textContent=it),ve=i(e),c(_.$$.fragment,e),$e=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1s8aj3m"&&(N.innerHTML=nt),Ue=i(e),c(Q.$$.fragment,e),Ie=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1lyf612"&&(R.innerHTML=ot),ke=i(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-10soa41"&&(y.innerHTML=rt),Be=i(e),c(G.$$.fragment,e),Ze=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-h9u7cp"&&(q.innerHTML=pt),Le=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-m5fkq0"&&(E.textContent=ct),He=i(e),c(Y.$$.fragment,e),Ce=i(e),f=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Fe(f).forEach(s),We=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-190mgpd"&&(F.innerHTML=ht),xe=i(e),c(A.$$.fragment,e),ze=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1pycgf5"&&(P.innerHTML=dt),_e=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1na14o1"&&(X.innerHTML=ut),Ne=i(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-13i7z0x"&&(D.innerHTML=ft),Qe=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hn154n"&&(V.innerHTML=gt),Re=i(e),c(K.$$.fragment,e),Ge=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-18gaz5u"&&(O.innerHTML=wt),qe=i(e),c(ee.$$.fragment,e),Ee=i(e),ae=o(e,"P",{}),Fe(ae).forEach(s),this.h()},h(){g(w,"name","hf:doc:metadata"),g(w,"content",kt),g(M,"class","warning"),g(b,"class","warning"),g(y,"class","flex justify-center"),bt(f.src,mt="https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true")||g(f,"src",mt),g(f,"frameborder","0"),g(f,"height","364"),g(f,"title","Streamlit app"),g(f,"class","container p-0 grow space-iframe"),g(f,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),g(f,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){vt(document.head,w),a(e,ie,t),a(e,se,t),a(e,ne,t),a(e,M,t),a(e,oe,t),m(T,e,t),a(e,re,t),m(j,e,t),a(e,pe,t),a(e,J,t),a(e,ce,t),a(e,S,t),a(e,me,t),a(e,v,t),a(e,he,t),m($,e,t),a(e,de,t),a(e,U,t),a(e,ue,t),a(e,I,t),a(e,fe,t),a(e,b,t),a(e,ge,t),m(k,e,t),a(e,we,t),a(e,B,t),a(e,Me,t),a(e,Z,t),a(e,be,t),m(L,e,t),a(e,ye,t),a(e,H,t),a(e,Te,t),m(C,e,t),a(e,je,t),a(e,W,t),a(e,Je,t),m(x,e,t),a(e,Se,t),a(e,z,t),a(e,ve,t),m(_,e,t),a(e,$e,t),a(e,N,t),a(e,Ue,t),m(Q,e,t),a(e,Ie,t),a(e,R,t),a(e,ke,t),a(e,y,t),a(e,Be,t),m(G,e,t),a(e,Ze,t),a(e,q,t),a(e,Le,t),a(e,E,t),a(e,He,t),m(Y,e,t),a(e,Ce,t),a(e,f,t),a(e,We,t),a(e,F,t),a(e,xe,t),m(A,e,t),a(e,ze,t),a(e,P,t),a(e,_e,t),a(e,X,t),a(e,Ne,t),a(e,D,t),a(e,Qe,t),a(e,V,t),a(e,Re,t),m(K,e,t),a(e,Ge,t),a(e,O,t),a(e,qe,t),m(ee,e,t),a(e,Ee,t),a(e,ae,t),Ye=!0},p:yt,i(e){Ye||(h(T.$$.fragment,e),h(j.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(L.$$.fragment,e),h(C.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),Ye=!0)},o(e){d(T.$$.fragment,e),d(j.$$.fragment,e),d($.$$.fragment,e),d(k.$$.fragment,e),d(L.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(G.$$.fragment,e),d(Y.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),Ye=!1},d(e){e&&(s(ie),s(se),s(ne),s(M),s(oe),s(re),s(pe),s(J),s(ce),s(S),s(me),s(v),s(he),s(de),s(U),s(ue),s(I),s(fe),s(b),s(ge),s(we),s(B),s(Me),s(Z),s(be),s(ye),s(H),s(Te),s(je),s(W),s(Je),s(Se),s(z),s(ve),s($e),s(N),s(Ue),s(Ie),s(R),s(ke),s(y),s(Be),s(Ze),s(q),s(Le),s(E),s(He),s(Ce),s(f),s(We),s(F),s(xe),s(ze),s(P),s(_e),s(X),s(Ne),s(D),s(Qe),s(V),s(Re),s(Ge),s(O),s(qe),s(Ee),s(ae)),s(w),u(T,e),u(j,e),u($,e),u(k,e),u(L,e),u(C,e),u(x,e),u(_,e),u(Q,e),u(G,e),u(Y,e),u(A,e),u(K,e),u(ee,e)}}}const kt='{"title":"Streamlit Spaces","local":"streamlit-spaces","sections":[{"title":"Your First Streamlit Space: Hot Dog Classifier","local":"your-first-streamlit-space-hot-dog-classifier","sections":[],"depth":2},{"title":"Create a new Streamlit Space","local":"create-a-new-streamlit-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the Streamlit app","local":"create-the-streamlit-app","sections":[],"depth":2},{"title":"Embed Streamlit Spaces on other webpages","local":"embed-streamlit-spaces-on-other-webpages","sections":[],"depth":2},{"title":"Embed Streamlit Spaces with auto-resizing IFrames","local":"embed-streamlit-spaces-with-auto-resizing-iframes","sections":[],"depth":2}],"depth":1}';function Bt(Ae){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends jt{constructor(w){super(),Jt(this,w,Bt,It,Mt,{})}}export{xt as component};
