import{s as Ha,n as Ya,o as Da}from"../chunks/scheduler.9cda857a.js";import{S as La,i as Ga,e as p,s as l,c as i,h as Pa,a as o,d as a,b as e,f as Ra,g as c,j as u,k as Xt,l as Oa,m as n,n as M,t as h,o as j,p as r}from"../chunks/index.f47f3121.js";import{C as _a}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as J}from"../chunks/CodeBlock.24d62f98.js";import{H as y,E as Va}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function Xa(Ft){let d,Ss,Es,Ns,f,Bs,w,Ws,T,Kt="<p>Webhooks are now publicly available!</p>",xs,U,sa="Webhooks are a foundation for MLOps-related features. They allow you to listen for new changes on specific repos or to all repos belonging to particular set of users/organizations (not just your repos, but any repo).",Qs,q,ta="You can use them to auto-convert models, build community bots, or build CI/CD for your models, datasets, and Spaces (and much more!).",zs,g,aa="The documentation for Webhooks is below – or you can also browse our <strong>guides</strong> showcasing a few possible use cases of Webhooks:",Rs,b,na='<li><a href="./webhooks-guide-auto-retrain">Fine-tune a new model whenever a dataset gets updated (Python)</a></li> <li><a href="./webhooks-guide-discussion-bot">Create a discussion bot on the Hub, using a LLM API (NodeJS)</a></li> <li><a href="./webhooks-guide-metadata-review">Create metadata quality reports (Python)</a></li> <li>and more to come…</li>',Hs,I,Ys,v,la='You can create new Webhooks and edit existing ones in your Webhooks <a href="https://huggingface.co/settings/webhooks" rel="nofollow">settings</a>:',Ds,$,ea='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhook-settings.png" alt="Settings of an individual webhook"/>',Ls,C,pa="Webhooks can watch for repos updates, Pull Requests, discussions, and new comments. It’s even possible to create a Space to react to your Webhooks!",Gs,k,Ps,A,oa="After registering a Webhook, you will be notified of new events via an <code>HTTP POST</code> call on the specified target URL. The payload is encoded in JSON.",Os,E,ua="You can view the history of payloads sent in the activity tab of the webhook settings page, it’s also possible to replay past webhooks for easier debugging:",_s,Z,ia='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhook-activity.png" alt="image.png"/>',Vs,S,ca="As an example, here is the full payload when a Pull Request is opened:",Xs,N,Fs,B,Ks,W,Ma="The top-level properties <code>event</code> is always specified and used to determine the nature of the event.",st,x,ha="It has two sub-properties: <code>event.action</code> and <code>event.scope</code>.",tt,Q,ja="<code>event.scope</code> will be one of the following values:",at,z,ra="<li><code>&quot;repo&quot;</code> - Global events on repos. Possible values for the associated <code>action</code>: <code>&quot;create&quot;</code>, <code>&quot;delete&quot;</code>, <code>&quot;update&quot;</code>, <code>&quot;move&quot;</code>.</li> <li><code>&quot;repo.content&quot;</code> - Events on the repo’s content, such as new commits or tags. It triggers on new Pull Requests as well due to the newly created reference/commit. The associated <code>action</code> is always <code>&quot;update&quot;</code>.</li> <li><code>&quot;repo.config&quot;</code> - Events on the config: update Space secrets, update settings, update DOIs, disabled or not, etc. The associated <code>action</code> is always <code>&quot;update&quot;</code>.</li> <li><code>&quot;discussion&quot;</code> - Creating a discussion or Pull Request, updating the title or status, and merging. Possible values for the associated <code>action</code>: <code>&quot;create&quot;</code>, <code>&quot;delete&quot;</code>, <code>&quot;update&quot;</code>.</li> <li><code>&quot;discussion.comment&quot;</code> - Creating, updating, and hiding a comment. Possible values for the associated <code>action</code>: <code>&quot;create&quot;</code>, <code>&quot;update&quot;</code>.</li>",nt,R,ya="More scopes can be added in the future. To handle unknown events, your webhook handler can consider any action on a narrowed scope to be an <code>&quot;update&quot;</code> action on the broader scope.",lt,H,da="For example, if the <code>&quot;repo.config.dois&quot;</code> scope is added in the future, any event with that scope can be considered by your webhook handler as an <code>&quot;update&quot;</code> action on the <code>&quot;repo.config&quot;</code> scope.",et,Y,pt,D,Ta="In the current version of webhooks, the top-level property <code>repo</code> is always specified, as events can always be associated with a repo. For example, consider the following value:",ot,L,ut,G,ma="<code>repo.headSha</code> is the sha of the latest commit on the repo’s <code>main</code> branch. It is only sent when <code>event.scope</code> starts with <code>&quot;repo&quot;</code>, not on community events like discussions and comments.",it,P,ct,O,Ja="On code changes, the top-level property <code>updatedRefs</code> is specified on repo events. It is an array of references that have been updated. Here is an example value:",Mt,_,ht,V,fa="Newly created references will have <code>oldSha</code> set to <code>null</code>. Deleted references will have <code>newSha</code> set to <code>null</code>.",jt,X,wa="You can react to new commits on specific pull requests, new tags, or new branches.",rt,F,yt,K,Ua="When the top-level property <code>event.scope</code> is <code>&quot;repo.config&quot;</code>, the <code>updatedConfig</code> property is specified. It is an object containing the updated config. Here is an example value:",dt,ss,Tt,ts,qa="or",mt,as,Jt,ns,ga="or, when the updated config key is not supported by the webhook:",ft,ls,wt,es,ba='For now only <code>private</code> and <code>xetEnabled</code> are supported. If you would benefit from more config keys being present here, please let us know at <a href="mailto:website@huggingface.co">website@huggingface.co</a>.',Ut,ps,qt,os,Ia="The top-level property <code>discussion</code> is specified on community events (discussions and Pull Requests). The <code>discussion.isPullRequest</code> property is a boolean indicating if the discussion is also a Pull Request (on the Hub, a PR is a special type of discussion). Here is an example value:",gt,us,bt,is,It,cs,va="The top level property <code>comment</code> is specified when a comment is created (including on discussion creation) or updated. Here is an example value:",vt,Ms,$t,hs,Ct,js,$a="Setting a Webhook secret is useful to make sure payloads sent to your Webhook handler URL are actually from Hugging Face.",kt,rs,Ca="If you set a secret for your Webhook, it will be sent along as an <code>X-Webhook-Secret</code> HTTP header on every request. Only ASCII characters are supported.",At,m,ka='<p>It’s also possible to add the secret directly in the handler URL. For example, setting it as a query parameter: <a href="https://example.com/webhook?secret=XXX" rel="nofollow">https://example.com/webhook?secret=XXX</a>.</p> <p>This can be helpful if accessing the HTTP headers of the request is complicated for your Webhook handler.</p>',Et,ys,Zt,ds,Aa="Each Webhook is limited to 1,000 triggers per 24 hours. You can view your usage in the Webhook settings page in the “Activity” tab.",St,Ts,Ea='If you need to increase the number of triggers for your Webhook, upgrade to PRO, Team or Enterprise and contact us at <a href="mailto:website@huggingface.co">website@huggingface.co</a>.',Nt,ms,Bt,Js,Za='If you do not have an HTTPS endpoint/URL, you can try out public tools for webhook testing. These tools act as catch-all (capture all requests) sent to them and give 200 OK status code. <a href="https://beeceptor.com/" rel="nofollow">Beeceptor</a> is one tool you can use to create a temporary HTTP endpoint and review the incoming payload. Another such tool is <a href="https://webhook.site/" rel="nofollow">Webhook.site</a>.',Wt,fs,Sa='Additionally, you can route a real Webhook payload to the code running locally on your machine during development. This is a great way to test and debug for faster integrations. You can do this by exposing your localhost port to the Internet. To be able to go this path, you can use <a href="https://ngrok.com/" rel="nofollow">ngrok</a> or <a href="https://theboroer.github.io/localtunnel-www/" rel="nofollow">localtunnel</a>.',xt,ws,Qt,Us,Na="You can easily find recently generated events for your webhooks. Open the activity tab for your webhook. There you will see the list of recent events.",zt,qs,Ba='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhook-payload.png" alt="image.png"/>',Rt,gs,Wa="Here you can review the HTTP status code and the payload of the generated events. Additionally, you can replay these events by clicking on the <code>Replay</code> button!",Ht,bs,xa="Note: When changing the target URL or secret of a Webhook, replaying an event will send the payload to the updated URL.",Yt,Is,Dt,vs,Lt,$s,Qa="No, this is not currently supported.",Gt,Cs,Pt,ks,za='This is not currently exposed to end users but we can toggle this for you if you send an email to <a href="mailto:website@huggingface.co">website@huggingface.co</a>.',Ot,As,_t,Zs,Vt;return f=new _a({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new y({props:{title:"Webhooks",local:"webhooks",headingTag:"h1"}}),I=new y({props:{title:"Create your Webhook",local:"create-your-webhook",headingTag:"h2"}}),k=new y({props:{title:"Webhook Payloads",local:"webhook-payloads",headingTag:"h2"}}),N=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyZXZlbnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJjcmVhdGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzY29wZSUyMiUzQSUyMCUyMmRpc2N1c3Npb24lMjIlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJyZXBvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjAlMjI2MjFmZmRjMDM2NDY4ZDcwOWYxNzQzNGQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwcml2YXRlJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjJ1cmwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWIlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJhcGklMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGYXBpJTJGbW9kZWxzJTJGb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJvd25lciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmlkJTIyJTNBJTIwJTIyNjI4Yjc1MzI4M2VmNTliNWJlODllOTM3JTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGlzY3Vzc2lvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlkJTIyJTNBJTIwJTIyNjM5OWY1ODUxODcyMWZkZDI3ZmM5Y2E5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJVcGRhdGUlMjBjbzIlMjBlbWlzc2lvbnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ1cmwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWIlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMkZkaXNjdXNzaW9ucyUyRjE5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXBpJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmFwaSUyRm1vZGVscyUyRm9wZW5haS1jb21tdW5pdHklMkZncHQyJTJGZGlzY3Vzc2lvbnMlMkYxOSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMm9wZW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdXRob3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJpZCUyMiUzQSUyMCUyMjYxZDJmOTBjM2MyMDgzZTFjMDhhZjIyZCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bSUyMiUzQSUyMDE5JTJDJTBBJTIwJTIwJTIwJTIwJTIyaXNQdWxsUmVxdWVzdCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGFuZ2VzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmFzZSUyMiUzQSUyMCUyMnJlZnMlMkZoZWFkcyUyRm1haW4lMjIlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJjb21tZW50JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjAlMjI2Mzk5ZjU4NTE4NzIxZmRkMjdmYzljYWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdXRob3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJpZCUyMiUzQSUyMCUyMjYxZDJmOTBjM2MyMDgzZTFjMDhhZjIyZCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJBZGQlMjBjbzIlMjBlbWlzc2lvbnMlMjBpbmZvcm1hdGlvbiUyMHRvJTIwdGhlJTIwbW9kZWwlMjBjYXJkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGlkZGVuJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjJ1cmwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWIlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMkZkaXNjdXNzaW9ucyUyRjE5JTIzNjM5OWY1ODUxODcyMWZkZDI3ZmM5Y2FhJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyd2ViaG9vayUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlkJTIyJTNBJTIwJTIyNjM5MGU4NTVlMzBkOTIwOTQxMWRlOTNiJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmVyc2lvbiUyMiUzQSUyMDMlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;event&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;create&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scope&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;discussion&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;model&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;openai-community/gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;621ffdc036468d709f17434d&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;private&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;web&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/openai-community/gpt2&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;api&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/api/models/openai-community/gpt2&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;owner&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;628b753283ef59b5be89e937&quot;</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;discussion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;6399f58518721fdd27fc9ca9&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;title&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Update co2 emissions&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;web&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/openai-community/gpt2/discussions/19&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;api&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/api/models/openai-community/gpt2/discussions/19&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;open&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;author&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;61d2f90c3c2083e1c08af22d&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">19</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;isPullRequest&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;changes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;base&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;refs/heads/main&quot;</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;comment&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;6399f58518721fdd27fc9caa&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;author&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;61d2f90c3c2083e1c08af22d&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Add co2 emissions information to the model card&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;hidden&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;web&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/openai-community/gpt2/discussions/19#6399f58518721fdd27fc9caa&quot;</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;webhook&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;6390e855e30d9209411de93b&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),B=new y({props:{title:"Event",local:"event",headingTag:"h3"}}),Y=new y({props:{title:"Repo",local:"repo",headingTag:"h3"}}),L=new J({props:{code:"JTIycmVwbyUyMiUzQSUyMCU3QiUwQSUwOSUyMnR5cGUlMjIlM0ElMjAlMjJtb2RlbCUyMiUyQyUwQSUwOSUyMm5hbWUlMjIlM0ElMjAlMjJzb21lLXVzZXIlMkZzb21lLXJlcG8lMjIlMkMlMEElMDklMjJpZCUyMiUzQSUyMCUyMjYzNjZjMDAwYTJhYmNkZjJmZDY5YTA4MCUyMiUyQyUwQSUwOSUyMnByaXZhdGUlMjIlM0ElMjBmYWxzZSUyQyUwQSUwOSUyMnVybCUyMiUzQSUyMCU3QiUwQSUwOSUwOSUyMndlYiUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzb21lLXVzZXIlMkZzb21lLXJlcG8lMjIlMkMlMEElMDklMDklMjJhcGklMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGYXBpJTJGbW9kZWxzJTJGc29tZS11c2VyJTJGc29tZS1yZXBvJTIyJTBBJTA5JTdEJTJDJTBBJTA5JTIyaGVhZFNoYSUyMiUzQSUyMCUyMmMzNzllODIxYzljOTVkNjEzODk5ZThjNDM0M2U0YmZlZTJiMGM2MDAlMjIlMkMlMEElMDklMjJ0YWdzJTIyJTNBJTIwJTVCJTBBJTA5JTA5JTIybGljZW5zZSUzQW90aGVyJTIyJTJDJTBBJTA5JTA5JTIyaGFzX3NwYWNlJTIyJTBBJTA5JTVEJTJDJTBBJTA5JTIyb3duZXIlMjIlM0ElMjAlN0IlMEElMDklMDklMjJpZCUyMiUzQSUyMCUyMjYxZDIwMDBjM2MyMDgzZTFjMDhhZjIyZCUyMiUwQSUwOSU3RCUwQSU3RA==",highlighted:`<span class="hljs-attr">&quot;repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;model&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;some-user/some-repo&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;6366c000a2abcdf2fd69a080&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;private&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;web&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/some-user/some-repo&quot;</span><span class="hljs-punctuation">,</span>
		<span class="hljs-attr">&quot;api&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/api/models/some-user/some-repo&quot;</span>
	<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;headSha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;c379e821c9c95d613899e8c4343e4bfee2b0c600&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
		<span class="hljs-string">&quot;license:other&quot;</span><span class="hljs-punctuation">,</span>
		<span class="hljs-string">&quot;has_space&quot;</span>
	<span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;owner&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;61d2000c3c2083e1c08af22d&quot;</span>
	<span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),P=new y({props:{title:"Code changes",local:"code-changes",headingTag:"h3"}}),_=new J({props:{code:"JTIydXBkYXRlZFJlZnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyZWYlMjIlM0ElMjAlMjJyZWZzJTJGaGVhZHMlMkZtYWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyb2xkU2hhJTIyJTNBJTIwJTIyY2U5YTQ2NzRmYTgzM2E2OGQ1YTczZWMzNTVmMGVhOTVlZWRkNjBiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5ld1NoYSUyMiUzQSUyMCUyMjU3NWRiOGI3YTUxYjZmODVlYjA2ZWVlNTQwNzM4NTg0NTg5ZjEzMWMlMjIlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyZWYlMjIlM0ElMjAlMjJyZWZzJTJGdGFncyUyRnRlc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJvbGRTaGElMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV3U2hhJTIyJTNBJTIwJTIyNTc1ZGI4YjdhNTFiNmY4NWViMDZlZWU1NDA3Mzg1ODQ1ODlmMTMxYyUyMiUwQSUyMCUyMCU3RCUwQSU1RA==",highlighted:`<span class="hljs-attr">&quot;updatedRefs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;ref&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;refs/heads/main&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;oldSha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ce9a4674fa833a68d5a73ec355f0ea95eedd60b7&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;newSha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;575db8b7a51b6f85eb06eee540738584589f131c&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;ref&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;refs/tags/test&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;oldSha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;newSha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;575db8b7a51b6f85eb06eee540738584589f131c&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span>`,wrap:!1}}),F=new y({props:{title:"Config changes",local:"config-changes",headingTag:"h3"}}),ss=new J({props:{code:"JTIydXBkYXRlZENvbmZpZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMnByaXZhdGUlMjIlM0ElMjBmYWxzZSUwQSU3RA==",highlighted:`<span class="hljs-attr">&quot;updatedConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;private&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),as=new J({props:{code:"JTIydXBkYXRlZENvbmZpZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMnhldEVuYWJsZWQlMjIlM0ElMjB0cnVlJTJDJTBBJTdE",highlighted:`<span class="hljs-attr">&quot;updatedConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;xetEnabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ls=new J({props:{code:"JTIydXBkYXRlZENvbmZpZyUyMiUzQSUyMCU3QiU3RA==",highlighted:'<span class="hljs-attr">&quot;updatedConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span>',wrap:!1}}),ps=new y({props:{title:"Discussions and Pull Requests",local:"discussions-and-pull-requests",headingTag:"h3"}}),us=new J({props:{code:"JTIyZGlzY3Vzc2lvbiUyMiUzQSUyMCU3QiUwQSUwOSUyMmlkJTIyJTNBJTIwJTIyNjM5ODg1ZDgxMWFlMmJhZDJiN2JhNDYxJTIyJTJDJTBBJTA5JTIydGl0bGUlMjIlM0ElMjAlMjJIZWxsbyElMjIlMkMlMEElMDklMjJ1cmwlMjIlM0ElMjAlN0IlMEElMDklMDklMjJ3ZWIlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc29tZS11c2VyJTJGc29tZS1yZXBvJTJGZGlzY3Vzc2lvbnMlMkYzJTIyJTJDJTBBJTA5JTA5JTIyYXBpJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmFwaSUyRm1vZGVscyUyRnNvbWUtdXNlciUyRnNvbWUtcmVwbyUyRmRpc2N1c3Npb25zJTJGMyUyMiUwQSUwOSU3RCUyQyUwQSUwOSUyMnN0YXR1cyUyMiUzQSUyMCUyMm9wZW4lMjIlMkMlMEElMDklMjJhdXRob3IlMjIlM0ElMjAlN0IlMEElMDklMDklMjJpZCUyMiUzQSUyMCUyMjYxZDIwMDBjM2MyMDgzZTFjMDhhZjIyZCUyMiUwQSUwOSU3RCUyQyUwQSUwOSUyMmlzUHVsbFJlcXVlc3QlMjIlM0ElMjB0cnVlJTJDJTBBJTA5JTIyY2hhbmdlcyUyMiUzQSUyMCU3QiUwQSUwOSUwOSUyMmJhc2UlMjIlM0ElMjAlMjJyZWZzJTJGaGVhZHMlMkZtYWluJTIyJTBBJTA5JTdEJTBBJTA5JTIybnVtJTIyJTNBJTIwMyUwQSU3RA==",highlighted:`<span class="hljs-attr">&quot;discussion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;639885d811ae2bad2b7ba461&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;title&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hello!&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;web&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/some-user/some-repo/discussions/3&quot;</span><span class="hljs-punctuation">,</span>
		<span class="hljs-attr">&quot;api&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/api/models/some-user/some-repo/discussions/3&quot;</span>
	<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;open&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;author&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;61d2000c3c2083e1c08af22d&quot;</span>
	<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;isPullRequest&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;changes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;base&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;refs/heads/main&quot;</span>
	<span class="hljs-punctuation">}</span>
	<span class="hljs-attr">&quot;num&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),is=new y({props:{title:"Comment",local:"comment",headingTag:"h3"}}),Ms=new J({props:{code:"JTIyY29tbWVudCUyMiUzQSUyMCU3QiUwQSUwOSUyMmlkJTIyJTNBJTIwJTIyNjM5ODg3Mjg4N2JmY2ZiOTNhMzA2ZjE4JTIyJTJDJTBBJTA5JTIyYXV0aG9yJTIyJTNBJTIwJTdCJTBBJTA5JTA5JTIyaWQlMjIlM0ElMjAlMjI2MWQyMDAwYzNjMjA4M2UxYzA4YWYyMmQlMjIlMEElMDklN0QlMkMlMEElMDklMjJjb250ZW50JTIyJTNBJTIwJTIyVGhpcyUyMGFkZHMlMjBhbiUyMGVudiUyMGtleSUyMiUyQyUwQSUwOSUyMmhpZGRlbiUyMiUzQSUyMGZhbHNlJTJDJTBBJTA5JTIydXJsJTIyJTNBJTIwJTdCJTBBJTA5JTA5JTIyd2ViJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNvbWUtdXNlciUyRnNvbWUtcmVwbyUyRmRpc2N1c3Npb25zJTJGNCUyMzYzOTg4NzI4ODdiZmNmYjkzYTMwNmYxOCUyMiUwQSUwOSU3RCUwQSU3RA==",highlighted:`<span class="hljs-attr">&quot;comment&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;6398872887bfcfb93a306f18&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;author&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;61d2000c3c2083e1c08af22d&quot;</span>
	<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This adds an env key&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;hidden&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
		<span class="hljs-attr">&quot;web&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://huggingface.co/some-user/some-repo/discussions/4#6398872887bfcfb93a306f18&quot;</span>
	<span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),hs=new y({props:{title:"Webhook secret",local:"webhook-secret",headingTag:"h2"}}),ys=new y({props:{title:"Rate limiting",local:"rate-limiting",headingTag:"h2"}}),ms=new y({props:{title:"Developing your Webhooks",local:"developing-your-webhooks",headingTag:"h2"}}),ws=new y({props:{title:"Debugging Webhooks",local:"debugging-webhooks",headingTag:"h2"}}),Is=new y({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),vs=new y({props:{title:"Can I define webhooks on my organization vs my user account?",local:"can-i-define-webhooks-on-my-organization-vs-my-user-account",headingTag:"h5"}}),Cs=new y({props:{title:"How can I subscribe to all events on HF (or across a whole repo type, like on all models)?",local:"how-can-i-subscribe-to-all-events-on-hf-or-across-a-whole-repo-type-like-on-all-models",headingTag:"h5"}}),As=new Va({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/webhooks.md"}}),{c(){d=p("meta"),Ss=l(),Es=p("p"),Ns=l(),i(f.$$.fragment),Bs=l(),i(w.$$.fragment),Ws=l(),T=p("blockquote"),T.innerHTML=Kt,xs=l(),U=p("p"),U.textContent=sa,Qs=l(),q=p("p"),q.textContent=ta,zs=l(),g=p("p"),g.innerHTML=aa,Rs=l(),b=p("ul"),b.innerHTML=na,Hs=l(),i(I.$$.fragment),Ys=l(),v=p("p"),v.innerHTML=la,Ds=l(),$=p("p"),$.innerHTML=ea,Ls=l(),C=p("p"),C.textContent=pa,Gs=l(),i(k.$$.fragment),Ps=l(),A=p("p"),A.innerHTML=oa,Os=l(),E=p("p"),E.textContent=ua,_s=l(),Z=p("p"),Z.innerHTML=ia,Vs=l(),S=p("p"),S.textContent=ca,Xs=l(),i(N.$$.fragment),Fs=l(),i(B.$$.fragment),Ks=l(),W=p("p"),W.innerHTML=Ma,st=l(),x=p("p"),x.innerHTML=ha,tt=l(),Q=p("p"),Q.innerHTML=ja,at=l(),z=p("ul"),z.innerHTML=ra,nt=l(),R=p("p"),R.innerHTML=ya,lt=l(),H=p("p"),H.innerHTML=da,et=l(),i(Y.$$.fragment),pt=l(),D=p("p"),D.innerHTML=Ta,ot=l(),i(L.$$.fragment),ut=l(),G=p("p"),G.innerHTML=ma,it=l(),i(P.$$.fragment),ct=l(),O=p("p"),O.innerHTML=Ja,Mt=l(),i(_.$$.fragment),ht=l(),V=p("p"),V.innerHTML=fa,jt=l(),X=p("p"),X.textContent=wa,rt=l(),i(F.$$.fragment),yt=l(),K=p("p"),K.innerHTML=Ua,dt=l(),i(ss.$$.fragment),Tt=l(),ts=p("p"),ts.textContent=qa,mt=l(),i(as.$$.fragment),Jt=l(),ns=p("p"),ns.textContent=ga,ft=l(),i(ls.$$.fragment),wt=l(),es=p("p"),es.innerHTML=ba,Ut=l(),i(ps.$$.fragment),qt=l(),os=p("p"),os.innerHTML=Ia,gt=l(),i(us.$$.fragment),bt=l(),i(is.$$.fragment),It=l(),cs=p("p"),cs.innerHTML=va,vt=l(),i(Ms.$$.fragment),$t=l(),i(hs.$$.fragment),Ct=l(),js=p("p"),js.textContent=$a,kt=l(),rs=p("p"),rs.innerHTML=Ca,At=l(),m=p("blockquote"),m.innerHTML=ka,Et=l(),i(ys.$$.fragment),Zt=l(),ds=p("p"),ds.textContent=Aa,St=l(),Ts=p("p"),Ts.innerHTML=Ea,Nt=l(),i(ms.$$.fragment),Bt=l(),Js=p("p"),Js.innerHTML=Za,Wt=l(),fs=p("p"),fs.innerHTML=Sa,xt=l(),i(ws.$$.fragment),Qt=l(),Us=p("p"),Us.textContent=Na,zt=l(),qs=p("p"),qs.innerHTML=Ba,Rt=l(),gs=p("p"),gs.innerHTML=Wa,Ht=l(),bs=p("p"),bs.textContent=xa,Yt=l(),i(Is.$$.fragment),Dt=l(),i(vs.$$.fragment),Lt=l(),$s=p("p"),$s.textContent=Qa,Gt=l(),i(Cs.$$.fragment),Pt=l(),ks=p("p"),ks.innerHTML=za,Ot=l(),i(As.$$.fragment),_t=l(),Zs=p("p"),this.h()},l(s){const t=Pa("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(a),Ss=e(s),Es=o(s,"P",{}),Ra(Es).forEach(a),Ns=e(s),c(f.$$.fragment,s),Bs=e(s),c(w.$$.fragment,s),Ws=e(s),T=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(T)!=="svelte-19nwf8t"&&(T.innerHTML=Kt),xs=e(s),U=o(s,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1ldsnol"&&(U.textContent=sa),Qs=e(s),q=o(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1hwy5h6"&&(q.textContent=ta),zs=e(s),g=o(s,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1aibu5k"&&(g.innerHTML=aa),Rs=e(s),b=o(s,"UL",{"data-svelte-h":!0}),u(b)!=="svelte-1vfwqru"&&(b.innerHTML=na),Hs=e(s),c(I.$$.fragment,s),Ys=e(s),v=o(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1jad0xw"&&(v.innerHTML=la),Ds=e(s),$=o(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-17huosr"&&($.innerHTML=ea),Ls=e(s),C=o(s,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1v6a87t"&&(C.textContent=pa),Gs=e(s),c(k.$$.fragment,s),Ps=e(s),A=o(s,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1agzgvr"&&(A.innerHTML=oa),Os=e(s),E=o(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1e4vmvr"&&(E.textContent=ua),_s=e(s),Z=o(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1leksdc"&&(Z.innerHTML=ia),Vs=e(s),S=o(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-u7i20p"&&(S.textContent=ca),Xs=e(s),c(N.$$.fragment,s),Fs=e(s),c(B.$$.fragment,s),Ks=e(s),W=o(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1m2weto"&&(W.innerHTML=Ma),st=e(s),x=o(s,"P",{"data-svelte-h":!0}),u(x)!=="svelte-3olods"&&(x.innerHTML=ha),tt=e(s),Q=o(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-141dwgh"&&(Q.innerHTML=ja),at=e(s),z=o(s,"UL",{"data-svelte-h":!0}),u(z)!=="svelte-tx2a4q"&&(z.innerHTML=ra),nt=e(s),R=o(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-kjsc8l"&&(R.innerHTML=ya),lt=e(s),H=o(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-cg0ijt"&&(H.innerHTML=da),et=e(s),c(Y.$$.fragment,s),pt=e(s),D=o(s,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1v3ajyh"&&(D.innerHTML=Ta),ot=e(s),c(L.$$.fragment,s),ut=e(s),G=o(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-ok4hz"&&(G.innerHTML=ma),it=e(s),c(P.$$.fragment,s),ct=e(s),O=o(s,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1o206uh"&&(O.innerHTML=Ja),Mt=e(s),c(_.$$.fragment,s),ht=e(s),V=o(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-4e3e0n"&&(V.innerHTML=fa),jt=e(s),X=o(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1aawfn"&&(X.textContent=wa),rt=e(s),c(F.$$.fragment,s),yt=e(s),K=o(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-tsnjq5"&&(K.innerHTML=Ua),dt=e(s),c(ss.$$.fragment,s),Tt=e(s),ts=o(s,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-93sdsf"&&(ts.textContent=qa),mt=e(s),c(as.$$.fragment,s),Jt=e(s),ns=o(s,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-1e68bwe"&&(ns.textContent=ga),ft=e(s),c(ls.$$.fragment,s),wt=e(s),es=o(s,"P",{"data-svelte-h":!0}),u(es)!=="svelte-114r03g"&&(es.innerHTML=ba),Ut=e(s),c(ps.$$.fragment,s),qt=e(s),os=o(s,"P",{"data-svelte-h":!0}),u(os)!=="svelte-empesk"&&(os.innerHTML=Ia),gt=e(s),c(us.$$.fragment,s),bt=e(s),c(is.$$.fragment,s),It=e(s),cs=o(s,"P",{"data-svelte-h":!0}),u(cs)!=="svelte-6f363t"&&(cs.innerHTML=va),vt=e(s),c(Ms.$$.fragment,s),$t=e(s),c(hs.$$.fragment,s),Ct=e(s),js=o(s,"P",{"data-svelte-h":!0}),u(js)!=="svelte-1it3ih6"&&(js.textContent=$a),kt=e(s),rs=o(s,"P",{"data-svelte-h":!0}),u(rs)!=="svelte-1a02rb"&&(rs.innerHTML=Ca),At=e(s),m=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(m)!=="svelte-1re06w"&&(m.innerHTML=ka),Et=e(s),c(ys.$$.fragment,s),Zt=e(s),ds=o(s,"P",{"data-svelte-h":!0}),u(ds)!=="svelte-1a0532t"&&(ds.textContent=Aa),St=e(s),Ts=o(s,"P",{"data-svelte-h":!0}),u(Ts)!=="svelte-awy2zc"&&(Ts.innerHTML=Ea),Nt=e(s),c(ms.$$.fragment,s),Bt=e(s),Js=o(s,"P",{"data-svelte-h":!0}),u(Js)!=="svelte-rvln7x"&&(Js.innerHTML=Za),Wt=e(s),fs=o(s,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-1qsbtmg"&&(fs.innerHTML=Sa),xt=e(s),c(ws.$$.fragment,s),Qt=e(s),Us=o(s,"P",{"data-svelte-h":!0}),u(Us)!=="svelte-1xirh7d"&&(Us.textContent=Na),zt=e(s),qs=o(s,"P",{"data-svelte-h":!0}),u(qs)!=="svelte-58u8h3"&&(qs.innerHTML=Ba),Rt=e(s),gs=o(s,"P",{"data-svelte-h":!0}),u(gs)!=="svelte-1iw0ibf"&&(gs.innerHTML=Wa),Ht=e(s),bs=o(s,"P",{"data-svelte-h":!0}),u(bs)!=="svelte-pwx7lx"&&(bs.textContent=xa),Yt=e(s),c(Is.$$.fragment,s),Dt=e(s),c(vs.$$.fragment,s),Lt=e(s),$s=o(s,"P",{"data-svelte-h":!0}),u($s)!=="svelte-1gyp1dm"&&($s.textContent=Qa),Gt=e(s),c(Cs.$$.fragment,s),Pt=e(s),ks=o(s,"P",{"data-svelte-h":!0}),u(ks)!=="svelte-10xs88v"&&(ks.innerHTML=za),Ot=e(s),c(As.$$.fragment,s),_t=e(s),Zs=o(s,"P",{}),Ra(Zs).forEach(a),this.h()},h(){Xt(d,"name","hf:doc:metadata"),Xt(d,"content",Fa),Xt(T,"class","tip"),Xt(m,"class","tip")},m(s,t){Oa(document.head,d),n(s,Ss,t),n(s,Es,t),n(s,Ns,t),M(f,s,t),n(s,Bs,t),M(w,s,t),n(s,Ws,t),n(s,T,t),n(s,xs,t),n(s,U,t),n(s,Qs,t),n(s,q,t),n(s,zs,t),n(s,g,t),n(s,Rs,t),n(s,b,t),n(s,Hs,t),M(I,s,t),n(s,Ys,t),n(s,v,t),n(s,Ds,t),n(s,$,t),n(s,Ls,t),n(s,C,t),n(s,Gs,t),M(k,s,t),n(s,Ps,t),n(s,A,t),n(s,Os,t),n(s,E,t),n(s,_s,t),n(s,Z,t),n(s,Vs,t),n(s,S,t),n(s,Xs,t),M(N,s,t),n(s,Fs,t),M(B,s,t),n(s,Ks,t),n(s,W,t),n(s,st,t),n(s,x,t),n(s,tt,t),n(s,Q,t),n(s,at,t),n(s,z,t),n(s,nt,t),n(s,R,t),n(s,lt,t),n(s,H,t),n(s,et,t),M(Y,s,t),n(s,pt,t),n(s,D,t),n(s,ot,t),M(L,s,t),n(s,ut,t),n(s,G,t),n(s,it,t),M(P,s,t),n(s,ct,t),n(s,O,t),n(s,Mt,t),M(_,s,t),n(s,ht,t),n(s,V,t),n(s,jt,t),n(s,X,t),n(s,rt,t),M(F,s,t),n(s,yt,t),n(s,K,t),n(s,dt,t),M(ss,s,t),n(s,Tt,t),n(s,ts,t),n(s,mt,t),M(as,s,t),n(s,Jt,t),n(s,ns,t),n(s,ft,t),M(ls,s,t),n(s,wt,t),n(s,es,t),n(s,Ut,t),M(ps,s,t),n(s,qt,t),n(s,os,t),n(s,gt,t),M(us,s,t),n(s,bt,t),M(is,s,t),n(s,It,t),n(s,cs,t),n(s,vt,t),M(Ms,s,t),n(s,$t,t),M(hs,s,t),n(s,Ct,t),n(s,js,t),n(s,kt,t),n(s,rs,t),n(s,At,t),n(s,m,t),n(s,Et,t),M(ys,s,t),n(s,Zt,t),n(s,ds,t),n(s,St,t),n(s,Ts,t),n(s,Nt,t),M(ms,s,t),n(s,Bt,t),n(s,Js,t),n(s,Wt,t),n(s,fs,t),n(s,xt,t),M(ws,s,t),n(s,Qt,t),n(s,Us,t),n(s,zt,t),n(s,qs,t),n(s,Rt,t),n(s,gs,t),n(s,Ht,t),n(s,bs,t),n(s,Yt,t),M(Is,s,t),n(s,Dt,t),M(vs,s,t),n(s,Lt,t),n(s,$s,t),n(s,Gt,t),M(Cs,s,t),n(s,Pt,t),n(s,ks,t),n(s,Ot,t),M(As,s,t),n(s,_t,t),n(s,Zs,t),Vt=!0},p:Ya,i(s){Vt||(h(f.$$.fragment,s),h(w.$$.fragment,s),h(I.$$.fragment,s),h(k.$$.fragment,s),h(N.$$.fragment,s),h(B.$$.fragment,s),h(Y.$$.fragment,s),h(L.$$.fragment,s),h(P.$$.fragment,s),h(_.$$.fragment,s),h(F.$$.fragment,s),h(ss.$$.fragment,s),h(as.$$.fragment,s),h(ls.$$.fragment,s),h(ps.$$.fragment,s),h(us.$$.fragment,s),h(is.$$.fragment,s),h(Ms.$$.fragment,s),h(hs.$$.fragment,s),h(ys.$$.fragment,s),h(ms.$$.fragment,s),h(ws.$$.fragment,s),h(Is.$$.fragment,s),h(vs.$$.fragment,s),h(Cs.$$.fragment,s),h(As.$$.fragment,s),Vt=!0)},o(s){j(f.$$.fragment,s),j(w.$$.fragment,s),j(I.$$.fragment,s),j(k.$$.fragment,s),j(N.$$.fragment,s),j(B.$$.fragment,s),j(Y.$$.fragment,s),j(L.$$.fragment,s),j(P.$$.fragment,s),j(_.$$.fragment,s),j(F.$$.fragment,s),j(ss.$$.fragment,s),j(as.$$.fragment,s),j(ls.$$.fragment,s),j(ps.$$.fragment,s),j(us.$$.fragment,s),j(is.$$.fragment,s),j(Ms.$$.fragment,s),j(hs.$$.fragment,s),j(ys.$$.fragment,s),j(ms.$$.fragment,s),j(ws.$$.fragment,s),j(Is.$$.fragment,s),j(vs.$$.fragment,s),j(Cs.$$.fragment,s),j(As.$$.fragment,s),Vt=!1},d(s){s&&(a(Ss),a(Es),a(Ns),a(Bs),a(Ws),a(T),a(xs),a(U),a(Qs),a(q),a(zs),a(g),a(Rs),a(b),a(Hs),a(Ys),a(v),a(Ds),a($),a(Ls),a(C),a(Gs),a(Ps),a(A),a(Os),a(E),a(_s),a(Z),a(Vs),a(S),a(Xs),a(Fs),a(Ks),a(W),a(st),a(x),a(tt),a(Q),a(at),a(z),a(nt),a(R),a(lt),a(H),a(et),a(pt),a(D),a(ot),a(ut),a(G),a(it),a(ct),a(O),a(Mt),a(ht),a(V),a(jt),a(X),a(rt),a(yt),a(K),a(dt),a(Tt),a(ts),a(mt),a(Jt),a(ns),a(ft),a(wt),a(es),a(Ut),a(qt),a(os),a(gt),a(bt),a(It),a(cs),a(vt),a($t),a(Ct),a(js),a(kt),a(rs),a(At),a(m),a(Et),a(Zt),a(ds),a(St),a(Ts),a(Nt),a(Bt),a(Js),a(Wt),a(fs),a(xt),a(Qt),a(Us),a(zt),a(qs),a(Rt),a(gs),a(Ht),a(bs),a(Yt),a(Dt),a(Lt),a($s),a(Gt),a(Pt),a(ks),a(Ot),a(_t),a(Zs)),a(d),r(f,s),r(w,s),r(I,s),r(k,s),r(N,s),r(B,s),r(Y,s),r(L,s),r(P,s),r(_,s),r(F,s),r(ss,s),r(as,s),r(ls,s),r(ps,s),r(us,s),r(is,s),r(Ms,s),r(hs,s),r(ys,s),r(ms,s),r(ws,s),r(Is,s),r(vs,s),r(Cs,s),r(As,s)}}}const Fa='{"title":"Webhooks","local":"webhooks","sections":[{"title":"Create your Webhook","local":"create-your-webhook","sections":[],"depth":2},{"title":"Webhook Payloads","local":"webhook-payloads","sections":[{"title":"Event","local":"event","sections":[],"depth":3},{"title":"Repo","local":"repo","sections":[],"depth":3},{"title":"Code changes","local":"code-changes","sections":[],"depth":3},{"title":"Config changes","local":"config-changes","sections":[],"depth":3},{"title":"Discussions and Pull Requests","local":"discussions-and-pull-requests","sections":[],"depth":3},{"title":"Comment","local":"comment","sections":[],"depth":3}],"depth":2},{"title":"Webhook secret","local":"webhook-secret","sections":[],"depth":2},{"title":"Rate limiting","local":"rate-limiting","sections":[],"depth":2},{"title":"Developing your Webhooks","local":"developing-your-webhooks","sections":[],"depth":2},{"title":"Debugging Webhooks","local":"debugging-webhooks","sections":[],"depth":2},{"title":"FAQ","local":"faq","sections":[{"title":"Can I define webhooks on my organization vs my user account?","local":"can-i-define-webhooks-on-my-organization-vs-my-user-account","sections":[],"depth":5},{"title":"How can I subscribe to all events on HF (or across a whole repo type, like on all models)?","local":"how-can-i-subscribe-to-all-events-on-hf-or-across-a-whole-repo-type-like-on-all-models","sections":[],"depth":5}],"depth":2}],"depth":1}';function Ka(Ft){return Da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends La{constructor(d){super(),Ga(this,d,Ka,Xa,Ha,{})}}export{en as component};
