import{s as $t,n as Zt,o as Rt}from"../chunks/scheduler.9cda857a.js";import{S as Vt,i as xt,e as o,s as l,c,h as Lt,a as i,d as s,b as n,f as St,g as h,j as p,k as ne,l as Gt,m as a,n as u,t as r,o as d,p as m}from"../chunks/index.f47f3121.js";import{C as Qt}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as pe}from"../chunks/CodeBlock.24d62f98.js";import{H as ce,E as qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function Yt(st){let M,he,oe,ue,j,re,J,de,T,at="<p>Webhooks are now publicly available!</p>",me,b,lt=`This guide will help walk you through the setup of an automatic training pipeline on the Hugging Face platform
using HF Datasets, Webhooks, Spaces, and AutoTrain.`,Me,g,nt=`We will build a Webhook that listens to changes on an image classification dataset and triggers a fine-tuning
of <a href="https://huggingface.co/microsoft/resnet-50" rel="nofollow">microsoft/resnet-50</a> using <a href="https://huggingface.co/autotrain" rel="nofollow">AutoTrain</a>.`,Te,U,we,k,ot=`We will use a <a href="https://huggingface.co/datasets/huggingface-projects/auto-retrain-input-dataset" rel="nofollow">simple image classification dataset</a> for the sake
of the example. Learn more about uploading your data to the Hub <a href="https://huggingface.co/docs/datasets/upload_dataset" rel="nofollow">here</a>.`,fe,v,it='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/dataset.png" alt="dataset"/>',ye,B,je,C,pt='First, let’s create a Webhook from your <a href="https://huggingface.co/settings/webhooks" rel="nofollow">settings</a>.',Je,W,ct='<li>Select your dataset as the target repository. We will target <a href="https://huggingface.co/datasets/huggingface-projects/input-dataset" rel="nofollow">huggingface-projects/input-dataset</a> in this example.</li> <li>You can put a dummy Webhook URL for now. Defining your Webhook will let you look at the events that will be sent to it. You can also replay them, which will be useful for debugging!</li> <li>Input a secret to make it more secure.</li> <li>Subscribe to “Repo update” events as we want to react to data changes</li>',be,E,ht="Your Webhook will look like this:",ge,I,ut='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/webhook-creation.png" alt="webhook-creation"/>',Ue,H,ke,_,rt='We now need a way to react to your Webhook events. An easy way to do this is to use a <a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">Space</a>!',ve,S,dt='You can find an example Space <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/tree/main" rel="nofollow">here</a>.',Be,$,mt='This Space uses Docker, Python, <a href="https://fastapi.tiangolo.com/" rel="nofollow">FastAPI</a>, and <a href="https://www.uvicorn.org" rel="nofollow">uvicorn</a> to run a simple HTTP server. Read more about Docker Spaces <a href="https://huggingface.co/docs/hub/spaces-sdks-docker" rel="nofollow">here</a>.',Ce,Z,Mt='The entry point is <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/blob/main/src/main.py" rel="nofollow">src/main.py</a>. Let’s walk through this file and detail what it does:',We,R,Tt="<li>It spawns a FastAPI app that will listen to HTTP <code>POST</code> requests on <code>/webhook</code>:</li>",Ee,V,Ie,w,wt='<li><ol start="2"><li>This route checks that the <code>X-Webhook-Secret</code> header is present and that its value is the same as the one you set in your Webhook’s settings. The <code>WEBHOOK_SECRET</code> secret must be set in the Space’s settings and be the same as the secret set in your Webhook.</li></ol></li>',He,x,_e,f,ft="<li>The event’s payload is encoded as JSON. Here, we’ll be using pydantic models to parse the event payload. We also specify that we will run our Webhook only when:</li>",Se,L,yt="<li>the event concerns the input dataset</li> <li>the event is an update on the repo’s content, i.e., there has been a new commit</li>",$e,G,Ze,y,jt="<li>If the payload is valid, the next step is to create a project on AutoTrain, schedule a fine-tuning of the input model (<code>microsoft/resnet-50</code> in our example) on the input dataset, and create a discussion on the dataset when it’s done!</li>",Re,Q,Ve,q,Jt="Visit the link inside the comment to review the training cost estimate, and start fine-tuning the model!",xe,Y,bt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/notification.png" alt="community tab notification"/>',Le,X,gt="In this example, we used Hugging Face AutoTrain to fine-tune our model quickly, but you can of course plug in your training infrastructure!",Ge,A,Ut="Feel free to duplicate the Space to your personal namespace and play with it. You will need to provide two secrets:",Qe,N,kt='<li><code>WEBHOOK_SECRET</code> : the secret from your Webhook.</li> <li><code>HF_ACCESS_TOKEN</code> : a User Access Token with <code>write</code> rights. You can create one <a href="https://huggingface.co/settings/tokens" rel="nofollow">from your settings</a>.</li>',qe,z,vt='You will also need to tweak the <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/blob/main/config.json" rel="nofollow"><code>config.json</code> file</a> to use the dataset and model of you choice:',Ye,F,Xe,P,Ae,O,Bt="Last but not least, you’ll need to configure your webhook to send POST requests to your Space.",Ne,D,Ct="Let’s first grab our Space’s “direct URL” from the contextual menu. Click on “Embed this Space” and copy the “Direct URL”.",ze,K,Wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/duplicate-space.png" alt="embed this Space"/>',Fe,ee,Et='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/direct-url.png" alt="direct URL"/>',Pe,te,It="Update your Webhook to send requests to that URL:",Oe,se,Ht='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/update-webhook.png" alt="webhook settings"/>',De,ae,_t="And that’s it! Now every commit to the input dataset will trigger a fine-tuning of ResNet-50 with AutoTrain 🎉",Ke,le,et,ie,tt;return j=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new ce({props:{title:"Webhook guide: Setup an automatic system to re-train a model when a dataset changes",local:"webhook-guide-setup-an-automatic-system-to-re-train-a-model-when-a-dataset-changes",headingTag:"h1"}}),U=new ce({props:{title:"Prerequisite: Upload your dataset to the Hub",local:"prerequisite-upload-your-dataset-to-the-hub",headingTag:"h2"}}),B=new ce({props:{title:"Create a Webhook to react to the dataset’s changes",local:"create-a-webhook-to-react-to-the-datasets-changes",headingTag:"h2"}}),H=new ce({props:{title:"Create a Space to react to your Webhook",local:"create-a-space-to-react-to-your-webhook",headingTag:"h2"}}),V=new pe({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBJTIzJTIwJTVCLi4uJTVEJTBBJTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHBvc3Rfd2ViaG9vayglMEElMDklMjMlMjAuLi4lMEEpJTNBJTBBJTBBJTIzJTIwLi4u",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

<span class="hljs-comment"># [...]</span>
<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># ...</span>
</span>):

<span class="hljs-comment"># ...</span>`,wrap:!1}}),x=new pe({props:{code:"JTIzJTIwJTVCLi4uJTVEJTBBJTBBV0VCSE9PS19TRUNSRVQlMjAlM0QlMjBvcy5nZXRlbnYoJTIyV0VCSE9PS19TRUNSRVQlMjIpJTBBJTBBJTIzJTIwJTVCLi4uJTVEJTBBJTBBJTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHBvc3Rfd2ViaG9vayglMEElMDklMjMlMjAlNUIuLi4lNUQlMEElMDl4X3dlYmhvb2tfc2VjcmV0JTNBJTIwJTIwT3B0aW9uYWwlNUJzdHIlNUQlMjAlM0QlMjBIZWFkZXIoZGVmYXVsdCUzRE5vbmUpJTJDJTBBJTA5JTIzJTIwJTVFJTIwY2hlY2tzJTIwZm9yJTIwdGhlJTIwWC1XZWJob29rLVNlY3JldCUyMEhUVFAlMjBoZWFkZXIlMEEpJTNBJTBBJTA5aWYlMjB4X3dlYmhvb2tfc2VjcmV0JTIwaXMlMjBOb25lJTNBJTBBJTA5JTA5cmFpc2UlMjBIVFRQRXhjZXB0aW9uKDQwMSklMEElMDlpZiUyMHhfd2ViaG9va19zZWNyZXQlMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMDklMDlyYWlzZSUyMEhUVFBFeGNlcHRpb24oNDAzKSUwQSUwOSUyMyUyMCU1Qi4uLiU1RA==",highlighted:`<span class="hljs-comment"># [...]</span>

WEBHOOK_SECRET = os.getenv(<span class="hljs-string">&quot;WEBHOOK_SECRET&quot;</span>)

<span class="hljs-comment"># [...]</span>

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># [...]</span>
	x_webhook_secret:  <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = Header(<span class="hljs-params">default=<span class="hljs-literal">None</span></span>),
	<span class="hljs-comment"># ^ checks for the X-Webhook-Secret HTTP header</span>
</span>):
	<span class="hljs-keyword">if</span> x_webhook_secret <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
		<span class="hljs-keyword">raise</span> HTTPException(<span class="hljs-number">401</span>)
	<span class="hljs-keyword">if</span> x_webhook_secret != WEBHOOK_SECRET:
		<span class="hljs-keyword">raise</span> HTTPException(<span class="hljs-number">403</span>)
	<span class="hljs-comment"># [...]</span>`,wrap:!1}}),G=new pe({props:{code:"JTIzJTIwZGVmaW5lZCUyMGluJTIwc3JjJTJGbW9kZWxzLnB5JTBBY2xhc3MlMjBXZWJob29rUGF5bG9hZEV2ZW50KEJhc2VNb2RlbCklM0ElMEElMDlhY3Rpb24lM0ElMjBMaXRlcmFsJTVCJTIyY3JlYXRlJTIyJTJDJTIwJTIydXBkYXRlJTIyJTJDJTIwJTIyZGVsZXRlJTIyJTVEJTBBJTA5c2NvcGUlM0ElMjBzdHIlMEElMEFjbGFzcyUyMFdlYmhvb2tQYXlsb2FkUmVwbyhCYXNlTW9kZWwpJTNBJTBBJTA5dHlwZSUzQSUyMExpdGVyYWwlNUIlMjJkYXRhc2V0JTIyJTJDJTIwJTIybW9kZWwlMjIlMkMlMjAlMjJzcGFjZSUyMiU1RCUwQSUwOW5hbWUlM0ElMjBzdHIlMEElMDlpZCUzQSUyMHN0ciUwQSUwOXByaXZhdGUlM0ElMjBib29sJTBBJTA5aGVhZFNoYSUzQSUyMHN0ciUwQSUwQWNsYXNzJTIwV2ViaG9va1BheWxvYWQoQmFzZU1vZGVsKSUzQSUwQSUwOWV2ZW50JTNBJTIwV2ViaG9va1BheWxvYWRFdmVudCUwQSUwOXJlcG8lM0ElMjBXZWJob29rUGF5bG9hZFJlcG8lMEElMEElMjMlMjAlNUIuLi4lNUQlMEElMEElNDBhcHAucG9zdCglMjIlMkZ3ZWJob29rJTIyKSUwQWFzeW5jJTIwZGVmJTIwcG9zdF93ZWJob29rKCUwQSUwOSUyMyUyMCU1Qi4uLiU1RCUwQSUwOXBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCUyQyUwQSUwOSUyMyUyMCU1RSUyMFB5ZGFudGljJTIwbW9kZWwlMjBkZWZpbmluZyUyMHRoZSUyMHBheWxvYWQlMjBmb3JtYXQlMEEpJTNBJTBBJTA5JTIzJTIwJTVCLi4uJTVEJTBBJTA5aWYlMjBub3QlMjAoJTBBJTA5JTA5cGF5bG9hZC5ldmVudC5hY3Rpb24lMjAlM0QlM0QlMjAlMjJ1cGRhdGUlMjIlMEElMDklMDlhbmQlMjBwYXlsb2FkLmV2ZW50LnNjb3BlLnN0YXJ0c3dpdGgoJTIycmVwby5jb250ZW50JTIyKSUwQSUwOSUwOWFuZCUyMHBheWxvYWQucmVwby5uYW1lJTIwJTNEJTNEJTIwY29uZmlnLmlucHV0X2RhdGFzZXQlMEElMDklMDlhbmQlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMEElMDkpJTNBJTBBJTA5JTA5JTIzJTIwbm8tb3AlMjBpZiUyMHRoZSUyMHBheWxvYWQlMjBkb2VzJTIwbm90JTIwbWF0Y2glMjBvdXIlMjBleHBlY3RhdGlvbnMlMEElMDklMDlyZXR1cm4lMjAlN0IlMjJwcm9jZXNzZWQlMjIlM0ElMjBGYWxzZSU3RCUwQSUwOSUyMyU1Qi4uLiU1RA==",highlighted:`<span class="hljs-comment"># defined in src/models.py</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayloadEvent</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	action: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;create&quot;</span>, <span class="hljs-string">&quot;update&quot;</span>, <span class="hljs-string">&quot;delete&quot;</span>]
	scope: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayloadRepo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	<span class="hljs-built_in">type</span>: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;dataset&quot;</span>, <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-string">&quot;space&quot;</span>]
	name: <span class="hljs-built_in">str</span>
	<span class="hljs-built_in">id</span>: <span class="hljs-built_in">str</span>
	private: <span class="hljs-built_in">bool</span>
	headSha: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayload</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	event: WebhookPayloadEvent
	repo: WebhookPayloadRepo

<span class="hljs-comment"># [...]</span>

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># [...]</span>
	payload: WebhookPayload,
	<span class="hljs-comment"># ^ Pydantic model defining the payload format</span>
</span>):
	<span class="hljs-comment"># [...]</span>
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> (
		payload.event.action == <span class="hljs-string">&quot;update&quot;</span>
		<span class="hljs-keyword">and</span> payload.event.scope.startswith(<span class="hljs-string">&quot;repo.content&quot;</span>)
		<span class="hljs-keyword">and</span> payload.repo.name == config.input_dataset
		<span class="hljs-keyword">and</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span>
	):
		<span class="hljs-comment"># no-op if the payload does not match our expectations</span>
		<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;processed&quot;</span>: <span class="hljs-literal">False</span>}
	<span class="hljs-comment">#[...]</span>`,wrap:!1}}),Q=new pe({props:{code:"ZGVmJTIwc2NoZWR1bGVfcmV0cmFpbihwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTA5JTIzJTIwQ3JlYXRlJTIwdGhlJTIwYXV0b3RyYWluJTIwcHJvamVjdCUwQSUwOXRyeSUzQSUwQSUwOSUwOXByb2plY3QlMjAlM0QlMjBBdXRvVHJhaW4uY3JlYXRlX3Byb2plY3QocGF5bG9hZCklMEElMDklMDlBdXRvVHJhaW4uYWRkX2RhdGEocHJvamVjdF9pZCUzRHByb2plY3QlNUIlMjJpZCUyMiU1RCklMEElMDklMDlBdXRvVHJhaW4uc3RhcnRfcHJvY2Vzc2luZyhwcm9qZWN0X2lkJTNEcHJvamVjdCU1QiUyMmlkJTIyJTVEKSUwQSUwOWV4Y2VwdCUyMHJlcXVlc3RzLkhUVFBFcnJvciUyMGFzJTIwZXJyJTNBJTBBJTA5JTA5cHJpbnQoJTIyRVJST1IlMjB3aGlsZSUyMHJlcXVlc3RpbmclMjBBdXRvVHJhaW4lMjBBUEklM0ElMjIpJTBBJTA5JTA5cHJpbnQoZiUyMiUyMCUyMGNvZGUlM0ElMjAlN0JlcnIucmVzcG9uc2Uuc3RhdHVzX2NvZGUlN0QlMjIpJTBBJTA5JTA5cHJpbnQoZiUyMiUyMCUyMCU3QmVyci5yZXNwb25zZS5qc29uKCklN0QlMjIpJTBBJTA5JTA5cmFpc2UlMEElMDklMjMlMjBOb3RpZnklMjBpbiUyMHRoZSUyMGNvbW11bml0eSUyMHRhYiUwQSUwOW5vdGlmeV9zdWNjZXNzKHByb2plY3QlNUIlMjJpZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">schedule_retrain</span>(<span class="hljs-params">payload: WebhookPayload</span>):
	<span class="hljs-comment"># Create the autotrain project</span>
	<span class="hljs-keyword">try</span>:
		project = AutoTrain.create_project(payload)
		AutoTrain.add_data(project_id=project[<span class="hljs-string">&quot;id&quot;</span>])
		AutoTrain.start_processing(project_id=project[<span class="hljs-string">&quot;id&quot;</span>])
	<span class="hljs-keyword">except</span> requests.HTTPError <span class="hljs-keyword">as</span> err:
		<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR while requesting AutoTrain API:&quot;</span>)
		<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  code: <span class="hljs-subst">{err.response.status_code}</span>&quot;</span>)
		<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{err.response.json()}</span>&quot;</span>)
		<span class="hljs-keyword">raise</span>
	<span class="hljs-comment"># Notify in the community tab</span>
	notify_success(project[<span class="hljs-string">&quot;id&quot;</span>])`,wrap:!1}}),F=new pe({props:{code:"JTdCJTBBJTA5JTIydGFyZ2V0X25hbWVzcGFjZSUyMiUzQSUyMCUyMnRoZSUyMG5hbWVzcGFjZSUyMHdoZXJlJTIwdGhlJTIwdHJhaW5lZCUyMG1vZGVsJTIwc2hvdWxkJTIwZW5kJTIwdXAlMjIlMkMlMEElMDklMjJpbnB1dF9kYXRhc2V0JTIyJTNBJTIwJTIydGhlJTIwZGF0YXNldCUyMG9uJTIwd2hpY2glMjB0aGUlMjBtb2RlbCUyMHdpbGwlMjBiZSUyMHRyYWluZWQlMjIlMkMlMEElMDklMjJpbnB1dF9tb2RlbCUyMiUzQSUyMCUyMnRoZSUyMGJhc2UlMjBtb2RlbCUyMHRvJTIwcmUtdHJhaW4lMjIlMkMlMEElMDklMjJhdXRvdHJhaW5fcHJvamVjdF9wcmVmaXglMjIlM0ElMjAlMjJBJTIwcHJlZml4JTIwZm9yJTIwdGhlJTIwQXV0b1RyYWluJTIwcHJvamVjdCUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;target_namespace&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the namespace where the trained model should end up&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;input_dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the dataset on which the model will be trained&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;input_model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the base model to re-train&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;autotrain_project_prefix&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A prefix for the AutoTrain project&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),P=new ce({props:{title:"Configure your Webhook to send events to your Space",local:"configure-your-webhook-to-send-events-to-your-space",headingTag:"h2"}}),le=new qt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/webhooks-guide-auto-retrain.md"}}),{c(){M=o("meta"),he=l(),oe=o("p"),ue=l(),c(j.$$.fragment),re=l(),c(J.$$.fragment),de=l(),T=o("blockquote"),T.innerHTML=at,me=l(),b=o("p"),b.textContent=lt,Me=l(),g=o("p"),g.innerHTML=nt,Te=l(),c(U.$$.fragment),we=l(),k=o("p"),k.innerHTML=ot,fe=l(),v=o("p"),v.innerHTML=it,ye=l(),c(B.$$.fragment),je=l(),C=o("p"),C.innerHTML=pt,Je=l(),W=o("ul"),W.innerHTML=ct,be=l(),E=o("p"),E.textContent=ht,ge=l(),I=o("p"),I.innerHTML=ut,Ue=l(),c(H.$$.fragment),ke=l(),_=o("p"),_.innerHTML=rt,ve=l(),S=o("p"),S.innerHTML=dt,Be=l(),$=o("p"),$.innerHTML=mt,Ce=l(),Z=o("p"),Z.innerHTML=Mt,We=l(),R=o("ol"),R.innerHTML=Tt,Ee=l(),c(V.$$.fragment),Ie=l(),w=o("ol"),w.innerHTML=wt,He=l(),c(x.$$.fragment),_e=l(),f=o("ol"),f.innerHTML=ft,Se=l(),L=o("ul"),L.innerHTML=yt,$e=l(),c(G.$$.fragment),Ze=l(),y=o("ol"),y.innerHTML=jt,Re=l(),c(Q.$$.fragment),Ve=l(),q=o("p"),q.textContent=Jt,xe=l(),Y=o("p"),Y.innerHTML=bt,Le=l(),X=o("p"),X.textContent=gt,Ge=l(),A=o("p"),A.textContent=Ut,Qe=l(),N=o("ul"),N.innerHTML=kt,qe=l(),z=o("p"),z.innerHTML=vt,Ye=l(),c(F.$$.fragment),Xe=l(),c(P.$$.fragment),Ae=l(),O=o("p"),O.textContent=Bt,Ne=l(),D=o("p"),D.textContent=Ct,ze=l(),K=o("p"),K.innerHTML=Wt,Fe=l(),ee=o("p"),ee.innerHTML=Et,Pe=l(),te=o("p"),te.textContent=It,Oe=l(),se=o("p"),se.innerHTML=Ht,De=l(),ae=o("p"),ae.textContent=_t,Ke=l(),c(le.$$.fragment),et=l(),ie=o("p"),this.h()},l(e){const t=Lt("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(s),he=n(e),oe=i(e,"P",{}),St(oe).forEach(s),ue=n(e),h(j.$$.fragment,e),re=n(e),h(J.$$.fragment,e),de=n(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-19nwf8t"&&(T.innerHTML=at),me=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-ze8gh0"&&(b.textContent=lt),Me=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-8my4lw"&&(g.innerHTML=nt),Te=n(e),h(U.$$.fragment,e),we=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1bbg0un"&&(k.innerHTML=ot),fe=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-l6l0rz"&&(v.innerHTML=it),ye=n(e),h(B.$$.fragment,e),je=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-15jch62"&&(C.innerHTML=pt),Je=n(e),W=i(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-vx6oz2"&&(W.innerHTML=ct),be=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1kjjv0e"&&(E.textContent=ht),ge=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1lz55rf"&&(I.innerHTML=ut),Ue=n(e),h(H.$$.fragment,e),ke=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-fqh90s"&&(_.innerHTML=rt),ve=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-sual4m"&&(S.innerHTML=dt),Be=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-j52eq3"&&($.innerHTML=mt),Ce=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1euo8xv"&&(Z.innerHTML=Mt),We=n(e),R=i(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-1xhscr8"&&(R.innerHTML=Tt),Ee=n(e),h(V.$$.fragment,e),Ie=n(e),w=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(w)!=="svelte-199ucq9"&&(w.innerHTML=wt),He=n(e),h(x.$$.fragment,e),_e=n(e),f=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(f)!=="svelte-18lnge2"&&(f.innerHTML=ft),Se=n(e),L=i(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-1gbdb1z"&&(L.innerHTML=yt),$e=n(e),h(G.$$.fragment,e),Ze=n(e),y=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(y)!=="svelte-1jgt1rb"&&(y.innerHTML=jt),Re=n(e),h(Q.$$.fragment,e),Ve=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-2wkt37"&&(q.textContent=Jt),xe=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-17amjt1"&&(Y.innerHTML=bt),Le=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1upb8bg"&&(X.textContent=gt),Ge=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1ieosw8"&&(A.textContent=Ut),Qe=n(e),N=i(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1mva7ee"&&(N.innerHTML=kt),qe=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-ch6cio"&&(z.innerHTML=vt),Ye=n(e),h(F.$$.fragment,e),Xe=n(e),h(P.$$.fragment,e),Ae=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-14g7hz7"&&(O.textContent=Bt),Ne=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-51uzae"&&(D.textContent=Ct),ze=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1gxz68g"&&(K.innerHTML=Wt),Fe=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-h01i34"&&(ee.innerHTML=Et),Pe=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1w4uowt"&&(te.textContent=It),Oe=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-lpgybe"&&(se.innerHTML=Ht),De=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-9f0m9n"&&(ae.textContent=_t),Ke=n(e),h(le.$$.fragment,e),et=n(e),ie=i(e,"P",{}),St(ie).forEach(s),this.h()},h(){ne(M,"name","hf:doc:metadata"),ne(M,"content",Xt),ne(T,"class","tip"),ne(w,"start","2"),ne(f,"start","3"),ne(y,"start","4")},m(e,t){Gt(document.head,M),a(e,he,t),a(e,oe,t),a(e,ue,t),u(j,e,t),a(e,re,t),u(J,e,t),a(e,de,t),a(e,T,t),a(e,me,t),a(e,b,t),a(e,Me,t),a(e,g,t),a(e,Te,t),u(U,e,t),a(e,we,t),a(e,k,t),a(e,fe,t),a(e,v,t),a(e,ye,t),u(B,e,t),a(e,je,t),a(e,C,t),a(e,Je,t),a(e,W,t),a(e,be,t),a(e,E,t),a(e,ge,t),a(e,I,t),a(e,Ue,t),u(H,e,t),a(e,ke,t),a(e,_,t),a(e,ve,t),a(e,S,t),a(e,Be,t),a(e,$,t),a(e,Ce,t),a(e,Z,t),a(e,We,t),a(e,R,t),a(e,Ee,t),u(V,e,t),a(e,Ie,t),a(e,w,t),a(e,He,t),u(x,e,t),a(e,_e,t),a(e,f,t),a(e,Se,t),a(e,L,t),a(e,$e,t),u(G,e,t),a(e,Ze,t),a(e,y,t),a(e,Re,t),u(Q,e,t),a(e,Ve,t),a(e,q,t),a(e,xe,t),a(e,Y,t),a(e,Le,t),a(e,X,t),a(e,Ge,t),a(e,A,t),a(e,Qe,t),a(e,N,t),a(e,qe,t),a(e,z,t),a(e,Ye,t),u(F,e,t),a(e,Xe,t),u(P,e,t),a(e,Ae,t),a(e,O,t),a(e,Ne,t),a(e,D,t),a(e,ze,t),a(e,K,t),a(e,Fe,t),a(e,ee,t),a(e,Pe,t),a(e,te,t),a(e,Oe,t),a(e,se,t),a(e,De,t),a(e,ae,t),a(e,Ke,t),u(le,e,t),a(e,et,t),a(e,ie,t),tt=!0},p:Zt,i(e){tt||(r(j.$$.fragment,e),r(J.$$.fragment,e),r(U.$$.fragment,e),r(B.$$.fragment,e),r(H.$$.fragment,e),r(V.$$.fragment,e),r(x.$$.fragment,e),r(G.$$.fragment,e),r(Q.$$.fragment,e),r(F.$$.fragment,e),r(P.$$.fragment,e),r(le.$$.fragment,e),tt=!0)},o(e){d(j.$$.fragment,e),d(J.$$.fragment,e),d(U.$$.fragment,e),d(B.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(x.$$.fragment,e),d(G.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(P.$$.fragment,e),d(le.$$.fragment,e),tt=!1},d(e){e&&(s(he),s(oe),s(ue),s(re),s(de),s(T),s(me),s(b),s(Me),s(g),s(Te),s(we),s(k),s(fe),s(v),s(ye),s(je),s(C),s(Je),s(W),s(be),s(E),s(ge),s(I),s(Ue),s(ke),s(_),s(ve),s(S),s(Be),s($),s(Ce),s(Z),s(We),s(R),s(Ee),s(Ie),s(w),s(He),s(_e),s(f),s(Se),s(L),s($e),s(Ze),s(y),s(Re),s(Ve),s(q),s(xe),s(Y),s(Le),s(X),s(Ge),s(A),s(Qe),s(N),s(qe),s(z),s(Ye),s(Xe),s(Ae),s(O),s(Ne),s(D),s(ze),s(K),s(Fe),s(ee),s(Pe),s(te),s(Oe),s(se),s(De),s(ae),s(Ke),s(et),s(ie)),s(M),m(j,e),m(J,e),m(U,e),m(B,e),m(H,e),m(V,e),m(x,e),m(G,e),m(Q,e),m(F,e),m(P,e),m(le,e)}}}const Xt='{"title":"Webhook guide: Setup an automatic system to re-train a model when a dataset changes","local":"webhook-guide-setup-an-automatic-system-to-re-train-a-model-when-a-dataset-changes","sections":[{"title":"Prerequisite: Upload your dataset to the Hub","local":"prerequisite-upload-your-dataset-to-the-hub","sections":[],"depth":2},{"title":"Create a Webhook to react to the dataset’s changes","local":"create-a-webhook-to-react-to-the-datasets-changes","sections":[],"depth":2},{"title":"Create a Space to react to your Webhook","local":"create-a-space-to-react-to-your-webhook","sections":[],"depth":2},{"title":"Configure your Webhook to send events to your Space","local":"configure-your-webhook-to-send-events-to-your-space","sections":[],"depth":2}],"depth":1}';function At(st){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Vt{constructor(M){super(),xt(this,M,At,Yt,$t,{})}}export{Dt as component};
