# Hugging Face Hub documentation

The Hugging Face Hub is a platform with over 2M models, 500k datasets, and 1M demo apps (Spaces), all open source and publicly available, in an online platform where people can easily collaborate and build ML together. The Hub works as a central place where anyone can explore, experiment, collaborate, and build technology with Machine Learning. Are you ready to join the path towards open source Machine Learning? 🤗

<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-3 md:mt-10">

<div class="group flex flex-col space-y-2 rounded-xl border border-purple-100 bg-linear-to-br from-purple-50 dark:bg-none px-6 py-4 transition-colors hover:shadow-sm dark:border-purple-700">
<div class="flex items-center py-0.5 text-lg font-semibold text-purple-600 dark:text-gray-400 mb-1">
<svg class="shrink-0 mr-1.5 text-purple-500" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" viewBox="0 0 32 32"><path fill="currentColor" d="M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37a1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56a1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.1 1.1 0 0 1-.39-.08M17.75 13l2-9H11.8L9.26 15h5.91l-1.59 10.28L23 13Z"/></svg> Subscriptions &  Plans</div>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./pro">PRO subscription</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./enterprise-hub">Team & Enterprise Plans</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./enterprise-sso">Single Sign-On (SSO)</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./audit-logs">Audit Logs</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./storage-regions">Storage Regions</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./enterprise-hub-datasets">Data Studio for Private datasets</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./security-resource-groups">Resource Groups</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./enterprise-hub-advanced-security">Advanced Security</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./enterprise-hub-tokens-management">Tokens Management</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./enterprise-hub-network-security">Network Security</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./rate-limits">Rate Limits</a>
</div>

<div class="group flex flex-col space-y-2 rounded-xl border border-orange-100 bg-linear-to-br from-orange-50 dark:bg-none px-6 py-4 transition-colors hover:shadow-sm dark:border-orange-700">
<div class="flex items-center py-0.5 text-lg font-semibold text-orange-600 dark:text-gray-400 mb-1">
 <svg class="shrink-0 mr-1.5 text-orange-500" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><path fill="currentColor" d="M2.6 10.59L8.38 4.8l1.69 1.7c-.24.85.15 1.78.93 2.23v5.54c-.6.34-1 .99-1 1.73a2 2 0 0 0 2 2a2 2 0 0 0 2-2c0-.74-.4-1.39-1-1.73V9.41l2.07 2.09c-.07.15-.07.32-.07.5a2 2 0 0 0 2 2a2 2 0 0 0 2-2a2 2 0 0 0-2-2c-.18 0-.35 0-.5.07L13.93 7.5a1.98 1.98 0 0 0-1.15-2.34c-.43-.16-.88-.2-1.28-.09L9.8 3.38l.79-.78c.78-.79 2.04-.79 2.82 0l7.99 7.99c.79.78.79 2.04 0 2.82l-7.99 7.99c-.78.79-2.04.79-2.82 0L2.6 13.41c-.79-.78-.79-2.04 0-2.82Z"></path></svg>Repositories</div>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./repositories">Introduction</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./repositories-getting-started">Getting Started</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./repositories-settings">Repository Settings</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./storage-limits">Storage Limits</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./xet/index">Storage Backend (Xet)</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./repositories-pull-requests-discussions">Pull requests and Discussions</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./notifications">Notifications</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./collections">Collections</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./webhooks">Webhooks</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./repositories-next-steps">Next Steps</a>
<a class="transform no-underline! transition-colors hover:translate-x-px hover:text-gray-700" href="./repositories-licenses">Licenses</a>
</div>

<div class="group flex flex-col space-y-2 rounded-xl border border-indigo-100 bg-linear-to-br from-indigo-50 dark:bg-none px-6 py-4 transition-colors hover:shadow-sm dark:border-indigo-700">
<div class="flex items-center py-0.5 text-lg font-semibold text-indigo-600 dark:text-gray-400 mb-1">
    <svg class="shrink-0 mr-1.5 text-indigo-500" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><path class="uim-quaternary" d="M20.23 7.24L12 12L3.77 7.24a1.98 1.98 0 0 1 .7-.71L11 2.76c.62-.35 1.38-.35 2 0l6.53 3.77c.29.173.531.418.7.71z" opacity=".25" fill="currentColor"></path><path class="uim-tertiary" d="M12 12v9.5a2.09 2.09 0 0 1-.91-.21L4.5 17.48a2.003 2.003 0 0 1-1-1.73v-7.5a2.06 2.06 0 0 1 .27-1.01L12 12z" opacity=".5" fill="currentColor"></path><path class="uim-primary" d="M20.5 8.25v7.5a2.003 2.003 0 0 1-1 1.73l-6.62 3.82c-.275.13-.576.198-.88.2V12l8.23-4.76c.175.308.268.656.27 1.01z" fill="currentColor"></path></svg> Models</div>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models">Introduction</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-the-hub">The Model Hub</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./model-cards">Model Cards</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-gated">Gated Models</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-uploading">Uploading Models</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-downloading">Downloading Models</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-libraries">Libraries</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-tasks">Tasks</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-widgets">Widgets</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-inference">Inference API</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./models-download-stats">Download Stats</a>
</div>

<div class="group flex flex-col space-y-2 rounded-xl border border-red-100 bg-linear-to-br from-red-50 dark:bg-none px-6 py-4 transition-colors hover:shadow-sm dark:border-red-700">
<div class="flex items-center py-0.5 text-lg font-semibold text-red-600 dark:text-gray-400 mb-1">
<svg class="shrink-0 mr-1.5 text-red-400" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 25 25"><ellipse cx="12.5" cy="5" fill="currentColor" fill-opacity="0.25" rx="7.5" ry="2"></ellipse><path d="M12.5 15C16.6421 15 20 14.1046 20 13V20C20 21.1046 16.6421 22 12.5 22C8.35786 22 5 21.1046 5 20V13C5 14.1046 8.35786 15 12.5 15Z" fill="currentColor" opacity="0.5"></path><path d="M12.5 7C16.6421 7 20 6.10457 20 5V11.5C20 12.6046 16.6421 13.5 12.5 13.5C8.35786 13.5 5 12.6046 5 11.5V5C5 6.10457 8.35786 7 12.5 7Z" fill="currentColor" opacity="0.5"></path><path d="M5.23628 12C5.08204 12.1598 5 12.8273 5 13C5 14.1046 8.35786 15 12.5 15C16.6421 15 20 14.1046 20 13C20 12.8273 19.918 12.1598 19.7637 12C18.9311 12.8626 15.9947 13.5 12.5 13.5C9.0053 13.5 6.06886 12.8626 5.23628 12Z" fill="currentColor"></path></svg> Datasets</div>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets">Introduction</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-overview">Datasets Overview</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-cards">Dataset Cards</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-gated">Gated Datasets</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-adding">Uploading Datasets</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-downloading">Downloading Datasets</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-libraries">Libraries</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-viewer">Dataset Viewer</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-download-stats">Download Stats</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./datasets-data-files-configuration">Data files Configuration</a>
</div>

<div class="group flex flex-col space-y-2 rounded-xl border border-blue-100 bg-linear-to-br from-blue-50 dark:bg-none px-6 py-4 transition-colors hover:shadow-sm dark:border-blue-700">
<div class="flex items-center py-0.5 text-lg font-semibold text-blue-600 dark:text-gray-400 mb-1">
<svg class="shrink-0 mr-1.5 text-blue-500" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" viewBox="0 0 25 25"><path opacity=".5" d="M6.016 14.674v4.31h4.31v-4.31h-4.31ZM14.674 14.674v4.31h4.31v-4.31h-4.31ZM6.016 6.016v4.31h4.31v-4.31h-4.31Z" fill="currentColor"></path><path opacity=".75" fill-rule="evenodd" clip-rule="evenodd" d="M3 4.914C3 3.857 3.857 3 4.914 3h6.514c.884 0 1.628.6 1.848 1.414a5.171 5.171 0 0 1 7.31 7.31c.815.22 1.414.964 1.414 1.848v6.514A1.914 1.914 0 0 1 20.086 22H4.914A1.914 1.914 0 0 1 3 20.086V4.914Zm3.016 1.102v4.31h4.31v-4.31h-4.31Zm0 12.968v-4.31h4.31v4.31h-4.31Zm8.658 0v-4.31h4.31v4.31h-4.31Zm0-10.813a2.155 2.155 0 1 1 4.31 0 2.155 2.155 0 0 1-4.31 0Z" fill="currentColor"></path><path opacity=".25" d="M16.829 6.016a2.155 2.155 0 1 0 0 4.31 2.155 2.155 0 0 0 0-4.31Z" fill="currentColor"></path></svg> Spaces</div>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces">Introduction</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-overview">Spaces Overview</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-sdks-gradio">Gradio Spaces</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-sdks-static">Static HTML Spaces</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-sdks-docker">Docker Spaces</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-embed">Embed your Space</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-run-with-docker">Run with Docker</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-config-reference">Reference</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-changelog">Changelog</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-advanced">Advanced Topics</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./spaces-oauth">Sign in with HF</a>
</div>

<div class="group flex flex-col space-y-2 rounded-xl border border-green-100 bg-linear-to-br from-green-50 dark:bg-none px-6 py-4 transition-colors hover:shadow-sm dark:border-green-700">
<div class="flex items-center py-0.5 text-lg font-semibold text-green-600 dark:text-gray-400 mb-1">
<svg class="shrink-0 mr-1.5 text-green-500" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" stroke="currentColor" d="M8.892 21.854a6.25 6.25 0 0 1-4.42-10.67l7.955-7.955a4.5 4.5 0 0 1 6.364 6.364l-6.895 6.894a2.816 2.816 0 0 1-3.89 0a2.75 2.75 0 0 1 .002-3.888l5.126-5.127a1 1 0 1 1 1.414 1.414l-5.126 5.127a.75.75 0 0 0 0 1.06a.768.768 0 0 0 1.06 0l6.895-6.894a2.503 2.503 0 0 0 0-3.535a2.56 2.56 0 0 0-3.536 0l-7.955 7.955a4.25 4.25 0 1 0 6.01 6.01l6.188-6.187a1 1 0 1 1 1.414 1.414l-6.187 6.186a6.206 6.206 0 0 1-4.42 1.832z"></path></svg> Other</div>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./organizations">Organizations</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./billing">Billing</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./security">Security</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./moderation">Moderation</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./paper-pages">Paper Pages</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./search">Search</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./doi">Digital Object Identifier (DOI)</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./api">Hub API Endpoints</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="./oauth">Sign in with HF</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="https://huggingface.co/code-of-conduct">Contributor Code of Conduct</a>
<a class="no-underline! hover:opacity-60 transform transition-colors hover:translate-x-px" href="https://huggingface.co/content-guidelines">Content Guidelines</a>
</div>

</div>

## What's the Hugging Face Hub?

We are helping the community work together towards the goal of advancing Machine Learning 🔥.

The Hugging Face Hub is a platform with over 2M models, 500k datasets, and 1M demos in which people can easily collaborate in their ML workflows. The Hub works as a central place where anyone can share, explore, discover, and experiment with open-source Machine Learning.

No single company, including the Tech Titans, will be able to “solve AI” by themselves – the only way we'll achieve this is by sharing knowledge and resources in a community-centric approach. We are building the largest open-source collection of models, datasets, and demos on the Hugging Face Hub to democratize and advance ML for everyone 🚀.

We encourage you to read the [Code of Conduct](https://huggingface.co/code-of-conduct) and the [Content Guidelines](https://huggingface.co/content-guidelines) to familiarize yourself with the values that we expect our community members to uphold 🤗.

## What can you find on the Hub?

The Hugging Face Hub hosts Git-based repositories, which are version-controlled buckets that can contain all your files. 💾

On it, you'll be able to upload and discover...

- Models: _hosting the latest state-of-the-art models for LLM, text, vision, and audio tasks_
- Datasets: _featuring a wide variety of data for different domains and modalities_
- Spaces: _interactive apps for demonstrating ML models directly in your browser_

The Hub offers **versioning, commit history, diffs, branches, and over a dozen library integrations**! 
All repositories build on [Xet](./xet/index), a new technology to efficiently store Large Files inside Git, intelligently splitting files into unique chunks and accelerating uploads and downloads.

You can learn more about the features that all repositories share in the [**Repositories documentation**](./repositories).

## Models

You can discover and use dozens of thousands of open-source ML models shared by the community. To promote responsible model usage and development, model repos are equipped with [Model Cards](./model-cards) to inform users of each model's limitations and biases. Additional [metadata](./model-cards#model-card-metadata) about info such as their tasks, languages, and evaluation results can be included, with training metrics charts even added if the repository contains [TensorBoard traces](./tensorboard). It's also easy to add an [**inference widget**](./models-widgets) to your model, allowing anyone to play with the model directly in the browser! For programmatic access, a serverless API is provided by [**Inference Providers**](./models-inference).

To upload models to the Hub, or download models and integrate them into your work, explore the [**Models documentation**](./models). You can also choose from [**over a dozen libraries**](./models-libraries) such as 🤗 Transformers, Asteroid, and ESPnet that support the Hub.

## Datasets

The Hub is home to over 500k public datasets in more than 8k languages that can be used for a broad range of tasks across NLP, Computer Vision, and Audio. The Hub makes it simple to find, download, and upload datasets. Datasets are accompanied by extensive documentation in the form of [**Dataset Cards**](./datasets-cards) and [**Data Studio**](./datasets-viewer) to let you explore the data directly in your browser. While many datasets are public, [**organizations**](./organizations) and individuals can create private datasets to comply with licensing or privacy issues. You can learn more about [**Datasets here on the Hugging Face Hub documentation**](./datasets-overview).

The [🤗 `datasets`](https://huggingface.co/docs/datasets/index) library allows you to programmatically interact with the datasets, so you can easily use datasets from the Hub in your projects. With a single line of code, you can access the datasets; even if they are so large they don't fit in your computer, you can use streaming to efficiently access the data.

## Spaces

[Spaces](https://huggingface.co/spaces) is a simple way to host ML demo apps on the Hub. They allow you to build your ML portfolio, showcase your projects at conferences or to stakeholders, and work collaboratively with other people in the ML ecosystem.

We currently support two awesome Python SDKs (**[Gradio](https://gradio.app/)** and **[Streamlit](./spaces-sdks-streamlit)**) that let you build cool apps in a matter of minutes. Users can also create static Spaces, which are simple HTML/CSS/JavaScript pages, or deploy any Docker-based application.

After you've explored a few Spaces (take a look at our [Space of the Week!](https://huggingface.co/spaces)), dive into the [**Spaces documentation**](./spaces-overview) to learn all about how you can create your own Space. You'll also be able to upgrade your Space to run on a GPU or other accelerated hardware. ⚡️

## Organizations

Companies, universities and non-profits are an essential part of the Hugging Face community! The Hub offers [**Organizations**](./organizations), which can be used to group accounts and manage datasets, models, and Spaces. Educators can also create collaborative organizations for students using [Hugging Face for Classrooms](https://huggingface.co/classrooms). An organization's repositories will be featured on the organization’s page and every member of the organization will have the ability to contribute to the repository. In addition to conveniently grouping all of an organization's work, the Hub allows admins to set roles to [**control access to repositories**](./organizations-security), and manage their organization's [payment method and billing info](https://huggingface.co/pricing). Machine Learning is more fun when collaborating! 🔥

[Explore existing organizations](https://huggingface.co/organizations), create a new organization [here](https://huggingface.co/organizations/new), and then visit the [**Organizations documentation**](./organizations) to learn more.

## Security

The Hugging Face Hub supports security and access control features to give you the peace of mind that your code, models, and data are safe. Visit the [**Security**](./security) section in these docs to learn about:

- User Access Tokens
- Access Control for Organizations
- Signing commits with GPG
- Malware scanning

<img width="150" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-soc-1.jpg">


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/index.md" />