# Models

The Hugging Face Hub hosts many models for a [variety of machine learning tasks](https://huggingface.co/tasks). Models are stored in repositories, so they benefit from [all the features](./repositories) possessed by every repo on the Hugging Face Hub. Additionally, model repos have attributes that make exploring and using models as easy as possible. These docs will take you through everything you'll need to know to find models on the Hub, upload your models, and make the most of everything the Model Hub offers!

## Contents

- [The Model Hub](./models-the-hub)
- [Model Cards](./model-cards)
  - [CO<sub>2</sub> emissions](./model-cards-co2)
  - [Gated models](./models-gated)
- [Libraries](./models-libraries)
- [Uploading Models](./models-uploading)
- [Downloading Models](./models-downloading)
- [Widgets](./models-widgets)
  - [Widget Examples](./models-widgets-examples)
- [Inference API](./models-inference)
- [Frequently Asked Questions](./models-faq)
- [Advanced Topics](./models-advanced)
  - [Integrating libraries with the Hub](./models-adding-libraries)
  - [Tasks](./models-tasks)


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/models.md" />