# Access control in organizations

> [!TIP]
> You can set up [Single Sign-On (SSO)](./security-sso) to be able to map access control rules from your organization's Identity Provider.

> [!TIP]
> Advanced and more fine-grained access control can be achieved with [Resource Groups](./security-resource-groups).
>
> The Resource Group feature is part of the <a href="https://huggingface.co/enterprise">Team & Enterprise</a> plans.

Members of organizations can have four different roles: `read`, `contributor`, `write`, or `admin`:

- `read`: read-only access to the Organization's repos and metadata/settings (eg, the Organization's profile, members list, API token, etc).

- `contributor`: additional write rights to the subset of the Organization's repos that were created by the user. I.e., users can create repos and _then_ modify only those repos. This is similar to the `write` role, but scoped to repos _created_ by the user.

- `write`: write rights to all the Organization's repos. Users can create, delete, or rename any repo in the Organization namespace. A user can also edit and delete files from the browser editor and push content with `git`.

- `admin`: in addition to write rights on repos, admin members can update the Organization's profile, refresh the Organization's API token, and manage Organization members.

As an organization `admin`, go to the **Members** section of the org settings to manage roles for users.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/org-members-page.png"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/org-members-page-dark.png"/>
</div>

## Viewing members' email address

> [!WARNING]
> This feature is part of the <a href="https://huggingface.co/enterprise">Team & Enterprise</a> plans.

You may be able to view the email addresses of members of your organization. The visibility of the email addresses depends on the organization's SSO configuration, or verified organization status.

- If you [verify a domain for your organization](./organizations-managing#organization-domain-name), you can view members' email addresses for the verified domain.
- If SSO is configured for your organization, you can view the email address for each of your organization members by setting `Matching email domains` in the SSO configuration

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/org-members-page-emails.png"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/org-members-page-emails-dark.png"/>
</div>

## Managing Access Tokens with access to my organization

See [Tokens Management](./enterprise-hub-tokens-management)


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/organizations-security.md" />