# Organizations

The Hugging Face Hub offers **Organizations**, which can be used to group accounts and manage datasets, models, and Spaces. The Hub also allows admins to set user roles to [**control access to repositories**](./organizations-security) and manage their organization's [payment method and billing info](https://huggingface.co/pricing).

If an organization needs to track user access to a dataset or a model due to licensing or privacy issues, an organization can enable [user access requests](./datasets-gated).

Note: Use the context switcher in your org settings to quickly switch between your account and your orgs.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/context-switcher.png"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/context-switcher-dark.png"/>
</div>

## Contents

- [Managing Organizations](./organizations-managing)
- [Organization Cards](./organizations-cards)
- [Access Control in Organizations](./organizations-security)

## Next: Power up your organization

- [Team & Enterprise Plans](./enterprise-hub)


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/organizations.md" />