# Malware Scanning

We run every file of your repositories through a [malware scanner](https://www.clamav.net/).

Scanning is triggered at each commit or when you visit a repository page.

Here is an [example view](https://huggingface.co/mcpotato/42-eicar-street/tree/main) of an infected file:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/eicar-hub-file-view.png"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/eicar-hub-file-view-dark.png"/>
</div>

> [!TIP]
> If your file has neither an ok nor infected badge, it could mean that it is either currently being scanned, waiting to be scanned, or that there was an error during the scan. It can take up to a few minutes to be scanned.

If at least one file has a been scanned as unsafe, a message will warn the users:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/eicar-hub-model.png"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/eicar-hub-model-dark.png"/>
</div>
<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/eicar-hub-tree-view.png"/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/eicar-hub-tree-view-dark.png"/>
</div>

> [!TIP]
> As the repository owner, we advise you to remove the suspicious file. The repository will appear back as safe.


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/security-malware.md" />