# Docker Spaces Examples

We gathered some example demos in the [Spaces Examples](https://huggingface.co/SpacesExamples) organization. Please check them out!

* Dummy FastAPI app: https://huggingface.co/spaces/DockerTemplates/fastapi_dummy 
* FastAPI app serving a static site and using `transformers`: https://huggingface.co/spaces/DockerTemplates/fastapi_t5
* Phoenix app for https://huggingface.co/spaces/DockerTemplates/single_file_phx_bumblebee_ml
* HTTP endpoint in Go with query parameters https://huggingface.co/spaces/XciD/test-docker-go?q=Adrien
* Shiny app written in Python https://huggingface.co/spaces/elonmuskceo/shiny-orbit-simulation
* Genie.jl app in Julia https://huggingface.co/spaces/nooji/GenieOnHuggingFaceSpaces
* Argilla app for data labelling and curation: https://huggingface.co/spaces/argilla/live-demo and [write-up about hosting Argilla on Spaces](./spaces-sdks-docker-argilla) by [@dvilasuero](https://huggingface.co/dvilasuero) 🎉
* JupyterLab and VSCode: https://huggingface.co/spaces/DockerTemplates/docker-examples by [@camenduru](https://twitter.com/camenduru) and [@nateraw](https://hf.co/nateraw).
* Zeno app for interactive model evaluation: https://huggingface.co/spaces/zeno-ml/diffusiondb and [instructions for setup](https://zenoml.com/docs/deployment#hugging-face-spaces)
* Gradio App: https://huggingface.co/spaces/sayakpaul/demo-docker-gradio


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-sdks-docker-examples.md" />