# Spaces

[Hugging Face Spaces](https://huggingface.co/spaces) offer a simple way to host ML demo apps directly on your profile or your organization's  profile. This allows you to create your ML portfolio, showcase your projects at conferences or to stakeholders, and work collaboratively with other people in the ML ecosystem.

We have built-in support for an awesome SDK that let you build cool apps in Python in a matter of minutes: **[Gradio](https://gradio.app/)**, but you can also unlock the whole power of Docker and host an arbitrary Dockerfile. Finally, you can create static Spaces using JavaScript and HTML.

You'll also be able to upgrade your Space to run [on a GPU or other accelerated hardware](./spaces-gpus). ⚡️

## Contents

- [Spaces Overview](./spaces-overview)
  - [Handling Spaces Dependencies](./spaces-dependencies)
  - [Spaces Settings](./spaces-settings)
  - [Using OpenCV in Spaces](./spaces-using-opencv)
  - [Using Spaces for Organization Cards](./spaces-organization-cards)
  - [More ways to create Spaces](./spaces-more-ways-to-create)
  - [Managing Spaces with Github Actions](./spaces-github-actions)
  - [How to Add a Space to ArXiv](./spaces-add-to-arxiv)
- [Spaces Dev Mode](./spaces-dev-mode)
- [Spaces GPU Upgrades](./spaces-gpus)
- [Spaces Persistent Storage](./spaces-storage)
- [Gradio Spaces](./spaces-sdks-gradio)
- [Docker Spaces](./spaces-sdks-docker)
- [Static HTML Spaces](./spaces-sdks-static)
- [Custom Python Spaces](./spaces-sdks-python)
- [Embed your Space](./spaces-embed)
- [Run your Space with Docker](./spaces-run-with-docker)
- [Reference](./spaces-config-reference)
- [Changelog](./spaces-changelog)

## Contact

Feel free to ask questions on the [forum](https://discuss.huggingface.co/c/spaces/24) if you need help with making a Space, or if you run into any other issues on the Hub.

If you're interested in infra challenges, custom demos, advanced GPUs, or something else, please reach out to us by sending an email to **website at huggingface.co**.

You can also tag us [on Twitter](https://twitter.com/huggingface)! 🤗


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces.md" />