import{s as wt,n as Mt,o as jt}from"../chunks/scheduler.eb244325.js";import{S as It,i as ft,e as p,s as l,c as o,h as dt,a as i,d as n,b as e,f as yt,g as u,j as m,k as Ns,l as Ut,m as a,n as c,t as r,o as J,p as T}from"../chunks/index.3fe63ad3.js";import{C as $t}from"../chunks/CopyLLMTxtMenu.3c6aa112.js";import{C as w}from"../chunks/CodeBlock.85b10842.js";import{H as h,E as Ct}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.bf4dbd10.js";function gt(Ds){let y,ps,ls,is,j,os,I,us,f,Fs="This guide explains how to use the <code>gym_hil</code> simulation environments as an alternative to real robots when working with the LeRobot framework for Human-In-the-Loop (HIL) reinforcement learning.",cs,d,Os="<code>gym_hil</code> is a package that provides Gymnasium-compatible simulation environments specifically designed for Human-In-the-Loop reinforcement learning. These environments allow you to:",rs,U,Ks="<li><p>Train policies in simulation to test the RL stack before training on real robots</p></li> <li><p>Collect demonstrations in sim using external devices like gamepads or keyboards</p></li> <li><p>Perform human interventions during policy learning</p></li>",Js,$,st="Currently, the main environment is a Franka Panda robot simulation based on MuJoCo, with tasks like picking up a cube.",Ts,C,ms,g,tt="First, install the <code>gym_hil</code> package within the LeRobot environment:",hs,b,ys,v,ws,B,nt="<li>A gamepad or keyboard to control the robot</li> <li>A Nvidia GPU</li>",Ms,q,js,_,at='To use <code>gym_hil</code> with LeRobot, you need to create a configuration file. An example is provided <a href="https://huggingface.co/datasets/lerobot/config_examples/resolve/main/rl/gym_hil/env_config.json" rel="nofollow">here</a>. Key configuration sections include:',Is,L,fs,k,ds,x,lt="Available tasks:",Us,H,et="<li><code>PandaPickCubeBase-v0</code>: Basic environment</li> <li><code>PandaPickCubeGamepad-v0</code>: With gamepad control</li> <li><code>PandaPickCubeKeyboard-v0</code>: With keyboard control</li>",$s,G,Cs,Q,gs,W,pt="Important parameters:",bs,X,it="<li><code>gripper.gripper_penalty</code>: Penalty for excessive gripper movement</li> <li><code>gripper.use_gripper</code>: Whether to enable gripper control</li> <li><code>inverse_kinematics.end_effector_step_sizes</code>: Size of the steps in the x,y,z axes of the end-effector</li> <li><code>control_mode</code>: Set to <code>&quot;gamepad&quot;</code> to use a gamepad controller</li>",vs,R,Bs,Z,qs,S,ot="To run the environment, set mode to null:",_s,E,Ls,A,ks,Y,ut="To collect a dataset, set the mode to <code>record</code> whilst defining the repo_id and number of episodes to record:",xs,V,Hs,z,Gs,P,Qs,N,ct='To train a policy, checkout the configuration example available <a href="https://huggingface.co/datasets/lerobot/config_examples/resolve/main/rl/gym_hil/train_config.json" rel="nofollow">here</a> and run the actor and learner servers:',Ws,D,Xs,F,rt="In a different terminal, run the learner server:",Rs,O,Zs,K,Jt="The simulation environment provides a safe and repeatable way to develop and test your Human-In-the-Loop reinforcement learning components before deploying to real robots.",Ss,ss,Tt="Congrats 🎉, you have finished this tutorial!",Es,M,mt='<p>If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.</p>',As,ts,ht="Paper citation:",Ys,ns,Vs,as,zs,es,Ps;return j=new $t({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new h({props:{title:"Train RL in Simulation",local:"train-rl-in-simulation",headingTag:"h1"}}),C=new h({props:{title:"Installation",local:"installation",headingTag:"h2"}}),b=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),v=new h({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),q=new h({props:{title:"Configuration",local:"configuration",headingTag:"h2"}}),L=new h({props:{title:"Environment Type and Task",local:"environment-type-and-task",headingTag:"h3"}}),k=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJneW1faGlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMlBhbmRhUGlja0N1YmVHYW1lcGFkLXYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnBzJTIyJTNBJTIwMTAlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_hil&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;PandaPickCubeGamepad-v0&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),G=new h({props:{title:"Processor Configuration",local:"processor-configuration",headingTag:"h3"}}),Q=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udHJvbF9tb2RlJTIyJTNBJTIwJTIyZ2FtZXBhZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmdyaXBwZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJncmlwcGVyX3BlbmFsdHklMjIlM0ElMjAtMC4wMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2V0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udHJvbF90aW1lX3MlMjIlM0ElMjAxNS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZml4ZWRfcmVzZXRfam9pbnRfcG9zaXRpb25zJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC4wJTJDJTIwMC4xOTUlMkMlMjAwLjAlMkMlMjAtMi40MyUyQyUyMDAuMCUyQyUyMDIuNjIlMkMlMjAwLjc4NSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmludmVyc2Vfa2luZW1hdGljcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeCUyMiUzQSUyMDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeSUyMiUzQSUyMDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDI1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;gripper_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">-0.02</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;control_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;fixed_reset_joint_positions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
          <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.195</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-2.43</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span> <span class="hljs-number">2.62</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.785</span>
        <span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;inverse_kinematics&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;end_effector_step_sizes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;x&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.025</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;y&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.025</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;z&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.025</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),R=new h({props:{title:"Running with HIL RL of LeRobot",local:"running-with-hil-rl-of-lerobot",headingTag:"h2"}}),Z=new h({props:{title:"Basic Usage",local:"basic-usage",headingTag:"h3"}}),E=new w({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBwYXRoJTJGdG8lMkZneW1faGlsX2Vudi5qc29u",highlighted:"python -m lerobot.rl.gym_manipulator --config_path path/to/gym_hil_env.json",wrap:!1}}),A=new h({props:{title:"Recording a Dataset",local:"recording-a-dataset",headingTag:"h3"}}),V=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJneW1faGlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMlBhbmRhUGlja0N1YmVHYW1lcGFkLXYwJTIyJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJ1c2VybmFtZSUyRnNpbV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycm9vdCUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTIycGlja19jdWJlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2VwaXNvZGVzX3RvX3JlY29yZCUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVwbGF5X2VwaXNvZGUlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIwJTIwJTIycHVzaF90b19odWIlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIybW9kZSUyMiUzQSUyMCUyMnJlY29yZCUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_hil&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;PandaPickCubeGamepad-v0&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/sim_dataset&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_cube&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes_to_record&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;replay_episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new w({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBwYXRoJTJGdG8lMkZneW1faGlsX2Vudi5qc29u",highlighted:"python -m lerobot.rl.gym_manipulator --config_path path/to/gym_hil_env.json",wrap:!1}}),P=new h({props:{title:"Training a Policy",local:"training-a-policy",headingTag:"h3"}}),D=new w({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmFjdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRnRyYWluX2d5bV9oaWxfZW52Lmpzb24=",highlighted:"python -m lerobot.rl.actor --config_path path/to/train_gym_hil_env.json",wrap:!1}}),O=new w({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmxlYXJuZXIlMjAtLWNvbmZpZ19wYXRoJTIwcGF0aCUyRnRvJTJGdHJhaW5fZ3ltX2hpbF9lbnYuanNvbg==",highlighted:"python -m lerobot.rl.learner --config_path path/to/train_gym_hil_env.json",wrap:!1}}),ns=new w({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),as=new Ct({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl_sim.mdx"}}),{c(){y=p("meta"),ps=l(),ls=p("p"),is=l(),o(j.$$.fragment),os=l(),o(I.$$.fragment),us=l(),f=p("p"),f.innerHTML=Fs,cs=l(),d=p("p"),d.innerHTML=Os,rs=l(),U=p("ul"),U.innerHTML=Ks,Js=l(),$=p("p"),$.textContent=st,Ts=l(),o(C.$$.fragment),ms=l(),g=p("p"),g.innerHTML=tt,hs=l(),o(b.$$.fragment),ys=l(),o(v.$$.fragment),ws=l(),B=p("ul"),B.innerHTML=nt,Ms=l(),o(q.$$.fragment),js=l(),_=p("p"),_.innerHTML=at,Is=l(),o(L.$$.fragment),fs=l(),o(k.$$.fragment),ds=l(),x=p("p"),x.textContent=lt,Us=l(),H=p("ul"),H.innerHTML=et,$s=l(),o(G.$$.fragment),Cs=l(),o(Q.$$.fragment),gs=l(),W=p("p"),W.textContent=pt,bs=l(),X=p("ul"),X.innerHTML=it,vs=l(),o(R.$$.fragment),Bs=l(),o(Z.$$.fragment),qs=l(),S=p("p"),S.textContent=ot,_s=l(),o(E.$$.fragment),Ls=l(),o(A.$$.fragment),ks=l(),Y=p("p"),Y.innerHTML=ut,xs=l(),o(V.$$.fragment),Hs=l(),o(z.$$.fragment),Gs=l(),o(P.$$.fragment),Qs=l(),N=p("p"),N.innerHTML=ct,Ws=l(),o(D.$$.fragment),Xs=l(),F=p("p"),F.textContent=rt,Rs=l(),o(O.$$.fragment),Zs=l(),K=p("p"),K.textContent=Jt,Ss=l(),ss=p("p"),ss.textContent=Tt,Es=l(),M=p("blockquote"),M.innerHTML=mt,As=l(),ts=p("p"),ts.textContent=ht,Ys=l(),o(ns.$$.fragment),Vs=l(),o(as.$$.fragment),zs=l(),es=p("p"),this.h()},l(s){const t=dt("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(n),ps=e(s),ls=i(s,"P",{}),yt(ls).forEach(n),is=e(s),u(j.$$.fragment,s),os=e(s),u(I.$$.fragment,s),us=e(s),f=i(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-399pbz"&&(f.innerHTML=Fs),cs=e(s),d=i(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-z2t1g3"&&(d.innerHTML=Os),rs=e(s),U=i(s,"UL",{"data-svelte-h":!0}),m(U)!=="svelte-19bnmv0"&&(U.innerHTML=Ks),Js=e(s),$=i(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-1n86ema"&&($.textContent=st),Ts=e(s),u(C.$$.fragment,s),ms=e(s),g=i(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-19ylgus"&&(g.innerHTML=tt),hs=e(s),u(b.$$.fragment,s),ys=e(s),u(v.$$.fragment,s),ws=e(s),B=i(s,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-37t4vf"&&(B.innerHTML=nt),Ms=e(s),u(q.$$.fragment,s),js=e(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1fynuu1"&&(_.innerHTML=at),Is=e(s),u(L.$$.fragment,s),fs=e(s),u(k.$$.fragment,s),ds=e(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1gmfvxn"&&(x.textContent=lt),Us=e(s),H=i(s,"UL",{"data-svelte-h":!0}),m(H)!=="svelte-tdrsar"&&(H.innerHTML=et),$s=e(s),u(G.$$.fragment,s),Cs=e(s),u(Q.$$.fragment,s),gs=e(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1i1dja0"&&(W.textContent=pt),bs=e(s),X=i(s,"UL",{"data-svelte-h":!0}),m(X)!=="svelte-mizygd"&&(X.innerHTML=it),vs=e(s),u(R.$$.fragment,s),Bs=e(s),u(Z.$$.fragment,s),qs=e(s),S=i(s,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1pcnjlb"&&(S.textContent=ot),_s=e(s),u(E.$$.fragment,s),Ls=e(s),u(A.$$.fragment,s),ks=e(s),Y=i(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-18bmi0"&&(Y.innerHTML=ut),xs=e(s),u(V.$$.fragment,s),Hs=e(s),u(z.$$.fragment,s),Gs=e(s),u(P.$$.fragment,s),Qs=e(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-11r10n7"&&(N.innerHTML=ct),Ws=e(s),u(D.$$.fragment,s),Xs=e(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-xj4a2z"&&(F.textContent=rt),Rs=e(s),u(O.$$.fragment,s),Zs=e(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-rhp9uh"&&(K.textContent=Jt),Ss=e(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-kg8fpw"&&(ss.textContent=Tt),Es=e(s),M=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(M)!=="svelte-so5vtc"&&(M.innerHTML=mt),As=e(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-k8021v"&&(ts.textContent=ht),Ys=e(s),u(ns.$$.fragment,s),Vs=e(s),u(as.$$.fragment,s),zs=e(s),es=i(s,"P",{}),yt(es).forEach(n),this.h()},h(){Ns(y,"name","hf:doc:metadata"),Ns(y,"content",bt),Ns(M,"class","tip")},m(s,t){Ut(document.head,y),a(s,ps,t),a(s,ls,t),a(s,is,t),c(j,s,t),a(s,os,t),c(I,s,t),a(s,us,t),a(s,f,t),a(s,cs,t),a(s,d,t),a(s,rs,t),a(s,U,t),a(s,Js,t),a(s,$,t),a(s,Ts,t),c(C,s,t),a(s,ms,t),a(s,g,t),a(s,hs,t),c(b,s,t),a(s,ys,t),c(v,s,t),a(s,ws,t),a(s,B,t),a(s,Ms,t),c(q,s,t),a(s,js,t),a(s,_,t),a(s,Is,t),c(L,s,t),a(s,fs,t),c(k,s,t),a(s,ds,t),a(s,x,t),a(s,Us,t),a(s,H,t),a(s,$s,t),c(G,s,t),a(s,Cs,t),c(Q,s,t),a(s,gs,t),a(s,W,t),a(s,bs,t),a(s,X,t),a(s,vs,t),c(R,s,t),a(s,Bs,t),c(Z,s,t),a(s,qs,t),a(s,S,t),a(s,_s,t),c(E,s,t),a(s,Ls,t),c(A,s,t),a(s,ks,t),a(s,Y,t),a(s,xs,t),c(V,s,t),a(s,Hs,t),c(z,s,t),a(s,Gs,t),c(P,s,t),a(s,Qs,t),a(s,N,t),a(s,Ws,t),c(D,s,t),a(s,Xs,t),a(s,F,t),a(s,Rs,t),c(O,s,t),a(s,Zs,t),a(s,K,t),a(s,Ss,t),a(s,ss,t),a(s,Es,t),a(s,M,t),a(s,As,t),a(s,ts,t),a(s,Ys,t),c(ns,s,t),a(s,Vs,t),c(as,s,t),a(s,zs,t),a(s,es,t),Ps=!0},p:Mt,i(s){Ps||(r(j.$$.fragment,s),r(I.$$.fragment,s),r(C.$$.fragment,s),r(b.$$.fragment,s),r(v.$$.fragment,s),r(q.$$.fragment,s),r(L.$$.fragment,s),r(k.$$.fragment,s),r(G.$$.fragment,s),r(Q.$$.fragment,s),r(R.$$.fragment,s),r(Z.$$.fragment,s),r(E.$$.fragment,s),r(A.$$.fragment,s),r(V.$$.fragment,s),r(z.$$.fragment,s),r(P.$$.fragment,s),r(D.$$.fragment,s),r(O.$$.fragment,s),r(ns.$$.fragment,s),r(as.$$.fragment,s),Ps=!0)},o(s){J(j.$$.fragment,s),J(I.$$.fragment,s),J(C.$$.fragment,s),J(b.$$.fragment,s),J(v.$$.fragment,s),J(q.$$.fragment,s),J(L.$$.fragment,s),J(k.$$.fragment,s),J(G.$$.fragment,s),J(Q.$$.fragment,s),J(R.$$.fragment,s),J(Z.$$.fragment,s),J(E.$$.fragment,s),J(A.$$.fragment,s),J(V.$$.fragment,s),J(z.$$.fragment,s),J(P.$$.fragment,s),J(D.$$.fragment,s),J(O.$$.fragment,s),J(ns.$$.fragment,s),J(as.$$.fragment,s),Ps=!1},d(s){s&&(n(ps),n(ls),n(is),n(os),n(us),n(f),n(cs),n(d),n(rs),n(U),n(Js),n($),n(Ts),n(ms),n(g),n(hs),n(ys),n(ws),n(B),n(Ms),n(js),n(_),n(Is),n(fs),n(ds),n(x),n(Us),n(H),n($s),n(Cs),n(gs),n(W),n(bs),n(X),n(vs),n(Bs),n(qs),n(S),n(_s),n(Ls),n(ks),n(Y),n(xs),n(Hs),n(Gs),n(Qs),n(N),n(Ws),n(Xs),n(F),n(Rs),n(Zs),n(K),n(Ss),n(ss),n(Es),n(M),n(As),n(ts),n(Ys),n(Vs),n(zs),n(es)),n(y),T(j,s),T(I,s),T(C,s),T(b,s),T(v,s),T(q,s),T(L,s),T(k,s),T(G,s),T(Q,s),T(R,s),T(Z,s),T(E,s),T(A,s),T(V,s),T(z,s),T(P,s),T(D,s),T(O,s),T(ns,s),T(as,s)}}}const bt='{"title":"Train RL in Simulation","local":"train-rl-in-simulation","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"Configuration","local":"configuration","sections":[{"title":"Environment Type and Task","local":"environment-type-and-task","sections":[],"depth":3},{"title":"Processor Configuration","local":"processor-configuration","sections":[],"depth":3}],"depth":2},{"title":"Running with HIL RL of LeRobot","local":"running-with-hil-rl-of-lerobot","sections":[{"title":"Basic Usage","local":"basic-usage","sections":[],"depth":3},{"title":"Recording a Dataset","local":"recording-a-dataset","sections":[],"depth":3},{"title":"Training a Policy","local":"training-a-policy","sections":[],"depth":3}],"depth":2}],"depth":1}';function vt(Ds){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends It{constructor(y){super(),ft(this,y,vt,gt,wt,{})}}export{xt as component};
